/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import java.util.Random;

public class MathTools {
    public static final int[] INTERPOLATION_OUT_QUINTIC = new int[]{5, -10, 10, -5, 1};
    public static final int[] INTERPOLATION_INOUT_QUINTIC = new int[]{0, 0, 10, -15, 6};
    public static final Random s_random = new Random(System.currentTimeMillis());
    private static int s_randomIntValue;
    private static int s_randomIntValuePosition;
    private static int[] s_cosineLookupTable;
    public static final int FP_RES = 8;
    public static final int FP_ROUND_TO_NEAREST = 128;
    private static final int FP_SIGN_BIT = Integer.MIN_VALUE;
    private static final long FPL_SIGN_BIT = Long.MIN_VALUE;
    private static final int FP_FRAC_MASK = 255;
    private static final long[] ARC_TANGENT_TABLE;

    public static int getRandomInt(int n, int n2) {
        return Math.abs(s_random.nextInt() % (n2 - n + 1)) + n;
    }

    public static boolean getNextRandomBoolean() {
        if (s_randomIntValuePosition <= 0) {
            s_randomIntValuePosition = 32;
            s_randomIntValue = s_random.nextInt();
        }
        --s_randomIntValuePosition;
        return ((s_randomIntValue >>= 1) & 1) == 1;
    }

    public static int getCosine(int n) {
        int n2 = n % 90;
        int n3 = n / 90;
        switch (n3) {
            case 0: {
                return s_cosineLookupTable[n2];
            }
            case 1: {
                return -s_cosineLookupTable[90 - n2];
            }
            case 2: {
                return -s_cosineLookupTable[n2];
            }
            case 3: {
                return s_cosineLookupTable[90 - n2];
            }
        }
        return 0;
    }

    public static int getSine(int n) {
        int n2 = n % 90;
        int n3 = n / 90;
        switch (n3) {
            case 0: {
                return s_cosineLookupTable[90 - n2];
            }
            case 1: {
                return s_cosineLookupTable[n2];
            }
            case 2: {
                return -s_cosineLookupTable[90 - n2];
            }
            case 3: {
                return -s_cosineLookupTable[n2];
            }
        }
        return 0;
    }

    public static long fpDistance(int n, int n2, int n3, int n4) {
        long l = n3 - n;
        l *= l;
        long l2 = n4 - n2;
        l2 *= l2;
        return MathTools.fpSqrt(l + l2 << 8);
    }

    public static long fpConvert(long l) {
        l <<= 8;
        return l /= 1000L;
    }

    public static long fpMul(long l, long l2) {
        l *= l2;
        return l >>= 8;
    }

    public static long fpDiv(long l, long l2) {
        l <<= 8;
        return l /= l2;
    }

    public static long fpAbs(long l) {
        return l < 0L ? -l : l;
    }

    public static int fpToCeiling(long l) {
        if (l > 0L) {
            l += 256L;
        } else if (l < 0L) {
            l -= 256L;
        }
        return (int)(l >> 8);
    }

    public static String fpToString(int n) {
        boolean bl = false;
        if ((n & Integer.MIN_VALUE) != 0) {
            bl = true;
            n ^= 0xFFFFFFFF;
            ++n;
        }
        long l = n & 0xFF;
        l *= 1000L;
        l >>= 8;
        char[] cArray = new char[3];
        int n2 = 2;
        while (n2 >= 0) {
            cArray[n2] = 48;
            int n3 = n2--;
            cArray[n3] = (char)(cArray[n3] + (char)(l % 10L));
            l /= 10L;
        }
        n2 = n >> 8;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('-');
        }
        stringBuffer.append(n2).append('.').append(cArray);
        return stringBuffer.toString();
    }

    public static String fpToString(long l) {
        char c = '\u0000';
        if ((l & Long.MIN_VALUE) != 0L) {
            c = '-';
            l ^= 0xFFFFFFFFFFFFFFFFL;
            ++l;
        }
        long l2 = l & 0xFFL;
        l2 *= 1000L;
        l2 >>= 8;
        char[] cArray = new char[3];
        int n = 2;
        while (n >= 0) {
            cArray[n] = 48;
            int n2 = n--;
            cArray[n2] = (char)(cArray[n2] + (char)(l2 % 10L));
            l2 /= 10L;
        }
        long l3 = l >> 8;
        StringBuffer stringBuffer = new StringBuffer();
        if (c != '\u0000') {
            stringBuffer.append(c);
        }
        stringBuffer.append(l3).append('.').append(cArray);
        return stringBuffer.toString();
    }

    public static int squareRoot(int n) {
        int n2;
        int n3 = 0;
        int n4 = n2 = n >= 65536 ? 0x40000000 : 16384;
        do {
            int n5;
            if (n >= (n5 = n3 + n2)) {
                n -= n5;
                n3 = n5 + n2;
            }
            n3 >>>= 1;
        } while ((n2 >>>= 2) != 0);
        return n3;
    }

    public static int computeLerp(int n, int n2, int n3, int n4) {
        return n + (n2 - n) * n3 / n4;
    }

    public static long easyInOut(long l, long l2) {
        if (l < 0L) {
            return 0L;
        }
        long l3 = (l2 - l << 8) / l2;
        long l4 = l3 * l3 >> 8;
        long l5 = 3L * l4 - 2L * (l4 * l3 >> 8);
        l5 = 256L - l5;
        return l5;
    }

    public static int getBitfieldCount(long l) {
        int n = 0;
        for (int i = 0; i < 64; ++i) {
            if ((l & 1L << i) == 0L) continue;
            ++n;
        }
        return n;
    }

    public static long cubicEaseIn(long l, long l2) {
        if (l < 0L) {
            return 0L;
        }
        long l3 = (l << 8) / l2;
        long l4 = l3 * l3 >> 8;
        long l5 = l4 * l3 >> 8;
        return l5;
    }

    public static long cubicEaseOut(long l, long l2) {
        if (l < 0L) {
            return 0L;
        }
        long l3 = (l << 8) / l2;
        long l4 = l3 * l3 >> 8;
        long l5 = l4 * l3 >> 8;
        return 3L * l3 - 3L * l4 + l5;
    }

    public static long parametricInterpolation(long l, long l2, int[] nArray) {
        if (l < 0L) {
            return 0L;
        }
        if (l > l2) {
            return 256L;
        }
        long l3 = (l << 8) / l2;
        long l4 = l3 * l3 >> 8;
        long l5 = l4 * l3 >> 8;
        long l6 = l5 * l3 >> 8;
        long l7 = l6 * l3 >> 8;
        return (long)nArray[0] * l3 + (long)nArray[1] * l4 + (long)nArray[2] * l5 + (long)nArray[3] * l6 + (long)nArray[4] * l7;
    }

    public static int fpSqrt(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        while (n5-- >= 0) {
            n3 = n3 << 16 | n4 >>> 16;
            n4 <<= 2;
            int n6 = ((n2 <<= 1) << 1) + 1;
            if (n3 < n6) continue;
            n3 -= n6;
            ++n2;
        }
        return n2;
    }

    public static long fpSqrt(long l) {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = l;
        int n = 0;
        while (n-- >= 0) {
            l3 = l3 << 2 | l4 >>> 62;
            l4 <<= 2;
            long l5 = ((l2 <<= 1) << 1) + 1L;
            if (l3 < l5) continue;
            l3 -= l5;
            ++l2;
        }
        return l2;
    }

    public static int computeBezierPoint(int n, int n2, int n3, int n4, int n5) {
        if (n4 >= n5) {
            return n2;
        }
        n -= (int)((long)(n - n3) * (long)n4 / (long)n5);
        n2 = n3 - (int)((long)(n3 - n2) * (long)n4 / (long)n5);
        return n - (int)((long)(n - n2) * (long)n4 / (long)n5);
    }

    public static int interpolatePositionQuadraticBezier(int n, int n2, int n3, int n4, int n5) {
        if (n4 == 0) {
            return n;
        }
        if (n4 >= n5) {
            return n3;
        }
        long l = ((long)n4 << 8) / (long)n5;
        long l2 = 256L - l;
        long l3 = (l2 * l2 >> 8) * (long)n;
        l3 += (l * l2 >> 8) * 2L * (long)n2;
        return (int)((l3 += (l * l >> 8) * (long)n3) >> 8);
    }

    public static int easyInOutInterpolate(int n, int n2, int n3, int n4) {
        if (n3 > n4) {
            return n2 << 8;
        }
        return (n << 8) + (n2 - n) * (int)MathTools.easyInOut(n3, n4);
    }

    public static int linearInterpolate(int n, int n2, int n3, int n4) {
        if (n3 > n4) {
            return n2;
        }
        if (n3 < 0) {
            return n;
        }
        return (n * (n4 - n3) + n2 * n3) / n4;
    }

    public static int getAngle(long l, long l2) {
        long l3;
        long l4;
        long l5;
        long l6 = l;
        if (l6 < 0L) {
            l6 = 0L - l6;
        }
        if ((l5 = l2) < 0L) {
            l5 = 0L - l5;
        }
        if (l5 <= l6) {
            if (l6 == 0L) {
                if (l2 >= 0L) {
                    return 0;
                }
                return 2;
            }
            l4 = l5;
            l4 <<= 9;
            l4 /= l6;
            l3 = 1L;
        } else {
            if (l5 == 0L) {
                if (l >= 0L) {
                    return 1;
                }
                return 3;
            }
            l4 = l6;
            l4 <<= 9;
            l4 /= l5;
            l3 = 0L;
        }
        long l7 = ARC_TANGENT_TABLE[(int)(l4 >> 2)] + l4;
        if (l >= 0L) {
            if (l2 >= 0L) {
                if (l3 != 0L) {
                    l7 = 1024L - l7;
                }
            } else {
                l7 = l3 != 0L ? (l7 += 1024L) : 2048L - l7;
            }
        } else {
            l7 = l2 >= 0L ? (l3 != 0L ? (l7 += 3072L) : 4096L - l7) : (l3 != 0L ? 3072L - l7 : (l7 += 2048L));
        }
        if ((l7 = 180L - (l7 * 90L >> 10)) < 0L) {
            l7 += 360L;
        }
        return (int)l7;
    }

    static {
        s_cosineLookupTable = new int[]{65536, 65526, 65496, 65446, 65376, 65286, 65176, 65047, 64898, 64729, 64540, 64332, 64104, 63856, 63589, 63303, 62997, 62672, 62328, 61965, 61583, 61183, 60763, 60325, 59870, 59395, 58903, 58393, 57865, 57319, 56756, 56175, 55577, 54963, 54331, 53683, 53019, 52339, 51643, 50931, 50203, 49460, 48702, 47929, 47142, 46341, 45525, 44695, 43852, 42995, 42125, 41243, 40347, 39440, 38521, 37590, 36647, 35693, 34728, 33753, 32768, 31772, 30767, 29752, 28729, 27696, 26656, 25606, 24550, 23486, 22414, 21336, 20251, 19160, 18064, 16962, 15854, 14742, 13625, 12504, 11380, 10251, 9120, 7986, 6850, 5712, 4571, 3430, 2287, 1143, 0};
        ARC_TANGENT_TABLE = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 28L, 29L, 30L, 31L, 32L, 32L, 33L, 34L, 35L, 35L, 36L, 37L, 37L, 38L, 39L, 39L, 40L, 40L, 41L, 41L, 42L, 42L, 43L, 43L, 44L, 44L, 44L, 45L, 45L, 45L, 45L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 45L, 45L, 45L, 44L, 44L, 44L, 43L, 43L, 43L, 42L, 42L, 41L, 41L, 40L, 39L, 39L, 38L, 38L, 37L, 36L, 35L, 35L, 34L, 33L, 32L, 31L, 31L, 30L, 29L, 28L, 27L, 26L, 25L, 24L, 23L, 22L, 21L, 19L, 18L, 17L, 16L, 15L, 14L, 12L, 11L, 10L, 8L, 7L, 6L, 4L, 3L, 1L, 0L};
    }
}

