/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.sdk.SDKAutoConstants;

public class InputManager {
    public static final int KEYS_ACTION_PRESSED = 0;
    public static final int KEYS_ACTION_RELEASED = 1;
    public static final int KEYS_ACTION_DOWN = 2;
    public static final int KEYS_ACTION_PRESSED_ASYNC = 3;
    public static final int KEYS_ACTION_RELEASED_ASYNC = 4;
    public static final int KEYS_ACTION_DOWN_ASYNC = 5;
    public static final int SIZEOF_KEYS_ACTION = 6;
    public static int s_keysPressed;
    public static int s_keysReleased;
    public static int s_keysDown;
    private static int s_keysPressedAsync;
    private static int s_keysReleasedAsync;
    private static int s_virtualKeysDownAsync;
    private static boolean s_pointerDownAsync;
    private static boolean s_pointerDraggedAsync;
    static boolean s_isPointerDragged;
    static boolean s_isPointerBeingPressed;
    private static int s_pointerXAsync;
    private static int s_pointerYAsync;
    public static boolean s_isPointerDown;
    public static int s_pointerX;
    public static int s_pointerDownX;
    public static int s_pointerY;
    public static int s_pointerDownY;
    public static boolean s_isKeyUpPressed;
    public static boolean s_isKeyDownPressed;
    public static boolean s_isKeyLeftPressed;
    public static boolean s_isKeyRightPressed;
    public static boolean s_isKeyLeftDown;
    public static boolean s_isKeyRightDown;
    public static boolean s_isKeyUpDown;
    public static boolean s_isKeyDownDown;
    public static boolean s_isKeyAcceptPressed;
    public static boolean s_isKeyCancelPressed;
    public static boolean s_isKeyCenterPressed;
    private static final int MAX_GAP_SIZE = 8;
    private static final int MAX_PRESS_LENGTH = 5;
    static final int MAX_FRAMES_ROLLBACK = 2;

    private static void updateKeyPresetsState() {
        if (SDKAutoConstants.getReversedSoftkeys()) {
            s_isKeyAcceptPressed = (s_keysPressed & 0x40) != 0;
            s_isKeyCancelPressed = (s_keysPressed & 0x20) != 0 || (s_keysPressed & 0x80000) != 0;
        } else {
            s_isKeyAcceptPressed = (s_keysPressed & 0x20) != 0;
            s_isKeyCancelPressed = (s_keysPressed & 0x40) != 0 || (s_keysPressed & 0x80000) != 0;
        }
        s_isKeyUpPressed = (s_keysPressed & 0x200) != 0 || (s_keysPressed & 1) != 0;
        s_isKeyDownPressed = (s_keysPressed & 0x8000) != 0 || (s_keysPressed & 2) != 0;
        s_isKeyLeftPressed = (s_keysPressed & 0x800) != 0 || (s_keysPressed & 4) != 0;
        s_isKeyRightPressed = (s_keysPressed & 0x2000) != 0 || (s_keysPressed & 8) != 0;
        s_isKeyCenterPressed = (s_keysPressed & 0x1000) != 0 || (s_keysPressed & 0x10) != 0;
        s_isKeyUpDown = (s_keysDown & 0x200) != 0 || (s_keysDown & 1) != 0;
        s_isKeyDownDown = (s_keysDown & 0x8000) != 0 || (s_keysDown & 2) != 0;
        s_isKeyLeftDown = (s_keysDown & 0x800) != 0 || (s_keysDown & 4) != 0;
        s_isKeyRightDown = (s_keysDown & 0x2000) != 0 || (s_keysDown & 8) != 0;
    }

    public static void keyPressed(int n) {
        s_keysPressedAsync |= n;
        s_virtualKeysDownAsync |= n;
    }

    public static void keyReleased(int n) {
        s_keysReleasedAsync |= n;
    }

    public static void pointerPressed(int n, int n2) {
        s_pointerDownAsync = true;
        s_isPointerBeingPressed = true;
        s_pointerXAsync = n;
        s_pointerYAsync = n2;
        s_pointerDownX = n;
        s_pointerDownY = n2;
    }

    public static void pointerReleased(int n, int n2) {
        s_pointerDownAsync = false;
        s_isPointerBeingPressed = false;
    }

    public static void pointerDragged(int n, int n2) {
        s_pointerDraggedAsync = true;
        s_pointerXAsync = n;
        s_pointerYAsync = n2;
        s_pointerDownX = n;
        s_pointerDownY = n2;
    }

    public static boolean checkTouch(int n, int n2, int n3, int n4) {
        return s_isPointerBeingPressed && s_pointerDownX >= n && s_pointerDownX <= n + n3 && s_pointerDownY >= n2 && s_pointerDownY <= n2 + n4;
    }

    public static boolean checkTouched(int n, int n2, int n3, int n4) {
        return s_isPointerDown && s_pointerX >= n && s_pointerX <= n + n3 && s_pointerY >= n2 && s_pointerY <= n2 + n4;
    }

    public static void updateKeyStates() {
        s_keysPressed = s_keysPressedAsync;
        s_keysReleased = s_keysReleasedAsync;
        s_keysDown = s_virtualKeysDownAsync;
        s_keysPressedAsync = 0;
        s_keysReleasedAsync = 0;
        s_virtualKeysDownAsync &= ~s_keysReleased;
        s_isPointerDown = s_pointerDownAsync;
        s_isPointerDragged = s_pointerDraggedAsync;
        s_pointerX = s_pointerXAsync;
        s_pointerY = s_pointerYAsync;
        s_pointerDownAsync = false;
        s_pointerDraggedAsync = false;
        s_pointerXAsync = 0;
        s_pointerYAsync = 0;
        InputManager.updateKeyPresetsState();
    }

    public static void clearKeyStates() {
        s_keysPressed = 0;
        s_keysReleased = 0;
        s_keysDown = 0;
        s_keysPressedAsync = 0;
        s_keysReleasedAsync = 0;
        s_virtualKeysDownAsync = 0;
        s_pointerDownX = 0;
        s_pointerDownY = 0;
        s_isPointerBeingPressed = false;
    }

    public static void addKeyToInputBuffer(byte by, byte[] byArray) {
        for (int i = byArray.length - 2; i >= 0; --i) {
            byArray[i + 1] = byArray[i];
        }
        byArray[0] = by;
    }

    public static boolean isCommandInInputBuffer(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byte by = -100;
        byte by2 = -100;
        for (int i = n; i < byArray.length; ++i) {
            byte by3 = byArray[i];
            byte by4 = byArray2[byArray2.length - 1 - n2];
            if (by != -100 && by3 == by && n4 > 0) {
                ++n4;
            } else if (by3 == by4 && (n4 == 0 || by2 != by3)) {
                ++n2;
                by = by4;
                ++n4;
                n3 = 0;
                by2 = by4;
            } else if (by3 == 10) {
                ++n3;
                n4 = 0;
            } else if (by3 != by4) {
                return false;
            }
            if (n3 > 8 || n4 > 5) {
                return false;
            }
            if (n2 != byArray2.length) continue;
            return true;
        }
        return false;
    }

    public static void resetInputBuffer(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 10;
        }
    }

    public static void letterPressed(int n) {
    }

    public static void letterReleased(int n) {
    }

    public static boolean isLetterDown(char c) {
        return false;
    }

    public static boolean isLetterPressed(int n) {
        return false;
    }

    public static boolean isLetterReleased(int n) {
        return false;
    }
}

