/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.Battle;
import com.ea.game.CharacterSelection;
import com.ea.game.Destiny;
import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.IFighter;
import com.ea.game.InputManager;
import com.ea.game.MathTools;
import com.ea.game.Menu;
import com.ea.game.Rms;
import com.ea.game.Softkey;
import com.ea.game.Sound;
import com.ea.game.Tileset;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class Ingame {
    public static int s_ingameState;
    public static int s_ingameStateTimer;
    public static final int INGAME_STATE_ARCADE_GAME_START = 0;
    public static final int INGAME_STATE_CHOOSE_FIGHTER = 1;
    public static final int INGAME_STATE_CHOOSE_YOUR_DESTINY = 2;
    public static final int INGAME_STATE_BATTLE = 3;
    public static final int INGAME_STATE_NEXT_FIGHT = 4;
    public static final int INGAME_STATE_ENDING = 5;
    public static final int INGAME_STATE_CREDITS = 6;
    public static final int INGAME_STATE_SHAO_KAHN_UNLOCKED = 7;
    public static final int INGAME_STATE_ENTER_NAME = 8;
    public static final int INGAME_STATE_GAME_OVER = 9;
    public static final int INGAME_STATE_BIO = 10;
    public static final int INGAME_STATE_CLEANED_UP = 11;
    private static final int ENDING_SCREEN_TEXT_SCROLL_SPEED_FP = 4096;
    private static final int GAME_OVER_SCREEN_DURATION = 3000;
    public static final int DESTINY_ID_NOVICE = 0;
    public static final int DESTINY_ID_WARRIOR = 1;
    public static final int DESTINY_ID_MASTER = 2;
    public static final int[] DESTINY_NAMES;
    public static final int NUMBER_OF_DESTINIES = 3;
    public static final int DESTINY_BOSS_FIGHTER_ID = 6;
    private static final int ARCADE_TEXT_BOTTOM_PADDING = 24;
    private static final int MAX_TEXT_LINES = 30;
    private static final int MINIMUM_NUMBER_OF_FIGHTS = 3;
    private static final int ENDURANCE_MATCH_COUNT = 2;
    public static int s_arcadeFighterId;
    public static int s_arcadeDestinyId;
    private static int[][] s_arcadeDestiny;
    private static int s_arcadeCurrentDestiny;
    public static int s_arcadeWonMatch;
    private static byte s_arcadeCurrentArenaId;
    private static final byte FINAL_ARENA_ID = 4;
    private static final byte FIRST_ARENA_ID = 0;
    private static SDKString s_arcadeText;
    private static short[] s_arcadeTextData;
    private static int s_arcadeTextY;
    private static int s_arcadeTextVisibleLines;
    private static int s_arcadeTextYFP;
    private static int s_arcadeTextFirstVisibleLine;
    private static boolean s_areInfoArrowsVisible;
    private static boolean s_isUpArrowVisible;
    private static boolean s_isUpArrowPressed;
    private static boolean s_isDownArrowVisible;
    private static boolean s_isDownArrowPressed;
    private static int s_arcadeTextMaxVisibleLines;
    private static boolean s_isBioShown;
    private static int s_arcadeOpponentId;
    private static boolean s_isPauseMenuLaunched;
    public static boolean s_isPauseMenuLaunchedExit;
    public static boolean s_isInfoMenuLaunched;
    public static long s_currentScore;
    public static long s_currentVisibleScore;
    public static long s_currentBeginningScore;
    private static long s_currentVisibleScoreTimer;
    private static final int SCORE_ANIMATION_DURATION = 1000;
    static long s_baseScore;
    private static boolean s_wasNewHighscore;
    private static int s_newHighscorePosition;
    private static Tileset s_fightersTileset;
    private static Animation s_fightersAnimation;
    private static int s_fightersAnimationInstance;
    private static int s_fightersAnimationWidth;
    private static int s_fightersAnimationHeight;
    private static int s_fightersAnimationLeft;
    private static int s_fightersAnimationX;
    private static int s_fightersAnimationY;
    private static int s_scrollableTextX;
    private static SDKString s_headerString;
    private static boolean s_isScrollingTextOver;
    private static boolean s_isShaoKahnJustUnlocked;
    public static byte[] s_enduranceFighters;
    private static boolean s_isInPracticeMode;
    private static final int INFO_SCREEN_SCROLLING_DELAY = 150;
    private static int s_infoScreenScrollTimer;
    private static byte FONT_INFO_SCREEN_ID;

    public static boolean isInPracticeMode() {
        return s_isInPracticeMode;
    }

    public static void setPracticeMode(boolean bl) {
        s_isInPracticeMode = bl;
    }

    public static void checkShaoKahnUnlock() {
        if (Destiny.getSelectedDestiny() == 2 && !GameImpl.isShaoKahnUnlocked()) {
            GameImpl.setShaoKahnUnlocked(true);
            s_isShaoKahnJustUnlocked = true;
        }
    }

    public static int getNewHighscorePosition() {
        return s_newHighscorePosition;
    }

    public static void setCurrentScore(int n) {
        if ((long)n != s_currentScore) {
            if (s_currentVisibleScore == 0L) {
                s_currentVisibleScoreTimer = 1000L;
                s_currentBeginningScore = s_currentScore;
                s_currentVisibleScore = n;
            } else {
                s_currentVisibleScoreTimer = 0L;
                s_currentBeginningScore = s_currentVisibleScore;
            }
        }
        s_currentScore = n;
    }

    public static int getCurrentScore() {
        return (int)s_currentScore;
    }

    public static int getCurrentVisibleScore() {
        return (int)s_currentVisibleScore;
    }

    public static void setBaseScore(int n) {
        s_baseScore = n;
    }

    public static int getBaseScore() {
        return (int)s_baseScore;
    }

    public static void launchInfoMenu() {
        if (s_ingameState == 3 && Battle.isPauseMenuStateAvailable()) {
            Sound.stopSound();
            s_isInfoMenuLaunched = true;
            GameImpl.setFont(FONT_INFO_SCREEN_ID);
            s_arcadeText = new SDKString(500, 0);
            s_arcadeText = s_arcadeText.append(Battle.getFighter1().m_moveList);
            s_arcadeText = s_arcadeText.append("||" + Menu.getLegendHelpText());
            s_arcadeTextData = SDKUtils.wrapString(s_arcadeText, null, GameImpl.s_screenWidth - 12, (short)124);
            s_arcadeTextFirstVisibleLine = 1;
            s_arcadeTextMaxVisibleLines = (GameImpl.s_screenHeight - Softkey.getSoftkeyHeight()) / SDKUtils.getBaselinePosition();
            Softkey.setSoftkeys((byte)0, (byte)4);
            boolean bl = s_areInfoArrowsVisible = s_arcadeTextData[0] > s_arcadeTextMaxVisibleLines;
            if (s_areInfoArrowsVisible) {
                s_arcadeTextMaxVisibleLines = (GameImpl.s_screenHeight - Softkey.getSoftkeyHeight() - 2 * Menu.getArrowHeight()) / SDKUtils.getBaselinePosition() - 1;
                s_infoScreenScrollTimer = 0;
            }
            s_arcadeTextY = (GameImpl.s_screenHeight - Softkey.getSoftkeyHeight()) / 2 + (s_areInfoArrowsVisible ? Menu.getArrowHeight() - 7 * SDKUtils.getBaselinePosition() / 4 : 0);
            s_arcadeTextY -= Math.min(s_arcadeTextData[0], s_arcadeTextMaxVisibleLines) * SDKUtils.getBaselinePosition() / 2;
        }
    }

    public static void launchPauseMenu() {
        if (!Battle.isPauseMenuStateAvailable()) {
            return;
        }
        Sound.stopSound();
        s_isPauseMenuLaunched = true;
        Menu.initState(24);
    }

    public static void launchPauseMenuExit() {
        if (!Battle.isPauseMenuStateAvailable()) {
            return;
        }
        Sound.stopSound();
        s_isPauseMenuLaunched = true;
        s_isPauseMenuLaunchedExit = true;
        Menu.initState(25);
    }

    private static void drawHeader() {
        GameImpl.setFont((byte)4);
        SDKUtils.drawString(s_headerString, GameImpl.s_screenWidth / 2, 6, 17);
    }

    public static void exitPauseMenu() {
        s_isPauseMenuLaunched = false;
        Battle.resetBattleMusic();
    }

    public static void exitInfoMenu() {
        s_isInfoMenuLaunched = false;
        Battle.resetBattleMusic();
    }

    public static boolean isInfoMenuLaunched() {
        return s_isInfoMenuLaunched;
    }

    public static void initIngame() {
        s_ingameState = 0;
        Ingame.ingameInitState(0);
    }

    private static void updateInfoMenuTouchpad() {
    }

    private static void updateInfoMenu() {
        Ingame.updateInfoMenuTouchpad();
        if (InputManager.s_isKeyDownPressed) {
            s_infoScreenScrollTimer = 0;
            ++s_arcadeTextFirstVisibleLine;
            s_isDownArrowPressed = true;
        } else {
            s_isDownArrowPressed = false;
        }
        if (InputManager.s_isKeyUpPressed) {
            s_infoScreenScrollTimer = 0;
            --s_arcadeTextFirstVisibleLine;
            s_isUpArrowPressed = true;
        } else {
            s_isUpArrowPressed = false;
        }
        if (InputManager.s_isKeyUpDown) {
            if ((s_infoScreenScrollTimer += GameImpl.s_elapsedTimeClamped) > 150) {
                s_infoScreenScrollTimer = 0;
                --s_arcadeTextFirstVisibleLine;
            }
            s_isUpArrowPressed = true;
        }
        if (InputManager.s_isKeyDownDown) {
            if ((s_infoScreenScrollTimer += GameImpl.s_elapsedTimeClamped) > 150) {
                s_infoScreenScrollTimer = 0;
                ++s_arcadeTextFirstVisibleLine;
            }
            s_isDownArrowPressed = true;
        }
        if (InputManager.s_isKeyCancelPressed) {
            Ingame.exitInfoMenu();
        }
        if (s_arcadeTextFirstVisibleLine + s_arcadeTextMaxVisibleLines > s_arcadeTextData[0] + 1) {
            s_arcadeTextFirstVisibleLine = s_arcadeTextData[0] - s_arcadeTextMaxVisibleLines + 1;
        }
        if (s_arcadeTextFirstVisibleLine < 1) {
            s_arcadeTextFirstVisibleLine = 1;
        }
        if (s_areInfoArrowsVisible) {
            s_isDownArrowVisible = s_arcadeTextFirstVisibleLine + s_arcadeTextMaxVisibleLines <= s_arcadeTextData[0];
            s_isUpArrowVisible = s_arcadeTextFirstVisibleLine > 1;
        }
    }

    public static void updateIngame() {
        if (s_isPauseMenuLaunched) {
            Menu.updateMenu();
            return;
        }
        if (s_isInfoMenuLaunched) {
            Ingame.updateInfoMenu();
            return;
        }
        if (s_ingameState == 3 && Battle.s_battleState != 14 && InputManager.s_isKeyCancelPressed) {
            Ingame.launchPauseMenu();
        } else if (s_ingameState == 3 && Battle.s_battleState != 14 && Battle.s_battleState != 5 && InputManager.s_isKeyAcceptPressed) {
            Ingame.launchInfoMenu();
        } else {
            Ingame.ingameUpdateState();
        }
    }

    private static void drawInfoMenu() {
        GameImpl.setFont(FONT_INFO_SCREEN_ID);
        int n = s_arcadeTextY;
        int n2 = Math.min(s_arcadeTextData[0], s_arcadeTextFirstVisibleLine + s_arcadeTextMaxVisibleLines);
        for (int i = s_arcadeTextFirstVisibleLine - 1; i < n2; ++i) {
            SDKUtils.drawSubString(s_arcadeText, s_arcadeTextData[i + 1], s_arcadeTextData[i + 2] - s_arcadeTextData[i + 1] + (i == s_arcadeTextData[0] - 1 ? 0 : -1), GameImpl.s_screenWidth / 2, n, 17);
            n += SDKUtils.getBaselinePosition();
        }
        if (s_areInfoArrowsVisible) {
            Menu.drawArrows(s_isUpArrowVisible, s_isUpArrowPressed, s_isDownArrowVisible, s_isDownArrowPressed, GameImpl.s_screenWidth / 2 - Menu.getArrowWidth() / 2, 0, GameImpl.s_screenWidth / 2 - Menu.getArrowWidth() / 2, GameImpl.s_screenHeight - Softkey.getSoftkeyHeight() - Menu.getArrowHeight(), true);
        }
    }

    public static void drawIngame(SDKGraphics sDKGraphics) {
        if (s_isPauseMenuLaunched) {
            Menu.drawMenu();
            return;
        }
        if (s_isInfoMenuLaunched) {
            Ingame.drawInfoMenu();
            return;
        }
        try {
            Ingame.ingameDrawState(sDKGraphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cleanupIngame() {
        s_enduranceFighters = null;
        s_arcadeDestiny = null;
        Ingame.ingameCleanupState(s_ingameState);
        s_ingameState = 11;
    }

    public static void ingameInitState(int n) {
        Ingame.ingameCleanupState(s_ingameState);
        Softkey.resetSoftkeys();
        switch (n) {
            case 0: {
                s_arcadeCurrentDestiny = -1;
                s_arcadeDestinyId = -1;
                s_arcadeWonMatch = 0;
                s_arcadeDestiny = null;
                s_arcadeCurrentArenaId = 0;
                s_isBioShown = false;
                s_currentScore = 0L;
                break;
            }
            case 1: {
                CharacterSelection.initCharacterSelection();
                break;
            }
            case 2: {
                s_arcadeDestiny = Ingame.createDestiny();
                Destiny.initDestiny();
                Destiny.setupDestiny(s_arcadeDestiny);
                Destiny.setFighterId(s_arcadeFighterId);
                Destiny.initState(0);
                break;
            }
            case 3: {
                if (s_currentScore > s_baseScore && !Ingame.isInPracticeMode()) {
                    s_baseScore = s_currentScore;
                }
                Battle.initBattle(s_arcadeFighterId, Ingame.isInPracticeMode() ? s_arcadeFighterId : s_arcadeOpponentId, Ingame.getCurrentArena());
                if (Ingame.isInPracticeMode()) break;
                s_currentVisibleScore = s_baseScore;
                s_currentBeginningScore = s_baseScore;
                break;
            }
            case 4: {
                Destiny.initDestiny();
                Destiny.setupDestiny(s_arcadeDestiny);
                Destiny.setSelectedDestiny(s_arcadeDestinyId);
                Destiny.setNewSelectedOpponent(s_arcadeWonMatch);
                Destiny.setFighterId(s_arcadeFighterId);
                Destiny.initState(4);
                break;
            }
            case 5: {
                GameImpl.setFont((byte)4);
                try {
                    s_fightersTileset = FileManager.createTileset(IFighter.FIGHTERS_TILESETS[s_arcadeFighterId]);
                    s_fightersAnimation = Animation.loadAnimation(IFighter.FIGHTERS_COMMON_ANIMATIONS[s_arcadeFighterId][66], 0);
                    s_fightersAnimationInstance = 1;
                    s_fightersAnimationHeight = s_fightersAnimation.computeGlobalHeight(s_fightersTileset);
                    s_fightersAnimationWidth = s_fightersAnimation.computeLastFrameWidth(s_fightersTileset);
                    s_fightersAnimationLeft = s_fightersAnimation.getLastFrameLeft(s_fightersTileset);
                    s_fightersAnimationX = -s_fightersAnimationLeft;
                    s_fightersAnimationY = GameImpl.s_screenHeight - Softkey.getSoftkeyHeight() - (GameImpl.s_screenHeight - Softkey.getSoftkeyHeight() - 6 - SDKUtils.getLineSize() - s_fightersAnimationHeight) / 2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                s_headerString = Battle.getLastWinsString().toSDKString();
                Ingame.prepareHalfScreenText(IFighter.FIGHTERS_ENDING_TXT[s_arcadeFighterId]);
                FileManager.cleanup();
                break;
            }
            case 6: {
                s_headerString = SDKUtils.getString(125, null);
                Ingame.prepareText(108);
                break;
            }
            case 7: {
                Ingame.prepareText(131);
                break;
            }
            case 8: {
                Menu.initEnterName();
                break;
            }
            case 9: {
                Ingame.prepareText(65);
                break;
            }
            case 10: {
                GameImpl.setFont((byte)4);
                try {
                    s_fightersTileset = FileManager.createTileset(IFighter.FIGHTERS_TILESETS[s_arcadeFighterId]);
                    s_fightersAnimation = Animation.loadAnimation(IFighter.FIGHTERS_COMMON_ANIMATIONS[s_arcadeFighterId][0], 1);
                    s_fightersAnimationInstance = 1;
                    s_fightersAnimationHeight = s_fightersAnimation.computeGlobalHeight(s_fightersTileset);
                    s_fightersAnimationWidth = s_fightersAnimation.computeGlobalWidth(s_fightersTileset);
                    s_fightersAnimationLeft = s_fightersAnimation.getMaxFrameLeft(s_fightersTileset);
                    s_fightersAnimationX = -s_fightersAnimationLeft;
                    s_fightersAnimationY = GameImpl.s_screenHeight - Softkey.getSoftkeyHeight() - (GameImpl.s_screenHeight - Softkey.getSoftkeyHeight() - 6 - SDKUtils.getLineSize() - s_fightersAnimationHeight) / 2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                s_headerString = SDKUtils.getString(IFighter.FIGHTER_NAMES[s_arcadeFighterId], null);
                Ingame.prepareHalfScreenText(IFighter.FIGHTERS_BIOS[s_arcadeFighterId]);
                FileManager.cleanup();
                break;
            }
            case 11: {
                if (s_wasNewHighscore) {
                    GameImpl.setState(9);
                    Menu.initState(7);
                    s_wasNewHighscore = false;
                    break;
                }
                Sound.stopSound();
                GameImpl.setState(9);
            }
        }
        s_ingameStateTimer = 0;
        s_ingameState = n;
    }

    private static void ingameUpdateState() {
        s_ingameStateTimer += GameImpl.s_elapsedTimeClamped;
        switch (s_ingameState) {
            case 0: {
                if (Destiny.getDestinySaved() && !Ingame.isInPracticeMode()) {
                    s_arcadeCurrentDestiny = Destiny.getSelectedDestiny();
                    s_arcadeDestinyId = Destiny.getSelectedDestiny();
                    s_arcadeWonMatch = Destiny.getSelectedBrick();
                    s_arcadeDestiny = Destiny.getDestinySetup();
                    s_isBioShown = true;
                    s_arcadeFighterId = Destiny.getFighterId();
                    Ingame.ingameInitState(4);
                    break;
                }
                Ingame.ingameInitState(1);
                break;
            }
            case 1: {
                if (CharacterSelection.isCharacterSelectionOver()) {
                    s_arcadeFighterId = CharacterSelection.getSelectedFighterId();
                    if (Ingame.isInPracticeMode()) {
                        Ingame.ingameInitState(3);
                    } else {
                        Ingame.ingameInitState(2);
                    }
                }
                if (!CharacterSelection.isCharacterSelectionBack()) break;
                Ingame.ingameInitState(11);
                break;
            }
            case 2: {
                if (!Destiny.isDestinyOver()) break;
                s_arcadeDestinyId = Destiny.getSelectedDestiny();
                s_arcadeOpponentId = Destiny.getSelectedOpponentFighterId();
                Softkey.setSoftkeys((byte)0, (byte)0);
                if (Ingame.isBioShown()) {
                    Ingame.ingameInitState(3);
                    break;
                }
                s_isBioShown = true;
                Ingame.ingameInitState(10);
                break;
            }
            case 3: {
                if (!Battle.isBattleOver()) break;
                if (Battle.didPlayerWin()) {
                    Ingame.gotoNextMatch();
                    break;
                }
                Ingame.gotoEnterNameOrGameOver();
                break;
            }
            case 4: {
                if (!Destiny.isDestinyOver()) break;
                s_enduranceFighters = null;
                boolean bl = false;
                if (Destiny.isOpponentEndurance3() || bl) {
                    Ingame.generateEndurance3();
                    s_arcadeOpponentId = Ingame.getFighterIdFromEnduranceList(0);
                } else if (Destiny.isOpponentEndurance2()) {
                    Ingame.generateEndurance2();
                    s_arcadeOpponentId = Ingame.getFighterIdFromEnduranceList(0);
                } else if (Destiny.isOpponentStandard()) {
                    s_arcadeOpponentId = Destiny.getSelectedOpponentFighterId();
                }
                Ingame.ingameInitState(3);
                break;
            }
            case 7: {
                if (!InputManager.s_isKeyAcceptPressed && !InputManager.s_isKeyCenterPressed) break;
                Ingame.ingameInitState(5);
                break;
            }
            case 5: {
                if (!InputManager.s_isKeyAcceptPressed && !InputManager.s_isKeyCenterPressed && s_arcadeText != null) break;
                Ingame.ingameInitState(6);
                break;
            }
            case 6: {
                if (!InputManager.s_isKeyAcceptPressed && !InputManager.s_isKeyCenterPressed) break;
                Ingame.gotoEnterNameOrGameOver();
                break;
            }
            case 8: {
                Menu.updateEnterName();
                if (!Menu.isEnterNameFinished()) break;
                s_newHighscorePosition = Menu.addHighscore(Menu.getEnteredName(), (int)s_currentScore);
                Ingame.ingameInitState(9);
                break;
            }
            case 9: {
                if (s_ingameStateTimer <= 3000 && !InputManager.s_isKeyAcceptPressed && !InputManager.s_isKeyCenterPressed) break;
                Destiny.setDestinySaved(false);
                Rms.rmsSave();
                Ingame.ingameInitState(11);
                break;
            }
            case 10: {
                if (!InputManager.s_isKeyAcceptPressed && !InputManager.s_isKeyCenterPressed) break;
                Ingame.ingameInitState(3);
            }
        }
        switch (s_ingameState) {
            case 1: {
                CharacterSelection.updateCharacterSelection();
                break;
            }
            case 2: 
            case 4: {
                Destiny.updateDestiny();
                break;
            }
            case 3: {
                Ingame.updateScoreAnimation();
                Battle.updateBattle();
                break;
            }
            case 5: 
            case 10: {
                s_fightersAnimationInstance = s_fightersAnimation.updateInstance(s_fightersAnimationInstance, GameImpl.s_elapsedTimeClamped);
                Softkey.setSoftkeys((byte)3, (byte)0);
                Ingame.scrollText();
                break;
            }
            case 8: {
                break;
            }
            case 7: {
                Softkey.setSoftkeys((byte)3, (byte)0);
                break;
            }
            case 6: 
            case 9: {
                Softkey.setSoftkeys((byte)3, (byte)0);
                Ingame.scrollText();
            }
        }
    }

    public static int getFighterIdFromEnduranceList(int n) {
        return s_enduranceFighters[n];
    }

    private static void generateEndurance2() {
        s_enduranceFighters = new byte[2];
        Ingame.s_enduranceFighters[0] = 3;
        Ingame.s_enduranceFighters[1] = 2;
    }

    private static void generateEndurance3() {
        s_enduranceFighters = new byte[3];
        Ingame.s_enduranceFighters[0] = 4;
        Ingame.s_enduranceFighters[1] = 1;
        Ingame.s_enduranceFighters[2] = 0;
    }

    private static void gotoEnterNameOrGameOver() {
        if (Menu.isEnoughForHighscore((int)s_currentScore)) {
            s_wasNewHighscore = true;
            Ingame.ingameInitState(8);
        } else {
            s_wasNewHighscore = false;
            Ingame.ingameInitState(9);
        }
    }

    private static void updateScoreAnimation() {
        s_currentVisibleScore = s_currentBeginningScore + (s_currentScore - s_currentBeginningScore) * (s_currentVisibleScoreTimer += (long)GameImpl.s_elapsedTimeClamped) / 1000L;
        s_currentVisibleScore = Math.max(s_currentVisibleScore, s_currentBeginningScore);
        s_currentVisibleScore = Math.min(s_currentVisibleScore, s_currentScore);
    }

    private static boolean isBioShown() {
        return s_arcadeFighterId == 6 ? true : s_isBioShown;
    }

    private static void ingameDrawState(SDKGraphics sDKGraphics) {
        switch (s_ingameState) {
            case 1: {
                CharacterSelection.drawCharacterSelection();
                break;
            }
            case 2: 
            case 4: {
                Destiny.drawDestiny();
                break;
            }
            case 3: {
                Battle.drawBattle(sDKGraphics);
                break;
            }
            case 5: 
            case 10: {
                Ingame.drawHeader();
                s_fightersAnimation.drawInstance(s_fightersAnimationInstance, s_fightersTileset, s_fightersAnimationX, s_fightersAnimationY, 0);
                Ingame.drawScrollableText(false);
                break;
            }
            case 8: {
                if (Menu.isEnterNameFinished()) break;
                Menu.drawEnterName();
                Softkey.drawSoftKeys();
                break;
            }
            case 6: {
                Ingame.drawHeader();
                Ingame.drawScrollableText(true);
                break;
            }
            case 7: 
            case 9: {
                Ingame.drawCenteredText();
            }
        }
    }

    private static void prepareHalfScreenText(int n) {
        GameImpl.setFont((byte)4);
        s_arcadeText = SDKUtils.getString(n, null);
        s_arcadeTextData = SDKUtils.wrapString(s_arcadeText, null, GameImpl.s_screenWidth - s_fightersAnimationWidth - 2, (short)124);
        s_arcadeTextYFP = GameImpl.s_screenHeight - 24 << 8;
        s_scrollableTextX = s_fightersAnimationWidth + 2;
        s_arcadeTextFirstVisibleLine = 1;
        s_isScrollingTextOver = false;
    }

    private static void prepareText(int n) {
        GameImpl.setFont((byte)4);
        s_arcadeText = SDKUtils.getString(n, null);
        s_arcadeTextData = SDKUtils.wrapString(s_arcadeText, null, GameImpl.s_screenWidth - 12, (short)124);
        s_arcadeTextYFP = GameImpl.s_screenHeight - 24 << 8;
        s_scrollableTextX = 6;
        s_arcadeTextFirstVisibleLine = 1;
        s_isScrollingTextOver = false;
    }

    private static void drawScrollableText(boolean bl) {
        GameImpl.setFont((byte)4);
        SDKUtils.drawWrappedString(s_arcadeText, s_arcadeTextData, s_arcadeTextFirstVisibleLine, Math.min(s_arcadeTextData[0], s_arcadeTextVisibleLines), bl ? GameImpl.s_screenWidth / 2 : s_scrollableTextX, s_arcadeTextYFP >> 8, 0x10 | (bl ? 1 : 4));
    }

    private static void drawCenteredText() {
        GameImpl.setFont((byte)4);
        SDKUtils.drawWrappedString(s_arcadeText, s_arcadeTextData, s_arcadeTextFirstVisibleLine, s_arcadeTextData[0], GameImpl.s_screenWidth / 2, GameImpl.s_screenHeight / 2 - s_arcadeTextData[0] * SDKUtils.getLineSize() / 2, 17);
    }

    private static byte getCurrentArena() {
        if (Ingame.isInPracticeMode()) {
            return (byte)MathTools.getRandomInt(0, 4);
        }
        if (s_arcadeWonMatch == Ingame.getFightsToBeat() - 1) {
            return 4;
        }
        if (s_arcadeWonMatch == 0) {
            return 0;
        }
        byte by = (byte)(s_arcadeWonMatch % 5);
        if (by == 4 || s_arcadeWonMatch >= 4) {
            by = (byte)((s_arcadeWonMatch + s_arcadeWonMatch / 4) % 5);
        }
        return by;
    }

    private static void gotoNextMatch() {
        if (Ingame.isInPracticeMode()) {
            s_arcadeCurrentArenaId = Ingame.getCurrentArena();
            Ingame.ingameInitState(3);
            return;
        }
        s_arcadeCurrentArenaId = Ingame.getCurrentArena();
        if (++s_arcadeWonMatch >= Ingame.getFightsToBeat()) {
            if (s_isShaoKahnJustUnlocked) {
                s_isShaoKahnJustUnlocked = false;
                Ingame.ingameInitState(7);
            } else if (s_arcadeFighterId == 6) {
                Ingame.ingameInitState(6);
            } else {
                Ingame.ingameInitState(5);
            }
            Destiny.setDestinySaved(false);
            Rms.rmsSave();
        } else {
            Ingame.ingameInitState(4);
        }
    }

    public static boolean isFinalFight() {
        return s_arcadeWonMatch == Ingame.getFightsToBeat() - 1;
    }

    private static int getFightsToBeat() {
        return Destiny.getNumberOfFights();
    }

    private static void ingameCleanupState(int n) {
        switch (n) {
            case 1: {
                CharacterSelection.cleanUpCharacterSelection();
                break;
            }
            case 2: 
            case 4: {
                Destiny.cleanupDestiny();
                break;
            }
            case 3: {
                Battle.cleanupBattle();
                break;
            }
            case 8: {
                Menu.cleanupEnterName();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                s_arcadeText = null;
                s_arcadeTextData = null;
                s_fightersTileset = null;
                s_fightersAnimation = null;
            }
        }
    }

    public static int[][] createDestiny() {
        int[][] nArray = new int[3][0];
        int n = 9;
        for (int i = 2; i >= 0; --i) {
            nArray[i] = new int[n + 1];
            nArray[i][0] = DESTINY_NAMES[i];
            for (int j = n; j > 0; --j) {
                if (j == n) {
                    nArray[i][j] = 6;
                    continue;
                }
                if (j == n - 1 && i > 0) {
                    if (i == 2) {
                        nArray[i][j] = -2;
                        continue;
                    }
                    if (i != 1) continue;
                    nArray[i][j] = -1;
                    continue;
                }
                if (j == n - 2 && i == 2) {
                    nArray[i][j] = -1;
                    continue;
                }
                boolean bl = false;
                while (!bl) {
                    nArray[i][j] = MathTools.getRandomInt(0, 6);
                    bl = true;
                    for (int k = n; k > j; --k) {
                        if (nArray[i][k] != nArray[i][j]) continue;
                        bl = false;
                    }
                }
            }
            if ((n -= 2) >= 3) continue;
            n = 3;
        }
        return nArray;
    }

    private static void scrollText() {
        GameImpl.setFont((byte)4);
        if (!s_isScrollingTextOver && (s_arcadeTextYFP -= 4096 * GameImpl.s_elapsedTimeClamped / 1000) >> 8 < 6 + 2 * SDKUtils.getLineSize()) {
            if ((s_arcadeTextYFP >> 8) + (s_arcadeTextData[0] - s_arcadeTextFirstVisibleLine + 1) * SDKUtils.getLineSize() < GameImpl.s_screenHeight - Softkey.getSoftkeyHeight() - SDKUtils.getLineSize()) {
                s_arcadeTextYFP += 4096 * GameImpl.s_elapsedTimeClamped / 1000;
                s_isScrollingTextOver = true;
            } else {
                ++s_arcadeTextFirstVisibleLine;
                s_arcadeTextYFP += SDKUtils.getLineSize() << 8;
            }
        }
        s_arcadeTextVisibleLines = (GameImpl.s_screenHeight - Softkey.getSoftkeyHeight() - (s_arcadeTextYFP >> 8)) / SDKUtils.getLineSize();
    }

    private boolean ingameFinished() {
        return s_ingameState == 11;
    }

    public static boolean isPauseMenuLaunched() {
        return s_isPauseMenuLaunched;
    }

    static {
        DESTINY_NAMES = new int[]{27, 28, 29};
        FONT_INFO_SCREEN_ID = (byte)4;
    }
}

