/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.Battle;
import com.ea.game.Debug;
import com.ea.game.FileManager;
import com.ea.game.IFont;
import com.ea.game.IResources;
import com.ea.game.Ingame;
import com.ea.game.InputManager;
import com.ea.game.Menu;
import com.ea.game.Rms;
import com.ea.game.Softkey;
import com.ea.game.Sound;
import com.ea.game.Tileset;
import com.ea.sdk.ResourceLoader;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGame;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKMoreGames16;
import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKUtils;
import java.io.InputStream;

public class GameImpl
implements SDKGame,
ResourceLoader {
    public static int s_elapsedTimeClamped;
    public static int s_elapsedTimeReal;
    private static long s_previousTime;
    public static final int VIBRATION_ON = 0;
    public static final int VIBRATION_OFF = 1;
    public static final int SOUND_SFX = 0;
    public static final int SOUND_MUSIC = 1;
    public static final int SOUND_OFF = 2;
    public static final int CONTROLS_STANDARD = 0;
    public static final int CONTROLS_ADVANCED = 1;
    public static final int DIFFICULTY_EASY = 0;
    public static final int DIFFICULTY_MEDIUM = 1;
    public static final int DIFFICULTY_HARD = 2;
    private static int s_currentVibrationState;
    private static int s_currentSoundState;
    private static int s_currentLanguageState;
    private static int s_currentControlsState;
    private static int s_currentDifficultyState;
    private static boolean s_isVibrationSupported;
    public static final int APPSTATE_STATE_NOT_STARTED = -1;
    public static final int APPSTATE_STATE_INITIAL_SETUP = 0;
    public static final int APPSTATE_STATE_LOGO_EA = 1;
    public static final int APPSTATE_STATE_LOGO_WB = 2;
    public static final int APPSTATE_STATE_LOGO_TITLE = 3;
    public static final int APPSTATE_STATE_LANGUAGE_SELECTION = 4;
    public static final int APPSTATE_STATE_SOUND_SELECTION = 5;
    public static final int APPSTATE_STATE_VIBRATION_SELECTION = 6;
    public static final int APPSTATE_STATE_DIFFICULTY_SELECTION = 7;
    public static final int APPSTATE_STATE_CONTROLS_SELECTION = 8;
    public static final int APPSTATE_STATE_MAIN_MENU = 9;
    public static final int APPSTATE_STATE_MORE_GAMES = 10;
    public static final int APPSTATE_STATE_INGAME = 11;
    public static int s_appStateState;
    public static int s_appStateStateTimer;
    public static SDKGraphics s_currentGraphics;
    public static final int APPSTATE_LOGO_EA_DURATION = 3000;
    public static final int APPSTATE_LOGO_WB_DURATION = 2000;
    public static final int APPSTATE_LOGO_TITLE_DURATION = 2000;
    public static final int VIBRATION_DURATION_SHORT = 100;
    public static final int VIBRATION_DURATION_LONG = 500;
    public static final int VIBRATION_DURATION_VERY_LONG = 2000;
    public static int s_currentBackgroundColour;
    public static final short NEWLINE_CHAR = 124;
    public static SDKMoreGames16 s_mgInstance;
    private static boolean s_menuOptionsNeedRefresh;
    public static boolean s_toggle;
    public static boolean s_toggle2;
    public static SDKSoundManager s_soundManager;
    private static int s_nextState;
    private static Tileset s_titleScreenBackgroundTileset;
    private static Tileset s_titleScreenLogoTileset;
    private static Tileset s_splashEATileset;
    private static Tileset s_splashWBTileset;
    private static Animation s_titleScreenBackgroundAnimation;
    private static Animation s_titleScreenLogoAnimation;
    private static Animation s_splashEAAnimation;
    private static Animation s_splashWBAnimation;
    private static int s_titleScreenBackgroundAnimationInstance;
    private static int s_titleScreenLogoAnimationInstance;
    private static int s_splashEAAnimationInstance;
    private static int s_splashWBAnimationInstance;
    public static String s_platformRequestString;
    public static boolean s_platformRequest;
    public static int s_counter;
    static SDKCanvas s_canvasInstance;
    private static Object[] s_fontsArray;
    public static int s_screenWidth;
    public static int s_screenHeight;
    public static int s_ingameLeft;
    public static int s_ingameTop;
    public static int s_ingameRight;
    public static int s_ingameBottom;
    public static int s_ingameCenterX;
    public static int s_ingameCenterY;
    public static int s_ingameWidth;
    public static int s_ingameHeight;
    public static int s_numLangsLoaded;
    private static boolean s_isLanguageSelectionSkipped;
    private static final String FATALITY_PROPERTY_NAME = "Fatality";
    private static final String FATALITY_VALUE_ON = "on";
    private static final String FATALITY_VALUE_OFF = "off";
    private static final String BLOOD_PROPERTY_NAME = "Blood";
    private static final String BLOOD_VALUE_RED = "red";
    private static final String BLOOD_VALUE_GREEN = "green";
    private static final String BLOOD_VALUE_OFF = "off";
    private static final String CHEATS_PROPERTY_NAME = "Cheats";
    private static final String CHEATS_VALUE_ON = "on";
    private static final String CHEATS_VALUE_OFF = "off";
    private static boolean s_isFatalityOn;
    public static boolean s_areCheatcodesActivated;
    private static boolean s_isBloodDrawn;
    private static boolean s_isBloodRed;
    private static boolean s_isShaoKahnUnlocked;
    public static String s_midletVersionString;
    private static final String MIDLET_VERSION_PROPERTY_NAME = "MIDlet-Version";
    private static final int MAX_FRAME_DURATION = 100;
    private static boolean s_isFirstLaunch;
    public static short[] s_highscoreLettersArray;

    public GameImpl(SDKCanvas sDKCanvas) {
        s_canvasInstance = sDKCanvas;
    }

    public static void setFirstLaunch(boolean bl) {
        s_isFirstLaunch = bl;
    }

    public static boolean getFirstLaunch() {
        return s_isFirstLaunch;
    }

    public static void setSoundState(int n) {
        if (n != s_currentSoundState) {
            s_currentSoundState = n;
            Sound.stopSound();
            SDKInputStream.purgeCache();
            s_soundManager.setSoundEnabled(n != 2);
        }
    }

    public static int getSoundState() {
        return s_currentSoundState;
    }

    public static void setVibrationState(int n) {
        s_currentVibrationState = n;
    }

    public static int getVibrationState() {
        return s_currentVibrationState;
    }

    public static void setLanguageState(int n) {
        if (n < 0) {
            return;
        }
        s_currentLanguageState = n;
        SDKUtils.setCurrentLanguage(s_currentLanguageState);
    }

    public static int getLanguageState() {
        return s_currentLanguageState;
    }

    public static void setControlsState(int n) {
        s_currentControlsState = n;
    }

    public static int getControlsState() {
        return s_currentControlsState;
    }

    public static void setDifficultyState(int n) {
        s_currentDifficultyState = n;
    }

    public static int getDifficultyState() {
        return s_currentDifficultyState;
    }

    public static void cleanupFont(byte by) {
        GameImpl.s_fontsArray[IFont.FONT_MAPPING[by]] = null;
    }

    public static void loadFont(byte by) {
        byte by2 = IFont.FONT_MAPPING[by];
        if (s_fontsArray[by2] == null) {
            switch (IFont.FONT_DATA[by2][0]) {
                case 0: {
                    byte[] byArray = SDKInputStream.loadResourceAsByteArray(IFont.FONT_DATA[by2][1]);
                    GameImpl.s_fontsArray[by2] = IFont.FONT_DATA[by2][3] == -1 ? SDKUtils.loadFont(SDKInputStream.loadImageObject(IFont.FONT_DATA[by2][2]), byArray) : SDKUtils.loadFont(SDKInputStream.loadImageObjectWithPalette(IFont.FONT_DATA[by2][2], IFont.FONT_DATA[by2][3]), byArray);
                }
            }
        }
    }

    public static void setFont(byte by) {
        if (s_fontsArray[IFont.FONT_MAPPING[by]] == null) {
            GameImpl.loadFont(IFont.FONT_MAPPING[by]);
        }
        switch (IFont.FONT_DATA[IFont.FONT_MAPPING[by]][0]) {
            case 0: {
                SDKUtils.setFont(s_fontsArray[IFont.FONT_MAPPING[by]]);
            }
        }
    }

    public static boolean isShaoKahnUnlocked() {
        return s_isShaoKahnUnlocked;
    }

    public static void setShaoKahnUnlocked(boolean bl) {
        s_isShaoKahnUnlocked = bl;
    }

    public static void initMoreGames() {
        s_mgInstance = new SDKMoreGames16(s_screenWidth, s_screenHeight){

            protected void drawBackground(SDKGraphics sDKGraphics) {
                int n = 5;
                sDKGraphics.setClip(0, 0, s_screenWidth, s_screenHeight);
                for (int i = 0; i < s_screenHeight; i += n) {
                    int n2 = 204 - i * 204 / s_screenHeight;
                    sDKGraphics.setColor(n2 << 16 | n2 << 8 | n2);
                    sDKGraphics.fillRect(0, i, s_screenWidth - 1, n);
                }
            }

            protected void platformRequestImpl(String string) {
                s_mgInstance.setDrawSoftKeys(false);
                s_platformRequestString = string;
                s_platformRequest = true;
            }
        };
        s_mgInstance.setProductData(SDKInputStream.loadResourceAsByteArray("/moregames", null, 0));
        GameImpl.loadFont((byte)8);
        GameImpl.loadFont((byte)7);
        Object[] objectArray = new Object[5];
        objectArray[0] = s_fontsArray[IFont.FONT_MAPPING[8]];
        objectArray[2] = s_fontsArray[IFont.FONT_MAPPING[7]];
        objectArray[3] = s_fontsArray[IFont.FONT_MAPPING[8]];
        objectArray[4] = s_fontsArray[IFont.FONT_MAPPING[8]];
        objectArray[1] = s_fontsArray[IFont.FONT_MAPPING[8]];
        s_mgInstance.setFonts(objectArray);
    }

    public void init() {
        Object object;
        FileManager.initialize(IResources.VOLUME_NAMES, IResources.VOLUME_TYPES, IResources.FILESYSTEM_NAMES, IResources.FILESYSTEM_SIZES);
        byte[] byArray = SDKInputStream.loadResourceAsByteArray("/hdr", null, 0);
        s_numLangsLoaded = SDKUtils.loadTextHeader(byArray);
        Debug.initDebug();
        s_soundManager = SDKSoundManager.getManager();
        s_soundManager.setLoader(this);
        s_soundManager.setSoundVolume(100);
        s_isVibrationSupported = s_soundManager.isVibrationSupported();
        if (!s_isVibrationSupported) {
            Menu.s_lockedStates[15] = true;
            Menu.s_lockedStates[14] = true;
            Menu.s_lockedStates[28] = true;
        }
        s_screenWidth = s_canvasInstance.getWidth();
        s_screenHeight = s_canvasInstance.getHeight();
        GameImpl.setIngameOffsets(0, 0, 0, 30);
        Rms.rmsLoad();
        int n = SDKUtils.chooseLanguage(s_currentLanguageState);
        if (n >= 0) {
            GameImpl.setLanguageState(n);
            s_isLanguageSelectionSkipped = true;
        } else {
            GameImpl.setLanguageState(-1 - n);
            s_isLanguageSelectionSkipped = false;
        }
        GameImpl.setState(0);
        String string = SDKMIDlet.getAppProp(BLOOD_PROPERTY_NAME);
        if (string != null) {
            if (string.equals("off")) {
                s_isBloodDrawn = false;
            } else if (string.equals(BLOOD_VALUE_RED)) {
                s_isBloodDrawn = true;
                s_isBloodRed = true;
            } else if (string.equals(BLOOD_VALUE_GREEN)) {
                s_isBloodDrawn = true;
                s_isBloodRed = false;
            }
        }
        if (!s_isBloodDrawn) {
            s_isFatalityOn = false;
        } else {
            object = SDKMIDlet.getAppProp(FATALITY_PROPERTY_NAME);
            if (object != null) {
                s_isFatalityOn = ((String)object).equals("on");
            }
        }
        if (SDKMIDlet.getAppProp(CHEATS_PROPERTY_NAME) != null && SDKMIDlet.getAppProp(CHEATS_PROPERTY_NAME).equals("on")) {
            s_areCheatcodesActivated = true;
        }
        s_midletVersionString = SDKMIDlet.getAppProp(MIDLET_VERSION_PROPERTY_NAME);
        object = SDKInputStream.loadResourceAsByteArray(11);
        Object object2 = SDKUtils.loadFont(SDKInputStream.loadImageObject(IFont.FONT_DATA[IFont.FONT_MAPPING[4]][2]), (byte[])object);
        s_highscoreLettersArray = (short[])((Object[])object2)[2];
        object = null;
        object2 = null;
    }

    public static void setIngameOffsets(int n, int n2, int n3, int n4) {
        s_ingameLeft = n;
        s_ingameTop = n2;
        s_ingameRight = s_screenWidth - n3;
        s_ingameBottom = s_screenHeight - n4;
        s_ingameWidth = s_ingameRight - s_ingameLeft;
        s_ingameHeight = s_ingameBottom - s_ingameTop;
        s_ingameCenterX = s_ingameLeft + s_ingameWidth / 2;
        s_ingameCenterY = s_ingameTop + s_ingameHeight / 2;
    }

    public static boolean isVibrationSupported() {
        return s_isVibrationSupported;
    }

    public static boolean getFatalityOn() {
        return s_isFatalityOn;
    }

    public static boolean getBloodDrawn() {
        return s_isBloodDrawn;
    }

    public static boolean getBloodRed() {
        return s_isBloodRed;
    }

    public byte[] loadResource(int n) {
        return SDKInputStream.loadResourceAsByteArray(n);
    }

    public static InputStream getResourceAsStream(String string) {
        return s_canvasInstance.getClass().getResourceAsStream(string);
    }

    public void update(long l) {
        s_elapsedTimeReal = s_elapsedTimeClamped = (int)(l - s_previousTime);
        if (s_elapsedTimeClamped > 100) {
            s_elapsedTimeClamped = 100;
        }
        s_previousTime = l;
        Sound.update();
        s_appStateStateTimer += s_elapsedTimeClamped;
        InputManager.updateKeyStates();
        Softkey.updateSoftKeys();
        Debug.updateDebug();
        switch (s_appStateState) {
            case 0: {
                s_previousTime = l;
                GameImpl.setState(1);
                break;
            }
            case 1: {
                if (s_appStateStateTimer <= 3000) break;
                GameImpl.setState(2);
                break;
            }
            case 2: {
                if (s_appStateStateTimer <= 2000) break;
                GameImpl.setState(3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Menu.updateMenu();
                break;
            }
            case 3: {
                if (s_appStateStateTimer <= 2000) break;
                if (s_isLanguageSelectionSkipped) {
                    GameImpl.setState(5);
                    break;
                }
                GameImpl.setState(4);
                break;
            }
            case 9: {
                if (s_menuOptionsNeedRefresh) {
                    Menu.s_lockedStates[20] = !s_mgInstance.isAvailable();
                    Menu.initState(0);
                    s_menuOptionsNeedRefresh = false;
                }
                Menu.updateMenu();
                break;
            }
            case 10: {
                if (s_mgInstance.isActive()) {
                    s_mgInstance.update();
                    break;
                }
                GameImpl.setState(9);
                Menu.setNewSelectedOption(Menu.getItemIdForState(20));
                break;
            }
            case 11: {
                Ingame.updateIngame();
            }
        }
    }

    public void draw(SDKGraphics sDKGraphics) {
        s_currentGraphics = sDKGraphics;
        this.clearScreen(s_currentGraphics, s_currentBackgroundColour);
        SDKUtils.setGraphics(s_currentGraphics);
        boolean bl = s_toggle = !s_toggle;
        if (s_toggle) {
            s_toggle2 = !s_toggle2;
        }
        switch (s_appStateState) {
            case 0: {
                break;
            }
            case 1: {
                s_splashEAAnimation.drawInstance(s_splashEAAnimationInstance, s_splashEATileset, s_screenWidth / 2, s_screenHeight / 2, 0);
                break;
            }
            case 2: {
                s_splashWBAnimation.drawInstance(s_splashWBAnimationInstance, s_splashWBTileset, s_screenWidth / 2, s_screenHeight / 2, 0);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Menu.drawMenu();
                Softkey.drawSoftKeys();
                break;
            }
            case 3: {
                s_titleScreenBackgroundAnimation.drawInstance(s_titleScreenBackgroundAnimationInstance, s_titleScreenBackgroundTileset, s_screenWidth / 2, s_screenHeight / 2, 0);
                s_titleScreenLogoAnimation.drawInstance(s_titleScreenLogoAnimationInstance, s_titleScreenLogoTileset, s_screenWidth / 2, s_screenHeight / 2, 0);
                break;
            }
            case 9: {
                Menu.drawMenu();
                Softkey.drawSoftKeys();
                break;
            }
            case 10: {
                if (!s_mgInstance.isActive()) break;
                s_mgInstance.paint(s_currentGraphics);
                break;
            }
            case 11: {
                Ingame.drawIngame(s_currentGraphics);
                Softkey.drawSoftKeys();
            }
        }
        Debug.drawDebug(sDKGraphics);
        if (s_platformRequest && ++s_counter > 2) {
            SDKUtils.platformRequest(s_platformRequestString);
        }
    }

    public void pause() {
        InputManager.clearKeyStates();
        if (s_appStateState == 11) {
            Ingame.launchPauseMenu();
            Battle.resetInputBuffers();
        }
        Sound.checkMusicInterruption();
    }

    public void resume() {
        InputManager.clearKeyStates();
        if (s_appStateState == 11) {
            Ingame.launchPauseMenu();
            Battle.resetInputBuffers();
        }
        Sound.checkMusicInterruption();
        Sound.resumeMusicInterruption();
    }

    public void exiting() {
        Sound.stopSound();
    }

    public static void setFullClip() {
        s_currentGraphics.setClip(0, 0, s_screenWidth, s_screenHeight);
    }

    public static void setIngameClip() {
        s_currentGraphics.setClip(s_ingameLeft, s_ingameTop, s_ingameWidth, s_ingameHeight);
    }

    public void appKeyPressed(int n, long l) {
        int n2;
        if (s_appStateState == 11 && Battle.isPauseMenuStateAvailable() && n == 524288) {
            Ingame.launchPauseMenuExit();
        } else if (s_appStateState == 11 && Battle.isPauseMenuStateAvailable() && n == 0x100000) {
            Ingame.launchPauseMenu();
        } else if (!(s_appStateState != 11 || Ingame.s_ingameState != 1 && Ingame.s_ingameState != 2 && Ingame.s_ingameState != 10 || n != 0x100000 && n != 524288)) {
            Ingame.ingameInitState(11);
        } else if (!(s_appStateState != 11 || Battle.isPauseMenuStateAvailable() || Menu.s_currentMenuState == 24 || n != 0x100000 && n != 524288 || Ingame.s_isInfoMenuLaunched)) {
            Menu.initState(24);
        } else if (s_appStateState == 9 && Menu.s_currentMenuState == 0 && n == 524288) {
            Menu.pushBackState(Menu.s_currentMenuState);
            Menu.initState(8);
        } else if (Ingame.s_isInfoMenuLaunched && (n == 0x100000 || n == 524288)) {
            Ingame.exitInfoMenu();
        } else if (!(s_appStateState != 11 || Battle.isPauseMenuStateAvailable() || n != 0x100000 && n != 524288)) {
            Menu.initState(23);
        } else if (s_appStateState == 9 && Menu.s_currentMenuState != 0 && n == 0x100000) {
            Menu.pushBackState(Menu.s_currentMenuState);
            Menu.initState(0);
        } else if (n == 0x200000) {
            n2 = s_soundManager.getSoundVolume();
            if ((n2 += 20) > 100) {
                n2 = 100;
            }
            s_soundManager.setSoundVolume(n2);
        } else if (n == 0x400000) {
            n2 = s_soundManager.getSoundVolume();
            if ((n2 -= 20) < 20) {
                n2 = 20;
            }
            s_soundManager.setSoundVolume(n2);
        } else {
            InputManager.keyPressed(n);
        }
        if ((s_appStateState == 9 || s_appStateState == 10) && (n2 = s_mgInstance.processKey(n)) == 1) {
            s_menuOptionsNeedRefresh = true;
        }
    }

    public void appKeyReleased(int n, long l) {
        InputManager.keyReleased(n);
    }

    public void appLetterPressed(int n, long l) {
        InputManager.letterPressed(n);
    }

    public void appLetterReleased(int n, long l) {
        InputManager.letterReleased(n);
    }

    public void appScreenChanged(int n, int n2) {
    }

    public void appPointerPressed(int n, int n2, long l) {
        if (s_appStateState == 10) {
            s_mgInstance.pointerPressed(n, n2);
        } else {
            InputManager.pointerPressed(n, n2);
        }
    }

    public void appPointerReleased(int n, int n2, long l) {
        if (s_appStateState == 10) {
            s_mgInstance.pointerReleased(n, n2);
        } else {
            InputManager.pointerReleased(n, n2);
        }
    }

    public void appPointerDragged(int n, int n2, long l) {
        InputManager.pointerDragged(n, n2);
    }

    public static void setState(int n) {
        s_nextState = n;
        GameImpl.appStateCleanupState(s_appStateState);
        GameImpl.appStateInitState(s_nextState);
        s_appStateState = s_nextState;
        s_appStateStateTimer = 0;
    }

    private static void appStateInitState(int n) {
        InputManager.clearKeyStates();
        switch (n) {
            case 0: {
                SDKUtils.loadStringsChunk(1);
                Softkey.initSoftkeys();
                break;
            }
            case 1: {
                try {
                    s_splashEATileset = FileManager.createTileset(167772273);
                    s_splashEAAnimation = Animation.loadAnimation(167772181, 1);
                    s_splashEAAnimationInstance = 1;
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                try {
                    s_splashWBTileset = FileManager.createTileset(0xA00007A);
                    s_splashWBAnimation = Animation.loadAnimation(0xA000022, 1);
                    s_splashWBAnimationInstance = 1;
                }
                catch (Exception exception) {}
                break;
            }
            case 4: {
                Menu.initMenu();
                s_soundManager.setCurrentLoop(1);
                s_soundManager.setPlaybackType(0);
                s_soundManager.playSound(62);
                s_soundManager.stopSounds();
                Menu.initState(11);
                break;
            }
            case 5: {
                if (s_isLanguageSelectionSkipped) {
                    Menu.initMenu();
                    s_soundManager.setCurrentLoop(1);
                    s_soundManager.setPlaybackType(0);
                    s_soundManager.playSound(62);
                    s_soundManager.stopSounds();
                }
                Menu.initState(13);
                break;
            }
            case 6: {
                Menu.initState(15);
                break;
            }
            case 7: {
                Menu.initState(17);
                break;
            }
            case 8: {
                Menu.initState(19);
                break;
            }
            case 3: {
                try {
                    s_titleScreenBackgroundTileset = FileManager.createTileset(167772280);
                    s_titleScreenLogoTileset = FileManager.createTileset(167772281);
                    s_titleScreenBackgroundAnimation = Animation.loadAnimation(0xA000020, 1);
                    s_titleScreenLogoAnimation = Animation.loadAnimation(167772193, 1);
                    s_titleScreenBackgroundAnimationInstance = 1;
                    s_titleScreenLogoAnimationInstance = 1;
                }
                catch (Exception exception) {}
                break;
            }
            case 9: {
                GameImpl.initMoreGames();
                Menu.initMenu();
                Menu.s_lockedStates[20] = !s_mgInstance.isAvailable();
                Menu.initState(0);
                InputManager.updateKeyStates();
                Menu.updateMenu();
                break;
            }
            case 10: {
                SDKUtils.loadStringsChunk(2);
                s_mgInstance.reset("mnu");
                Sound.stopSound();
                break;
            }
            case 11: {
                Softkey.setSoftkeys((byte)0, (byte)5);
                Ingame.initIngame();
            }
        }
    }

    public static void vibrate(int n) {
        if (s_currentVibrationState == 0) {
            s_soundManager.vibrate(n);
        }
    }

    public static void forceGarbageCollector() {
        try {
            System.gc();
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void appStateCleanupState(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                s_splashEATileset = null;
                s_splashEAAnimation = null;
                break;
            }
            case 2: {
                s_splashWBTileset = null;
                s_splashWBAnimation = null;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 3: {
                s_titleScreenBackgroundTileset = null;
                s_titleScreenLogoTileset = null;
                s_titleScreenBackgroundAnimation = null;
                s_titleScreenLogoAnimation = null;
                break;
            }
            case 9: {
                Menu.cleanupMenuResources();
                GameImpl.cleanupFont((byte)8);
                GameImpl.cleanupFont((byte)7);
                GameImpl.cleanupFont((byte)6);
                if (s_nextState == 10) break;
                s_mgInstance = null;
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                Ingame.cleanupIngame();
            }
        }
    }

    private void clearScreen(SDKGraphics sDKGraphics, int n) {
        sDKGraphics.setColor(n);
        sDKGraphics.fillRect(0, 0, s_screenWidth, s_screenHeight);
    }

    static {
        s_currentVibrationState = 0;
        s_currentSoundState = 0;
        s_currentLanguageState = -1;
        s_currentControlsState = 0;
        s_currentDifficultyState = 1;
        s_appStateState = -1;
        s_currentBackgroundColour = 0;
        s_menuOptionsNeedRefresh = false;
        s_platformRequestString = "";
        s_platformRequest = false;
        s_counter = 0;
        s_fontsArray = new Object[9];
        s_isFatalityOn = true;
        s_areCheatcodesActivated = false;
        s_isBloodDrawn = true;
        s_isBloodRed = true;
        s_isFirstLaunch = true;
    }
}

