/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.GameImpl;
import com.ea.game.Tileset;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKImageMIDP2;
import com.ea.sdk.SDKUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class FileManager {
    static final int VOLUME_TYPE_FILESYSTEM = 0;
    static final int VOLUME_TYPE_BIGFILE = 1;
    private static final int FILEREF_CHUNK_TYPE_UTF8 = 0;
    private static final int FILEREF_CHUNK_TYPE_UBYTE = 1;
    private static final int FILEREF_CHUNK_TYPE_USHORT = 2;
    private static final int FILEREF_CHUNK_TYPE_UINT = 4;
    public static final byte PALETTE_EFFECT_CACHE_OFFSET = 24;
    public static final byte PALETTE_EFFECT_NONE = 0;
    public static final byte PALETTE_EFFECT_DARKER = 1;
    public static final byte PALETTE_EFFECT_LIGHTER = 2;
    public static final byte PALETTE_EFFECT_GREEN_BLOOD = 3;
    public static final int USE_ORIGINAL_PALETTE = -1;
    private static final int DARKER_EFFECT_FACTOR = 5;
    private static final int LIGHTER_EFFECT_FACTOR = 16;
    private static final int GREEN_EFFECT_RED_FACTOR = 4;
    private static final int GREEN_EFFECT_GREEN_FACTOR = 7;
    private static final int EFFECTS_DIVIDER = 10;
    private static final int MAXIMUM_COLOUR_VALUE = 255;
    private static final int PALETTE_OFFSET = 3;
    private static final int RED_OFFSET = 0;
    private static final int GREEN_OFFSET = 1;
    private static final int BLUE_OFFSET = 2;
    private static String[] s_volumeNamesArray;
    static int[] s_volumeTypesArray;
    static byte[][] s_volumeBufferArray;
    static String[] s_systemFileNamesArray;
    private static int[] s_systemFileSizeArray;
    private static int s_lastFileSize;
    public static int s_lastImageStart;
    public static int s_lastImageLength;
    public static int s_lastVolumeId;
    public static byte[] s_lastUsedPalette;
    private static final boolean DEFAULT_PRETRANSFORM = true;

    public static void initialize(String[] stringArray, int[] nArray, String[] stringArray2, int[] nArray2) {
        s_volumeNamesArray = stringArray;
        s_volumeTypesArray = nArray;
        s_volumeBufferArray = new byte[stringArray.length][];
        s_systemFileNamesArray = stringArray2;
        s_systemFileSizeArray = nArray2;
    }

    public static void cleanup() {
        for (int i = 0; i < s_volumeBufferArray.length; ++i) {
            FileManager.s_volumeBufferArray[i] = null;
        }
        GameImpl.forceGarbageCollector();
    }

    static int getVolumeId(int n) {
        return n >>> 24;
    }

    static int getFileIndex(int n) {
        return n & 0xFFFFFF;
    }

    static void openVolume(int n) throws IOException {
        if (s_volumeBufferArray[n] == null) {
            DataInputStream dataInputStream = FileManager.openFileAsStream(s_volumeNamesArray[n]);
            int n2 = dataInputStream.readInt();
            FileManager.s_volumeBufferArray[n] = new byte[n2];
            dataInputStream.readFully(s_volumeBufferArray[n]);
            dataInputStream.close();
            dataInputStream = null;
        }
    }

    public static DataInputStream openFileAsStream(int n) throws IOException {
        int n2 = FileManager.getFileIndex(n);
        int n3 = FileManager.getVolumeId(n);
        int n4 = s_volumeTypesArray[n3];
        DataInputStream dataInputStream = null;
        if (n4 == 0) {
            String string = s_systemFileNamesArray[n2];
            dataInputStream = FileManager.openFileAsStream(string);
        } else if (n4 == 1) {
            FileManager.openVolume(n3);
            dataInputStream = new DataInputStream(new ByteArrayInputStream(s_volumeBufferArray[n3]));
            int n5 = dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.skipBytes(n2 << 3);
            s_lastFileSize = dataInputStream.readInt();
            int n6 = dataInputStream.readInt();
            dataInputStream.reset();
            dataInputStream.skipBytes(4 + n5 + 4 + n6);
        }
        return dataInputStream;
    }

    public static DataInputStream openFileAsStream(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
        if (string.indexOf(47) != 0) {
            stringBuffer.append('/');
        }
        stringBuffer.append(string);
        InputStream inputStream = GameImpl.getResourceAsStream(stringBuffer.toString());
        return new DataInputStream(inputStream);
    }

    public static int readFilerefChunkIntegerValue(DataInputStream dataInputStream) throws IOException {
        int n = -1;
        int n2 = dataInputStream.readUnsignedByte();
        switch (n2) {
            case 1: {
                n = dataInputStream.readUnsignedByte();
                n = (n & 0xC0) << 18 | n & 0x3F;
                break;
            }
            case 2: {
                n = dataInputStream.readUnsignedShort();
                n = (n & 0xF000) << 12 | n & 0xFFF;
                break;
            }
            case 4: {
                n = dataInputStream.readInt();
            }
        }
        return n;
    }

    public static Tileset createTileset(int n) throws IOException {
        return FileManager.createTileset(n, -1, (byte)0, false, true);
    }

    public static Tileset createTileset(int n, boolean bl) throws IOException {
        return FileManager.createTileset(n, -1, (byte)0, false, bl);
    }

    public static Tileset createTileset(int n, int n2) throws IOException {
        return FileManager.createTileset(n, n2, (byte)0, false, true);
    }

    public static Tileset createTileset(int n, byte by) throws IOException {
        return FileManager.createTileset(n, -1, by, false, true);
    }

    public static Tileset createTileset(int n, int n2, byte by, boolean bl, boolean bl2) throws IOException {
        int[] nArray = new int[]{n2};
        byte[] byArray = new byte[]{by};
        return FileManager.createTileset(n, nArray, byArray, bl, bl2);
    }

    public static Tileset createTileset(int n, int[] nArray, byte[] byArray, boolean bl, boolean bl2) throws IOException {
        int n2;
        DataInputStream dataInputStream = FileManager.openFileAsStream(n);
        int n3 = FileManager.readFilerefChunkIntegerValue(dataInputStream);
        int n4 = dataInputStream.readUnsignedByte();
        long[] lArray = new long[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            lArray[n2] = dataInputStream.readLong();
        }
        n2 = dataInputStream.readUnsignedByte();
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = (byte)dataInputStream.readUnsignedByte();
            byArray3[i] = (byte)dataInputStream.readUnsignedByte();
        }
        dataInputStream.close();
        dataInputStream = null;
        Tileset tileset = Tileset.createTileset(n3, lArray, byArray2, byArray3, nArray, byArray, bl, bl2);
        return tileset;
    }

    public static SDKImage createSDKImage(int n, int n2, byte by) throws IOException {
        SDKImage sDKImage = null;
        int n3 = FileManager.getFileIndex(n);
        int n4 = FileManager.getVolumeId(n);
        int n5 = s_volumeTypesArray[n4];
        if (n5 == 0) {
            String string = s_systemFileNamesArray[n3];
            sDKImage = SDKUtils.createImage("/" + string);
        } else {
            FileManager.openVolume(n4);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(s_volumeBufferArray[n4]));
            int n6 = dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.skipBytes(n3 << 3);
            int n7 = dataInputStream.readInt();
            int n8 = dataInputStream.readInt();
            int n9 = 4 + n6 + 4 + n8;
            dataInputStream.close();
            dataInputStream = null;
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (n2 != -1 || by != 0) {
                byArray = FileManager.getPaletteData(s_volumeBufferArray[n4], n9, n7);
            }
            if (n2 != -1) {
                byArray2 = FileManager.readResourcePalette(n2);
            }
            if (by != 0) {
                if (byArray2 == null) {
                    byArray2 = new byte[byArray.length];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                }
                FileManager.applyPaletteEffect(byArray2, by);
            }
            if (byArray2 != null) {
                FileManager.changePalette(s_volumeBufferArray[n4], n9, n7, byArray2);
            }
            sDKImage = SDKUtils.createImage(s_volumeBufferArray[n4], n9, n7);
            if (byArray != null) {
                FileManager.changePalette(s_volumeBufferArray[n4], n9, n7, byArray);
            }
            s_lastImageStart = n9;
            s_lastImageLength = n7;
            s_lastVolumeId = n4;
            s_lastUsedPalette = byArray2;
        }
        return sDKImage;
    }

    public static Image createImage(int n, int n2, byte by) throws IOException {
        Image image = null;
        int n3 = FileManager.getFileIndex(n);
        int n4 = FileManager.getVolumeId(n);
        int n5 = s_volumeTypesArray[n4];
        if (n5 == 0) {
            String string = s_systemFileNamesArray[n3];
            image = Image.createImage((String)("/" + string));
        } else {
            FileManager.openVolume(n4);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(s_volumeBufferArray[n4]));
            int n6 = dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.skipBytes(n3 << 3);
            int n7 = dataInputStream.readInt();
            int n8 = dataInputStream.readInt();
            int n9 = 4 + n6 + 4 + n8;
            dataInputStream.close();
            dataInputStream = null;
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (n2 != -1 || by != 0) {
                byArray = FileManager.getPaletteData(s_volumeBufferArray[n4], n9, n7);
            }
            if (n2 != -1) {
                byArray2 = FileManager.readResourcePalette(n2);
            }
            if (by != 0) {
                if (byArray2 == null) {
                    byArray2 = new byte[byArray.length];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                }
                FileManager.applyPaletteEffect(byArray2, by);
            }
            if (byArray2 != null) {
                FileManager.changePalette(s_volumeBufferArray[n4], n9, n7, byArray2);
            }
            image = Image.createImage((byte[])s_volumeBufferArray[n4], (int)n9, (int)n7);
            if (byArray != null) {
                FileManager.changePalette(s_volumeBufferArray[n4], n9, n7, byArray);
            }
            s_lastImageStart = n9;
            s_lastImageLength = n7;
            s_lastVolumeId = n4;
            s_lastUsedPalette = byArray2;
        }
        return image;
    }

    public static SDKImage createSDKImageFromImage(Image image, int n, int n2, int n3, int n4, int n5) {
        Image image2 = Image.createImage((Image)image, (int)n, (int)n2, (int)n3, (int)n4, (int)n5);
        SDKImageMIDP2 sDKImageMIDP2 = new SDKImageMIDP2();
        sDKImageMIDP2.init(image2);
        return sDKImageMIDP2;
    }

    public static void changePalette(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = FileManager.getPNGPaletteStart(byArray, n, n2);
        int n4 = FileManager.getPNGPaletteEnd(byArray, n3);
        int n5 = n4 - n3;
        if (byArray2.length < n5) {
            n5 = byArray2.length;
        }
        for (int i = 0; i < n5; ++i) {
            byArray[i + n3] = byArray2[i];
        }
        FileManager.setPNGCRC(byArray, n3);
    }

    public static byte[] getPaletteData(byte[] byArray, int n, int n2) {
        int n3 = FileManager.getPNGPaletteStart(byArray, n, n2);
        int n4 = FileManager.getPNGPaletteEnd(byArray, n3);
        byte[] byArray2 = new byte[n4 - n3];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray[n3 + i];
        }
        return byArray2;
    }

    public static void applyPaletteEffect(byte[] byArray, byte by) {
        for (int i = 0; i < byArray.length - 3; i += 3) {
            int n = byArray[i + 0] & 0xFF;
            int n2 = byArray[i + 1] & 0xFF;
            int n3 = byArray[i + 2] & 0xFF;
            switch (by) {
                case 1: {
                    n = n * 5 / 10;
                    n2 = n2 * 5 / 10;
                    n3 = n3 * 5 / 10;
                    break;
                }
                case 2: {
                    n = n * 16 / 10;
                    n = Math.min(255, n);
                    n2 = n2 * 16 / 10;
                    n2 = Math.min(255, n2);
                    n3 = n3 * 16 / 10;
                    n3 = Math.min(255, n3);
                    break;
                }
                case 3: {
                    n2 = n * 7 / 10;
                    n = n * 4 / 10;
                }
            }
            byArray[i + 0] = (byte)n;
            byArray[i + 1] = (byte)n2;
            byArray[i + 2] = (byte)n3;
        }
    }

    public static byte[] readResourcePalette(int n) {
        byte[] byArray = null;
        try {
            DataInputStream dataInputStream = FileManager.openFileAsStream(n);
            byArray = new byte[s_lastFileSize];
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            dataInputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private static int getPNGPaletteEnd(byte[] byArray, int n) {
        int n2 = n;
        while (!(byArray[n2 + 2] == 116 && byArray[n2 + 3] == 82 && byArray[n2 + 4] == 78 && byArray[n2 + 5] == 83 || byArray[n2 + 2] == 73 && byArray[n2 + 3] == 68 && byArray[n2 + 4] == 65 && byArray[n2 + 5] == 84)) {
            ++n2;
        }
        return n2;
    }

    private static int getPNGPaletteStart(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2 - 4; ++i) {
            if (byArray[i + 0] != 80 || byArray[i + 1] != 76 || byArray[i + 2] != 84 || byArray[i + 3] != 69) continue;
            return i + 4;
        }
        return 0;
    }

    private static void setPNGCRC(byte[] byArray, int n) {
        int n2 = (byArray[n - 8] & 0xFF) << 24 | (byArray[n - 7] & 0xFF) << 16 | (byArray[n - 6] & 0xFF) << 8 | byArray[n - 5] & 0xFF;
        long[] lArray = new long[256];
        for (int i = 0; i < 256; ++i) {
            long l = i;
            for (int j = 0; j < 8; ++j) {
                if ((l & 1L) != 0L) {
                    l = 0xEDB88320L ^ l >> 1;
                    continue;
                }
                l >>= 1;
            }
            lArray[i] = l;
        }
        long l = 0xFFFFFFFFL;
        for (int i = 0; i < n2 + 4; ++i) {
            l = lArray[(int)(l ^ (long)byArray[n - 4 + i] & 0xFFL) & 0xFF] ^ l >> 8;
        }
        byArray[n + n2 + 0] = (byte)((l ^= 0xFFFFFFFFL) >> 24 & 0xFFL);
        byArray[n + n2 + 1] = (byte)(l >> 16 & 0xFFL);
        byArray[n + n2 + 2] = (byte)(l >> 8 & 0xFFL);
        byArray[n + n2 + 3] = (byte)(l & 0xFFL);
    }
}

