/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.ICharacterSelection;
import com.ea.game.IFighter;
import com.ea.game.InputManager;
import com.ea.game.MathTools;
import com.ea.game.Softkey;
import com.ea.game.Sound;
import com.ea.game.Tileset;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class CharacterSelection {
    public static final int CHARACTER_STATE_NORMAL = 0;
    private static final int CHARACTER_STATE_RANDOM = 1;
    private static final int CHARACTER_STATE_SELECTED = 2;
    private static final int SELECTION_BLINKING_DURATION = 1000;
    private static int s_selectionBlinkingTimer;
    private static int s_currentCharacterState;
    private static final int SELECTION_COLOUR = 0xFF0000;
    private static final int SELECTION_SELECTED_COLOUR = 0xFFFFFF;
    private static int s_currentSelectionFrameColour;
    private static boolean s_isCharacterSelectionOver;
    public static boolean s_isCharacterSelectionBackToMenu;
    private static byte s_randomCharacterSlotFinal;
    private static byte s_randomCharacterSlotCurrent;
    private static final int RANDOMIZING_TIME = 1000;
    private static int s_randomizingTimer;
    private static byte s_currentAcceptSoftkeyType;
    private static byte s_currentCancelSoftkeyType;
    private static int s_characterDataWidth;
    private static int s_characterDataHeight;
    private static SDKString s_currentCharacterName;
    private static int s_characterNameY;
    private static int s_fighterPreviewX;
    private static int s_fighterPreviewY;
    private static Tileset s_fighterTileset;
    private static Animation s_fighterAnimation;
    private static Animation s_fighterAnimationStand;
    private static Animation s_fighterAnimationWinning;
    private static int s_fighterAnimationInstance;
    private static int s_fighterPreviewTimer;
    private static final int FIGHTER_PREVIEW_DELAY = 700;
    private static boolean s_isFighterPreviewLoaded;
    private static final int CHARACTER_TILESET_HEADER = 0;
    private static final int CHARACTER_TILESET_AVATARS = 1;
    private static final int CHARACTER_TILESET_BG = 2;
    private static final int[] CHARACTER_TILESET;
    private static Tileset[] s_characterTileset;
    private static final int CHARACTER_ANIMATION_HEADER = 0;
    private static final int CHARACTER_ANIMATION_AVATAR_DRAGON_GRAY = 1;
    private static final int CHARACTER_ANIMATION_AVATAR_DRAGON_RANDOM = 2;
    private static final int CHARACTER_ANIMATION_BG = 3;
    private static final int[] CHARACTER_ANIMATION;
    private static final int[] CHARACTER_ANIMATION_TILESETS;
    private static final int TOUCH_AVATAR_COLOUR = 65280;
    private static Animation[] s_characterAnimation;
    private static Animation[] s_avatarsAnimation;
    private static int s_avatarsSize;
    private static int s_avatarsSpace;
    private static int[] s_avatarsAnimationInstance;
    private static int[] s_characterAnimationWidth;
    private static int[] s_characterAnimationHeight;
    private static int[] s_characterAnimationInstance;
    private static int s_characterHeaderY;
    private static SDKString s_currentCharacterHeader;
    private static byte s_currentSelectedSlot;
    private static int s_characterDataOffsetX;
    private static int s_characterDataOffsetY;

    public static void initCharacterSelection() {
        s_characterHeaderY = 6;
        s_currentCharacterHeader = SDKUtils.getString(25, null);
        try {
            int n;
            s_characterTileset = new Tileset[CHARACTER_TILESET.length];
            for (n = 0; n < CHARACTER_TILESET.length; ++n) {
                CharacterSelection.s_characterTileset[n] = n == 2 ? FileManager.createTileset(CHARACTER_TILESET[n], 167772269, (byte)0, false, false) : FileManager.createTileset(CHARACTER_TILESET[n]);
            }
            s_characterAnimation = new Animation[CHARACTER_ANIMATION.length];
            s_characterAnimationInstance = new int[CHARACTER_ANIMATION.length];
            s_characterAnimationWidth = new int[CHARACTER_ANIMATION.length];
            s_characterAnimationHeight = new int[CHARACTER_ANIMATION.length];
            for (n = 0; n < CHARACTER_ANIMATION.length; ++n) {
                CharacterSelection.s_characterAnimation[n] = Animation.loadAnimation(CHARACTER_ANIMATION[n], 1);
                CharacterSelection.s_characterAnimationInstance[n] = 1;
                CharacterSelection.s_characterAnimationWidth[n] = s_characterAnimation[n].computeGlobalWidth(s_characterTileset[CHARACTER_ANIMATION_TILESETS[n]]);
                CharacterSelection.s_characterAnimationHeight[n] = s_characterAnimation[n].computeGlobalHeight(s_characterTileset[CHARACTER_ANIMATION_TILESETS[n]]);
            }
            s_avatarsAnimation = new Animation[IFighter.FIGHTERS_AVATARS_ANIMATIONS.length];
            s_avatarsAnimationInstance = new int[IFighter.FIGHTERS_AVATARS_ANIMATIONS.length];
            s_avatarsSize = s_characterAnimationWidth[1];
            s_avatarsSpace = 5;
            for (n = 0; n < IFighter.FIGHTERS_AVATARS_ANIMATIONS.length; ++n) {
                CharacterSelection.s_avatarsAnimation[n] = Animation.loadAnimation(IFighter.FIGHTERS_AVATARS_ANIMATIONS[n], 1);
                CharacterSelection.s_avatarsAnimationInstance[n] = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_isCharacterSelectionOver = false;
        s_isCharacterSelectionBackToMenu = false;
        s_isFighterPreviewLoaded = false;
        s_fighterPreviewTimer = 0;
        CharacterSelection.setCharacterState(0);
        CharacterSelection.setCurrentSelectedSlot((byte)0);
        CharacterSelection.setupAvaterSelectionTable();
        FileManager.cleanup();
    }

    private static byte getRandomCharacterSlot() {
        byte by = s_currentSelectedSlot;
        while (!CharacterSelection.isSlotWithAvatar(by = (byte)MathTools.getRandomInt(0, ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY.length - 1)) || s_currentSelectedSlot == by) {
        }
        return by;
    }

    private static void setCharacterState(int n) {
        s_currentCharacterState = n;
        s_currentAcceptSoftkeyType = 1;
        s_currentCancelSoftkeyType = (byte)4;
        switch (s_currentCharacterState) {
            case 0: {
                s_currentSelectionFrameColour = 0xFF0000;
                break;
            }
            case 1: {
                s_currentSelectionFrameColour = 0xFF0000;
                s_randomCharacterSlotCurrent = CharacterSelection.getRandomCharacterSlot();
                s_randomCharacterSlotFinal = CharacterSelection.getRandomCharacterSlot();
                CharacterSelection.setCurrentSelectedSlot(s_randomCharacterSlotCurrent);
                s_currentAcceptSoftkeyType = 0;
                s_currentCancelSoftkeyType = 0;
                s_randomizingTimer = 0;
                break;
            }
            case 2: {
                s_currentSelectionFrameColour = 0xFFFFFF;
                s_selectionBlinkingTimer = 0;
                s_currentAcceptSoftkeyType = 0;
                s_currentCancelSoftkeyType = 0;
            }
        }
    }

    private static void drawCharacterBackground() {
        for (int i = 0; i < GameImpl.s_screenWidth; i += s_characterAnimationWidth[3]) {
            for (int j = 0; j < GameImpl.s_screenHeight; j += s_characterAnimationHeight[3]) {
                CharacterSelection.drawCharacterAnimation(3, i, j);
            }
        }
    }

    private static void drawCharacterHeader() {
        for (int i = 0; i <= GameImpl.s_screenWidth; i += s_characterAnimationWidth[0]) {
            CharacterSelection.drawCharacterAnimation(0, i, 0);
        }
        GameImpl.setFont((byte)4);
        SDKUtils.drawString(s_currentCharacterHeader, GameImpl.s_screenWidth / 2, s_characterHeaderY, 17);
    }

    private static void drawCharacterAnimation(int n, int n2, int n3) {
        s_characterAnimation[n].drawInstance(s_characterAnimationInstance[n], s_characterTileset[CHARACTER_ANIMATION_TILESETS[n]], n2, n3, 0);
    }

    public static void setCurrentSelectedSlot(byte by) {
        s_currentSelectedSlot = by;
        s_currentAcceptSoftkeyType = 1;
        s_currentCancelSoftkeyType = (byte)4;
        s_isFighterPreviewLoaded = false;
        s_fighterPreviewTimer = 0;
        if (CharacterSelection.isSlotWithAvatar(by)) {
            s_currentCharacterName = SDKUtils.getString(IFighter.FIGHTER_NAMES[ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[s_currentSelectedSlot][0]], null);
        } else {
            s_currentCharacterName = new SDKString("");
            if (ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[by][1] == 1) {
                s_currentAcceptSoftkeyType = 0;
            }
        }
    }

    private static void drawCharacterAvatar(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 0: {
                s_avatarsAnimation[n].drawInstance(s_avatarsAnimationInstance[n], s_characterTileset[1], n3, n4, 0);
                break;
            }
            case 1: {
                s_characterAnimation[1].drawInstance(s_avatarsAnimationInstance[1], s_characterTileset[1], n3, n4, 0);
                break;
            }
            case 2: {
                s_characterAnimation[2].drawInstance(s_avatarsAnimationInstance[2], s_characterTileset[1], n3, n4, 0);
            }
        }
    }

    public static void cleanUpCharacterSelection() {
        s_characterAnimation = null;
        s_characterTileset = null;
        s_avatarsAnimation = null;
        s_fighterTileset = null;
        s_fighterAnimation = null;
        s_fighterAnimationStand = null;
        s_fighterAnimationWinning = null;
    }

    private static int calculateRealAvatarCoordinate(byte by) {
        return by * (s_avatarsSize + s_avatarsSpace);
    }

    public static void setupAvaterSelectionTable() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY.length; ++i) {
            n = Math.max(n, CharacterSelection.calculateRealAvatarCoordinate(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[i][2]));
            n2 = Math.max(n2, CharacterSelection.calculateRealAvatarCoordinate(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[i][3]));
        }
        s_characterDataWidth = n + s_avatarsSize;
        s_characterDataHeight = n2 + s_avatarsSize;
        s_characterDataOffsetX = GameImpl.s_screenWidth - s_characterDataWidth - 12;
        s_characterDataOffsetY = s_characterHeaderY + (GameImpl.s_screenHeight - Softkey.getSoftkeyHeight() - s_characterHeaderY - s_characterDataHeight) / 2;
        GameImpl.setFont((byte)4);
        s_characterNameY = GameImpl.s_screenHeight - Softkey.getSoftkeyHeight() - SDKUtils.getLineSize();
        s_fighterPreviewX = s_characterDataOffsetX / 2;
        s_fighterPreviewY = s_characterDataOffsetY + s_characterDataHeight;
    }

    private static void loadFighterPreview(int n) {
        try {
            s_fighterPreviewTimer = 0;
            s_fighterTileset = FileManager.createTileset(IFighter.FIGHTERS_TILESETS[n]);
            s_fighterAnimationWinning = Animation.loadAnimation(IFighter.FIGHTERS_COMMON_ANIMATIONS[n][66], 0);
            s_fighterAnimationStand = Animation.loadAnimation(IFighter.FIGHTERS_COMMON_ANIMATIONS[n][0], 1);
            s_isFighterPreviewLoaded = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileManager.cleanup();
    }

    private static void setFighterAnimationStand() {
        s_fighterAnimation = s_fighterAnimationStand;
        s_fighterAnimationInstance = 1;
    }

    private static void setFighterAnimationWinning() {
        s_fighterAnimation = s_fighterAnimationWinning;
        s_fighterAnimationInstance = 1;
    }

    private static boolean isSlotWithAvatar(byte by) {
        boolean bl = false;
        if (ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[by][1] == 0 || ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[by][1] == 1 && GameImpl.isShaoKahnUnlocked()) {
            bl = true;
        }
        return bl;
    }

    private static void updateTouchpad() {
    }

    public static void updateCharacterSelection() {
        CharacterSelection.updateTouchpad();
        switch (s_currentCharacterState) {
            case 0: {
                if (InputManager.s_isKeyLeftPressed) {
                    CharacterSelection.setCurrentSelectedSlot(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[s_currentSelectedSlot][4]);
                }
                if (InputManager.s_isKeyRightPressed) {
                    CharacterSelection.setCurrentSelectedSlot(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[s_currentSelectedSlot][5]);
                }
                if (InputManager.s_isKeyUpPressed) {
                    CharacterSelection.setCurrentSelectedSlot(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[s_currentSelectedSlot][6]);
                }
                if (InputManager.s_isKeyDownPressed) {
                    CharacterSelection.setCurrentSelectedSlot(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[s_currentSelectedSlot][7]);
                }
                if (InputManager.s_isKeyCancelPressed) {
                    s_isCharacterSelectionBackToMenu = true;
                }
                if (InputManager.s_isKeyAcceptPressed || InputManager.s_isKeyCenterPressed) {
                    switch (ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[s_currentSelectedSlot][1]) {
                        case 0: 
                        case 1: {
                            if (!CharacterSelection.isSlotWithAvatar(s_currentSelectedSlot)) break;
                            Sound.playSFX(IFighter.FIGHTERS_SFX_NAMES[CharacterSelection.getSelectedFighterId()]);
                            CharacterSelection.setCharacterState(2);
                            if (!s_isFighterPreviewLoaded) {
                                CharacterSelection.loadFighterPreview(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[s_currentSelectedSlot][0]);
                            }
                            CharacterSelection.setFighterAnimationWinning();
                            return;
                        }
                        case 2: {
                            CharacterSelection.setCharacterState(1);
                            return;
                        }
                    }
                }
                if (s_isFighterPreviewLoaded || (s_fighterPreviewTimer += GameImpl.s_elapsedTimeClamped) <= 700) break;
                if (CharacterSelection.isSlotWithAvatar(s_currentSelectedSlot)) {
                    CharacterSelection.loadFighterPreview(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[s_currentSelectedSlot][0]);
                    CharacterSelection.setFighterAnimationStand();
                    break;
                }
                s_fighterPreviewTimer = 0;
                break;
            }
            case 1: {
                if ((s_randomizingTimer += GameImpl.s_elapsedTimeClamped) > 1000) {
                    CharacterSelection.setCurrentSelectedSlot(s_randomCharacterSlotFinal);
                    Sound.playSFX(IFighter.FIGHTERS_SFX_NAMES[CharacterSelection.getSelectedFighterId()]);
                    CharacterSelection.setCharacterState(2);
                    if (!s_isFighterPreviewLoaded) {
                        CharacterSelection.loadFighterPreview(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[s_currentSelectedSlot][0]);
                    }
                    CharacterSelection.setFighterAnimationWinning();
                    break;
                }
                s_randomCharacterSlotCurrent = CharacterSelection.getRandomCharacterSlot();
                CharacterSelection.setCurrentSelectedSlot(s_randomCharacterSlotCurrent);
                break;
            }
            case 2: {
                int n = s_currentSelectionFrameColour = s_currentSelectionFrameColour == 0xFF0000 ? 0xFFFFFF : 0xFF0000;
                if ((s_selectionBlinkingTimer += GameImpl.s_elapsedTimeClamped) - Sound.getLastSFXLagDelay() <= 1000) break;
                Sound.resetLastSFXLag();
                s_isCharacterSelectionOver = true;
            }
        }
        if (s_isFighterPreviewLoaded) {
            s_fighterAnimationInstance = s_fighterAnimation.updateInstance(s_fighterAnimationInstance, GameImpl.s_elapsedTimeClamped);
        }
        Softkey.setSoftkeys(s_currentAcceptSoftkeyType, s_currentCancelSoftkeyType);
    }

    private static void drawSelectionBar(int n) {
        GameImpl.s_currentGraphics.setColor(s_currentSelectionFrameColour);
        GameImpl.s_currentGraphics.fillRect(CharacterSelection.calculateRealAvatarCoordinate(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[n][2]) + s_characterDataOffsetX - 3, CharacterSelection.calculateRealAvatarCoordinate(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[n][3]) + s_characterDataOffsetY - 3, s_avatarsSize + 6, s_avatarsSize + 6);
    }

    private static void drawCharacterData() {
        for (byte by = 0; by < ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY.length; by = (byte)(by + 1)) {
            CharacterSelection.drawCharacterAvatar(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[by][0], CharacterSelection.isSlotWithAvatar(by) ? (byte)0 : ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[by][1], CharacterSelection.calculateRealAvatarCoordinate(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[by][2]) + s_characterDataOffsetX, CharacterSelection.calculateRealAvatarCoordinate(ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[by][3]) + s_characterDataOffsetY);
        }
    }

    public static void drawCharacterSelection() {
        CharacterSelection.drawCharacterBackground();
        CharacterSelection.drawCharacterHeader();
        CharacterSelection.drawSelectionBar(s_currentSelectedSlot);
        CharacterSelection.drawCharacterData();
        GameImpl.setFont((byte)4);
        SDKUtils.drawString(s_currentCharacterName, GameImpl.s_screenWidth / 2, s_characterNameY, 17);
        if (s_isFighterPreviewLoaded) {
            s_fighterAnimation.drawInstance(s_fighterAnimationInstance, s_fighterTileset, s_fighterPreviewX, s_fighterPreviewY, 0);
        }
    }

    public static boolean isCharacterSelectionOver() {
        return s_isCharacterSelectionOver;
    }

    public static boolean isCharacterSelectionBack() {
        return s_isCharacterSelectionBackToMenu;
    }

    public static int getSelectedFighterId() {
        return ICharacterSelection.CHARACTER_SELECTION_DATA_ARRAY[s_currentSelectedSlot][0];
    }

    static {
        CHARACTER_TILESET = new int[]{167772275, 0xA000070, 167772274};
        CHARACTER_ANIMATION = new int[]{167772189, 0xA000007, 0xA000008, 167772184};
        CHARACTER_ANIMATION_TILESETS = new int[]{0, 1, 1, 2};
    }
}

