/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.IArena;
import com.ea.game.Tileset;
import com.ea.sdk.SDKImage;
import java.io.DataInputStream;

public class Arena {
    public static byte s_currentArenaId;
    public static Tileset s_arenaTileset;
    public static byte[][] s_layerTilemap;
    public static byte[] s_tilemapCols;
    public static byte[] s_tilemapRows;
    public static int[] s_tilemapWidth;
    public static int[] s_tilemapHeight;
    public static int[] s_layerBaseOffsetX;
    public static int[] s_layerBaseOffsetY;
    public static int[] s_layerCurrentOffsetX;
    public static int[] s_layerCurrentOffsetY;
    public static int s_currentArenaLeft;
    public static int s_currentArenaRight;
    public static int s_currentArenaTop;
    public static int s_currentArenaBottom;
    public static int s_currentArenaPhysicsBoundaryLeft;
    public static int s_currentArenaPhysicsBoundaryRight;
    public static final int ARENA_IMAGE_STANDARD = 0;
    public static final int ARENA_IMAGE_FATALITY = 1;
    private static final int ARENA_IMAGE_BOTH = -1;
    private static Tileset s_miscTileset;
    private static Animation s_miscAnimation;
    private static int s_miscAnimationInstance;
    private static int s_miscAnimationX;
    private static int s_miscAnimationY;
    private static int s_currentArenaImageId;
    private static int s_currentArenaTopBottomOffset;
    private static int s_currentArenaTopBottomOffsetVirtual;
    private static final boolean IS_ARENA_PRETRANSFORM_ENABLED = true;
    public static SDKImage[][] s_arena_background_layer;
    private static final int[] ARENA_PALETTES;
    private static final byte[] ARENA_EFFECTS;

    public static void cleanupArena() {
        s_arenaTileset = null;
        s_miscTileset = null;
        s_miscAnimation = null;
    }

    public static void updateArena() {
    }

    private static void updateArenaObjects() {
        switch (s_currentArenaId) {
            case 4: {
                s_miscAnimationInstance = s_miscAnimation.updateInstance(s_miscAnimationInstance, GameImpl.s_elapsedTimeClamped);
                s_miscAnimationX = -s_layerCurrentOffsetX[1] + 264 + GameImpl.s_ingameLeft;
                s_miscAnimationY = -s_layerCurrentOffsetY[1] + 192 + GameImpl.s_ingameTop;
                break;
            }
            case 3: {
                s_miscAnimationInstance = s_miscAnimation.updateInstance(s_miscAnimationInstance, GameImpl.s_elapsedTimeClamped);
                break;
            }
            case 2: {
                s_miscAnimationInstance = s_miscAnimation.updateInstance(s_miscAnimationInstance, GameImpl.s_elapsedTimeClamped);
                s_miscAnimationY = 48 - s_layerCurrentOffsetY[0] + s_layerBaseOffsetY[0] + s_currentArenaTopBottomOffset + GameImpl.s_ingameTop;
                break;
            }
            case 1: {
                s_miscAnimationInstance = s_miscAnimation.updateInstance(s_miscAnimationInstance, GameImpl.s_elapsedTimeClamped);
                s_miscAnimationX = -s_layerCurrentOffsetX[0] + 216 + GameImpl.s_ingameLeft;
                s_miscAnimationY = -s_layerCurrentOffsetY[0] + 120 + GameImpl.s_ingameTop;
                break;
            }
            case 0: {
                s_miscAnimationInstance = s_miscAnimation.updateInstance(s_miscAnimationInstance, GameImpl.s_elapsedTimeClamped);
                s_miscAnimationX = -s_layerCurrentOffsetX[1] + 264 + GameImpl.s_ingameLeft;
                s_miscAnimationY = -s_layerCurrentOffsetY[1] + 168 + GameImpl.s_ingameTop;
            }
        }
    }

    public static void updateCurrentOffset(int n, int n2) {
        for (int i = 0; i < 3; ++i) {
            int n3 = n;
            n3 *= IArena.ARENA_DATA[s_currentArenaId][13 + i];
            Arena.s_layerCurrentOffsetX[i] = s_layerBaseOffsetX[i] + (n3 >>= 8);
            int n4 = n2;
            n4 *= IArena.ARENA_DATA[s_currentArenaId][16 + i];
            Arena.s_layerCurrentOffsetY[i] = s_layerBaseOffsetY[i] + (n4 >>= 8);
        }
        Arena.updateArenaObjects();
    }

    public static void initArena(byte by) {
        Arena.initArena(by, -1);
    }

    public static void initArena(byte by, int n) {
        s_currentArenaId = by;
        s_arenaTileset = null;
        try {
            s_currentArenaTopBottomOffset = (GameImpl.s_ingameHeight - IArena.ARENA_DATA[by][11] * 24) / 2;
            s_currentArenaTopBottomOffsetVirtual = s_currentArenaTopBottomOffset = Math.max(s_currentArenaTopBottomOffset, 0);
            if (s_currentArenaTopBottomOffsetVirtual != 0) {
                GameImpl.setIngameOffsets(0, Math.max(0, s_currentArenaTopBottomOffset), 0, Math.max(30, s_currentArenaTopBottomOffset));
                s_currentArenaTopBottomOffsetVirtual += (IArena.ARENA_DATA[by][11] - 10) * 24;
            }
            if (s_currentArenaTopBottomOffsetVirtual == 0 && GameImpl.s_ingameHeight < 240) {
                s_currentArenaTopBottomOffsetVirtual = GameImpl.s_ingameHeight - 240;
            }
            s_currentArenaLeft = -IArena.ARENA_DATA[by][10] * 24 / 2;
            s_currentArenaRight = IArena.ARENA_DATA[by][10] * 24 / 2;
            s_currentArenaBottom = IArena.ARENA_DATA[by][9] + (GameImpl.s_ingameHeight - 240) - s_currentArenaTopBottomOffsetVirtual;
            s_currentArenaTop = s_currentArenaBottom - IArena.ARENA_DATA[by][11] * 24;
            s_currentArenaPhysicsBoundaryLeft = s_currentArenaLeft + IArena.ARENA_DATA[by][12];
            s_currentArenaPhysicsBoundaryRight = s_currentArenaRight - IArena.ARENA_DATA[by][12];
            for (int n2 = 0; n2 < 3; n2 = (int)((byte)(n2 + 1))) {
                Arena.createTilemap(IArena.ARENA_DATA[by][0 + n2], n2, n);
                Arena.s_layerBaseOffsetX[n2] = IArena.ARENA_DATA[by][3 + n2] * 24 + s_tilemapWidth[n2] / 2 - GameImpl.s_ingameCenterX + GameImpl.s_ingameLeft;
                Arena.s_layerBaseOffsetY[n2] = -IArena.ARENA_DATA[by][6 + n2] * 24 - s_currentArenaTopBottomOffsetVirtual;
                Arena.s_layerCurrentOffsetX[n2] = s_layerBaseOffsetX[n2];
                Arena.s_layerCurrentOffsetY[n2] = s_layerBaseOffsetY[n2];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Arena.initArenaSpecific(n);
    }

    private static void initArenaSpecific(int n) {
        s_arena_background_layer = new SDKImage[3][2];
        try {
            int n2 = -1;
            switch (s_currentArenaId) {
                case 4: {
                    n2 = 117440549;
                    s_miscAnimation = Animation.loadAnimation(0x7000000, 1);
                    s_miscAnimationInstance = 1;
                    break;
                }
                case 3: {
                    n2 = 117440550;
                    s_miscAnimation = Animation.loadAnimation(0x7000001, 1);
                    s_miscAnimationInstance = 1;
                    s_miscAnimationX = 72 + GameImpl.s_ingameLeft;
                    s_miscAnimationY = 72 + s_currentArenaTopBottomOffsetVirtual + GameImpl.s_ingameTop;
                    break;
                }
                case 2: {
                    n2 = 117440550;
                    s_miscAnimationInstance = 1;
                    s_miscAnimation = Animation.loadAnimation(0x7000001, 1);
                    s_miscAnimationX = 48 + GameImpl.s_ingameLeft;
                    break;
                }
                case 1: {
                    n2 = 0x7000027;
                    s_miscAnimation = Animation.loadAnimation(0x7000002, 1);
                    s_miscAnimationInstance = 1;
                    break;
                }
                case 0: {
                    n2 = 117440552;
                    s_miscAnimation = Animation.loadAnimation(0x7000003, 1);
                    s_miscAnimationInstance = 1;
                }
            }
            block8 : switch (n) {
                case -1: {
                    block40: for (byte by = 0; by < 2; by = (byte)((byte)(by + 1))) {
                        switch (s_currentArenaId) {
                            case 4: {
                                Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(167772214, -1, by);
                                Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(167772216, -1, by);
                                Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(0xA00003A, -1, by);
                                continue block40;
                            }
                            case 3: {
                                Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(0xA00002A, -1, by);
                                Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(167772204, -1, by);
                                Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(167772206, -1, by);
                                continue block40;
                            }
                            case 2: {
                                Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(0xA000030, -1, by);
                                Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(167772210, -1, by);
                                Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(167772212, -1, by);
                                continue block40;
                            }
                            case 1: {
                                Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(167772226, -1, by);
                                Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(0xA000044, -1, by);
                                Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(167772230, -1, by);
                                continue block40;
                            }
                            case 0: {
                                Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(167772220, -1, by);
                                Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(167772222, -1, by);
                                Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(0xA000040, -1, by);
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    byte by = 1;
                    switch (s_currentArenaId) {
                        case 4: {
                            Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(167772214, -1, by);
                            Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(167772216, -1, by);
                            Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(0xA00003A, -1, by);
                            break;
                        }
                        case 3: {
                            Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(0xA00002A, -1, by);
                            Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(167772204, -1, by);
                            Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(167772206, -1, by);
                            break;
                        }
                        case 2: {
                            Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(0xA000030, -1, by);
                            Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(167772210, -1, by);
                            Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(167772212, -1, by);
                            break;
                        }
                        case 1: {
                            Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(167772226, -1, by);
                            Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(0xA000044, -1, by);
                            Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(167772230, -1, by);
                            break;
                        }
                        case 0: {
                            Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(167772220, -1, by);
                            Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(167772222, -1, by);
                            Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(0xA000040, -1, by);
                        }
                    }
                    break;
                }
                case 0: {
                    byte by = 0;
                    switch (s_currentArenaId) {
                        case 4: {
                            Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(167772214, -1, by);
                            Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(167772216, -1, by);
                            Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(0xA00003A, -1, by);
                            break block8;
                        }
                        case 3: {
                            Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(0xA00002A, -1, by);
                            Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(167772204, -1, by);
                            Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(167772206, -1, by);
                            break block8;
                        }
                        case 2: {
                            Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(0xA000030, -1, by);
                            Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(167772210, -1, by);
                            Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(167772212, -1, by);
                            break block8;
                        }
                        case 1: {
                            Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(167772226, -1, by);
                            Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(0xA000044, -1, by);
                            Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(167772230, -1, by);
                            break block8;
                        }
                        case 0: {
                            Arena.s_arena_background_layer[2][by] = FileManager.createSDKImage(167772220, -1, by);
                            Arena.s_arena_background_layer[1][by] = FileManager.createSDKImage(167772222, -1, by);
                            Arena.s_arena_background_layer[0][by] = FileManager.createSDKImage(0xA000040, -1, by);
                        }
                    }
                }
            }
            if (n2 != -1) {
                switch (n) {
                    case -1: {
                        s_miscTileset = FileManager.createTileset(n2, ARENA_PALETTES, ARENA_EFFECTS, true, false);
                        break;
                    }
                    case 1: {
                        s_miscTileset = FileManager.createTileset(n2, (byte)1);
                        break;
                    }
                    case 0: {
                        s_miscTileset = FileManager.createTileset(n2);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void createTilemap(int n, int n2, int n3) throws Exception {
        DataInputStream dataInputStream = FileManager.openFileAsStream(n);
        Arena.s_tilemapCols[n2] = (byte)dataInputStream.readUnsignedByte();
        Arena.s_tilemapRows[n2] = (byte)dataInputStream.readUnsignedByte();
        Arena.s_tilemapWidth[n2] = s_tilemapCols[n2] * 24;
        Arena.s_tilemapHeight[n2] = s_tilemapRows[n2] * 24;
        dataInputStream.readUnsignedByte();
        int n4 = FileManager.readFilerefChunkIntegerValue(dataInputStream);
        Arena.s_layerTilemap[n2] = new byte[s_tilemapCols[n2] * s_tilemapRows[n2]];
        dataInputStream.readFully(s_layerTilemap[n2]);
        dataInputStream.close();
        if (s_arenaTileset == null) {
            switch (n3) {
                case -1: {
                    s_arenaTileset = FileManager.createTileset(n4, ARENA_PALETTES, ARENA_EFFECTS, true, true);
                    s_currentArenaImageId = 0;
                    break;
                }
                case 1: {
                    s_arenaTileset = FileManager.createTileset(n4, -1, (byte)1, true, true);
                    s_currentArenaImageId = 1;
                    break;
                }
                case 0: {
                    s_arenaTileset = FileManager.createTileset(n4, -1, (byte)0, true, true);
                    s_currentArenaImageId = 0;
                }
            }
        }
    }

    public static void setCurrentArenaImageId(int n) {
        s_currentArenaImageId = n;
        s_arenaTileset.setCurrentImageSlot(s_currentArenaImageId);
        if (s_miscTileset != null) {
            s_miscTileset.setCurrentImageSlot(s_currentArenaImageId);
        }
    }

    public static int getCurrentArenaImageId() {
        return s_currentArenaImageId;
    }

    public static void drawTilemap(byte by) {
        GameImpl.s_currentGraphics.drawImage(s_arena_background_layer[by][s_currentArenaImageId], -s_layerCurrentOffsetX[by] - GameImpl.s_ingameLeft, -s_layerCurrentOffsetY[by] - GameImpl.s_ingameTop, 20);
    }

    public static void drawArena() {
        for (byte by = 0; by < 3; by = (byte)(by + 1)) {
            Arena.drawObjectsBeforeLayer(by);
            Arena.drawTilemap(by);
            Arena.drawObjectsAfterLayer(by);
        }
    }

    private static void drawObjectsAfterLayer(byte by) {
        switch (s_currentArenaId) {
            case 1: {
                if (by != 1) break;
                s_miscAnimation.drawInstance(s_miscAnimationInstance, s_miscTileset, s_miscAnimationX, s_miscAnimationY, 0);
                break;
            }
            case 0: {
                if (by != 1) break;
                s_miscAnimation.drawInstance(s_miscAnimationInstance, s_miscTileset, s_miscAnimationX, s_miscAnimationY, 0);
            }
        }
    }

    private static void drawObjectsBeforeLayer(byte by) {
        switch (s_currentArenaId) {
            case 4: {
                if (by != 1) break;
                s_miscAnimation.drawInstance(s_miscAnimationInstance, s_miscTileset, s_miscAnimationX, s_miscAnimationY, 0);
                break;
            }
            case 2: 
            case 3: {
                if (by != 0) break;
                s_miscAnimation.drawInstance(s_miscAnimationInstance, s_miscTileset, s_miscAnimationX, s_miscAnimationY, 0);
            }
        }
    }

    static {
        s_layerTilemap = new byte[3][0];
        s_tilemapCols = new byte[3];
        s_tilemapRows = new byte[3];
        s_tilemapWidth = new int[3];
        s_tilemapHeight = new int[3];
        s_layerBaseOffsetX = new int[3];
        s_layerBaseOffsetY = new int[3];
        s_layerCurrentOffsetX = new int[3];
        s_layerCurrentOffsetY = new int[3];
        ARENA_PALETTES = new int[]{-1, -1};
        ARENA_EFFECTS = new byte[]{0, 1};
    }
}

