/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.Battle;
import com.ea.game.Camera;
import com.ea.game.Fighter;
import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.IFighter;
import com.ea.game.MathTools;
import com.ea.game.Particle;
import com.ea.game.Physics;
import com.ea.game.Projectile;
import com.ea.game.Sound;
import com.ea.game.Tileset;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import java.io.IOException;

public class Special
extends Fighter {
    private static final int FATALITY_STEP_0 = 0;
    private static final int FATALITY_STEP_1 = 1;
    private static final int FATALITY_STEP_2 = 2;
    private static final int FATALITY_STEP_3 = 3;
    private static final int FATALITY_STEP_4 = 4;
    private static final int FATALITY_STEP_5 = 5;
    private static final int FATALITY_STEP_6 = 6;
    private static final int FATALITY_STEP_7 = 7;
    private static final int FATALITY_STEP_8 = 8;
    private static final int FATALITY_STEP_9 = 9;
    private static final int FATALITY_STEP_10 = 10;
    private static final int BABALITY_STEP_0 = 0;
    private static final int BABALITY_STEP_1 = 1;
    private static final int BABALITY_STEP_2 = 2;
    private static final int BABALITY_STEP_3 = 3;
    private static final int BABALITY_STEP_4 = 4;
    private static final int BABALITY_STEP_5 = 5;
    private static final int BABALITY_STEP_6 = 6;
    private static final int BABALITY_STEP_7 = 7;
    private static final int BABALITY_STEP_8 = 8;
    private static final int BABALITY_STEP_9 = 9;
    private static final int BABALITY_STEP_10 = 10;
    private static final int MAX_SCORPION_FIREBALLS = 12;
    private static final int SCORPION_FIREBALL_TTL = 1500;
    private static final int SCORPION_FIREBALL_DELAY = 80;
    private static final int SCORPION_FIREBALL_TRAJECTORY_DURATION = 400;
    private static final int MOVE_LIST_LINES_COUNT = 13;
    private static final String COMBO_SEPARATOR = ",";
    private static final String COMMAND_SEPARATOR = "-";
    private static final int TIMER_FATALITY_STEP_SHORT = 400;
    private static final int TIMER_FATALITY_STEP = 1000;
    private static final int TIMER_BABALITY_MUSIC_DURATION = 2500;
    private static final int TIMER_FATALITY_STEP_LONG = 1500;
    private static final int SCORPION_FIREBALL_WIDTH = 36;
    private static final int TIMER_FATALITY_SCORPION_BODY_SWAP = 300;
    private static final int MOVE_LIST_STRING_LENGTH = 1000;
    private static final int FATALITY_CYRAX_MAX_EFFECTS = 4;
    private static final int FATALITY_CYRAX_EFFECT_DELAY = 160;
    private static final int FATALITY_CYRAX_EFFECT_OFFSET_Y = 18;
    private static final int TIMER_FATALITY_LIUKANG_BURN_EFFECT = 50;
    private static int s_finisherStep;
    private static int s_finisherStepTimer;
    private static Tileset s_skeletonTileset;
    private static Animation s_skeletonAnimation;
    public static boolean s_didFinisherEnd;
    private static int s_cyraxFatalityEffectsCount;
    private static Tileset s_shadowsTileset;
    private static Animation s_shadowsAnimation1;
    private static Animation s_shadowsAnimation2;
    private static Animation s_shadowsAnimation3;
    private static int s_deathKissPosX;
    private static int s_deathKissPosY;
    private static boolean s_isDeathKissVisible;
    private static int s_deathKissSaveX;
    private static int s_deathKissSaveY;
    private static Tileset s_liukangFlameEngulfTileset;
    private static Tileset s_liukangVanishTileset;
    private static Animation s_liukangFlameEngulfAnimation;
    private static Animation s_liukangVanishAnimation;
    private static boolean s_isFlameEngulfVisible;
    private static Fighter s_flameEngulfFighter;
    private static Tileset s_kitanaFanliftTileset;
    private static Animation s_kitanaFanliftAnimation;

    public static void updateSpecialMove(Fighter fighter) {
        switch (fighter.m_fighterId) {
            case 1: {
                if (fighter.m_attackConnected) break;
                Physics.forceMovement(fighter, 67584 * fighter.m_orientation * GameImpl.s_elapsedTimeClamped / 1000, 0);
                break;
            }
            case 0: {
                boolean bl = fighter.m_orientation == -1 ? fighter.m_leftWallCollided : fighter.m_rightWallCollided;
                int n = Camera.getCameraRight() - Camera.getCameraLeft() - 48;
                if (fighter.m_attackBlocked) {
                    if (fighter.m_animId == 18) break;
                    fighter.m_isTrajectoryLaunched = false;
                    fighter.playNewAnim(18);
                    fighter.m_stateTimer = 0;
                    break;
                }
                if (fighter.m_attackHit) {
                    fighter.m_attackHit = false;
                    fighter.m_resetTrajectory = true;
                    break;
                }
                if (!bl) break;
                fighter.translate(fighter.m_orientation * -1 * (n << 8), 0);
                break;
            }
            case 3: {
                if (fighter.m_attackConnected && fighter.m_stateTimer - fighter.m_attackConnectedTimer <= 200) {
                    Physics.forceMovement(fighter, 0, 0);
                    break;
                }
                if (fighter.m_stateTimer < 800 && !fighter.m_attackConnected) {
                    if (fighter.m_animId == 19) {
                        fighter.m_isOnGround = false;
                        Physics.forceMovement(fighter, 0, -73728 * GameImpl.s_elapsedTimeClamped / 1000);
                        int n = -60;
                        if (fighter.getY() > n) break;
                        fighter.setPosition(fighter.getX(), n);
                        fighter.playNewAnim(26);
                        break;
                    }
                    if (fighter.m_animId != 26) break;
                    Physics.forceMovement(fighter, fighter.m_orientation * 98304 * GameImpl.s_elapsedTimeClamped / 1000, 0);
                    break;
                }
                if (fighter.m_animId != 19) {
                    fighter.reversePlayNewAnim(19);
                }
                Physics.forceMovement(fighter, 0, 73728 * GameImpl.s_elapsedTimeClamped / 1000);
                int n = 0;
                if (fighter.getY() < n) break;
                fighter.setPosition(fighter.getX(), n);
                fighter.m_isOnGround = true;
                fighter.initState(0);
                break;
            }
            case 2: {
                fighter.m_fanLiftAnimInstance = s_kitanaFanliftAnimation.updateInstance(fighter.m_fanLiftAnimInstance, GameImpl.s_elapsedTimeClamped);
                break;
            }
            case 4: {
                if (fighter.m_attackConnected) break;
                Physics.forceMovement(fighter, 67584 * fighter.m_orientation * GameImpl.s_elapsedTimeClamped / 1000, 0);
                break;
            }
            case 5: {
                if (!fighter.animationFinished() || fighter.m_animId != 26) break;
                int n = fighter.getOpponent().getX();
                n = fighter.getOpponent().isCloseToArenaBoundaries() ? (n -= fighter.m_orientation * 48) : (n += fighter.m_orientation * 48);
                fighter.setPosition(n, 0);
                fighter.reversePlayNewAnim(27);
                Particle.launchExplosion(fighter.getX(), fighter.getY() - 41, true, true);
                fighter.m_score += 2000;
                break;
            }
            case 6: {
                if (fighter.m_stateTimer > 400 || fighter.m_attackConnected) break;
                Physics.forceMovement(fighter, fighter.m_orientation * 36864 * GameImpl.s_elapsedTimeClamped / 1000, 0);
            }
        }
    }

    protected static void nextFinisherStep() {
        ++s_finisherStep;
    }

    public static void loadShadows() {
    }

    public static void cleanupShadows() {
    }

    protected static boolean transitFinisher(Fighter fighter) {
        return s_didFinisherEnd;
    }

    protected static void updateFatality(Fighter fighter) {
        int n = s_finisherStep;
        if (GameImpl.getFatalityOn()) {
            switch (fighter.m_fighterId) {
                case 0: {
                    Special.updateFatalityScorpion(fighter);
                    break;
                }
                case 1: {
                    Special.updateFatalitySubzero(fighter);
                    break;
                }
                case 2: {
                    Special.updateFatalityKitana(fighter);
                    break;
                }
                case 3: {
                    Special.updateFatalitySonya(fighter);
                    break;
                }
                case 4: {
                    Special.updateFatalityLiukang(fighter);
                    break;
                }
                case 5: {
                    Special.updateFatalityCyrax(fighter);
                }
            }
        } else {
            Special.updateGenericFatality(fighter);
        }
        s_finisherStepTimer = s_finisherStep == n ? (s_finisherStepTimer += GameImpl.s_elapsedTimeClamped) : 0;
    }

    public static void updateGenericBabality(Fighter fighter) {
        int n = s_finisherStep;
        switch (s_finisherStep) {
            case 0: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().m_autoUpdateAnimation = false;
                    fighter.playNewAnim(33);
                    break;
                }
                if (!fighter.animationFinished()) break;
                Special.nextFinisherStep();
                break;
            }
            case 1: {
                if (s_finisherStepTimer == 0) {
                    Particle.loadFlamesResources();
                    FileManager.cleanup();
                    Special.loadBabality(fighter.getOpponent());
                    FileManager.cleanup();
                    break;
                }
                Special.nextFinisherStep();
                break;
            }
            case 2: {
                if (s_finisherStepTimer == 0) {
                    Camera.cameraShake();
                    Particle.launchBurningEffect(fighter.getOpponent().getX(), fighter.getOpponent().getY());
                    break;
                }
                if (s_finisherStepTimer <= 300) break;
                Special.nextFinisherStep();
                break;
            }
            case 3: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().playNewAnim(fighter.getOpponent().m_babalityAnimation, fighter.getOpponent().m_babalityTileset);
                    break;
                }
                if (s_finisherStepTimer <= 2500) break;
                s_didFinisherEnd = true;
            }
        }
        s_finisherStepTimer = s_finisherStep == n ? (s_finisherStepTimer += GameImpl.s_elapsedTimeClamped) : 0;
    }

    private static void loadBabality(Fighter fighter) {
        int n = IFighter.FIGHTERS_BABALITY_TILESETS[fighter.m_fighterId];
        int n2 = IFighter.FIGHTERS_BABALITY_ANIMATIONS[fighter.m_fighterId];
        if (n != -1) {
            try {
                fighter.m_babalityTileset = FileManager.createTileset(n, false);
                fighter.m_babalityAnimation = Animation.loadAnimation(n2, 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void updateFatalityCyrax(Fighter fighter) {
        switch (s_finisherStep) {
            case 0: {
                if (s_finisherStepTimer == 0) {
                    fighter.m_skipPhysics = true;
                    fighter.playNewAnim(0);
                    Particle.loadBodyPartsResources();
                    Particle.loadCyraxBloodExplosion();
                    break;
                }
                if (s_finisherStepTimer <= 1000) break;
                Special.nextFinisherStep();
                break;
            }
            case 1: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(28);
                    break;
                }
                if (!fighter.animationFinished()) break;
                Special.nextFinisherStep();
                break;
            }
            case 2: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(29);
                    break;
                }
                if (s_finisherStepTimer <= 1000) break;
                Special.nextFinisherStep();
                break;
            }
            case 3: {
                if (s_finisherStepTimer == 0) {
                    s_finisherStepTimer = 0;
                    break;
                }
                if (fighter.getY() > -150) {
                    fighter.translate(0, -24576 * GameImpl.s_elapsedTimeClamped / 1000);
                    break;
                }
                Special.nextFinisherStep();
                break;
            }
            case 4: {
                if (s_finisherStepTimer == 0) {
                    fighter.setPosition(fighter.getOpponent().getX(), fighter.getY() - 58);
                    fighter.m_throwTransformation = 2;
                    fighter.m_useThrowTransformation = true;
                    Camera.setCamera(fighter.getOpponent().getX(), fighter.getOpponent().getY());
                    break;
                }
                if (fighter.getY() < -165) {
                    fighter.translate(0, 24576 * GameImpl.s_elapsedTimeClamped / 1000);
                    break;
                }
                Special.nextFinisherStep();
                break;
            }
            case 5: {
                if (s_finisherStepTimer == 0) {
                    GameImpl.vibrate(500);
                    fighter.getOpponent().playNewAnim(22);
                    fighter.getOpponent().m_autoUpdateAnimation = false;
                    s_cyraxFatalityEffectsCount = 0;
                    fighter.getOpponent().playSfx(13);
                    break;
                }
                if (s_cyraxFatalityEffectsCount < 4) {
                    Camera.cameraShake();
                    fighter.translate(0, 18432 * GameImpl.s_elapsedTimeClamped / 1000);
                    if (s_cyraxFatalityEffectsCount == 0 || s_finisherStepTimer / 160 > s_cyraxFatalityEffectsCount) {
                        int n = s_cyraxFatalityEffectsCount * 18;
                        Particle.launchBloodExplosion(fighter.getOpponent().getX(), fighter.getOpponent().getY() + -65 + n);
                        if (s_cyraxFatalityEffectsCount % 2 == 0) {
                            Particle.launchFullBodyMembersExplosionCyrax(fighter.getOpponent().getX(), fighter.getOpponent().getY() + n - 58);
                        }
                        ++s_cyraxFatalityEffectsCount;
                    }
                    if (s_finisherStepTimer < 700 || fighter.getOpponent().m_animId == -1) break;
                    fighter.getOpponent().m_animId = -1;
                    break;
                }
                Special.nextFinisherStep();
                break;
            }
            case 6: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().m_animId = -1;
                    break;
                }
                if (fighter.getY() < 75) {
                    fighter.translate(0, 18432 * GameImpl.s_elapsedTimeClamped / 1000);
                    break;
                }
                Special.nextFinisherStep();
                break;
            }
            case 7: {
                if (s_finisherStepTimer == 0) {
                    fighter.setPosition(fighter.getOpponent().getX(), 0);
                    fighter.m_useThrowTransformation = false;
                    fighter.reversePlayNewAnim(27);
                    Particle.launchExplosion(fighter.getX(), fighter.getY() - 41, true, true);
                    break;
                }
                if (!fighter.animationFinished()) break;
                Special.nextFinisherStep();
                break;
            }
            case 8: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(33);
                    break;
                }
                s_didFinisherEnd = true;
            }
        }
    }

    private static void updateFatalityLiukang(Fighter fighter) {
        switch (s_finisherStep) {
            case 0: {
                if (s_finisherStepTimer == 0) {
                    Particle.loadFlamesResources();
                    fighter.playNewAnim(33);
                    break;
                }
                if (!fighter.animationFinished()) break;
                Special.nextFinisherStep();
                break;
            }
            case 1: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().m_autoUpdateAnimation = false;
                    Special.loadLiukangFatality();
                    Special.loadSkeleton();
                    FileManager.cleanup();
                    break;
                }
                Special.nextFinisherStep();
                break;
            }
            case 2: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(s_liukangVanishAnimation, s_liukangVanishTileset);
                    break;
                }
                if (!fighter.animationFinished()) break;
                Special.nextFinisherStep();
                break;
            }
            case 3: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(-1);
                    Battle.s_battleCameraAutomatic = false;
                    Camera.setCamera(fighter.getOpponent().getX(), fighter.getOpponent().getY());
                    break;
                }
                if (s_finisherStepTimer < 1000) break;
                Special.nextFinisherStep();
                break;
            }
            case 4: {
                if (s_finisherStepTimer == 0) {
                    Battle.fighterMoved(fighter.getOpponent());
                    fighter.setPosition(fighter.getOpponent().getX(), fighter.getOpponent().getY());
                    fighter.playNewAnim(28);
                    s_isFlameEngulfVisible = true;
                    s_flameEngulfFighter = fighter;
                    break;
                }
                if (s_finisherStepTimer < 50) break;
                Special.nextFinisherStep();
                break;
            }
            case 5: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().playSfx(13);
                    Particle.launchBurningEffect(fighter.getOpponent().getX(), fighter.getOpponent().getY());
                    break;
                }
                if (s_finisherStepTimer >= 300) {
                    Special.nextFinisherStep();
                    break;
                }
                if (!fighter.animationFinished()) break;
                fighter.playNewAnim(-1);
                s_flameEngulfFighter = null;
                s_isFlameEngulfVisible = false;
                break;
            }
            case 6: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().playNewAnim(s_skeletonAnimation, s_skeletonTileset);
                    break;
                }
                if (s_finisherStepTimer >= 1500) {
                    Special.nextFinisherStep();
                    break;
                }
                if (!fighter.animationFinished()) break;
                fighter.playNewAnim(-1);
                s_flameEngulfFighter = null;
                s_isFlameEngulfVisible = false;
                break;
            }
            case 7: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().m_autoUpdateAnimation = true;
                    break;
                }
                if (s_finisherStepTimer <= 1000) break;
                Special.nextFinisherStep();
                break;
            }
            case 8: {
                if (s_finisherStepTimer == 0) {
                    fighter.setPosition(fighter.getOpponent().getX() - 48, fighter.getY());
                    fighter.reversePlayNewAnim(s_liukangVanishAnimation, s_liukangVanishTileset);
                    break;
                }
                if (!fighter.animationFinished()) break;
                Special.nextFinisherStep();
                break;
            }
            case 9: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(33);
                    break;
                }
                if (!fighter.animationFinished()) break;
                s_didFinisherEnd = true;
            }
        }
    }

    private static void updateFatalitySonya(Fighter fighter) {
        switch (s_finisherStep) {
            case 0: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(0);
                    fighter.getOpponent().m_autoUpdateAnimation = false;
                    fighter.getOpponent().playNewAnim(22);
                    Particle.loadFlamesResources();
                    Special.loadSkeleton();
                    FileManager.cleanup();
                    break;
                }
                if (s_finisherStepTimer <= 1000) break;
                Special.nextFinisherStep();
                break;
            }
            case 1: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(28);
                    break;
                }
                if (!fighter.animationFinished()) break;
                Special.nextFinisherStep();
                break;
            }
            case 2: {
                Special.nextFinisherStep();
                break;
            }
            case 3: {
                if (s_finisherStepTimer > 1000) {
                    Special.nextFinisherStep();
                    break;
                }
                s_isDeathKissVisible = true;
                int n = fighter.getX() + fighter.m_orientation * 14;
                int n2 = fighter.getY() + -52;
                s_deathKissPosX = MathTools.computeBezierPoint(n, n + fighter.m_orientation * -24, n + fighter.m_orientation * 60, s_finisherStepTimer, 1000);
                s_deathKissPosY = MathTools.computeBezierPoint(n2, n2 + -75, n2 + -15, s_finisherStepTimer, 1000);
                break;
            }
            case 4: {
                if (s_finisherStepTimer == 0) {
                    s_deathKissSaveX = s_deathKissPosX;
                    s_deathKissSaveY = s_deathKissPosY;
                    break;
                }
                if (s_finisherStepTimer > 400) {
                    Special.nextFinisherStep();
                    break;
                }
                int n = fighter.getOpponent().getX() - s_deathKissSaveX;
                int n3 = fighter.getOpponent().getY() + -24 - s_deathKissSaveY;
                s_deathKissPosX = s_deathKissSaveX + n * s_finisherStepTimer / 400;
                s_deathKissPosY = s_deathKissSaveY + n3 * s_finisherStepTimer / 400;
                break;
            }
            case 5: {
                if (s_finisherStepTimer == 0) {
                    GameImpl.vibrate(500);
                    fighter.getOpponent().playSfx(13);
                    Particle.launchBurningEffect(fighter.getOpponent().getX(), fighter.getOpponent().getY());
                    s_isDeathKissVisible = false;
                    break;
                }
                if (s_finisherStepTimer <= 300) break;
                Special.nextFinisherStep();
                break;
            }
            case 6: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().playNewAnim(s_skeletonAnimation, s_skeletonTileset);
                    break;
                }
                if (s_finisherStepTimer <= 1500) break;
                Special.nextFinisherStep();
                break;
            }
            case 7: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().m_autoUpdateAnimation = true;
                    fighter.playNewAnim(33);
                    break;
                }
                s_didFinisherEnd = true;
            }
        }
    }

    private static void updateFatalityKitana(Fighter fighter) {
        switch (s_finisherStep) {
            case 0: {
                if (s_finisherStepTimer == 0) {
                    fighter.m_skipPhysics = true;
                    fighter.getOpponent().m_autoUpdateAnimation = false;
                    fighter.getOpponent().playNewAnim(22);
                    break;
                }
                if (s_finisherStepTimer <= 1000) break;
                Special.nextFinisherStep();
                break;
            }
            case 1: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(6);
                    Camera.setCamera(fighter.getOpponent().getX(), fighter.getOpponent().getY());
                    break;
                }
                if (Battle.getOpponentsDistance() > 40 && s_finisherStepTimer < 3000) {
                    fighter.translate(fighter.m_orientation * 21504 * GameImpl.s_elapsedTimeClamped / 1000, 0);
                    break;
                }
                Special.nextFinisherStep();
                break;
            }
            case 2: {
                if (s_finisherStepTimer == 0) {
                    fighter.setPosition(fighter.getOpponent().getX() + fighter.m_orientation * 40 * -1, fighter.getY());
                    fighter.playNewAnim(4);
                    break;
                }
                if (s_finisherStepTimer <= 1000) break;
                Special.nextFinisherStep();
                break;
            }
            case 3: {
                if (s_finisherStepTimer == 0) {
                    s_finisherStepTimer = 0;
                    GameImpl.vibrate(500);
                    fighter.playNewAnim(24);
                    break;
                }
                if (s_finisherStepTimer <= 150) break;
                Special.nextFinisherStep();
                break;
            }
            case 4: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().playSfx(13);
                    fighter.getOpponent().playNewAnim(31);
                    Particle.launchParticleEffect(0, fighter.getOpponent().getX(), fighter.getOpponent().getY() - 58, fighter.getOpponent().m_fighterId == 5 ? 1 : 0);
                    Particle.createParticle(fighter.getOpponent().getX(), fighter.getOpponent().getY() - 58, 24 * fighter.m_orientation, 84, 1000, 0, 5, 2, 0, (byte)0, true, false, false, false, true, false, fighter.getOpponent().getCurrentTileset(), fighter.getOpponent().m_anims[32], fighter.getOpponent().getCurrentTileset(), fighter.getOpponent().m_anims[32]);
                    Camera.cameraShake();
                    break;
                }
                if (s_finisherStepTimer <= 1500) break;
                Special.nextFinisherStep();
                break;
            }
            case 5: {
                if (s_finisherStepTimer == 0) {
                    Particle.launchParticleEffect(0, fighter.getOpponent().getX(), fighter.getOpponent().getY() + -65, fighter.getOpponent().m_fighterId == 5 ? 1 : 0);
                    fighter.playNewAnim(33);
                    break;
                }
                if (!fighter.animationFinished()) break;
                s_didFinisherEnd = true;
            }
        }
    }

    private static void updateGenericFatality(Fighter fighter) {
        switch (s_finisherStep) {
            case 0: {
                if (s_finisherStepTimer == 0) {
                    // empty if block
                }
                Special.nextFinisherStep();
                break;
            }
            case 1: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(6);
                    break;
                }
                if (Battle.getOpponentsDistance() > 48 && s_finisherStepTimer < 3000) {
                    fighter.translate(fighter.m_orientation * 21504 * GameImpl.s_elapsedTimeClamped / 1000, 0);
                    break;
                }
                Special.nextFinisherStep();
                break;
            }
            case 2: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(4);
                    break;
                }
                if (s_finisherStepTimer <= 1000) break;
                Special.nextFinisherStep();
                break;
            }
            case 3: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(15);
                    break;
                }
                if (s_finisherStepTimer <= 200) break;
                Special.nextFinisherStep();
                break;
            }
            case 4: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().playSfx(13);
                    GameImpl.vibrate(500);
                    fighter.getOpponent().playNewAnim(3);
                    fighter.getOpponent().m_trajectoryFpWidth = fighter.getOrientation() * IFighter.TRAJ_IMPACT_BIG_UPPERCUT[0] << 8;
                    fighter.getOpponent().m_trajectoryFpHeight = IFighter.TRAJ_IMPACT_BIG_UPPERCUT[1] << 8;
                    fighter.getOpponent().m_trajectoryDuration = IFighter.TRAJ_IMPACT_BIG_UPPERCUT[2];
                    fighter.getOpponent().m_isTrajectoryLaunched = false;
                    Particle.launchParticleEffect(0, fighter.getOpponent().getX(), fighter.getOpponent().getY() + -65, fighter.getOpponent().m_fighterId == 5 ? 1 : 0);
                    Camera.cameraShake();
                    break;
                }
                if (s_finisherStepTimer <= 400 || !fighter.getOpponent().isOnGround()) break;
                Special.nextFinisherStep();
                break;
            }
            case 5: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(33);
                    fighter.getOpponent().playNewAnim(8);
                    Camera.cameraShake();
                    break;
                }
                if (!fighter.animationFinished()) break;
                s_didFinisherEnd = true;
            }
        }
    }

    private static void updateFatalitySubzero(Fighter fighter) {
        switch (s_finisherStep) {
            case 0: {
                if (s_finisherStepTimer == 0) {
                    fighter.m_skipPhysics = true;
                    fighter.m_autoUpdateAnimation = false;
                    Particle.loadIceParticlesResources();
                    Particle.loadIceBreathResources();
                    FileManager.cleanup();
                    break;
                }
                if (s_finisherStepTimer <= 1000) break;
                Special.nextFinisherStep();
                break;
            }
            case 1: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(28);
                    fighter.m_autoUpdateAnimation = true;
                    break;
                }
                if (!fighter.animationFinished()) break;
                Special.nextFinisherStep();
                break;
            }
            case 2: {
                if (s_finisherStepTimer == 0) {
                    Battle.s_battleCameraAutomatic = false;
                    Camera.setCamera(fighter.getOpponent().getX(), fighter.getOpponent().getY());
                    Particle.launchSubzeroIceBreathEffect(fighter.getX() + fighter.m_orientation * 27, fighter.getY() + -67, fighter.getOpponent().getX(), fighter.getOpponent().getY() + -67, 1000, 0, 1000);
                    s_finisherStepTimer = 0;
                    break;
                }
                if (s_finisherStepTimer <= 400) break;
                Special.nextFinisherStep();
                break;
            }
            case 3: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().m_autoUpdateAnimation = false;
                    fighter.getOpponent().setTilesetImageType(1);
                    fighter.getOpponent().playSfx(13);
                    break;
                }
                if (s_finisherStepTimer <= 1000) break;
                Special.nextFinisherStep();
                break;
            }
            case 4: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(6);
                    break;
                }
                if (Battle.getOpponentsDistance() > 48 && s_finisherStepTimer < 3000) {
                    fighter.translate(fighter.m_orientation * 21504 * GameImpl.s_elapsedTimeClamped / 1000, 0);
                    break;
                }
                Special.nextFinisherStep();
                break;
            }
            case 5: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(4);
                    break;
                }
                if (s_finisherStepTimer <= 1000) break;
                Special.nextFinisherStep();
                break;
            }
            case 6: {
                if (s_finisherStepTimer == 0) {
                    GameImpl.vibrate(500);
                    fighter.playNewAnim(15);
                    break;
                }
                if (s_finisherStepTimer <= 200) break;
                Special.nextFinisherStep();
                break;
            }
            case 7: {
                if (s_finisherStepTimer == 0) {
                    Sound.playSFX((byte)53);
                    fighter.getOpponent().playNewAnim(-1);
                    Particle.launchIceExplosion(fighter.getOpponent().getX(), fighter.getOpponent().getY());
                    Camera.cameraShake();
                    break;
                }
                if (s_finisherStepTimer <= 1000) break;
                Special.nextFinisherStep();
                break;
            }
            case 8: {
                if (s_finisherStepTimer == 0) {
                    fighter.playNewAnim(33);
                    break;
                }
                if (!fighter.animationFinished()) break;
                s_didFinisherEnd = true;
            }
        }
    }

    protected static void initSpecialMove(Fighter fighter) {
        fighter.m_timeSinceLastSpecialMove = 0;
        switch (fighter.m_fighterId) {
            case 1: {
                fighter.playNewAnim(26);
                break;
            }
            case 0: {
                fighter.playNewAnim(26);
                fighter.m_orientation *= -1;
                break;
            }
            case 2: {
                fighter.playNewAnim(26);
                fighter.m_fanLiftAnimInstance = 1;
                break;
            }
            case 3: {
                fighter.playNewAnim(19);
                break;
            }
            case 4: {
                fighter.m_isOnGround = false;
                fighter.playNewAnim(26);
                break;
            }
            case 5: {
                Particle.launchExplosion(fighter.getX(), fighter.getY() - 41, true, false);
                fighter.playNewAnim(26);
                break;
            }
            case 6: {
                fighter.playNewAnim(26);
            }
        }
    }

    protected static void transitSpecialMove(Fighter fighter) {
        switch (fighter.m_fighterId) {
            case 1: {
                if (fighter.m_stateTimer <= 750) break;
                fighter.initState(0);
                break;
            }
            case 0: {
                if (!fighter.m_isOnGround || fighter.m_stateTimer <= 500) break;
                fighter.initState(0);
                break;
            }
            case 2: {
                if (fighter.m_stateTimer <= 3000 && (fighter.getOpponent().m_state != 34 || fighter.getOpponent().m_stateTimer <= 800)) break;
                fighter.initState(0);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (fighter.m_stateTimer <= 800) break;
                fighter.m_isOnGround = true;
                fighter.initState(0);
                break;
            }
            case 5: {
                if (fighter.m_animId != 27 || !fighter.animationFinished()) break;
                fighter.initState(0);
                break;
            }
            case 6: {
                if (fighter.m_stateTimer <= 700) break;
                fighter.initState(0);
            }
        }
    }

    protected static void initFinisher(Fighter fighter) {
        s_finisherStep = 0;
        s_finisherStepTimer = 0;
        s_didFinisherEnd = false;
    }

    private static void updateFatalityScorpion(Fighter fighter) {
        switch (s_finisherStep) {
            case 0: {
                fighter.playNewAnim(28);
                fighter.getOpponent().m_autoUpdateAnimation = false;
                fighter.m_autoUpdateAnimation = false;
                Special.nextFinisherStep();
                Particle.loadFlamesResources();
                break;
            }
            case 1: {
                Particle.loadFlamesResources();
                Special.nextFinisherStep();
                break;
            }
            case 2: {
                if (s_finisherStepTimer == 0) {
                    Special.loadSkeleton();
                }
                FileManager.cleanup();
                Special.nextFinisherStep();
                break;
            }
            case 3: {
                fighter.m_autoUpdateAnimation = true;
                if (!fighter.animationFinished()) break;
                Special.nextFinisherStep();
                break;
            }
            case 4: {
                if (s_finisherStepTimer == 0) {
                    int n = fighter.getX() + 27 * fighter.m_orientation;
                    int n2 = fighter.getY() + -54;
                    int n3 = fighter.getOpponent().getX();
                    int n4 = fighter.getOpponent().getY();
                    for (int i = 0; i < 12; ++i) {
                        int n5 = MathTools.getRandomInt(0, 36) - 18;
                        Particle.launchScorpionFireballEffect(n, n2, n3 + n5, n4, 1500, i * 80, 400);
                    }
                    Camera.setCamera(n3, n4);
                    fighter.m_skipPhysics = true;
                    s_finisherStepTimer = 0;
                    break;
                }
                if (s_finisherStepTimer <= 1500) break;
                Special.nextFinisherStep();
                break;
            }
            case 5: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().playSfx(13);
                    GameImpl.vibrate(500);
                    Particle.launchBurningEffect(fighter.getOpponent().getX(), fighter.getOpponent().getY());
                    break;
                }
                if (s_finisherStepTimer <= 300) break;
                Special.nextFinisherStep();
                break;
            }
            case 6: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().playNewAnim(s_skeletonAnimation, s_skeletonTileset);
                    break;
                }
                if (s_finisherStepTimer <= 1500) break;
                Special.nextFinisherStep();
                break;
            }
            case 7: {
                if (s_finisherStepTimer == 0) {
                    fighter.getOpponent().m_autoUpdateAnimation = true;
                    break;
                }
                if (!fighter.getOpponent().animationFinished()) break;
                s_didFinisherEnd = true;
            }
        }
    }

    private static void loadSkeleton() {
        try {
            s_skeletonTileset = FileManager.createTileset(134217836, false);
            s_skeletonAnimation = Animation.loadAnimation(134217757, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void initSpecial() {
        s_didFinisherEnd = false;
        s_finisherStep = 0;
        s_finisherStepTimer = 0;
    }

    public static SDKString createMoveList(byte[][] byArray, byte[][][] byArray2, int n) {
        SDKString sDKString = SDKUtils.getString(43, null);
        SDKString[] sDKStringArray = new SDKString[8];
        sDKStringArray[0] = SDKUtils.getString(IFighter.FIGHTER_NAMES[n], null);
        sDKStringArray[1] = new SDKString(Special.commandToString(byArray[0]));
        sDKStringArray[2] = new SDKString(Special.commandToString(byArray[1]));
        if (byArray2 != null) {
            sDKStringArray[3] = new SDKString(Special.comboToString(byArray2[0]));
            sDKStringArray[4] = new SDKString(Special.comboToString(byArray2[1]));
            sDKStringArray[5] = new SDKString(Special.comboToString(byArray2[2]));
        } else {
            sDKStringArray[3] = new SDKString("---");
            sDKStringArray[4] = new SDKString("---");
            sDKStringArray[5] = new SDKString("---");
        }
        boolean bl = n != 6;
        sDKStringArray[6] = byArray[2] != null && bl ? new SDKString(Special.commandToString(byArray[2])) : new SDKString("---");
        sDKStringArray[7] = byArray[3] != null && bl ? new SDKString(Special.commandToString(byArray[3])) : new SDKString("---");
        sDKString = sDKString.replace(sDKStringArray);
        return sDKString;
    }

    private static String comboToString(byte[][] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; i += 2) {
            if (i > 0) {
                string = string + COMBO_SEPARATOR;
            }
            byte[] byArray2 = byArray[i + 0];
            string = string + Special.commandToString(byArray2);
        }
        return string;
    }

    public static String commandToString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                string = string + COMMAND_SEPARATOR;
            }
            string = string + Special.commandKeyToString(byArray[i]);
        }
        return string;
    }

    private static SDKString commandKeyToString(byte by) {
        SDKString sDKString = new SDKString("");
        switch (by) {
            case 0: {
                SDKUtils.getString(93, sDKString);
                break;
            }
            case 1: {
                SDKUtils.getString(95, sDKString);
                break;
            }
            case 7: {
                SDKUtils.getString(85, sDKString);
                break;
            }
            case 8: {
                SDKUtils.getString(89, sDKString);
                break;
            }
            case 9: {
                SDKUtils.getString(87, sDKString);
                break;
            }
            case 3: {
                SDKUtils.getString(97, sDKString);
                break;
            }
            case 2: {
                SDKUtils.getString(93, sDKString);
            }
        }
        return sDKString;
    }

    public static void drawShadow(Fighter fighter) {
        int n = fighter.getY() / 2;
        GameImpl.s_currentGraphics.setColor(657930);
        GameImpl.s_currentGraphics.fillArc(fighter.getX() - Camera.getCameraLeft() - n / 2 - 24, -4 - Camera.getCameraTop(), n + 48, n / 8 + 8, 0, 360);
    }

    public static void drawSpecial() {
        if (s_isDeathKissVisible) {
            Particle.s_flameAnimation1.drawInstance(1, Particle.s_flameTileset, s_deathKissPosX - Camera.getCameraLeft(), s_deathKissPosY - Camera.getCameraTop(), 0);
        } else if (s_isFlameEngulfVisible && s_liukangVanishAnimation.getNbFrames() > Animation.getInstanceCurrentFrame(Special.s_flameEngulfFighter.m_animInstance)) {
            s_liukangFlameEngulfAnimation.drawInstance(Special.s_flameEngulfFighter.m_animInstance, s_liukangFlameEngulfTileset, s_flameEngulfFighter.getX() - Camera.getCameraLeft(), s_flameEngulfFighter.getY() - Camera.getCameraTop(), 0);
        }
        for (int i = 0; i < Fighter.s_pool.length; ++i) {
            if (Fighter.s_pool[i].m_poolState != 2 || Fighter.s_pool[i].m_fighterId != 2 || Fighter.s_pool[i].m_state != 26) continue;
            Fighter fighter = Fighter.s_pool[i];
            s_kitanaFanliftAnimation.drawInstance(fighter.m_fanLiftAnimInstance, s_kitanaFanliftTileset, fighter.getX() - Camera.getCameraLeft(), fighter.getY() - Camera.getCameraTop(), fighter.getOrientation() == 1 ? 0 : 4);
        }
    }

    public static void loadLiukangFatality() {
        try {
            s_liukangFlameEngulfTileset = FileManager.createTileset(134217844);
            s_liukangVanishTileset = FileManager.createTileset(134217845, false);
            s_liukangFlameEngulfAnimation = Animation.loadAnimation(134217775, 0);
            s_liukangVanishAnimation = Animation.loadAnimation(0x8000030, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void loadKitanaSpecial() {
        try {
            s_kitanaFanliftTileset = FileManager.createTileset(134217846, false);
            s_kitanaFanliftAnimation = Animation.loadAnimation(134217777, 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void cleanupKitanaSpecial() {
        s_kitanaFanliftAnimation = null;
        s_kitanaFanliftTileset = null;
    }

    public static void cleanupLiukangFatality() {
        s_liukangFlameEngulfTileset = null;
        s_liukangVanishTileset = null;
        s_liukangFlameEngulfAnimation = null;
        s_liukangVanishAnimation = null;
    }

    public static void cleanupSkeleton() {
        s_skeletonTileset = null;
        s_skeletonAnimation = null;
    }

    public static void removeFighterFromPool(Fighter fighter) {
        for (int i = 0; i < Fighter.s_pool.length; ++i) {
            if (Fighter.s_pool[i] != fighter) continue;
            Fighter.s_pool[i].m_poolState = 0;
        }
    }

    public static byte[][][] simplifyCombos(byte[][][] byArray) {
        byte[][][] byArrayArray = new byte[byArray.length][][];
        for (int i = 0; i < byArray.length; ++i) {
            byArrayArray[i] = new byte[byArray[i].length][];
            for (int j = 0; j < byArray[i].length; ++j) {
                if (j == 0) {
                    switch (i) {
                        case 0: {
                            byArrayArray[i][j] = new byte[2];
                            byArrayArray[i][j][0] = 9;
                            byArrayArray[i][j][1] = 2;
                            break;
                        }
                        case 1: {
                            byArrayArray[i][j] = new byte[2];
                            byArrayArray[i][j][0] = 7;
                            byArrayArray[i][j][1] = 2;
                            break;
                        }
                        case 2: {
                            byArrayArray[i][j] = new byte[1];
                            byArrayArray[i][j][0] = 2;
                        }
                    }
                    continue;
                }
                byArrayArray[i][j] = new byte[byArray[i][j].length];
                for (int k = 0; k < byArray[i][j].length; ++k) {
                    int n = byArray[i][j][k];
                    boolean bl = j % 2 == 0;
                    byArrayArray[i][j][k] = bl && (n == 0 || n == 1) ? 2 : n;
                }
            }
        }
        return byArrayArray;
    }

    public static void UpdateShaoKahnAI(Fighter fighter, int n, int n2, int n3, boolean bl) {
        Fighter fighter2 = fighter.getOpponent();
        switch (fighter.m_state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (fighter.m_previousState == 24 || fighter.m_previousState == 25 || fighter.m_previousState == 15) {
                    fighter.initState(26);
                    break;
                }
                if (fighter2.m_state == 10) {
                    if (fighter2.m_stateTimer < 200) {
                        fighter.initState(2);
                        break;
                    }
                    if (Battle.getOpponentsDistance() < 48) {
                        fighter.initState(21);
                        break;
                    }
                    fighter.initState(26);
                    break;
                }
                if (fighter2.m_state == 27 && fighter2.m_stateTimer < 630) break;
                if (fighter2.m_state == 21 || fighter2.m_state == 12) {
                    fighter.initState(MathTools.getRandomInt(0, 1) == 0 ? 21 : 26);
                    break;
                }
                if (fighter2.m_state == 9) {
                    if (fighter2.m_previousState == 8) {
                        fighter.initState(21);
                        break;
                    }
                    fighter.initState(26);
                    break;
                }
                if (fighter2.m_state == 6) {
                    fighter.initState(26);
                    break;
                }
                if (Battle.getOpponentsDistance() <= 48) {
                    int n4 = MathTools.getRandomInt(0, 3);
                    switch (n4) {
                        case 0: {
                            fighter.initState(4);
                            break;
                        }
                        case 1: {
                            fighter.initState(5);
                            break;
                        }
                        case 2: {
                            fighter.initState(21);
                            break;
                        }
                        case 3: {
                            fighter.initState(26);
                        }
                    }
                    break;
                }
                if (fighter2.m_state == 1) {
                    fighter.initState(2);
                    break;
                }
                fighter.initState(1);
            }
        }
    }

    protected static void updateState(Fighter fighter) {
        fighter.m_stateTimer += GameImpl.s_elapsedTimeClamped;
        fighter.updateRunMeter();
        fighter.updateAntiThrowTimer();
        fighter.m_timeSinceLastProjectile += GameImpl.s_elapsedTimeClamped;
        fighter.m_timeSinceLastSpecialMove += GameImpl.s_elapsedTimeClamped;
        if (fighter.canGuard(false)) {
            Battle.backToBlockable(fighter);
        }
        fighter.m_attackResetTimer += GameImpl.s_elapsedTimeClamped;
        fighter.addKeyToInputBuffer();
        if (fighter.isControllable()) {
            switch (fighter.getPlayerType()) {
                case 0: {
                    fighter.updateLocalControls();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    fighter.updateAI();
                }
            }
        }
        Special.checkTransit(fighter);
        switch (fighter.m_state) {
            case 35: {
                Physics.forceMovement(fighter, 0, 55296 * GameImpl.s_elapsedTimeClamped / 1000);
                break;
            }
            case 36: {
                if (fighter.m_previousState == 9 && fighter.m_stateTimer < 180) break;
                Physics.forceMovement(fighter, 0, 55296 * GameImpl.s_elapsedTimeClamped / 1000);
                break;
            }
            case 34: {
                fighter.cancelTrajectory();
                fighter.m_isOnGround = false;
                if (fighter.getY() <= -60) {
                    Physics.forceMovement(fighter, fighter.m_orientation * -1 * (3072 * GameImpl.s_elapsedTimeClamped) / 1000, 0);
                } else {
                    Physics.forceMovement(fighter, 0, -12288 * GameImpl.s_elapsedTimeClamped / 1000);
                }
                fighter.playNewAnim(3);
                break;
            }
            case 0: {
                if (fighter.m_animId != 1 || !fighter.animationFinished()) break;
                fighter.playNewAnim(0);
                break;
            }
            case 3: {
                if (fighter.m_animId != 5 || !fighter.animationFinished()) break;
                fighter.playNewAnimAtTheEnd(4);
                break;
            }
            case 2: {
                Physics.forceMovement(fighter, -21504 * fighter.m_orientation * GameImpl.s_elapsedTimeClamped / 1000, 0);
                break;
            }
            case 1: {
                Physics.forceMovement(fighter, 21504 * fighter.m_orientation * GameImpl.s_elapsedTimeClamped / 1000, 0);
                break;
            }
            case 8: {
                if (fighter.m_animId != 17 || fighter.m_stateTimer < 100) break;
                fighter.reversePlayNewAnim(18);
                break;
            }
            case 6: {
                if (fighter.m_animId != 17 || fighter.m_stateTimer < 100) break;
                fighter.playNewAnim(18);
                break;
            }
            case 12: {
                if (fighter.getPhysicsData()[0] == 0) {
                    Physics.forceMovement(fighter, 0, 5632 * GameImpl.s_elapsedTimeClamped / 1000);
                    break;
                }
                if (fighter.m_stateTimer >= fighter.m_physicsData[3] / 3) break;
                fighter.playNewAnim(3);
                break;
            }
            case 16: {
                Physics.forceMovement(fighter, 43008 * fighter.m_orientation * GameImpl.s_elapsedTimeClamped / 1000, 0);
                fighter.alterRunMeter(-25600 * GameImpl.s_elapsedTimeClamped / 1000);
                break;
            }
            case 10: {
                if (!fighter.m_attackConnected || fighter.m_stateTimer >= 1000) break;
                int n = Math.min(5, fighter.m_anims[fighter.m_animId].getNbFrames() - 1);
                fighter.m_animInstance = fighter.getCurrentAnimation().startInstanceAtFrame(n);
                break;
            }
            case 17: {
                if (fighter.m_thrownOpponent.m_state != 18) break;
                int[] nArray = fighter.getThrowData();
                int n = Animation.getInstanceCurrentFrame(fighter.m_animInstance);
                Special.forceThrowAnimationFrame(fighter.m_thrownOpponent, nArray, n, fighter.getX(), fighter.getY(), fighter.m_orientation * -1);
                break;
            }
            case 21: {
                short[] sArray;
                short[] sArray2 = sArray = fighter.m_isOnGround ? fighter.m_projectileData : fighter.m_airProjectileData;
                if (fighter.m_stateTimer <= sArray[3] || fighter.m_projectile != null) break;
                fighter.m_projectile = Projectile.createProjectile(sArray[0], fighter.getX() + sArray[1] * fighter.m_orientation, fighter.getY() + sArray[2], fighter.m_orientation, fighter.m_collidableGroupId, fighter);
                break;
            }
            case 100: {
                Fighter fighter2 = fighter.m_projectile.m_victim;
                if (Battle.getOpponentsDistance() > 48) {
                    Physics.forceMovement(fighter2, fighter.m_orientation * -1 * 49152 * GameImpl.s_elapsedTimeClamped / 1000, 0);
                }
                fighter2.forceAnimationFrame(3, 0);
                break;
            }
            case 102: {
                fighter.forceAnimationFrame(3, 0);
                break;
            }
            case 23: {
                if (fighter.m_stateTimer < 1000) {
                    fighter.m_isShaking = true;
                }
                fighter.forceAnimationFrame(fighter.m_animId, fighter.m_frozenFrame);
                if (fighter.m_fighterId == 0) {
                    fighter.resetProjectile();
                }
                fighter.resetThrow();
                break;
            }
            case 26: {
                Special.updateSpecialMove(fighter);
                break;
            }
            case 27: {
                Physics.forceMovement(fighter, fighter.m_orientation * -15360 * GameImpl.s_elapsedTimeClamped / 1000, 0);
                break;
            }
            case 28: {
                Special.updateFatality(fighter);
                break;
            }
            case 33: {
                Special.updateGenericBabality(fighter);
                break;
            }
            case 30: {
                if (fighter.m_attackConnected) {
                    fighter.m_autoUpdateAnimation = fighter.m_animFreezeTimer == 0;
                    fighter.m_animFreezeTimer = Math.max(0, fighter.m_animFreezeTimer - GameImpl.s_elapsedTimeClamped);
                    break;
                }
                Physics.forceMovement(fighter, 12288 * fighter.m_orientation * GameImpl.s_elapsedTimeClamped / 1000, 0);
            }
        }
        if (fighter.isInChangeableOrientationState()) {
            fighter.m_orientation = fighter.m_newOrientation;
        }
    }

    private static void forceThrowAnimationFrame(Fighter fighter, int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = 5 + n * 5;
        int n6 = nArray[n5 + 0];
        int n7 = nArray[n5 + 1];
        int n8 = nArray[n5 + 2];
        int n9 = nArray[n5 + 3];
        int n10 = nArray[n5 + 4];
        fighter.forceAnimationFrame(n8, n9);
        fighter.setPosition(n2 + n6 * n4 * -1, n3 + n7);
        fighter.m_throwTransformation = n10;
        fighter.m_orientation = n4;
    }

    public static void checkTransit(Fighter fighter) {
        switch (fighter.m_state) {
            case 35: {
                if (!fighter.m_isOnGround) break;
                fighter.m_isOnGround = true;
                fighter.initState(13);
                fighter.setPosition(fighter.getX(), 0);
                break;
            }
            case 36: {
                if (!fighter.m_isOnGround) break;
                fighter.m_isOnGround = true;
                fighter.initState(0);
                fighter.setPosition(fighter.getX(), 0);
                break;
            }
            case 102: {
                if (fighter.getOpponent().m_state == 21 || fighter.getOpponent().m_state == 101 || fighter.getOpponent().m_state == 100 || fighter.m_stateTimer <= 300) break;
                fighter.initState(0);
                break;
            }
            case 34: {
                if (fighter.m_stateTimer <= 3000) break;
                fighter.initState(35);
                break;
            }
            case 32: {
                if (fighter.m_stateTimer <= 2500) break;
                if (fighter.m_isOnGround) {
                    fighter.initState(0);
                    break;
                }
                fighter.initState(35);
                break;
            }
            case 3: {
                if (!fighter.healthDepleted()) break;
                fighter.initState(12);
                fighter.m_isTrajectoryLaunched = true;
                break;
            }
            case 0: {
                if (!fighter.healthDepleted()) break;
                if (Battle.s_battleState == 3) {
                    fighter.initState(22);
                    break;
                }
                fighter.initState(12);
                fighter.m_isTrajectoryLaunched = true;
                break;
            }
            case 4: {
                if (fighter.canPerformProjectile() && fighter.isCommandInInputBuffer(fighter.m_commands[0])) {
                    fighter.initState(21);
                    break;
                }
                if (fighter.canPerformSpecial() && fighter.isCommandInInputBuffer(fighter.m_commands[1])) {
                    fighter.initState(26);
                    break;
                }
                if (fighter.m_nextJab) {
                    if (fighter.m_stateTimer <= 200) break;
                    fighter.initState(31);
                    break;
                }
                if (!fighter.animationFinished()) break;
                fighter.initState(0);
                break;
            }
            case 5: {
                if (!fighter.animationFinished()) break;
                fighter.initState(0);
                break;
            }
            case 31: {
                if (fighter.canPerformProjectile() && fighter.isCommandInInputBuffer(fighter.m_commands[0])) {
                    fighter.initState(21);
                    break;
                }
                if (fighter.canPerformSpecial() && fighter.isCommandInInputBuffer(fighter.m_commands[1])) {
                    fighter.initState(26);
                    break;
                }
                if (fighter.m_nextJab) {
                    if ((!fighter.m_nextJabBackward || fighter.m_stateTimer < 250) && (fighter.m_nextJabBackward || fighter.m_stateTimer < 400)) break;
                    fighter.initState(31);
                    fighter.m_nextJab = false;
                    break;
                }
                if (!fighter.animationFinished() || fighter.m_stateTimer <= 700) break;
                fighter.initState(0);
                break;
            }
            case 10: {
                if (!fighter.animationFinished()) break;
                fighter.initState(0);
                break;
            }
            case 11: {
                if (!fighter.animationFinished()) break;
                fighter.initState(0);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (!fighter.m_isOnGround || fighter.m_stateTimer <= 500) break;
                fighter.initState(0);
                break;
            }
            case 9: {
                if (fighter.m_attackConnected) {
                    fighter.initState(36);
                    fighter.playNewAnimAtTheEnd(20);
                }
                if (!fighter.m_isOnGround) break;
                fighter.initState(0);
                break;
            }
            case 12: {
                if (fighter.m_stateTimer <= 200 || !fighter.m_isOnGround) break;
                fighter.initState(13);
                break;
            }
            case 13: {
                if (fighter.m_stateTimer <= 150 || fighter.healthDepleted() && Battle.s_battleState != 3) break;
                fighter.initState(14);
                break;
            }
            case 14: {
                if (!fighter.animationFinished()) break;
                if (!fighter.healthDepleted()) {
                    fighter.initState(0);
                    break;
                }
                if (Battle.s_battleState == 3) {
                    fighter.initState(22);
                    break;
                }
                fighter.initState(13);
                break;
            }
            case 15: {
                if (!fighter.animationFinished() || Battle.getFighterOpponent(fighter) != null && Battle.getFighterOpponent((Fighter)fighter).m_state == 30 && Battle.getFighterOpponent((Fighter)fighter).m_comboStep > 0) break;
                fighter.initState(0);
                break;
            }
            case 16: {
                if (!fighter.runMeterDepleted()) break;
                fighter.initState(0);
                break;
            }
            case 17: {
                if (fighter.canRejectOpponent() && fighter.m_thrownOpponent.m_state == 18) {
                    int[] nArray = fighter.getThrowData();
                    fighter.m_thrownOpponent.m_isTrajectoryLaunched = false;
                    fighter.m_thrownOpponent.m_trajectoryFpWidth = (nArray[2] << 8) * fighter.m_orientation * -1;
                    fighter.m_thrownOpponent.m_trajectoryFpHeight = nArray[3] << 8;
                    fighter.m_thrownOpponent.m_trajectoryDuration = nArray[4];
                    fighter.m_thrownOpponent.initState(19);
                    Special.forceThrowAnimationFrame(fighter.m_thrownOpponent, nArray, fighter.m_anims[16].getNbFrames() - 1, fighter.getX(), fighter.getY(), fighter.getOrientation() * -1);
                    if (fighter.m_fighterId == 5) {
                        Camera.cameraShake();
                    }
                }
                if (!fighter.canRecoverFromThrow()) break;
                fighter.initState(0);
                break;
            }
            case 19: {
                if (!fighter.m_isOnGround) break;
                fighter.initState(13);
                break;
            }
            case 21: {
                if (!fighter.canRecoverFromProjectile()) break;
                if (fighter.m_isOnGround) {
                    fighter.initState(0);
                    break;
                }
                fighter.initState(36);
                break;
            }
            case 100: {
                if (!fighter.animationFinished() || Battle.getOpponentsDistance() > 48) break;
                fighter.initState(0);
                fighter.m_projectile.m_victim.initState(22);
                fighter.m_projectile.initPoolState(3);
                break;
            }
            case 22: {
                if (Battle.s_battleState == 3 || Battle.s_battleState == 4 || fighter.healthDepleted() || fighter.m_stateTimer <= 1300 && fighter.getOpponent().m_isOnGround) break;
                fighter.initState(0);
                break;
            }
            case 101: {
                if (fighter.m_stateTimer <= 300) break;
                fighter.initState(100);
                break;
            }
            case 23: {
                if (fighter.m_stateTimer <= 3500) break;
                if (fighter.m_isOnGround) {
                    fighter.initState(0);
                    break;
                }
                fighter.initState(13);
                break;
            }
            case 24: {
                if (fighter.m_stateTimer <= 300) break;
                fighter.initState(0);
                break;
            }
            case 25: {
                if (fighter.m_stateTimer <= 300) break;
                if (fighter.hasRestrictedMovement()) {
                    fighter.initState(0);
                    break;
                }
                fighter.initState(3);
                break;
            }
            case 1: 
            case 2: {
                if (fighter.isControllable()) break;
                fighter.initState(0);
                break;
            }
            case 26: {
                Special.transitSpecialMove(fighter);
                break;
            }
            case 27: {
                if (fighter.m_stateTimer <= 630) break;
                if (fighter.m_isOnGround) {
                    fighter.initState(0);
                    break;
                }
                fighter.initState(35);
                break;
            }
            case 28: 
            case 33: {
                Special.transitFinisher(fighter);
                break;
            }
            case 30: {
                if (!fighter.animationFinished() || fighter.m_stateTimer < 600) break;
                fighter.initState(0);
            }
        }
    }

    public static void forceReject(Fighter fighter) {
        if (fighter.m_state == 27 || fighter.m_state == 12) {
            return;
        }
        if (fighter.m_isOnGround) {
            fighter.initState(27);
        } else {
            fighter.m_trajectoryDuration = IFighter.TRAJ_IMPACT_STANDARD[2];
            fighter.m_trajectoryFpHeight = IFighter.TRAJ_IMPACT_STANDARD[1] << 8;
            fighter.m_trajectoryFpWidth = -1 * fighter.m_orientation * IFighter.TRAJ_IMPACT_STANDARD[0] << 8;
            fighter.m_isTrajectoryLaunched = false;
            fighter.initState(12);
        }
    }

    public static void loadSpecificResources(int n) {
        switch (n) {
            case 5: {
                Particle.loadCyraxBloodResources();
                Particle.loadExplosion();
                break;
            }
            case 3: {
                Particle.loadPurpleBloodDrop();
                break;
            }
            case 6: {
                Particle.loadExplosion();
                break;
            }
            case 4: {
                Particle.loadExplosion();
                break;
            }
            case 2: {
                Special.loadKitanaSpecial();
            }
        }
    }

    public static void cleanupSpecificResources(int n) {
        switch (n) {
            case 5: {
                Particle.cleanupCyraxBloodResources();
                Particle.cleanupExplosion();
                break;
            }
            case 3: {
                Particle.cleanupPurpleBlood();
                break;
            }
            case 6: {
                Particle.cleanupExplosion();
                break;
            }
            case 4: {
                Particle.cleanupExplosion();
                break;
            }
            case 2: {
                Special.cleanupKitanaSpecial();
            }
        }
    }

    public static boolean isNoLongerInPool(int n) {
        for (int i = 0; i < Fighter.s_pool.length; ++i) {
            if (Fighter.s_pool[i] == null || Fighter.s_pool[i].m_fighterId != n) continue;
            return false;
        }
        return true;
    }

    public static void cleanupSonyaKiss() {
        s_isDeathKissVisible = false;
    }
}

