/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.Camera;
import com.ea.game.Fighter;
import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.ICollidable;
import com.ea.game.IFighter;
import com.ea.game.IProjectile;
import com.ea.game.Particle;
import com.ea.game.Physics;
import com.ea.game.Tileset;
import com.ea.sdk.SDKGraphics;
import java.io.IOException;

public class Projectile
implements ICollidable {
    private static Animation[][] s_anims;
    private static Tileset[] s_tilesets;
    public int m_animInstance;
    private int m_animId;
    int m_state;
    private int m_stateTimer;
    private boolean m_attackConnected;
    public static final int PROJECTILE_STATE_MOVING = 0;
    public static final int PROJECTILE_STATE_COLLIDED = 1;
    public static final int PROJECTILE_STATE_BLOCKED = 2;
    public static final int PROJECTILE_STATE_STARTING = 3;
    public int m_orientation;
    private int m_poolState = 0;
    public static final int POOL_STATE_INACTIVE = 0;
    public static final int POOL_STATE_LOADING = 1;
    public static final int POOL_STATE_ACTIVE = 2;
    public static final int POOL_STATE_CLEANING = 3;
    private static Projectile[] s_pool;
    public static final int MAX_PROJECTILES_IN_POOL = 8;
    int m_projectileId;
    private int m_previousState;
    private int m_poolStateTimer;
    int m_currentLoadingStep;
    private int m_poolIndex;
    private int m_collidableGroupId;
    public int[] m_physicsData = new int[11];
    Fighter m_victim;
    public Fighter m_owner;
    private boolean m_toggleBlink;
    private int m_launchedBloodEffects;
    public static final int PROJECTILE_ANIM_MOVING = 0;
    public static final int PROJECTILE_ANIM_COLLIDED = 1;
    public static final int PROJECTILE_ANIM_STARTING = 2;
    public static final int PROJECTILE_ANIM_DRAGGING = 3;
    public static final int PROJECTILE_ANIMS_COUNT = 4;
    private static final int TIMER_ATK_BOX_STATE_STARTING = 130;
    public static final int ORIENTATION_FACING_RIGHT = 1;
    public static final int ORIENTATION_FACING_LEFT = -1;

    private Projectile() {
    }

    public static Projectile createProjectile(int n, int n2, int n3, int n4, int n5, Fighter fighter) {
        Projectile projectile = null;
        int n6 = 0;
        for (n6 = 0; n6 < 8; ++n6) {
            if (s_pool[n6].isActive()) continue;
            projectile = s_pool[n6];
            projectile.setPoolIndex(n6);
            projectile.setProjectileId(n);
            projectile.setCollidableGroupId(n5);
            projectile.setPosition(n2, n3);
            projectile.setOrientation(n4);
            projectile.setOwner(fighter);
            projectile.initPoolState(2);
            return projectile;
        }
        return null;
    }

    private void setOwner(Fighter fighter) {
        this.m_owner = fighter;
    }

    private void setOrientation(int n) {
        this.m_orientation = n;
    }

    public void setCollidableGroupId(int n) {
        this.m_collidableGroupId = n;
    }

    public int getCollidableGroupId() {
        return this.m_collidableGroupId;
    }

    private void setPoolIndex(int n) {
        this.m_poolIndex = n;
    }

    private void setProjectileId(int n) {
        this.m_projectileId = n;
    }

    public void setPosition(int n, int n2) {
        this.m_physicsData[0] = n << 8;
        this.m_physicsData[1] = n2 << 8;
    }

    public static void initPool() {
        s_pool = new Projectile[8];
        s_anims = new Animation[7][4];
        s_tilesets = new Tileset[7];
        for (int i = 0; i < s_pool.length; ++i) {
            Projectile.s_pool[i] = new Projectile();
        }
    }

    void initPoolState(int n) {
        this.cleanupPoolState(this.m_poolState);
        switch (n) {
            case 2: {
                if (this.m_projectileId == 3 || this.m_projectileId == 5 || this.m_projectileId == 4 || this.m_projectileId == 1) {
                    this.initState(3);
                } else {
                    this.initState(0);
                }
                this.m_attackConnected = false;
                Physics.addCollidable(this, this.getCollidableGroupId());
                break;
            }
            case 3: {
                this.m_attackConnected = true;
                Physics.removeCollidable(this, this.getCollidableGroupId());
                this.m_owner = null;
            }
        }
        this.m_poolStateTimer = 0;
        this.m_poolState = n;
    }

    private void updatePoolState() {
        switch (this.m_poolState) {
            case 3: {
                this.initPoolState(0);
            }
        }
    }

    public static boolean resourcesForProjectileLoaded(int n) {
        return s_tilesets[n] != null && s_anims[n] != null;
    }

    public static void loadProjectileResources(int n) {
        Projectile.loadMainTileset(n);
        Projectile.loadCommonAnimations(n);
    }

    public static void cleanupProjectileResources(int n) {
        Projectile.cleanupMainTileset(n);
        Projectile.cleanupAnimations(n);
    }

    private void cleanupPoolState(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public static void releasePool() {
        s_pool = null;
        s_tilesets = null;
        s_anims = null;
    }

    public static void updateProjectiles() {
        if (s_pool == null) {
            Projectile.initPool();
        }
        for (int i = 0; i < s_pool.length; ++i) {
            s_pool[i].updatePoolState();
            if (!s_pool[i].isActive()) continue;
            s_pool[i].update();
        }
    }

    public void playNewAnim(int n) {
        this.m_animId = n;
        this.m_animInstance = 1;
    }

    public static void drawProjectiles(SDKGraphics sDKGraphics) {
        if (s_pool == null) {
            Projectile.initPool();
        }
        for (int i = 0; i < s_pool.length; ++i) {
            if (Projectile.s_pool[i].m_poolState != 2) continue;
            s_pool[i].draw(sDKGraphics);
        }
    }

    public static boolean loadMainTileset(int n) {
        int n2 = Projectile.getTilesetDeclaration(n);
        try {
            Projectile.s_tilesets[n] = FileManager.createTileset(n2, false);
        }
        catch (IOException iOException) {
            return true;
        }
        return false;
    }

    private static void cleanupMainTileset(int n) {
        Projectile.s_tilesets[n] = null;
    }

    public static int getTilesetDeclaration(int n) {
        return IProjectile.PROJECTILES_TILESETS_DECLARATIONS[n];
    }

    public static boolean loadCommonAnimations(int n) {
        int[] nArray = Projectile.getAnimationsDeclarations(n);
        int n2 = 0;
        try {
            Projectile.s_anims[n] = new Animation[nArray.length / 2];
            for (n2 = 0; n2 < nArray.length; n2 += 2) {
                int n3 = nArray[n2];
                int n4 = nArray[n2 + 1];
                Projectile.s_anims[n][n2 / 2] = Animation.loadAnimation(n3, n4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static void cleanupAnimations(int n) {
        int[] nArray = Projectile.getAnimationsDeclarations(n);
        int n2 = 0;
        for (n2 = 0; n2 < nArray.length; n2 += 2) {
            Projectile.s_anims[n][n2 / 2] = null;
        }
    }

    public static int[] getAnimationsDeclarations(int n) {
        return IProjectile.PROJECTILES_ANIMATIONS_DECLARATIONS[n];
    }

    public void update() {
        this.updateState();
        this.updateAnimation();
    }

    void initState(int n) {
        this.cleanupState(this.m_state);
        block0 : switch (n) {
            case 3: {
                this.playNewAnim(2);
                break;
            }
            case 0: {
                if (this.m_projectileId == 4) {
                    this.playNewAnimAtTheEnd(0);
                    break;
                }
                this.playNewAnim(0);
                break;
            }
            case 1: {
                if (this.m_projectileId == 4 || this.m_projectileId == 6) {
                    Particle.launchExplosion(this.m_victim.getX(), this.getY(), false, false);
                    this.deactivate();
                    return;
                }
                this.m_launchedBloodEffects = 0;
                this.playNewAnim(1);
                if (this.m_projectileId == 2) {
                    this.launchBloodEffect();
                    break;
                }
                if (this.m_projectileId == 3) {
                    this.playNewAnim(3);
                    this.setPosition(this.m_victim.getX(), this.m_victim.getY() + -9);
                    this.m_victim.initState(32);
                    break;
                }
                if (this.m_projectileId == 1) {
                    this.setPosition(this.m_victim.getX(), this.getY());
                    break;
                }
                if (this.m_projectileId != 5) break;
                Particle.launchPurpleBloodExplosion(this.m_victim.getX(), this.m_victim.getY() - 58);
                break;
            }
            case 2: {
                switch (this.m_projectileId) {
                    case 0: {
                        this.playNewAnimAtTheEnd(0);
                        break block0;
                    }
                    case 3: {
                        this.playNewAnim(1);
                        break block0;
                    }
                    case 4: 
                    case 6: {
                        Particle.launchExplosion(this.m_victim.getX(), this.getY(), false, false);
                        this.deactivate();
                        return;
                    }
                }
                this.playNewAnim(1);
            }
        }
        this.m_stateTimer = 0;
        this.m_previousState = this.m_state;
        this.m_state = n;
    }

    public void playNewAnimAtTheEnd(int n) {
        this.m_animId = n;
        Animation animation = this.getCurrentAnimation();
        this.m_animInstance = animation.createInstance(animation.getTotalDuration(), animation.getNbFrames() - 1, 1);
    }

    public Animation getCurrentAnimation() {
        if (s_anims == null || this.m_animId < 0 || this.m_animId >= s_anims[this.m_projectileId].length) {
            return null;
        }
        return s_anims[this.m_projectileId][this.m_animId];
    }

    public void updateAnimation() {
        Animation animation = this.getCurrentAnimation();
        if (animation != null) {
            this.m_animInstance = animation.updateInstance(this.m_animInstance, GameImpl.s_elapsedTimeClamped);
        }
    }

    public boolean animationFinished() {
        return Animation.getInstanceCurrentState(this.m_animInstance) == 0;
    }

    private void updateState() {
        this.m_stateTimer += GameImpl.s_elapsedTimeClamped;
        switch (this.m_state) {
            case 3: {
                if (this.m_owner == null || this.m_owner.m_state != 21) {
                    this.deactivate();
                    break;
                }
                if (!this.animationFinished()) break;
                this.initState(0);
                break;
            }
            case 0: {
                if (this.m_stateTimer <= 1500) break;
                this.deactivate();
                break;
            }
            case 1: {
                if (this.m_projectileId == 0) {
                    if (this.m_victim == null || this.m_victim.m_state != 102) {
                        this.initState(2);
                        break;
                    }
                    if (this.m_stateTimer <= 1500) break;
                    this.deactivate();
                    break;
                }
                if (this.m_projectileId == 1) {
                    if (!this.animationFinished()) break;
                    this.deactivate();
                    break;
                }
                if (this.m_projectileId == 3) {
                    if (this.m_victim != null && this.m_victim.m_state == 32) break;
                    this.m_victim = null;
                    this.initState(2);
                    break;
                }
                if (this.m_projectileId == 2) {
                    if (this.m_stateTimer / 400 > this.m_launchedBloodEffects && this.m_launchedBloodEffects < 2) {
                        this.launchBloodEffect();
                        ++this.m_launchedBloodEffects;
                    }
                    if (this.m_stateTimer < 750) {
                        this.setPosition(this.m_victim.getX() + this.m_victim.m_orientation * 7, this.getPositionY());
                        break;
                    }
                    if (this.m_stateTimer < 1500) {
                        this.translate(this.m_orientation * -1 * 73728 * GameImpl.s_elapsedTimeClamped / 1000, -61440 * GameImpl.s_elapsedTimeClamped / 1000);
                        break;
                    }
                    this.deactivate();
                    break;
                }
                if (this.m_projectileId != 5 || !this.animationFinished()) break;
                this.deactivate();
                break;
            }
            case 2: {
                if (this.m_projectileId == 0) {
                    if (this.m_stateTimer <= 500) break;
                    this.deactivate();
                    break;
                }
                if (this.m_projectileId == 2) {
                    if (this.m_stateTimer < 1500) {
                        this.translate(this.m_orientation * -1 * 73728 * GameImpl.s_elapsedTimeClamped / 1000, -61440 * GameImpl.s_elapsedTimeClamped / 1000);
                        break;
                    }
                    this.deactivate();
                    break;
                }
                if (!this.animationFinished()) break;
                this.deactivate();
            }
        }
        switch (this.m_state) {
            case 0: {
                this.translate(this.m_orientation * this.getFPSpeed() * GameImpl.s_elapsedTimeClamped / 1000, 0);
                break;
            }
            case 1: {
                if (this.m_projectileId == 0) {
                    int n = -16384;
                    this.m_physicsData[0] = this.m_victim.getPhysicsData()[0];
                    this.m_physicsData[1] = this.m_victim.getPhysicsData()[1] + n;
                    break;
                }
                if (this.m_projectileId != 3 || this.m_victim == null) break;
                Physics.forceMovement(this.m_victim, this.m_orientation * this.getFPSpeed() * GameImpl.s_elapsedTimeClamped / 1000, 0);
                this.setPosition(this.m_victim.getX(), this.m_victim.getY() + -9);
            }
        }
    }

    private int getX() {
        return this.m_physicsData[0] >> 8;
    }

    private int getY() {
        return this.m_physicsData[1] >> 8;
    }

    private void launchBloodEffect() {
        int n = this.m_orientation > 0 ? 2 : 1;
        Particle.launchParticleEffect(n, this.getPositionX(), this.getPositionY(), this.m_victim.m_fighterId == 5 ? 1 : 0);
    }

    public void forceAnimationFrame(int n, int n2) {
        this.m_animId = n;
        this.m_animInstance = this.getCurrentAnimation().startInstanceAtFrame(n2);
    }

    public void translate(int n, int n2) {
        this.m_physicsData[0] = this.m_physicsData[0] + n;
        this.m_physicsData[1] = this.m_physicsData[1] + n2;
    }

    private void drawState(SDKGraphics sDKGraphics) {
        int n = (this.m_physicsData[0] >> 8) - Camera.getCameraLeft();
        int n2 = (this.m_physicsData[1] >> 8) - Camera.getCameraTop();
        Animation animation = this.getCurrentAnimation();
        Tileset tileset = this.getTileset();
        boolean bl = this.m_toggleBlink = !this.m_toggleBlink;
        if ((!this.isBlinking() || this.m_toggleBlink) && tileset != null && animation != null) {
            int n3 = this.m_orientation == 1 ? 0 : 4;
            animation.drawInstance(this.m_animInstance, tileset, n, n2, n3);
        }
    }

    private boolean isBlinking() {
        return this.m_projectileId == 0 && this.m_state == 2;
    }

    private Tileset getTileset() {
        return s_tilesets[this.m_projectileId];
    }

    private void cleanupState(int n) {
    }

    public void draw(SDKGraphics sDKGraphics) {
        this.drawState(sDKGraphics);
    }

    public boolean skipPhysics() {
        return true;
    }

    public int[] getPhysicsData() {
        return this.m_physicsData;
    }

    public boolean getImpactData(int[] nArray, int n) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean getCollisionBox(int n, int n2, int[] nArray, int n3) {
        int n4 = this.getPositionX();
        int n5 = this.getPositionY();
        short[] sArray = null;
        switch (n) {
            case 1: {
                switch (this.m_state) {
                    case 0: {
                        sArray = IProjectile.PROJECTILES_ATTACKBOXES[this.m_projectileId];
                        break;
                    }
                    case 3: {
                        if (this.m_stateTimer <= 130) break;
                        sArray = IProjectile.PROJECTILES_ATTACKBOXES_STARTING[this.m_projectileId];
                    }
                }
                break;
            }
        }
        if (sArray == null) return false;
        nArray[n3 + 0] = n5 + sArray[0];
        nArray[n3 + 3] = n5 + sArray[3];
        if (this.m_orientation == 1) {
            nArray[n3 + 1] = n4 + sArray[1];
            nArray[n3 + 2] = n4 + sArray[2];
            return true;
        }
        nArray[n3 + 1] = n4 - sArray[2];
        nArray[n3 + 2] = n4 - sArray[1];
        return true;
    }

    public int getCollisionBoxesCount(int n) {
        if (n == 1 && (this.m_state == 0 || this.m_state == 3)) {
            return 1;
        }
        return 0;
    }

    public boolean getRequiredTrajectory(int[] nArray, int n) {
        return false;
    }

    public int onHit(ICollidable iCollidable, int[] nArray, int[] nArray2) {
        return 0;
    }

    public void onEnvironmentCollided(int n) {
        switch (n) {
            default: 
        }
    }

    public boolean isOnGround() {
        return false;
    }

    public boolean isNextToWall() {
        return false;
    }

    public void executeCueState() {
    }

    public void onAttackConnected(ICollidable iCollidable, int[] nArray) {
    }

    public void onAttackHit(Fighter fighter) {
        if (!this.m_attackConnected) {
            this.m_victim = fighter;
            this.m_owner.onProjectileHit();
            this.m_attackConnected = true;
            this.initState(1);
            if (this.m_projectileId == 3) {
                this.setPosition(this.m_victim.getX(), this.m_victim.getY() + -9);
                this.setOrientation(this.m_victim.getOrientation() * -1);
            } else if (this.m_projectileId == 5 || this.m_projectileId == 4) {
                if (this.m_victim.isOnGround()) {
                    this.m_victim.initState(27);
                } else {
                    this.m_victim.initState(12);
                    this.m_victim.applyTrajectory(IFighter.TRAJ_LAUNCHER_HORIZONTAL);
                }
            } else if (this.m_projectileId == 6) {
                this.m_victim.initState(12);
                this.m_victim.applyTrajectory(IFighter.TRAJ_LAUNCHER_HORIZONTAL_BIG);
            }
        }
    }

    public void onAttackBlocked(Fighter fighter) {
        if (!this.m_attackConnected) {
            this.m_owner.onProjectileBlocked();
            this.m_attackConnected = true;
            if (this.m_projectileId == 3) {
                this.m_victim = fighter;
                this.setPosition(this.m_victim.getX(), this.m_victim.getY() + -9);
                this.setOrientation(this.m_victim.getOrientation() * -1);
            } else if (this.m_projectileId == 1) {
                this.m_victim = fighter;
                this.setPosition(this.m_victim.getX(), this.getY());
            } else if (this.m_projectileId == 6) {
                this.m_victim = fighter;
                fighter.initState(27);
            } else if (this.m_projectileId == 5 || this.m_projectileId == 4) {
                this.m_victim = fighter;
                this.initState(1);
                return;
            }
            this.initState(2);
        }
    }

    public void executeQueueState() {
    }

    public int getPositionX() {
        return this.m_physicsData[0] >> 8;
    }

    public int getPositionY() {
        return this.m_physicsData[1] >> 8;
    }

    public boolean isLoaded() {
        return this.m_poolState == 2;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public boolean isActive() {
        return this.m_poolState == 2;
    }

    public void deactivate() {
        this.initPoolState(3);
    }

    public int getDamage() {
        return IProjectile.PROJECTILES_DAMAGE[this.m_projectileId];
    }

    public int getHitEffect(int n, boolean bl) {
        switch (this.m_projectileId) {
            case 0: {
                if (bl) break;
                return n == -1 ? 2 : 1;
            }
        }
        return -1;
    }

    public int getFPSpeed() {
        switch (this.m_projectileId) {
            case 3: {
                int n = 0;
                if (this.m_state == 1) {
                    int n2 = Math.min(900, this.m_stateTimer);
                    int n3 = -79872;
                    n = n3 * n2 / 900;
                }
                return 49152 + n;
            }
        }
        return 61440;
    }

    public boolean skipAdjustments() {
        return false;
    }

    public static void killAllProjectiles() {
        if (s_pool == null) {
            return;
        }
        for (int i = 0; i < s_pool.length; ++i) {
            s_pool[i].initPoolState(3);
        }
    }
}

