/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.GameImpl;
import com.ea.game.ICollidable;
import com.ea.game.MathTools;

public class Physics {
    public static final int GROUP_COUNT = 3;
    public static final int GROUP_FRIENDS_ID = 0;
    public static final int GROUP_FOES_ID = 1;
    public static final int GROUP_PARTICLES_ID = 2;
    public static final int MAX_COLLIDABLE_OBJECTS_AMOUNT = 50;
    private static ICollidable[][] s_collidableObjectArray = null;
    private static int[] s_objectsCount = null;
    private static int currentObjectId = -1;
    private static int s_currentGroupID = 0;
    public static final int COLLISIONBOX_DATA_LENGTH = 5;
    public static final int COLLISIONBOX_DATA_BUFFER_LENGTH = 20;
    private static int[] s_collisionBoxDataBuffer = null;
    private static int s_collisionBoxOffset = 0;
    private static int s_currentObjectCollisionBoxOffset = 0;
    public static final int MAX_PHYSICS_DATA_CHANGES_PER_OBJECT = 20;
    private static int[] s_physicsData = null;
    private static int[] s_correctionObjectData = null;
    private static int[] s_physicsColidedData = null;
    private static int[] s_physicsChangeData = null;
    private static int s_physicsOffset = 0;
    private static final int CAN_MOVE_DOWN = 1;
    private static final int CAN_MOVE_UP = 2;
    private static final int CAN_MOVE_LEFT = 4;
    private static final int CAN_MOVE_RIGHT = 8;
    private static final int COLLISION_NO_COLLISION = 0;
    private static final int COLLISION_LEFT_TOP = 1;
    private static final int COLLISION_RIGHT_TOP = 2;
    private static final int COLLISION_LEFT_MID = 3;
    private static final int COLLISION_RIGHT_MID = 4;
    private static final int COLLISION_LEFT_LOW = 5;
    private static final int COLLISION_RIGHT_LOW = 6;
    private static int[] s_correctionBuffer = null;
    private static final int CORRECTION_CURRENT_OBJECT_X = 0;
    private static final int CORRECTION_CURRENT_OBJECT_Y = 1;
    private static final int CORRECTION_TESTED_OBJECT_X = 2;
    private static final int CORRECTION_TESTED_OBJECT_Y = 3;
    private static final int CORRECTION_LENGTH = 4;
    private static int[] s_impactDataBuffer = null;
    private static int s_impactDataBufferOffset = 0;
    private static final int GRAVITY_LEVEL = 25600000;
    public static int s_fpGroundLevel = 0;
    public static int s_fpCeilingLevel = 0;
    public static int s_fpWallLeftLevel = 0;
    public static int s_fpWallRightLevel = 0;
    private static final int MAX_IMPACTS_IN_QUEUE = 50;
    private static int s_lastImpactOffset = 0;
    private static int s_trowQueuePosition = -1;
    private static final int IMPACT_QUEUE_COLLISION_BOUNDARIES_LEFT = 8;
    private static final int IMPACT_QUEUE_COLLISION_BOUNDARIES_TOP = 9;
    private static final int IMPACT_QUEUE_COLLISION_BOUNDARIES_RIGHT = 10;
    private static final int IMPACT_QUEUE_COLLISION_BOUNDARIES_BOTTOM = 11;
    private static final int IMPACT_QUEUE_GROUP_ID = 12;
    private static final int IMPACT_QUEUE_OBJECT_ID = 13;
    private static final int IMPACT_QUEUE_ATTACKING_GROUP_ID = 14;
    private static final int IMPACT_QUEUE_ATTACKING_OBJECT_ID = 15;
    private static final int IMPACT_QUEUE_SINGLE_IMPACT_DATA_LENGTH = 16;
    private static final int COLOR_HITBOX = 65280;
    private static final int COLOR_ATTACKBOX = 0xFF0000;
    private static int[] s_impactsQueue = new int[800];

    public static void setEnviroment(int n, int n2, int n3, int n4) {
        s_fpWallLeftLevel = n << 8;
        s_fpGroundLevel = n2 << 8;
        s_fpCeilingLevel = n3 << 8;
        s_fpWallRightLevel = n4 << 8;
    }

    public static void initPhysics() {
        s_collidableObjectArray = new ICollidable[3][50];
        s_collisionBoxDataBuffer = new int[20];
        s_physicsChangeData = new int[20];
        s_correctionBuffer = new int[4];
        s_objectsCount = new int[3];
        s_impactDataBuffer = new int[8];
        s_currentGroupID = 0;
    }

    public static void updatePhysics() {
        Physics.physicsUpdateTrajectories();
        Physics.physicsUpdateAdjustments();
        Physics.physicsUpdateCollisions();
    }

    public static void physicsUpdateCollisions() {
        int n;
        s_trowQueuePosition = -1;
        for (s_currentGroupID = 0; s_currentGroupID < 3; ++s_currentGroupID) {
            for (currentObjectId = 0; currentObjectId < s_objectsCount[s_currentGroupID]; ++currentObjectId) {
                for (n = 0; n < s_collidableObjectArray[s_currentGroupID][currentObjectId].getCollisionBoxesCount(1); ++n) {
                    if (!s_collidableObjectArray[s_currentGroupID][currentObjectId].getCollisionBox(1, n, s_collisionBoxDataBuffer, s_collisionBoxOffset)) continue;
                    s_currentObjectCollisionBoxOffset = s_collisionBoxOffset;
                    s_collisionBoxOffset += 5;
                    Physics.detectHits(true);
                    s_collisionBoxOffset -= 5;
                }
            }
        }
        if (s_trowQueuePosition == -1) {
            for (n = 0; n < s_lastImpactOffset; n += 16) {
                Physics.s_impactDataBuffer[0] = s_impactsQueue[n + 0];
                Physics.s_impactDataBuffer[1] = s_impactsQueue[n + 1];
                Physics.s_impactDataBuffer[2] = s_impactsQueue[n + 2];
                Physics.s_impactDataBuffer[3] = s_impactsQueue[n + 3];
                Physics.s_impactDataBuffer[4] = s_impactsQueue[n + 4];
                Physics.s_impactDataBuffer[5] = s_impactsQueue[n + 5];
                Physics.s_impactDataBuffer[6] = s_impactsQueue[n + 6];
                Physics.s_impactDataBuffer[7] = s_impactsQueue[n + 7];
                Physics.s_correctionBuffer[0] = s_impactsQueue[n + 8];
                Physics.s_correctionBuffer[1] = s_impactsQueue[n + 9];
                Physics.s_correctionBuffer[2] = s_impactsQueue[n + 10];
                Physics.s_correctionBuffer[3] = s_impactsQueue[n + 11];
                s_collidableObjectArray[s_impactsQueue[n + 12]][s_impactsQueue[n + 13]].onHit(s_collidableObjectArray[s_impactsQueue[n + 14]][s_impactsQueue[n + 15]], s_impactDataBuffer, s_correctionBuffer);
                s_collidableObjectArray[s_impactsQueue[n + 14]][s_impactsQueue[n + 15]].onAttackConnected(s_collidableObjectArray[s_impactsQueue[n + 12]][s_impactsQueue[n + 13]], s_impactDataBuffer);
            }
            s_lastImpactOffset = 0;
        } else {
            Physics.s_impactDataBuffer[0] = s_impactsQueue[s_trowQueuePosition + 0];
            Physics.s_impactDataBuffer[1] = s_impactsQueue[s_trowQueuePosition + 1];
            Physics.s_impactDataBuffer[2] = s_impactsQueue[s_trowQueuePosition + 2];
            Physics.s_impactDataBuffer[3] = s_impactsQueue[s_trowQueuePosition + 3];
            Physics.s_impactDataBuffer[4] = s_impactsQueue[s_trowQueuePosition + 4];
            Physics.s_impactDataBuffer[5] = s_impactsQueue[s_trowQueuePosition + 5];
            Physics.s_impactDataBuffer[6] = s_impactsQueue[s_trowQueuePosition + 6];
            Physics.s_impactDataBuffer[7] = s_impactsQueue[s_trowQueuePosition + 7];
            Physics.s_correctionBuffer[0] = s_impactsQueue[s_trowQueuePosition + 8];
            Physics.s_correctionBuffer[1] = s_impactsQueue[s_trowQueuePosition + 9];
            Physics.s_correctionBuffer[2] = s_impactsQueue[s_trowQueuePosition + 10];
            Physics.s_correctionBuffer[3] = s_impactsQueue[s_trowQueuePosition + 11];
            s_collidableObjectArray[s_impactsQueue[s_trowQueuePosition + 12]][s_impactsQueue[s_trowQueuePosition + 13]].onHit(s_collidableObjectArray[s_impactsQueue[s_trowQueuePosition + 14]][s_impactsQueue[s_trowQueuePosition + 15]], s_impactDataBuffer, s_correctionBuffer);
            s_collidableObjectArray[s_impactsQueue[s_trowQueuePosition + 14]][s_impactsQueue[s_trowQueuePosition + 15]].onAttackConnected(s_collidableObjectArray[s_impactsQueue[s_trowQueuePosition + 12]][s_impactsQueue[s_trowQueuePosition + 13]], s_impactDataBuffer);
            s_lastImpactOffset = 0;
        }
    }

    public static void physicsUpdateAdjustments() {
        ICollidable iCollidable;
        for (s_currentGroupID = 0; s_currentGroupID < 3; ++s_currentGroupID) {
            for (currentObjectId = 0; currentObjectId < s_objectsCount[s_currentGroupID]; ++currentObjectId) {
                iCollidable = s_collidableObjectArray[s_currentGroupID][currentObjectId];
                s_physicsData = iCollidable.getPhysicsData();
                if (s_physicsData == null || !iCollidable.skipAdjustments()) continue;
                return;
            }
        }
        for (s_currentGroupID = 0; s_currentGroupID < 3; ++s_currentGroupID) {
            for (currentObjectId = 0; currentObjectId < s_objectsCount[s_currentGroupID]; ++currentObjectId) {
                iCollidable = s_collidableObjectArray[s_currentGroupID][currentObjectId];
                s_physicsData = iCollidable.getPhysicsData();
                if (s_physicsData == null || iCollidable.skipAdjustments()) continue;
                for (int i = 0; i < iCollidable.getCollisionBoxesCount(0); ++i) {
                    if (!iCollidable.getCollisionBox(0, i, s_collisionBoxDataBuffer, s_collisionBoxOffset)) continue;
                    s_currentObjectCollisionBoxOffset = s_collisionBoxOffset;
                    s_collisionBoxOffset += 5;
                    Physics.makeAdjustments(s_correctionBuffer);
                    s_collisionBoxOffset -= 5;
                }
            }
        }
    }

    public static void physicsUpdateTrajectories() {
        for (s_currentGroupID = 0; s_currentGroupID < 3; ++s_currentGroupID) {
            for (currentObjectId = 0; currentObjectId < s_objectsCount[s_currentGroupID]; ++currentObjectId) {
                s_physicsData = s_collidableObjectArray[s_currentGroupID][currentObjectId].getPhysicsData();
                Physics.s_physicsData[10] = 0xFFFFFF;
                if (s_collidableObjectArray[s_currentGroupID][currentObjectId].skipPhysics() || s_physicsData == null) continue;
                if (s_collidableObjectArray[s_currentGroupID][currentObjectId].getRequiredTrajectory(s_physicsChangeData, s_physicsOffset)) {
                    Physics.applyTrajectory(s_physicsChangeData, s_physicsOffset);
                }
                Physics.makeMoves();
                if (s_physicsData[1] == s_fpGroundLevel) {
                    s_physicsData[10] = s_physicsData[10] ^ 1;
                }
                if (s_physicsData[1] == s_fpCeilingLevel) {
                    s_physicsData[10] = s_physicsData[10] ^ 2;
                }
                if (s_physicsData[0] == s_fpWallLeftLevel) {
                    s_physicsData[10] = s_physicsData[10] ^ 4;
                }
                if (s_physicsData[0] != s_fpWallRightLevel) continue;
                s_physicsData[10] = s_physicsData[10] ^ 8;
            }
        }
    }

    private static void addImpactToQueue(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 0] = nArray[0];
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 1] = nArray[1];
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 2] = nArray[2];
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 3] = nArray[3];
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 4] = nArray[4];
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 5] = nArray[5];
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 6] = nArray[6];
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 7] = nArray[7];
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 8] = nArray2[0];
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 9] = nArray2[1];
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 10] = nArray2[2];
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 11] = nArray2[3];
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 12] = n;
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 13] = n2;
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 14] = n3;
        Physics.s_impactsQueue[Physics.s_lastImpactOffset + 15] = n4;
        if ((s_impactsQueue[s_lastImpactOffset + 4] | 0x200) != 0) {
            s_trowQueuePosition = s_lastImpactOffset;
        }
        s_lastImpactOffset += 16;
    }

    private static void detectHits(boolean bl) {
        int n = 0;
        boolean bl2 = false;
        for (int i = 0; i < 3; ++i) {
            if (i == s_currentGroupID) continue;
            for (int j = 0; j < s_objectsCount[i]; ++j) {
                int n2;
                s_physicsColidedData = s_collidableObjectArray[i][j].getPhysicsData();
                for (n2 = 0; n2 < s_collidableObjectArray[i][j].getCollisionBoxesCount(0); ++n2) {
                    if (!s_collidableObjectArray[i][j].getCollisionBox(0, n2, s_collisionBoxDataBuffer, s_collisionBoxOffset) || (n = Physics.detectConflict(s_collisionBoxDataBuffer[s_collisionBoxOffset + 1], s_collisionBoxDataBuffer[s_collisionBoxOffset + 3], s_collisionBoxDataBuffer[s_collisionBoxOffset + 2], s_collisionBoxDataBuffer[s_collisionBoxOffset + 0])) == 0) continue;
                    s_collidableObjectArray[s_currentGroupID][currentObjectId].getImpactData(s_impactDataBuffer, s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 4]);
                    Physics.getCollisionBoundaries(s_collisionBoxDataBuffer[s_collisionBoxOffset + 1], s_collisionBoxDataBuffer[s_collisionBoxOffset + 3], s_collisionBoxDataBuffer[s_collisionBoxOffset + 2], s_collisionBoxDataBuffer[s_collisionBoxOffset + 0], s_correctionBuffer);
                    if (bl2) continue;
                    Physics.addImpactToQueue(s_impactDataBuffer, s_correctionBuffer, i, j, s_currentGroupID, currentObjectId);
                    bl2 = true;
                }
                for (n2 = 0; n2 < s_collidableObjectArray[i][j].getCollisionBoxesCount(1); ++n2) {
                    if (!s_collidableObjectArray[i][j].getCollisionBox(1, n2, s_collisionBoxDataBuffer, s_collisionBoxOffset) || (n = Physics.detectConflict(s_collisionBoxDataBuffer[s_collisionBoxOffset + 1], s_collisionBoxDataBuffer[s_collisionBoxOffset + 3], s_collisionBoxDataBuffer[s_collisionBoxOffset + 2], s_collisionBoxDataBuffer[s_collisionBoxOffset + 0])) == 0) continue;
                    s_collidableObjectArray[s_currentGroupID][currentObjectId].getImpactData(s_impactDataBuffer, s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 4]);
                    Physics.getCollisionBoundaries(s_collisionBoxDataBuffer[s_collisionBoxOffset + 1], s_collisionBoxDataBuffer[s_collisionBoxOffset + 3], s_collisionBoxDataBuffer[s_collisionBoxOffset + 2], s_collisionBoxDataBuffer[s_collisionBoxOffset + 0], s_correctionBuffer);
                    if (bl2) continue;
                    Physics.addImpactToQueue(s_impactDataBuffer, s_correctionBuffer, i, j, s_currentGroupID, currentObjectId);
                    bl2 = true;
                }
            }
        }
    }

    private static void applyTrajectory(int[] nArray, int n) {
        Physics.s_physicsData[4] = 0;
        Physics.s_physicsData[2] = nArray[n + 1];
        Physics.s_physicsData[3] = nArray[n + 2];
        Physics.s_physicsData[5] = nArray[n + 3];
        Physics.s_physicsData[6] = nArray[n + 4];
        Physics.s_physicsData[7] = nArray[n + 0];
        Physics.s_physicsData[8] = s_physicsData[0];
        Physics.s_physicsData[9] = s_physicsData[1];
        if (s_physicsData[7] == 5 && s_physicsData[6] < 0) {
            Physics.s_physicsData[4] = s_physicsData[3] / 2;
            Physics.s_physicsData[6] = -s_physicsData[6];
            Physics.s_physicsData[8] = s_physicsData[8] - s_physicsData[5] / 2;
            long l = 4L * (long)s_physicsData[6] * (long)s_physicsData[4];
            long l2 = l * (long)s_physicsData[4];
            Physics.s_physicsData[9] = s_physicsData[9] + (int)(l /= (long)s_physicsData[3]) - (int)(l2 /= (long)(s_physicsData[3] * s_physicsData[3]));
        }
    }

    private static void makeMoves() {
        if (s_physicsData[7] != 0) {
            if (s_physicsData[2] > 0) {
                s_physicsData[2] = s_physicsData[2] - GameImpl.s_elapsedTimeClamped;
            } else {
                Physics.s_physicsData[4] = s_physicsData[7] != 5 ? Math.min(s_physicsData[4] + GameImpl.s_elapsedTimeClamped, s_physicsData[3]) : s_physicsData[4] + GameImpl.s_elapsedTimeClamped;
                long l = 0L;
                switch (s_physicsData[7]) {
                    case 1: {
                        l = MathTools.cubicEaseIn(s_physicsData[4] << 8, s_physicsData[3] << 8);
                        break;
                    }
                    case 2: {
                        l = MathTools.cubicEaseOut(s_physicsData[4] << 8, s_physicsData[3] << 8);
                        break;
                    }
                    case 4: 
                    case 5: {
                        l = (s_physicsData[4] << 8) / s_physicsData[3];
                        break;
                    }
                    case 3: {
                        l = MathTools.easyInOut(s_physicsData[4] << 8, s_physicsData[3] << 8);
                    }
                }
                Physics.s_physicsData[0] = s_physicsData[8] + (int)(l * (long)s_physicsData[5] >> 8);
                switch (s_physicsData[7]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (s_physicsData[6] == 0) break;
                        Physics.s_physicsData[1] = s_physicsData[9] - (int)(l * (long)s_physicsData[6] >> 8);
                        break;
                    }
                    case 5: {
                        long l2 = 4L * (long)s_physicsData[6] * (long)s_physicsData[4];
                        long l3 = l2 * (long)s_physicsData[4];
                        Physics.s_physicsData[1] = s_physicsData[9] - (int)(l2 /= (long)s_physicsData[3]) + (int)(l3 /= (long)(s_physicsData[3] * s_physicsData[3]));
                    }
                }
                if (s_physicsData[7] != 5) {
                    if (s_physicsData[4] == s_physicsData[3]) {
                        Physics.s_physicsData[7] = 0;
                    }
                } else if (s_physicsData[1] >= s_fpGroundLevel) {
                    Physics.s_physicsData[7] = 0;
                    if (s_physicsData[1] == s_fpGroundLevel) {
                        s_physicsData[1] = s_physicsData[1] + 1;
                    }
                }
            }
        }
        if (s_physicsData[1] > s_fpGroundLevel) {
            s_collidableObjectArray[s_currentGroupID][currentObjectId].onEnvironmentCollided(8);
            Physics.s_physicsData[1] = s_fpGroundLevel;
        } else if (s_physicsData[1] < s_fpCeilingLevel) {
            s_collidableObjectArray[s_currentGroupID][currentObjectId].onEnvironmentCollided(1);
            if (s_currentGroupID != 2) {
                Physics.s_physicsData[1] = s_fpCeilingLevel;
            }
        }
        if (s_physicsData[0] < s_fpWallLeftLevel) {
            s_collidableObjectArray[s_currentGroupID][currentObjectId].onEnvironmentCollided(2);
            if (s_currentGroupID != 2) {
                Physics.s_physicsData[0] = s_fpWallLeftLevel;
            }
        } else if (s_physicsData[0] > s_fpWallRightLevel) {
            s_collidableObjectArray[s_currentGroupID][currentObjectId].onEnvironmentCollided(4);
            if (s_currentGroupID != 2) {
                Physics.s_physicsData[0] = s_fpWallRightLevel;
            }
        }
    }

    private static boolean makeAdjustments(int[] nArray) {
        int n = 0;
        for (int i = s_currentGroupID + 1; i < 3; ++i) {
            for (int j = 0; j < s_objectsCount[i]; ++j) {
                s_physicsColidedData = s_collidableObjectArray[i][j].getPhysicsData();
                for (int k = 0; k < s_collidableObjectArray[i][j].getCollisionBoxesCount(0); ++k) {
                    if (!s_collidableObjectArray[i][j].getCollisionBox(0, k, s_collisionBoxDataBuffer, s_collisionBoxOffset) || !Physics.makeCorrection(n = Physics.detectConflict(s_collisionBoxDataBuffer[s_collisionBoxOffset + 1], s_collisionBoxDataBuffer[s_collisionBoxOffset + 3], s_collisionBoxDataBuffer[s_collisionBoxOffset + 2], s_collisionBoxDataBuffer[s_collisionBoxOffset + 0]), nArray, i, j)) continue;
                    Physics.applyAdjustment(nArray, i, j);
                }
            }
        }
        return false;
    }

    private static void applyAdjustment(int[] nArray, int n, int n2) {
        s_physicsData[0] = s_physicsData[0] + (nArray[0] << 8);
        s_physicsData[1] = s_physicsData[1] + (nArray[1] << 8);
        if (s_physicsData[7] != 0) {
            s_physicsData[8] = s_physicsData[8] + (nArray[0] << 8);
            s_physicsData[9] = s_physicsData[9] + (nArray[1] << 8);
        }
        if (s_physicsData[7] != 0) {
            s_physicsData[8] = s_physicsData[8] + (nArray[2] << 8);
            s_physicsData[9] = s_physicsData[9] + (nArray[3] << 8);
        }
        if (s_physicsData[1] > s_fpGroundLevel) {
            s_collidableObjectArray[s_currentGroupID][currentObjectId].onEnvironmentCollided(8);
            Physics.s_physicsData[1] = s_fpGroundLevel;
        } else if (s_physicsData[1] < s_fpCeilingLevel) {
            s_collidableObjectArray[s_currentGroupID][currentObjectId].onEnvironmentCollided(1);
            Physics.s_physicsData[1] = s_fpCeilingLevel;
        }
        if (s_physicsData[0] < s_fpWallLeftLevel) {
            s_collidableObjectArray[s_currentGroupID][currentObjectId].onEnvironmentCollided(2);
            Physics.s_physicsData[0] = s_fpWallLeftLevel;
        } else if (s_physicsData[0] > s_fpWallRightLevel) {
            s_collidableObjectArray[s_currentGroupID][currentObjectId].onEnvironmentCollided(4);
            Physics.s_physicsData[0] = s_fpWallRightLevel;
        }
        s_physicsColidedData[0] = s_physicsColidedData[0] + (nArray[2] << 8);
        s_physicsColidedData[1] = s_physicsColidedData[1] + (nArray[3] << 8);
        if (s_physicsColidedData[1] > s_fpGroundLevel) {
            Physics.s_physicsColidedData[1] = s_fpGroundLevel;
        } else if (s_physicsColidedData[1] < s_fpCeilingLevel) {
            Physics.s_physicsColidedData[1] = s_fpCeilingLevel;
        }
        if (s_physicsColidedData[0] < s_fpWallLeftLevel) {
            Physics.s_physicsColidedData[0] = s_fpWallLeftLevel;
        } else if (s_physicsColidedData[0] > s_fpWallRightLevel) {
            Physics.s_physicsColidedData[0] = s_fpWallRightLevel;
        }
    }

    private static boolean makeCorrection(int n, int[] nArray, int n2, int n3) {
        boolean bl = false;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        s_correctionObjectData = s_collidableObjectArray[n2][n3].getPhysicsData();
        switch (n) {
            case 1: {
                nArray[0] = s_collisionBoxDataBuffer[s_collisionBoxOffset + 1] - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] - 1;
                if ((s_correctionObjectData[10] ^ 1) == 1) {
                    nArray[1] = s_collisionBoxDataBuffer[s_collisionBoxOffset + 0] - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 3];
                }
                bl = true;
                break;
            }
            case 2: {
                nArray[0] = s_collisionBoxDataBuffer[s_collisionBoxOffset + 2] - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] + 1;
                if ((s_correctionObjectData[10] ^ 1) == 1) {
                    nArray[1] = s_collisionBoxDataBuffer[s_collisionBoxOffset + 0] - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 3];
                }
                bl = true;
                break;
            }
            case 5: {
                nArray[2] = s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] - s_collisionBoxDataBuffer[s_collisionBoxOffset + 1] + 1;
                if ((s_correctionObjectData[10] ^ 1) == 1) {
                    nArray[3] = s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 0] - s_collisionBoxDataBuffer[s_collisionBoxOffset + 3];
                }
                bl = true;
                break;
            }
            case 6: {
                nArray[2] = s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] - s_collisionBoxDataBuffer[s_collisionBoxOffset + 2] - 1;
                if ((s_correctionObjectData[10] ^ 1) == 1) {
                    nArray[3] = s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 0] - s_collisionBoxDataBuffer[s_collisionBoxOffset + 3];
                }
                bl = true;
                break;
            }
            case 3: {
                if ((s_correctionObjectData[10] & 4) == 4 && (s_correctionObjectData[10] & 8) == 8) {
                    nArray[0] = (s_collisionBoxDataBuffer[s_collisionBoxOffset + 1] - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] >> 1) - 1;
                    nArray[2] = (s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] - s_collisionBoxDataBuffer[s_collisionBoxOffset + 1] >> 1) + 1;
                } else if ((s_correctionObjectData[10] & 4) == 4) {
                    nArray[0] = s_collisionBoxDataBuffer[s_collisionBoxOffset + 1] - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] - 1;
                } else if ((s_correctionObjectData[10] & 8) == 8) {
                    nArray[2] = s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] - s_collisionBoxDataBuffer[s_collisionBoxOffset + 1] + 1;
                }
                bl = true;
                break;
            }
            case 4: {
                if ((s_correctionObjectData[10] & 8) == 8 && (s_correctionObjectData[10] & 4) == 4) {
                    nArray[0] = (s_collisionBoxDataBuffer[s_collisionBoxOffset + 2] - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] >> 1) + 1;
                    nArray[2] = (s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] - s_collisionBoxDataBuffer[s_collisionBoxOffset + 2] >> 1) - 1;
                } else if ((s_correctionObjectData[10] & 8) == 8) {
                    nArray[0] = s_collisionBoxDataBuffer[s_collisionBoxOffset + 2] - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] + 1;
                } else if ((s_correctionObjectData[10] & 4) == 4) {
                    nArray[2] = s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] - s_collisionBoxDataBuffer[s_collisionBoxOffset + 2] - 1;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static int detectConflict(int n, int n2, int n3, int n4) {
        if (!(s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] < n3 && s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] > n || s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] > n3 && s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] < n)) {
            return 0;
        }
        if (!(s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 0] < n2 && s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 3] > n4 || s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 0] > n2 && s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 3] < n4)) {
            return 0;
        }
        if (s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 3] < n4 + (n2 - n4 >> 2)) {
            if (s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] + s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] > n3 + n) {
                return 2;
            }
            return 1;
        }
        if (s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 0] < n2 && s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 0] > n2 - (n2 - n4 >> 2)) {
            if (s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] + s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] > n3 + n) {
                return 6;
            }
            return 5;
        }
        if (s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] + s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] > n3 + n) {
            return 4;
        }
        return 3;
    }

    private static void getCollisionBoundaries(int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = 0;
        int n6 = 0;
        if (s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] > n && s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] < n) {
            n5 = Math.min(s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] - n, n3 - n);
        } else if (s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1] < n3) {
            n5 = Math.min(n3 - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1], s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2] - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1]);
        }
        if (s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 0] < n2) {
            n6 = Math.min(n2 - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 0], n2 - n4);
        } else if (s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 3] < n4) {
            n6 = Math.min(n4 - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 3], s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 0] - s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 3]);
        }
        int n7 = Math.min(n, s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 2]);
        int n8 = Math.min(n3, s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 1]);
        int n9 = Math.max(n4, s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 3]);
        int n10 = Math.max(n2, s_collisionBoxDataBuffer[s_currentObjectCollisionBoxOffset + 0]);
        if (n8 > n7) {
            n7 = n8;
        }
        if (n10 < n9) {
            n9 = n10;
        }
        nArray[0] = n9;
        nArray[3] = n9 + n6;
        nArray[1] = n7;
        nArray[2] = n7 + n5;
    }

    public static void drawPhysics() {
    }

    private static void drawDebugCollisionBox(int n, int[] nArray, int n2) {
    }

    public static void cleanupPhysics() {
        s_collidableObjectArray = null;
        s_collisionBoxDataBuffer = null;
        s_physicsChangeData = null;
        s_correctionBuffer = null;
    }

    public static void forceMovement(ICollidable iCollidable, int n, int n2) {
        s_physicsData = iCollidable.getPhysicsData();
        s_physicsData[0] = s_physicsData[0] + n;
        s_physicsData[1] = s_physicsData[1] + n2;
        if (s_physicsData[7] != 0) {
            s_physicsData[8] = s_physicsData[8] + n;
            s_physicsData[9] = s_physicsData[9] + n2;
        }
        if (s_physicsData[1] > s_fpGroundLevel) {
            iCollidable.onEnvironmentCollided(8);
            Physics.s_physicsData[1] = s_fpGroundLevel;
        } else if (s_physicsData[1] < s_fpCeilingLevel) {
            iCollidable.onEnvironmentCollided(1);
            Physics.s_physicsData[1] = s_fpCeilingLevel;
        }
        if (s_physicsData[0] < s_fpWallLeftLevel) {
            iCollidable.onEnvironmentCollided(2);
            Physics.s_physicsData[0] = s_fpWallLeftLevel;
        } else if (s_physicsData[0] > s_fpWallRightLevel) {
            iCollidable.onEnvironmentCollided(4);
            Physics.s_physicsData[0] = s_fpWallRightLevel;
        }
    }

    public static void addCollidable(ICollidable iCollidable, int n) {
        if (s_objectsCount[n] > 50) {
            return;
        }
        Physics.s_collidableObjectArray[n][Physics.s_objectsCount[n]] = iCollidable;
        int n2 = n;
        s_objectsCount[n2] = s_objectsCount[n2] + 1;
    }

    public static void removeCollidable(ICollidable iCollidable, int n) {
        for (int i = 0; i < s_objectsCount[n]; ++i) {
            if (!s_collidableObjectArray[n][i].equals(iCollidable)) continue;
            for (int j = i; j < s_objectsCount[n] - 1; ++j) {
                Physics.s_collidableObjectArray[n][j] = s_collidableObjectArray[n][j + 1];
            }
            int n2 = n;
            s_objectsCount[n2] = s_objectsCount[n2] - 1;
        }
    }
}

