/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.Arena;
import com.ea.game.Camera;
import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.IArena;
import com.ea.game.ICollidable;
import com.ea.game.MathTools;
import com.ea.game.Physics;
import com.ea.game.Tileset;
import java.io.IOException;

public class Particle
implements ICollidable {
    public static final byte MAX_PARTICLES_IN_POOL = 50;
    public static final byte PARTICLE_STATE_DEAD = 0;
    public static final byte PARTICLE_STATE_ALIVE = 1;
    public static final byte PARTICLE_STATE_GROUND = 2;
    public static final byte NUMBER_OF_BOUNCES = 2;
    public static final byte LIFE_CYCLE_TYPE_TIME_BASED = 0;
    public static final byte LIFE_CYCLE_TYPE_ANIMATION_BASED = 1;
    public static final byte LIFE_CYCLE_TYPE_PERSISTENT = 2;
    public static final byte BEHAVIOR_TYPE_LOOP_FORWARD = 0;
    public static final byte BEHAVIOR_TYPE_LOOP_BACKWARD = 1;
    public static final byte BEHAVIOR_TYPE_PLAY_ONCE_FORWARD = 2;
    public static final byte BEHAVIOR_TYPE_PLAY_ONCE_BACKWARD = 3;
    public static final byte BEHAVIOR_TYPE_PING_PONG = 4;
    public static final byte BEHAVIOR_TYPE_CURVE = 5;
    public static final byte NO_MORE_FREE_SLOTS = -1;
    public static final byte TRAJECTORY_DATA_WIDTH = 0;
    public static final byte TRAJECTORY_DATA_HEIGHT = 1;
    public static final byte TRAJECTORY_DATA_DURATION = 2;
    public static final int[][] UPPERCUT_TRAJECTORIES_DATA = new int[][]{{24, 120, 1200}, {-24, 120, 1200}, {48, 96, 1200}, {-48, 96, 1200}, {72, 72, 1000}, {-72, 72, 1000}};
    public static final int[][] PURPLE_EXPLOSION_TRAJECTORIES_DATA = new int[][]{{24, 120, 900}, {-24, 120, 900}, {48, 96, 900}, {-48, 96, 900}, {72, 72, 900}, {-72, 72, 900}};
    public static final byte PARTICLE_EFFECT_UPPERCUT = 0;
    public static final byte PARTICLE_EFFECT_STANDARD_BLOW_RIGHT = 1;
    public static final byte PARTICLE_EFFECT_STANDARD_BLOW_LEFT = 2;
    public static final int[][] STANDARD_BLOW_TRAJECTORIES_DATA = new int[][]{{24, 24, 550}, {48, 24, 650}, {72, 24, 620}, {48, 48, 610}, {72, 48, 580}, {48, 72, 590}};
    public static final int STANDARD_BLOW_TRAJECTORY_LIFE_TIME = 500;
    private static final int RANDOM_TRAJECTORY_SHIFT = 24;
    private static final int PARTICLE_FLOOR_DURATION_MIN = 1000;
    private static final int PARTICLE_FLOOR_DURATION_MAX = 2000;
    private static final int STANDARD_BLOW_CURVED_BLOOD_WIDTH = 48;
    private static final int STANDARD_BLOW_CURVED_BLOOD_HEIGHT = 48;
    private static final int STANDARD_BLOW_CURVED_BLOOD_DURATION = 600;
    private static final int BURNING_EFFECT_FLAMES_COUNT_Y = 6;
    private static final int BURNING_EFFECT_FLAMES_COUNT_X = 4;
    private static final int BURNING_EFFECT_FLAMES_SPACING_X = 9;
    private static final int BURNING_EFFECT_FLAMES_SPACING_Y = 14;
    private static final int[] BURNING_EFFECT_FLAMES = new int[]{12, -13, 0, -3, -12, 0, 4, -18, 0, 12, -26, 0, -3, -24, 0, 5, -33, 0, 9, -44, 100, -1, -42, 100, 19, -38, 100, -10, -37, 100, 15, -54, 200, 3, -54, 200, -8, -51, 200, 10, -64, 200, -2, -66, 200, 3, -75, 200, -13, -27, 200, 22, -27, 200};
    private static final int BURNING_EFFECT_FLAME_DX = 0;
    private static final int BURNING_EFFECT_FLAME_DY = 1;
    private static final int BURNING_EFFECT_FLAME_DELAY = 2;
    private static final int SIZEOF_BURNING_EFFECT_FLAME = 3;
    private static final int ICE_EXPLOSION_DELTA_X_1 = -18;
    private static final int ICE_EXPLOSION_DELTA_X_2 = -9;
    private static final int ICE_EXPLOSION_DELTA_X_3 = 0;
    private static final int ICE_EXPLOSION_DELTA_X_4 = 9;
    private static final int ICE_EXPLOSION_DELTA_X_5 = 18;
    private static final int ICE_EXPLOSION_WIDTH = 96;
    private static final int ICE_EXPLOSION_DELTA_Y = 7;
    private static final int ICE_EXPLOSION_Y_MIN = 120;
    private static final int ICE_EXPLOSION_Y_MAX = 165;
    private static final int ICE_EXPLOSION_TIMER_MULTIPLIER = 7;
    private static final int ICE_EXPLOSION_PASSES_COUNT = 5;
    private static final int BODY_MEMBERS_EXPLOSION_WIDTH = 24;
    private static final int BODY_MEMBERS_EXPLOSION_WIDTH_CYRAX = 6;
    private static final int BODY_MEMBERS_EXPLOSION_DELTA_Y = -4;
    private static Particle[] s_particlesPool;
    private static int s_particlesCount;
    private static int s_highestParticleID;
    public static final int PALETTE_BLOOD_RED = 0;
    public static final int PALETTE_BLOOD_CYRAX = 1;
    private static final int PALETTE_BLOOD_NUMBER = 2;
    public static Tileset[] s_bloodDropTileset;
    public static Tileset s_purpleBloodTileset;
    public static Tileset[] s_bloodSplashTileset;
    public static Tileset s_bloodExplosionTileset;
    public static Tileset s_explosionTileset;
    public static Tileset s_flameTileset;
    public static Animation s_flameAnimation1;
    public static Animation s_flameAnimation2;
    public static Tileset s_iceTileset;
    public static Animation[] s_iceAnimations;
    public static Animation s_bloodFlyingAnimation;
    public static Animation s_purpleBloodFlyingAnimation;
    public static Animation s_bloodGroundAnimation;
    public static Animation s_purpleBloodGroundAnimation;
    public static Animation s_bloodSplashAnimation;
    public static Animation s_bloodExplosionAnimation;
    public static Animation s_explosionAnimation;
    public int[] m_physicsData;
    public boolean m_isBouncing;
    public int m_bounceNumber;
    public int m_previousTrajectoryWidth = 0;
    public int m_previousTrajectoryHeight = 0;
    public int m_previousTrajectoryDuration = 0;
    public int m_nextTrajectoryWidth;
    public int m_nextTrajectoryHeight;
    public int m_nextTrajectoryDuration;
    private int m_nextTrajectoryDelay;
    public int m_state;
    public boolean m_isOnGround;
    public int m_behaviorType;
    public int m_timeToLive;
    public boolean m_isWallHitEnabled;
    public boolean m_isGroundHitKilling;
    public boolean m_isTrajectoryRandomized;
    public int m_lifeCycleType;
    public boolean m_isUsingGroundHitAnimation;
    public Tileset m_particleTileset;
    public Tileset m_groundHitTileset;
    public Animation m_particleAnimation;
    public Animation m_groundHitAnimation;
    public int m_currentAnimationInstance;
    public boolean m_isCurveParticleRotatingClockwise;
    public int m_currentDX;
    public int m_currentDY;
    public int m_previousPositionX;
    public int m_previousPositionY;
    public boolean m_isDrawnBehindPlayer;
    private static int[] ICE_PARTICLES_DECLARATIONS;
    private static int[] BODY_PARTS_DECLARATIONS;
    private static Tileset s_iceMystTileset;
    private static Animation s_iceMystAnimation;
    private static Tileset s_bodyMembersTileset;
    private static Animation[] s_bodyMembersAnimations;

    public static void cleanupPool() {
        s_particlesPool = null;
    }

    public static void cleanupBloodResources() {
        Particle.killAllParticles();
        s_bloodDropTileset = null;
        s_bloodSplashTileset = null;
        s_bloodFlyingAnimation = null;
        s_bloodGroundAnimation = null;
        s_bloodSplashAnimation = null;
    }

    public static void cleanUpParticleResources() {
        Particle.cleanupBloodResources();
        s_iceTileset = null;
        s_iceAnimations = null;
        s_bodyMembersTileset = null;
        s_bodyMembersAnimations = null;
        s_iceMystTileset = null;
        s_iceMystAnimation = null;
        Particle.cleanupExplosion();
        Particle.cleanupPurpleBlood();
        Particle.cleanupFlame();
        Particle.cleanupBloodExplosion();
    }

    public static void cleanupBloodExplosion() {
        s_bloodExplosionTileset = null;
        s_bloodExplosionAnimation = null;
    }

    public static void cleanupFlame() {
        s_flameTileset = null;
        s_flameAnimation1 = null;
        s_flameAnimation2 = null;
    }

    public static void cleanupExplosion() {
        s_explosionTileset = null;
    }

    public static void cleanupPurpleBlood() {
        s_purpleBloodTileset = null;
        s_purpleBloodGroundAnimation = null;
        s_purpleBloodFlyingAnimation = null;
    }

    public static void initPool() {
        s_particlesPool = new Particle[50];
        s_particlesCount = 0;
        s_highestParticleID = -1;
        for (int n = 0; n < 50; n = (int)((byte)(n + 1))) {
            Particle.s_particlesPool[n] = new Particle();
            Particle.s_particlesPool[n].m_physicsData = new int[11];
        }
    }

    public static void loadCyraxBloodResources() {
        if (s_bloodDropTileset[1] == null) {
            try {
                Particle.s_bloodDropTileset[1] = FileManager.createTileset(134217825, 134217822);
                Particle.s_bloodSplashTileset[1] = FileManager.createTileset(134217826, 134217823);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void cleanupCyraxBloodResources() {
        Particle.s_bloodDropTileset[1] = null;
        Particle.s_bloodSplashTileset[1] = null;
    }

    public static void loadPurpleBloodDrop() {
        if (s_purpleBloodTileset == null) {
            try {
                s_purpleBloodTileset = FileManager.createTileset(134217843);
                s_purpleBloodFlyingAnimation = Animation.loadAnimation(134217773, 1);
                s_purpleBloodGroundAnimation = Animation.loadAnimation(134217774, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void loadExplosion() {
        if (s_explosionTileset == null) {
            try {
                s_explosionTileset = FileManager.createTileset(134217841);
                s_explosionAnimation = Animation.loadAnimation(134217771, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void loadCyraxBloodExplosion() {
        if (s_bloodExplosionTileset == null) {
            try {
                s_bloodExplosionTileset = FileManager.createTileset(0x8000070, GameImpl.getBloodRed() ? (byte)0 : 3);
                s_bloodExplosionAnimation = Animation.loadAnimation(134217770, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void loadBloodResources() {
        if (s_bloodDropTileset == null) {
            try {
                s_bloodDropTileset = new Tileset[2];
                s_bloodSplashTileset = new Tileset[2];
                Particle.s_bloodDropTileset[0] = FileManager.createTileset(134217825, GameImpl.getBloodRed() ? (byte)0 : 3);
                Particle.s_bloodSplashTileset[0] = FileManager.createTileset(134217826, GameImpl.getBloodRed() ? (byte)0 : 3);
                s_bloodFlyingAnimation = Animation.loadAnimation(0x8000001, 1);
                s_bloodGroundAnimation = Animation.loadAnimation(0x8000000, 0);
                s_bloodSplashAnimation = Animation.loadAnimation(0x8000002, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void launchStandardCurvedBlood(int n, int n2, int n3, int n4, int n5, int n6) {
        if (GameImpl.getBloodDrawn()) {
            int n7 = MathTools.getRandomInt(1000, 2000);
            Particle.createParticle(n, n2, n3, n4, n5, 0, 5, 0, n5 + n7, (byte)5, false, true, false, false, true, false, s_bloodDropTileset[n6], s_bloodFlyingAnimation, s_bloodDropTileset[n6], s_bloodGroundAnimation);
        }
    }

    public static void launchPurpleCurvedBlood(int n, int n2, int n3, int n4, int n5) {
        int n6 = MathTools.getRandomInt(1000, 2000);
        Particle.createParticle(n, n2, n3, n4, n5, 0, 5, 0, n5 + n6, (byte)5, false, true, false, false, true, false, s_purpleBloodTileset, s_purpleBloodFlyingAnimation, s_purpleBloodTileset, s_purpleBloodGroundAnimation);
    }

    public static void launchBurningEffect(int n, int n2) {
        for (int i = 0; i < BURNING_EFFECT_FLAMES.length; i += 3) {
            int n3 = n + BURNING_EFFECT_FLAMES[i + 0];
            int n4 = n2 + BURNING_EFFECT_FLAMES[i + 1];
            int n5 = BURNING_EFFECT_FLAMES[i + 2];
            Animation animation = MathTools.getRandomInt(0, 1) == 0 ? s_flameAnimation1 : s_flameAnimation2;
            Particle.createParticle(n3, n4, 1, 1, 1000, n5, 5, 1, 0, (byte)2, false, false, false, false, false, false, s_flameTileset, animation, s_flameTileset, animation);
        }
    }

    public int getOrientation() {
        return 1;
    }

    public static void launchStandardBloodSplash(int n, int n2, int n3) {
        if (GameImpl.getBloodDrawn()) {
            Particle.createParticle(n, n2, 0, 0, 0, 0, 0, 1, 0, (byte)2, false, false, false, false, false, false, s_bloodSplashTileset[n3], s_bloodSplashAnimation, s_bloodSplashTileset[n3], s_bloodSplashAnimation);
        }
    }

    public static void launchStandardShortTimeBlood(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (GameImpl.getBloodDrawn()) {
            Particle.createParticle(n, n2, n3, n4, n5, 0, 5, 0, n6, (byte)5, false, false, true, true, true, false, s_bloodDropTileset[n7], s_bloodFlyingAnimation, s_bloodDropTileset[n7], s_bloodFlyingAnimation);
        }
    }

    public static void launchBloodExplosion(int n, int n2) {
        if (GameImpl.getBloodDrawn()) {
            Particle.createParticle(n, n2, 0, 0, 0, 0, 0, 1, 0, (byte)2, false, false, false, false, false, false, s_bloodExplosionTileset, s_bloodExplosionAnimation, s_bloodExplosionTileset, s_bloodExplosionAnimation);
        }
    }

    public static void launchExplosion(int n, int n2, boolean bl, boolean bl2) {
        Particle.createParticle(n, n2, 0, 0, 0, 0, 0, 1, 0, bl2 ? (byte)3 : 2, false, false, false, false, false, bl, s_explosionTileset, s_explosionAnimation, s_explosionTileset, s_explosionAnimation);
    }

    public static void launchPurpleBloodExplosion(int n, int n2) {
        for (int i = 0; i < PURPLE_EXPLOSION_TRAJECTORIES_DATA.length; ++i) {
            Particle.launchPurpleCurvedBlood(n, n2, PURPLE_EXPLOSION_TRAJECTORIES_DATA[i][0], PURPLE_EXPLOSION_TRAJECTORIES_DATA[i][1], PURPLE_EXPLOSION_TRAJECTORIES_DATA[i][2]);
        }
    }

    public static void launchParticleEffect(int n, int n2, int n3, int n4) {
        switch (n) {
            case 0: {
                Particle.launchStandardBloodSplash(n2, n3, n4);
                for (int i = 0; i < UPPERCUT_TRAJECTORIES_DATA.length; ++i) {
                    Particle.launchStandardCurvedBlood(n2, n3, UPPERCUT_TRAJECTORIES_DATA[i][0], UPPERCUT_TRAJECTORIES_DATA[i][1], UPPERCUT_TRAJECTORIES_DATA[i][2], n4);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < STANDARD_BLOW_TRAJECTORIES_DATA.length; ++i) {
                    Particle.launchStandardShortTimeBlood(n2, n3, STANDARD_BLOW_TRAJECTORIES_DATA[i][0], STANDARD_BLOW_TRAJECTORIES_DATA[i][1], STANDARD_BLOW_TRAJECTORIES_DATA[i][2], 500, n4);
                }
                Particle.launchStandardCurvedBlood(n2, n3, 48, 48, 600, n4);
                Particle.launchStandardCurvedBlood(n2, n3, 48, 48, 600, n4);
                Particle.launchStandardCurvedBlood(n2, n3, 48, 48, 600, n4);
                break;
            }
            case 2: {
                for (int i = 0; i < STANDARD_BLOW_TRAJECTORIES_DATA.length; ++i) {
                    Particle.launchStandardShortTimeBlood(n2, n3, -STANDARD_BLOW_TRAJECTORIES_DATA[i][0], STANDARD_BLOW_TRAJECTORIES_DATA[i][1], STANDARD_BLOW_TRAJECTORIES_DATA[i][2], 500, n4);
                }
                Particle.launchStandardCurvedBlood(n2, n3, -48, 48, 600, n4);
                Particle.launchStandardCurvedBlood(n2, n3, -48, 48, 600, n4);
                Particle.launchStandardCurvedBlood(n2, n3, -48, 48, 600, n4);
            }
        }
    }

    private static void killParticle(Particle particle) {
        Physics.removeCollidable(particle, 2);
        particle.m_state = 0;
        particle.m_particleTileset = null;
        particle.m_particleAnimation = null;
        particle.m_groundHitTileset = null;
        particle.m_groundHitAnimation = null;
        --s_particlesCount;
        int n = -1;
        for (int n2 = 0; n2 <= s_highestParticleID; n2 = (int)((byte)(n2 + 1))) {
            if (Particle.s_particlesPool[n2].m_state == 0) continue;
            n = n2;
        }
        s_highestParticleID = n;
    }

    private static byte getNextEmptyPoolID() {
        int n = -1;
        for (int n2 = 0; n2 < 50; n2 = (int)((byte)(n2 + 1))) {
            if (Particle.s_particlesPool[n2].m_state != 0) continue;
            n = n2;
            break;
        }
        return (byte)n;
    }

    public static boolean createParticle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, byte by, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Tileset tileset, Animation animation, Tileset tileset2, Animation animation2) {
        byte by2 = Particle.getNextEmptyPoolID();
        if (by2 != -1) {
            Particle.s_particlesPool[by2].m_physicsData[0] = n << 8;
            Particle.s_particlesPool[by2].m_physicsData[1] = n2 << 8;
            Particle.s_particlesPool[by2].m_nextTrajectoryWidth = n3;
            Particle.s_particlesPool[by2].m_nextTrajectoryHeight = n4;
            Particle.s_particlesPool[by2].m_nextTrajectoryDuration = n5;
            Particle.s_particlesPool[by2].m_nextTrajectoryDelay = n6;
            Particle.s_particlesPool[by2].m_physicsData[2] = n6;
            Particle.s_particlesPool[by2].m_physicsData[7] = n7;
            Particle.s_particlesPool[by2].m_lifeCycleType = n8;
            Particle.s_particlesPool[by2].m_timeToLive = n9;
            Particle.s_particlesPool[by2].m_behaviorType = by;
            Particle.s_particlesPool[by2].m_isBouncing = bl;
            Particle.s_particlesPool[by2].m_isUsingGroundHitAnimation = bl2;
            Particle.s_particlesPool[by2].m_isWallHitEnabled = bl3;
            Particle.s_particlesPool[by2].m_isGroundHitKilling = bl4;
            Particle.s_particlesPool[by2].m_isTrajectoryRandomized = bl5;
            Particle.s_particlesPool[by2].m_particleTileset = tileset;
            Particle.s_particlesPool[by2].m_particleAnimation = animation;
            Particle.s_particlesPool[by2].m_groundHitTileset = tileset2;
            Particle.s_particlesPool[by2].m_groundHitAnimation = animation2;
            Particle.s_particlesPool[by2].m_isDrawnBehindPlayer = bl6;
            Particle.s_particlesPool[by2].m_state = 1;
            Particle.s_particlesPool[by2].m_bounceNumber = 0;
            switch (by) {
                case 0: {
                    Particle.s_particlesPool[by2].m_currentAnimationInstance = 1;
                    Particle.s_particlesPool[by2].m_particleAnimation.setLoopMode(1);
                    break;
                }
                case 1: {
                    Particle.s_particlesPool[by2].m_currentAnimationInstance = 2;
                    Particle.s_particlesPool[by2].m_particleAnimation.setLoopMode(1);
                    break;
                }
                case 2: {
                    Particle.s_particlesPool[by2].m_currentAnimationInstance = 1;
                    Particle.s_particlesPool[by2].m_particleAnimation.setLoopMode(0);
                    break;
                }
                case 3: {
                    Particle.s_particlesPool[by2].m_currentAnimationInstance = 2;
                    Particle.s_particlesPool[by2].m_particleAnimation.setLoopMode(0);
                    Particle.s_particlesPool[by2].m_currentAnimationInstance = Particle.s_particlesPool[by2].m_particleAnimation.startInstanceFromEnd();
                    break;
                }
                case 4: {
                    Particle.s_particlesPool[by2].m_currentAnimationInstance = 1;
                    Particle.s_particlesPool[by2].m_particleAnimation.setLoopMode(2);
                    break;
                }
            }
            Physics.addCollidable(s_particlesPool[by2], 2);
            ++s_particlesCount;
            if (by2 > s_highestParticleID) {
                s_highestParticleID = by2;
            }
            return true;
        }
        return false;
    }

    public static void updateParticles() {
        for (int i = 0; i < s_particlesPool.length; ++i) {
            Particle particle = s_particlesPool[i];
            if (particle == null || particle.m_state == 0) continue;
            Particle.updateParticle(particle);
        }
    }

    private static void updateCurveParticleAnimationFrame(Particle particle) {
        int n;
        if (particle.m_state != 1) {
            return;
        }
        int n2 = MathTools.getAngle(particle.m_currentDX, particle.m_currentDY);
        int n3 = n2 * particle.m_particleAnimation.getNbFrames() / 360;
        if (n3 != (n = Animation.getInstanceCurrentFrame(particle.m_currentAnimationInstance))) {
            if (particle.m_isCurveParticleRotatingClockwise) {
                if (n3 < n) {
                    n3 = n;
                }
            } else if (n3 > n) {
                n3 = n;
            }
            particle.m_currentAnimationInstance = particle.m_particleAnimation.startInstanceAtFrame(n3);
        }
    }

    private Particle() {
    }

    private static int getCurrentFrameHeight(Particle particle) {
        int[] nArray = new int[4];
        particle.m_particleAnimation.computeFrameBoundingBox(Animation.getInstanceCurrentFrame(particle.m_currentAnimationInstance), particle.m_particleTileset, 0, nArray, 0);
        return nArray[3] - nArray[1];
    }

    private static void updateParticle(Particle particle) {
        if (particle.m_physicsData[2] > 0) {
            return;
        }
        particle.m_currentDX = particle.m_physicsData[0] - particle.m_previousPositionX;
        particle.m_currentDY = particle.m_physicsData[1] - particle.m_previousPositionY;
        particle.m_previousPositionX = particle.m_physicsData[0];
        particle.m_previousPositionY = particle.m_physicsData[1];
        switch (particle.m_state) {
            case 1: {
                if (particle.m_behaviorType == 5) {
                    Particle.updateCurveParticleAnimationFrame(particle);
                } else {
                    particle.m_currentAnimationInstance = particle.m_particleAnimation.updateInstance(particle.m_currentAnimationInstance, GameImpl.s_elapsedTimeClamped);
                }
                if (!particle.m_isUsingGroundHitAnimation || particle.m_currentDY <= 0 || (Particle.getCurrentFrameHeight(particle) << 8) / 2 + particle.m_physicsData[1] < Physics.s_fpGroundLevel) break;
                particle.m_currentAnimationInstance = 1;
                particle.m_state = 2;
                particle.m_physicsData[1] = Physics.s_fpGroundLevel;
                if (particle.m_isTrajectoryRandomized) {
                    particle.m_physicsData[1] = particle.m_physicsData[1] + (MathTools.getRandomInt(0, IArena.ARENA_DATA[Arena.s_currentArenaId][21]) - IArena.ARENA_DATA[Arena.s_currentArenaId][21] / 2 << 8);
                }
                particle.m_isDrawnBehindPlayer = true;
                break;
            }
            case 2: {
                particle.m_currentAnimationInstance = particle.m_groundHitAnimation.updateInstance(particle.m_currentAnimationInstance, GameImpl.s_elapsedTimeClamped);
            }
        }
        switch (particle.m_lifeCycleType) {
            case 0: {
                particle.m_timeToLive -= GameImpl.s_elapsedTimeClamped;
                if (particle.m_timeToLive >= 0) break;
                Particle.killParticle(particle);
                break;
            }
            case 1: {
                if (Animation.getInstanceCurrentState(particle.m_currentAnimationInstance) != 0) break;
                Particle.killParticle(particle);
                break;
            }
        }
        if (particle.m_isWallHitEnabled && (particle.m_physicsData[0] >> 8 < Camera.getCameraLeft() || particle.m_physicsData[0] >> 8 > Camera.getCameraRight())) {
            Particle.killParticle(particle);
        }
    }

    public static void drawParticlesBehindPlayer() {
        for (int i = 0; i < s_particlesPool.length; ++i) {
            Particle particle = s_particlesPool[i];
            if (particle == null || particle.m_state == 0 || !particle.m_isDrawnBehindPlayer) continue;
            Particle.drawParticle(particle);
        }
    }

    public static void drawParticlesOverPlayer() {
        for (int i = 0; i < s_particlesPool.length; ++i) {
            Particle particle = s_particlesPool[i];
            if (particle == null || particle.m_state == 0 || particle.m_isDrawnBehindPlayer) continue;
            Particle.drawParticle(particle);
        }
    }

    private static void drawParticle(Particle particle) {
        if (particle.m_physicsData[2] > 0) {
            return;
        }
        int n = particle.m_physicsData[0] >> 8;
        int n2 = particle.m_physicsData[1] >> 8;
        n -= Camera.getCameraLeft();
        n2 -= Camera.getCameraTop();
        switch (particle.m_state) {
            case 2: {
                if (particle.m_groundHitTileset == null || particle.m_groundHitAnimation == null) break;
                particle.m_groundHitAnimation.drawInstance(particle.m_currentAnimationInstance, particle.m_groundHitTileset, n, n2, 0);
                break;
            }
            case 1: {
                if (particle.m_particleTileset == null || particle.m_particleAnimation == null) break;
                particle.m_particleAnimation.drawInstance(particle.m_currentAnimationInstance, particle.m_particleTileset, n, n2, 0);
            }
        }
    }

    public boolean skipPhysics() {
        return this.m_state == 2;
    }

    public int[] getPhysicsData() {
        return this.m_physicsData;
    }

    public boolean getImpactData(int[] nArray, int n) {
        return false;
    }

    public boolean getCollisionBox(int n, int n2, int[] nArray, int n3) {
        return false;
    }

    public int getCollisionBoxesCount(int n) {
        return 0;
    }

    private static boolean generateRequiredTrajectory(Particle particle, int[] nArray, int n) {
        if (particle.m_nextTrajectoryWidth != 0 || particle.m_nextTrajectoryHeight != 0) {
            particle.m_previousTrajectoryWidth = particle.m_nextTrajectoryWidth;
            particle.m_previousTrajectoryHeight = particle.m_nextTrajectoryHeight;
            particle.m_previousTrajectoryDuration = particle.m_nextTrajectoryDuration;
            if (particle.m_bounceNumber == 0 && particle.m_isTrajectoryRandomized) {
                int n2 = MathTools.getRandomInt(0, 24) - 12;
                particle.m_nextTrajectoryWidth += n2;
                int n3 = MathTools.getRandomInt(0, 24) - 12;
                particle.m_nextTrajectoryHeight += n3;
            }
            nArray[n + 0] = particle.m_physicsData[7];
            nArray[n + 1] = 0;
            nArray[n + 2] = particle.m_nextTrajectoryDuration;
            nArray[n + 3] = particle.m_nextTrajectoryWidth << 8;
            nArray[n + 4] = particle.m_nextTrajectoryHeight << 8;
            nArray[n + 1] = particle.m_nextTrajectoryDelay;
            if (particle.m_behaviorType == 5) {
                if (particle.m_nextTrajectoryWidth > 0) {
                    particle.m_isCurveParticleRotatingClockwise = true;
                    particle.m_currentAnimationInstance = particle.m_particleAnimation.startInstanceAtFrame(0);
                } else {
                    particle.m_isCurveParticleRotatingClockwise = false;
                    particle.m_currentAnimationInstance = particle.m_particleAnimation.startInstanceAtFrame(particle.m_particleAnimation.getNbFrames() - 1);
                }
            }
            particle.m_nextTrajectoryWidth = 0;
            particle.m_nextTrajectoryHeight = 0;
            particle.m_previousPositionX = particle.m_physicsData[0];
            particle.m_previousPositionY = particle.m_physicsData[1];
            return true;
        }
        return false;
    }

    public boolean getRequiredTrajectory(int[] nArray, int n) {
        return Particle.generateRequiredTrajectory(this, nArray, n);
    }

    private static boolean addNextBounce(Particle particle) {
        if (particle.m_bounceNumber < 2) {
            ++particle.m_bounceNumber;
            particle.m_nextTrajectoryWidth = (short)(particle.m_previousTrajectoryWidth / 2);
            particle.m_nextTrajectoryHeight = (short)(Math.abs(particle.m_previousTrajectoryHeight) / 2);
            particle.m_nextTrajectoryDuration = (short)(particle.m_previousTrajectoryDuration / 2);
            particle.m_physicsData[7] = 5;
            return true;
        }
        return false;
    }

    public int onHit(ICollidable iCollidable, int[] nArray, int[] nArray2) {
        return 0;
    }

    public void onEnvironmentCollided(int n) {
        switch (n) {
            case 8: {
                this.m_isOnGround = true;
                if (this.m_isBouncing) {
                    if (Particle.addNextBounce(this)) {
                        this.m_isOnGround = false;
                        break;
                    }
                    this.m_isBouncing = false;
                    this.m_currentAnimationInstance = 0;
                    break;
                }
                if (!this.m_isGroundHitKilling) break;
                Particle.killParticle(this);
                break;
            }
        }
    }

    public boolean isOnGround() {
        return this.m_isOnGround;
    }

    public boolean isNextToWall() {
        return false;
    }

    public void executeQueueState() {
    }

    public void onAttackConnected(ICollidable iCollidable, int[] nArray) {
    }

    public static void loadFlamesResources() {
        if (s_flameTileset == null || s_flameAnimation1 == null || s_flameAnimation2 == null) {
            try {
                s_flameTileset = FileManager.createTileset(134217835);
                s_flameAnimation1 = Animation.loadAnimation(134217755, 0);
                s_flameAnimation2 = Animation.loadAnimation(134217756, 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void launchScorpionFireballEffect(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Particle.createParticle(n, n2, n3 - n, n2, n7, n6, 2, 0, n5, (byte)0, false, false, false, false, false, false, s_flameTileset, s_flameAnimation1, s_flameTileset, s_flameAnimation1);
    }

    public static void launchSubzeroIceBreathEffect(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Particle.createParticle(n, n2, n3 - n, n2 - n4, n7, n6, 2, 0, n5, (byte)0, false, false, false, false, false, false, s_iceMystTileset, s_iceMystAnimation, s_iceMystTileset, s_iceMystAnimation);
    }

    public static void loadIceParticlesResources() {
        if (s_iceTileset == null || s_iceAnimations == null) {
            try {
                int[] nArray = ICE_PARTICLES_DECLARATIONS;
                Tileset tileset = FileManager.createTileset(nArray[0]);
                Animation[] animationArray = new Animation[(nArray.length - 1) / 2];
                for (int i = 1; i < nArray.length; i += 2) {
                    animationArray[i / 2] = Animation.loadAnimation(nArray[i], nArray[i + 1]);
                }
                s_iceTileset = tileset;
                s_iceAnimations = animationArray;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void loadBodyPartsResources() {
        if (s_bodyMembersTileset == null || s_bodyMembersAnimations == null) {
            try {
                int[] nArray = BODY_PARTS_DECLARATIONS;
                Tileset tileset = FileManager.createTileset(nArray[0]);
                Animation[] animationArray = new Animation[(nArray.length - 1) / 2];
                for (int i = 1; i < nArray.length; i += 2) {
                    animationArray[i / 2] = Animation.loadAnimation(nArray[i], nArray[i + 1]);
                }
                s_bodyMembersTileset = tileset;
                s_bodyMembersAnimations = animationArray;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void loadIceBreathResources() {
        if (s_iceMystTileset == null || s_iceMystAnimation == null) {
            try {
                s_iceMystTileset = FileManager.createTileset(134217837);
                s_iceMystAnimation = Animation.loadAnimation(134217758, 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void launchIceExplosion(int n, int n2) {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < s_iceAnimations.length; ++j) {
                int n3 = 0;
                switch (i) {
                    case 0: {
                        n3 = -18;
                        break;
                    }
                    case 1: {
                        n3 = -9;
                        break;
                    }
                    case 2: {
                        n3 = 0;
                        break;
                    }
                    case 3: {
                        n3 = 9;
                        break;
                    }
                    case 4: {
                        n3 = 18;
                    }
                }
                int n4 = -j * 7;
                int n5 = MathTools.getRandomInt(0, 96) - 48;
                int n6 = MathTools.getRandomInt(120, 165);
                int n7 = n6 * 7;
                Particle.createParticle(n + n3, n2 + n4, n5, n6, n7, 0, 5, 2, 0, (byte)0, true, false, false, false, true, false, s_iceTileset, s_iceAnimations[j], s_iceTileset, s_iceAnimations[j]);
            }
        }
    }

    public static void launchFullBodyMembersExplosion(int n, int n2) {
        for (int i = 0; i < s_bodyMembersAnimations.length; ++i) {
            int n3 = i % 2 == 0 ? -12 : 12;
            int n4 = -i * -4;
            int n5 = MathTools.getRandomInt(0, 96) - 48;
            int n6 = MathTools.getRandomInt(120, 165);
            int n7 = n6 * 7;
            Particle.createParticle(n + n3, n2 + n4, n5, n6, n7, 0, 5, 2, 0, (byte)0, true, false, false, false, true, false, s_bodyMembersTileset, s_bodyMembersAnimations[i], s_bodyMembersTileset, s_bodyMembersAnimations[i]);
        }
        Particle.launchParticleEffect(0, n, n2 + -65, 0);
    }

    public static void launchFullBodyMembersExplosionCyrax(int n, int n2) {
        for (int i = 0; i < s_bodyMembersAnimations.length; ++i) {
            int n3 = MathTools.getRandomInt(0, 6);
            int n4 = MathTools.getRandomInt(120, 165);
            int n5 = n4 * 7;
            int n6 = MathTools.getRandomInt(0, 1);
            n3 = n6 > 0 ? (n3 += 6) : -n3 - 6;
            Particle.createParticle(n, n2, n3 + (n6 > 0 ? 24 : -24), n4, n5, i * 100, 5, 2, 0, (byte)0, true, false, false, false, true, false, s_bodyMembersTileset, s_bodyMembersAnimations[i], s_bodyMembersTileset, s_bodyMembersAnimations[i]);
        }
    }

    public static void killAllParticles() {
        if (s_particlesPool == null) {
            return;
        }
        for (int i = 0; i < s_particlesPool.length; ++i) {
            if (s_particlesPool[i] == null || Particle.s_particlesPool[i].m_state == 0) continue;
            Particle.killParticle(s_particlesPool[i]);
        }
    }

    public boolean skipAdjustments() {
        return false;
    }

    static {
        ICE_PARTICLES_DECLARATIONS = new int[]{134217838, 134217759, 1, 0x8000020, 1, 134217761, 1, 0x8000022, 1, 134217763, 1, 134217764, 1, 134217765, 1, 134217766, 1};
        BODY_PARTS_DECLARATIONS = new int[]{134217827, 0x8000003, 1, 0x8000004, 1, 0x8000005, 1, 0x8000006, 1, 0x8000007, 1, 0x8000008, 1, 0x8000008, 1, 0x8000009, 1, 0x800000A, 1, 0x800000A, 1, 0x800000B, 1};
    }
}

