/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.Ingame;
import com.ea.game.Tileset;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class Hud {
    private static final int MAXIMUM_LIFE_LEVEL = 100;
    private static final int LIFE_BAR_RECT_COLOUR = 13157464;
    private static final int LIFE_BAR_HEALTH_COLOUR = 255;
    private static final int LIFE_BAR_WOUND_COLOUR = 0x880000;
    private static final int RUN_BAR_WIDTH = 40;
    private static final int RUN_BAR_HEIGHT = 40;
    private static final int RUN_BAR_PERCENT = 100;
    private static final int MAXIMUM_RUN_LEVEL = 100;
    private static final int RUN_BAR_COLOUR = 65280;
    private static final int LIFE_ANIMATION_SPEED = 40;
    private static final int RUN_ANIMATION_SPEED = 70;
    private static final int MILISECONDS_1000 = 1000;
    private static final int MILISECONDS_500 = 500;
    private static int s_HudBoundaryLeft;
    private static int s_HudBoundaryRight;
    private static int s_HudBoundaryTop;
    private static int s_HudBoundaryBottom;
    private static int s_timerX;
    private static int s_timerY;
    private static int s_timerWidth;
    private static int s_timerHeight;
    private static int s_player1LifeBarX;
    private static int s_player2LifeBarX;
    private static int s_lifeBarY;
    private static int s_lifeBarWidth;
    private static int s_lifeBarHeight;
    private static int s_fpPlayer1LifeLevel;
    private static int s_fpPlayer2LifeLevel;
    private static int s_fpPlayer1LifeLevelVisible;
    private static int s_fpPlayer2LifeLevelVisible;
    private static int s_fpPlayer1RunLevelVisible;
    private static int s_fpPlayer2RunLevelVisible;
    private static int s_player1LifeLevelVisibleWidth;
    private static int s_player2LifeLevelVisibleWidth;
    private static int s_player1KombatantNameX;
    private static int s_player2KombatantNameX;
    private static int s_scoreY;
    private static int s_scoreHeight;
    private static int s_kombatantNameY;
    private static int s_runBarWidth;
    private static int s_runBarHeight;
    private static int s_fpPlayer1RunLevel;
    private static int s_fpPlayer2RunLevel;
    private static int s_player1RunLevelVisibleWidth;
    private static int s_player2RunLevelVisibleWidth;
    private static int s_player1WinsNumber;
    private static int s_player2WinsNumber;
    public static int s_dragonImageHeight;
    public static int s_dragonImageWidth;
    private static int s_dragonImageY;
    private static int s_dragonImageSpace;
    private static int s_timerValue;
    private static SDKString s_timerStringValue;
    private static int s_currentScoreValue;
    private static int s_fpLifeAnimationSpeed;
    private static int s_fpRunAnimationSpeed;
    private static SDKString s_player1Name;
    private static SDKString s_player2Name;
    private static SDKString s_currentScoreString;
    public static Tileset s_hudDragonTileset;
    public static Animation s_hudDragonAnimation;
    public static int s_hudDragonAnimationInstance;
    public static final int HIGHSCORE_MAXIMUM_NUMBER_OF_DIGITS = 10;
    private static final int COMBO_REPORT_STATE_NOT_STARTED = 0;
    private static final int COMBO_REPORT_STATE_SLIDE_IN = 1;
    private static final int COMBO_REPORT_STATE_DISPLAYED = 2;
    private static final int COMBO_REPORT_STATE_SLIDE_OUT = 3;
    private static final int COMBO_REPORTS_NUMBER = 2;
    public static final int COMBO_REPORT_LEFT = 0;
    public static final int COMBO_REPORT_RIGHT = 1;
    private static int[] s_comboReportState;
    private static SDKString[] s_comboReportHitNumString;
    private static SDKString[] s_comboReportDamageString;
    private static SDKString s_comboHitsBaseString;
    private static SDKString s_comboDamageBaseString;
    private static int[] s_comboHitsBaseOffset;
    private static int[] s_comboHitsEndOffset;
    private static int[] s_comboHitsCurrentOffset;
    private static int[] s_comboDamageBaseOffset;
    private static int[] s_comboDamageEndOffset;
    private static int[] s_comboDamageCurrentOffset;
    private static int[] s_comboReportTimer;
    private static int s_comboReportHitsY;
    private static int s_comboReportDamageY;
    private static final int COMBO_REPORT_SLIDE_DURATION = 600;
    private static final int COMBO_REPORT_DAMAGE_SLIDE_DELAY = 300;
    private static final int COMBO_REPORT_DISPLAY_DURATION = 500;
    private static final byte SCORE_FONT_ID = 4;
    private static final byte COMBO_FONT_ID = 4;

    public static void initHud(int n, int n2, int n3, int n4, SDKString sDKString, SDKString sDKString2, int n5) {
        GameImpl.loadFont((byte)1);
        GameImpl.loadFont((byte)0);
        s_HudBoundaryLeft = n;
        s_HudBoundaryTop = n2;
        s_HudBoundaryRight = n3;
        s_HudBoundaryBottom = n4;
        s_player1Name = sDKString;
        s_player2Name = sDKString2;
        s_timerValue = n5;
        s_timerStringValue = Hud.makeTimerStringFromInt(s_timerValue);
        s_currentScoreValue = 0;
        s_player1WinsNumber = 0;
        s_player2WinsNumber = 0;
        GameImpl.setFont((byte)0);
        s_timerWidth = SDKUtils.getStringSize(s_timerStringValue);
        s_timerHeight = SDKUtils.getLineSize();
        s_timerX = s_HudBoundaryLeft + (s_HudBoundaryRight - s_HudBoundaryLeft) / 2 - s_timerWidth / 2 + 0;
        s_timerY = s_HudBoundaryTop + 3;
        s_player1LifeBarX = s_HudBoundaryLeft + 3;
        s_lifeBarWidth = s_timerX - 2 - s_player1LifeBarX;
        s_player2LifeBarX = s_HudBoundaryRight - 3 - s_lifeBarWidth;
        s_lifeBarY = s_timerY + s_timerHeight + 2;
        s_fpLifeAnimationSpeed = 10240;
        s_currentScoreString = new SDKString(10, 0);
        s_currentScoreString.append(s_currentScoreValue);
        GameImpl.setFont((byte)4);
        s_scoreHeight = SDKUtils.getBaselinePosition();
        s_scoreY = s_lifeBarY - s_scoreHeight - 1;
        GameImpl.setFont((byte)1);
        s_lifeBarHeight = SDKUtils.getLineSize() + 2 + 0;
        s_player1KombatantNameX = s_player1LifeBarX + 3;
        s_player2KombatantNameX = s_player2LifeBarX + s_lifeBarWidth - 3;
        s_kombatantNameY = s_lifeBarY + 1 + 0;
        s_fpPlayer2LifeLevel = 25600;
        s_fpPlayer1LifeLevel = 25600;
        s_fpPlayer2LifeLevelVisible = 0;
        s_fpPlayer1LifeLevelVisible = 0;
        s_player2LifeLevelVisibleWidth = 0;
        s_player1LifeLevelVisibleWidth = 0;
        s_runBarWidth = s_lifeBarWidth * 40 / 100;
        s_runBarHeight = s_lifeBarHeight * 40 / 100 + 0;
        if (s_runBarHeight < 2) {
            s_runBarHeight = 2;
        }
        s_fpPlayer2RunLevel = 25600;
        s_fpPlayer1RunLevel = 25600;
        s_fpPlayer2RunLevelVisible = 25600;
        s_fpPlayer1RunLevelVisible = 25600;
        s_player1RunLevelVisibleWidth = s_player2RunLevelVisibleWidth = s_runBarWidth;
        s_fpRunAnimationSpeed = 17920;
        try {
            s_hudDragonTileset = FileManager.createTileset(0x9000009);
            s_hudDragonAnimation = Animation.loadAnimation(0x9000000, 0);
            s_hudDragonAnimationInstance = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_dragonImageWidth = s_hudDragonAnimation.computeGlobalWidth(s_hudDragonTileset);
        s_dragonImageHeight = s_hudDragonAnimation.computeGlobalHeight(s_hudDragonTileset);
        s_dragonImageSpace = 3;
        s_dragonImageY = s_lifeBarY + s_lifeBarHeight + s_runBarHeight + 3;
        s_comboHitsBaseString = SDKUtils.getString(123, null);
        s_comboDamageBaseString = SDKUtils.getString(124, null);
    }

    private static SDKString makeTimerStringFromInt(int n) {
        SDKString sDKString = new SDKString("");
        if (n < 10) {
            sDKString = sDKString.concat("0");
        }
        return sDKString.concat(n);
    }

    private static void updateComboReports() {
        block6: for (int i = 0; i < 2; ++i) {
            switch (s_comboReportState[i]) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    int n = i;
                    s_comboReportTimer[n] = s_comboReportTimer[n] + GameImpl.s_elapsedTimeClamped;
                    Hud.s_comboHitsCurrentOffset[i] = s_comboHitsBaseOffset[i] + (s_comboHitsEndOffset[i] - s_comboHitsBaseOffset[i]) * s_comboReportTimer[i] / 600;
                    if (s_comboReportTimer[i] > 600) {
                        Hud.s_comboHitsCurrentOffset[i] = s_comboHitsEndOffset[i];
                    }
                    Hud.s_comboDamageCurrentOffset[i] = s_comboDamageBaseOffset[i] + (s_comboDamageEndOffset[i] - s_comboDamageBaseOffset[i]) * (s_comboReportTimer[i] - 300) / 600;
                    if (s_comboReportTimer[i] - 300 <= 600) continue block6;
                    Hud.s_comboDamageCurrentOffset[i] = s_comboDamageEndOffset[i];
                    Hud.s_comboReportState[i] = 2;
                    Hud.s_comboReportTimer[i] = 0;
                    continue block6;
                }
                case 2: {
                    int n = i;
                    s_comboReportTimer[n] = s_comboReportTimer[n] + GameImpl.s_elapsedTimeClamped;
                    if (s_comboReportTimer[i] <= 500) continue block6;
                    Hud.s_comboReportState[i] = 3;
                    Hud.s_comboReportTimer[i] = 0;
                    continue block6;
                }
                case 3: {
                    int n = i;
                    s_comboReportTimer[n] = s_comboReportTimer[n] + GameImpl.s_elapsedTimeClamped;
                    Hud.s_comboHitsCurrentOffset[i] = s_comboHitsEndOffset[i] - (s_comboHitsEndOffset[i] - s_comboHitsBaseOffset[i]) * s_comboReportTimer[i] / 600;
                    if (s_comboReportTimer[i] > 600) {
                        Hud.s_comboHitsCurrentOffset[i] = s_comboHitsBaseOffset[i];
                    }
                    if (s_comboReportTimer[i] > 300) {
                        Hud.s_comboDamageCurrentOffset[i] = s_comboDamageEndOffset[i] - (s_comboDamageEndOffset[i] - s_comboDamageBaseOffset[i]) * (s_comboReportTimer[i] - 300) / 600;
                    }
                    if (s_comboReportTimer[i] - 300 <= 600) continue block6;
                    Hud.s_comboDamageCurrentOffset[i] = s_comboDamageBaseOffset[i];
                    Hud.s_comboReportState[i] = 0;
                }
            }
        }
    }

    public static void hideComboReports() {
        Hud.s_comboReportState[0] = 0;
        Hud.s_comboReportState[1] = 0;
    }

    public static int getHudEnd() {
        return s_dragonImageY + s_dragonImageHeight;
    }

    private static void drawComboReports() {
        GameImpl.setFont((byte)4);
        for (int i = 0; i < 2; ++i) {
            if (s_comboReportState[i] == 0) continue;
            SDKUtils.drawString(s_comboReportHitNumString[i], s_comboHitsCurrentOffset[i], s_comboReportHitsY, i == 0 ? 24 : 20);
            SDKUtils.drawString(s_comboReportDamageString[i], s_comboDamageCurrentOffset[i], s_comboReportDamageY, i == 0 ? 24 : 20);
        }
    }

    public static void displayComboReport(int n, int n2, int n3) {
        GameImpl.setFont((byte)4);
        Hud.s_comboReportState[n] = 1;
        Hud.s_comboReportHitNumString[n] = s_comboHitsBaseString.replaceFirst(n2);
        Hud.s_comboReportDamageString[n] = s_comboDamageBaseString.replaceFirst(n3);
        int n4 = 12 + Math.max(SDKUtils.getStringSize(s_comboReportHitNumString[n]), SDKUtils.getStringSize(s_comboReportDamageString[n]));
        switch (n) {
            case 0: {
                Hud.s_comboHitsBaseOffset[n] = GameImpl.s_ingameLeft;
                Hud.s_comboDamageBaseOffset[n] = GameImpl.s_ingameLeft;
                Hud.s_comboHitsEndOffset[n] = s_comboHitsBaseOffset[n] + n4;
                Hud.s_comboDamageEndOffset[n] = s_comboDamageBaseOffset[n] + n4;
                break;
            }
            case 1: {
                Hud.s_comboHitsBaseOffset[n] = GameImpl.s_ingameRight;
                Hud.s_comboDamageBaseOffset[n] = GameImpl.s_ingameRight;
                Hud.s_comboHitsEndOffset[n] = s_comboHitsBaseOffset[n] - n4;
                Hud.s_comboDamageEndOffset[n] = s_comboDamageBaseOffset[n] - n4;
            }
        }
        Hud.s_comboHitsCurrentOffset[n] = s_comboHitsBaseOffset[n];
        Hud.s_comboDamageCurrentOffset[n] = s_comboDamageBaseOffset[n];
        Hud.s_comboReportTimer[n] = 0;
        s_comboReportHitsY = s_dragonImageY + s_dragonImageHeight + 6;
        s_comboReportDamageY = s_comboReportHitsY + SDKUtils.getLineSize();
    }

    public static void setHUDNames(SDKString sDKString, SDKString sDKString2) {
        s_player1Name = sDKString;
        s_player2Name = sDKString2;
    }

    public static void setHudParameters(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        s_fpPlayer1LifeLevel = n << 8;
        s_fpPlayer2LifeLevel = n2 << 8;
        s_fpPlayer1RunLevel = n3 << 8;
        s_fpPlayer2RunLevel = n4 << 8;
        s_player1WinsNumber = n5;
        s_player2WinsNumber = n6;
        if (s_timerValue != n7) {
            s_timerValue = n7;
            s_timerStringValue = Hud.makeTimerStringFromInt(s_timerValue);
        }
        if (s_currentScoreValue != n8) {
            s_currentScoreString = new SDKString(10, 0);
            s_currentScoreString.append(n8);
            s_currentScoreValue = n8;
        }
    }

    public static int getPlayer1LifeLevel() {
        return s_fpPlayer1LifeLevel >> 8;
    }

    public static int getPlayer2LifeLevel() {
        return s_fpPlayer2LifeLevel >> 8;
    }

    public static int getPlayer1RunLevel() {
        return s_fpPlayer1RunLevel >> 8;
    }

    public static int getPlayer2RunLevel() {
        return s_fpPlayer2RunLevel >> 8;
    }

    public static int getPlayer1WinsNumber() {
        return s_player1WinsNumber;
    }

    public static int getPlayer2WinsNumber() {
        return s_player2WinsNumber;
    }

    public static int getTimerValue() {
        return s_timerValue;
    }

    public static int getCurrentScoreValue() {
        return s_currentScoreValue;
    }

    public static void updateHud() {
        if (s_fpPlayer1LifeLevelVisible > s_fpPlayer1LifeLevel) {
            s_fpPlayer1LifeLevelVisible = Math.max(s_fpPlayer1LifeLevel, s_fpPlayer1LifeLevelVisible - (GameImpl.s_elapsedTimeClamped * s_fpLifeAnimationSpeed + 500) / 1000);
        } else if (s_fpPlayer1LifeLevelVisible < s_fpPlayer1LifeLevel) {
            s_fpPlayer1LifeLevelVisible = Math.min(s_fpPlayer1LifeLevel, s_fpPlayer1LifeLevelVisible + (GameImpl.s_elapsedTimeClamped * s_fpLifeAnimationSpeed + 500) / 1000);
        }
        if (s_fpPlayer2LifeLevelVisible > s_fpPlayer2LifeLevel) {
            s_fpPlayer2LifeLevelVisible = Math.max(s_fpPlayer2LifeLevel, s_fpPlayer2LifeLevelVisible - (GameImpl.s_elapsedTimeClamped * s_fpLifeAnimationSpeed + 500) / 1000);
        } else if (s_fpPlayer2LifeLevelVisible < s_fpPlayer2LifeLevel) {
            s_fpPlayer2LifeLevelVisible = Math.min(s_fpPlayer2LifeLevel, s_fpPlayer2LifeLevelVisible + (GameImpl.s_elapsedTimeClamped * s_fpLifeAnimationSpeed + 500) / 1000);
        }
        if (s_fpPlayer1RunLevelVisible > s_fpPlayer1RunLevel) {
            s_fpPlayer1RunLevelVisible = Math.max(s_fpPlayer1RunLevel, s_fpPlayer1RunLevelVisible - (GameImpl.s_elapsedTimeClamped * s_fpRunAnimationSpeed + 500) / 1000);
        } else if (s_fpPlayer1RunLevelVisible < s_fpPlayer1RunLevel) {
            s_fpPlayer1RunLevelVisible = Math.min(s_fpPlayer1RunLevel, s_fpPlayer1RunLevelVisible + (GameImpl.s_elapsedTimeClamped * s_fpRunAnimationSpeed + 500) / 1000);
        }
        if (s_fpPlayer2RunLevelVisible > s_fpPlayer2RunLevel) {
            s_fpPlayer2RunLevelVisible = Math.max(s_fpPlayer2RunLevel, s_fpPlayer2RunLevelVisible - (GameImpl.s_elapsedTimeClamped * s_fpRunAnimationSpeed + 500) / 1000);
        } else if (s_fpPlayer2RunLevelVisible < s_fpPlayer2RunLevel) {
            s_fpPlayer2RunLevelVisible = Math.min(s_fpPlayer2RunLevel, s_fpPlayer2RunLevelVisible + (GameImpl.s_elapsedTimeClamped * s_fpRunAnimationSpeed + 500) / 1000);
        }
        s_player1LifeLevelVisibleWidth = s_fpPlayer1LifeLevelVisible * s_lifeBarWidth / 100 >> 8;
        s_player2LifeLevelVisibleWidth = s_fpPlayer2LifeLevelVisible * s_lifeBarWidth / 100 >> 8;
        s_player1RunLevelVisibleWidth = s_fpPlayer1RunLevelVisible * s_runBarWidth / 100 >> 8;
        s_player2RunLevelVisibleWidth = s_fpPlayer2RunLevelVisible * s_runBarWidth / 100 >> 8;
        Hud.updateComboReports();
    }

    private static void drawBloodArea(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4) {
        sDKGraphics.setColor(0x880000);
        sDKGraphics.fillRect(n, n2, n3, n4);
    }

    public static void drawHud(SDKGraphics sDKGraphics) {
        GameImpl.setFont((byte)0);
        SDKUtils.drawString(s_timerStringValue, s_timerX, s_timerY, 20);
        if (!Ingame.isInPracticeMode()) {
            GameImpl.setFont((byte)4);
            SDKUtils.drawString(s_currentScoreString, s_player1LifeBarX, s_scoreY, 20);
        }
        sDKGraphics.setColor(255);
        sDKGraphics.fillRect(s_player1LifeBarX, s_lifeBarY, s_player1LifeLevelVisibleWidth, s_lifeBarHeight);
        sDKGraphics.fillRect(s_player2LifeBarX + s_lifeBarWidth - s_player2LifeLevelVisibleWidth, s_lifeBarY, s_player2LifeLevelVisibleWidth, s_lifeBarHeight);
        Hud.drawBloodArea(sDKGraphics, s_player1LifeBarX + s_player1LifeLevelVisibleWidth, s_lifeBarY, s_lifeBarWidth - s_player1LifeLevelVisibleWidth, s_lifeBarHeight);
        Hud.drawBloodArea(sDKGraphics, s_player2LifeBarX, s_lifeBarY, s_lifeBarWidth - s_player2LifeLevelVisibleWidth, s_lifeBarHeight);
        sDKGraphics.setColor(13157464);
        sDKGraphics.drawRect(s_player1LifeBarX, s_lifeBarY, s_lifeBarWidth, s_lifeBarHeight - 1);
        sDKGraphics.drawRect(s_player2LifeBarX, s_lifeBarY, s_lifeBarWidth, s_lifeBarHeight - 1);
        GameImpl.setFont((byte)1);
        SDKUtils.drawString(s_player1Name, s_player1KombatantNameX, s_kombatantNameY, 20);
        SDKUtils.drawString(s_player2Name, s_player2KombatantNameX, s_kombatantNameY, 24);
        sDKGraphics.setColor(65280);
        sDKGraphics.fillRect(s_player1LifeBarX, s_lifeBarY + s_lifeBarHeight, s_player1RunLevelVisibleWidth, s_runBarHeight);
        sDKGraphics.fillRect(s_player2LifeBarX + s_lifeBarWidth - s_player2RunLevelVisibleWidth, s_lifeBarY + s_lifeBarHeight, s_player2RunLevelVisibleWidth, s_runBarHeight);
        Hud.drawBloodArea(sDKGraphics, s_player1LifeBarX + s_player1RunLevelVisibleWidth, s_lifeBarY + s_lifeBarHeight, s_runBarWidth - s_player1RunLevelVisibleWidth, s_runBarHeight);
        Hud.drawBloodArea(sDKGraphics, s_player2LifeBarX + s_lifeBarWidth - s_runBarWidth, s_lifeBarY + s_lifeBarHeight, s_runBarWidth - s_player2RunLevelVisibleWidth, s_runBarHeight);
        sDKGraphics.setColor(13157464);
        sDKGraphics.drawRect(s_player1LifeBarX, s_lifeBarY + s_lifeBarHeight - 1, s_runBarWidth, s_runBarHeight);
        sDKGraphics.drawRect(s_player2LifeBarX + s_lifeBarWidth - s_runBarWidth, s_lifeBarY + s_lifeBarHeight - 1, s_runBarWidth, s_runBarHeight);
        if (!Ingame.isInPracticeMode()) {
            int n;
            for (n = 0; n < s_player1WinsNumber; ++n) {
                s_hudDragonAnimation.drawInstance(s_hudDragonAnimationInstance, s_hudDragonTileset, s_player1LifeBarX + (s_dragonImageSpace + s_dragonImageWidth) * n, s_dragonImageY, 0);
            }
            for (n = 0; n < s_player2WinsNumber; ++n) {
                s_hudDragonAnimation.drawInstance(s_hudDragonAnimationInstance, s_hudDragonTileset, s_player2LifeBarX + s_lifeBarWidth - s_dragonImageWidth - (s_dragonImageSpace + s_dragonImageWidth) * n, s_dragonImageY, 0);
            }
        }
        Hud.drawComboReports();
    }

    public static void cleanUpHud() {
        GameImpl.cleanupFont((byte)1);
        GameImpl.cleanupFont((byte)0);
    }

    public static void resetHud() {
        s_fpPlayer1LifeLevelVisible = 0;
        s_fpPlayer2LifeLevelVisible = 0;
        s_fpPlayer1RunLevelVisible = 0;
        s_fpPlayer2RunLevelVisible = 0;
        Hud.hideComboReports();
    }

    static {
        s_comboReportState = new int[2];
        s_comboReportHitNumString = new SDKString[2];
        s_comboReportDamageString = new SDKString[2];
        s_comboHitsBaseOffset = new int[2];
        s_comboHitsEndOffset = new int[2];
        s_comboHitsCurrentOffset = new int[2];
        s_comboDamageBaseOffset = new int[2];
        s_comboDamageEndOffset = new int[2];
        s_comboDamageCurrentOffset = new int[2];
        s_comboReportTimer = new int[2];
    }
}

