/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Arena;
import com.ea.game.Battle;
import com.ea.game.GameImpl;
import com.ea.game.Physics;

public class Camera {
    private static final int CAMERA_TRAVELLING_SPEED_X = 72;
    private static final int CAMERA_SHAKE_DELTA = 4;
    private static final int CAMERA_SHAKE_TIMER = 300;
    private static final int CAMERA_MIN_DELTA = 6;
    private static int s_cameraX;
    private static int s_cameraY;
    private static int s_cameraWidth;
    private static int s_cameraHeight;
    private static int s_cameraLeft;
    private static int s_cameraTop;
    private static int s_cameraRight;
    private static int s_cameraBottom;
    private static int s_cameraLeftPhysicsBoundary;
    private static int s_cameraRightPhysicsBoundary;
    public static int s_groundLevel;
    private static int s_cameraDestinationX;
    private static int s_cameraDestinationY;
    private static int s_cameraShakeTimer;
    private static int s_cameraShakeDelta;

    public static void initCamera() {
        s_cameraX = GameImpl.s_ingameLeft;
        s_cameraY = GameImpl.s_ingameTop;
        s_cameraWidth = GameImpl.s_ingameWidth;
        s_cameraHeight = GameImpl.s_ingameHeight;
        s_groundLevel = 0;
    }

    public static int getCameraLeft() {
        return s_cameraLeft - GameImpl.s_ingameLeft;
    }

    public static int getCameraRight() {
        return s_cameraRight;
    }

    public static int getCameraTop() {
        return s_cameraTop + s_cameraShakeDelta - GameImpl.s_ingameTop;
    }

    public static int getCameraX() {
        return s_cameraX;
    }

    public static int getCameraY() {
        return s_cameraY;
    }

    public static void setCamera(int n, int n2) {
        s_cameraDestinationX = n;
        s_cameraDestinationY = n2;
    }

    public static void setCamera(int n, int n2, boolean bl) {
        if (bl) {
            s_cameraDestinationX = n;
            s_cameraDestinationY = n2;
            s_cameraX = n;
            s_cameraY = n2;
        } else {
            s_cameraDestinationX = n;
            s_cameraDestinationY = n2;
        }
    }

    public static void cameraShake() {
        s_cameraShakeTimer = 300;
    }

    public static void updateCamera() {
        Camera.updateCameraMovement();
        Camera.updateCameraShake();
        s_cameraLeft = s_cameraX - s_cameraWidth / 2;
        s_cameraTop = s_cameraY - s_cameraHeight / 2;
        s_cameraRight = s_cameraLeft + s_cameraWidth;
        s_cameraBottom = s_cameraTop + s_cameraHeight;
        int n = s_cameraBottom - Math.max(s_cameraBottom, s_groundLevel);
        s_cameraBottom -= n;
        s_cameraTop -= n;
        s_cameraY -= n;
        n = s_cameraTop - Math.max(s_cameraTop, Arena.s_currentArenaTop);
        s_cameraTop -= n;
        s_cameraY -= n;
        int n2 = (s_cameraBottom -= n) - Math.min(s_cameraBottom, Arena.s_currentArenaBottom);
        s_cameraBottom -= n2;
        s_cameraTop -= n2;
        int n3 = s_cameraLeft - Math.max(s_cameraLeft, Arena.s_currentArenaLeft);
        s_cameraLeft -= n3;
        s_cameraX -= n3;
        int n4 = (s_cameraRight -= n3) - Math.min(s_cameraRight, Arena.s_currentArenaRight);
        Arena.updateCurrentOffset(s_cameraX -= n4, (s_cameraY -= n2) + s_cameraShakeDelta + GameImpl.s_ingameHeight / 2 - Arena.s_currentArenaBottom);
        s_cameraLeftPhysicsBoundary = (s_cameraLeft -= n4) + 27;
        s_cameraRightPhysicsBoundary = (s_cameraRight -= n4) - 27;
        if (Battle.s_battleState == 4) {
            Physics.setEnviroment(Math.max(s_cameraLeftPhysicsBoundary, Arena.s_currentArenaPhysicsBoundaryLeft), s_groundLevel, -GameImpl.s_ingameHeight, Math.min(s_cameraRightPhysicsBoundary, Arena.s_currentArenaPhysicsBoundaryRight));
        } else {
            Physics.setEnviroment(Math.max(s_cameraLeftPhysicsBoundary, Arena.s_currentArenaPhysicsBoundaryLeft), s_groundLevel, s_cameraTop + 58, Math.min(s_cameraRightPhysicsBoundary, Arena.s_currentArenaPhysicsBoundaryRight));
        }
    }

    private static void updateCameraShake() {
        if (s_cameraShakeTimer > 0) {
            s_cameraShakeTimer -= GameImpl.s_elapsedTimeClamped;
            s_cameraShakeDelta = GameImpl.s_toggle2 ? 4 : 0;
        } else {
            s_cameraShakeDelta = 0;
        }
    }

    private static void updateCameraMovement() {
        if (s_cameraDestinationX != s_cameraX) {
            int n = 72 * GameImpl.s_elapsedTimeClamped / 1000;
            if (s_cameraDestinationX > s_cameraX) {
                if (s_cameraDestinationX < (s_cameraX += n)) {
                    s_cameraX = s_cameraDestinationX;
                }
            } else if (s_cameraDestinationX > (s_cameraX -= n)) {
                s_cameraX = s_cameraDestinationX;
            }
        }
        if (s_cameraDestinationY != s_cameraY) {
            s_cameraY += (s_cameraDestinationY - s_cameraY) / 3;
        }
    }

    public static void resetCameraShake() {
        s_cameraShakeTimer = 0;
    }
}

