/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

class Sounds
implements PlayerListener {
    public static boolean soundsOn;
    public static byte soundsVol;
    private static int currentSoundPriority;
    private static String sndRes;
    private static InputStream is;
    private static int currentSound;
    private static Player soundPlayer;
    private static Thread thSoundPlayer;
    public static boolean musicOn;
    public static byte musicVol;
    private static Player musicPlayer;
    private static int iMusicLoop;

    static String getSoundFile(int sndID) {
        switch (sndID) {
            case 0: {
                return "/p1.wav";
            }
            case 1: {
                return "/p2.wav";
            }
            case 2: {
                return "/p3.wav";
            }
            case 3: {
                return "/p4.wav";
            }
            case 4: {
                return "/h1.wav";
            }
            case 5: {
                return "/h2.wav";
            }
            case 6: {
                return "/h3.wav";
            }
            case 7: {
                return "/n1.wav";
            }
            case 8: {
                return "/n2.wav";
            }
            case 9: {
                return "/n3.wav";
            }
            case 10: {
                return "/b1.wav";
            }
        }
        return "";
    }

    void playSoundTest() {
    }

    void playSound_Pop() {
        int tmp = Common.getRandomUInt(400);
        this.playSound(0, tmp / 100, 0);
    }

    void playSound_Bounce() {
        this.playSound(1, 10, 0);
    }

    void playMusic_LevelWon() {
        this.playSong("/mlw.mid", 1);
    }

    void playMusic_LevelLost() {
        this.playSong("/mll.mid", 1);
    }

    void playMusic_LevelSelection() {
        this.playSong("/mls.mid", -1);
    }

    void playMusic_LevelStart() {
        this.playSong("/mlst.mid", 1);
    }

    void playMusic_Achievement() {
        this.playSong("/mac.mid", 1);
    }

    void playMusic_MainMenu() {
        if (!Sounds.musicPlaying()) {
            this.playSong("/mm.mid", -1);
        }
    }

    Sounds() {
        soundPlayer = null;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (player == soundPlayer) {
            if (event.compareTo("endOfMedia") == 0) {
                soundPlayer.close();
                soundPlayer = null;
            } else if (event.compareTo("stopped") == 0) {
                soundPlayer.close();
            } else if (event.compareTo("closed") == 0) {
                soundPlayer = null;
            }
        }
        if (player == musicPlayer) {
            if (event.compareTo("endOfMedia") == 0) {
                if (iMusicLoop == -1) {
                    try {
                        musicPlayer.setMediaTime(0L);
                        musicPlayer.start();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    return;
                }
                musicPlayer.close();
            } else if (event.compareTo("stopped") == 0) {
                musicPlayer.close();
            } else if (event.compareTo("closed") == 0) {
                musicPlayer = null;
            }
        }
    }

    public void playSound(final int playerSlot, final int sndID, final int priority) {
        System.out.println("playSound() - in");
        if (!soundsOn) {
            System.out.println("playSound() - skipped");
            return;
        }
        if (thSoundPlayer != null && thSoundPlayer.isAlive()) {
            return;
        }
        thSoundPlayer = null;
        thSoundPlayer = new Thread(){

            public void run() {
                Sounds.this._playSound(playerSlot, sndID, priority);
            }
        };
        thSoundPlayer.start();
        System.out.println("playSound() - out");
    }

    static final void releaseInputStream() {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        is = null;
        System.gc();
    }

    final void _playSound(int playerSlot, int sndID, int priority) {
        if (!soundsOn) {
            return;
        }
        sndRes = Sounds.getSoundFile(sndID);
        Sounds.releaseInputStream();
        try {
            if (soundPlayer != null && priority <= currentSoundPriority) {
                return;
            }
            Sounds.stopSoundPlayer(soundPlayer);
            if (soundPlayer != null && currentSound != sndID) {
                this.destroySoundPlayer(soundPlayer);
            }
            if (soundPlayer == null) {
                is = this.getClass().getResourceAsStream(sndRes);
                soundPlayer = Manager.createPlayer((InputStream)is, (String)"audio/x-wav");
                soundPlayer.addPlayerListener((PlayerListener)this);
                soundPlayer.prefetch();
            }
            if (soundPlayer.getState() != 300) {
                soundPlayer = null;
                Sounds.releaseInputStream();
                return;
            }
            soundPlayer.start();
            currentSoundPriority = priority;
            currentSound = sndID;
        }
        catch (Throwable ex) {
            Debug.trace("playSound Exception ...");
            Debug.trace(ex.toString());
        }
        Sounds.releaseInputStream();
    }

    public void playSong(String songFile, int count) {
        if (!musicOn) {
            return;
        }
        this.stopMusic();
        Sounds pl = this;
        try {
            this.stopSounds();
            musicPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(songFile), (String)"audio/midi");
            musicPlayer.addPlayerListener((PlayerListener)this);
            musicPlayer.realize();
            musicPlayer.prefetch();
            iMusicLoop = count;
            musicPlayer.start();
        }
        catch (Throwable t) {
            Debug.trace(t.toString());
        }
    }

    public void setMusicVol(int vol) {
        if (musicPlayer != null) {
            ((VolumeControl)musicPlayer.getControl("VolumeControl")).setLevel(vol);
        }
    }

    public static boolean musicPlaying() {
        if (musicPlayer == null) {
            return false;
        }
        return (musicPlayer.getState() & 0x190) == 400;
    }

    final void stopMusic() {
        try {
            if (musicPlayer != null) {
                musicPlayer.stop();
                if (musicPlayer != null) {
                    while (musicPlayer != null) {
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void stopSounds() {
        Sounds.stopSoundPlayer(soundPlayer);
    }

    static void stopSoundPlayer(Player player) {
        if (player != null) {
            if (player.getState() == 400) {
                try {
                    player.stop();
                    if (player != null) {
                        while (player != null) {
                        }
                    }
                }
                catch (Throwable t) {
                    Debug.trace(t.toString());
                }
            }
            while (player.getState() == 400) {
            }
        }
    }

    void destroySoundPlayer(Player player) {
        if (player.getState() != 300) {
            return;
        }
        player.close();
    }

    static {
        currentSoundPriority = 0;
        is = null;
        currentSound = -1;
        soundPlayer = null;
        thSoundPlayer = null;
        musicPlayer = null;
    }
}

