/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

class Sounds
implements PlayerListener {
    public static boolean musicOn;
    public static byte musicVol;
    private static Player musicPlayer;
    private static int iMusicLoop;

    void playSoundTest() {
        this.stopMusic();
    }

    void playSound_Pop() {
        int tmp = Common.getRandomUInt(400);
        this.playSound(0, tmp / 100, 0);
    }

    void playSound_Bounce() {
    }

    void playMusic_LevelWon() {
        this.playSong("/mlw.mid", 1);
    }

    void playMusic_LevelLost() {
        this.playSong("/mll.mid", 1);
    }

    void playMusic_LevelSelection() {
        this.playSong("/mls.mid", -1);
    }

    void playMusic_LevelStart() {
        this.playSong("/mlst.mid", 1);
    }

    void playMusic_Achievement() {
        this.playSong("/mac.mid", 1);
    }

    void playMusic_MainMenu() {
        if (!Sounds.musicPlaying()) {
            this.playSong("/mm.mid", -1);
        }
    }

    Sounds() {
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (player == musicPlayer) {
            if (event.compareTo("endOfMedia") == 0) {
                if (iMusicLoop == -1) {
                    try {
                        musicPlayer.setMediaTime(0L);
                        musicPlayer.start();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    return;
                }
                musicPlayer.close();
            } else if (event.compareTo("stopped") == 0) {
                musicPlayer.close();
            } else if (event.compareTo("closed") == 0) {
                musicPlayer = null;
            }
        }
    }

    public void playSound(int playerSlot, int sndID, int priority) {
    }

    final void _playSound(int playerSlot, int sndID, int priority) {
    }

    public void playSong(String songFile, int count) {
        if (!musicOn) {
            return;
        }
        this.stopMusic();
        Sounds pl = this;
        try {
            this.stopSounds();
            musicPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(songFile), (String)"audio/midi");
            musicPlayer.realize();
            musicPlayer.prefetch();
            iMusicLoop = count;
            musicPlayer.setLoopCount(count);
            musicPlayer.start();
        }
        catch (Throwable t) {
            Debug.trace(t.toString());
        }
    }

    public void setMusicVol(int vol) {
        if (musicPlayer != null) {
            ((VolumeControl)musicPlayer.getControl("VolumeControl")).setLevel(vol);
        }
    }

    public static boolean musicPlaying() {
        if (musicPlayer == null) {
            return false;
        }
        return (musicPlayer.getState() & 0x190) == 400;
    }

    final void stopMusic() {
        try {
            if (musicPlayer != null) {
                musicPlayer.stop();
                musicPlayer.deallocate();
                musicPlayer = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void stopSounds() {
    }

    static {
        musicPlayer = null;
    }
}

