/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

class Level {
    static final int LOST_BUBBLE = -5;
    static final int HEDGEGOG_HIT = -10;
    static final int MAX_FIGURES = 25;
    static int TIME_TO_NEXT_ROW = 20000;
    static int TIME_TO_MOVE_ANCHOR = 18000;
    static int MAX_NUBERS_OF_LEVELS = 50;
    static boolean bInfinityLoop = false;
    int iLevelNum;
    int iLevelTimer;
    int iTimeToAction;
    int iTimeToActionInit;
    int iTimeToActionDelay;
    int iTypeOfBackground = 0;
    int iArcadeType = 0;
    boolean bArcadeMode;
    boolean bRefreshStatusBar;
    boolean bRefreshStatusScore;
    boolean bRefreshStatusPerls;
    private StringBuffer sbLvls = new StringBuffer();
    Player player;
    Perls perls;
    int iPerlWidth;
    int iPerlWidth2;
    int[] figType = new int[25];
    static byte[] figState;
    static byte[] figRes1;
    static byte[] figRes2;
    static byte[] figRes3;
    static byte[] figRes4;
    static int[] figRes5;
    static int[] figRes6;
    static int[] figRes7;
    static int[] figRes8;
    public static boolean isLvlUnlocked;
    int idx_star;
    int idx_hedgegog;
    int idx_octopus;
    int idx_fish;
    int iSelectedFlag;
    int iSelectedLevel;
    int[] iaLevelScore = null;
    int[] iaLevelBonus = null;
    int[] iaLevelTime = null;
    int[] iaLevelPerls = null;
    byte[] baLevelLock = null;
    byte[] baLevelMedal = null;
    byte[] baLevelPlayed = null;
    byte[] baAchievements = null;
    int iLastPerlsTop;
    boolean bFinaleNextRow;
    long lArcadeTotalTime;
    long lArcadeBubbles;
    long lArcadeTotalBubbles;
    int iArcadePlayedTimes;
    static int iArcadeTopScore;
    static int iArcadeNormalTopScore;
    static int iArcadeZumaTopScore;
    static int iArcadeFallingTopScore;
    long lStoryTotalTime;
    boolean bStoryCompleted;
    int iShrimpHits;
    int iArcadePerlsLeft;
    int iArcadeLevel;
    int iPlayerPerl;
    int iNextPerl;
    Vector vecStatsLeft;
    Vector vecStatsRight;
    static int[] unlockedLevels;
    static int[] levelStars;
    static int[] unlockedFigures;
    public static boolean isArcadeMode;
    static final int OCTOPUS = 0;
    static final int STARFISH = 1;
    static final int SEAHORSE = 2;
    static final int EEL = 3;
    RecordStore rsobj_loadsave = null;
    int iSwapCnt = 0;
    int iChainCount = 0;
    int iLastCalled = 0;
    boolean bAchievmentOpen = false;
    String strDescription;
    static int iIdxShooter;
    static Sprite sprShooter;
    static final int FIG_STR = 0;
    static final int FIG_OCT = 1;
    static final int FIG_EEL = 2;
    private static boolean bSwitchFig;
    private static int iFigPosX;
    private static int iSwitchSide;
    static int iNextShooter;
    private static boolean bSwapped;
    public boolean bPrepareBomb = false;
    static final int EEL_CNT = 11;
    static final int OCT_CNT = 8;
    int iPointerX;
    int iPointerY;
    int[] iaTimeBarColors = new int[]{14510384, 15956289, 0xF9966F};
    boolean bRefreshStatusBarOverride = true;
    boolean isArcadePlaying = false;
    int buoyDepth = 0;
    int iOldSelectedX = -1;
    int iOldSelectedY = -1;
    int iActualSelectedLevel;
    boolean bScroll = false;
    boolean bScrollL = false;
    int iScrollX;
    int iSelectorX = 0;
    int iSelectorY = 0;
    static int iSelectedLvl;
    int iLevelW = 30;
    int iLevelH = 30;
    static int iSpacesW;
    static int iSpacesH;
    static int iPosX;
    static int iPosY;
    int iActualPosX;
    int iActualPosY;
    static int iScreenCounter;
    static int iTextTableW;
    static int iTablePosX;
    static int iTablePosY;
    static int iShellW;
    static int iShellH;
    static int iStartPosX;
    static int iStarDiffX;
    static int iWindowPosY;
    int iSelected;
    public Image img1;
    public Image img2;
    int iTmpVal = 0;
    int iStarsUnlock;
    int iParalaxPosX;
    String strLevels;
    int iActualValue;
    int iLevelFontX;
    int iCharSpace = 2;
    int iNumbersPosY = 10;
    int iNumbersPosX = 0;
    int ypaint = 0;
    public static int iTableWindowW;
    public static int iArrowDiffX;
    StringBuffer sb = new StringBuffer();
    static final int MAX_BUBBLES = 15;
    static final int MAX_LOOPS = 14;
    static final int MAX_BORDER_BUBBLES = 10;
    int[] iBubblePosY = new int[15];
    int[] iBubbleSpeed = new int[15];
    int[] iBubblePosX = new int[15];
    int[] iBubbleSizeX = new int[15];

    Level() {
        this.iaLevelScore = new int[MAX_NUBERS_OF_LEVELS];
        this.iaLevelBonus = new int[MAX_NUBERS_OF_LEVELS];
        this.iaLevelTime = new int[MAX_NUBERS_OF_LEVELS];
        this.iaLevelPerls = new int[MAX_NUBERS_OF_LEVELS];
        this.baLevelLock = new byte[MAX_NUBERS_OF_LEVELS];
        this.baLevelMedal = new byte[MAX_NUBERS_OF_LEVELS];
        this.baLevelPlayed = new byte[MAX_NUBERS_OF_LEVELS];
        this.baAchievements = new byte[12];
        this.vecStatsLeft = X.canvas.vecStatsLeft;
        this.vecStatsRight = X.canvas.vecStatsRight;
        this.createObjects();
        this.prepareBorders();
        this.bArcadeMode = false;
        this.loadGame("STATS", true);
        this.updateLevelLocks();
    }

    public static boolean returnArcType() {
        return isArcadeMode;
    }

    void unlockFigures(int iLevel) {
        if (iLevel > 0) {
            Level.unlockedFigures[1] = 1;
        }
        if (iLevel > 19) {
            Level.unlockedFigures[2] = 1;
        }
        if (iLevel > 29) {
            Level.unlockedFigures[0] = 1;
        }
        if (iLevel > 39) {
            Level.unlockedFigures[3] = 1;
        }
    }

    void updateLevelStatus() {
        this.unlockFigures(this.iLevelNum);
        ++this.iSelectorX;
        if (this.iSelectorX > 4) {
            this.iSelectorX = 0;
            ++this.iSelectorY;
            if (this.iSelectorY > 1) {
                this.iSelectorY = 0;
                ++iScreenCounter;
            }
        }
        this.setCurrentLevel();
        Level.unlockedLevels[this.iLevelNum] = 1;
        iSelectedLvl = this.iSelectorY * 5 + this.iSelectorX;
    }

    void createObjects() {
        this.player = new Player();
        this.perls = new Perls();
        this.figType = new int[25];
        figState = new byte[25];
        figRes1 = new byte[25];
        figRes2 = new byte[25];
        figRes3 = new byte[25];
        figRes4 = new byte[25];
        figRes5 = new int[25];
        figRes6 = new int[25];
        figRes7 = new int[25];
        figRes8 = new int[25];
        GameDef.octopusBounce = figRes1;
        GameDef.hedgegogBounce = figRes1;
        GameDef.figFrame = figRes1;
        GameDef.figOffs = figRes2;
        GameDef.figStateTimer = figRes5;
        GameDef.figAngle = figRes6;
        GameDef.figCol = figRes3;
        GameDef.figRow = figRes4;
        GameDef.figDepth = figRes5;
        GameDef.figPerl = figRes6;
        GameDef.figSpeed = figRes7;
        GameDef.figPosX = figRes8;
    }

    void resetStory() {
        int i;
        Debug.trace("Level.resetStory() - in");
        this.iSelectedFlag = 0;
        this.iSelectedLevel = 0;
        for (i = this.iaLevelScore.length - 1; i >= 0; --i) {
            this.iaLevelScore[i] = 0;
            this.iaLevelBonus[i] = 0;
            this.iaLevelTime[i] = -1;
            this.iaLevelPerls[i] = 0;
            this.baLevelLock[i] = 0;
            this.baLevelMedal[i] = -1;
            this.baLevelPlayed[i] = 0;
            Level.unlockedLevels[i] = 0;
            Level.levelStars[i] = 0;
        }
        for (i = this.baAchievements.length - 1; i >= 0; --i) {
            this.baAchievements[i] = 0;
        }
        Level.unlockedLevels[0] = 1;
        for (i = 0; i < 5; ++i) {
            Level.unlockedFigures[i] = 0;
        }
        this.updateLevelLocks();
        this.lStoryTotalTime = 0L;
        this.bStoryCompleted = false;
        this.saveGame("STATS", true);
        Debug.trace("Level.resetStory() - out");
    }

    void resetStats() {
        Debug.trace("Level.resetStats() - in");
        this.resetStory();
        this.lArcadeBubbles = 0L;
        this.lArcadeTotalBubbles = 0L;
        this.lArcadeTotalTime = 0L;
        this.iArcadePlayedTimes = 0;
        iArcadeTopScore = 0;
        iArcadeNormalTopScore = 0;
        iArcadeZumaTopScore = 0;
        iArcadeFallingTopScore = 0;
        this.saveGame("STATS", true);
        Debug.trace("Level.resetStats() - out");
    }

    void updateLevelLocks() {
        int i;
        int cnt = 0;
        int iUnlock = 0;
        for (i = 0; i < 10; ++i) {
            this.baLevelLock[i] = i < 3 ? (byte)0 : 1;
        }
        for (i = 0; i < 10; ++i) {
            if (this.baLevelPlayed[i] <= 0 || this.baLevelPlayed[i] >= 100) continue;
            this.baLevelLock[i] = 0;
            ++cnt;
            iUnlock = i;
        }
        if (cnt >= 3) {
            this.baLevelLock[iUnlock + 1] = 0;
        }
        cnt = 0;
        for (i = 0; i < 10; ++i) {
            if (this.baLevelPlayed[i + 10] <= 0 || this.baLevelPlayed[i + 10] >= 100) continue;
            ++cnt;
        }
        for (i = 5; i >= 4; --i) {
            this.baLevelLock[i + 10] = (byte)(cnt < 4 ? 1 : 0);
        }
        for (i = 7; i >= 6; --i) {
            this.baLevelLock[i + 10] = (byte)(cnt < 6 ? 1 : 0);
        }
        for (i = 9; i >= 8; --i) {
            this.baLevelLock[i + 10] = (byte)(cnt < 8 ? 1 : 0);
        }
        cnt = 0;
        for (i = 0; i < 10; ++i) {
            if (this.baLevelPlayed[i + 20] <= 0 || this.baLevelPlayed[i + 20] >= 100) continue;
            ++cnt;
        }
        for (i = 5; i >= 3; --i) {
            this.baLevelLock[i + 20] = (byte)(cnt < 3 ? 1 : 0);
        }
        for (i = 9; i >= 6; --i) {
            this.baLevelLock[i + 20] = (byte)(cnt < 6 ? 1 : 0);
        }
        cnt = 0;
        for (i = 0; i < 10; ++i) {
            if (this.baLevelPlayed[i + 30] <= 0 || this.baLevelPlayed[i + 30] >= 100) continue;
            ++cnt;
        }
        this.baLevelLock[32] = (byte)(cnt < 2 ? 1 : 0);
        for (i = 5; i >= 3; --i) {
            this.baLevelLock[i + 30] = (byte)(cnt < 3 ? 1 : 0);
        }
        this.baLevelLock[36] = (byte)(cnt < 6 ? 1 : 0);
        this.baLevelLock[37] = (byte)(cnt < 7 ? 1 : 0);
        for (i = 9; i >= 8; --i) {
            this.baLevelLock[i + 30] = (byte)(cnt < 8 ? 1 : 0);
        }
        cnt = 0;
        for (i = 0; i < 10; ++i) {
            if (this.baLevelPlayed[i + 30] <= 0 || this.baLevelPlayed[i + 40] >= 100) continue;
            ++cnt;
        }
        this.baLevelLock[32] = (byte)(cnt < 2 ? 1 : 0);
        for (i = 5; i >= 3; --i) {
            this.baLevelLock[i + 40] = (byte)(cnt < 3 ? 1 : 0);
        }
        this.baLevelLock[36] = (byte)(cnt < 6 ? 1 : 0);
        this.baLevelLock[37] = (byte)(cnt < 7 ? 1 : 0);
        for (i = 9; i >= 8; --i) {
            this.baLevelLock[i + 30] = (byte)(cnt < 8 ? 1 : 0);
        }
    }

    void destroy() {
        Debug.trace("Level.destroy() - in");
        this.saveGame("STATS", true);
        this.figType = null;
        figState = null;
        figRes1 = null;
        figRes2 = null;
        figRes3 = null;
        figRes4 = null;
        figRes5 = null;
        figRes6 = null;
        figRes7 = null;
        figRes8 = null;
        this.iaLevelScore = null;
        this.iaLevelBonus = null;
        this.iaLevelTime = null;
        this.iaLevelPerls = null;
        this.baLevelLock = null;
        this.baLevelMedal = null;
        this.baLevelPlayed = null;
        this.baAchievements = null;
        this.player = null;
        this.perls.destroy();
        this.perls = null;
        System.gc();
        Debug.trace("Level.destroy() - out");
    }

    void incPoppedBubbles(int inc) {
        if (this.bArcadeMode) {
            ++this.lArcadeBubbles;
            ++this.lArcadeTotalBubbles;
        } else {
            int n = this.iLevelNum;
            this.iaLevelPerls[n] = this.iaLevelPerls[n] + inc;
        }
    }

    void saveGameStats(DataOutputStream data) {
        try {
            int i;
            data.writeLong(this.lArcadeTotalTime);
            data.writeLong(this.lArcadeTotalBubbles);
            data.writeInt(this.iArcadePlayedTimes);
            data.writeInt(iArcadeTopScore);
            data.writeInt(iArcadeNormalTopScore);
            data.writeInt(iArcadeZumaTopScore);
            data.writeInt(iArcadeFallingTopScore);
            data.writeLong(this.lStoryTotalTime);
            data.writeBoolean(this.bStoryCompleted);
            data.writeInt(this.iSelectedFlag);
            data.writeInt(this.iSelectedLevel);
            for (i = this.iaLevelScore.length - 1; i >= 0; --i) {
                data.writeInt(this.iaLevelScore[i]);
                data.writeInt(this.iaLevelBonus[i]);
                data.writeInt(this.iaLevelTime[i]);
                data.writeInt(this.iaLevelPerls[i]);
                data.writeByte(this.baLevelLock[i]);
                data.writeByte(this.baLevelMedal[i]);
                data.writeByte(this.baLevelPlayed[i]);
                data.writeInt(unlockedLevels[i]);
                data.writeInt(levelStars[i]);
            }
            for (i = this.baAchievements.length - 1; i >= 0; --i) {
                data.writeByte(this.baAchievements[i]);
            }
            data.writeInt(iScreenCounter);
            data.writeInt(this.iSelectorX);
            data.writeInt(this.iSelectorY);
            data.writeInt(this.iParalaxPosX);
            for (i = 0; i < 5; ++i) {
                data.writeInt(unlockedFigures[i]);
            }
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
        }
    }

    void saveGameArcade(DataOutputStream data) {
        try {
            data.writeInt(this.iLevelNum);
            data.writeInt(this.iLevelTimer);
            data.writeInt(this.iTimeToActionInit);
            data.writeInt(this.iTimeToAction);
            data.writeInt(this.iTimeToActionDelay);
            for (int i = 0; i < 25; ++i) {
                data.writeInt(this.figType[i]);
                data.writeByte(figState[i]);
                data.writeByte(figRes1[i]);
                data.writeByte(figRes2[i]);
                data.writeByte(figRes3[i]);
                data.writeByte(figRes4[i]);
                data.writeInt(figRes5[i]);
                data.writeInt(figRes6[i]);
                data.writeInt(figRes7[i]);
                data.writeInt(figRes8[i]);
            }
            data.writeInt(this.idx_star);
            data.writeInt(this.idx_hedgegog);
            data.writeInt(this.idx_octopus);
            data.writeInt(this.idx_fish);
            data.writeInt(this.iLastPerlsTop);
            data.writeInt(this.iShrimpHits);
            this.perls.save(data);
            this.player.save(data);
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
        }
    }

    void loadGameArcade(DataInputStream data) {
        try {
            this.iLevelNum = data.readInt();
            this.iLevelTimer = data.readInt();
            this.iTimeToActionInit = data.readInt();
            this.iTimeToAction = data.readInt();
            this.iTimeToActionDelay = data.readInt();
            for (int i = 0; i < 25; ++i) {
                this.figType[i] = data.readInt();
                Level.figState[i] = data.readByte();
                Level.figRes1[i] = data.readByte();
                Level.figRes2[i] = data.readByte();
                Level.figRes3[i] = data.readByte();
                Level.figRes4[i] = data.readByte();
                Level.figRes5[i] = data.readInt();
                Level.figRes6[i] = data.readInt();
                Level.figRes7[i] = data.readInt();
                Level.figRes8[i] = data.readInt();
            }
            this.idx_star = data.readInt();
            this.idx_hedgegog = data.readInt();
            this.idx_octopus = data.readInt();
            this.idx_fish = data.readInt();
            this.iLastPerlsTop = data.readInt();
            this.iShrimpHits = data.readInt();
            this.perls.load(data);
            this.player.load(data);
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
            this.resetStats();
        }
    }

    void loadGameStats(DataInputStream data) {
        try {
            int i;
            this.lArcadeTotalTime = data.readLong();
            this.lArcadeTotalBubbles = data.readLong();
            this.iArcadePlayedTimes = data.readInt();
            iArcadeTopScore = data.readInt();
            iArcadeNormalTopScore = data.readInt();
            iArcadeZumaTopScore = data.readInt();
            iArcadeFallingTopScore = data.readInt();
            this.lStoryTotalTime = data.readLong();
            this.bStoryCompleted = data.readBoolean();
            this.iSelectedFlag = data.readInt();
            this.iSelectedLevel = data.readInt();
            for (i = this.iaLevelScore.length - 1; i >= 0; --i) {
                this.iaLevelScore[i] = data.readInt();
                this.iaLevelBonus[i] = data.readInt();
                this.iaLevelTime[i] = data.readInt();
                this.iaLevelPerls[i] = data.readInt();
                this.baLevelLock[i] = data.readByte();
                this.baLevelMedal[i] = data.readByte();
                this.baLevelPlayed[i] = data.readByte();
                Level.unlockedLevels[i] = data.readInt();
                Level.levelStars[i] = data.readInt();
            }
            for (i = this.baAchievements.length - 1; i >= 0; --i) {
                this.baAchievements[i] = data.readByte();
            }
            iScreenCounter = data.readInt();
            this.iSelectorX = data.readInt();
            this.iSelectorY = data.readInt();
            this.iParalaxPosX = data.readInt();
            for (i = 0; i < 5; ++i) {
                Level.unlockedFigures[i] = data.readInt();
            }
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
            this.resetStats();
        }
        if (this.iSelectorX > 1000) {
            this.iSelectorX = 0;
        }
        iSelectedLvl = this.iSelectorY * 5 + this.iSelectorX;
        WholeGame.iLastScrollX = this.iParalaxPosX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame(String rstoreName, boolean bStats) {
        Debug.trace("Level.saveGame(" + (bStats ? "STATS" : "") + ") - in");
        Level.deleteSavedGame(rstoreName);
        try {
            this.rsobj_loadsave = RecordStore.openRecordStore((String)rstoreName, (boolean)true);
            ByteArrayOutputStream array = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(array);
            if (bStats) {
                this.saveGameStats(data);
            } else {
                this.saveGameArcade(data);
            }
            this.rsobj_loadsave.addRecord(array.toByteArray(), 0, array.toByteArray().length);
            this.rsobj_loadsave.closeRecordStore();
        }
        catch (Exception ex) {
            Debug.trace(ex.toString());
            Level.deleteSavedGame(rstoreName);
        }
        finally {
            if (this.rsobj_loadsave != null) {
                try {
                    this.rsobj_loadsave.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
        Debug.trace("Level.saveGame() - out");
    }

    public static void deleteSavedGame(String rstoreName) {
        Debug.trace("Level.deleteSavedGame(boolean) - in");
        try {
            RecordStore.deleteRecordStore((String)rstoreName);
        }
        catch (Exception ex) {
            Debug.trace(ex.toString());
        }
        Debug.trace("Level.deleteSavedGame(boolean) - out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadGame(String rstoreName, boolean bStats) {
        Debug.trace("Level.loadGame(" + (bStats ? "STATS" : "") + ") - in");
        boolean bLoaded = false;
        try {
            this.rsobj_loadsave = RecordStore.openRecordStore((String)rstoreName, (boolean)false);
            RecordEnumeration enumr = this.rsobj_loadsave.enumerateRecords(null, null, false);
            int i = enumr.nextRecordId();
            byte[] record = this.rsobj_loadsave.getRecord(i);
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(record));
            if (bStats) {
                this.loadGameStats(data);
            } else {
                this.loadGameArcade(data);
            }
            this.rsobj_loadsave.closeRecordStore();
        }
        catch (Exception ex) {
            Debug.trace(ex.toString());
            this.resetStats();
        }
        finally {
            if (this.rsobj_loadsave != null) {
                try {
                    this.rsobj_loadsave.closeRecordStore();
                }
                catch (Exception ex) {}
            }
            this.rsobj_loadsave = null;
            System.gc();
        }
        Debug.trace("Level.loadGame(" + (bStats ? "STATS" : "") + ") - out");
        return bLoaded;
    }

    int getTrophyScore(int iTrophy) {
        switch (iTrophy) {
            case 0: {
                return 100;
            }
            case 1: {
                return 500;
            }
            case 3: {
                return 100;
            }
            case 4: {
                return 100;
            }
            case 5: {
                return 200;
            }
            case 6: {
                return 500;
            }
            case 7: {
                return 100;
            }
            case 8: {
                return 250;
            }
            case 9: {
                return 500;
            }
            case 10: {
                return 500;
            }
            case 11: {
                return 1000;
            }
        }
        return 0;
    }

    int totalScore() {
        int iTotalScore = 0;
        for (int i = 39; i >= 0; --i) {
            iTotalScore += this.iaLevelScore[i];
        }
        if (this.bStoryCompleted) {
            int len = X.canvas.iaRadiusTrophies.length;
            for (int i = 0; i < len; ++i) {
                if (this.baAchievements[i] != 1) continue;
                iTotalScore += this.getTrophyScore(i);
            }
        }
        return iTotalScore;
    }

    int totalTime() {
        int iTotalTime = 0;
        for (int i = 39; i >= 0; --i) {
            iTotalTime += this.iaLevelTime[i];
        }
        return iTotalTime;
    }

    int totalPerls() {
        int iTotalPerls = 0;
        for (int i = 39; i >= 0; --i) {
            iTotalPerls += this.iaLevelPerls[i];
        }
        return iTotalPerls;
    }

    int getMedals(int bMedal) {
        int iTotalMedals = 0;
        for (int i = MAX_NUBERS_OF_LEVELS - 1; i >= 0; --i) {
            if (this.baLevelMedal[i] != bMedal) continue;
            ++iTotalMedals;
        }
        return iTotalMedals;
    }

    int getFinishedLevels() {
        int iTotalCompleted = 0;
        for (int i = 39; i >= 0; --i) {
            if (this.baLevelPlayed[i] <= 0 || this.baLevelPlayed[i] >= 100) continue;
            ++iTotalCompleted;
        }
        return iTotalCompleted;
    }

    int getCompletition() {
        int iTotalCompleted = 0;
        for (int i = 39; i >= 0; --i) {
            if (this.iaLevelScore[i] <= 0) continue;
            ++iTotalCompleted;
        }
        return 10 * iTotalCompleted / 4;
    }

    boolean testAchievement(int iType) {
        Debug.trace("Level.testAchievement() - in");
        if (this.bArcadeMode) {
            return false;
        }
        if (this.baAchievements[iType] != 1) {
            this.baAchievements[iType] = 1;
            this.saveGame("STATS", true);
            X.canvas.iAchievementDelay = 1000;
            X.canvas.iAchievementIdx = iType;
            X.canvas.sAchievementTitle1 = X.texts.getString("ACHI");
            X.canvas.sAchievementTitle2 = X.texts.getString("UNLOCKED");
            this.strDescription = "TEST";
            this.bAchievmentOpen = true;
            Debug.trace("Level.testAchievement() - out 1");
            return true;
        }
        Debug.trace("Level.testAchievement() - out 2");
        return false;
    }

    void init() {
        Debug.trace("Level.init() - in");
        this.lArcadeBubbles = 0L;
        this.iTimeToActionInit = 0;
        this.perls.init();
        this.reset();
        Debug.trace("Level.init() - out");
    }

    void reset() {
        this.perls.reset();
        this.player.reset();
        this.iPerlWidth = Resources.sprPerlsWidth;
        this.iPerlWidth2 = Resources.sprPerlsWidth / 2;
        this.bRefreshStatusBar = true;
        X.canvas.resetScoreLabels();
        WholeGame.particles.resetParticles();
    }

    void initTime() {
        if (this.bArcadeMode) {
            this.iLevelTimer = 0;
            this.setTimeToAction(this.getTimeToAction());
            return;
        }
        this.iTimeToActionInit = 1000;
        switch (this.iLevelNum) {
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 22: {
                this.iLevelTimer = 0;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 19: {
                this.iLevelTimer = 100000;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 4: 
            case 9: 
            case 14: {
                this.iLevelTimer = 50000;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 25: {
                this.iLevelTimer = 60000;
                this.setTimeToAction(5000);
                break;
            }
            case 26: {
                this.iLevelTimer = 90000;
                this.setTimeToAction(5000);
                break;
            }
            case 27: {
                this.iLevelTimer = 120000;
                this.setTimeToAction(5000);
            }
            case 28: {
                this.iLevelTimer = 150000;
                this.setTimeToAction(5000);
                break;
            }
            case 24: 
            case 29: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                this.iLevelTimer = 0;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 44: {
                this.iLevelTimer = 180000;
                this.setTimeToAction(5000);
                break;
            }
            default: {
                this.iLevelTimer = 0;
            }
        }
    }

    void initFigures() {
        int fidx;
        Debug.trace("Level.initFigures() - in");
        Arrays.resetIntsArray(this.figType);
        this.idx_fish = -1979;
        this.idx_star = Arrays.addIntToArray(this.figType, 4);
        this.idx_octopus = Arrays.addIntToArray(this.figType, 2);
        GameDef.figAngle[this.idx_star] = 0;
        GameDef.figFrame[this.idx_star] = 0;
        Level.figState[this.idx_star] = 0;
        Level.figState[this.idx_octopus] = 0;
        GameDef.figFrame[this.idx_octopus] = 0;
        if (this.iLevelNum == 4 || this.iLevelNum == 9) {
            int cnt = 2 * GameDef._WIDTH / (Resources.sprFishBlueWidth + Resources.sprFishBlueWidth / 5);
            int tmp = 200 / cnt;
            int tmp2 = tmp / 2;
            for (int i = -100; i < 100; i += tmp) {
                fidx = Arrays.addIntToArray(this.figType, 16);
                GameDef.figOffs[fidx] = (byte)i;
                GameDef.figDepth[fidx] = Resources.sprTopBar.getHeight();
                GameDef.figSpeed[fidx] = 2;
                GameDef.figFrame[fidx] = 0;
                fidx = Arrays.addIntToArray(this.figType, 17);
                GameDef.figOffs[fidx] = (byte)i;
                GameDef.figDepth[fidx] = Resources.sprTopBar.getHeight() + Resources.sprFishBlueHeight * 3 / 2;
                GameDef.figSpeed[fidx] = 1;
                GameDef.figFrame[fidx] = 0;
                if (this.iLevelNum != 14 && this.iLevelNum != 9 || (fidx = Arrays.addIntToArray(this.figType, 13)) < 0) continue;
                GameDef.figFrame[fidx] = 0;
                GameDef.figOffs[fidx] = (byte)i;
                GameDef.figDepth[fidx] = Resources.sprTopBar.getHeight() + Resources.sprFishBlueHeight * 4;
                GameDef.figSpeed[fidx] = -1;
            }
        }
        if (this.iLevelNum == 7 || this.iLevelNum == 8 || this.iLevelNum == 18) {
            for (int i = 0; i < 360; i += 90) {
                fidx = Arrays.addIntToArray(this.figType, 23);
                GameDef.figOffs[fidx] = (byte)i;
                GameDef.figAngle[fidx] = i;
                GameDef.figSpeed[fidx] = 1;
                GameDef.figFrame[fidx] = 0;
            }
        }
        Debug.trace("Level.initFigures() - out");
    }

    void prepareLevelBackround() {
    }

    void prepareLevel() {
        isArcadeMode = false;
        Debug.trace("Level.prepareLevel() - in");
        sprShooter = Resources.sprChange;
        this.iShrimpHits = 0;
        this.bFinaleNextRow = false;
        this.iTypeOfBackground = this.iLevelNum / 10;
        this.perls.prepareLevel(this.iLevelNum);
        this.initTime();
        this.initFigures();
        X.canvas.resetScoreLabels();
        X.canvas.resetCongratLabels();
        this.iaLevelScore[this.iLevelNum] = 0;
        this.iaLevelBonus[this.iLevelNum] = 0;
        this.iaLevelTime[this.iLevelNum] = 0;
        this.iaLevelPerls[this.iLevelNum] = 0;
        this.baLevelMedal[this.iLevelNum] = -1;
        this.unlockFigures(this.iLevelNum);
        this.iLastCalled = 0;
        this.returnStar();
        this.perls.iDropDownSpeed = 4;
        this.perls.iDropDownSpeedRand = 3;
        this.perls.iDropDownTime = 2000;
        Debug.trace("Level.prepareLevel() - out");
    }

    void prepareArcade(int iType) {
        Debug.trace("Level.prepareArcade() - in");
        isArcadeMode = true;
        this.iArcadeType = iType;
        this.iLevelNum = 0;
        this.iShrimpHits = 0;
        this.bFinaleNextRow = false;
        this.iArcadePerlsLeft = 50;
        this.iArcadeLevel = 0;
        if (this.iArcadeType == 0) {
            iScreenCounter = 0;
            this.perls.prepareArcadeClassic();
        }
        if (this.iArcadeType == 1) {
            iScreenCounter = 2;
            this.perls.setZumaToBase();
            this.perls.prepareArcadeZuma();
        }
        if (this.iArcadeType == 2) {
            iScreenCounter = 4;
            this.perls.prepareArcadeBonus();
            this.iLevelTimer = 60000;
        }
        this.initTime();
        this.initFigures();
        X.canvas.resetScoreLabels();
        X.canvas.resetCongratLabels();
        sprShooter = Common.createSprite("/fig/tocenie.png", 4, 1);
        Debug.trace("Level.prepareArcade() - out");
    }

    int getTimeToAction() {
        if (this.bArcadeMode) {
            int iMul1 = 2;
            iMul1 += (this.iLevelNum + 1) / 2;
            int iLineDec = 4;
            if ((iLineDec -= (this.iLevelNum + 1) / 5) < 2) {
                iLineDec = 2;
            }
            if (this.perls.iPerlsLeft < iMul1 * this.perls.iPerlsInLine && this.perls.getLastRowForAdd() < this.perls.iTotalLines - iLineDec) {
                return 100;
            }
            int iSpeed = 15000 - this.iLevelNum / 10 * 300 - this.iLevelNum % 10 * 150;
            return iSpeed;
        }
        if (this.perls.iLevelType == 5) {
            return TIME_TO_MOVE_ANCHOR;
        }
        switch (this.iLevelNum) {
            case 3: {
                return 10000;
            }
            case 4: 
            case 5: {
                return 15000;
            }
            case 6: 
            case 7: {
                return 15000;
            }
            case 10: 
            case 11: {
                return 15000;
            }
            case 12: 
            case 13: {
                return 25000;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 10000;
            }
            case 38: {
                if (this.perls.bFailed) {
                    return 20000;
                }
                if (this.perls.getLastRowForAdd() < this.perls.iTotalLines - 3 && this.perls.iPerlsLeft < this.perls.iTotalLines / 6 * 5 * this.perls.iPerlsInLine) {
                    return 200;
                }
                return 12000;
            }
            case 39: {
                if (this.perls.bFailed) {
                    return 20000;
                }
                if (this.perls.getLastRowForAdd() < this.perls.iTotalLines - 2 && this.perls.iPerlsLeft < this.perls.iTotalLines / 5 * 4 * this.perls.iPerlsInLine) {
                    return 200;
                }
                return 18000;
            }
            case 44: {
                if (this.perls.bFailed) {
                    return 20000;
                }
                if (this.perls.getLastRowForAdd() < this.perls.iTotalLines - 3 && this.perls.iPerlsLeft < this.perls.iTotalLines / 6 * 5 * this.perls.iPerlsInLine) {
                    return 200;
                }
                return 12000;
            }
            case 45: {
                if (this.perls.bFailed) {
                    return 20000;
                }
                if (this.perls.getLastRowForAdd() < this.perls.iTotalLines - 2 && this.perls.iPerlsLeft < this.perls.iTotalLines / 5 * 4 * this.perls.iPerlsInLine) {
                    return 200;
                }
                return 18000;
            }
        }
        return TIME_TO_NEXT_ROW;
    }

    void setTimeToAction(int iTime) {
        this.iTimeToActionInit = this.iTimeToAction = iTime;
        this.iLastPerlsTop = this.perls.iTop;
        this.iTimeToActionDelay = 0;
    }

    void incTimeToAction(int inc) {
        this.iTimeToAction += inc;
        if (this.iTimeToAction > this.iTimeToActionInit) {
            this.iTimeToAction = this.iTimeToActionInit;
        }
    }

    void updateFigures() {
        block8: for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            switch (this.figType[i]) {
                case 5: {
                    if (GameDef.figOffs[i] < 125) {
                        int n = i;
                        GameDef.figOffs[n] = (byte)(GameDef.figOffs[n] + GameDef.figSpeed[i]);
                        continue block8;
                    }
                    this.figType[i] = -1979;
                    continue block8;
                }
                case 23: {
                    if (GameDef.figAngle[i] < 360) {
                        int n = i;
                        GameDef.figAngle[n] = GameDef.figAngle[n] + GameDef.figSpeed[i];
                        continue block8;
                    }
                    GameDef.figAngle[i] = 0;
                    continue block8;
                }
                case 16: 
                case 17: {
                    if (GameDef.figOffs[i] < 100) {
                        int n = i;
                        GameDef.figOffs[n] = (byte)(GameDef.figOffs[n] + GameDef.figSpeed[i]);
                        continue block8;
                    }
                    GameDef.figOffs[i] = -100;
                    continue block8;
                }
                case 13: {
                    if (GameDef.figOffs[i] > -100) {
                        int n = i;
                        GameDef.figOffs[n] = (byte)(GameDef.figOffs[n] + GameDef.figSpeed[i]);
                        continue block8;
                    }
                    GameDef.figOffs[i] = 100;
                    continue block8;
                }
                case 6: 
                case 7: {
                    if (!this.perls.bFailed) {
                        this.perls.addPerlOnTop(GameDef.figCol[i]);
                        if (this.iLevelNum > 37) {
                            this.perls.addPerlOnTop(GameDef.figCol[i]);
                        }
                    }
                    if (GameDef.figOffs[i] < 100) {
                        int n = i;
                        GameDef.figOffs[n] = (byte)(GameDef.figOffs[n] + 3);
                        continue block8;
                    }
                    this.perls.bNoScoreForShakenPerls = true;
                    this.perls.shakePerls();
                    this.figType[i] = -1979;
                    this.idx_fish = -1979;
                    continue block8;
                }
                case 2: {
                    if (this.perls.bDangerousState) {
                        if (figState[this.idx_octopus] != 0) continue block8;
                        WholeGame.sounds.playSound(1, 7, 10);
                        Level.figState[this.idx_octopus] = 2;
                        GameDef.figStateTimer[this.idx_octopus] = 1000;
                        continue block8;
                    }
                    if (figState[this.idx_octopus] != 2) continue block8;
                    Level.figState[this.idx_octopus] = 0;
                }
            }
        }
    }

    int testFigureHit(int x, int y) {
        block5: for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            switch (this.figType[i]) {
                case 5: {
                    int ypos;
                    int dy;
                    int width = Resources.sprRybkaWidth;
                    int height = Resources.sprRybkaHeight;
                    int xpos = GameDef.barValue(GameDef.figOffs[i], 100, Defines.WIDTH);
                    int pxpos = xpos - this.iPerlWidth2;
                    int dx = x - (xpos -= width - this.iPerlWidth / 4 * 3);
                    if (dx < this.iPerlWidth2 || dx > width - this.iPerlWidth2 || (dy = y - (ypos = GameDef.figDepth[i])) < this.iPerlWidth2 || dy > height - this.iPerlWidth2) continue block5;
                    int scoreinc = 20;
                    if (GameDef.figPerl[i] != -1979) {
                        WholeGame.particles.createBubbles(pxpos, y);
                        WholeGame.particles.createBubbles(pxpos, y);
                        GameDef.figPerl[i] = -1979;
                        int pidx = WholeGame.particles.createParticle(pxpos, y, 0, 4, 0, 1, 0, 0);
                        if (pidx != -1) {
                            WholeGame.particles.partSprite[pidx] = Resources.sprPerls;
                            WholeGame.particles.partFrame[pidx] = 16;
                            WholeGame.particles.partLife[pidx] = 14;
                        }
                        scoreinc *= 2;
                    }
                    ++this.iShrimpHits;
                    if (this.iShrimpHits == 5) {
                        this.testAchievement(4);
                    }
                    GameDef.figSpeed[i] = 3;
                    WholeGame.sounds.playSound(1, 8, 10);
                    this.player.incScore(scoreinc);
                    X.canvas.createScoreLabel(x, y, scoreinc);
                    return i;
                }
                case 23: {
                    int dy;
                    int width = Resources.sprHed1Width;
                    int height = Resources.sprHed1Height;
                    int xpos = GameDef._WIDTH / 2 + (Common.COS(GameDef.figAngle[i]) * ((GameDef._WIDTH - Resources.sprHed1Width) / 2) >> 8) - Resources.sprHed1Width / 2;
                    int ypos = Common.SIN(GameDef.figAngle[i]) * (GameDef._WIDTH / 2) >> 8;
                    int dx = x - xpos;
                    if (dx < this.iPerlWidth2 || dx > width - this.iPerlWidth2 || (dy = y - ypos) < this.iPerlWidth2 || dy > height - this.iPerlWidth2) continue block5;
                    WholeGame.particles.createBubbles(x, y);
                    this.player.incScore(-10);
                    X.canvas.createScoreLabel(x, y, -10);
                    return i;
                }
                case 6: 
                case 7: 
                case 13: 
                case 16: 
                case 17: {
                    int dx;
                    int xpos;
                    boolean bBlueFish = this.figType[i] == 6 || this.figType[i] == 16;
                    int ypos = GameDef.figDepth[i];
                    if (this.figType[i] == 13) {
                        ypos += Math.abs(GameDef.figFrame[i] / 3);
                    }
                    int height = Resources.sprFishBlueHeight;
                    int width = Resources.sprFishBlueWidth;
                    if (this.figType[i] == 13) {
                        width = Resources.sprHed1Width;
                        height = Resources.sprHed1Height;
                    }
                    int h2 = height / 2;
                    int w2 = width / 2;
                    int dy = y - (ypos + h2);
                    if (dy > this.iPerlWidth2 || dy < -this.iPerlWidth2 || (dx = x - ((xpos = GameDef.figPosX[i]) + w2)) > w2 || dx < -w2) continue block5;
                    WholeGame.particles.createBubbles(x, y);
                    if (this.figType[i] == 13) {
                        this.player.incScore(-10);
                        X.canvas.createScoreLabel(x, y, -10);
                    } else {
                        this.incPoppedBubbles(1);
                        this.perls.incMultiplier();
                        for (int ii = 0; ii < width; ii += 4) {
                            WholeGame.particles.createBubbles(x + ii, y + Common.getRandomInt(4));
                        }
                        int iScore = 2;
                        if (this.figType[i] == 6 || this.figType[i] == 16) {
                            iScore = 5;
                        }
                        if (this.perls.iMultiplierVal > 1) {
                            X.canvas.createScoreLabel(x, y, this.perls.iMultiplierVal, iScore);
                        } else {
                            X.canvas.createScoreLabel(x, y, iScore);
                        }
                        this.player.incScore(iScore * this.perls.iMultiplierVal);
                        this.figType[i] = -1979;
                        int cnt = 0;
                        int len = this.figType.length;
                        for (int ii = len - 1; ii >= 0 && cnt == 0; --ii) {
                            if (this.figType[ii] == -1979 || this.figType[ii] != 17 && this.figType[ii] != 16) continue;
                            ++cnt;
                        }
                    }
                    return i;
                }
            }
        }
        return -1;
    }

    Sprite getShooter() {
        return sprShooter;
    }

    boolean isStar() {
        return iNextShooter == 0;
    }

    boolean callFigure(int nxt) {
        if (bSwitchFig) {
            return false;
        }
        bSwitchFig = true;
        iFigPosX = 0;
        iSwitchSide = 5;
        iNextShooter = nxt;
        return true;
    }

    void returnStar() {
        if (this.isStar()) {
            return;
        }
        this.callFigure(0);
        bSwapped = false;
    }

    void updateHorsie() {
        if (unlockedFigures[2] == 0) {
            return;
        }
        int iChainCnt = this.perls.getChainCntInt();
        if (iChainCnt != 0 && iChainCnt % 8 == 0) {
            this.perls.prepareBomb();
            if (this.iChainCount < 5) {
                ++this.iChainCount;
                if (this.iChainCount == 5) {
                    this.testAchievement(2);
                }
            }
        }
        if (iChainCnt >= 16) {
            this.testAchievement(5);
        }
    }

    void updateShooterChange() {
        if (bSwapped) {
            return;
        }
        if (this.perls.iLevelType == 3) {
            return;
        }
        if (this.perls.getChainCntInt() != 0 && this.perls.getChainCntInt() % 8 == 0) {
            return;
        }
        int iPlayerShoot = this.player.getPlayerShootCount();
        if (iPlayerShoot != 0 && iPlayerShoot % 8 == 0 && unlockedFigures[0] != 0) {
            if (iPlayerShoot == this.iLastCalled) {
                return;
            }
            this.iLastCalled = iPlayerShoot;
            this.callFigure(1);
            bSwapped = true;
        }
        if (iPlayerShoot != 0 && iPlayerShoot % 11 == 0 && unlockedFigures[3] != 0) {
            if (iPlayerShoot == this.iLastCalled) {
                return;
            }
            this.iLastCalled = iPlayerShoot;
            this.callFigure(2);
            bSwapped = true;
        }
        this.releaseCounter(iPlayerShoot);
    }

    void releaseCounter(int cnt) {
        if (unlockedFigures[2] != 0) {
            if (cnt >= 11) {
                this.player.resetShootCounter();
                this.iLastCalled = 0;
            }
        } else if (unlockedFigures[0] != 0 && cnt >= 8) {
            this.player.resetShootCounter();
            this.iLastCalled = 0;
        }
    }

    void updateSwitchingFig() {
        if (!bSwitchFig) {
            return;
        }
        if (iFigPosX >= Resources.sprChangeWidth) {
            iSwitchSide *= -1;
            if (iNextShooter == 0) {
                sprShooter = Common.createSprite("/fig/tocenie.png", 4, 1);
            }
            if (iNextShooter == 1) {
                sprShooter = Common.createSprite("/fig/tocenie.png", 4, 1);
            }
            if (iNextShooter == 2) {
                sprShooter = Common.createSprite("/fig/tocenie.png", 4, 1);
            }
            Resources.sprChangeWidth = sprShooter.getWidth();
            Resources.sprChangeHeight = sprShooter.getHeight();
        } else if (iFigPosX <= 0) {
            iFigPosX = 0;
            bSwitchFig = false;
            if (iNextShooter == 1 && unlockedFigures[0] != 0) {
                this.perls.prepareCannon();
            }
            if (iNextShooter == 2 && unlockedFigures[3] != 0) {
                this.perls.prepareInk();
            }
        }
    }

    boolean bTouchShooter(int x, int y) {
        this.iPointerX = GameDef._WIDTH / 3 - Resources.sprPerlsWidth;
        this.iPointerY = GameDef._HEIGHT - Resources.sprDolnyBar.getHeight();
        return x > this.iPointerX && y > this.iPointerY && x < this.iPointerX + GameDef._WIDTH / 3 && y < GameDef._HEIGHT;
    }

    void swapBubbles() {
        if (!this.bArcadeMode && unlockedFigures[1] == 0) {
            return;
        }
        if (!this.isStar()) {
            return;
        }
        if (this.player.perlSpd != 0) {
            return;
        }
        this.iPlayerPerl = Player.perlType;
        this.iNextPerl = this.perls.iPreparedPerl;
        if (this.perls.iPreparedPerl != -1979) {
            if (Player.perlType != -1979) {
                this.player.initPerl(this.iNextPerl);
                this.perls.iPreparedPerl = this.iPlayerPerl;
            }
        }
        if (this.iSwapCnt < 20) {
            ++this.iSwapCnt;
            if (this.iSwapCnt == 20) {
                this.testAchievement(1);
            }
        }
    }

    void paintFiguresForeground(Graphics g) {
        Sprite spr = null;
        block14: for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            switch (this.figType[i]) {
                case 23: {
                    spr = Resources.sprHed1;
                    int xpos = GameDef._WIDTH / 2 + (Common.COS(GameDef.figAngle[i]) * ((GameDef._WIDTH - Resources.sprHed1Width) / 2) >> 8) - Resources.sprHed1Width / 2;
                    int ypos = Common.SIN(GameDef.figAngle[i]) * (GameDef._WIDTH / 2) >> 8;
                    spr.setPosition(xpos, ypos);
                    spr.paint(g);
                    continue block14;
                }
                case 5: {
                    int x = GameDef.barValue(GameDef.figOffs[i], 100, GameDef._WIDTH);
                    int dspx = WholeGame.level.perls.iLeft - this.iPerlWidth2;
                    int col = (x - dspx) / this.iPerlWidth;
                    if (col == GameDef.figCol[i] && GameDef.figPerl[i] != -1979) {
                        g.setColor(0xFF0000);
                        if (WholeGame.level.perls.canAddPerl(GameDef.figRow[i] + 1, GameDef.figCol[i])) {
                            WholeGame.level.perls.addPerl(GameDef.figRow[i] + 1, GameDef.figCol[i], GameDef.figPerl[i]);
                            GameDef.figPerl[i] = -1979;
                        }
                    }
                    spr = Resources.sprRybka;
                    spr.setFrame(Math.abs(GameDef.figFrame[i]) / 2);
                    spr.setPosition(x - Resources.sprRybkaWidth + this.iPerlWidth / 4 * 3, GameDef.figDepth[i]);
                    spr.paint(g);
                    if (GameDef.figOffs[i] % 4 == 0) {
                        WholeGame.particles.createBubbles(x - Resources.sprRybkaWidth / 2, GameDef.figDepth[i] + 30);
                    }
                    if (GameDef.figPerl[i] != -1979) {
                        spr = Resources.sprPerls;
                        spr.setFrame(GameDef.figPerl[i]);
                        spr.setPosition(x - this.iPerlWidth2, GameDef.figDepth[i]);
                        spr.paint(g);
                    }
                    if (GameDef.figFrame[i] < 7) {
                        int n = i;
                        GameDef.figFrame[n] = (byte)(GameDef.figFrame[n] + 1);
                        continue block14;
                    }
                    GameDef.figFrame[i] = -7;
                    continue block14;
                }
                case 6: 
                case 7: 
                case 13: 
                case 16: 
                case 17: {
                    boolean bBlueFish = this.figType[i] == 6 || this.figType[i] == 16;
                    int x = GameDef.barValue(GameDef.figOffs[i], 100, GameDef._WIDTH);
                    int y = GameDef.figDepth[i];
                    if (bBlueFish) {
                        x = GameDef._WIDTH - x;
                    }
                    int dspx = WholeGame.level.perls.iLeft - this.iPerlWidth2;
                    GameDef.figCol[i] = (byte)((x - dspx) / this.iPerlWidth);
                    if (this.figType[i] == 13) {
                        spr = Resources.sprHed1;
                        spr.setFrame(0);
                        y += Math.abs(GameDef.figFrame[i] / 3);
                    } else {
                        spr = bBlueFish ? Resources.sprFishBlue : Resources.sprFishRed;
                        spr.setFrame(Math.abs(GameDef.figFrame[i] / 3));
                    }
                    GameDef.figPosX[i] = x -= bBlueFish ? Resources.sprFishBlueWidth : 0;
                    spr.setPosition(x, y);
                    spr.paint(g);
                    if (GameDef.figFrame[i] < 5) {
                        int n = i;
                        GameDef.figFrame[n] = (byte)(GameDef.figFrame[n] + 1);
                        continue block14;
                    }
                    GameDef.figFrame[i] = -5;
                    continue block14;
                }
                case 4: {
                    int frame = GameDef.figFrame[i] / 2;
                    int xpos = GameDef._WIDTH / 2 - Resources.sprChangeWidth * 2 - Resources.sprPerls.getHeight() / 5;
                    int ypos = GameDef._HEIGHT - Resources.sprChangeHeight * 2 + Resources.sprDolnyBar.getHeight() / 6;
                    spr = this.getShooter();
                    spr.setPosition(xpos + iFigPosX, ypos);
                    spr.setFrame(0);
                    if (this.bArcadeMode || unlockedFigures[1] != 0) {
                        spr.paint(g);
                    }
                    this.perls.updatePreparedPerl();
                    spr = Resources.sprPerls;
                    int v = WholeGame.level.perls.iPreparedPerl;
                    boolean bPointer = v >= 600 && v < 700;
                    boolean bBomb = v >= 700 && v < 800;
                    boolean bStop = v >= 800 && v < 900;
                    v = WholeGame.level.perls.getPerlVal(WholeGame.level.perls.iPreparedPerl);
                    if (figState[i] == 0 || figState[i] == 3) {
                        if (this.bArcadeMode || unlockedFigures[1] != 0) {
                            switch (frame) {
                                case 0: {
                                    xpos = xpos - Resources.sprPerlsWidth - Resources.sprDolnyBar.getHeight() / 6;
                                    ypos = GameDef._HEIGHT - Resources.sprDolnyBar.getHeight() + Resources.sprDolnyBar.getHeight() / 3;
                                    break;
                                }
                                case 1: {
                                    xpos = xpos - Resources.sprPerlsWidth - Resources.sprDolnyBar.getHeight() / 6;
                                    ypos = GameDef._HEIGHT - Resources.sprDolnyBar.getHeight() + Resources.sprDolnyBar.getHeight() / 3;
                                    break;
                                }
                                case 2: {
                                    xpos = xpos - Resources.sprPerlsWidth - Resources.sprDolnyBar.getHeight() / 6;
                                    ypos = GameDef._HEIGHT - Resources.sprDolnyBar.getHeight() + Resources.sprDolnyBar.getHeight() / 3;
                                    break;
                                }
                                case 3: {
                                    xpos = xpos - Resources.sprPerlsWidth - Resources.sprDolnyBar.getHeight() / 6;
                                    ypos = GameDef._HEIGHT - Resources.sprDolnyBar.getHeight() + Resources.sprDolnyBar.getHeight() / 3;
                                    break;
                                }
                                case 4: {
                                    xpos = xpos - Resources.sprPerlsWidth - Resources.sprDolnyBar.getHeight() / 6;
                                    ypos = GameDef._HEIGHT - Resources.sprDolnyBar.getHeight() + Resources.sprDolnyBar.getHeight() / 3;
                                    break;
                                }
                                case 5: {
                                    xpos = xpos - Resources.sprPerlsWidth - Resources.sprDolnyBar.getHeight() / 6;
                                    ypos = GameDef._HEIGHT - Resources.sprDolnyBar.getHeight() + Resources.sprDolnyBar.getHeight() / 3;
                                }
                            }
                        }
                        xpos -= 2;
                        ypos += 2;
                        if (v != 901 && v != 902 && (this.bArcadeMode || unlockedFigures[1] != 0)) {
                            spr.setFrame(v);
                            spr.setPosition(xpos + Resources.sprDolnyBar.getHeight() / 18, ypos - Resources.sprDolnyBar.getHeight() / 18);
                            spr.paint(g);
                        }
                        if (v == 901) {
                            WholeGame.level.perls.paintInk(g, xpos, ypos - Resources.sprDolnyBar.getHeight() / 18);
                        }
                        if (v == 16) {
                            WholeGame.level.perls.paintEmpty(g, xpos, ypos - Resources.sprDolnyBar.getHeight() / 18);
                        }
                        if (v == 902) {
                            WholeGame.level.perls.paintElectric(g, xpos, ypos - Resources.sprDolnyBar.getHeight() / 18);
                        }
                        if (v == 15) {
                            Sprite sprClean = Resources.sprClean;
                            sprClean.setFrame(0);
                            sprClean.setPosition(xpos, ypos - Resources.sprDolnyBar.getHeight() / 18);
                            sprClean.paint(g);
                        }
                        if (bPointer) {
                            Sprite sprP = Resources.sprPtr;
                            sprP.setPosition(xpos, ypos - Resources.sprDolnyBar.getHeight() / 18);
                            sprP.setFrame(0);
                            sprP.paint(g);
                        }
                        if (bBomb) {
                            spr.setFrame(14);
                            spr.setPosition(xpos, ypos - Resources.sprDolnyBar.getHeight() / 18);
                            spr.paint(g);
                        }
                        if (bStop) {
                            spr.setFrame(12);
                            spr.setPosition(xpos, ypos);
                            spr.paint(g);
                        }
                        if (figState[i] != 3) continue block14;
                        if (this.bArcadeMode || unlockedFigures[1] != 0) {
                            // empty if block
                        }
                        if (GameDef.figFrame[i] < 11) {
                            int n = i;
                            GameDef.figFrame[n] = (byte)(GameDef.figFrame[n] + 1);
                            continue block14;
                        }
                        Level.figState[i] = 4;
                        continue block14;
                    }
                    if (figState[i] != 4) continue block14;
                    xpos = 290 + (Common.COS(GameDef.figAngle[i]) * 67 >> 8);
                    ypos = 650 + (Common.SIN(GameDef.figAngle[i]) * 45 >> 8);
                    spr.setPosition(240, 575);
                    if (this.bArcadeMode || unlockedFigures[1] != 0) {
                        // empty if block
                    }
                    if (GameDef.figAngle[i] < 180) {
                        int n = i;
                        GameDef.figAngle[n] = GameDef.figAngle[n] + 20;
                        continue block14;
                    }
                    GameDef.figFrame[i] = 0;
                    Level.figState[i] = 0;
                    WholeGame.level.player.initPerl(WholeGame.level.perls.iPreparedPerl);
                    WholeGame.level.perls.prepareNextPerl();
                    if (iNextShooter != 0) {
                        this.returnStar();
                    }
                    this.updateHorsie();
                }
            }
        }
    }

    int statItemToShow(int iLevel) {
        switch (iLevel) {
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 44: {
                return 0;
            }
            case 13: 
            case 14: {
                return 2;
            }
        }
        return 1;
    }

    boolean objectiveCompleted() {
        if (this.bArcadeMode) {
            if (this.iArcadeType == 0) {
                return false;
            }
            if (this.iArcadeType == 1) {
                return this.perls.iZumaPerlsCount == 0 && this.perls.iStackedPerlsCount == 0 && X.canvas.iActiveScoreLabels == 0;
            }
            if (this.iArcadeType == 2) {
                return false;
            }
        }
        switch (this.iLevelNum) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.perls.iActivePerlsCount == 0 && this.perls.iStackedPerlsCount == 0 && X.canvas.iActiveScoreLabels == 0 && !this.perls.bFailed;
            }
            case 14: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 44: {
                return this.iLevelTimer <= 0;
            }
            case 4: 
            case 9: {
                int cnt = 0;
                int len = this.figType.length;
                for (int ii = len - 1; ii >= 0 && cnt == 0; --ii) {
                    if (this.figType[ii] == -1979 || this.figType[ii] != 17 && this.figType[ii] != 16) continue;
                    ++cnt;
                }
                return this.iLevelTimer <= 0 || cnt == 0;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                return this.perls.iZumaPerlsCount == 0 && this.perls.iStackedPerlsCount == 0 && X.canvas.iActiveScoreLabels == 0;
            }
        }
        Debug.trace("level " + this.iLevelNum + " -> Level.objectiveCompleted() not defined");
        return false;
    }

    void updateTime() {
        if (this.bArcadeMode) {
            this.iLevelTimer += 30;
            return;
        }
        switch (this.iLevelNum) {
            case 4: 
            case 9: 
            case 14: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 44: {
                this.iLevelTimer -= 30;
                break;
            }
            default: {
                this.iLevelTimer += 30;
            }
        }
    }

    void updateActions() {
        if (this.iTimeToActionDelay > 0) {
            this.iTimeToActionDelay -= 30;
            return;
        }
        if (this.bArcadeMode) {
            this.iTimeToAction -= 30;
            if (this.iTimeToAction < 0 && this.player.perlSpd == 0) {
                this.setTimeToAction(this.getTimeToAction());
                if (this.perls.iLevelType != 3 && this.perls.iLevelType != 6) {
                    this.addPerlRowOnTop();
                }
            }
            if (this.iArcadePerlsLeft <= 0 && !this.perls.bFailed) {
                this.iArcadePerlsLeft = 50 + this.iLevelNum * 10;
                X.canvas.createCongratLabel(0, 0, Resources.sprLabelLevelUp);
                ++this.iLevelNum;
                WholeGame.level.bRefreshStatusPerls = true;
                int iCnt = 4 + this.iLevelNum % 10 / 3;
                Arrays.resetIntsArray(this.perls.iaPerlsInGame);
                Arrays.resetIntsArray(this.perls.iaPerlsOnStart);
                for (int i = 0; i < iCnt; ++i) {
                    Arrays.addIntToArray(this.perls.iaPerlsInGame, i);
                    Arrays.addIntToArray(this.perls.iaPerlsOnStart, i);
                }
            }
            return;
        }
        switch (this.iLevelNum) {
            case 15: 
            case 16: 
            case 17: {
                this.iTimeToAction -= 30;
                if (this.iTimeToAction >= 0 || this.player.perlSpd != 0) break;
                this.setTimeToAction(this.getTimeToAction());
                this.addPerlOnBottom();
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 44: {
                this.iTimeToAction -= 30;
                if (this.iTimeToAction >= 0 || this.player.perlSpd != 0) break;
                this.setTimeToAction(this.getTimeToAction());
                this.addPerlRowOnTop();
                break;
            }
            case 24: 
            case 29: 
            case 40: 
            case 41: {
                this.iTimeToAction -= 30;
                if (this.iTimeToAction < 0 && this.player.perlSpd == 0) {
                    this.setTimeToAction(this.getTimeToAction());
                    break;
                }
                this.perls.iTop = this.iLastPerlsTop + GameDef.barValue(this.getTimeToAction() - this.iTimeToAction, this.getTimeToAction(), this.perls.iPerlWidth);
                if (WholeGame.lRunCounter % 3L != 0L) break;
                this.perls.updateDangerousState();
                break;
            }
        }
    }

    boolean objectiveFailed() {
        if (this.perls.bFailed) {
            return WholeGame.particles.activeParticles() == 0;
        }
        return false;
    }

    byte getMedal(int iLevel) {
        switch (iLevel) {
            case 0: {
                if (this.iaLevelScore[iLevel] >= 1200) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1000) {
                    return 1;
                }
                return 2;
            }
            case 1: {
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1000) {
                    return 1;
                }
                return 2;
            }
            case 2: {
                if (this.iaLevelScore[iLevel] >= 1850) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1350) {
                    return 1;
                }
                return 2;
            }
            case 3: {
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1000) {
                    return 1;
                }
                return 2;
            }
            case 4: {
                if (this.iaLevelScore[iLevel] >= 100) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 75) {
                    return 1;
                }
                return 2;
            }
            case 5: {
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1250) {
                    return 1;
                }
                return 2;
            }
            case 6: {
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1250) {
                    return 1;
                }
                return 2;
            }
            case 7: {
                if (this.iaLevelScore[iLevel] >= 1200) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 900) {
                    return 1;
                }
                return 2;
            }
            case 8: {
                if (this.iaLevelScore[iLevel] >= 900) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 700) {
                    return 1;
                }
                return 2;
            }
            case 9: {
                if (this.iaLevelScore[iLevel] >= 100) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 75) {
                    return 1;
                }
                return 2;
            }
            case 10: {
                if (this.iaLevelScore[iLevel] >= 2500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 1;
                }
                return 2;
            }
            case 11: {
                if (this.iaLevelScore[iLevel] >= 900) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 1;
                }
                return 2;
            }
            case 12: {
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 1;
                }
                return 2;
            }
            case 13: {
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 1;
                }
                return 2;
            }
            case 14: {
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 1;
                }
                return 2;
            }
            case 15: {
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1000) {
                    return 1;
                }
                return 2;
            }
            case 16: {
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1000) {
                    return 1;
                }
                return 2;
            }
            case 17: {
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1200) {
                    return 1;
                }
                return 2;
            }
            case 18: {
                if (this.iaLevelScore[iLevel] >= 700) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 550) {
                    return 1;
                }
                return 2;
            }
            case 19: {
                if (this.iaLevelScore[iLevel] >= 1700) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1350) {
                    return 1;
                }
                return 2;
            }
            case 20: {
                if (this.iaLevelScore[iLevel] >= 1750) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1250) {
                    return 1;
                }
                return 2;
            }
            case 21: {
                if (this.iaLevelScore[iLevel] >= 2300) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 1;
                }
                return 2;
            }
            case 22: {
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 1;
                }
                return 2;
            }
            case 23: {
                if (this.iaLevelScore[iLevel] >= 2500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1750) {
                    return 1;
                }
                return 2;
            }
            case 24: {
                if (this.iaLevelScore[iLevel] >= 2500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 1;
                }
                return 2;
            }
            case 25: {
                if (this.iaLevelScore[iLevel] >= 3000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 2500) {
                    return 1;
                }
                return 2;
            }
            case 26: {
                if (this.iaLevelScore[iLevel] >= 3000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 1;
                }
                return 2;
            }
            case 27: {
                if (this.iaLevelScore[iLevel] >= 4000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 3000) {
                    return 1;
                }
                return 2;
            }
            case 28: {
                if (this.iaLevelScore[iLevel] >= 3000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 1;
                }
                return 2;
            }
            case 29: {
                if (this.iaLevelScore[iLevel] >= 1700) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1300) {
                    return 1;
                }
                return 2;
            }
            case 30: {
                if (this.iaLevelScore[iLevel] >= 2500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 1;
                }
                return 2;
            }
            case 31: {
                if (this.iaLevelScore[iLevel] >= 3000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1750) {
                    return 1;
                }
                return 2;
            }
            case 32: {
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1250) {
                    return 1;
                }
                return 2;
            }
            case 33: {
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1250) {
                    return 1;
                }
                return 2;
            }
            case 34: {
                if (this.iaLevelScore[iLevel] >= 1000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 800) {
                    return 1;
                }
                return 2;
            }
            case 35: {
                if (this.iaLevelScore[iLevel] >= 3000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 1;
                }
                return 2;
            }
            case 36: {
                if (this.iaLevelScore[iLevel] >= 1750) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1250) {
                    return 1;
                }
                return 2;
            }
            case 37: {
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 1;
                }
                return 2;
            }
            case 38: {
                if (this.iaLevelScore[iLevel] >= 2500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 1;
                }
                return 2;
            }
            case 39: {
                if (this.iaLevelScore[iLevel] >= 2500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 1;
                }
                return 2;
            }
            case 40: {
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1250) {
                    return 1;
                }
                return 2;
            }
            case 41: {
                if (this.iaLevelScore[iLevel] >= 3000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1750) {
                    return 1;
                }
                return 2;
            }
            case 42: {
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 1;
                }
                return 2;
            }
            case 43: {
                if (this.iaLevelScore[iLevel] >= 3000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 2000) {
                    return 1;
                }
                return 2;
            }
            case 44: {
                if (this.iaLevelScore[iLevel] >= 20000) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 15000) {
                    return 1;
                }
                return 2;
            }
            case 45: {
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1250) {
                    return 1;
                }
                return 2;
            }
            case 46: {
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1250) {
                    return 1;
                }
                return 2;
            }
            case 47: {
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1250) {
                    return 1;
                }
                return 2;
            }
            case 48: {
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1250) {
                    return 1;
                }
                return 2;
            }
            case 49: {
                if (this.iaLevelScore[iLevel] >= 1500) {
                    return 0;
                }
                if (this.iaLevelScore[iLevel] >= 1250) {
                    return 1;
                }
                return 2;
            }
        }
        return 2;
    }

    int timeBonus(int iLevel) {
        switch (iLevel) {
            case 0: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
            case 1: {
                if (this.iaLevelTime[iLevel] >= 80000) break;
                return 150;
            }
            case 2: {
                if (this.iaLevelTime[iLevel] >= 80000) break;
                return 150;
            }
            case 3: {
                if (this.iaLevelTime[iLevel] >= 90000) break;
                return 150;
            }
            case 8: {
                if (this.iaLevelTime[iLevel] >= 55000) break;
                return 150;
            }
            case 9: {
                if (this.iaLevelTime[iLevel] >= 65000) break;
                return 150;
            }
            case 10: {
                if (this.iaLevelTime[iLevel] >= 60000) break;
                return 150;
            }
            case 11: {
                if (this.iaLevelTime[iLevel] >= 60000) break;
                return 150;
            }
            case 12: {
                if (this.iaLevelTime[iLevel] >= 120000) break;
                return 150;
            }
            case 13: {
                if (this.iaLevelTime[iLevel] >= 90000) break;
                return 150;
            }
            case 14: {
                if (this.iaLevelTime[iLevel] >= 90000) break;
                return 150;
            }
            case 15: {
                if (this.iaLevelTime[iLevel] >= 60000) break;
                return 150;
            }
            case 16: {
                if (this.iaLevelTime[iLevel] >= 65000) break;
                return 150;
            }
            case 17: {
                if (this.iaLevelTime[iLevel] >= 70000) break;
                return 150;
            }
            case 18: {
                if (this.iaLevelTime[iLevel] >= 60000) break;
                return 150;
            }
            case 19: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
            case 20: {
                if (this.iaLevelTime[iLevel] >= 200000) break;
                return 150;
            }
            case 21: {
                if (this.iaLevelTime[iLevel] >= 120000) break;
                return 150;
            }
            case 22: {
                if (this.iaLevelTime[iLevel] >= 120000) break;
                return 150;
            }
            case 23: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
            case 25: {
                if (this.iaLevelTime[iLevel] >= 100000) break;
                return 150;
            }
            case 26: {
                if (this.iaLevelTime[iLevel] >= 60000) break;
                return 150;
            }
            case 27: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
            case 28: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
            case 29: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
            case 30: {
                if (this.iaLevelTime[iLevel] >= 60000) break;
                return 150;
            }
            case 31: {
                if (this.iaLevelTime[iLevel] >= 140000) break;
                return 150;
            }
            case 32: {
                if (this.iaLevelTime[iLevel] >= 110000) break;
                return 150;
            }
            case 33: {
                if (this.iaLevelTime[iLevel] >= 90000) break;
                return 150;
            }
            case 34: {
                if (this.iaLevelTime[iLevel] >= 120000) break;
                return 150;
            }
            case 35: {
                if (this.iaLevelTime[iLevel] >= 120000) break;
                return 150;
            }
            case 37: {
                if (this.iaLevelTime[iLevel] >= 50000) break;
                return 150;
            }
        }
        return 0;
    }

    void onArcadeRestart() {
        Debug.trace("Level.onArcadeRestart() - in");
        this.lArcadeTotalTime += (long)this.iLevelTimer;
        ++this.iArcadePlayedTimes;
        this.saveGame("STATS", true);
        if (this.iArcadeType == 0) {
            Level.deleteSavedGame("ARCADE");
        }
        Debug.trace("Level.onArcadeRestart() - out");
    }

    void onStoryRestart(boolean bFailed) {
        Debug.trace("Level.onStoryRestart() - in");
        this.iaLevelPerls[this.iLevelNum] = 0;
        this.iaLevelScore[this.iLevelNum] = 0;
        if (bFailed) {
            this.baLevelPlayed[this.iLevelNum] = 100;
        } else if (this.baLevelPlayed[this.iLevelNum] == 100) {
            this.baLevelPlayed[this.iLevelNum] = 2;
        } else {
            int n = this.iLevelNum;
            this.baLevelPlayed[n] = (byte)(this.baLevelPlayed[n] + 1);
        }
        this.saveGame("STATS", true);
        Debug.trace("Level.onStoryRestart() - out");
    }

    void update() {
        if (this.objectiveFailed()) {
            if (this.bArcadeMode) {
                if (this.player.iScore > iArcadeTopScore) {
                    iArcadeTopScore = this.player.iScore;
                }
                this.onArcadeRestart();
                X.canvas.setMode(19, true);
            } else {
                this.onStoryRestart(true);
                X.canvas.setMode(22, false);
            }
            return;
        }
        if (this.objectiveCompleted()) {
            if (this.bArcadeMode) {
                if (this.iArcadeType == 1) {
                    ++this.iArcadeLevel;
                    X.canvas.createCongratLabel(0, 0, Resources.sprLabelLevelUp);
                    this.perls.prepareArcadeZuma();
                }
                return;
            }
            if (this.iLevelNum == 4) {
                this.testAchievement(0);
            }
            if (this.iLevelNum == 24) {
                this.testAchievement(8);
            }
            if (!this.bAchievmentOpen) {
                int iTimeBonus;
                this.iaLevelBonus[this.iLevelNum] = 0;
                this.iaLevelScore[this.iLevelNum] = this.player.iScore;
                this.iaLevelTime[this.iLevelNum] = this.iLevelTimer;
                this.baLevelMedal[this.iLevelNum] = this.getMedal(this.iLevelNum);
                int n = this.iLevelNum;
                this.baLevelPlayed[n] = (byte)(this.baLevelPlayed[n] + 1);
                if (this.baLevelPlayed[this.iLevelNum] == 1) {
                    int n2 = this.iLevelNum;
                    this.iaLevelScore[n2] = this.iaLevelScore[n2] + 100;
                    int n3 = this.iLevelNum;
                    this.iaLevelBonus[n3] = this.iaLevelBonus[n3] + 100;
                }
                if ((iTimeBonus = this.timeBonus(this.iLevelNum)) > 0) {
                    int n4 = this.iLevelNum;
                    this.iaLevelScore[n4] = this.iaLevelScore[n4] + iTimeBonus;
                    int n5 = this.iLevelNum;
                    this.iaLevelBonus[n5] = this.iaLevelBonus[n5] + iTimeBonus;
                }
                this.updateLevelLocks();
                if (this.iLevelNum >= 49) {
                    this.bStoryCompleted = true;
                }
                this.saveGame("STATS", true);
                X.canvas.setMode(21, false);
                return;
            }
        }
        this.player.update();
        this.perls.update();
        this.updateFigures();
        this.updateActions();
        this.updateTime();
        this.updateBorders();
        this.updateSwitchingFig();
        this.updateShooterChange();
    }

    void nextPerl() {
        this.player.playerBounces = 0;
        GameDef.figAngle[this.idx_star] = 105;
        Level.figState[this.idx_star] = 3;
        GameDef.figFrame[this.idx_star] = 0;
        WholeGame.level.perls.bNextPerlReady = false;
    }

    void addPerlRowOnTop() {
        Debug.trace("addPerlRowOnTop() - in");
        for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            if (this.figType[i] == 6) {
                return;
            }
            if (this.figType[i] != 7) continue;
            return;
        }
        if (this.iLevelNum > 37) {
            this.idx_fish = this.bFinaleNextRow ? Arrays.addIntToArray(this.figType, 6) : Arrays.addIntToArray(this.figType, 7);
            this.bFinaleNextRow = !this.bFinaleNextRow;
        } else {
            this.idx_fish = Arrays.addIntToArray(this.figType, Common.getRandomUInt(100) % 2 == 0 ? 6 : 7);
        }
        Debug.trace("created : " + this.idx_fish);
        GameDef.figOffs[this.idx_fish] = 0;
        GameDef.figCol[this.idx_fish] = -1;
        GameDef.figFrame[this.idx_fish] = 0;
        GameDef.figDepth[this.idx_fish] = Resources.sprFishBlueHeight / 4;
        WholeGame.level.perls.resetPerlAdd();
        Debug.trace("addPerlRowOnTop() - out");
    }

    void addPerlOnBottom() {
        Debug.trace("addPerlOnBottom() - in");
        for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979 || this.figType[i] != 5) continue;
            return;
        }
        int fidx = Arrays.addIntToArray(this.figType, 5);
        GameDef.figFrame[fidx] = 0;
        GameDef.figOffs[fidx] = 0;
        GameDef.figRow[fidx] = (byte)WholeGame.level.perls.getLastRowForAdd();
        if (GameDef.figRow[fidx] < 0) {
            this.figType[fidx] = -1979;
            return;
        }
        GameDef.figDepth[fidx] = (GameDef.figRow[fidx] + 1) * this.iPerlWidth + WholeGame.level.perls.iTop;
        GameDef.figCol[fidx] = (byte)WholeGame.level.perls.getColForAdd(GameDef.figRow[fidx]);
        GameDef.figPerl[fidx] = Arrays.intInArray(this.perls.iaPerlsInGame, Common.getRandomUInt(Arrays.intsInArray(this.perls.iaPerlsInGame)));
        if ((this.iLevelNum == 25 || this.iLevelNum == 26 || this.iLevelNum == 27 || this.iLevelNum == 28) && Common.getRandomUInt(100) < 60) {
            GameDef.figPerl[fidx] = 9;
        }
        GameDef.figSpeed[fidx] = 1;
        Debug.trace("addPerlOnBottom() - out");
    }

    int paintStatusBarNumbers(Graphics g, int xpos, boolean bAlignRight) {
        int width = (WholeGame.stringBuffer.length() + 2) * Resources.imgScoreFontWidth - 2;
        int y = Resources.sprTopBar.getHeight() / 3;
        y = Resources.sprTopBar.getHeight() / 4;
        if (bAlignRight) {
            xpos -= width;
        }
        g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
        Texts.drawNumbers(g, Resources.imgScoreFont, WholeGame.stringBuffer.toString(), xpos + Resources.imgScoreFontWidth / 4, y);
        return width;
    }

    int paintStatusBarTime(Graphics g, int xpos, boolean bAlignRight) {
        int width = (WholeGame.stringBuffer.length() + 2) * Resources.imgScoreFontWidth - 2;
        int y = Resources.sprTopBar.getHeight() / 3;
        int x = 0;
        y = Resources.sprTopBar.getHeight() / 4;
        if (bAlignRight) {
            xpos -= width;
        }
        g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
        if (this.iTimeToActionDelay <= 0 && this.perls.iLevelType == 1 && this.iTimeToActionInit > 3000) {
            int idx = GameDef.barValue(this.iTimeToAction, this.iTimeToActionInit, 2);
            if (idx < 0) {
                idx = 0;
            }
            if (idx > 2) {
                idx = 2;
            }
        }
        Texts.drawNumbers(g, Resources.imgScoreFont, WholeGame.stringBuffer.toString(), xpos - Resources.imgScoreFontWidth * 4 / 3 + x, y);
        return width;
    }

    void timeToStringBuffer(long timer) {
        long secs = timer / 1000L;
        long mins = secs / 60L;
        WholeGame.stringBuffer.setLength(0);
        WholeGame.stringBuffer.append(secs %= 60L);
        if (WholeGame.stringBuffer.length() < 2) {
            WholeGame.stringBuffer.insert(0, '0');
        }
        WholeGame.stringBuffer.insert(0, ':');
        WholeGame.stringBuffer.insert(0, mins);
        if (mins < 10L) {
            WholeGame.stringBuffer.insert(0, '0');
        }
    }

    void paintStatusBar(Graphics g) {
        int wb;
        int ypos;
        int height;
        int width;
        int h = 0;
        int h2 = 0;
        int h3 = 0;
        int h4 = 0;
        h = 1;
        h2 = 3;
        Sprite spr = Resources.sprTopBar;
        spr.setFrame(0);
        spr.setPosition(0, 0);
        spr.paint(g);
        Sprite bar = Resources.sprBar;
        if (!(this.bRefreshStatusBarOverride || WholeGame.lRunCounter % 3L == 0L || WholeGame.mode != 18 && WholeGame.mode != 20)) {
            return;
        }
        this.bRefreshStatusBarOverride = false;
        if (this.bRefreshStatusBar) {
            g.setClip(0, 0, GameDef._WIDTH, Resources.sprTopBar.getHeight());
            boolean ypos2 = false;
        }
        int xpos = 0;
        if (this.bRefreshStatusScore || this.bRefreshStatusBar) {
            WholeGame.stringBuffer.setLength(0);
            WholeGame.stringBuffer.append(this.player.iScore);
            while (WholeGame.stringBuffer.length() < 5) {
                WholeGame.stringBuffer.insert(0, 'O');
            }
            Texts.NUMBERS = "0123456789:O";
            xpos = 4 + this.paintStatusBarNumbers(g, 4 + h + h3, false);
            this.bRefreshStatusScore = false;
        }
        if (this.bRefreshStatusBar || WholeGame.lRunCounter % 5L == 0L) {
            this.timeToStringBuffer(this.iLevelTimer);
            xpos = this.iTimeToActionInit > 0 ? (xpos += 4 + this.paintStatusBarTime(g, xpos + 4 + h + h2, false)) : (xpos += 4 + this.paintStatusBarNumbers(g, xpos + 4 + h + h2, false));
        }
        if (this.bArcadeMode && this.iArcadeType != 1 && this.iArcadeType != 2 && (this.bRefreshStatusPerls || this.bRefreshStatusBar)) {
            WholeGame.stringBuffer.setLength(0);
            WholeGame.stringBuffer.append(this.iArcadePerlsLeft);
            while (WholeGame.stringBuffer.length() < 5) {
                WholeGame.stringBuffer.insert(0, 'O');
            }
            Texts.NUMBERS = "0123456789:O";
            xpos += 4 + this.paintStatusBarNumbers(g, 4 + xpos, false);
            WholeGame.stringBuffer.setLength(0);
            WholeGame.stringBuffer.append(this.iLevelNum + 1);
            while (WholeGame.stringBuffer.length() < 2) {
                WholeGame.stringBuffer.insert(0, 'O');
            }
            Texts.NUMBERS = "0123456789:O";
            xpos += 4 + this.paintStatusBarNumbers(g, 4 + xpos, false);
            this.bRefreshStatusPerls = false;
        }
        int iMultiplierLeft = xpos - 4;
        WholeGame.stringBuffer.setLength(0);
        WholeGame.stringBuffer.append(this.perls.iMultiplierVal);
        if (WholeGame.stringBuffer.length() < 2) {
            WholeGame.stringBuffer.insert(0, '0');
        }
        xpos = GameDef._WIDTH - 8 - this.paintStatusBarNumbers(g, GameDef._WIDTH - Resources.imgScoreFontWidth * 3 + h + h4, false) + Resources.sprBar.getWidth() / 35;
        h = 0;
        h2 = 0;
        h = -5;
        h2 = -2;
        g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
        if (!this.isArcadePlaying) {
            width = Resources.sprBar.getWidth();
            height = Resources.sprBar.getHeight();
            ypos = Resources.sprTopBar.getHeight() / 3 - 1;
            wb = GameDef.barValue(this.perls.iMultiplierTime, this.perls.getMultiplierTime(), width);
            g.setClip((xpos -= width) + h, ypos + h2, wb, height);
            bar.setFrame(0);
            bar.setPosition(xpos + h, ypos + h2);
            bar.paint(g);
        }
        if (this.isArcadePlaying && this.iArcadeType == 1) {
            width = Resources.sprBar.getWidth();
            height = Resources.sprBar.getHeight();
            ypos = Resources.sprTopBar.getHeight() / 3 - 1;
            wb = GameDef.barValue(this.perls.iMultiplierTime, this.perls.getMultiplierTime(), width);
            g.setClip((xpos -= width) + h, ypos + h2, wb, height);
            bar.setFrame(0);
            bar.setPosition(xpos + h, ypos + h2);
            bar.paint(g);
        } else if (this.isArcadePlaying && this.iArcadeType == 2) {
            width = Resources.sprBar.getWidth();
            height = Resources.sprBar.getHeight();
            ypos = Resources.sprTopBar.getHeight() / 3 - 1;
            wb = GameDef.barValue(this.perls.iMultiplierTime, this.perls.getMultiplierTime(), width);
            g.setClip((xpos -= width) + h, ypos + h2, wb, height);
            bar.setFrame(0);
            bar.setPosition(xpos + h, ypos + h2);
            bar.paint(g);
        }
    }

    void paintGame(Graphics g) {
        g.setClip(0, Resources.sprTopBar.getHeight(), GameDef._WIDTH, GameDef._HEIGHT - Resources.sprTopBar.getHeight());
        this.paintInLevelBackground(g, 0);
        if (!this.bArcadeMode) {
            this.isArcadePlaying = false;
            if (iScreenCounter == 0) {
                this.paintLevel1(g);
            } else if (iScreenCounter == 1) {
                this.paintLevel2(g);
            } else if (iScreenCounter == 2) {
                this.paintLevel3(g);
            } else if (iScreenCounter == 3) {
                this.paintLevel4(g);
            } else if (iScreenCounter == 4) {
                this.paintLevel5(g);
            }
        } else {
            this.paintBorders(g);
            this.isArcadePlaying = true;
        }
        this.player.paint(g);
        this.perls.paint(g);
        this.player.paintPerl(g);
        this.paintFiguresForeground(g);
        WholeGame.particles.paintParticles(g);
        X.canvas.paintScoreLabels(g);
        X.canvas.paintCongratLabels(g);
        this.paintStatusBar(g);
    }

    void paintLevel1(Graphics g) {
        if (iScreenCounter != 0) {
            return;
        }
        Sprite spr = Resources.sprHora;
        spr.setFrame(0);
        spr.setPosition(0, GameDef._HEIGHT - Resources.sprHora.getHeight());
        spr.paint(g);
        this.paintBorders(g);
    }

    void paintLevel2(Graphics g) {
        if (iScreenCounter != 1) {
            return;
        }
        Sprite spr = Resources.sprHory;
        spr.setFrame(0);
        spr.setPosition(0, GameDef._HEIGHT - Resources.sprHory.getHeight());
        spr.paint(g);
        this.paintBorders(g);
    }

    void paintLevel3(Graphics g) {
        if (iScreenCounter != 2) {
            return;
        }
        Sprite sprH = Resources.sprHory;
        sprH.setFrame(0);
        sprH.setPosition(0, GameDef._HEIGHT - Resources.sprHory.getHeight());
        sprH.paint(g);
        Sprite spr = Resources.sprPozadie1;
        spr.setFrame(0);
        spr.setPosition(0, GameDef._HEIGHT - Resources.sprPozadie1.getHeight());
        spr.paint(g);
        this.paintBorders(g);
    }

    void paintLevel4(Graphics g) {
        if (iScreenCounter != 3) {
            return;
        }
        Sprite sprH = Resources.sprHory;
        sprH.setFrame(0);
        sprH.setPosition(0, GameDef._HEIGHT - Resources.sprHory.getHeight());
        sprH.paint(g);
        Sprite spr = Resources.sprPozadie2;
        spr.setFrame(0);
        spr.setPosition(0, GameDef._HEIGHT - Resources.sprPozadie2.getHeight());
        spr.paint(g);
        this.paintBorders(g);
    }

    void paintLevel5(Graphics g) {
        if (iScreenCounter != 4) {
            return;
        }
        Sprite sprH = Resources.sprHory;
        sprH.setFrame(0);
        sprH.setPosition(0, GameDef._HEIGHT - Resources.sprHory.getHeight());
        sprH.paint(g);
        Sprite spr = Resources.sprPozadie3;
        spr.setFrame(0);
        spr.setPosition(0, GameDef._HEIGHT - Resources.sprPozadie3.getHeight());
        spr.paint(g);
        this.paintBorders(g);
    }

    void paintLeveleSelectionBottom(Graphics g) {
        g.setColor(65280);
        g.fillRect(0, GameDef._HEIGHT - 50, GameDef._WIDTH, 50);
    }

    boolean selectSelectedLvl(int x, int y) {
        if (y > iPosY && y < iPosY + 2 * iShellH && x > iStartPosX && x < iStartPosX + 5 * iShellW) {
            this.iSelectorX = (x - iStartPosX) / iShellW;
            this.iSelectorY = (y - iPosY) / iShellH;
            iSelectedLvl = this.iSelectorY * 5 + this.iSelectorX;
            this.updateLevelDescription(iSelectedLvl + iScreenCounter * 10);
            if (this.iSelectorX == this.iOldSelectedX && this.iSelectorY == this.iOldSelectedY) {
                return true;
            }
            this.iOldSelectedX = this.iSelectorX;
            this.iOldSelectedY = this.iSelectorY;
        }
        return false;
    }

    void updateSelectorRL(boolean bLeft) {
        if (this.bScroll) {
            return;
        }
        this.bScrollL = false;
        this.iSelectorX = bLeft ? --this.iSelectorX : ++this.iSelectorX;
        if (this.iSelectorX > 4) {
            this.iSelectorX = 4;
            this.bScrollL = false;
            this.bScroll = true;
            if (iScreenCounter != 4) {
                // empty if block
            }
            if (iScreenCounter >= 4) {
                this.bScrollL = false;
                this.bScroll = false;
            }
        }
        if (iScreenCounter == 0) {
            // empty if block
        }
        if (this.iSelectorX < 0) {
            this.iSelectorX = 0;
            this.bScrollL = true;
            this.bScroll = true;
            if (iScreenCounter != 0) {
                // empty if block
            }
            if (iScreenCounter == 0) {
                iScreenCounter = 0;
                this.bScrollL = false;
                this.bScroll = false;
            }
        }
        iSelectedLvl = this.iSelectorY * 5 + this.iSelectorX;
    }

    void scrollScreenL() {
        if (this.bScroll) {
            return;
        }
        this.iSelectorX = 0;
        this.bScrollL = true;
        this.bScroll = true;
        if (iScreenCounter != 0) {
            // empty if block
        }
        if (iScreenCounter <= 0) {
            iScreenCounter = 0;
            this.bScrollL = false;
            this.bScroll = false;
        }
    }

    void scrollScreenR() {
        if (this.bScroll) {
            return;
        }
        this.iSelectorX = 4;
        this.bScrollL = false;
        this.bScroll = true;
        if (iScreenCounter != 4) {
            // empty if block
        }
        if (iScreenCounter >= 4) {
            iScreenCounter = 4;
            this.bScrollL = false;
            this.bScroll = false;
        }
    }

    void updateSelectorUD(boolean bUp) {
        if (this.bScroll) {
            return;
        }
        if (bUp && --this.iSelectorY < 0) {
            this.iSelectorY = 0;
        }
        if (!bUp && ++this.iSelectorY > 1) {
            this.iSelectorY = 1;
        }
        iSelectedLvl = this.iSelectorY * 5 + this.iSelectorX;
    }

    void setCurrentLevel() {
        this.iSelectedLevel = this.iActualSelectedLevel = this.iSelectorY * 5 + this.iSelectorX + iScreenCounter * 10;
        this.iLevelNum = this.iActualSelectedLevel;
    }

    void updateScroll() {
        if (this.bScroll) {
            if (this.bScrollL) {
                this.iScrollX += 10;
                this.iParalaxPosX += 2;
            } else {
                this.iScrollX -= 10;
                this.iParalaxPosX -= 2;
            }
            if (Math.abs(this.iScrollX) >= GameDef._WIDTH) {
                if (this.bScrollL) {
                    if (--iScreenCounter < 0) {
                        iScreenCounter = 0;
                    }
                } else if (++iScreenCounter >= 4) {
                    iScreenCounter = 4;
                }
                this.iScrollX = 0;
                this.bScroll = false;
                this.iSelectorX = 0;
                iSelectedLvl = this.iSelectorY * 5 + this.iSelectorX;
                this.updateLevelDescription(iSelectedLvl + iScreenCounter * 10);
            }
        }
    }

    static void prepareLevelScreen() {
        iShellW = Resources.iLevelOpn.getWidth();
        iShellH = Resources.iLevelOpn.getHeight() + 2 * Resources.iSprStarsH;
        iStartPosX = GameDef._WIDTH - 5 * iShellW >> 1;
        iStarDiffX = iShellW - 3 * Resources.iSprStarsW >> 1;
        iTextTableW = 4 * iSpacesW + 5 * Resources.iLevelOpn.getWidth();
        iTablePosX = iPosX;
        iTablePosY = iSpacesW * 3 + Resources.iLevelOpn.getHeight() * 2;
        iPosY = iShellH >> 1;
        iWindowPosY = 4 * iShellH;
    }

    int getActualLevelCount() {
        return this.iLevelNum;
    }

    void paintTextTable(Graphics g) {
        g.setColor(0xFF0000);
        g.fillRect(iTablePosX + this.iScrollX, iTablePosY, iTextTableW, 120);
    }

    Image getActualLevelImg(int x, int y) {
        Level.unlockedLevels[0] = 1;
        this.iSelected = x * 5 + y;
        if (unlockedLevels[this.iSelected + iScreenCounter * 10] == 0) {
            isLvlUnlocked = false;
            if (this.iSelected == iSelectedLvl) {
                return Resources.iLevelClsSel;
            }
            return Resources.iLevelCls;
        }
        isLvlUnlocked = true;
        if (this.iSelected == iSelectedLvl) {
            return Resources.iLevelOpnSel;
        }
        return Resources.iLevelOpn;
    }

    boolean isUnlockedLevel(int x, int y) {
        this.iTmpVal = iScreenCounter * 10 + (x * 5 + y);
        if (this.iTmpVal > 50) {
            return false;
        }
        return unlockedLevels[iScreenCounter * 10 + (x * 5 + y)] == 1;
    }

    boolean isLevelUnlocked() {
        return unlockedLevels[iScreenCounter * 10 + (this.iSelectorY * 5 + this.iSelectorX)] == 1;
    }

    void paintStars(Graphics g, int x, int y, int cnt) {
        y += 25;
        x += iStarDiffX + Resources.sprLevelStar.getWidth() * 2 + 5;
        for (int i = 0; i < 3; ++i) {
            if (i < cnt) {
                Resources.sprLevelStar.setFrame(0);
            } else {
                Resources.sprLevelStar.setFrame(1);
            }
            if (i == 1) {
                Resources.sprLevelStar.setPosition(x, y - 3);
            } else {
                Resources.sprLevelStar.setPosition(x, y);
            }
            Resources.sprLevelStar.paint(g);
            x += Resources.iSprStarsW;
        }
    }

    public void paintLevelBackground(Graphics g) {
    }

    public void paintBackground(Graphics g, int iScrlX) {
        Sprite spr;
        Sprite sprH;
        Sprite spr2;
        if (Resources.imgBg != null) {
            g.drawImage(Resources.imgBg, 0, 0, 20);
        } else {
            g.setColor(866662);
            g.fillRect(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
        }
        if (iScreenCounter == 0) {
            spr2 = Resources.sprHora;
            spr2.setFrame(0);
            spr2.setPosition(iScrlX, GameDef._HEIGHT - Resources.sprHora.getHeight());
            spr2.paint(g);
        }
        if (iScreenCounter == 1) {
            spr2 = Resources.sprHory;
            spr2.setFrame(0);
            spr2.setPosition(iScrlX, GameDef._HEIGHT - Resources.sprHory.getHeight());
            spr2.paint(g);
        }
        if (iScreenCounter == 2) {
            sprH = Resources.sprHory;
            sprH.setFrame(0);
            sprH.setPosition(iScrlX, GameDef._HEIGHT - Resources.sprHory.getHeight());
            sprH.paint(g);
            spr = Resources.sprPozadie1;
            spr.setFrame(0);
            spr.setPosition(iScrlX, GameDef._HEIGHT - Resources.sprPozadie1.getHeight());
            spr.paint(g);
        }
        if (iScreenCounter == 3) {
            sprH = Resources.sprHory;
            sprH.setFrame(0);
            sprH.setPosition(iScrlX, GameDef._HEIGHT - Resources.sprHory.getHeight());
            sprH.paint(g);
            spr = Resources.sprPozadie2;
            spr.setFrame(0);
            spr.setPosition(iScrlX, GameDef._HEIGHT - Resources.sprPozadie2.getHeight());
            spr.paint(g);
        }
        if (iScreenCounter == 4) {
            sprH = Resources.sprHory;
            sprH.setFrame(0);
            sprH.setPosition(iScrlX, GameDef._HEIGHT - Resources.sprHory.getHeight());
            sprH.paint(g);
            spr = Resources.sprPozadie3;
            spr.setFrame(0);
            spr.setPosition(iScrlX, GameDef._HEIGHT - Resources.sprPozadie3.getHeight());
            spr.paint(g);
        }
        g.drawImage(Resources.imgBg2, iScrlX, GameDef._HEIGHT - Resources.iBgH2, 20);
    }

    public void paintInLevelBackground(Graphics g, int iScrlX) {
        if (Resources.imgBg != null) {
            g.drawImage(Resources.imgBg, 0, 0, 20);
        } else {
            g.setColor(866662);
            g.fillRect(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
        }
    }

    void paintLevelScrolling(Graphics g, int iScrlX) {
        if (iScrlX < 0) {
            Sprite spr;
            Sprite sprH;
            if (iScreenCounter == 0) {
                sprH = Resources.sprHory;
                sprH.setFrame(0);
                sprH.setPosition(iScrlX + GameDef._WIDTH, GameDef._HEIGHT - Resources.sprHora.getHeight());
                sprH.paint(g);
            }
            if (iScreenCounter == 1) {
                sprH = Resources.sprHory;
                sprH.setFrame(0);
                sprH.setPosition(iScrlX + GameDef._WIDTH, GameDef._HEIGHT - Resources.sprHory.getHeight());
                sprH.paint(g);
                spr = Resources.sprPozadie1;
                spr.setFrame(0);
                spr.setPosition(iScrlX + GameDef._WIDTH, GameDef._HEIGHT - Resources.sprPozadie1.getHeight());
                spr.paint(g);
            }
            if (iScreenCounter == 2) {
                sprH = Resources.sprHory;
                sprH.setFrame(0);
                sprH.setPosition(iScrlX + GameDef._WIDTH, GameDef._HEIGHT - Resources.sprHory.getHeight());
                sprH.paint(g);
                spr = Resources.sprPozadie2;
                spr.setFrame(0);
                spr.setPosition(iScrlX + GameDef._WIDTH, GameDef._HEIGHT - Resources.sprPozadie2.getHeight());
                spr.paint(g);
            }
            if (iScreenCounter == 3) {
                sprH = Resources.sprHory;
                sprH.setFrame(0);
                sprH.setPosition(iScrlX + GameDef._WIDTH, GameDef._HEIGHT - Resources.sprHory.getHeight());
                sprH.paint(g);
                spr = Resources.sprPozadie3;
                spr.setFrame(0);
                spr.setPosition(iScrlX + GameDef._WIDTH, GameDef._HEIGHT - Resources.sprPozadie3.getHeight());
                spr.paint(g);
            }
            g.drawImage(Resources.imgBg2, iScrlX + GameDef._WIDTH, GameDef._HEIGHT - Resources.iBgH2, 20);
        } else {
            Sprite spr;
            Sprite sprH;
            if (iScreenCounter == 1) {
                Sprite spr2 = Resources.sprHora;
                spr2.setFrame(0);
                spr2.setPosition(iScrlX - GameDef._WIDTH, GameDef._HEIGHT - Resources.sprHora.getHeight());
                spr2.paint(g);
            }
            if (iScreenCounter == 2) {
                sprH = Resources.sprHory;
                sprH.setFrame(0);
                sprH.setPosition(iScrlX - GameDef._WIDTH, GameDef._HEIGHT - Resources.sprHory.getHeight());
                sprH.paint(g);
            }
            if (iScreenCounter == 3) {
                sprH = Resources.sprHory;
                sprH.setFrame(0);
                sprH.setPosition(iScrlX - GameDef._WIDTH, GameDef._HEIGHT - Resources.sprHory.getHeight());
                sprH.paint(g);
                spr = Resources.sprPozadie1;
                spr.setFrame(0);
                spr.setPosition(iScrlX - GameDef._WIDTH, GameDef._HEIGHT - Resources.sprPozadie1.getHeight());
                spr.paint(g);
            }
            if (iScreenCounter == 4) {
                sprH = Resources.sprHory;
                sprH.setFrame(0);
                sprH.setPosition(iScrlX - GameDef._WIDTH, GameDef._HEIGHT - Resources.sprHory.getHeight());
                sprH.paint(g);
                spr = Resources.sprPozadie2;
                spr.setFrame(0);
                spr.setPosition(iScrlX - GameDef._WIDTH, GameDef._HEIGHT - Resources.sprPozadie2.getHeight());
                spr.paint(g);
            }
            g.drawImage(Resources.imgBg2, iScrlX - GameDef._WIDTH, GameDef._HEIGHT - Resources.iBgH2, 20);
        }
    }

    void paintLevels(Graphics g, int iScrlX) {
        this.iActualPosY = iPosY;
        for (int i = 0; i < 2; ++i) {
            this.iActualPosX = iStartPosX + iScrlX;
            for (int j = 0; j < 5; ++j) {
                g.drawImage(this.getActualLevelImg(i, j), this.iActualPosX, this.iActualPosY, 0);
                this.iLevelFontX = Resources.iSelectorLevelW - Resources.sprDolnyBar.getHeight() / 18 * Resources.iNumW - this.iCharSpace >> 1;
                this.iActualValue = i * 5 + j + iScreenCounter * 10 + 1;
                this.sbLvls.setLength(0);
                if (this.iActualValue < 10) {
                    this.sbLvls.append(0);
                }
                this.sbLvls.append(this.iActualValue);
                Texts.drawLevel(g, this.sbLvls.toString(), this.iActualPosX + this.iLevelFontX - this.iNumbersPosX, this.iActualPosY + this.iNumbersPosY, this.iCharSpace);
                g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
                if (this.isUnlockedLevel(i, j)) {
                    this.iStarsUnlock = levelStars[iScreenCounter * 10 + (i * 5 + j)];
                    this.paintStars(g, this.iActualPosX - Resources.iLevelCls.getWidth() / 3 * 2, this.iActualPosY - (Resources.iLevelCls.getHeight() - 5), this.iStarsUnlock);
                }
                this.iActualPosX += iShellW;
            }
            this.ypaint = this.iActualPosY;
            this.iActualPosY += iShellH;
        }
    }

    void paintLevelDescription(Graphics g) {
        int y = 0;
        int w = 0;
        y = GameDef._HEIGHT - Resources.sprWindow.getHeight() * 3;
        if (this.bScroll) {
            return;
        }
        if (!this.isUnlockedLevel(this.iSelectorY, this.iSelectorX)) {
            return;
        }
        iTableWindowW = GameDef._WIDTH == 176 ? GameDef._WIDTH - Resources.iChatArrW * 2 - iArrowDiffX * 2 : (GameDef._WIDTH == 360 ? GameDef._WIDTH - Resources.iChatArrW * 2 - iArrowDiffX * 2 : (GameDef._WIDTH == 480 ? GameDef._WIDTH - Resources.iChatArrW * 2 - iArrowDiffX * 2 : 180));
        g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
        if (GameDef._HEIGHT - (this.ypaint + Resources.iLevelCls.getHeight() + 2) < Resources.sprWindow.getWidth() * 3) {
            X.canvas.paintGuiTable(g, GameDef._WIDTH - Resources.sprWindow.getWidth() * 3 - w >> 1, this.ypaint + Resources.iLevelCls.getHeight() + 2, w + Resources.sprWindow.getWidth() * 3, GameDef._HEIGHT - (this.ypaint + Resources.iLevelCls.getHeight() + 2), 4);
        } else {
            X.canvas.paintGuiTable(g, GameDef._WIDTH - Resources.sprWindow.getWidth() * 3 - w >> 1, y, w + Resources.sprWindow.getWidth() * 3, Resources.sprWindow.getHeight() * 3, 4);
        }
        Txt.drawCenteredText(g, y + Resources.iWindowH);
    }

    void updateLevelDescription(int iLevel) {
        this.sb.setLength(0);
        if (iLevel == 0) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 3");
        } else if (iLevel == 1) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 4");
        } else if (iLevel == 2) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 4");
        } else if (iLevel == 3) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 4").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_1"));
        } else if (iLevel == 4) {
            this.sb.append(X.texts.getHashedString("LEVEL_3")).append("\n").append(X.texts.getHashedString("BONUS_1"));
        } else if (iLevel == 5) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 4").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_1"));
        } else if (iLevel == 6) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_1"));
        } else if (iLevel == 7) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 6").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_3"));
        } else if (iLevel == 8) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 6").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_1")).append("\n").append(X.texts.getHashedString("CHALLANGE_3"));
        } else if (iLevel == 9) {
            this.sb.append(X.texts.getHashedString("LEVEL_3")).append("\n").append(X.texts.getHashedString("CHALLANGE_3")).append("\n").append(X.texts.getHashedString("BONUS_1"));
        } else if (iLevel == 10) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 4");
        } else if (iLevel == 11) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_1"));
        } else if (iLevel == 12) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 4").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_2"));
        } else if (iLevel == 13) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_2"));
        } else if (iLevel == 14) {
            this.sb.append(X.texts.getHashedString("LEVEL_3")).append("\n").append(X.texts.getHashedString("BONUS_2"));
        } else if (iLevel == 15) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_4"));
        } else if (iLevel == 16) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_4")).append("\n").append(X.texts.getHashedString("CHALLANGE_1"));
        } else if (iLevel == 17) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 4").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_1")).append("\n").append(X.texts.getHashedString("CHALLANGE_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_4"));
        } else if (iLevel == 18) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 7").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_3"));
        } else if (iLevel == 19) {
            this.sb.append(X.texts.getHashedString("LEVEL_3")).append("\n").append(X.texts.getHashedString("BONUS_2"));
        } else if (iLevel == 20) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("CHALLANGE_1"));
        } else if (iLevel == 21) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 4").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_2"));
        } else if (iLevel == 22) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_5"));
        } else if (iLevel == 23) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 4").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_5"));
        } else if (iLevel == 24) {
            this.sb.append(X.texts.getHashedString("LEVEL_3")).append("\n").append(X.texts.getHashedString("BONUS_3"));
        } else if (iLevel == 25) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("BONUS_1"));
        } else if (iLevel == 26) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("BONUS_1"));
        } else if (iLevel == 27) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("BONUS_1")).append("\n").append(X.texts.getHashedString("CHALLANGE_1"));
        } else if (iLevel == 28) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("BONUS_1")).append("\n").append(X.texts.getHashedString("CHALLANGE_2"));
        } else if (iLevel == 29) {
            this.sb.append(X.texts.getHashedString("LEVEL_3")).append("\n").append(X.texts.getHashedString("BONUS_3"));
        } else if (iLevel == 30) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 6");
        } else if (iLevel == 31) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 7").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_1"));
        } else if (iLevel == 32) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 7").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_5"));
        } else if (iLevel == 33 && WholeGame.selectedLang == 1 && GameDef._WIDTH == 128) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 7").append(" ").append(X.texts.getHashedString("LEVEL_2")).append(" ").append(X.texts.getHashedString("CHALLANGE_2")).append(" ").append(X.texts.getHashedString("CHALLANGE_5"));
        } else if (iLevel == 33) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 7").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_5"));
        } else if (iLevel == 34) {
            this.sb.append(X.texts.getHashedString("LEVEL_3")).append("\n").append(X.texts.getHashedString("BONUS_4"));
        } else if (iLevel == 35) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 4").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_6"));
        } else if (iLevel == 36) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_1")).append("\n").append(X.texts.getHashedString("CHALLANGE_6"));
        } else if (iLevel == 37 && WholeGame.selectedLang == 1 && GameDef._WIDTH == 128) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 6").append(" ").append(X.texts.getHashedString("LEVEL_2")).append(" ").append(X.texts.getHashedString("CHALLANGE_1")).append(" ").append(X.texts.getHashedString("CHALLANGE_5")).append(" ").append(X.texts.getHashedString("CHALLANGE_6"));
        } else if (iLevel == 37 && WholeGame.selectedLang == 3 && GameDef._WIDTH == 128) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 6").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_1")).append("\n").append(X.texts.getHashedString("CHALLANGE_5")).append(" ").append(X.texts.getHashedString("CHALLANGE_6"));
        } else if (iLevel == 37) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 6").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_1")).append("\n").append(X.texts.getHashedString("CHALLANGE_5")).append("\n").append(X.texts.getHashedString("CHALLANGE_6"));
        } else if (iLevel == 38) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_6"));
        } else if (iLevel == 39) {
            this.sb.append(X.texts.getHashedString("LEVEL_3")).append("\n").append(X.texts.getHashedString("BONUS_4")).append("\n").append(X.texts.getHashedString("CHALLANGE_1"));
        } else if (iLevel == 40) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 3").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_1")).append("\n").append(X.texts.getHashedString("BONUS_3"));
        } else if (iLevel == 41) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 4").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_2")).append("\n").append(X.texts.getHashedString("BONUS_3"));
        } else if (iLevel == 42) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 6").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("RAY"));
        } else if (iLevel == 43) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 7").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_1")).append("\n").append(X.texts.getHashedString("RAY"));
        } else if (iLevel == 44) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 3").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("BONUS_1"));
        } else if (iLevel == 45) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 3").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_8"));
        } else if (iLevel == 46) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 4").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_8"));
        } else if (iLevel == 47) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 5").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_8"));
        } else if (iLevel == 48) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 6").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_8"));
        } else if (iLevel == 49) {
            this.sb.append(X.texts.getHashedString("LEVEL_1")).append(" 7").append("\n").append(X.texts.getHashedString("LEVEL_2")).append("\n").append(X.texts.getHashedString("CHALLANGE_8"));
        }
        WholeGame.txt.prepareText(this.sb.toString(), Resources.sprWindow.getWidth() * 2, Resources.sprWindow.getHeight(), 0);
    }

    void paintLevelSelection(Graphics g) {
        this.paintBackground(g, this.iScrollX);
        this.paintLevelScrolling(g, this.iScrollX);
        this.paintLevels(g, this.iScrollX);
        this.paintLevelDescription(g);
        if (this.bScroll) {
            return;
        }
        g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
        Sprite spr = Resources.sprChatArr;
        if (iScreenCounter != 0) {
            spr.setFrame(0);
            spr.setPosition(iArrowDiffX, GameDef._HEIGHT / 2 - Resources.sprChatArr.getHeight() / 2);
            spr.paint(g);
        }
        if (iScreenCounter != 4) {
            spr.setFrame(1);
            spr.setPosition(GameDef._WIDTH - Resources.iChatArrW - iArrowDiffX, GameDef._HEIGHT / 2 - Resources.sprChatArr.getHeight() / 2);
            Resources.sprChatArr.paint(g);
        }
    }

    void updateLevelInfo() {
    }

    void paintLevelDetails(Graphics g) {
        int i;
        Texts.setFontSize(GameDef.FONT_MENU);
        int iLines = 3;
        int iLineHeight = Texts.iFontHeight + 2;
        int borderWidth = Resources.sprChatArr.getWidth();
        int borderHeight = Resources.sprChatArr.getWidth();
        int iLineGap = 2;
        int gap = 3;
        int width = 5 * Resources.iLevelOpn.getWidth() + 6 * gap + 2 * borderWidth;
        int height = 2 * Resources.iLevelOpn.getHeight() + 2 * borderHeight + 3 * iLineGap;
        int iLeft = (GameDef._WIDTH - width) / 2;
        int levelBase = this.iSelectedFlag * 10;
        int iTop = iLeft;
        int iWidth = GameDef._WIDTH - 2 * iLeft;
        if (X.canvas.menuState != 0) {
            iTop -= iLeft + height - GameDef.barValue(X.canvas.iarrElasticMovement[X.canvas.menuAnimOffs], 100, iLeft + height);
        }
        g.setColor(15128735);
        X.canvas.paintGuiRect(g, Resources.sprBtnMenu, iLeft, iTop, width, height, 4);
        g.setClip(0, 0, GameDef._WIDTH, GameDef._HEIGHT);
        int ypos = iTop + borderHeight + gap;
        int xpos = iLeft + borderWidth + gap;
        for (i = 0; i < 5; ++i) {
            if (this.baLevelLock[levelBase + i] != 0) {
                g.drawImage(Resources.iLevelCls, xpos, ypos, 20);
            } else {
                g.drawImage(Resources.iLevelOpn, xpos, ypos, 20);
                this.paintLevelIcon(g, xpos, ypos, levelBase + i);
            }
            if (i == this.iSelectedLevel && this.buoyDepth < 0) {
                g.drawImage(Resources.iLevelOpnSel, xpos - 1, ypos - 1, 20);
            }
            xpos += Resources.iLevelOpn.getWidth() + gap;
        }
        ypos += Resources.iLevelOpn.getWidth() + gap;
        xpos = iLeft + borderWidth + gap;
        for (i = 0; i < 5; ++i) {
            if (this.baLevelLock[levelBase + 5 + i] != 0) {
                g.drawImage(Resources.iLevelCls, xpos, ypos, 20);
            } else {
                g.drawImage(Resources.iLevelOpn, xpos, ypos, 20);
                this.paintLevelIcon(g, xpos, ypos, levelBase + 5 + i);
            }
            if (i + 5 == this.iSelectedLevel && this.buoyDepth < 0) {
                g.drawImage(Resources.iLevelOpn, xpos - 1, ypos - 1, 20);
            }
            xpos += Resources.iLevelOpn.getWidth() + gap;
        }
        iLines = 3;
        iTop = iLeft + height + 1;
        height = X.canvas.calcStatsHeight();
        if (X.canvas.menuState != 0) {
            iTop += height - GameDef.barValue(X.canvas.iarrElasticMovement[X.canvas.menuAnimOffs], 100, height);
        }
        g.setColor(15128735);
        X.canvas.paintGuiRect(g, Resources.sprBtnMenu, iLeft, iTop, width, height, 4);
        int w = Resources.sprBtnMenu.getWidth();
        if (X.canvas.menuState == 0) {
            int pw = Resources.sprBtnMenu.getWidth();
            int py = iTop + Resources.sprBtnMenu.getHeight();
            int len = this.vecStatsLeft.size();
            for (int i2 = 0; i2 < len; ++i2) {
                py += X.canvas.paintStatsLine(g, this.vecStatsLeft.elementAt(i2).toString(), this.vecStatsRight.elementAt(i2).toString(), iLeft + pw, py, width - 2 * pw, iLineHeight) + iLineGap;
            }
        }
    }

    void paintLevelIcon(Graphics g, int xpos, int ypos, int level) {
    }

    void prepareBorders() {
        int iStep = GameDef._HEIGHT / 10;
        for (int i = 14; i >= 0; --i) {
            if (i < 10) {
                this.iBubblePosY[i] = i * iStep;
                this.iBubbleSpeed[i] = 9;
                this.iBubblePosX[i] = 0;
                this.iBubbleSizeX[i] = 0;
                continue;
            }
            this.iBubblePosY[i] = GameDef._HEIGHT;
            this.iBubbleSpeed[i] = 2 + Common.getRandomUInt(5);
            this.iBubbleSizeX[i] = Common.getRandomUInt(2);
            this.iBubblePosX[i] = Common.getRandomInt(5) * 2;
        }
    }

    void updateBorders() {
        for (int i = 14; i >= 0; --i) {
            int n = i;
            this.iBubblePosY[n] = this.iBubblePosY[n] - this.iBubbleSpeed[i];
            if (this.iBubblePosY[i] > 0) continue;
            if (i < 10) {
                this.iBubblePosY[i] = GameDef._HEIGHT;
                continue;
            }
            this.iBubblePosY[i] = GameDef._HEIGHT;
            this.iBubbleSpeed[i] = 2 + Common.getRandomUInt(5);
            this.iBubbleSizeX[i] = Common.getRandomUInt(2);
            this.iBubblePosX[i] = Common.getRandomInt(5) * 2;
        }
    }

    void paintBubles(Graphics g) {
        for (int i = 14; i >= 0; --i) {
            Resources.sprBubbles.setFrame(this.iBubbleSizeX[i]);
            Resources.sprBubbles.setPosition(this.perls.iRight - Resources.sprBubblesWidth2 - this.iBubblePosX[i], this.iBubblePosY[i]);
            Resources.sprBubbles.paint(g);
            Resources.sprBubbles.setPosition(this.perls.iLeft - Resources.sprBubblesWidth2 + this.iBubblePosX[i], this.iBubblePosY[i]);
            Resources.sprBubbles.paint(g);
        }
    }

    void paintBorders(Graphics g) {
        g.setClip(0, Resources.sprTopBar.getHeight(), GameDef._WIDTH, GameDef._HEIGHT);
        this.paintBubles(g);
    }

    void paint(Graphics g) {
        switch (WholeGame.mode) {
            case 11: {
                this.paintLevelSelection(g);
                X.canvas.updateMenuAnimation();
                X.canvas.paintRightButton(g, 2);
                break;
            }
            case 12: {
                this.paintLevelSelection(g);
                this.paintLevelDetails(g);
                X.canvas.updateMenuAnimation();
                X.canvas.paintLeftButton(g, 2);
                if (this.baLevelLock[this.iSelectedFlag * 10 + this.iSelectedLevel] != 0) break;
                X.canvas.paintRightButton(g, 0);
                break;
            }
            case 13: {
                this.paintLevelSelection(g);
                X.canvas.paintSimpleText(g, Resources.sprBtnMenu);
                X.canvas.updateMenuAnimation();
                X.canvas.paintLeftButton(g, 2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 39: {
                this.paintGame(g);
            }
        }
    }

    static {
        isLvlUnlocked = false;
        iArcadeNormalTopScore = 0;
        iArcadeZumaTopScore = 0;
        iArcadeFallingTopScore = 0;
        unlockedLevels = new int[50];
        levelStars = new int[50];
        unlockedFigures = new int[5];
        iIdxShooter = 0;
        bSwitchFig = false;
        iSwitchSide = 5;
        iNextShooter = 0;
        bSwapped = false;
        iSelectedLvl = 0;
        iSpacesW = 10;
        iSpacesH = 10;
        iPosX = 0;
        iPosY = 0;
        iScreenCounter = 0;
        iWindowPosY = 0;
        iArrowDiffX = 5;
    }
}

