/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

class Player {
    static final int HIT_DELAY = 5;
    static final int PMODE_IDLE = 0;
    static final int PMODE_SHOOTING = 1;
    static final int PMODE_HAPPY = 2;
    boolean playerMovingLeft;
    boolean playerMovingRight;
    boolean playerMovingUp;
    boolean playerMovingDown;
    boolean playerPressingAttack;
    int playerXPx;
    int playerYPx;
    int playerAngle;
    int playerMode;
    int playerFrame;
    int playerPointer;
    int playerPointerDelay;
    int playerBounces;
    int perlBaseXPx;
    int perlBaseYPx;
    int perlX;
    int perlXPx;
    int perlY;
    int perlYPx;
    int perlAngle;
    int perlSpd;
    int perlSpdX;
    int perlSpdY;
    static int perlType;
    int iPointerCount = 0;
    int iScore;
    int iTargetLeft;
    int iTargetRight;
    int shootCounter = 0;
    int iPointerNewAngle = 0;
    boolean bTouched = false;

    Player() {
    }

    void reset() {
        Debug.trace("Player.reset() - in");
        this.initPlayerPos();
        this.playerMode = 0;
        this.playerFrame = 0;
        this.playerAngle = 90;
        this.playerPointer = 8;
        perlType = -1979;
        this.iScore = 0;
        this.shootCounter = 0;
        this.iTargetLeft = WholeGame.level.perls.iLeft + Resources.sprPerlsWidth / 2;
        this.iTargetRight = WholeGame.level.perls.iRight - Resources.sprPerlsWidth / 2;
        this.playerPointerDelay = 3000;
        Debug.trace("Player.reset() - out");
    }

    void initPlayerPos() {
        this.playerXPx = 115;
        this.playerYPx = 320;
        int pdspx = 3;
        int pdspy = 5;
        this.perlBaseXPx = GameDef._WIDTH / 2;
        this.perlBaseYPx = this.playerYPx + pdspy;
        this.perlBaseYPx = this.playerYPx + pdspy * 11;
    }

    void initPerl(int nextPerlType) {
        this.perlXPx = this.perlBaseXPx;
        this.perlX = this.perlXPx << 4;
        this.perlYPx = this.perlBaseYPx;
        this.perlY = this.perlYPx << 4;
        this.perlSpdX = 0;
        this.perlSpdY = 0;
        this.perlSpd = 0;
        perlType = nextPerlType;
    }

    void save(DataOutputStream data) {
        try {
            data.writeInt(this.playerXPx);
            data.writeInt(this.playerYPx);
            data.writeInt(this.playerAngle);
            data.writeInt(this.playerMode);
            data.writeInt(this.playerFrame);
            data.writeInt(this.playerPointer);
            data.writeInt(this.playerPointerDelay);
            data.writeInt(this.playerBounces);
            data.writeInt(this.perlX);
            data.writeInt(this.perlXPx);
            data.writeInt(this.perlY);
            data.writeInt(this.perlYPx);
            data.writeInt(this.perlAngle);
            data.writeInt(this.perlSpd);
            data.writeInt(this.perlSpdX);
            data.writeInt(this.perlSpdY);
            data.writeInt(perlType);
            data.writeInt(this.iScore);
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
        }
    }

    void load(DataInputStream data) {
        try {
            this.playerXPx = data.readInt();
            this.playerYPx = data.readInt();
            this.playerAngle = data.readInt();
            this.playerMode = data.readInt();
            this.playerFrame = data.readInt();
            this.playerPointer = data.readInt();
            this.playerPointerDelay = data.readInt();
            this.playerBounces = data.readInt();
            this.perlX = data.readInt();
            this.perlXPx = data.readInt();
            this.perlY = data.readInt();
            this.perlYPx = data.readInt();
            this.perlAngle = data.readInt();
            this.perlSpd = data.readInt();
            this.perlSpdX = data.readInt();
            this.perlSpdY = data.readInt();
            perlType = data.readInt();
            this.iScore = data.readInt();
        }
        catch (Throwable ex) {
            Debug.trace(ex.toString());
        }
    }

    void incScore(int inc) {
        this.iScore += inc;
        if (this.iScore < 0) {
            this.iScore = 0;
        }
        WholeGame.level.bRefreshStatusScore = true;
    }

    void updatePerlMovement() {
        int sprW2;
        block19: {
            block20: {
                if (perlType == -1979) {
                    if (WholeGame.level.perls.bNextPerlReady) {
                        WholeGame.level.nextPerl();
                    }
                    return;
                }
                if (this.perlSpd == 0) {
                    return;
                }
                int h = 1;
                h = 2;
                this.perlX += this.perlSpdX * h;
                this.perlY += this.perlSpdY * h;
                this.perlXPx = this.perlX >> 4;
                this.perlYPx = this.perlY >> 4;
                sprW2 = Resources.sprPerlsWidth / 2;
                if (perlType != 901) {
                    if (this.perlXPx - sprW2 <= WholeGame.level.perls.iLeft) {
                        if (perlType != 15) {
                            ++this.playerBounces;
                        }
                        X.canvas.createScoreLabelMul(this.perlXPx, this.perlYPx, this.playerBounces + 1);
                        this.perlSpdX = -this.perlSpdX;
                        this.perlXPx = WholeGame.level.perls.iLeft + sprW2;
                        this.perlX = this.perlXPx << 4;
                        WholeGame.sounds.playSound_Bounce();
                        return;
                    }
                    if (this.perlXPx + sprW2 >= WholeGame.level.perls.iRight) {
                        if (perlType != 15) {
                            ++this.playerBounces;
                        }
                        X.canvas.createScoreLabelMul(this.perlXPx, this.perlYPx, this.playerBounces + 1);
                        this.perlSpdX = -this.perlSpdX;
                        this.perlXPx = WholeGame.level.perls.iRight - sprW2;
                        this.perlX = this.perlXPx << 4;
                        WholeGame.sounds.playSound_Bounce();
                        return;
                    }
                }
                if (perlType == 901) break block19;
                if (this.perlXPx - sprW2 < WholeGame.level.perls.iLeft) break block20;
                if (this.perlXPx + sprW2 <= WholeGame.level.perls.iRight && this.perlYPx + sprW2 >= 0) break block19;
            }
            if (!WholeGame.level.perls.perlWasDestroyed()) {
                WholeGame.level.perls.resetChainCounter();
            }
        }
        if (perlType == 901 && (this.perlXPx + sprW2 < 0 || this.perlXPx - sprW2 > GameDef._WIDTH || this.perlYPx + sprW2 < 0)) {
            WholeGame.level.perls.bShakePerlsNeeded = true;
            perlType = -1979;
            WholeGame.level.nextPerl();
            return;
        }
        if (this.perlYPx + sprW2 < 0) {
            if (perlType != 15 && perlType != 901) {
                this.incScore(-5);
                X.canvas.createScoreLabel(this.perlXPx, 3 * Resources.sprPerlsWidth, -5);
                WholeGame.level.iChainCount = 0;
                WholeGame.level.perls.resetChainCounter();
                WholeGame.sounds.playSound(1, 9, 10);
                Level.figState[WholeGame.level.idx_octopus] = 2;
                GameDef.figStateTimer[WholeGame.level.idx_octopus] = 300;
            }
            if (perlType == 901) {
                WholeGame.level.perls.bShakePerlsNeeded = true;
            }
            perlType = -1979;
            WholeGame.level.nextPerl();
            return;
        }
        if (this.perlYPx + sprW2 > WholeGame.level.perls.getBottom() && this.perlSpdY > 0) {
            WholeGame.particles.createBubbles(this.perlXPx, this.perlYPx);
            perlType = -1979;
            WholeGame.level.nextPerl();
            return;
        }
        if (WholeGame.level.testFigureHit(this.perlXPx, this.perlYPx) != -1) {
            perlType = -1979;
            WholeGame.level.nextPerl();
        }
        if (WholeGame.level.perls.testPerl(this.perlX, this.perlY, this.perlSpd, this.perlSpdY, perlType)) {
            perlType = -1979;
            this.perlSpd = 0;
            return;
        }
    }

    void resetPlayerActions() {
        this.playerMovingLeft = false;
        this.playerMovingRight = false;
        this.playerMovingUp = false;
        this.playerMovingDown = false;
        this.playerPressingAttack = false;
        WholeGame.invalidateKeys();
    }

    int getPlayerShootCount() {
        return this.shootCounter;
    }

    void resetShootCounter() {
        this.shootCounter = 0;
    }

    void updatePointer() {
        if (!this.bTouched) {
            return;
        }
        if (this.iPointerNewAngle >= this.playerAngle) {
            this.playerMovingRight = true;
            this.playerMovingLeft = false;
        }
        if (this.iPointerNewAngle <= this.playerAngle) {
            this.playerMovingRight = false;
            this.playerMovingLeft = true;
        }
        if (Math.abs(this.iPointerNewAngle - this.playerAngle) < 1) {
            this.playerAngle = this.iPointerNewAngle;
            this.bTouched = false;
            this.playerMovingRight = false;
            this.playerMovingLeft = false;
        }
    }

    void resetPointer() {
        this.bTouched = false;
    }

    void setPointerAngle(int iAngle) {
        if (iAngle > 175 && iAngle <= 360) {
            return;
        }
        if (iAngle >= 0 && iAngle <= 5) {
            return;
        }
        this.iPointerNewAngle = iAngle;
        this.playerAngle = iAngle;
        this.bTouched = true;
    }

    void update() {
        this.playerMovingLeft = (WholeGame.keyStates & 4) != 0;
        this.playerMovingRight = (WholeGame.keyStates & 0x20) != 0;
        this.playerMovingUp = (WholeGame.keyStates & 2) != 0;
        this.playerMovingDown = (WholeGame.keyStates & 0x40) != 0;
        this.updatePointer();
        if (this.playerMovingRight && this.playerAngle < 170) {
            this.playerAngle += 2;
        }
        if (this.playerMovingLeft && this.playerAngle > 10) {
            this.playerAngle -= 2;
        }
        if (this.playerPressingAttack && perlType != -1979 && this.perlSpd == 0) {
            this.playerMode = 1;
            this.playerPressingAttack = false;
        }
        if (this.playerPointer > 10) {
            if (this.playerPointerDelay > 0) {
                this.playerPointerDelay -= 30;
            } else {
                this.playerPointerDelay = 3000;
                --this.playerPointer;
            }
        }
        this.updatePerlMovement();
    }

    void drawCircle(Graphics g, int cx, int cy, int size) {
        g.fillArc(cx - size / 2, cy - size / 2, size, size, 0, 360);
    }

    int getMaxPlayerFrames() {
        if (this.playerMode == 1) {
            return 14;
        }
        return 9;
    }

    void releasePerl() {
        if (this.playerAngle >= 175 && this.playerAngle <= 360) {
            return;
        }
        if (this.playerAngle >= 0 && this.playerAngle <= 5) {
            return;
        }
        if (perlType != -1979 && this.perlSpd == 0) {
            this.playerMode = 1;
            this.playerPressingAttack = false;
        }
    }

    int getBasePerlPosY() {
        return this.perlBaseYPx - (Resources.sprPerlsWidth >> 1);
    }

    int getBasePerlPosX() {
        return GameDef._WIDTH >> 1;
    }

    int getRealPerlYPos() {
        int sprW2 = Resources.sprPerlsWidth / 2;
        int ypos = this.perlBaseYPx - Resources.sprPerlsWidth / 2;
        if (this.playerMode == 1) {
            switch (this.playerFrame / 3) {
                case 2: 
                case 4: {
                    --ypos;
                    break;
                }
                case 3: {
                    ypos -= 4;
                }
            }
        }
        return ypos;
    }

    void paintPlayerCharacter(Graphics g) {
        Sprite spr = Resources.sprDolnyBar;
        spr.setFrame(0);
        spr.setPosition(0, GameDef._HEIGHT - Resources.sprDolnyBar.getHeight());
        spr.paint(g);
    }

    void paintTargeting(Graphics g) {
        int sprW2 = Resources.sprPerlsWidth / 2;
        int WminW2 = Defines.WIDTH - sprW2;
        int dspx = Resources.sprPointerWidth / 2;
        Sprite spr = Resources.sprPointer;
        int idx = WholeGame.level.perls.getPerlVal(perlType);
        if (idx < 0 || idx > 6) {
            idx = 8;
        }
        spr.setFrame(idx);
        int py = this.perlBaseYPx;
        for (int i = 0; i < this.playerPointer && py > 0; ++i) {
            int px = this.perlBaseXPx - (Common.COS(this.playerAngle) * ((i + 1) * 12) >> 8);
            py = this.perlBaseYPx - (Common.SIN(this.playerAngle) * ((i + 1) * 12) >> 8);
            if (px < this.iTargetLeft) {
                px = this.iTargetLeft - (px - this.iTargetLeft);
            }
            if (px > this.iTargetRight) {
                px = this.iTargetRight - (px - this.iTargetRight);
            }
            if (px < this.iTargetLeft) {
                px = this.iTargetLeft - (px - this.iTargetLeft);
            }
            if (px > this.iTargetRight) {
                px = this.iTargetRight - (px - this.iTargetRight);
            }
            if (px < this.iTargetLeft) {
                py = -100;
            }
            spr.setPosition(px - dspx, py - dspx);
            spr.paint(g);
        }
    }

    void paintPerl(Graphics g) {
        if (this.playerMode == 1) {
            ++this.shootCounter;
            this.playerMode = 0;
            this.perlYPx = this.perlBaseYPx;
            this.perlY = this.perlYPx << 4;
            this.perlSpd = 2;
            this.perlAngle = this.playerAngle;
            this.perlSpdX = -(2 * Common.COS(this.perlAngle) / 5);
            this.perlSpdY = -(2 * Common.SIN(this.perlAngle) / 5);
        }
        this.playerFrame = 0;
        if (perlType != -1979) {
            int sprW2 = Resources.sprPerlsWidth / 2;
            int ypos = this.perlYPx - sprW2;
            if (this.playerMode == 1) {
                ypos = this.perlBaseYPx - Resources.sprPerlsWidth / 2;
            }
            int v = WholeGame.level.perls.getPerlVal(perlType);
            boolean bPointer = perlType >= 600 && perlType < 700;
            boolean bBomb = perlType >= 700 && perlType < 800;
            boolean bStop = perlType >= 800 && perlType < 900;
            Sprite spr = Resources.sprPerls;
            int xTerc = this.perlXPx - sprW2 + 1;
            int yTerc = ypos;
            if (v == 901) {
                WholeGame.level.perls.paintInk(g, this.perlXPx - sprW2 - 1, ypos);
                return;
            }
            if (v == 16) {
                WholeGame.level.perls.paintEmpty(g, this.perlXPx - sprW2 - 1, ypos);
                return;
            }
            if (v == 902) {
                WholeGame.level.perls.paintElectric(g, this.perlXPx - sprW2 - 1, ypos);
                return;
            }
            spr.setFrame(v);
            spr.setPosition(this.perlXPx - sprW2, ypos);
            spr.paint(g);
            if (bPointer) {
                Sprite sprP = Resources.sprPtr;
                sprP.setPosition(xTerc, yTerc);
                sprP.setFrame(0);
                sprP.paint(g);
            }
            if (bBomb) {
                spr.setPosition(xTerc, yTerc);
                spr.setFrame(14);
                spr.paint(g);
            }
            if (bStop) {
                spr.setFrame(12);
                spr.paint(g);
            }
            if (perlType == 15) {
                Sprite sprClean = Resources.sprClean;
                sprClean.setFrame(0);
                sprClean.setPosition(this.perlXPx - sprW2 - 1, ypos);
                sprClean.paint(g);
                WholeGame.particles.createBubbles(this.perlXPx - Resources.sprPerlsWidth / 2, this.perlYPx);
            }
        }
    }

    void paint(Graphics g) {
        this.paintTargeting(g);
        this.paintPlayerCharacter(g);
    }
}

