/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStore;

public class SolarSystemCanvas320
extends GameCanvas {
    private int[] scoreArray = new int[]{5, 7, 10, 15};
    private boolean paused = false;
    private boolean levelCompleted = false;
    private int currentLevel = 1;
    private int made;
    private int score;
    private boolean vibrations = true;
    private boolean confirmNewGameStart;
    private boolean confirmDifficultyChange;
    private int LEVEL_TIME;
    private int levelFinishTime;
    public long pausedTime;
    private int gameState;
    private int lastGameState;
    public static final int SHIFTING_SPEED = 5;
    public static final int PLATE_FRAME = 40;
    public static final int STONE_FRAME = 44;
    public static final int SELECTOR_FRAME = 42;
    public static final int PLAYER_FRAME = 41;
    private int types_OF_CELLS = 3;
    public static final int MAIN_MENU = 0;
    public static final int PAUSE_MENU = 1;
    public static final int START_MENU = 2;
    public static final int OPTIONS_MENU = 3;
    public static final int SOUNDS_MENU = 4;
    public static final int VIBRATION_MENU = 5;
    public static final int GAMEMODE_MENU = 6;
    public static final int CONFIRMATION_MENU = 7;
    public static final int EASY = 1;
    public static final int NORMAL = 0;
    public static final int HARD = -1;
    private int difficulty;
    private int soundVolume = 66;
    public int menuType;
    public static final int SPLASH_STATE = 0;
    public static final int MAINMENU_STATE = 1;
    public static final int HIGHSCORES_STATE = 2;
    public static final int NEWGAME_STATE = 3;
    public static final int CONTINUE_STATE = 4;
    public static final int UI_STATE = 5;
    public static final int ABOUT_STATE = 6;
    public static final int HELP_STATE = 7;
    public static final int LEVELSTATS_STATE = 8;
    public static final int NEXT_LEVEL_STATE = 9;
    public static final int GAME_OVER_STATE = 10;
    public static final int OPENING_CURTAIN_STATE = 11;
    public static final int CLOSING_CURTAIN_STATE = 12;
    public static final int SHIFTING_STATE = 13;
    public static final int TRAVERSING_STATE = 14;
    public static final int FILLING_STATE = 15;
    public static final int PLAYING_STATE = 16;
    private static final int WIDTH = 6;
    private SolarSystem320 midlet;
    public int menuIndex;
    private String[] menuItems;
    private String[] mmenuItems = new String[]{" START", " OPTIONS", " HIGHSCORES", " HELP", " EXIT"};
    private String[] ppmenuItems = new String[]{" NEW GAME", " CONTINUE", " BACK"};
    private String[] omenuItems = new String[]{" SOUNDS", " VIBRATIONS", " DIFFICULTY", " BACK"};
    private String[] soundsItems = new String[]{" OFF", " LOW", " MEDIUM", " HIGH", " BACK"};
    private String[] vibrationItems = new String[]{" ON", " OFF", " BACK"};
    private String[] confirmationItems = new String[]{" NO", " YES"};
    private String[] gameModeItems = new String[]{" EASY", " NORMAL", " HARD", " BACK"};
    private String[] pauseMenuItems = new String[]{" RESUME", " SOUNDS", " VIBRATIONS", " MAIN MENU"};
    private TiledLayer layer;
    private Sprite backLayer;
    private Sprite player;
    private Sprite selector;
    private Sprite fontSprite;
    private Sprite translucentSprite;
    private Sprite header;
    private Sprite messageSprite;
    private Sprite[][] scarabs;
    private int offsetX;
    private int offsetY;
    private int moveVal;
    private int k;
    private int cellIndex;
    private static final int FRAMEWIDTH = 35;
    private static final int FRAMEHEIGHT = 35;
    private static final int FONTSIZE = 20;
    private int screenWidth = 240;
    private int screenHeight = 300;
    private int currentColumn;
    private int currentRow;
    private int empityColumn;
    private int empityRow;
    private int breakingIndex = -1;
    private boolean breakingColumnFlag;
    private int[] shiftingCells = new int[]{-1, -1, -1, -1, -1, -1};
    private int[][] shiftingBlock = new int[][]{{-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}};
    private int[] playerFrameSequence = new int[]{14, 19, 24, 29, 29, 24, 19, 14};
    private Graphics g;
    private boolean playing;
    private Random random;
    private Font SMALLFONT;
    private Font SMALLULINEFONT;
    private Font BIGFONT;
    private RecordStore rs;
    private final int RECORD_SIZE;
    private byte[] rec = new byte[11];
    private static int MAX_LENGTH = 6;
    private boolean takeInput;
    private char[] uName = new char[]{' ', ' ', ' ', ' ', ' ', ' '};
    private int changeSelection;
    private int nameIndex;
    private int repeatIndex;
    private int lastKey = -1;
    private long keyDelay;
    private static long WAIT_TIME = 2000L;
    public static final int BACKGROUNDSOUND = 0;
    public static final int ARRANGEDSOUND = 1;
    public static final int ERRORSOUND = 2;
    public static final int ALARMSOUND = 3;
    private Player[] musicPlayer;
    public static final int UP_PRESSED = 2;
    public static final int DOWN_PRESSED = 64;
    public static final int LEFT_PRESSED = 4;
    public static final int RIGHT_PRESSED = 32;
    public static final int FIRE_PRESSED = 256;
    public static final int GAME_A_PRESSED = 512;
    public static final int GAME_B_PRESSED = 1024;
    public static final int GAME_C_PRESSED = 2048;
    public static final int GAME_D_PRESSED = 4096;
    private int m_keyStates;

    public SolarSystemCanvas320(SolarSystem320 midlet) {
        super(false);
        this.RECORD_SIZE = 11;
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.g = this.getGraphics();
        this.g.setColor(0);
        this.g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        this.random = new Random();
        this.SMALLFONT = Font.getFont((int)0, (int)1, (int)8);
        this.SMALLULINEFONT = Font.getFont((int)0, (int)5, (int)8);
        this.BIGFONT = Font.getFont((int)0, (int)1, (int)16);
        this.g.setFont(this.SMALLFONT);
        this.offsetX = (this.screenWidth - 210) / 2;
        this.offsetY = (this.screenHeight - 210) / 2;
        this.offsetY += 30;
        try {
            this.player = new Sprite(Image.createImage((String)"/img.png"), 35, 35);
            this.fontSprite = new Sprite(Image.createImage((String)"/font.png"), 20, 20);
            this.translucentSprite = new Sprite(Image.createImage((String)"/block.png"), 20, 20);
            this.selector = new Sprite(Image.createImage((String)"/img.png"), 35, 35);
            this.backLayer = new Sprite(Image.createImage((String)"/splash.png"), this.screenWidth, this.screenHeight);
            this.header = new Sprite(Image.createImage((String)"/tt.png"), 160, 60);
            this.header.defineReferencePixel(this.header.getWidth() / 2, this.header.getHeight());
            this.header.setRefPixelPosition(this.screenWidth / 2, this.screenHeight / 2);
            this.messageSprite = new Sprite(Image.createImage((String)"/msg.png"), 180, 20);
            this.messageSprite.defineReferencePixel(this.messageSprite.getWidth() / 2, this.messageSprite.getHeight() / 2);
            this.messageSprite.setRefPixelPosition(this.screenWidth / 2, 0);
        }
        catch (IOException ex) {
            System.out.println("cant find art assets" + ex);
            ex.printStackTrace();
        }
        this.readRMS();
        this.fillHighScoresData();
        this.initMedia();
    }

    protected void start() {
        this.playing = true;
        Timer timer = new Timer();
        timer.schedule((TimerTask)new GameLoop(), 30L, 30L);
    }

    public void input() {
        int states = this.changeSelection;
        if ((states & 0x100) != 0 && this.layer.getCell(this.currentColumn, this.currentRow) != 5 && this.layer.getCell(this.currentColumn, this.currentRow) != 0) {
            if (this.findEmpityCell()) {
                this.layer.setCell(this.currentColumn, this.currentRow, 0);
                this.gameState = 13;
            } else if (this.soundVolume > 0) {
                try {
                    this.musicPlayer[2].start();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            }
        } else if ((states & 2) != 0) {
            this.currentRow = this.currentRow == 0 ? 5 : --this.currentRow;
        } else if ((states & 0x40) != 0) {
            this.currentRow = this.currentRow == 5 ? 0 : ++this.currentRow;
        } else if ((states & 4) != 0) {
            this.currentColumn = this.currentColumn == 0 ? 5 : --this.currentColumn;
        } else if ((states & 0x20) != 0) {
            this.currentColumn = this.currentColumn == 5 ? 0 : ++this.currentColumn;
        }
        this.changeSelection = 0;
    }

    public boolean findEmpityCell() {
        int i;
        for (i = 0; i < 6; ++i) {
            if (this.layer.getCell(i, this.currentRow) != 0) continue;
            this.empityColumn = i;
            this.empityRow = this.currentRow;
            if (this.empityColumn < this.currentColumn) {
                int j;
                for (j = this.empityColumn + 1; j <= this.currentColumn; ++j) {
                    if (this.layer.getCell(j, this.currentRow) != 44) continue;
                    return false;
                }
                for (j = this.empityColumn + 1; j <= this.currentColumn; ++j) {
                    this.shiftingCells[j] = this.layer.getCell(j, this.currentRow) - 1;
                    this.layer.setCell(j, this.currentRow, 0);
                }
            } else {
                int j;
                for (j = this.empityColumn - 1; j >= this.currentColumn; --j) {
                    if (this.layer.getCell(j, this.currentRow) != 44) continue;
                    return false;
                }
                for (j = this.empityColumn - 1; j >= this.currentColumn; --j) {
                    this.shiftingCells[j] = this.layer.getCell(j, this.currentRow) - 1;
                    this.layer.setCell(j, this.currentRow, 0);
                }
            }
            return true;
        }
        for (i = 0; i < 6; ++i) {
            if (this.layer.getCell(this.currentColumn, i) != 0) continue;
            this.empityColumn = this.currentColumn;
            this.empityRow = i;
            if (this.empityRow < this.currentRow) {
                int j;
                for (j = this.empityRow + 1; j <= this.currentRow; ++j) {
                    if (this.layer.getCell(this.currentColumn, j) != 44) continue;
                    return false;
                }
                for (j = this.empityRow + 1; j <= this.currentRow; ++j) {
                    this.shiftingCells[j] = this.layer.getCell(this.currentColumn, j) - 1;
                    this.layer.setCell(this.currentColumn, j, 0);
                }
            } else {
                int j;
                for (j = this.empityRow - 1; j >= this.currentRow; --j) {
                    if (this.layer.getCell(this.currentColumn, j) != 44) continue;
                    return false;
                }
                for (j = this.empityRow - 1; j >= this.currentRow; --j) {
                    this.shiftingCells[j] = this.layer.getCell(this.currentColumn, j) - 1;
                    this.layer.setCell(this.currentColumn, j, 0);
                }
            }
            return true;
        }
        return false;
    }

    public void shiftCells() {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (this.currentColumn >= this.empityColumn) break block4;
                        for (int j = this.empityColumn - 1; j >= this.currentColumn; --j) {
                            this.layer.setCell(j + 1, this.currentRow, this.shiftingCells[j] + 1);
                        }
                        break block5;
                    }
                    if (this.currentColumn <= this.empityColumn) break block6;
                    for (int j = this.empityColumn + 1; j <= this.currentColumn; ++j) {
                        this.layer.setCell(j - 1, this.currentRow, this.shiftingCells[j] + 1);
                    }
                    break block5;
                }
                if (this.currentRow >= this.empityRow) break block7;
                for (int j = this.empityRow - 1; j >= this.currentRow; --j) {
                    this.layer.setCell(this.currentColumn, j + 1, this.shiftingCells[j] + 1);
                }
                break block5;
            }
            if (this.currentRow <= this.empityRow) break block5;
            for (int j = this.empityRow + 1; j <= this.currentRow; ++j) {
                this.layer.setCell(this.currentColumn, j - 1, this.shiftingCells[j] + 1);
            }
        }
    }

    public boolean check() {
        int i;
        for (i = 0; i < 6; ++i) {
            if (this.layer.getCell(i, 0) != this.layer.getCell(i, 1) || this.layer.getCell(i, 0) != this.layer.getCell(i, 2) || this.layer.getCell(i, 0) != this.layer.getCell(i, 3) || this.layer.getCell(i, 0) != this.layer.getCell(i, 4) || this.layer.getCell(i, 0) != this.layer.getCell(i, 5)) continue;
            this.breakingColumnFlag = true;
            this.breakingIndex = i;
            this.cellIndex = this.layer.getCell(i, 0);
            if (this.vibrations) {
                this.midlet.vibra(1000);
            }
            if (this.soundVolume > 0) {
                try {
                    this.musicPlayer[1].start();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            }
            return true;
        }
        for (i = 0; i < 6; ++i) {
            if (this.layer.getCell(0, i) != this.layer.getCell(1, i) || this.layer.getCell(0, i) != this.layer.getCell(2, i) || this.layer.getCell(0, i) != this.layer.getCell(3, i) || this.layer.getCell(0, i) != this.layer.getCell(4, i) || this.layer.getCell(0, i) != this.layer.getCell(5, i)) continue;
            this.breakingColumnFlag = false;
            this.breakingIndex = i;
            this.cellIndex = this.layer.getCell(0, i);
            if (this.vibrations) {
                this.midlet.vibra(1000);
            }
            if (this.soundVolume > 0) {
                try {
                    this.musicPlayer[1].start();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            }
            return true;
        }
        this.breakingIndex = -1;
        return false;
    }

    public void createBoard() {
        int j;
        int i;
        int temp = 0;
        if (this.layer == null) {
            try {
                Image image = Image.createImage((String)"/img.png");
                this.layer = new TiledLayer(6, 6, image, 35, 35);
                this.layer.setPosition(this.offsetX, this.offsetY);
                this.scarabs = new Sprite[6][6];
                for (i = 5; i >= 0; --i) {
                    for (j = 5; j >= 0; --j) {
                        this.scarabs[i][j] = new Sprite(image, 35, 35);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.currentLevel > 6) {
            this.types_OF_CELLS = 4;
        }
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                this.layer.setCell(i, j, Math.abs(this.random.nextInt() % this.types_OF_CELLS) + 1);
            }
        }
        this.empityColumn = 0;
        this.empityRow = 0;
        this.layer.setCell(0, 0, 0);
        if (this.currentLevel >= 4 && this.currentLevel <= 6) {
            for (int k = 3; k < this.currentLevel; ++k) {
                i = Math.abs(this.random.nextInt() % 5);
                if (this.layer.getCell(i, j = Math.abs(this.random.nextInt() % 5)) == 0) {
                    this.layer.setCell(i + 1, j + 1, 44);
                    continue;
                }
                this.layer.setCell(i, j, 44);
            }
        } else if (this.currentLevel >= 10 && this.currentLevel <= 12) {
            for (int k = 9; k < this.currentLevel; ++k) {
                i = Math.abs(this.random.nextInt() % 5);
                if (this.layer.getCell(i, j = Math.abs(this.random.nextInt() % 5)) == 0) {
                    this.layer.setCell(i + 1, j + 1, 44);
                    continue;
                }
                this.layer.setCell(i, j, 44);
            }
        } else if (this.currentLevel > 12 && this.currentLevel <= 25) {
            for (int k = 0; k < 3; ++k) {
                i = Math.abs(this.random.nextInt() % 5);
                if (this.layer.getCell(i, j = Math.abs(this.random.nextInt() % 5)) == 0) {
                    this.layer.setCell(i + 1, j + 1, 44);
                    continue;
                }
                this.layer.setCell(i, j, 44);
            }
        } else if (this.currentLevel > 25) {
            for (int k = 0; k < 4; ++k) {
                i = Math.abs(this.random.nextInt() % 5);
                if (this.layer.getCell(i, j = Math.abs(this.random.nextInt() % 5)) == 0) {
                    this.layer.setCell(i + 1, j + 1, 44);
                    continue;
                }
                this.layer.setCell(i, j, 44);
            }
        }
        if (this.layer.getCell(1, 0) == 44 && this.layer.getCell(0, 1) == 44) {
            if (this.layer.getCell(4, 5) == 44 && this.layer.getCell(5, 4) == 44) {
                this.layer.setCell(0, 0, this.layer.getCell(5, 5));
                this.layer.setCell(5, 5, 0);
                this.empityColumn = 5;
                this.empityRow = 5;
            } else {
                this.layer.setCell(0, 0, this.layer.getCell(0, 5));
                this.layer.setCell(0, 5, 0);
                this.empityColumn = 0;
                this.empityRow = 5;
            }
        }
        this.checkBoard();
        for (i = 5; i >= 0; --i) {
            for (j = 5; j >= 0; --j) {
                try {
                    this.scarabs[i][j].setFrame(40);
                    this.scarabs[i][j].setPosition(Math.abs(this.random.nextInt() % this.screenWidth), Math.abs(this.random.nextInt() % this.screenHeight));
                    this.scarabs[i][j].setVisible(true);
                    temp = this.layer.getCell(i, j);
                    if (temp <= 0 || temp > 28) continue;
                    this.layer.setCell(i, j, temp + 24);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("big trouble temp : " + temp);
                }
            }
        }
    }

    public void checkBoard() {
        int j;
        int i;
        for (i = 0; i < 6; ++i) {
            j = this.layer.getCell(i, 0);
            if (j != this.layer.getCell(i, 1) || j != this.layer.getCell(i, 2) || j != this.layer.getCell(i, 3) || j != this.layer.getCell(i, 4) || j != this.layer.getCell(i, 5)) continue;
            if (i == 5) {
                if (j == this.layer.getCell(4, 0)) {
                    this.layer.setCell(5, 0, j == 1 ? 2 : 1);
                    continue;
                }
                this.layer.setCell(5, 0, this.layer.getCell(4, 0));
                this.layer.setCell(4, 0, j);
                continue;
            }
            if (j == this.layer.getCell(i + 1, 0)) {
                this.layer.setCell(i, 0, j == 1 ? 2 : 1);
                continue;
            }
            this.layer.setCell(i, 0, this.layer.getCell(i + 1, 0));
            this.layer.setCell(i + 1, 0, j);
        }
        for (i = 0; i < 6; ++i) {
            j = this.layer.getCell(0, i);
            if (this.layer.getCell(0, i) == this.layer.getCell(1, i) && this.layer.getCell(0, i) == this.layer.getCell(2, i) && this.layer.getCell(0, i) == this.layer.getCell(3, i) && this.layer.getCell(0, i) == this.layer.getCell(4, i) && this.layer.getCell(0, i) == this.layer.getCell(5, i)) {
                if (i == 5) {
                    if (j == this.layer.getCell(0, 4)) {
                        this.layer.setCell(0, 5, j == 1 ? 2 : 1);
                    } else {
                        this.layer.setCell(0, 5, this.layer.getCell(0, 4));
                        this.layer.setCell(0, 4, j);
                    }
                } else if (j == this.layer.getCell(0, i + 1)) {
                    this.layer.setCell(0, i, j == 1 ? 2 : 1);
                } else {
                    this.layer.setCell(0, i, this.layer.getCell(i + 1, 0));
                    this.layer.setCell(0, i + 1, j);
                }
            }
            if (this.check()) {
                this.createBoard();
                continue;
            }
            if (this.layer.getCell(1, 0) != 5 || this.layer.getCell(0, 1) != 5) continue;
            this.layer.setCell(0, 0, 1);
            this.layer.setCell(5, 5, 0);
        }
    }

    public void animateMainMenu() {
        int xx;
        this.selector.setFrame(42);
        this.selector.setTransform(2);
        this.player.setFrame(42);
        if (this.changeSelection == -5) {
            this.changeSelection = 0;
            block2 : switch (this.menuType) {
                case 7: {
                    switch (this.menuIndex) {
                        case 0: {
                            if (this.confirmDifficultyChange) {
                                this.menuIndex = 0;
                                this.menuItems = this.omenuItems;
                                this.menuType = 3;
                                this.confirmDifficultyChange = false;
                                break block2;
                            }
                            if (this.confirmNewGameStart) {
                                this.menuIndex = 0;
                                this.menuItems = this.ppmenuItems;
                                this.menuType = 2;
                                this.confirmNewGameStart = false;
                                break block2;
                            }
                            if (this.paused) {
                                this.menuIndex = 0;
                                this.menuItems = this.pauseMenuItems;
                                this.menuType = 1;
                                break block2;
                            }
                            this.menuIndex = 0;
                            this.menuItems = this.mmenuItems;
                            this.menuType = 0;
                            break block2;
                        }
                        case 1: {
                            if (this.confirmDifficultyChange) {
                                this.confirmDifficultyChange = false;
                                this.menuIndex = this.difficulty == 1 ? 0 : (this.difficulty == 0 ? 1 : 2);
                                this.menuItems = this.gameModeItems;
                                this.menuType = 6;
                                this.ppmenuItems[1] = "*CONTINUE";
                                this.currentLevel = 0;
                                this.writeRMS(true);
                                break block2;
                            }
                            if (this.confirmNewGameStart) {
                                this.ppmenuItems[1] = "*CONTINUE";
                                this.gameState = 3;
                                this.confirmNewGameStart = false;
                                break block2;
                            }
                            if (this.paused) {
                                this.ppmenuItems[1] = " CONTINUE";
                                this.paused = false;
                                this.menuItems = this.mmenuItems;
                                this.menuType = 0;
                                break block2;
                            }
                            this.playing = false;
                            try {
                                this.musicPlayer[3].stop();
                                this.musicPlayer[0].stop();
                            }
                            catch (MediaException ex) {
                                ex.printStackTrace();
                            }
                            this.midlet.destroyApp(true);
                            this.midlet.notifyDestroyed();
                            break block2;
                        }
                    }
                    System.out.println("impossible option from confirmation state");
                    break;
                }
                case 0: {
                    this.paused = false;
                    switch (this.menuIndex) {
                        case 0: {
                            this.menuItems = this.ppmenuItems;
                            this.menuType = 2;
                            break block2;
                        }
                        case 1: {
                            this.menuItems = this.omenuItems;
                            this.menuType = 3;
                            break block2;
                        }
                        case 2: {
                            this.header.setRefPixelPosition(this.screenWidth / 2, this.screenHeight / 2);
                            this.header.setFrame(1);
                            this.messageSprite.setRefPixelPosition(this.screenWidth / 2, 0);
                            this.messageSprite.setFrame(0);
                            this.gameState = 2;
                            break block2;
                        }
                        case 3: {
                            if (this.layer == null) {
                                this.createBoard();
                            }
                            this.layer.fillCells(0, 0, 6, 6, 0);
                            this.layer.fillCells(0, 1, 6, 3, 41);
                            this.header.setRefPixelPosition(this.screenWidth + this.screenWidth / 2, 100);
                            this.gameState = 7;
                            break block2;
                        }
                    }
                    this.menuIndex = 0;
                    this.menuItems = this.confirmationItems;
                    this.menuType = 7;
                    this.messageSprite.setRefPixelPosition(this.screenWidth / 2, 0);
                    break;
                }
                case 2: {
                    switch (this.menuIndex) {
                        case 0: {
                            if (this.ppmenuItems[1].charAt(0) == '*') {
                                this.gameState = 3;
                                break block2;
                            }
                            this.confirmNewGameStart = true;
                            this.menuIndex = 0;
                            this.menuItems = this.confirmationItems;
                            this.menuType = 7;
                            this.messageSprite.setRefPixelPosition(this.screenWidth / 2, 0);
                            break block2;
                        }
                        case 1: {
                            this.gameState = 4;
                            break block2;
                        }
                    }
                    this.menuItems = this.mmenuItems;
                    this.menuType = 0;
                    break;
                }
                case 3: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.menuIndex = this.soundVolume / 33;
                            this.menuItems = this.soundsItems;
                            this.menuType = 4;
                            break;
                        }
                        case 1: {
                            this.menuIndex = this.vibrations ? 0 : 1;
                            this.menuItems = this.vibrationItems;
                            this.menuType = 5;
                            break;
                        }
                        case 2: {
                            if (this.ppmenuItems[1].charAt(0) == '*') {
                                this.menuIndex = this.difficulty == 1 ? 0 : (this.difficulty == 0 ? 1 : 2);
                                this.menuItems = this.gameModeItems;
                                this.menuType = 6;
                                break;
                            }
                            this.confirmDifficultyChange = true;
                            this.menuIndex = 0;
                            this.menuItems = this.confirmationItems;
                            this.menuType = 7;
                            this.messageSprite.setRefPixelPosition(this.screenWidth / 2, 0);
                            break;
                        }
                        case 3: {
                            if (this.paused) {
                                this.menuItems = this.pauseMenuItems;
                                this.menuType = 1;
                                break;
                            }
                            this.menuItems = this.mmenuItems;
                            this.menuType = 0;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.difficulty = 1;
                            this.currentLevel = 0;
                            this.writeRMS(true);
                            break;
                        }
                        case 1: {
                            this.difficulty = 0;
                            this.currentLevel = 0;
                            this.writeRMS(true);
                            break;
                        }
                        case 2: {
                            this.difficulty = -1;
                            this.currentLevel = 0;
                            this.writeRMS(true);
                        }
                    }
                    this.menuItems = this.omenuItems;
                    this.menuType = 3;
                    break;
                }
                case 4: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.soundVolume = 0;
                            this.writeRMS(false);
                            this.initMedia();
                            break;
                        }
                        case 1: {
                            this.soundVolume = 33;
                            this.writeRMS(false);
                            this.initMedia();
                            break;
                        }
                        case 2: {
                            this.soundVolume = 66;
                            this.writeRMS(false);
                            this.initMedia();
                            break;
                        }
                        case 3: {
                            this.soundVolume = 100;
                            this.writeRMS(false);
                            this.initMedia();
                        }
                    }
                    if (this.paused) {
                        this.menuItems = this.pauseMenuItems;
                        this.menuType = 1;
                        break;
                    }
                    this.menuItems = this.omenuItems;
                    this.menuType = 3;
                    break;
                }
                case 5: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.vibrations = true;
                            this.midlet.vibra(1000);
                            this.writeRMS(false);
                            break;
                        }
                        case 1: {
                            this.vibrations = false;
                            this.writeRMS(false);
                            break;
                        }
                    }
                    if (this.paused) {
                        this.menuItems = this.pauseMenuItems;
                        this.menuType = 1;
                        break;
                    }
                    this.menuItems = this.omenuItems;
                    this.menuType = 3;
                    break;
                }
                case 1: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.paused = false;
                            this.player.setFrame(41);
                            this.gameState = this.lastGameState;
                            if (this.gameState >= 13) {
                                this.levelFinishTime = (int)((long)this.levelFinishTime + (System.currentTimeMillis() - this.pausedTime) / 1000L);
                                if (this.gameState == 12 && this.soundVolume > 0) {
                                    try {
                                        this.musicPlayer[0].start();
                                    }
                                    catch (MediaException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            }
                            this.changeSelection = 0;
                            break block2;
                        }
                        case 3: {
                            this.menuIndex = 0;
                            this.menuItems = this.confirmationItems;
                            this.menuType = 7;
                            break block2;
                        }
                        case 1: {
                            this.menuIndex = this.soundVolume / 33;
                            this.menuItems = this.soundsItems;
                            this.menuType = 4;
                            break block2;
                        }
                        case 2: {
                            this.menuIndex = this.vibrations ? 0 : 1;
                            this.menuItems = this.vibrationItems;
                            this.menuType = 5;
                        }
                    }
                }
            }
            if (this.menuType != 6 && this.menuType != 4 && this.menuType != 5) {
                this.menuIndex = 0;
            }
        }
        do {
            this.menuIndex += this.changeSelection;
            if (this.menuIndex == -1) {
                this.menuIndex = this.menuItems.length - 1;
                continue;
            }
            if (this.menuIndex != this.menuItems.length) continue;
            this.menuIndex = 0;
        } while (this.menuItems[this.menuIndex].charAt(0) == '*');
        for (int i = 0; i < this.menuItems.length; ++i) {
            this.displayString(this.menuItems[i], this.screenWidth / 2 - this.menuItems[i].length() * 20 / 2 - 10, 35 * i + this.offsetY + 40, i == this.menuIndex, this.menuItems[i].charAt(0) == '*');
        }
        this.changeSelection = 0;
        int x = this.player.getX();
        if (x < (xx = this.screenWidth / 2 - this.menuItems[this.menuIndex].length() * 20 / 2 - 10 + 4)) {
            x += (xx - x) / 3 + 1;
        } else if (x > xx) {
            x -= (x - xx) / 3 + 1;
        }
        int y = this.player.getY();
        int yy = this.offsetY + this.menuIndex * 35 + 40 - 4 - 2;
        if (y < yy) {
            y += (yy - y) / 3 + 1;
        } else if (y > yy) {
            y -= (y - yy) / 3 + 1;
        }
        this.player.setPosition(x, y);
        this.player.paint(this.g);
        x = this.selector.getX();
        xx = this.screenWidth / 2 + (this.menuItems[this.menuIndex].length() * 20 / 2 - 20) - 10;
        if (x < xx) {
            x += (xx - x) / 3 + 1;
        } else if (x > xx) {
            x -= (x - xx) / 3 + 1;
        }
        y = this.selector.getY();
        if (y < yy) {
            y += (yy - y) / 3 + 1;
        } else if (y > yy) {
            y -= (y - yy) / 3 + 1;
        }
        this.selector.setPosition(x, y);
        this.selector.paint(this.g);
    }

    private void displayString(String str, int x, int y, boolean inFocus, boolean inActive) {
        char ch = '\u0000';
        for (int j = 0; j < str.length(); ++j) {
            ch = str.charAt(j);
            if (ch >= 'A' && ch <= '\\') {
                if (inFocus) {
                    this.fontSprite.setFrame(38);
                } else if (inActive) {
                    this.fontSprite.setFrame(36);
                } else {
                    this.fontSprite.setFrame(37);
                }
                this.fontSprite.setPosition(x + j * 20, y);
                this.fontSprite.paint(this.g);
                this.fontSprite.setFrame(ch - 65);
                this.fontSprite.paint(this.g);
            } else if (ch >= '0' && ch <= ';') {
                if (inFocus) {
                    this.fontSprite.setFrame(38);
                } else if (inActive) {
                    this.fontSprite.setFrame(37);
                } else {
                    this.fontSprite.setFrame(36);
                }
                this.fontSprite.setPosition(x + j * 20, y);
                this.fontSprite.paint(this.g);
                this.fontSprite.setFrame(ch - 22);
                this.fontSprite.paint(this.g);
            }
            if (ch != ':') continue;
            if (inFocus) {
                this.fontSprite.setFrame(38);
            } else if (inActive) {
                this.fontSprite.setFrame(36);
            } else {
                this.fontSprite.setFrame(37);
            }
            this.fontSprite.setPosition(x + j * 20, y);
            this.fontSprite.paint(this.g);
            this.fontSprite.setFrame(41);
            this.fontSprite.paint(this.g);
        }
    }

    protected void hideNotify() {
        System.out.println("in hide notify with gameState:" + this.gameState);
        if (this.gameState >= 13) {
            this.writeRMS(true);
        }
        try {
            this.musicPlayer[3].stop();
            this.musicPlayer[0].stop();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        if (this.gameState >= 10) {
            this.menuIndex = 0;
            this.paused = true;
            this.lastGameState = this.gameState;
            this.menuItems = this.pauseMenuItems;
            this.menuType = 1;
            this.gameState = 1;
            this.pausedTime = System.currentTimeMillis();
        }
    }

    protected void showNotify() {
    }

    public void writeRMS(boolean completeGame) {
        if (completeGame) {
            int timeLeft = (int)((long)this.levelFinishTime - System.currentTimeMillis() / 1000L);
            if (timeLeft < 0 && this.currentLevel != 0) {
                timeLeft = (this.currentLevel + 1) * 30;
                timeLeft += this.LEVEL_TIME / 4 * this.difficulty;
            }
            this.rec[0] = (byte)this.currentLevel;
            this.rec[1] = (byte)(this.currentLevel >>> 8);
            this.rec[2] = (byte)this.made;
            this.rec[3] = (byte)(this.made >>> 8);
            this.rec[4] = (byte)this.score;
            this.rec[5] = (byte)(this.score >>> 8);
            this.rec[6] = (byte)(this.score >>> 16);
            this.rec[7] = (byte)timeLeft;
            this.rec[8] = (byte)(timeLeft >>> 8);
            this.rec[9] = (byte)(timeLeft >>> 16);
            System.out.println("writing to persistence storage level: " + this.currentLevel + " made:" + this.made + " score:" + this.score + "timeleft:" + timeLeft);
        }
        this.rec[10] = 0;
        this.rec[10] = (byte)(this.soundVolume / 33);
        if (this.vibrations) {
            this.rec[10] = (byte)(this.rec[10] | 4);
        }
        if (this.difficulty == 1) {
            this.rec[10] = (byte)(this.rec[10] | 8);
        } else if (this.difficulty == -1) {
            this.rec[10] = (byte)(this.rec[10] | 0x10);
        }
        if (this.levelCompleted) {
            this.rec[10] = (byte)(this.rec[10] | 0x20);
        }
        System.out.println("written..." + Integer.toBinaryString(this.rec[10]));
        try {
            this.rs = RecordStore.openRecordStore((String)"scarabsDB", (boolean)true);
            if (this.rs.getNumRecords() > 0) {
                this.rs.setRecord(1, this.rec, 0, 11);
            } else {
                this.rs.addRecord(this.rec, 0, 11);
            }
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant write into rs : " + e);
        }
    }

    public void readRMS() {
        try {
            this.rs = RecordStore.openRecordStore((String)"scarabsDB", (boolean)true);
            this.rec = this.rs.getRecord(1);
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant open recordStore for reading" + e);
            this.ppmenuItems[1] = "*CONTINUE";
            return;
        }
        this.currentLevel = this.rec[1] << 8 & 0xFF00 | this.rec[0] & 0xFF;
        if (this.currentLevel == 0) {
            this.ppmenuItems[1] = "*CONTINUE";
        }
        System.out.println("got..." + Integer.toBinaryString(this.rec[10]));
        System.out.println("applying settings" + (this.rec[10] & 3));
        this.soundVolume = (this.rec[10] & 3) * 33;
        this.vibrations = (this.rec[10] & 4) != 0;
        this.difficulty = 0;
        if ((this.rec[10] & 8) == 8) {
            this.difficulty = 1;
        } else if ((this.rec[10] & 0x10) == 16) {
            this.difficulty = -1;
        }
        System.out.println("reading L:" + this.currentLevel);
    }

    public void deleteRMS1() {
        if (RecordStore.listRecordStores() != null) {
            try {
                RecordStore.deleteRecordStore((String)"scarabsDB");
            }
            catch (Exception e) {
                System.out.println("cant delete the rs :" + e);
            }
        }
    }

    public void fillHighScoresData() {
        try {
            this.rs = RecordStore.openRecordStore((String)"SscoresDB", (boolean)true);
            if (this.rs.getNumRecords() > 0) {
                this.rs.closeRecordStore();
                return;
            }
            byte[] b = new byte[14];
            this.rs.addRecord(b, 0, 14);
            this.rs.addRecord(b, 0, 14);
            this.rs.addRecord(b, 0, 14);
            this.rs.addRecord(b, 0, 14);
            this.rs.addRecord(b, 0, 14);
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant write into rs : " + e);
        }
    }

    public String[] getHighScores(int[] scores) {
        byte[] records = new byte[14];
        String[] names = new String[5];
        try {
            this.rs = RecordStore.openRecordStore((String)"SscoresDB", (boolean)true);
            records = this.rs.getRecord(1);
            names[0] = new String(records, 0, 6);
            scores[0] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            records = this.rs.getRecord(2);
            names[1] = new String(records, 0, 6);
            scores[1] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            records = this.rs.getRecord(3);
            names[2] = new String(records, 0, 6);
            scores[2] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            records = this.rs.getRecord(4);
            names[3] = new String(records, 0, 6);
            scores[3] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            records = this.rs.getRecord(5);
            names[4] = new String(records, 0, 6);
            scores[4] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant open scores recordStore " + e);
            this.mmenuItems[2] = "*HIGHSCORES";
        }
        return names;
    }

    public void updateHighScores() {
        if (this.score <= 0) {
            return;
        }
        int pos = -1;
        int[] highScores = new int[5];
        byte[][] records = new byte[14][5];
        try {
            int i;
            this.rs = RecordStore.openRecordStore((String)"SscoresDB", (boolean)true);
            records[0] = this.rs.getRecord(1);
            highScores[0] = records[0][6] & 0xFF | records[0][7] << 8 & 0xFF00 | records[0][8] << 16 & 0xFF0000;
            records[1] = this.rs.getRecord(2);
            highScores[1] = records[1][6] & 0xFF | records[1][7] << 8 & 0xFF00 | records[1][8] << 16 & 0xFF0000;
            records[2] = this.rs.getRecord(3);
            highScores[2] = records[2][6] & 0xFF | records[2][7] << 8 & 0xFF00 | records[2][8] << 16 & 0xFF0000;
            records[3] = this.rs.getRecord(4);
            highScores[3] = records[3][6] & 0xFF | records[3][7] << 8 & 0xFF00 | records[3][8] << 16 & 0xFF0000;
            records[4] = this.rs.getRecord(5);
            highScores[4] = records[4][6] & 0xFF | records[4][7] << 8 & 0xFF00 | records[4][8] << 16 & 0xFF0000;
            for (i = 4; i >= 0; --i) {
                if (this.score <= highScores[i]) continue;
                pos = i;
            }
            if (pos != -1) {
                i = 4;
                while (i > pos - 1) {
                    System.arraycopy(records[i - 1], 0, records[i], 0, 14);
                    if (--i != 0) continue;
                }
                records[pos][0] = (byte)this.uName[0];
                records[pos][1] = (byte)this.uName[1];
                records[pos][2] = (byte)this.uName[2];
                records[pos][3] = (byte)this.uName[3];
                records[pos][4] = (byte)this.uName[4];
                records[pos][5] = (byte)this.uName[5];
                records[pos][6] = (byte)this.score;
                records[pos][7] = (byte)(this.score >>> 8);
                records[pos][8] = (byte)(this.score >>> 16);
                for (i = pos; i < 5; ++i) {
                    this.rs.setRecord(i + 1, records[i], 0, 14);
                }
                this.mmenuItems[2] = " HIGHSCORES";
            }
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant open scores recordStore for updation" + e);
            this.mmenuItems[2] = "*HIGHSCORES";
        }
    }

    public void keyPressed(int keyCode) {
        this.mykeyPressed(keyCode);
        if (keyCode == -22) {
            keyCode = -7;
        } else if (keyCode == -23) {
            keyCode = -8;
        }
        if (keyCode == -7 && this.gameState >= 10) {
            try {
                this.musicPlayer[3].stop();
                this.musicPlayer[0].stop();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
            if (this.gameState >= 13) {
                this.writeRMS(true);
            }
            this.menuItems = this.pauseMenuItems;
            this.menuType = 1;
            this.menuIndex = 0;
            this.lastGameState = this.gameState;
            this.gameState = 1;
            this.pausedTime = System.currentTimeMillis();
            this.paused = true;
            return;
        }
        if (this.gameState == 1) {
            if (keyCode == -1 || keyCode == 50) {
                this.changeSelection = -1;
            } else if (keyCode == -6 || keyCode == 56) {
                this.changeSelection = 1;
            } else if (keyCode == -20 || keyCode == 53) {
                this.changeSelection = -5;
            }
        } else if (this.gameState == 6 || this.gameState == 7 || this.gameState == 2) {
            if (keyCode == -2 || keyCode == 52) {
                this.changeSelection = -1;
            } else if (keyCode == -5 || keyCode == 54) {
                this.changeSelection = 1;
            } else if (keyCode == -20 || keyCode == 53) {
                this.changeSelection = -5;
            }
        } else if (this.gameState == 16) {
            this.changeSelection = this.getKeyStates();
        }
    }

    public void keyReleased(int keyCode) {
        this.mykeyReleased(keyCode);
        if (this.takeInput) {
            if (keyCode > 49 && keyCode <= 57) {
                if (this.lastKey == keyCode && this.keyDelay > System.currentTimeMillis() && this.nameIndex > 0) {
                    --this.nameIndex;
                    ++this.repeatIndex;
                    this.keyDelay = System.currentTimeMillis() + WAIT_TIME;
                    this.lastKey = keyCode;
                    switch (keyCode) {
                        default: {
                            if (this.repeatIndex < 3) {
                                this.uName[this.nameIndex] = (char)(keyCode + 15 + 2 * (keyCode - 50) + this.repeatIndex);
                                ++this.nameIndex;
                                break;
                            }
                            if (this.repeatIndex == 3) {
                                this.uName[this.nameIndex] = (char)keyCode;
                                ++this.nameIndex;
                                break;
                            }
                            this.repeatIndex = 0;
                            this.uName[this.nameIndex] = (char)(keyCode + 15 + 2 * (keyCode - 50));
                            ++this.nameIndex;
                            break;
                        }
                        case 55: {
                            if (this.repeatIndex < 4) {
                                this.uName[this.nameIndex] = (char)(keyCode + 15 + 2 * (keyCode - 50) + this.repeatIndex);
                                ++this.nameIndex;
                                break;
                            }
                            if (this.repeatIndex == 4) {
                                this.uName[this.nameIndex] = (char)keyCode;
                                ++this.nameIndex;
                                break;
                            }
                            this.repeatIndex = 0;
                            this.uName[this.nameIndex] = (char)(keyCode + 15 + 2 * (keyCode - 50));
                            ++this.nameIndex;
                            break;
                        }
                        case 56: {
                            if (this.repeatIndex < 3) {
                                this.uName[this.nameIndex] = (char)(84 + this.repeatIndex);
                                ++this.nameIndex;
                                break;
                            }
                            if (this.repeatIndex == 3) {
                                this.uName[this.nameIndex] = (char)keyCode;
                                ++this.nameIndex;
                                break;
                            }
                            this.repeatIndex = 0;
                            this.uName[this.nameIndex] = 84;
                            ++this.nameIndex;
                            break;
                        }
                        case 57: {
                            if (this.repeatIndex < 4) {
                                this.uName[this.nameIndex] = (char)(87 + this.repeatIndex);
                                ++this.nameIndex;
                                break;
                            }
                            if (this.repeatIndex == 4) {
                                this.uName[this.nameIndex] = (char)keyCode;
                                ++this.nameIndex;
                                break;
                            }
                            this.repeatIndex = 0;
                            this.uName[this.nameIndex] = 87;
                            ++this.nameIndex;
                            break;
                        }
                    }
                } else if (this.nameIndex < MAX_LENGTH) {
                    this.repeatIndex = 0;
                    this.keyDelay = System.currentTimeMillis() + WAIT_TIME;
                    this.lastKey = keyCode;
                    switch (keyCode) {
                        default: {
                            this.uName[this.nameIndex] = (char)(keyCode + 15 + 2 * (keyCode - 50));
                            ++this.nameIndex;
                            break;
                        }
                        case 49: {
                            this.uName[this.nameIndex] = 45;
                            ++this.nameIndex;
                            break;
                        }
                        case 56: {
                            this.uName[this.nameIndex] = 84;
                            ++this.nameIndex;
                            break;
                        }
                        case 57: {
                            this.uName[this.nameIndex] = 87;
                            ++this.nameIndex;
                            break;
                        }
                    }
                }
            } else if ((keyCode == -23 || keyCode == -21) && this.nameIndex > 0) {
                --this.nameIndex;
                this.uName[this.nameIndex] = 32;
                this.keyDelay = System.currentTimeMillis();
            } else if (keyCode == -6) {
                this.keyDelay = System.currentTimeMillis();
            } else if ((keyCode == -20 || keyCode == -22) && this.nameIndex >= 1) {
                this.takeInput = false;
            }
        }
    }

    public void drawTranslucentRect(int x, int y, int width, int height) {
        int j;
        int i;
        this.translucentSprite.setFrame(0);
        this.translucentSprite.setPosition(x, y);
        this.translucentSprite.paint(this.g);
        this.translucentSprite.setFrame(2);
        this.translucentSprite.setPosition(x + width * 20, y);
        this.translucentSprite.paint(this.g);
        this.translucentSprite.setFrame(6);
        this.translucentSprite.setPosition(x, y + height * 20);
        this.translucentSprite.paint(this.g);
        this.translucentSprite.setFrame(8);
        this.translucentSprite.setPosition(x + width * 20, y + height * 20);
        this.translucentSprite.paint(this.g);
        for (i = width - 1; i > 0; --i) {
            this.translucentSprite.setFrame(1);
            this.translucentSprite.setPosition(x + i * 20, y);
            this.translucentSprite.paint(this.g);
            this.translucentSprite.setFrame(7);
            this.translucentSprite.setPosition(x + i * 20, y + height * 20);
            this.translucentSprite.paint(this.g);
        }
        for (j = height - 1; j > 0; --j) {
            this.translucentSprite.setFrame(3);
            this.translucentSprite.setPosition(x, y + j * 20);
            this.translucentSprite.paint(this.g);
            this.translucentSprite.setFrame(5);
            this.translucentSprite.setPosition(x + width * 20, y + j * 20);
            this.translucentSprite.paint(this.g);
        }
        this.translucentSprite.setFrame(4);
        for (i = width - 1; i > 0; --i) {
            for (j = height - 1; j > 0; --j) {
                this.translucentSprite.setPosition(x + i * 20, y + j * 20);
                this.translucentSprite.paint(this.g);
            }
        }
    }

    private void initMedia() {
        System.out.println("In initMedia ...");
        if (this.musicPlayer == null) {
            String[] musicFiles = new String[]{"/tts.mid", "/scr.mid", "/err.mid", "/wrn.mid"};
            String xtension = "mid";
            this.musicPlayer = new Player[6];
            for (int i = 0; i < this.musicPlayer.length; ++i) {
                try {
                    InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(musicFiles[i]);
                    this.musicPlayer[i] = musicFiles[i].endsWith(xtension) ? Manager.createPlayer((InputStream)is, (String)"audio/midi") : Manager.createPlayer((InputStream)is, (String)"audio/X-wav");
                    this.musicPlayer[i].realize();
                    continue;
                }
                catch (Exception e) {
                    System.out.println(" " + e.getMessage());
                }
            }
            this.musicPlayer[0].setLoopCount(-1);
        }
        if (this.soundVolume > 0) {
            VolumeControl vc = (VolumeControl)this.musicPlayer[0].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)this.musicPlayer[0].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)this.musicPlayer[1].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)this.musicPlayer[2].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)this.musicPlayer[3].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
        } else {
            try {
                this.musicPlayer[0].stop();
                this.musicPlayer[1].stop();
                this.musicPlayer[2].stop();
                this.musicPlayer[3].stop();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void mykeyPressed(int keyCode) {
        this.m_keyStates |= 1 << this.getGameAction(keyCode);
    }

    protected void mykeyReleased(int keyCode) {
        this.m_keyStates &= ~(1 << this.getGameAction(keyCode));
    }

    public int getKeyStates() {
        return this.m_keyStates;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
    }

    static /* synthetic */ String[] access$2502(SolarSystemCanvas320 x0, String[] x1) {
        x0.menuItems = x1;
        return x1;
    }

    class GameLoop
    extends TimerTask {
        String[] names = null;
        int[] scores = new int[5];
        Sprite gameOverSprite1 = null;
        Sprite gameOverSprite2 = null;
        Image titleImage = null;
        Image lose = null;
        private int traverseIndex;
        private int temp = 20;
        private int timeBonus;
        private int movieStep;

        public GameLoop() {
            try {
                this.titleImage = Image.createImage((String)"/lg.png");
                this.lose = Image.createImage((String)"/b.png");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            SolarSystemCanvas320.this.getHighScores(this.scores);
            if (this.scores[0] <= 0 && this.scores[1] <= 0 && this.scores[2] <= 0 && this.scores[3] <= 0 && this.scores[4] <= 0) {
                ((SolarSystemCanvas320)SolarSystemCanvas320.this).mmenuItems[2] = "*HIGHSCORES";
            }
        }

        public void run() {
            if (!SolarSystemCanvas320.this.isShown()) {
                return;
            }
            if (SolarSystemCanvas320.this.playing) {
                switch (SolarSystemCanvas320.this.gameState) {
                    case 7: {
                        int j;
                        int x = SolarSystemCanvas320.this.header.getRefPixelX();
                        int xx = SolarSystemCanvas320.this.screenWidth / 2 - this.temp * SolarSystemCanvas320.this.screenWidth;
                        if (x < xx) {
                            x += (xx - x) / 5 + 1;
                        } else if (x > xx) {
                            x -= (x - xx) / 5 + 1;
                        }
                        SolarSystemCanvas320.this.header.setRefPixelPosition(x, 100);
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        SolarSystemCanvas320.this.g.setFont(SolarSystemCanvas320.this.SMALLFONT);
                        if (x == xx) {
                            SolarSystemCanvas320.this.g.setColor(0);
                            if (this.temp != 0) {
                                SolarSystemCanvas320.this.g.fillTriangle(30, 40 + SolarSystemCanvas320.this.screenWidth / 2, 40, 40 + SolarSystemCanvas320.this.screenWidth / 2 - 10, 40, 40 + SolarSystemCanvas320.this.screenWidth / 2 + 10);
                            }
                            if (this.temp != 5) {
                                SolarSystemCanvas320.this.g.fillTriangle(SolarSystemCanvas320.this.screenWidth - 20 - 10, 40 + SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenWidth - 40, 40 + SolarSystemCanvas320.this.screenWidth / 2 - 10, SolarSystemCanvas320.this.screenWidth - 40, 40 + SolarSystemCanvas320.this.screenWidth / 2 + 10);
                            }
                            SolarSystemCanvas320.this.displayString(" BACK", SolarSystemCanvas320.this.screenWidth / 2 - 50 - 10, 140 + SolarSystemCanvas320.this.offsetY + 40, true, false);
                            SolarSystemCanvas320.this.selector.setFrame(42);
                            SolarSystemCanvas320.this.selector.setTransform(0);
                            SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.screenWidth / 2 - 50 - 10 + 4, SolarSystemCanvas320.this.offsetY + 140 + 40 - 4 - 2);
                            SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                            SolarSystemCanvas320.this.selector.setTransform(2);
                            SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.screenWidth / 2 + 30 - 10, SolarSystemCanvas320.this.offsetY + 140 + 40 - 4 - 2);
                            SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                        }
                        SolarSystemCanvas320.this.g.setColor(0xFFFFFF);
                        SolarSystemCanvas320.this.g.drawString("SOLAR SYSTEM HELP: " + (this.temp + 1) + "/6", SolarSystemCanvas320.this.screenWidth / 2, 40, 17);
                        if (this.temp == 0 || this.temp == 1) {
                            SolarSystemCanvas320.this.g.drawString("The Solar System is in a mess", x, 80, 17);
                            SolarSystemCanvas320.this.g.drawString("caused by unknown meteoroids", x, 100, 17);
                            SolarSystemCanvas320.this.g.drawString("your job is to sort", x, 120, 17);
                            SolarSystemCanvas320.this.g.drawString("it out by making chains  ", x, 140, 17);
                            SolarSystemCanvas320.this.g.drawString("of the Planets, before time", x, 160, 17);
                            SolarSystemCanvas320.this.g.drawString("runs out.Chains can be made", x, 180, 17);
                            SolarSystemCanvas320.this.g.drawString("by using the empty cell.", x, 200, 17);
                            SolarSystemCanvas320.this.g.drawString("if all cells of a row", x, 220, 17);
                        }
                        if (this.temp == 0 || this.temp == 1 || this.temp == 2) {
                            SolarSystemCanvas320.this.g.drawString("or column are of same", x + SolarSystemCanvas320.this.screenWidth, 80, 17);
                            SolarSystemCanvas320.this.g.drawString("type of Planet, a chain", x + SolarSystemCanvas320.this.screenWidth, 100, 17);
                            SolarSystemCanvas320.this.g.drawString("is made and you will", x + SolarSystemCanvas320.this.screenWidth, 120, 17);
                            SolarSystemCanvas320.this.g.drawString("be awarded the score", x + SolarSystemCanvas320.this.screenWidth, 140, 17);
                            SolarSystemCanvas320.this.g.drawString("depending on the type", x + SolarSystemCanvas320.this.screenWidth, 160, 17);
                            SolarSystemCanvas320.this.g.drawString("of Planet. The faster you", x + SolarSystemCanvas320.this.screenWidth, 180, 17);
                            SolarSystemCanvas320.this.g.drawString("go the more you score;", x + SolarSystemCanvas320.this.screenWidth, 200, 17);
                            SolarSystemCanvas320.this.g.drawString("as you get a time bonus", x + SolarSystemCanvas320.this.screenWidth, 220, 17);
                        }
                        if (this.temp == 1 || this.temp == 2 || this.temp == 3) {
                            SolarSystemCanvas320.this.g.drawString("after each level. Time", x + SolarSystemCanvas320.this.screenWidth * 2, 80, 17);
                            SolarSystemCanvas320.this.g.drawString("bonus will depend on", x + SolarSystemCanvas320.this.screenWidth * 2, 100, 17);
                            SolarSystemCanvas320.this.g.drawString("the time left and the", x + SolarSystemCanvas320.this.screenWidth * 2, 120, 17);
                            SolarSystemCanvas320.this.g.drawString("difficulty level of your", x + SolarSystemCanvas320.this.screenWidth * 2, 140, 17);
                            SolarSystemCanvas320.this.g.drawString("game. You will earn", x + SolarSystemCanvas320.this.screenWidth * 2, 160, 17);
                            SolarSystemCanvas320.this.g.drawString("highest time bonus for", x + SolarSystemCanvas320.this.screenWidth * 2, 180, 17);
                            SolarSystemCanvas320.this.g.drawString("difficulty set as HARD and", x + SolarSystemCanvas320.this.screenWidth * 2, 200, 17);
                            SolarSystemCanvas320.this.g.drawString("lowest for EASY. You should", x + SolarSystemCanvas320.this.screenWidth * 2, 220, 17);
                            SolarSystemCanvas320.this.g.drawString("also go for high scoring", x + SolarSystemCanvas320.this.screenWidth * 2, 240, 17);
                        }
                        if (this.temp == 4 || this.temp == 2 || this.temp == 3) {
                            SolarSystemCanvas320.this.g.drawString("chains in order to", x + SolarSystemCanvas320.this.screenWidth * 3, 80, 17);
                            SolarSystemCanvas320.this.g.drawString("achieve higher scores.", x + SolarSystemCanvas320.this.screenWidth * 3, 100, 17);
                            SolarSystemCanvas320.this.g.drawString("Following are the", x + SolarSystemCanvas320.this.screenWidth * 3, 120, 17);
                            SolarSystemCanvas320.this.g.drawString("respective points for", x + SolarSystemCanvas320.this.screenWidth * 3, 140, 17);
                            SolarSystemCanvas320.this.g.drawString("each type of Gem", x + SolarSystemCanvas320.this.screenWidth * 3, 160, 17);
                            SolarSystemCanvas320.this.selector.setFrame(0);
                            SolarSystemCanvas320.this.selector.setPosition(40 + x + SolarSystemCanvas320.this.screenWidth * 3 - SolarSystemCanvas320.this.screenWidth / 2, 180);
                            SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                            SolarSystemCanvas320.this.g.setFont(SolarSystemCanvas320.this.BIGFONT);
                            SolarSystemCanvas320.this.g.drawString("5", 100 + x + SolarSystemCanvas320.this.screenWidth * 3 - SolarSystemCanvas320.this.screenWidth / 2, 180, 17);
                            SolarSystemCanvas320.this.g.setFont(SolarSystemCanvas320.this.SMALLFONT);
                            SolarSystemCanvas320.this.g.drawString("points", 100 + x + SolarSystemCanvas320.this.screenWidth * 3 - SolarSystemCanvas320.this.screenWidth / 2, 200, 17);
                            SolarSystemCanvas320.this.selector.setFrame(1);
                            SolarSystemCanvas320.this.selector.setPosition(40 + x + SolarSystemCanvas320.this.screenWidth * 3 - SolarSystemCanvas320.this.screenWidth / 2, 220);
                            SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                            SolarSystemCanvas320.this.g.setFont(SolarSystemCanvas320.this.BIGFONT);
                            SolarSystemCanvas320.this.g.drawString("7", 100 + x + SolarSystemCanvas320.this.screenWidth * 3 - SolarSystemCanvas320.this.screenWidth / 2, 220, 17);
                            SolarSystemCanvas320.this.g.setFont(SolarSystemCanvas320.this.SMALLFONT);
                            SolarSystemCanvas320.this.g.drawString("points", 100 + x + SolarSystemCanvas320.this.screenWidth * 3 - SolarSystemCanvas320.this.screenWidth / 2, 240, 17);
                            SolarSystemCanvas320.this.selector.setFrame(2);
                            SolarSystemCanvas320.this.selector.setPosition(120 + x + SolarSystemCanvas320.this.screenWidth * 3 - SolarSystemCanvas320.this.screenWidth / 2, 180);
                            SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                            SolarSystemCanvas320.this.g.setFont(SolarSystemCanvas320.this.BIGFONT);
                            SolarSystemCanvas320.this.g.drawString("10", 180 + x + SolarSystemCanvas320.this.screenWidth * 3 - SolarSystemCanvas320.this.screenWidth / 2, 180, 17);
                            SolarSystemCanvas320.this.g.setFont(SolarSystemCanvas320.this.SMALLFONT);
                            SolarSystemCanvas320.this.g.drawString("points", 180 + x + SolarSystemCanvas320.this.screenWidth * 3 - SolarSystemCanvas320.this.screenWidth / 2, 200, 17);
                            SolarSystemCanvas320.this.selector.setFrame(3);
                            SolarSystemCanvas320.this.selector.setPosition(120 + x + SolarSystemCanvas320.this.screenWidth * 3 - SolarSystemCanvas320.this.screenWidth / 2, 220);
                            SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                            SolarSystemCanvas320.this.g.setFont(SolarSystemCanvas320.this.BIGFONT);
                            SolarSystemCanvas320.this.g.drawString("15", 180 + x + SolarSystemCanvas320.this.screenWidth * 3 - SolarSystemCanvas320.this.screenWidth / 2, 220, 17);
                            SolarSystemCanvas320.this.g.setFont(SolarSystemCanvas320.this.SMALLFONT);
                            SolarSystemCanvas320.this.g.drawString("points", 180 + x + SolarSystemCanvas320.this.screenWidth * 3 - SolarSystemCanvas320.this.screenWidth / 2, 240, 17);
                        }
                        if (this.temp == 5 || this.temp == 4 || this.temp == 3) {
                            SolarSystemCanvas320.this.g.drawString("You cannot move the", x + SolarSystemCanvas320.this.screenWidth * 5, 80, 17);
                            SolarSystemCanvas320.this.g.drawString("Meteoroid. It is", x + SolarSystemCanvas320.this.screenWidth * 5, 100, 17);
                            SolarSystemCanvas320.this.g.drawString("an obstacle for you.", x + SolarSystemCanvas320.this.screenWidth * 5, 120, 17);
                            SolarSystemCanvas320.this.g.drawString("If you want to pause", x + SolarSystemCanvas320.this.screenWidth * 5, 180, 17);
                            SolarSystemCanvas320.this.g.drawString("the game anytime press", x + SolarSystemCanvas320.this.screenWidth * 5, 200, 17);
                            SolarSystemCanvas320.this.g.drawString("RSK(Right Soft Key)", x + SolarSystemCanvas320.this.screenWidth * 5, 220, 17);
                            SolarSystemCanvas320.this.selector.setFrame(43);
                            SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.screenWidth / 2 - 17 + x + SolarSystemCanvas320.this.screenWidth * 5 - SolarSystemCanvas320.this.screenWidth / 2, 140);
                            SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                        }
                        if (this.temp == 6 || this.temp == 5 || this.temp == 4) {
                            if (this.temp == 4) {
                                SolarSystemCanvas320.this.layer.paint(SolarSystemCanvas320.this.g);
                            }
                            SolarSystemCanvas320.this.selector.setTransform(0);
                            for (j = 0; j < 6; ++j) {
                                if (SolarSystemCanvas320.this.shiftingCells[j] == -1) continue;
                                SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingCells[j]);
                                SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + j * 35 + x + SolarSystemCanvas320.this.screenWidth * 4 - SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.offsetY + 35);
                                SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                            }
                            for (j = 0; j < 6; ++j) {
                                if (SolarSystemCanvas320.this.shiftingBlock[0][j] != -1) {
                                    SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingBlock[0][j]);
                                    SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + j * 35 + x + SolarSystemCanvas320.this.screenWidth * 4 - SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.offsetY + 70);
                                    SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                }
                                if (SolarSystemCanvas320.this.shiftingBlock[1][j] == -1) continue;
                                SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingBlock[1][j]);
                                SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + j * 35 + x + SolarSystemCanvas320.this.screenWidth * 4 - SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.offsetY + 105);
                                SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                            }
                            if (x == SolarSystemCanvas320.this.screenWidth / 2 - 4 * SolarSystemCanvas320.this.screenWidth) {
                                int[] colArray = new int[]{3, 2, 1, 1, 1, 2, 3, 4, 4, 4, 5, 0, 1, 1, 1, 0, 0, 5, 5, 4, 3, 3, 4, 5, 5};
                                int[] rowArray = new int[]{0, 0, 0, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0, 1, 2, 2, 1, 1, 0, 0, 0, 1, 1, 1, 2};
                                int i = SolarSystemCanvas320.this.player.getX();
                                if (i < (xx = this.movieStep < 25 ? SolarSystemCanvas320.this.offsetX + colArray[this.movieStep] * 35 : SolarSystemCanvas320.this.offsetX)) {
                                    i += (xx - i) / 5 + 1;
                                } else if (i > xx) {
                                    i -= (i - xx) / 5 + 1;
                                }
                                j = SolarSystemCanvas320.this.player.getY();
                                int yy = this.movieStep < 25 ? SolarSystemCanvas320.this.offsetY + rowArray[this.movieStep] * 35 + 35 : SolarSystemCanvas320.this.offsetY + 105;
                                if (j < yy) {
                                    j += (yy - j) / 5 + 1;
                                } else if (j > yy) {
                                    j -= (j - yy) / 5 + 1;
                                }
                                SolarSystemCanvas320.this.player.setFrame(41);
                                SolarSystemCanvas320.this.player.setPosition(i, j);
                                SolarSystemCanvas320.this.player.paint(SolarSystemCanvas320.this.g);
                                switch (this.movieStep) {
                                    default: {
                                        if (this.movieStep < 3) {
                                            SolarSystemCanvas320.this.g.drawString("To move left press 4", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        } else if (this.movieStep < 5) {
                                            SolarSystemCanvas320.this.g.drawString("To move down press 8", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        } else if (this.movieStep < 8) {
                                            SolarSystemCanvas320.this.g.drawString("To move right press 6", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        } else if (this.movieStep < 10) {
                                            SolarSystemCanvas320.this.g.drawString("To move up press 2", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        } else if (this.movieStep < 12) {
                                            SolarSystemCanvas320.this.g.drawString("If u cross one edge", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                            SolarSystemCanvas320.this.g.drawString("u will appear on other side", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        } else if (this.movieStep > 24 && this.movieStep < 34) {
                                            SolarSystemCanvas320.this.g.drawString("Go for high scoring", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                            SolarSystemCanvas320.this.g.drawString("to set records", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                            int[] nArray = SolarSystemCanvas320.this.shiftingBlock[0];
                                            nArray[0] = nArray[0] + 4;
                                            int[] nArray2 = SolarSystemCanvas320.this.shiftingBlock[0];
                                            nArray2[1] = nArray2[1] + 4;
                                            int[] nArray3 = SolarSystemCanvas320.this.shiftingBlock[0];
                                            nArray3[2] = nArray3[2] + 4;
                                            int[] nArray4 = SolarSystemCanvas320.this.shiftingBlock[0];
                                            nArray4[3] = nArray4[3] + 4;
                                            int[] nArray5 = SolarSystemCanvas320.this.shiftingBlock[0];
                                            nArray5[4] = nArray5[4] + 4;
                                            int[] nArray6 = SolarSystemCanvas320.this.shiftingBlock[0];
                                            nArray6[5] = nArray6[5] + 4;
                                            ++this.movieStep;
                                        } else if (this.movieStep >= 34 && this.movieStep < 37) {
                                            SolarSystemCanvas320.this.g.drawString("Be a topper set", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                            SolarSystemCanvas320.this.g.drawString("unbreakable record", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                            int[] nArray = SolarSystemCanvas320.this.shiftingBlock[0];
                                            nArray[0] = nArray[0] - 4;
                                            int[] nArray7 = SolarSystemCanvas320.this.shiftingBlock[0];
                                            nArray7[1] = nArray7[1] - 4;
                                            int[] nArray8 = SolarSystemCanvas320.this.shiftingBlock[0];
                                            nArray8[2] = nArray8[2] - 4;
                                            int[] nArray9 = SolarSystemCanvas320.this.shiftingBlock[0];
                                            nArray9[3] = nArray9[3] - 4;
                                            int[] nArray10 = SolarSystemCanvas320.this.shiftingBlock[0];
                                            nArray10[4] = nArray10[4] - 4;
                                            int[] nArray11 = SolarSystemCanvas320.this.shiftingBlock[0];
                                            nArray11[5] = nArray11[5] - 4;
                                            ++this.movieStep;
                                        } else {
                                            ++this.temp;
                                        }
                                        if (j != yy || i != xx) break;
                                        ++this.movieStep;
                                        break;
                                    }
                                    case 12: {
                                        SolarSystemCanvas320.this.g.drawString("To push the Planets in", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("empty block press 5", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[1] = -1;
                                        SolarSystemCanvas320.this.selector.setFrame(2);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 35 + SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + 35);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.moveVal += 5;
                                        if (SolarSystemCanvas320.this.moveVal < 35) break;
                                        SolarSystemCanvas320.this.moveVal = 0;
                                        ++this.movieStep;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[2] = 2;
                                        break;
                                    }
                                    case 13: {
                                        SolarSystemCanvas320.this.g.drawString("To push the Planets in", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("empty block press 5", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ++this.movieStep;
                                        break;
                                    }
                                    case 14: {
                                        SolarSystemCanvas320.this.g.drawString("Go to the final", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("Planet and press 5", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][1] = -1;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][1] = -1;
                                        SolarSystemCanvas320.this.selector.setFrame(0);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 35, SolarSystemCanvas320.this.offsetY + 70 - SolarSystemCanvas320.this.moveVal);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.selector.setFrame(3);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 35, SolarSystemCanvas320.this.offsetY + 105 - SolarSystemCanvas320.this.moveVal);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.moveVal += 5;
                                        if (SolarSystemCanvas320.this.moveVal < 35) break;
                                        SolarSystemCanvas320.this.moveVal = 0;
                                        ++this.movieStep;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[1] = 0;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][1] = 3;
                                        break;
                                    }
                                    case 15: {
                                        SolarSystemCanvas320.this.g.drawString("Go to the final", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("Planet and press 5", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][0] = -1;
                                        SolarSystemCanvas320.this.selector.setFrame(2);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + 105);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.moveVal += 5;
                                        if (SolarSystemCanvas320.this.moveVal < 35) break;
                                        SolarSystemCanvas320.this.moveVal = 0;
                                        ++this.movieStep;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][1] = 2;
                                        break;
                                    }
                                    case 16: {
                                        SolarSystemCanvas320.this.g.drawString("Also move circular", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("to save time", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][0] = -1;
                                        SolarSystemCanvas320.this.selector.setFrame(1);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX, SolarSystemCanvas320.this.offsetY + 70 + SolarSystemCanvas320.this.moveVal);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.moveVal += 5;
                                        if (SolarSystemCanvas320.this.moveVal < 35) break;
                                        SolarSystemCanvas320.this.moveVal = 0;
                                        ++this.movieStep;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][0] = 1;
                                        break;
                                    }
                                    case 17: {
                                        SolarSystemCanvas320.this.g.drawString("Also move circular", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("to save time", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][1] = -1;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][2] = -1;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][3] = -1;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][4] = -1;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][5] = -1;
                                        SolarSystemCanvas320.this.selector.setFrame(3);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 35 - SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + 70);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.selector.setFrame(3);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 70 - SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + 70);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.selector.setFrame(3);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 105 - SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + 70);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.selector.setFrame(2);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 140 - SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + 70);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.selector.setFrame(3);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 175 - SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + 70);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.moveVal += 5;
                                        if (SolarSystemCanvas320.this.moveVal < 35) break;
                                        SolarSystemCanvas320.this.moveVal = 0;
                                        ++this.movieStep;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][0] = 3;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][1] = 3;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][2] = 3;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][3] = 2;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][4] = 3;
                                        break;
                                    }
                                    case 18: {
                                        SolarSystemCanvas320.this.g.drawString("Push multiple Planet", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("to save time", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[5] = -1;
                                        SolarSystemCanvas320.this.selector.setFrame(3);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 175, SolarSystemCanvas320.this.offsetY + 35 + SolarSystemCanvas320.this.moveVal);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.moveVal += 5;
                                        if (SolarSystemCanvas320.this.moveVal < 35) break;
                                        SolarSystemCanvas320.this.moveVal = 0;
                                        ++this.movieStep;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][5] = 3;
                                        break;
                                    }
                                    case 19: {
                                        SolarSystemCanvas320.this.g.drawString("Push multiple Planet", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("to save time", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ++this.movieStep;
                                        break;
                                    }
                                    case 20: {
                                        SolarSystemCanvas320.this.g.drawString("Push multiple Planet", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("to save time", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[3] = -1;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[4] = -1;
                                        SolarSystemCanvas320.this.selector.setFrame(1);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 105 + SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + 35);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.selector.setFrame(0);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 140 + SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + 35);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.moveVal += 5;
                                        if (SolarSystemCanvas320.this.moveVal < 35) break;
                                        SolarSystemCanvas320.this.moveVal = 0;
                                        ++this.movieStep;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[4] = 1;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[5] = 0;
                                        break;
                                    }
                                    case 21: {
                                        SolarSystemCanvas320.this.g.drawString("Go to the final", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("Planet and press 5", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][3] = -1;
                                        SolarSystemCanvas320.this.selector.setFrame(2);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 105, SolarSystemCanvas320.this.offsetY + 70 - SolarSystemCanvas320.this.moveVal);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.moveVal += 5;
                                        if (SolarSystemCanvas320.this.moveVal < 35) break;
                                        SolarSystemCanvas320.this.moveVal = 0;
                                        ++this.movieStep;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[3] = 2;
                                        break;
                                    }
                                    case 22: {
                                        SolarSystemCanvas320.this.g.drawString("Go to the final", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("Planet and press 5", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ++this.movieStep;
                                        break;
                                    }
                                    case 23: {
                                        SolarSystemCanvas320.this.g.drawString("Plan, than move", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("time is very crucial", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][4] = -1;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][5] = -1;
                                        SolarSystemCanvas320.this.selector.setFrame(3);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 140 - SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + 70);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.selector.setFrame(3);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 175 - SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + 70);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.moveVal += 5;
                                        if (SolarSystemCanvas320.this.moveVal < 35) break;
                                        SolarSystemCanvas320.this.moveVal = 0;
                                        ++this.movieStep;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][3] = 3;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][4] = 3;
                                        break;
                                    }
                                    case 24: {
                                        SolarSystemCanvas320.this.g.drawString("Plan, than move", x + SolarSystemCanvas320.this.screenWidth * 4, 80, 17);
                                        SolarSystemCanvas320.this.g.drawString("time is very crucial", x + SolarSystemCanvas320.this.screenWidth * 4, 80 + SolarSystemCanvas320.this.SMALLFONT.getHeight(), 17);
                                        if (j != yy || i != xx) break;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][5] = -1;
                                        SolarSystemCanvas320.this.selector.setFrame(3);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 175, SolarSystemCanvas320.this.offsetY + 105 - SolarSystemCanvas320.this.moveVal);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                        SolarSystemCanvas320.this.moveVal += 5;
                                        if (SolarSystemCanvas320.this.moveVal < 35) break;
                                        SolarSystemCanvas320.this.moveVal = 0;
                                        ++this.movieStep;
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][5] = 3;
                                        if (SolarSystemCanvas320.this.vibrations) {
                                            SolarSystemCanvas320.this.midlet.vibra(1000);
                                        }
                                        if (SolarSystemCanvas320.this.soundVolume <= 0) break;
                                        try {
                                            SolarSystemCanvas320.this.musicPlayer[1].start();
                                            break;
                                        }
                                        catch (MediaException ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                }
                            }
                        }
                        if (SolarSystemCanvas320.this.changeSelection == -5) {
                            SolarSystemCanvas320.this.gameState = 1;
                            this.temp = 0;
                            for (j = 0; j < 4; ++j) {
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[j] = -1;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][j] = -1;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][j] = -1;
                            }
                        } else if (SolarSystemCanvas320.this.changeSelection == 1 && this.temp < 5) {
                            this.temp += SolarSystemCanvas320.this.changeSelection;
                            if (this.temp == 4) {
                                this.movieStep = 0;
                                SolarSystemCanvas320.this.moveVal = 0;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[0] = 0;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[1] = 2;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[2] = -1;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[3] = 1;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[4] = 0;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[5] = 3;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][0] = 1;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][1] = 0;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][2] = 3;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][3] = 3;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][4] = 2;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][5] = 3;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][0] = 2;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][1] = 3;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][2] = 0;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][3] = 1;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][4] = 43;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][5] = 3;
                            }
                        } else if (SolarSystemCanvas320.this.changeSelection == -1 && this.temp > 0) {
                            this.temp += SolarSystemCanvas320.this.changeSelection;
                            if (this.temp == 4) {
                                this.movieStep = 0;
                                SolarSystemCanvas320.this.moveVal = 0;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[0] = 0;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[1] = 2;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[2] = -1;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[3] = 1;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[4] = 0;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[5] = 3;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][0] = 1;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][1] = 0;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][2] = 3;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][3] = 3;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][4] = 2;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][5] = 3;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][0] = 2;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][1] = 3;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][2] = 0;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][3] = 1;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][4] = 43;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][5] = 3;
                            }
                        }
                        SolarSystemCanvas320.this.changeSelection = 0;
                        break;
                    }
                    case 6: {
                        int x = SolarSystemCanvas320.this.header.getRefPixelX();
                        int xx = SolarSystemCanvas320.this.screenWidth / 2 - this.temp * SolarSystemCanvas320.this.screenWidth;
                        if (x < xx) {
                            x += (xx - x) / 5 + 1;
                        } else if (x > xx) {
                            x -= (x - xx) / 5 + 1;
                        }
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        SolarSystemCanvas320.this.header.setRefPixelPosition(x, 100);
                        if (x == xx) {
                            SolarSystemCanvas320.this.g.setColor(153, 193, 204);
                            if (this.temp != 0) {
                                SolarSystemCanvas320.this.g.fillTriangle(30, 40 + SolarSystemCanvas320.this.screenWidth / 2, 40, 40 + SolarSystemCanvas320.this.screenWidth / 2 - 10, 40, 40 + SolarSystemCanvas320.this.screenWidth / 2 + 10);
                            }
                            if (this.temp != 2) {
                                SolarSystemCanvas320.this.g.fillTriangle(SolarSystemCanvas320.this.screenWidth - 20 - 10, 40 + SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenWidth - 40, 40 + SolarSystemCanvas320.this.screenWidth / 2 - 10, SolarSystemCanvas320.this.screenWidth - 40, 40 + SolarSystemCanvas320.this.screenWidth / 2 + 10);
                            }
                            SolarSystemCanvas320.this.displayString(" BACK", SolarSystemCanvas320.this.screenWidth / 2 - 50 - 10, 140 + SolarSystemCanvas320.this.offsetY + 40, true, false);
                            SolarSystemCanvas320.this.player.setPosition(SolarSystemCanvas320.this.screenWidth / 2 - 50 - 10 + 4, SolarSystemCanvas320.this.offsetY + 140 + 40 - 4 - 2);
                            SolarSystemCanvas320.this.player.paint(SolarSystemCanvas320.this.g);
                            SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.screenWidth / 2 + 30 - 10, SolarSystemCanvas320.this.offsetY + 140 + 40 - 4 - 2);
                            SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                        }
                        SolarSystemCanvas320.this.g.setColor(0xFFFFFF);
                        SolarSystemCanvas320.this.g.setFont(SolarSystemCanvas320.this.SMALLFONT);
                        SolarSystemCanvas320.this.g.drawString("SCARAB VERSION 1.0.0", x, 80, 17);
                        SolarSystemCanvas320.this.g.drawString("\u00a9 2009 ALL RIGHTS RESERVED", x, 100, 17);
                        if (this.temp > 0) {
                            SolarSystemCanvas320.this.g.drawString("CREDITS", SolarSystemCanvas320.this.screenWidth / 2, 40, 17);
                        }
                        SolarSystemCanvas320.this.g.setFont(SolarSystemCanvas320.this.SMALLULINEFONT);
                        SolarSystemCanvas320.this.g.drawString("PUBLISHED BY", x, 140, 17);
                        SolarSystemCanvas320.this.g.drawString("DEVELOPED BY", x, 200, 17);
                        SolarSystemCanvas320.this.g.drawString("PROGRAMMERS", x + SolarSystemCanvas320.this.screenWidth, 120, 17);
                        SolarSystemCanvas320.this.g.drawString("ARTIST", x + SolarSystemCanvas320.this.screenWidth * 2, 80, 17);
                        SolarSystemCanvas320.this.g.drawString("PRODUCER", x + SolarSystemCanvas320.this.screenWidth * 2, 140, 17);
                        SolarSystemCanvas320.this.g.drawString("TESTER", x + SolarSystemCanvas320.this.screenWidth * 2, 200, 17);
                        SolarSystemCanvas320.this.g.setFont(SolarSystemCanvas320.this.BIGFONT);
                        SolarSystemCanvas320.this.g.drawString("RZ2 GAMES", x, 160, 17);
                        SolarSystemCanvas320.this.g.drawString("RZ2 GAMES", x, 220, 17);
                        SolarSystemCanvas320.this.g.drawString("KAMESHWAR", x + SolarSystemCanvas320.this.screenWidth, 140, 17);
                        SolarSystemCanvas320.this.g.drawString("BHAWANI", x + SolarSystemCanvas320.this.screenWidth, 160, 17);
                        SolarSystemCanvas320.this.g.drawString("PARUL SHEORAN", x + SolarSystemCanvas320.this.screenWidth, 180, 17);
                        SolarSystemCanvas320.this.g.drawString("MAYANK SHARMA", x + SolarSystemCanvas320.this.screenWidth * 2, 100, 17);
                        SolarSystemCanvas320.this.g.drawString("SIMON BANERJEE", x + SolarSystemCanvas320.this.screenWidth * 2, 160, 17);
                        SolarSystemCanvas320.this.g.drawString("RANJOY DATTA", x + SolarSystemCanvas320.this.screenWidth * 2, 220, 17);
                        if (SolarSystemCanvas320.this.changeSelection == -5) {
                            SolarSystemCanvas320.this.gameState = 1;
                            this.temp = 0;
                        } else if (SolarSystemCanvas320.this.changeSelection == 1 && this.temp < 2) {
                            this.temp += SolarSystemCanvas320.this.changeSelection;
                        } else if (SolarSystemCanvas320.this.changeSelection == -1 && this.temp > 0) {
                            this.temp += SolarSystemCanvas320.this.changeSelection;
                        }
                        SolarSystemCanvas320.this.changeSelection = 0;
                        break;
                    }
                    case 0: {
                        int yy;
                        ++this.traverseIndex;
                        if (this.traverseIndex < 40) {
                            SolarSystemCanvas320.this.g.drawImage(this.titleImage, SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenHeight / 2, 3);
                            for (int j = this.temp; j > 0; --j) {
                                for (int i = 0; i < 8; ++i) {
                                    SolarSystemCanvas320.this.g.drawImage(this.lose, SolarSystemCanvas320.this.screenWidth / 2, 20 * i + 80, 17);
                                }
                            }
                            --this.temp;
                            break;
                        }
                        if (this.traverseIndex >= 40 && this.traverseIndex <= 70) {
                            for (int i = 0; i < 8; ++i) {
                                SolarSystemCanvas320.this.g.drawImage(this.lose, SolarSystemCanvas320.this.screenWidth / 2, 20 * i + 80, 17);
                            }
                            break;
                        }
                        if (this.traverseIndex == 71) {
                            this.lose = null;
                            try {
                                this.titleImage = Image.createImage((String)"/tl.png");
                            }
                            catch (IOException ex) {
                                System.out.println("cant create titleImage " + ex);
                                ex.printStackTrace();
                            }
                            SolarSystemCanvas320.this.selector.setRefPixelPosition(0, SolarSystemCanvas320.this.screenHeight);
                            break;
                        }
                        int y = SolarSystemCanvas320.this.selector.getRefPixelY();
                        if (y < (yy = 10)) {
                            y += (yy - y) / 20 + 1;
                        } else if (y > yy) {
                            y -= (y - yy) / 20 + 1;
                        }
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        SolarSystemCanvas320.this.selector.setPosition(0, y);
                        SolarSystemCanvas320.this.g.drawImage(this.titleImage, SolarSystemCanvas320.this.screenWidth / 2, y, 17);
                        if (y != yy) break;
                        boolean i = false;
                        this.traverseIndex = 0;
                        this.temp = 0;
                        SolarSystemCanvas320.access$2502(SolarSystemCanvas320.this, SolarSystemCanvas320.this.mmenuItems);
                        SolarSystemCanvas320.this.menuType = 0;
                        SolarSystemCanvas320.this.gameState = 1;
                        SolarSystemCanvas320.this.changeSelection = 0;
                        break;
                    }
                    case 3: {
                        SolarSystemCanvas320.this.currentLevel = 0;
                        SolarSystemCanvas320.this.types_OF_CELLS = 3;
                        SolarSystemCanvas320.this.score = 0;
                        this.traverseIndex = 0;
                    }
                    case 9: {
                        if (SolarSystemCanvas320.this.soundVolume > 0 && SolarSystemCanvas320.this.musicPlayer[0].getState() != 400) {
                            try {
                                SolarSystemCanvas320.this.musicPlayer[0].start();
                            }
                            catch (MediaException ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (this.traverseIndex == 0) {
                            SolarSystemCanvas320.this.currentLevel++;
                            SolarSystemCanvas320.this.LEVEL_TIME = (SolarSystemCanvas320.this.currentLevel + 1) * 30;
                            SolarSystemCanvas320.this.LEVEL_TIME += SolarSystemCanvas320.this.LEVEL_TIME / 4 * SolarSystemCanvas320.this.difficulty;
                            SolarSystemCanvas320.this.made = 0;
                            ++this.traverseIndex;
                            SolarSystemCanvas320.this.createBoard();
                            SolarSystemCanvas320.this.header.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenHeight / 2);
                            SolarSystemCanvas320.this.header.setFrame(0);
                            SolarSystemCanvas320.this.messageSprite.setFrame(0);
                            SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, 0);
                            SolarSystemCanvas320.this.gameState = 9;
                            SolarSystemCanvas320.this.levelCompleted = false;
                            SolarSystemCanvas320.this.changeSelection = 0;
                            System.out.println("out of trouble");
                            break;
                        }
                        ++this.traverseIndex;
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        int x = SolarSystemCanvas320.this.header.getRefPixelX();
                        int xx = SolarSystemCanvas320.this.screenWidth / 2;
                        if (x < xx) {
                            x += (xx - x) / 5 + 1;
                        } else if (x > xx) {
                            x -= (x - xx) / 5 + 1;
                        }
                        int y = SolarSystemCanvas320.this.header.getRefPixelY();
                        int yy = SolarSystemCanvas320.this.offsetY + 20;
                        if (y < yy) {
                            y += (yy - y) / 5 + 1;
                        } else if (y > yy) {
                            y -= (y - yy) / 5 + 1;
                        }
                        SolarSystemCanvas320.this.header.setRefPixelPosition(x, y);
                        SolarSystemCanvas320.this.header.paint(SolarSystemCanvas320.this.g);
                        SolarSystemCanvas320.this.drawTranslucentRect(10, 110, 10, 8);
                        SolarSystemCanvas320.this.displayString("LEVEL", 20, 120, false, false);
                        SolarSystemCanvas320.this.displayString("NO:", 20, 140, false, false);
                        SolarSystemCanvas320.this.displayString("TIME", 20, 180, false, false);
                        SolarSystemCanvas320.this.displayString("LIMIT", 20, 200, false, false);
                        SolarSystemCanvas320.this.displayString("LINES", 20, 240, false, false);
                        SolarSystemCanvas320.this.displayString("TOGO:", 20, 260, false, false);
                        if (SolarSystemCanvas320.this.currentLevel > 300) {
                            SolarSystemCanvas320.this.displayString("" + SolarSystemCanvas320.this.currentLevel, 120, 130, false, false);
                            SolarSystemCanvas320.this.displayString("" + SolarSystemCanvas320.this.LEVEL_TIME, 120, 190, false, false);
                            SolarSystemCanvas320.this.displayString("" + (SolarSystemCanvas320.this.currentLevel + 1 - SolarSystemCanvas320.this.made), 120, 250, false, false);
                        } else {
                            SolarSystemCanvas320.this.displayString("" + SolarSystemCanvas320.this.currentLevel, 140, 130, false, false);
                            SolarSystemCanvas320.this.displayString("" + SolarSystemCanvas320.this.LEVEL_TIME, 140, 190, false, false);
                            SolarSystemCanvas320.this.displayString("" + (SolarSystemCanvas320.this.currentLevel + 1 - SolarSystemCanvas320.this.made), 140, 250, false, false);
                        }
                        y = SolarSystemCanvas320.this.messageSprite.getRefPixelY();
                        yy = SolarSystemCanvas320.this.screenHeight - 10;
                        if (y < yy) {
                            y += (yy - y) / 5 + 1;
                        } else if (y > yy) {
                            y -= (y - yy) / 5 + 1;
                        }
                        SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, y);
                        SolarSystemCanvas320.this.messageSprite.paint(SolarSystemCanvas320.this.g);
                        if (y == yy && (SolarSystemCanvas320.this.getKeyStates() & 0x100) != 0) {
                            try {
                                SolarSystemCanvas320.this.musicPlayer[0].stop();
                            }
                            catch (MediaException ex) {
                                ex.printStackTrace();
                            }
                            SolarSystemCanvas320.this.gameState = 11;
                            this.traverseIndex = 0;
                            SolarSystemCanvas320.this.changeSelection = 0;
                            break;
                        }
                        SolarSystemCanvas320.this.getKeyStates();
                        break;
                    }
                    case 2: {
                        if (this.names == null) {
                            this.names = SolarSystemCanvas320.this.getHighScores(this.scores);
                            SolarSystemCanvas320.this.g.setColor(0xFFFFFF);
                            SolarSystemCanvas320.this.header.setFrame(1);
                            break;
                        }
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        int x = SolarSystemCanvas320.this.header.getRefPixelX();
                        int xx = SolarSystemCanvas320.this.screenWidth / 2;
                        if (x < xx) {
                            x += (xx - x) / 5 + 1;
                        } else if (x > xx) {
                            x -= (x - xx) / 5 + 1;
                        }
                        int y = SolarSystemCanvas320.this.header.getRefPixelY();
                        int yy = SolarSystemCanvas320.this.offsetY + 20;
                        if (y < yy) {
                            y += (yy - y) / 5 + 1;
                        } else if (y > yy) {
                            y -= (y - yy) / 5 + 1;
                        }
                        SolarSystemCanvas320.this.header.setRefPixelPosition(x, y);
                        SolarSystemCanvas320.this.header.paint(SolarSystemCanvas320.this.g);
                        SolarSystemCanvas320.this.drawTranslucentRect(20, 130, 9, 7);
                        for (int i = 0; i < 5; ++i) {
                            if (this.scores[i] <= 0) continue;
                            SolarSystemCanvas320.this.g.drawString(this.names[i], 30, 140 + i * 20, 20);
                            SolarSystemCanvas320.this.g.drawString("" + this.scores[i], 200, 140 + i * 20, 24);
                        }
                        y = SolarSystemCanvas320.this.messageSprite.getRefPixelY();
                        if (y < (yy = SolarSystemCanvas320.this.screenHeight - 10)) {
                            y += (yy - y) / 5 + 1;
                        } else if (y > yy) {
                            y -= (y - yy) / 5 + 1;
                        }
                        SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, y);
                        SolarSystemCanvas320.this.messageSprite.paint(SolarSystemCanvas320.this.g);
                        if (y == yy && (SolarSystemCanvas320.this.getKeyStates() & 0x100) != 0) {
                            SolarSystemCanvas320.this.menuIndex = 0;
                            SolarSystemCanvas320.this.paused = false;
                            SolarSystemCanvas320.access$2502(SolarSystemCanvas320.this, SolarSystemCanvas320.this.mmenuItems);
                            SolarSystemCanvas320.this.menuType = 0;
                            SolarSystemCanvas320.this.gameState = 1;
                            this.names = null;
                            SolarSystemCanvas320.this.changeSelection = 0;
                            break;
                        }
                        SolarSystemCanvas320.this.getKeyStates();
                        break;
                    }
                    case 4: {
                        SolarSystemCanvas320.this.currentLevel = SolarSystemCanvas320.this.rec[1] << 8 & 0xFF00 | SolarSystemCanvas320.this.rec[0] & 0xFF;
                        if (SolarSystemCanvas320.this.currentLevel == 0) {
                            SolarSystemCanvas320.this.gameState = 3;
                            break;
                        }
                        SolarSystemCanvas320.this.made = SolarSystemCanvas320.this.rec[3] << 8 & 0xFF00 | SolarSystemCanvas320.this.rec[2] & 0xFF;
                        System.out.println("made[3]:" + SolarSystemCanvas320.this.rec[3] + " made[2]:" + SolarSystemCanvas320.this.rec[2] + " made:" + SolarSystemCanvas320.this.made);
                        SolarSystemCanvas320.this.score = SolarSystemCanvas320.this.rec[6] << 16 & 0xFF0000 | SolarSystemCanvas320.this.rec[5] << 8 & 0xFF00 | SolarSystemCanvas320.this.rec[4] & 0xFF;
                        SolarSystemCanvas320.this.LEVEL_TIME = SolarSystemCanvas320.this.rec[9] << 16 & 0xFF0000 | SolarSystemCanvas320.this.rec[8] << 8 & 0xFF00 | SolarSystemCanvas320.this.rec[7] & 0xFF;
                        SolarSystemCanvas320.this.levelCompleted = (SolarSystemCanvas320.this.rec[10] & 0x20) == 32 || SolarSystemCanvas320.this.currentLevel == SolarSystemCanvas320.this.made - 1;
                        this.traverseIndex = 0;
                        if (SolarSystemCanvas320.this.levelCompleted) {
                            this.traverseIndex = 0;
                        } else {
                            this.traverseIndex = 1;
                            SolarSystemCanvas320.this.createBoard();
                        }
                        System.out.println("loading values:" + SolarSystemCanvas320.this.currentLevel + " made:" + SolarSystemCanvas320.this.made + "score:" + SolarSystemCanvas320.this.score + "time:" + SolarSystemCanvas320.this.LEVEL_TIME + " difficulty:" + SolarSystemCanvas320.this.difficulty + " SV:" + SolarSystemCanvas320.this.soundVolume + " vibrations:" + SolarSystemCanvas320.this.vibrations + " ***LC:" + SolarSystemCanvas320.this.levelCompleted);
                        SolarSystemCanvas320.this.header.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenHeight / 2);
                        SolarSystemCanvas320.this.header.setFrame(0);
                        SolarSystemCanvas320.this.messageSprite.setFrame(0);
                        SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, 0);
                        SolarSystemCanvas320.this.gameState = 9;
                        if (SolarSystemCanvas320.this.soundVolume <= 0) break;
                        try {
                            SolarSystemCanvas320.this.musicPlayer[0].start();
                        }
                        catch (MediaException ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    case 16: {
                        SolarSystemCanvas320.this.input();
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        for (int i = 5; i >= 0; --i) {
                            for (int j = 5; j >= 0; --j) {
                                SolarSystemCanvas320.this.scarabs[i][j].paint(SolarSystemCanvas320.this.g);
                            }
                        }
                        SolarSystemCanvas320.this.layer.paint(SolarSystemCanvas320.this.g);
                        int x = SolarSystemCanvas320.this.player.getX();
                        int xx = SolarSystemCanvas320.this.offsetX + SolarSystemCanvas320.this.currentColumn * 35;
                        if (x < xx) {
                            x += (xx - x) / 5 + 1;
                        } else if (x > xx) {
                            x -= (x - xx) / 5 + 1;
                        }
                        int y = SolarSystemCanvas320.this.player.getY();
                        int yy = SolarSystemCanvas320.this.offsetY + SolarSystemCanvas320.this.currentRow * 35;
                        if (y < yy) {
                            y += (yy - y) / 5 + 1;
                        } else if (y > yy) {
                            y -= (y - yy) / 5 + 1;
                        }
                        SolarSystemCanvas320.this.player.setPosition(x, y);
                        SolarSystemCanvas320.this.player.paint(SolarSystemCanvas320.this.g);
                        if ((long)SolarSystemCanvas320.this.levelFinishTime - System.currentTimeMillis() / 1000L > 10L) break;
                        if ((long)SolarSystemCanvas320.this.levelFinishTime - System.currentTimeMillis() / 1000L < 0L) {
                            SolarSystemCanvas320.this.currentLevel = 0;
                            SolarSystemCanvas320.this.writeRMS(true);
                            try {
                                SolarSystemCanvas320.this.musicPlayer[3].stop();
                            }
                            catch (MediaException ex) {
                                ex.printStackTrace();
                            }
                            if (this.gameOverSprite1 == null) {
                                try {
                                    this.gameOverSprite1 = new Sprite(Image.createImage((String)"/go.png"), 200, 80);
                                    this.gameOverSprite1.defineReferencePixel(100, 40);
                                    this.gameOverSprite2 = new Sprite(Image.createImage((String)"/go.png"), 200, 80);
                                    this.gameOverSprite2.defineReferencePixel(100, 40);
                                    this.gameOverSprite2.setFrame(1);
                                }
                                catch (Exception e) {
                                    System.out.println("cant create game over Sprite" + e);
                                }
                            }
                            switch (SolarSystemCanvas320.this.random.nextInt() % 5) {
                                case 1: {
                                    this.gameOverSprite2.setRefPixelPosition(0, 0);
                                    this.gameOverSprite1.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth, SolarSystemCanvas320.this.screenHeight);
                                    break;
                                }
                                case -1: {
                                    this.gameOverSprite1.setRefPixelPosition(0, 0);
                                    this.gameOverSprite2.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth, SolarSystemCanvas320.this.screenHeight);
                                    break;
                                }
                                case 2: {
                                    this.gameOverSprite2.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, 0);
                                    this.gameOverSprite1.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenHeight);
                                    break;
                                }
                                case -2: {
                                    this.gameOverSprite1.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, 0);
                                    this.gameOverSprite2.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenHeight);
                                    break;
                                }
                                case 3: {
                                    this.gameOverSprite1.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth, 0);
                                    this.gameOverSprite2.setRefPixelPosition(0, SolarSystemCanvas320.this.screenHeight);
                                    break;
                                }
                                case -3: {
                                    this.gameOverSprite2.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth, 0);
                                    this.gameOverSprite1.setRefPixelPosition(0, SolarSystemCanvas320.this.screenHeight);
                                    break;
                                }
                                case 4: {
                                    this.gameOverSprite1.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth, SolarSystemCanvas320.this.screenHeight / 2);
                                    this.gameOverSprite2.setRefPixelPosition(0, SolarSystemCanvas320.this.screenHeight / 2);
                                    break;
                                }
                                case -4: {
                                    this.gameOverSprite2.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth, SolarSystemCanvas320.this.screenHeight / 2);
                                    this.gameOverSprite1.setRefPixelPosition(0, SolarSystemCanvas320.this.screenHeight);
                                    break;
                                }
                                default: {
                                    this.gameOverSprite2.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, 0);
                                    this.gameOverSprite1.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenHeight);
                                }
                            }
                            ((SolarSystemCanvas320)SolarSystemCanvas320.this).ppmenuItems[1] = "*CONTINUE";
                            SolarSystemCanvas320.this.gameState = 10;
                            SolarSystemCanvas320.this.messageSprite.setFrame(0);
                            SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenHeight);
                            break;
                        }
                        if (SolarSystemCanvas320.this.soundVolume <= 0 || SolarSystemCanvas320.this.musicPlayer[3].getState() == 400) break;
                        try {
                            SolarSystemCanvas320.this.musicPlayer[3].start();
                        }
                        catch (MediaException ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    case 10: {
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        int y = SolarSystemCanvas320.this.messageSprite.getRefPixelY();
                        int yy = SolarSystemCanvas320.this.screenHeight - 10;
                        if (y < yy) {
                            y += (yy - y) / 5 + 1;
                        } else if (y > yy) {
                            y -= (y - yy) / 5 + 1;
                        }
                        SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, y);
                        SolarSystemCanvas320.this.messageSprite.setFrame(0);
                        SolarSystemCanvas320.this.messageSprite.paint(SolarSystemCanvas320.this.g);
                        int x = this.gameOverSprite1.getRefPixelX();
                        int xx = SolarSystemCanvas320.this.screenWidth / 2;
                        if (x < xx) {
                            x += (xx - x) / 5 + 1;
                        } else if (x > xx) {
                            x -= (x - xx) / 5 + 1;
                        }
                        y = this.gameOverSprite1.getRefPixelY();
                        yy = SolarSystemCanvas320.this.screenHeight / 2 - 40;
                        if (y < yy) {
                            y += (yy - y) / 5 + 1;
                        } else if (y > yy) {
                            y -= (y - yy) / 5 + 1;
                        }
                        this.gameOverSprite1.setRefPixelPosition(x, y);
                        this.gameOverSprite1.paint(SolarSystemCanvas320.this.g);
                        x = this.gameOverSprite2.getRefPixelX();
                        xx = SolarSystemCanvas320.this.screenWidth / 2;
                        if (x < xx) {
                            x += (xx - x) / 5 + 1;
                        } else if (x > xx) {
                            x -= (x - xx) / 5 + 1;
                        }
                        y = this.gameOverSprite2.getRefPixelY();
                        yy = SolarSystemCanvas320.this.screenHeight / 2 + 40;
                        if (y < yy) {
                            y += (yy - y) / 5 + 1;
                        } else if (y > yy) {
                            y -= (y - yy) / 5 + 1;
                        }
                        this.gameOverSprite2.setRefPixelPosition(x, y);
                        this.gameOverSprite2.paint(SolarSystemCanvas320.this.g);
                        if (y == yy && x == xx && (SolarSystemCanvas320.this.getKeyStates() & 0x100) != 0) {
                            if (SolarSystemCanvas320.this.score > this.scores[4]) {
                                SolarSystemCanvas320.this.nameIndex = 0;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).uName[0] = 32;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).uName[1] = 32;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).uName[2] = 32;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).uName[3] = 32;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).uName[4] = 32;
                                ((SolarSystemCanvas320)SolarSystemCanvas320.this).uName[5] = 32;
                                SolarSystemCanvas320.this.takeInput = true;
                                SolarSystemCanvas320.this.gameState = 5;
                                SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenHeight - 20);
                                SolarSystemCanvas320.this.messageSprite.setFrame(0);
                                SolarSystemCanvas320.this.changeSelection = 0;
                                SolarSystemCanvas320.this.paused = false;
                            } else {
                                SolarSystemCanvas320.this.header.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenHeight / 2);
                                SolarSystemCanvas320.this.header.setFrame(1);
                                SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, 0);
                                SolarSystemCanvas320.this.messageSprite.setFrame(0);
                                this.names = null;
                                SolarSystemCanvas320.this.gameState = 2;
                                SolarSystemCanvas320.this.changeSelection = 0;
                                SolarSystemCanvas320.this.paused = false;
                            }
                        }
                        SolarSystemCanvas320.this.changeSelection = 0;
                        break;
                    }
                    case 11: {
                        ++this.traverseIndex;
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        if (this.traverseIndex < 20) {
                            for (int i = 5; i >= 0; --i) {
                                for (int j = 5; j >= 0; --j) {
                                    int xx;
                                    int x = SolarSystemCanvas320.this.scarabs[i][j].getX();
                                    if (x < (xx = SolarSystemCanvas320.this.offsetX + i * 35)) {
                                        x += (xx - x) / 5 + 1;
                                    } else if (x > xx) {
                                        x -= (x - xx) / 5 + 1;
                                    }
                                    int y = SolarSystemCanvas320.this.scarabs[i][j].getY();
                                    int yy = SolarSystemCanvas320.this.offsetY + j * 35;
                                    if (y < yy) {
                                        y += (yy - y) / 5 + 1;
                                    } else if (y > yy) {
                                        y -= (y - yy) / 5 + 1;
                                    }
                                    SolarSystemCanvas320.this.scarabs[i][j].setPosition(x, y);
                                    SolarSystemCanvas320.this.scarabs[i][j].paint(SolarSystemCanvas320.this.g);
                                }
                            }
                            break;
                        }
                        if (this.traverseIndex == 20) {
                            for (int i = 5; i >= 0; --i) {
                                for (int j = 5; j >= 0; --j) {
                                    SolarSystemCanvas320.this.scarabs[i][j].setPosition(SolarSystemCanvas320.this.offsetX + i * 35, SolarSystemCanvas320.this.offsetY + j * 35);
                                    SolarSystemCanvas320.this.scarabs[i][j].paint(SolarSystemCanvas320.this.g);
                                }
                            }
                            break;
                        }
                        if (this.traverseIndex > 20 && this.traverseIndex < 27) {
                            for (int i = 5; i >= 0; --i) {
                                for (int j = 5; j >= 0; --j) {
                                    SolarSystemCanvas320.this.scarabs[i][j].paint(SolarSystemCanvas320.this.g);
                                    this.temp = SolarSystemCanvas320.this.layer.getCell(i, j);
                                    if (this.temp <= 0 || this.temp > 28) continue;
                                    SolarSystemCanvas320.this.layer.setCell(i, j, SolarSystemCanvas320.this.layer.getCell(i, j) - 4);
                                }
                            }
                            SolarSystemCanvas320.this.layer.paint(SolarSystemCanvas320.this.g);
                            break;
                        }
                        if (this.traverseIndex < 27) break;
                        SolarSystemCanvas320.this.levelFinishTime = (int)(System.currentTimeMillis() / 1000L) + SolarSystemCanvas320.this.LEVEL_TIME;
                        SolarSystemCanvas320.this.writeRMS(true);
                        SolarSystemCanvas320.this.player.setFrame(41);
                        SolarSystemCanvas320.this.gameState = 16;
                        break;
                    }
                    case 12: {
                        int j;
                        int i;
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        for (i = 5; i >= 0; --i) {
                            for (j = 5; j >= 0; --j) {
                                SolarSystemCanvas320.this.scarabs[i][j].paint(SolarSystemCanvas320.this.g);
                            }
                        }
                        ++this.traverseIndex;
                        if (this.traverseIndex < 7) {
                            SolarSystemCanvas320.this.layer.paint(SolarSystemCanvas320.this.g);
                            for (i = 5; i >= 0; --i) {
                                for (j = 5; j >= 0; --j) {
                                    if (SolarSystemCanvas320.this.layer.getCell(i, j) > 24) continue;
                                    SolarSystemCanvas320.this.layer.setCell(i, j, SolarSystemCanvas320.this.layer.getCell(i, j) + 4);
                                }
                            }
                            break;
                        }
                        if (this.traverseIndex >= 7 && this.traverseIndex <= 42) {
                            int k = SolarSystemCanvas320.this.random.nextInt();
                            k = Math.abs(k) % 36;
                            while (!SolarSystemCanvas320.this.scarabs[k / 6][k % 6].isVisible()) {
                                ++k;
                                k %= 36;
                            }
                            SolarSystemCanvas320.this.scarabs[k / 6][k % 6].setVisible(false);
                            break;
                        }
                        for (i = 5; i >= 0; --i) {
                            for (j = 5; j >= 0; --j) {
                                SolarSystemCanvas320.this.scarabs[i][j].setVisible(true);
                            }
                        }
                        this.traverseIndex = 0;
                        SolarSystemCanvas320.this.header.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenHeight / 2);
                        SolarSystemCanvas320.this.header.setFrame(2);
                        SolarSystemCanvas320.this.messageSprite.setFrame(0);
                        SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, 0);
                        SolarSystemCanvas320.this.gameState = 8;
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        SolarSystemCanvas320.this.drawTranslucentRect(10, 70, 10, 7);
                        SolarSystemCanvas320.this.changeSelection = 0;
                        this.temp = this.timeBonus / 20;
                        SolarSystemCanvas320.this.getKeyStates();
                        SolarSystemCanvas320.this.changeSelection = 0;
                        break;
                    }
                    case 8: {
                        if (SolarSystemCanvas320.this.soundVolume > 0 && SolarSystemCanvas320.this.musicPlayer[0].getState() != 400) {
                            try {
                                SolarSystemCanvas320.this.musicPlayer[0].start();
                            }
                            catch (MediaException ex) {
                                ex.printStackTrace();
                            }
                        }
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        int x = SolarSystemCanvas320.this.header.getRefPixelX();
                        int xx = SolarSystemCanvas320.this.screenWidth / 2;
                        if (x < xx) {
                            x += (xx - x) / 5 + 1;
                        } else if (x > xx) {
                            x -= (x - xx) / 5 + 1;
                        }
                        int y = SolarSystemCanvas320.this.header.getRefPixelY();
                        int yy = SolarSystemCanvas320.this.offsetY + 20;
                        if (y < yy) {
                            y += (yy - y) / 5 + 1;
                        } else if (y > yy) {
                            y -= (y - yy) / 5 + 1;
                        }
                        SolarSystemCanvas320.this.header.setRefPixelPosition(x, y);
                        SolarSystemCanvas320.this.header.paint(SolarSystemCanvas320.this.g);
                        SolarSystemCanvas320.this.drawTranslucentRect(10, 110, 10, 8);
                        SolarSystemCanvas320.this.displayString("SCORE", 20, 120, false, false);
                        SolarSystemCanvas320.this.displayString("" + SolarSystemCanvas320.this.score, 20, 140, false, false);
                        SolarSystemCanvas320.this.displayString("TIME BONUS", 20, 180, false, false);
                        SolarSystemCanvas320.this.displayString("" + this.traverseIndex, 20, 200, false, false);
                        SolarSystemCanvas320.this.displayString("TOTAL", 20, 240, false, false);
                        SolarSystemCanvas320.this.displayString("" + (SolarSystemCanvas320.this.score + this.traverseIndex), 20, 260, false, false);
                        if (this.traverseIndex >= this.timeBonus) {
                            y = SolarSystemCanvas320.this.messageSprite.getRefPixelY();
                            if (y < (yy = SolarSystemCanvas320.this.screenHeight - 10)) {
                                y += (yy - y) / 5 + 1;
                            } else if (y > yy) {
                                y -= (y - yy) / 5 + 1;
                            }
                            SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, y);
                            SolarSystemCanvas320.this.messageSprite.paint(SolarSystemCanvas320.this.g);
                            if (y == yy && (SolarSystemCanvas320.this.getKeyStates() & 0x100) != 0) {
                                SolarSystemCanvas320.this.header.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenHeight / 2);
                                SolarSystemCanvas320.this.header.setFrame(1);
                                SolarSystemCanvas320.this.gameState = 9;
                                SolarSystemCanvas320.this.score += this.traverseIndex;
                                this.traverseIndex = 0;
                                this.temp = 0;
                                SolarSystemCanvas320.this.getKeyStates();
                                break;
                            }
                            SolarSystemCanvas320.this.getKeyStates();
                            break;
                        }
                        if (this.temp <= 0) {
                            ++this.traverseIndex;
                            break;
                        }
                        this.traverseIndex += this.temp;
                        break;
                    }
                    case 1: {
                        this.temp = 0;
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        if (!SolarSystemCanvas320.this.paused && SolarSystemCanvas320.this.menuType != 7) {
                            SolarSystemCanvas320.this.g.drawImage(this.titleImage, SolarSystemCanvas320.this.screenWidth / 2, 10, 17);
                        }
                        if (SolarSystemCanvas320.this.menuType == 7) {
                            int xx;
                            int x = SolarSystemCanvas320.this.messageSprite.getRefPixelX();
                            if (x < (xx = SolarSystemCanvas320.this.screenWidth / 2)) {
                                x += (xx - x) / 5 + 1;
                            } else if (x > xx) {
                                x -= (x - xx) / 5 + 1;
                            }
                            int y = SolarSystemCanvas320.this.messageSprite.getRefPixelY();
                            int yy = SolarSystemCanvas320.this.offsetY;
                            if (y < yy) {
                                y += (yy - y) / 5 + 1;
                            } else if (y > yy) {
                                y -= (y - yy) / 5 + 1;
                            }
                            SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(x, y);
                            if (SolarSystemCanvas320.this.confirmNewGameStart || SolarSystemCanvas320.this.confirmDifficultyChange) {
                                if (this.lose == null) {
                                    try {
                                        this.lose = Image.createImage((String)"/lose.png");
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                SolarSystemCanvas320.this.g.drawImage(this.lose, SolarSystemCanvas320.this.screenWidth / 2, 40, 17);
                            }
                            SolarSystemCanvas320.this.messageSprite.setFrame(1);
                            SolarSystemCanvas320.this.messageSprite.paint(SolarSystemCanvas320.this.g);
                        } else if (SolarSystemCanvas320.this.paused) {
                            int yy;
                            int y = SolarSystemCanvas320.this.messageSprite.getRefPixelY();
                            if (y < (yy = SolarSystemCanvas320.this.offsetY)) {
                                y += (yy - y) / 5 + 1;
                            } else if (y > yy) {
                                y -= (y - yy) / 5 + 1;
                            }
                            SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, y);
                            SolarSystemCanvas320.this.messageSprite.setFrame(2);
                            SolarSystemCanvas320.this.messageSprite.paint(SolarSystemCanvas320.this.g);
                        }
                        SolarSystemCanvas320.this.animateMainMenu();
                        break;
                    }
                    case 5: {
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        SolarSystemCanvas320.this.drawTranslucentRect(SolarSystemCanvas320.this.screenWidth / 2 - 80, SolarSystemCanvas320.this.screenHeight / 2 - 20, 7, 3);
                        SolarSystemCanvas320.this.g.setColor(0);
                        SolarSystemCanvas320.this.g.drawString("*** ENTER YOUR NAME ***", SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.offsetY, 17);
                        if (SolarSystemCanvas320.this.nameIndex > 0) {
                            SolarSystemCanvas320.this.messageSprite.paint(SolarSystemCanvas320.this.g);
                        }
                        SolarSystemCanvas320.this.displayString(new String(SolarSystemCanvas320.this.uName), SolarSystemCanvas320.this.screenWidth / 2 - 60, 160, true, false);
                        SolarSystemCanvas320.this.g.drawString("__", SolarSystemCanvas320.this.screenWidth / 2 - 60 + 20 * SolarSystemCanvas320.this.nameIndex, 180, 36);
                        if (SolarSystemCanvas320.this.takeInput) break;
                        SolarSystemCanvas320.this.updateHighScores();
                        SolarSystemCanvas320.this.takeInput = false;
                        SolarSystemCanvas320.this.header.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, SolarSystemCanvas320.this.screenHeight / 2);
                        SolarSystemCanvas320.this.header.setFrame(1);
                        SolarSystemCanvas320.this.messageSprite.setRefPixelPosition(SolarSystemCanvas320.this.screenWidth / 2, 0);
                        SolarSystemCanvas320.this.messageSprite.setFrame(0);
                        this.names = null;
                        SolarSystemCanvas320.this.gameState = 2;
                        SolarSystemCanvas320.this.changeSelection = 0;
                        break;
                    }
                    case 14: {
                        int j;
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        if (this.traverseIndex < 10) {
                            int i;
                            for (i = 5; i >= 0; --i) {
                                for (int j2 = 5; j2 >= 0; --j2) {
                                    SolarSystemCanvas320.this.scarabs[i][j2].paint(SolarSystemCanvas320.this.g);
                                }
                            }
                            SolarSystemCanvas320.this.layer.paint(SolarSystemCanvas320.this.g);
                            if (SolarSystemCanvas320.this.breakingColumnFlag) {
                                for (i = 0; i < 6; ++i) {
                                    SolarSystemCanvas320.this.layer.setCell(SolarSystemCanvas320.this.breakingIndex, i, SolarSystemCanvas320.this.cellIndex + this.traverseIndex * 4);
                                }
                            } else {
                                for (i = 0; i < 6; ++i) {
                                    SolarSystemCanvas320.this.layer.setCell(i, SolarSystemCanvas320.this.breakingIndex, SolarSystemCanvas320.this.cellIndex + this.traverseIndex * 4);
                                }
                            }
                            ++this.traverseIndex;
                            this.temp = 4;
                            break;
                        }
                        if (this.temp > 0) {
                            int i;
                            for (i = 5; i >= 0; --i) {
                                for (int j3 = 5; j3 >= 0; --j3) {
                                    SolarSystemCanvas320.this.scarabs[i][j3].paint(SolarSystemCanvas320.this.g);
                                }
                            }
                            SolarSystemCanvas320.this.layer.paint(SolarSystemCanvas320.this.g);
                            if (SolarSystemCanvas320.this.breakingColumnFlag) {
                                for (i = 0; i < 6; ++i) {
                                    SolarSystemCanvas320.this.layer.setCell(SolarSystemCanvas320.this.breakingIndex, i, SolarSystemCanvas320.this.cellIndex + this.temp * 4 + 20);
                                }
                            } else {
                                for (i = 0; i < 6; ++i) {
                                    SolarSystemCanvas320.this.layer.setCell(i, SolarSystemCanvas320.this.breakingIndex, SolarSystemCanvas320.this.cellIndex + this.temp * 4 + 20);
                                }
                            }
                            --this.temp;
                            break;
                        }
                        this.traverseIndex = 0;
                        SolarSystemCanvas320.this.moveVal = 0;
                        SolarSystemCanvas320.this.score += SolarSystemCanvas320.this.scoreArray[SolarSystemCanvas320.this.cellIndex - 1] * 6;
                        SolarSystemCanvas320.this.made++;
                        if (SolarSystemCanvas320.this.currentLevel == SolarSystemCanvas320.this.made - 1) {
                            try {
                                SolarSystemCanvas320.this.musicPlayer[3].stop();
                            }
                            catch (MediaException ex) {
                                ex.printStackTrace();
                            }
                            if (SolarSystemCanvas320.this.soundVolume > 0) {
                                try {
                                    SolarSystemCanvas320.this.musicPlayer[0].start();
                                }
                                catch (MediaException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            SolarSystemCanvas320.this.gameState = 12;
                            this.timeBonus = (int)((long)SolarSystemCanvas320.this.levelFinishTime - System.currentTimeMillis() / 1000L);
                            this.timeBonus *= 3;
                            this.timeBonus += this.timeBonus * SolarSystemCanvas320.this.difficulty / 2;
                            SolarSystemCanvas320.this.levelCompleted = true;
                            SolarSystemCanvas320.this.writeRMS(true);
                            break;
                        }
                        for (j = 0; j < 6; ++j) {
                            ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingCells[j] = Math.abs(SolarSystemCanvas320.this.random.nextInt() % SolarSystemCanvas320.this.types_OF_CELLS);
                        }
                        if (SolarSystemCanvas320.this.shiftingCells[0] == 0) {
                            int[] nArray = SolarSystemCanvas320.this.shiftingCells;
                            nArray[0] = nArray[0] + 1;
                        } else {
                            int[] nArray = SolarSystemCanvas320.this.shiftingCells;
                            nArray[0] = nArray[0] - 1;
                        }
                        SolarSystemCanvas320.this.gameState = 15;
                        if (SolarSystemCanvas320.this.breakingColumnFlag) {
                            switch (SolarSystemCanvas320.this.breakingIndex) {
                                case 2: {
                                    for (j = 0; j < 6; ++j) {
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][j] = SolarSystemCanvas320.this.layer.getCell(1, j) - 1;
                                    }
                                    SolarSystemCanvas320.this.layer.fillCells(1, 0, 1, 6, 0);
                                }
                                case 1: {
                                    for (j = 0; j < 6; ++j) {
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][j] = SolarSystemCanvas320.this.layer.getCell(0, j) - 1;
                                    }
                                    SolarSystemCanvas320.this.layer.fillCells(0, 0, 1, 6, 0);
                                    break;
                                }
                                case 3: {
                                    for (j = 0; j < 6; ++j) {
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][j] = SolarSystemCanvas320.this.layer.getCell(4, j) - 1;
                                    }
                                    SolarSystemCanvas320.this.layer.fillCells(4, 0, 1, 6, 0);
                                }
                                case 4: {
                                    for (j = 0; j < 6; ++j) {
                                        ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][j] = SolarSystemCanvas320.this.layer.getCell(5, j) - 1;
                                    }
                                    SolarSystemCanvas320.this.layer.fillCells(5, 0, 1, 6, 0);
                                }
                            }
                            SolarSystemCanvas320.this.layer.fillCells(SolarSystemCanvas320.this.breakingIndex, 0, 1, 6, 0);
                            break;
                        }
                        switch (SolarSystemCanvas320.this.breakingIndex) {
                            case 2: {
                                for (j = 0; j < 6; ++j) {
                                    ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][j] = SolarSystemCanvas320.this.layer.getCell(j, 1) - 1;
                                }
                                SolarSystemCanvas320.this.layer.fillCells(0, 1, 6, 1, 0);
                            }
                            case 1: {
                                for (j = 0; j < 6; ++j) {
                                    ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][j] = SolarSystemCanvas320.this.layer.getCell(j, 0) - 1;
                                }
                                SolarSystemCanvas320.this.layer.fillCells(0, 0, 6, 1, 0);
                                break;
                            }
                            case 3: {
                                for (j = 0; j < 6; ++j) {
                                    ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[1][j] = SolarSystemCanvas320.this.layer.getCell(j, 4) - 1;
                                }
                                SolarSystemCanvas320.this.layer.fillCells(0, 4, 6, 1, 0);
                            }
                            case 4: {
                                for (j = 0; j < 6; ++j) {
                                    ((SolarSystemCanvas320)SolarSystemCanvas320.this).shiftingBlock[0][j] = SolarSystemCanvas320.this.layer.getCell(j, 5) - 1;
                                }
                                SolarSystemCanvas320.this.layer.fillCells(0, 5, 6, 1, 0);
                            }
                        }
                        SolarSystemCanvas320.this.layer.fillCells(0, SolarSystemCanvas320.this.breakingIndex, 6, 1, 0);
                        break;
                    }
                    case 15: {
                        int j;
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        for (int i = 5; i >= 0; --i) {
                            for (j = 5; j >= 0; --j) {
                                SolarSystemCanvas320.this.scarabs[i][j].paint(SolarSystemCanvas320.this.g);
                            }
                        }
                        SolarSystemCanvas320.this.layer.paint(SolarSystemCanvas320.this.g);
                        if (SolarSystemCanvas320.this.breakingColumnFlag) {
                            switch (SolarSystemCanvas320.this.breakingIndex) {
                                case 2: {
                                    SolarSystemCanvas320.this.selector.setTransform(5);
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[1][j] == -1) continue;
                                        SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingBlock[1][j]);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 35 + SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + j * 35);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                    }
                                }
                                case 1: {
                                    SolarSystemCanvas320.this.selector.setTransform(5);
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[0][j] == -1) continue;
                                        SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingBlock[0][j]);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + j * 35);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                    }
                                }
                                case 0: {
                                    SolarSystemCanvas320.this.selector.setTransform(5);
                                    for (j = 0; j < 6; ++j) {
                                        SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingCells[j]);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX - 35 + SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + j * 35);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                    }
                                    break;
                                }
                                case 3: {
                                    SolarSystemCanvas320.this.selector.setTransform(6);
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[1][j] == -1) continue;
                                        SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingBlock[1][j]);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 140 - SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + j * 35);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                    }
                                }
                                case 4: {
                                    SolarSystemCanvas320.this.selector.setTransform(6);
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[0][j] == -1) continue;
                                        SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingBlock[0][j]);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 175 - SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + j * 35);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                    }
                                }
                                case 5: {
                                    SolarSystemCanvas320.this.selector.setTransform(6);
                                    for (j = 0; j < 6; ++j) {
                                        SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingCells[j]);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + 210 - SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + j * 35);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                    }
                                    break;
                                }
                            }
                        } else {
                            switch (SolarSystemCanvas320.this.breakingIndex) {
                                case 2: {
                                    SolarSystemCanvas320.this.selector.setTransform(3);
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[1][j] == -1) continue;
                                        SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingBlock[1][j]);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + j * 35, SolarSystemCanvas320.this.offsetY + 35 + SolarSystemCanvas320.this.moveVal);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                    }
                                }
                                case 1: {
                                    SolarSystemCanvas320.this.selector.setTransform(3);
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[0][j] == -1) continue;
                                        SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingBlock[0][j]);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + j * 35, SolarSystemCanvas320.this.offsetY + SolarSystemCanvas320.this.moveVal);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                    }
                                }
                                case 0: {
                                    SolarSystemCanvas320.this.selector.setTransform(3);
                                    for (j = 0; j < 6; ++j) {
                                        SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingCells[j]);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + j * 35, SolarSystemCanvas320.this.offsetY - 35 + SolarSystemCanvas320.this.moveVal);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                    }
                                    break;
                                }
                                case 3: {
                                    SolarSystemCanvas320.this.selector.setTransform(0);
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[1][j] == -1) continue;
                                        SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingBlock[1][j]);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + j * 35, SolarSystemCanvas320.this.offsetY + 140 - SolarSystemCanvas320.this.moveVal);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                    }
                                }
                                case 4: {
                                    SolarSystemCanvas320.this.selector.setTransform(0);
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[0][j] == -1) continue;
                                        SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingBlock[0][j]);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + j * 35, SolarSystemCanvas320.this.offsetY + 175 - SolarSystemCanvas320.this.moveVal);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                    }
                                }
                                case 5: {
                                    SolarSystemCanvas320.this.selector.setTransform(0);
                                    for (j = 0; j < 6; ++j) {
                                        SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingCells[j]);
                                        SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + j * 35, SolarSystemCanvas320.this.offsetY + 210 - SolarSystemCanvas320.this.moveVal);
                                        SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                                    }
                                    break;
                                }
                            }
                        }
                        SolarSystemCanvas320.this.moveVal += 5;
                        if (SolarSystemCanvas320.this.moveVal < 35) break;
                        if (SolarSystemCanvas320.this.breakingColumnFlag) {
                            switch (SolarSystemCanvas320.this.breakingIndex) {
                                case 2: {
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[1][j] == -1) continue;
                                        SolarSystemCanvas320.this.layer.setCell(2, j, SolarSystemCanvas320.this.shiftingBlock[1][j] + 1);
                                    }
                                }
                                case 1: {
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[0][j] == -1) continue;
                                        SolarSystemCanvas320.this.layer.setCell(1, j, SolarSystemCanvas320.this.shiftingBlock[0][j] + 1);
                                    }
                                }
                                case 0: {
                                    for (j = 0; j < 6; ++j) {
                                        SolarSystemCanvas320.this.layer.setCell(0, j, SolarSystemCanvas320.this.shiftingCells[j] + 1);
                                    }
                                    break;
                                }
                                case 3: {
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[1][j] == -1) continue;
                                        SolarSystemCanvas320.this.layer.setCell(3, j, SolarSystemCanvas320.this.shiftingBlock[1][j] + 1);
                                    }
                                }
                                case 4: {
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[0][j] == -1) continue;
                                        SolarSystemCanvas320.this.layer.setCell(4, j, SolarSystemCanvas320.this.shiftingBlock[0][j] + 1);
                                    }
                                }
                                case 5: {
                                    for (j = 0; j < 6; ++j) {
                                        SolarSystemCanvas320.this.layer.setCell(5, j, SolarSystemCanvas320.this.shiftingCells[j] + 1);
                                    }
                                    break;
                                }
                            }
                        } else {
                            switch (SolarSystemCanvas320.this.breakingIndex) {
                                case 2: {
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[1][j] == -1) continue;
                                        SolarSystemCanvas320.this.layer.setCell(j, 2, SolarSystemCanvas320.this.shiftingBlock[1][j] + 1);
                                    }
                                }
                                case 1: {
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[0][j] == -1) continue;
                                        SolarSystemCanvas320.this.layer.setCell(j, 1, SolarSystemCanvas320.this.shiftingBlock[0][j] + 1);
                                    }
                                }
                                case 0: {
                                    for (j = 0; j < 6; ++j) {
                                        SolarSystemCanvas320.this.layer.setCell(j, 0, SolarSystemCanvas320.this.shiftingCells[j] + 1);
                                    }
                                    break;
                                }
                                case 3: {
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[1][j] == -1) continue;
                                        SolarSystemCanvas320.this.layer.setCell(j, 3, SolarSystemCanvas320.this.shiftingBlock[1][j] + 1);
                                    }
                                }
                                case 4: {
                                    for (j = 0; j < 6; ++j) {
                                        if (SolarSystemCanvas320.this.shiftingBlock[0][j] == -1) continue;
                                        SolarSystemCanvas320.this.layer.setCell(j, 4, SolarSystemCanvas320.this.shiftingBlock[0][j] + 1);
                                    }
                                }
                                case 5: {
                                    for (j = 0; j < 6; ++j) {
                                        SolarSystemCanvas320.this.layer.setCell(j, 5, SolarSystemCanvas320.this.shiftingCells[j] + 1);
                                    }
                                    break;
                                }
                            }
                        }
                        SolarSystemCanvas320.this.moveVal = 0;
                        if (SolarSystemCanvas320.this.check()) {
                            SolarSystemCanvas320.this.gameState = 14;
                            break;
                        }
                        SolarSystemCanvas320.this.player.setFrame(41);
                        SolarSystemCanvas320.this.gameState = 16;
                        break;
                    }
                    case 13: {
                        int j;
                        SolarSystemCanvas320.this.backLayer.paint(SolarSystemCanvas320.this.g);
                        for (int i = 5; i >= 0; --i) {
                            for (j = 5; j >= 0; --j) {
                                SolarSystemCanvas320.this.scarabs[i][j].paint(SolarSystemCanvas320.this.g);
                            }
                        }
                        SolarSystemCanvas320.this.layer.paint(SolarSystemCanvas320.this.g);
                        if (SolarSystemCanvas320.this.currentColumn < SolarSystemCanvas320.this.empityColumn) {
                            SolarSystemCanvas320.this.selector.setTransform(5);
                            for (j = SolarSystemCanvas320.this.empityColumn - 1; j >= SolarSystemCanvas320.this.currentColumn; --j) {
                                SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingCells[j]);
                                SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + j * 35 + SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + SolarSystemCanvas320.this.currentRow * 35);
                                SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                            }
                        } else if (SolarSystemCanvas320.this.currentColumn > SolarSystemCanvas320.this.empityColumn) {
                            SolarSystemCanvas320.this.selector.setTransform(6);
                            for (j = SolarSystemCanvas320.this.empityColumn + 1; j <= SolarSystemCanvas320.this.currentColumn; ++j) {
                                SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingCells[j]);
                                SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + j * 35 - SolarSystemCanvas320.this.moveVal, SolarSystemCanvas320.this.offsetY + SolarSystemCanvas320.this.currentRow * 35);
                                SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                            }
                        } else if (SolarSystemCanvas320.this.currentRow < SolarSystemCanvas320.this.empityRow) {
                            SolarSystemCanvas320.this.selector.setTransform(3);
                            for (j = SolarSystemCanvas320.this.empityRow - 1; j >= SolarSystemCanvas320.this.currentRow; --j) {
                                SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingCells[j]);
                                SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + SolarSystemCanvas320.this.currentColumn * 35, SolarSystemCanvas320.this.offsetY + j * 35 + SolarSystemCanvas320.this.moveVal);
                                SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                            }
                        } else if (SolarSystemCanvas320.this.currentRow > SolarSystemCanvas320.this.empityRow) {
                            SolarSystemCanvas320.this.selector.setTransform(0);
                            for (j = SolarSystemCanvas320.this.empityRow + 1; j <= SolarSystemCanvas320.this.currentRow; ++j) {
                                SolarSystemCanvas320.this.selector.setFrame(SolarSystemCanvas320.this.shiftingCells[j]);
                                SolarSystemCanvas320.this.selector.setPosition(SolarSystemCanvas320.this.offsetX + SolarSystemCanvas320.this.currentColumn * 35, SolarSystemCanvas320.this.offsetY + j * 35 - SolarSystemCanvas320.this.moveVal);
                                SolarSystemCanvas320.this.selector.paint(SolarSystemCanvas320.this.g);
                            }
                        }
                        SolarSystemCanvas320.this.moveVal += 5;
                        if (SolarSystemCanvas320.this.moveVal < 35) break;
                        SolarSystemCanvas320.this.shiftCells();
                        this.traverseIndex = 0;
                        SolarSystemCanvas320.this.moveVal = 0;
                        if (SolarSystemCanvas320.this.check()) {
                            SolarSystemCanvas320.this.gameState = 14;
                            break;
                        }
                        SolarSystemCanvas320.this.player.setFrame(41);
                        SolarSystemCanvas320.this.gameState = 16;
                        break;
                    }
                    default: {
                        SolarSystemCanvas320.this.gameState = 3;
                    }
                }
                if (SolarSystemCanvas320.this.gameState >= 13) {
                    SolarSystemCanvas320.this.drawTranslucentRect(0, 0, 11, 3);
                    SolarSystemCanvas320.this.displayString("SCORE" + SolarSystemCanvas320.this.score, 0, 30, false, false);
                    SolarSystemCanvas320.this.displayString("TOGO" + (SolarSystemCanvas320.this.currentLevel + 1 - SolarSystemCanvas320.this.made), 0, 4, false, false);
                    if (SolarSystemCanvas320.this.currentLevel > 300) {
                        int tx = (int)((long)SolarSystemCanvas320.this.levelFinishTime - System.currentTimeMillis() / 1000L);
                        if (tx < 0) {
                            SolarSystemCanvas320.this.displayString("TIME0", 0, 55, false, false);
                        } else {
                            SolarSystemCanvas320.this.displayString("TIME" + tx, 0, 55, false, false);
                        }
                    } else {
                        int tx = (int)((long)SolarSystemCanvas320.this.levelFinishTime - System.currentTimeMillis() / 1000L);
                        if (tx < 0) {
                            SolarSystemCanvas320.this.displayString("TIMELEFT0", 0, 55, false, false);
                        } else {
                            SolarSystemCanvas320.this.displayString("TIMELEFT" + tx, 0, 55, false, false);
                        }
                    }
                }
                SolarSystemCanvas320.this.flushGraphics();
            } else {
                this.cancel();
            }
        }
    }
}

