/*
 * Decompiled with CFR 0.152.
 */
package mainPackage;

import applicationPackage.CollisionHandler;
import applicationPackage.EnviromentGenerator;
import applicationPackage.GameController;
import applicationPackage.LevelCreator;
import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBGameCanvas;
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import domainPackage.Location;
import domainPackage.UserPlane;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import mainPackage.AirCombat;
import mainPackage.LevelCompleteCanvas;
import mainPackage.SoundCheckScreen;
import mainPackage.WorldWarProcessor;

public class WorldWarCanvas
extends JBGameCanvas
implements Runnable {
    public static boolean startScreen;
    public static boolean bossDead;
    public static boolean sameLevel;
    public static int planeState;
    public static int currentLevel;
    public static long clearLayersTime;
    public static long createLayersTime;
    public static LevelCreator levelCreator;
    public static AirCombat mainMidlet;
    public Sprite backGroundSprite;
    private int b;
    private final Image[] c;
    private final Image[] d;
    private WorldWarProcessor e;
    private Location f;
    private TiledLayer g;
    private TiledLayer h;
    private Graphics i;

    public WorldWarCanvas(AirCombat airCombat) {
        int n;
        this.setFullScreenMode(true);
        mainMidlet = airCombat;
        levelCreator = new LevelCreator();
        this.b = 50;
        currentLevel = 0;
        planeState = 0;
        bossDead = false;
        sameLevel = false;
        startScreen = false;
        this.c = new Image[10];
        for (n = 9; n >= 0; --n) {
            this.c[n] = JBManager.getInstance().getTextImage(Integer.toString(n), "font-oyun");
        }
        this.d = new Image[10];
        for (n = 9; n >= 0; --n) {
            this.d[n] = JBManager.getInstance().getTextImage(Integer.toString(n), "font-score");
        }
        this.i = this.getGraphics();
        this.initializeProcessor();
        KeyCodeAdapter.getInstance().setCanvas((Canvas)this);
    }

    public void paintBackGround(Graphics graphics) {
        EnviromentGenerator.getInstance().managerGroundParticle.paint(graphics, 0, 20);
    }

    public void paintGroundEnemy(Graphics object) {
        try {
            this.renderGroundEnemy((Graphics)object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void paintCloudFirstLayer(Graphics graphics) {
        for (int i = GameController.getInstance().cloudListFirstLayer.getNoItems() - 1; i >= 0; --i) {
            GameController.getInstance().cloudListFirstLayer.retrieveCloud(i).getUnitSprite().paint(graphics);
        }
    }

    public void paintPlayerShadow(Graphics graphics) {
        GameController.getInstance().userShadow.getUnitSprite().paint(graphics);
    }

    public void paintAirEnemy(Graphics object) {
        try {
            this.renderAirEnemy((Graphics)object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void paintFire(Graphics graphics) {
        GameController.getInstance().managerEnemyFire.paint(graphics, 0, 20);
        GameController.getInstance().managerUserFire.paint(graphics, 0, 20);
        if (CollisionHandler.getExplosionSprite() != null) {
            CollisionHandler.getExplosionSprite().paint(graphics);
        }
        if (CollisionHandler.getExplosionBossSprite() != null) {
            CollisionHandler.getExplosionBossSprite().paint(graphics);
        }
        if (CollisionHandler.getExplosionUserSprite() != null) {
            CollisionHandler.getExplosionUserSprite().paint(graphics);
        }
    }

    public void paintPlayer(Graphics object) {
        try {
            this.renderPlayer((Graphics)object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void paintCloudSecondLayer(Graphics graphics) {
        for (int i = GameController.getInstance().cloudListSecondLayer.getNoItems() - 1; i >= 0; --i) {
            GameController.getInstance().cloudListSecondLayer.retrieveCloud(i).getUnitSprite().paint(graphics);
        }
    }

    public void paintScreen(Graphics object) {
        try {
            object.drawImage(GameController.getInstance().barImage1, 0, 0, 0);
            this.renderGamePlayBars();
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void paintAll() {
        this.paintBackGround(this.i);
        this.paintGroundEnemy(this.i);
        this.paintCloudFirstLayer(this.i);
        this.paintPlayerShadow(this.i);
        this.paintAirEnemy(this.i);
        this.paintFire(this.i);
        this.paintPlayer(this.i);
        this.paintCloudSecondLayer(this.i);
        this.paintScreen(this.i);
    }

    public void renderGamePlayBars() {
        CollisionHandler.getInstance().getHitPointBar().paint(this.i);
        CollisionHandler.getInstance().getHealthBar().paint(this.i);
        CollisionHandler.getInstance().getBonusBar().paint(this.i);
        String string = Integer.toString(CollisionHandler.getInstance().scorePoint);
        int n = 60;
        for (int i = 0; i < string.length(); ++i) {
            int n2 = Integer.parseInt(string.substring(i, i + 1));
            this.i.drawImage(this.d[n2], n, 7, 20);
            n += this.d[n2].getWidth();
        }
        UserPlane.getInstance().userPlaneRazor.paint(this.i);
        UserPlane.getInstance().userRadar.paint(this.i);
    }

    public void renderPlayer(Graphics graphics) {
        if (UserPlane.getInstance() != null) {
            int n;
            for (n = 0; n < 4; ++n) {
                ((Sprite)UserPlane.getInstance().smokeFrames1.elementAt(n)).paint(graphics);
            }
            for (n = 0; n < 4; ++n) {
                ((Sprite)UserPlane.getInstance().smokeFrames2.elementAt(n)).paint(graphics);
            }
            UserPlane.getInstance().getUnitSprite().paint(graphics);
            UserPlane.getInstance().userPlaneFireEffect1.paint(graphics);
            UserPlane.getInstance().userPlaneFireEffect2.paint(graphics);
        }
    }

    public void renderGroundEnemy(Graphics graphics) {
        GameController.getInstance().managerGroundPlane.paint(graphics, 0, 20);
        GameController.getInstance().managerBonusPlane.paint(graphics, 0, 20);
    }

    public void renderAirEnemy(Graphics graphics) {
        GameController.getInstance().managerBossPlane.paint(graphics, 0, 20);
        GameController.getInstance().managerEnemyPlane.paint(graphics, 0, 20);
    }

    public void adjustGamePlayBars() {
        CollisionHandler.getInstance().hitPointBar.setLocation(190, 18);
        CollisionHandler.getInstance().hitPointBar.setSize(44, 6);
        CollisionHandler.getInstance().hitPointBar.setVisible(true);
        CollisionHandler.getInstance().healthBar.setLocation(160, 16);
        CollisionHandler.getInstance().bonusBar.setLocation(195, 8);
        UserPlane.getInstance().userRadar.setPosition(8, 1);
    }

    public void checkKeys(int n) {
        this.e.a = this.getKeyStates();
    }

    public void keyPressed(int n) {
        this.e.b = KeyCodeAdapter.getInstance().adoptKeyCode(n);
    }

    public void createLayers() {
        long l = System.currentTimeMillis();
        this.g = EnviromentGenerator.getInstance().createBackGroundBoard();
        this.h = EnviromentGenerator.getInstance().createGroundParticleBoard(EnviromentGenerator.getInstance().createGroundParticleMap(EnviromentGenerator.getInstance().groundLayerIndex, LevelCreator.getCurrentLevel()));
        if (EnviromentGenerator.getInstance().managerBackGround == null && EnviromentGenerator.getInstance().managerGroundParticle == null) {
            EnviromentGenerator.getInstance().createBackGroundManagers();
        }
        EnviromentGenerator.getInstance().managerBackGround.append((Layer)this.g);
        EnviromentGenerator.getInstance().managerGroundParticle.append((Layer)this.h);
        this.adjustGamePlayBars();
        createLayersTime = System.currentTimeMillis() - l;
    }

    public void clearLayers() {
        int n;
        long l = System.currentTimeMillis();
        if (EnviromentGenerator.getInstance().managerBackGround != null && EnviromentGenerator.getInstance().managerGroundParticle != null) {
            for (n = EnviromentGenerator.getInstance().managerBackGround.getSize() - 1; n >= 0; --n) {
                EnviromentGenerator.getInstance().managerBackGround.remove(EnviromentGenerator.getInstance().managerBackGround.getLayerAt(n));
            }
            for (n = EnviromentGenerator.getInstance().managerGroundParticle.getSize() - 1; n >= 0; --n) {
                EnviromentGenerator.getInstance().managerGroundParticle.remove(EnviromentGenerator.getInstance().managerGroundParticle.getLayerAt(n));
            }
        }
        for (n = GameController.getInstance().managerBossPlane.getSize() - 1; n >= 0; --n) {
            GameController.getInstance().managerBossPlane.remove(GameController.getInstance().managerBossPlane.getLayerAt(n));
        }
        for (n = GameController.getInstance().managerEnemyPlane.getSize() - 1; n >= 0; --n) {
            GameController.getInstance().managerEnemyPlane.remove(GameController.getInstance().managerEnemyPlane.getLayerAt(n));
        }
        for (n = GameController.getInstance().managerGroundPlane.getSize() - 1; n >= 0; --n) {
            GameController.getInstance().managerGroundPlane.remove(GameController.getInstance().managerGroundPlane.getLayerAt(n));
        }
        for (n = GameController.getInstance().managerBonusPlane.getSize() - 1; n >= 0; --n) {
            GameController.getInstance().managerBonusPlane.remove(GameController.getInstance().managerBonusPlane.getLayerAt(n));
        }
        for (n = GameController.getInstance().managerEnemyFire.getSize() - 1; n >= 0; --n) {
            GameController.getInstance().managerEnemyFire.remove(GameController.getInstance().managerEnemyFire.getLayerAt(n));
        }
        for (n = GameController.getInstance().managerUserFire.getSize() - 1; n >= 0; --n) {
            GameController.getInstance().managerUserFire.remove(GameController.getInstance().managerUserFire.getLayerAt(n));
        }
        for (n = GameController.getInstance().enemyPlaneList.getNoItems() - 1; n >= 0; --n) {
            GameController.getInstance().enemyPlaneList.retrieveEnemyPlane(n).getTimer().cancel();
            GameController.getInstance().enemyPlaneList.deleteEnemyPlaneByIndex(n);
        }
        for (n = GameController.getInstance().groundUnitList.getNoItems() - 1; n >= 0; --n) {
            GameController.getInstance().groundUnitList.retrieveGroundUnit(n).getTimer().cancel();
            GameController.getInstance().groundUnitList.deleteGroundUnitIndex(n);
        }
        for (n = GameController.getInstance().bossPlaneList.getNoItems() - 1; n >= 0; --n) {
            GameController.getInstance().bossPlaneList.retrieveBossUnit(n).getTimer().cancel();
            GameController.getInstance().bossPlaneList.deleteBossIndex(n);
        }
        for (n = GameController.getInstance().bonusList.getNoItems() - 1; n >= 0; --n) {
            GameController.getInstance().bonusList.deleteBonusByIndex(n);
        }
        for (n = GameController.getInstance().UserFireList.getNoItems() - 1; n >= 0; --n) {
            GameController.getInstance().UserFireList.deleteFireIndex(n);
        }
        for (n = GameController.getInstance().EnemyFireList.getNoItems() - 1; n >= 0; --n) {
            GameController.getInstance().EnemyFireList.deleteFireIndex(n);
        }
        for (n = GameController.getInstance().cloudListFirstLayer.getNoItems() - 1; n >= 0; --n) {
            GameController.getInstance().cloudListFirstLayer.deleteCloudByIndex(n);
        }
        for (n = GameController.getInstance().cloudListSecondLayer.getNoItems() - 1; n >= 0; --n) {
            GameController.getInstance().cloudListSecondLayer.deleteCloudByIndex(n);
        }
        EnviromentGenerator.getInstance().groundLayerIndex = 10;
        EnviromentGenerator.getInstance().groundUnitLayerIndex = 10;
        CollisionHandler.getInstance().clearAnimationTimers();
        UserPlane.getInstance().setDefense(100);
        UserPlane.getInstance().setHealth(UserPlane.getInstance().getHealth());
        CollisionHandler.getInstance().getHitPointBar().setValue(100);
        CollisionHandler.getInstance().getHealthBar().setValue(UserPlane.getInstance().getHealth());
        CollisionHandler.getInstance().getBonusBar().setValue(0);
        UserPlane.getInstance().weaponOverHeat = 0;
        this.f = new Location(120 - UserPlane.getInstance().getUnitSprite().getWidth() / 2, 320 - UserPlane.getInstance().getUnitSprite().getHeight(), UserPlane.getInstance().getUnitSprite().getWidth(), UserPlane.getInstance().getUnitSprite().getHeight());
        UserPlane.getInstance().setLocation(this.f, UserPlane.getInstance().getUnitSprite());
        clearLayersTime = System.currentTimeMillis() - l;
    }

    public void clearManagers() {
        EnviromentGenerator.getInstance().managerBackGround = null;
        EnviromentGenerator.getInstance().managerGroundParticle = null;
        this.g = null;
        this.h = null;
    }

    public void initializeProcessor() {
        if (this.e != null) {
            this.e.killThread = true;
        }
        this.e = new WorldWarProcessor();
        this.e.start();
    }

    private boolean a() {
        if (CollisionHandler.getInstance().isUserDead() || bossDead && LevelCreator.getCurrentLevel() == 8) {
            JBManager.getInstance().gameSettings.putAndSave("score:mylast", Integer.toString(CollisionHandler.getInstance().scorePoint));
            try {
                if (Integer.parseInt(JBManager.getInstance().gameSettings.get("score:mytop")) < CollisionHandler.getInstance().scorePoint) {
                    JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(CollisionHandler.getInstance().scorePoint));
                }
            }
            catch (Exception exception) {
                JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(CollisionHandler.getInstance().scorePoint));
            }
            JBManager.getInstance().gameSettings.remove("lastLevel");
            JBManager.getInstance().gameSettings.remove("lastScore");
            mainMidlet.openPauseMenu();
            JBManager.getInstance().addAction(new JBAction(this, "TOP:T0"));
            mainMidlet.d();
            return true;
        }
        return false;
    }

    public void executeGame() {
        while (AirCombat.isRunning && !bossDead && !CollisionHandler.getInstance().isUserDead() && !AirCombat.restartApp) {
            long l = System.currentTimeMillis();
            if (!AirCombat.pauseApp) {
                if (UserPlane.getInstance().getDefence() > 0) {
                    this.checkKeys(this.getKeyStates());
                }
                this.paintAll();
                this.flushGraphics();
            }
            try {
                Thread.sleep(Math.max(0L, (long)this.b - System.currentTimeMillis() + l));
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
                interruptedException.printStackTrace();
            }
        }
    }

    public void run() {
        while (AirCombat.startApp && !this.a()) {
            IOException iOException;
            Runnable runnable;
            if (LevelCreator.getCurrentLevel() == 0 && !CollisionHandler.getInstance().isUserDead()) {
                runnable = null;
                startScreen = true;
                try {
                    runnable = new SoundCheckScreen(mainMidlet);
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    iOException2.printStackTrace();
                }
                ((SoundCheckScreen)runnable).show();
                ((SoundCheckScreen)runnable).joinThread();
            }
            LevelCreator.setCurrentLevel(currentLevel);
            this.executeGame();
            if (!bossDead || LevelCreator.getCurrentLevel() == 8) continue;
            runnable = null;
            try {
                runnable = new LevelCompleteCanvas(mainMidlet, true, 3);
            }
            catch (IOException iOException3) {
                iOException = iOException3;
                iOException3.printStackTrace();
            }
            ((LevelCompleteCanvas)runnable).start();
            ((LevelCompleteCanvas)runnable).joinThread();
            ++currentLevel;
        }
    }
}

