/*
 * Decompiled with CFR 0.152.
 */
package sandeep.rz2.jumpingjack;

import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStore;
import sandeep.rz2.jumpingjack.FroggerQuest128;

public class FroggerQuestCanvas128
extends GameCanvas {
    private boolean paused;
    private boolean vibrations;
    private boolean confirmNewGameStart;
    private int soundVolume;
    private int changeSelection;
    private Graphics g;
    boolean soundsOn;
    private Sprite player;
    private int currentLevel;
    private int iv_islandsCleared = 0;
    private int offsetX;
    private int offsetY;
    public static int screenWidth = 128;
    public static int screenHeight = 128;
    private static int FRAME_SIZE = 15;
    private static int COLUMNS = 8;
    private static int ROWS = 8;
    private int traverseIndex;
    private int currentColumn;
    private int currentRow;
    private Timer timer;
    private TiledLayer board;
    private int[] downFrameSequence = new int[]{0, 1, 2, 3};
    private int[] leftFrameSequence = new int[]{4, 5, 6, 7};
    private int[] rightFrameSequence = new int[]{8, 9, 10, 11};
    private int[] upFrameSequence = new int[]{12, 13, 14, 15};
    private int[] playerFallingFrameSequence = new int[]{20, 20, 21, 21, 22, 22, 23, 23};
    private int gameState;
    private int playerState;
    private int pDirection;
    private int deltaJump;
    public static final int PS_IDLE_STATE = 0;
    public static final int PS_WALKING_STATE = 1;
    public static final int PS_FALLING_STATE = 2;
    public static final int PS_JUMPING_STATE = 2;
    public static final int DOWN_DIRECTION = 0;
    public static final int LEFT_DIRECTION = 1;
    public static final int RIGHT_DIRECTION = 2;
    public static final int UP_DIRECTION = 3;
    public static final int SPLASH_STATE = 0;
    public static final int ISLANDCLEARED_STATE = 1;
    public static final int MAP_STATE = 2;
    public static final int HELP_STATE = 3;
    public static final int MAINMENU_STATE = 4;
    public static final int ABOUT_STATE = 5;
    public static final int OPENING_CURTAIN_STATE = 8;
    public static final int PLAYING_STATE = 10;
    private static final int MOVESPEED = 5;
    private Sprite[][] blocks;
    private Image backImage;
    private Image titleImage;
    private Sprite fallingBlock;
    private Sprite arrowSprite;
    private Sprite flagSprite;
    private Sprite fontSprite;
    private static final int FONTSIZE = 12;
    private static int fWidth;
    private static final int SMALLFONTSIZE = 10;
    private Sprite dragonSprite;
    private int[] dragonX;
    private int[] dragonY;
    private int leftSelectorX;
    private int leftSelectorY;
    private int rightSelectorX;
    private int rightSelectorY;
    private int menuType;
    public int menuIndex;
    private String[] menuItems;
    private String[] mmenuItems = new String[]{"\u958b\u59cb", "\u9078\u64c7", "\u5e6b\u52a9", "\u9000\u51fa"};
    private String[] omenuItems = new String[]{"\u8072\u97f3", "\u632f\u52d5", "\u8a9e\u8a00", "\u8fd4\u56de"};
    private String[] soundsItems = new String[]{"\u95dc", "\u4f4e", "\u4e2d", "\u9ad8", "\u8fd4\u56de"};
    private String[] vibrationItems = new String[]{"\u958b", "\u95dc", "\u8fd4\u56de"};
    private String[] confirmationItems = new String[]{"\u5426", "\u662f"};
    private String[] pauseMenuItems = new String[]{"\u91cd\u65b0\u958b\u59cb", "\u8072\u97f3", "\u632f\u52d5", "\u96e2\u958b"};
    private String[] languageItems = new String[]{"\u7e41\u9ad4\u4e2d\u6587", "\u7c21\u9ad4\u4e2d\u6587", "\u82f1\u6587", "\u56de\u4e0a\u9801"};
    private String[] mmenuItems1 = new String[]{"\u5f00\u59cb", "\u9009\u62e9", "\u5e2e\u52a9", "\u9000\u51fa"};
    private String[] omenuItems1 = new String[]{"\u58f0\u97f3", "\u632f\u52a8", "\u8a9e\u8a00", "\u8fd4\u56de"};
    private String[] soundsItems1 = new String[]{"\u5173", "\u4f4e", "\u4e2d", "\u9ad8", "\u8fd4\u56de"};
    private String[] vibrationItems1 = new String[]{"\u5f00", "\u5173", "\u8fd4\u56de"};
    private String[] confirmationItems1 = new String[]{"\u5426", "\u662f"};
    private String[] pauseMenuItems1 = new String[]{"\u91cd\u65b0\u5f00\u59cb", "\u58f0\u97f3", "\u632f\u52a8", "\u79bb\u5f00"};
    private String[] languageItems1 = new String[]{"\u7e41\u4f53\u4e2d\u6587", "\u7b80\u4f53\u4e2d\u6587", "\u82f1\u6587", "\u56de"};
    private String[] mmenuItems2 = new String[]{"START", "OPTIONS", "HELP", "EXIT"};
    private String[] omenuItems2 = new String[]{"SOUNDS", "VIBRATE", "LANGUAGE", "BACK"};
    private String[] soundsItems2 = new String[]{"OFF", "LOW", "MEDIUM", "HIGH", "BACK"};
    private String[] vibrationItems2 = new String[]{"ON", "OFF", "BACK"};
    private String[] confirmationItems2 = new String[]{"NO", "YES"};
    private String[] pauseMenuItems2 = new String[]{"RESUME", "SOUNDS", "VIBRATE", "QUIT"};
    private String[] languageItems2 = new String[]{"TRADITIONAL", "SIMPLIFIED", "ENGLISH", "BACK"};
    public static final int MAIN_MENU = 0;
    public static final int PAUSE_MENU = 1;
    public static final int START_MENU = 2;
    public static final int OPTIONS_MENU = 3;
    public static final int SOUNDS_MENU = 4;
    public static final int VIBRATION_MENU = 5;
    public static final int CONFIRMATION_MENU = 7;
    static final int LANGUAGE_MENU = 8;
    static int language;
    private Font SMALLFONT;
    private Font SMALLULINEFONT;
    private Font BIGFONT;
    private int[][] lavaFrames;
    public static final int MAXFRAMES = 10;
    FroggerQuest128 midlet;
    private int unfoldingIndex = 0;
    private RecordStore rs;
    private byte[] rec = new byte[1];
    private static int seed;
    public static final int BACKGROUNDSOUND = 0;
    public static final int LEVELUPSOUND = 1;
    public static final int JUMPSOUND = 2;
    public static final int BREAKSOUND = 3;
    public static final int FALLSOUND = 4;
    public static Player[] musicPlayer;

    public FroggerQuestCanvas128(FroggerQuest128 midlet) {
        super(false);
        seed = (int)System.currentTimeMillis();
        this.g = this.getGraphics();
        this.setFullScreenMode(true);
        this.g.setColor(0);
        this.g.fillRect(0, 0, screenWidth, screenHeight);
        this.midlet = midlet;
        this.offsetY = 5;
        this.SMALLFONT = Font.getFont((int)0, (int)0, (int)8);
        this.SMALLULINEFONT = Font.getFont((int)0, (int)5, (int)8);
        this.BIGFONT = Font.getFont((int)0, (int)1, (int)16);
        this.loadText();
        this.lavaFrames = new int[6][8];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.lavaFrames[i][j] = Math.abs(FroggerQuestCanvas128.nextInt(10));
            }
        }
        try {
            this.menuItems = language == 0 ? this.mmenuItems : (language == 1 ? this.mmenuItems1 : this.mmenuItems2);
            this.player = new Sprite(Image.createImage((String)"/p.png"), FRAME_SIZE, 16);
            this.player.setFrameSequence(this.downFrameSequence);
            this.player.setFrameSequence(this.downFrameSequence);
            this.fallingBlock = new Sprite(Image.createImage((String)"/brick4.png"), FRAME_SIZE, FRAME_SIZE);
            this.fallingBlock.setVisible(false);
            this.arrowSprite = new Sprite(Image.createImage((String)"/pointer.png"), 6, 18);
            int[] arrowFSQ = new int[]{0, 1, 2, 1};
            this.arrowSprite.setFrameSequence(arrowFSQ);
            this.flagSprite = new Sprite(Image.createImage((String)"/flag.png"));
            this.fontSprite = new Sprite(Image.createImage((String)"/f22.png"), 12, 12);
            this.backImage = Image.createImage((String)"/lg.png");
        }
        catch (Exception e) {
            System.out.println("can't create MainMenu " + e);
        }
        this.initMedia();
        this.readRMS();
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        GameLoop gameLoop = new GameLoop();
        this.timer.schedule((TimerTask)gameLoop, 50L, 50L);
        this.arrowSprite.setPosition(gameLoop.levelX[this.currentLevel], gameLoop.levelY[this.currentLevel] - this.arrowSprite.getHeight());
    }

    public void stop() {
        this.timer.cancel();
        this.timer = null;
    }

    private void setPlayerIdleState() {
        this.playerState = 0;
        this.pDirection = 0;
        this.player.setFrameSequence(this.downFrameSequence);
    }

    public void input() {
        int lastColumn = this.currentColumn--;
        int lastRow = this.currentRow--;
        int states = this.changeSelection;
        this.changeSelection = 0;
        if (this.playerState == 0) {
            if ((states & 0x100) != 0) {
                if (this.soundVolume > 0) {
                    // empty if block
                }
                switch (this.pDirection) {
                    case 1: {
                        this.currentColumn -= 2;
                        break;
                    }
                    case 2: {
                        this.currentColumn += 2;
                        break;
                    }
                    case 3: {
                        this.currentRow -= 2;
                        break;
                    }
                    case 0: {
                        this.currentRow += 2;
                    }
                }
                this.playerState = 1;
                this.deltaJump = 8;
            } else if ((states & 2) != 0) {
                if (this.pDirection == 3) {
                    this.playerState = 1;
                    this.deltaJump = 4;
                } else {
                    this.pDirection = 3;
                    this.player.setFrameSequence(this.upFrameSequence);
                }
            } else if ((states & 0x40) != 0) {
                if (this.pDirection == 0) {
                    ++this.currentRow;
                    this.playerState = 1;
                    this.deltaJump = 4;
                } else {
                    this.pDirection = 0;
                    this.player.setFrameSequence(this.downFrameSequence);
                }
            } else if ((states & 4) != 0) {
                if (this.pDirection == 1) {
                    this.playerState = 1;
                    this.deltaJump = 4;
                } else {
                    this.pDirection = 1;
                    this.player.setFrameSequence(this.leftFrameSequence);
                }
            } else if ((states & 0x20) != 0) {
                if (this.pDirection == 2) {
                    ++this.currentColumn;
                    this.playerState = 1;
                    this.deltaJump = 4;
                } else {
                    this.pDirection = 2;
                    this.player.setFrameSequence(this.rightFrameSequence);
                }
            }
        } else if (this.playerState == 2) {
            this.fallingBlock.setPosition(this.fallingBlock.getX(), this.fallingBlock.getY() + FRAME_SIZE);
            this.fallingBlock.nextFrame();
            if (this.fallingBlock.getFrame() == 0) {
                this.fallingBlock.setVisible(false);
            }
            this.player.nextFrame();
            this.player.setPosition(this.player.getX() + this.deltaJump, this.player.getY() + FRAME_SIZE - 5);
            if (this.player.getFrame() == 0) {
                this.setPlayerIdleState();
                this.changeBackImage(2);
                this.gameState = 2;
            }
        } else {
            if (this.fallingBlock.isVisible()) {
                this.fallingBlock.setPosition(this.fallingBlock.getX(), this.fallingBlock.getY() + FRAME_SIZE);
                this.fallingBlock.nextFrame();
                if (this.fallingBlock.getFrame() == 0) {
                    this.fallingBlock.setVisible(false);
                }
            }
            this.player.nextFrame();
            switch (this.pDirection) {
                case 1: {
                    this.player.setPosition(this.player.getX() - this.deltaJump, this.player.getY());
                    break;
                }
                case 2: {
                    this.player.setPosition(this.player.getX() + this.deltaJump, this.player.getY());
                    break;
                }
                case 3: {
                    this.player.setPosition(this.player.getX(), this.player.getY() - this.deltaJump);
                    break;
                }
                case 0: {
                    this.player.setPosition(this.player.getX(), this.player.getY() + this.deltaJump);
                }
            }
            if (this.player.getFrame() == 0) {
                this.playerState = 0;
                this.player.setPosition(this.offsetX + this.currentColumn * FRAME_SIZE, this.offsetY + this.currentRow * FRAME_SIZE - 9);
                this.fallingBlock.setVisible(false);
                this.fallingBlock.setFrame(0);
            }
        }
        if (lastColumn == this.currentColumn && lastRow == this.currentRow) {
            return;
        }
        if (this.currentColumn < 0 || this.currentColumn > COLUMNS - 1 || this.currentRow < 0 || this.currentRow > ROWS - 1 || this.board.getCell(this.currentColumn, this.currentRow) == 0) {
            this.deltaJump = this.pDirection == 1 ? (this.deltaJump == 8 ? -6 : -3) : (this.pDirection == 2 ? (this.deltaJump == 8 ? 6 : 3) : 0);
            if (this.soundVolume > 0) {
                // empty if block
            }
            this.playerState = 2;
            this.player.setFrameSequence(this.playerFallingFrameSequence);
            if (this.vibrations) {
                this.midlet.vibra(1000);
            }
            this.blocks[lastColumn][lastRow].setVisible(false);
            this.fallingBlock.setVisible(true);
            this.fallingBlock.setPosition(this.offsetX + lastColumn * FRAME_SIZE, this.offsetY + lastRow * FRAME_SIZE - FRAME_SIZE / 2);
        } else {
            if (this.soundVolume > 0) {
                try {
                    musicPlayer[3].start();
                }
                catch (Exception ex) {
                    System.out.println("exx:" + ex);
                    ex.printStackTrace();
                }
            }
            this.board.setCell(lastColumn, lastRow, 0);
            this.blocks[lastColumn][lastRow].setVisible(false);
            this.fallingBlock.setVisible(true);
            this.fallingBlock.setPosition(this.offsetX + lastColumn * FRAME_SIZE, this.offsetY + lastRow * FRAME_SIZE - FRAME_SIZE / 2);
        }
    }

    private void displayString(String str, int y, boolean inFocus) {
        this.g.setFont(this.SMALLFONT);
        this.g.setColor(0);
        this.g.drawString(str, screenWidth / 2 - 1, y - 1, 0x10 | 1);
        this.g.drawString(str, screenWidth / 2 - 1, y + 1, 0x10 | 1);
        this.g.drawString(str, screenWidth / 2 + 1, y + 1, 0x10 | 1);
        this.g.drawString(str, screenWidth / 2 + 1, y - 1, 0x10 | 1);
        this.g.setColor(0xFFFF00);
        this.g.drawString(str, screenWidth / 2, y, 0x10 | 1);
    }

    public void levelState() {
        switch (this.currentLevel) {
            case 0: {
                this.currentColumn = 6;
                this.currentRow = 1;
                break;
            }
            case 1: {
                this.currentColumn = 5;
                this.currentRow = 2;
                break;
            }
            case 2: {
                this.currentColumn = 5;
                this.currentRow = 2;
                break;
            }
            case 3: {
                this.currentColumn = 0;
                this.currentRow = 2;
                break;
            }
            case 4: {
                this.currentColumn = 4;
                this.currentRow = 4;
                break;
            }
            case 5: {
                this.currentColumn = 5;
                this.currentRow = 3;
                break;
            }
            case 6: {
                this.currentColumn = 0;
                this.currentRow = 0;
                break;
            }
            case 7: {
                this.currentColumn = 1;
                this.currentRow = 0;
                break;
            }
            case 8: {
                this.currentColumn = 3;
                this.currentRow = 2;
                break;
            }
            case 9: {
                this.currentColumn = 6;
                this.currentRow = 0;
                break;
            }
            case 10: {
                this.currentColumn = 6;
                this.currentRow = 2;
                break;
            }
            case 11: {
                this.currentColumn = 6;
                this.currentRow = 1;
                break;
            }
            case 12: {
                this.currentColumn = 5;
                this.currentRow = 3;
                break;
            }
            case 13: {
                this.currentColumn = 4;
                this.currentRow = 2;
                break;
            }
            case 14: {
                this.currentColumn = 6;
                this.currentRow = 2;
                break;
            }
            case 15: {
                this.currentColumn = 6;
                this.currentRow = 2;
                break;
            }
            case 16: {
                this.currentColumn = 4;
                this.currentRow = 2;
                break;
            }
            case 17: {
                this.currentColumn = 4;
                this.currentRow = 2;
                break;
            }
            case 18: {
                this.currentColumn = 6;
                this.currentRow = 2;
                break;
            }
        }
        this.player.setPosition(this.offsetX + this.currentColumn * FRAME_SIZE, this.offsetY + this.currentRow * FRAME_SIZE - FRAME_SIZE / 2);
    }

    private void createBoard() {
        if (this.board == null) {
            try {
                Image image = Image.createImage((String)"/brick4.png");
                this.board = new TiledLayer(COLUMNS, ROWS, image, FRAME_SIZE, FRAME_SIZE);
                this.board.setPosition(this.offsetX, this.offsetY);
                this.blocks = new Sprite[COLUMNS][ROWS];
                for (int i = COLUMNS - 1; i >= 0; --i) {
                    for (int j = ROWS - 1; j >= 0; --j) {
                        this.blocks[i][j] = new Sprite(image, FRAME_SIZE, FRAME_SIZE);
                    }
                }
            }
            catch (IOException ioe) {
                System.out.println("Caught in creatboard : " + ioe);
            }
        }
        this.fallingBlock.setVisible(false);
        this.board.fillCells(0, 0, COLUMNS, ROWS, 0);
        switch (this.currentLevel) {
            case 0: {
                this.board.setCell(4, 0, 1);
                this.board.setCell(1, 1, 1);
                this.board.setCell(2, 1, 1);
                this.board.setCell(3, 1, 1);
                this.board.setCell(4, 1, 1);
                this.board.setCell(5, 1, 1);
                this.board.setCell(6, 1, 1);
                this.board.setCell(1, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(1, 3, 1);
                this.board.setCell(4, 3, 1);
                this.board.setCell(0, 4, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(5, 4, 1);
                this.board.setCell(6, 4, 1);
                this.board.setCell(0, 5, 1);
                this.board.setCell(6, 5, 1);
                this.board.setCell(0, 6, 1);
                this.board.setCell(1, 6, 1);
                this.board.setCell(2, 6, 1);
                this.board.setCell(3, 6, 1);
                this.board.setCell(4, 6, 1);
                this.board.setCell(5, 6, 1);
                this.board.setCell(6, 6, 1);
                break;
            }
            case 1: {
                this.board.setCell(0, 0, 1);
                this.board.setCell(0, 1, 1);
                this.board.setCell(1, 1, 1);
                this.board.setCell(2, 1, 1);
                this.board.setCell(3, 1, 1);
                this.board.setCell(4, 1, 1);
                this.board.setCell(0, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(5, 2, 1);
                this.board.setCell(6, 2, 1);
                this.board.setCell(0, 3, 1);
                this.board.setCell(0, 4, 1);
                this.board.setCell(2, 4, 1);
                this.board.setCell(3, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(3, 5, 1);
                this.board.setCell(0, 6, 1);
                this.board.setCell(1, 6, 1);
                this.board.setCell(2, 6, 1);
                this.board.setCell(3, 6, 1);
                break;
            }
            case 2: {
                this.board.setCell(5, 0, 1);
                this.board.setCell(2, 1, 1);
                this.board.setCell(4, 1, 1);
                this.board.setCell(5, 1, 1);
                this.board.setCell(6, 1, 1);
                this.board.setCell(5, 2, 1);
                this.board.setCell(2, 3, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(2, 4, 1);
                this.board.setCell(3, 4, 1);
                this.board.setCell(5, 4, 1);
                this.board.setCell(2, 5, 1);
                break;
            }
            case 3: {
                this.board.setCell(0, 0, 1);
                this.board.setCell(0, 1, 1);
                this.board.setCell(2, 1, 1);
                this.board.setCell(4, 1, 1);
                this.board.setCell(6, 1, 1);
                this.board.setCell(0, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(6, 2, 1);
                this.board.setCell(6, 3, 1);
                this.board.setCell(0, 4, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(2, 4, 1);
                this.board.setCell(4, 5, 1);
                this.board.setCell(5, 5, 1);
                this.board.setCell(6, 5, 1);
                this.board.setCell(2, 6, 1);
                this.board.setCell(3, 6, 1);
                this.board.setCell(4, 6, 1);
                this.board.setCell(5, 6, 1);
                this.board.setCell(6, 6, 1);
                break;
            }
            case 4: {
                this.board.setCell(2, 0, 1);
                this.board.setCell(2, 1, 1);
                this.board.setCell(1, 2, 1);
                this.board.setCell(2, 2, 1);
                this.board.setCell(3, 2, 1);
                this.board.setCell(2, 3, 1);
                this.board.setCell(4, 3, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(6, 4, 1);
                this.board.setCell(0, 5, 1);
                this.board.setCell(1, 5, 1);
                this.board.setCell(3, 5, 1);
                this.board.setCell(4, 5, 1);
                this.board.setCell(5, 5, 1);
                this.board.setCell(6, 5, 1);
                this.board.setCell(1, 6, 1);
                this.board.setCell(6, 6, 1);
                break;
            }
            case 5: {
                this.board.setCell(3, 0, 1);
                this.board.setCell(5, 0, 1);
                this.board.setCell(3, 1, 1);
                this.board.setCell(5, 2, 1);
                this.board.setCell(6, 2, 1);
                this.board.setCell(2, 3, 1);
                this.board.setCell(3, 3, 1);
                this.board.setCell(4, 3, 1);
                this.board.setCell(5, 3, 1);
                this.board.setCell(6, 4, 1);
                this.board.setCell(1, 5, 1);
                this.board.setCell(3, 5, 1);
                this.board.setCell(3, 6, 1);
                this.board.setCell(5, 6, 1);
                this.board.setCell(6, 6, 1);
                break;
            }
            case 6: {
                this.board.setCell(0, 0, 1);
                this.board.setCell(2, 0, 1);
                this.board.setCell(4, 0, 1);
                this.board.setCell(6, 0, 1);
                this.board.setCell(0, 2, 1);
                this.board.setCell(2, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(6, 2, 1);
                this.board.setCell(0, 4, 1);
                this.board.setCell(2, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(6, 4, 1);
                this.board.setCell(0, 6, 1);
                this.board.setCell(2, 6, 1);
                this.board.setCell(4, 6, 1);
                this.board.setCell(6, 6, 1);
                this.board.setCell(0, 7, 1);
                this.board.setCell(1, 7, 1);
                this.board.setCell(3, 7, 1);
                this.board.setCell(5, 7, 1);
                this.board.setCell(7, 7, 1);
                break;
            }
            case 7: {
                this.board.setCell(1, 0, 1);
                this.board.setCell(0, 1, 1);
                this.board.setCell(1, 1, 1);
                this.board.setCell(2, 1, 1);
                this.board.setCell(4, 1, 1);
                this.board.setCell(6, 1, 1);
                this.board.setCell(3, 2, 1);
                this.board.setCell(5, 2, 1);
                this.board.setCell(6, 2, 1);
                this.board.setCell(3, 3, 1);
                this.board.setCell(6, 3, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(2, 4, 1);
                this.board.setCell(3, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(5, 4, 1);
                this.board.setCell(1, 5, 1);
                this.board.setCell(3, 5, 1);
                this.board.setCell(5, 5, 1);
                this.board.setCell(6, 5, 1);
                this.board.setCell(5, 6, 1);
                break;
            }
            case 8: {
                this.board.setCell(4, 0, 1);
                this.board.setCell(5, 0, 1);
                this.board.setCell(6, 0, 1);
                this.board.setCell(1, 1, 1);
                this.board.setCell(3, 1, 1);
                this.board.setCell(6, 1, 1);
                this.board.setCell(1, 2, 1);
                this.board.setCell(2, 2, 1);
                this.board.setCell(3, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(6, 3, 1);
                this.board.setCell(2, 4, 1);
                this.board.setCell(3, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(5, 4, 1);
                this.board.setCell(6, 5, 1);
                this.board.setCell(6, 6, 1);
                this.board.setCell(5, 6, 1);
                break;
            }
            case 9: {
                this.board.setCell(3, 0, 1);
                this.board.setCell(4, 0, 1);
                this.board.setCell(5, 0, 1);
                this.board.setCell(6, 0, 1);
                this.board.setCell(1, 1, 1);
                this.board.setCell(2, 1, 1);
                this.board.setCell(3, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(5, 2, 1);
                this.board.setCell(0, 3, 1);
                this.board.setCell(2, 3, 1);
                this.board.setCell(4, 3, 1);
                this.board.setCell(6, 3, 1);
                this.board.setCell(0, 4, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(2, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(0, 5, 1);
                this.board.setCell(6, 5, 1);
                this.board.setCell(0, 6, 1);
                this.board.setCell(2, 6, 1);
                this.board.setCell(0, 7, 1);
                this.board.setCell(2, 7, 1);
                this.board.setCell(4, 7, 1);
                this.board.setCell(5, 7, 1);
                this.board.setCell(6, 7, 1);
                this.board.setCell(7, 7, 1);
                break;
            }
            case 10: {
                this.board.setCell(1, 0, 1);
                this.board.setCell(2, 0, 1);
                this.board.setCell(3, 0, 1);
                this.board.setCell(5, 0, 1);
                this.board.setCell(7, 0, 1);
                this.board.setCell(4, 1, 1);
                this.board.setCell(5, 1, 1);
                this.board.setCell(1, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(6, 2, 1);
                this.board.setCell(7, 2, 1);
                this.board.setCell(2, 3, 1);
                this.board.setCell(5, 3, 1);
                this.board.setCell(7, 3, 1);
                this.board.setCell(0, 4, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(2, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(6, 4, 1);
                this.board.setCell(0, 5, 1);
                this.board.setCell(2, 5, 1);
                this.board.setCell(5, 5, 1);
                this.board.setCell(0, 6, 1);
                this.board.setCell(1, 6, 1);
                this.board.setCell(2, 6, 1);
                this.board.setCell(3, 6, 1);
                this.board.setCell(4, 6, 1);
                this.board.setCell(6, 6, 1);
                this.board.setCell(3, 7, 1);
                this.board.setCell(5, 7, 1);
                break;
            }
            case 11: {
                this.board.setCell(6, 0, 1);
                this.board.setCell(1, 1, 1);
                this.board.setCell(6, 1, 1);
                this.board.setCell(1, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(5, 2, 1);
                this.board.setCell(6, 2, 1);
                this.board.setCell(0, 3, 1);
                this.board.setCell(1, 3, 1);
                this.board.setCell(4, 3, 1);
                this.board.setCell(5, 3, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(2, 5, 1);
                this.board.setCell(3, 5, 1);
                this.board.setCell(5, 5, 1);
                this.board.setCell(0, 6, 1);
                this.board.setCell(1, 6, 1);
                this.board.setCell(2, 6, 1);
                this.board.setCell(0, 7, 1);
                this.board.setCell(2, 7, 1);
                break;
            }
            case 12: {
                this.board.setCell(3, 0, 1);
                this.board.setCell(5, 0, 1);
                this.board.setCell(1, 1, 1);
                this.board.setCell(3, 1, 1);
                this.board.setCell(7, 1, 1);
                this.board.setCell(4, 1, 1);
                this.board.setCell(5, 1, 1);
                this.board.setCell(6, 1, 1);
                this.board.setCell(1, 2, 1);
                this.board.setCell(3, 2, 1);
                this.board.setCell(5, 2, 1);
                this.board.setCell(0, 3, 1);
                this.board.setCell(1, 3, 1);
                this.board.setCell(2, 3, 1);
                this.board.setCell(5, 3, 1);
                this.board.setCell(7, 3, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(5, 4, 1);
                this.board.setCell(6, 4, 1);
                this.board.setCell(7, 4, 1);
                this.board.setCell(2, 5, 1);
                this.board.setCell(3, 6, 1);
                this.board.setCell(4, 6, 1);
                this.board.setCell(5, 6, 1);
                this.board.setCell(2, 7, 1);
                this.board.setCell(4, 7, 1);
                break;
            }
            case 13: {
                this.board.setCell(0, 0, 1);
                this.board.setCell(2, 0, 1);
                this.board.setCell(3, 0, 1);
                this.board.setCell(5, 0, 1);
                this.board.setCell(0, 1, 1);
                this.board.setCell(3, 1, 1);
                this.board.setCell(5, 1, 1);
                this.board.setCell(0, 2, 1);
                this.board.setCell(1, 2, 1);
                this.board.setCell(2, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(0, 3, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(3, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(5, 4, 1);
                this.board.setCell(0, 5, 1);
                this.board.setCell(2, 5, 1);
                this.board.setCell(4, 5, 1);
                break;
            }
            case 14: {
                this.board.setCell(4, 0, 1);
                this.board.setCell(0, 1, 1);
                this.board.setCell(1, 1, 1);
                this.board.setCell(2, 1, 1);
                this.board.setCell(4, 1, 1);
                this.board.setCell(7, 1, 1);
                this.board.setCell(2, 2, 1);
                this.board.setCell(3, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(5, 2, 1);
                this.board.setCell(6, 2, 1);
                this.board.setCell(7, 2, 1);
                this.board.setCell(1, 3, 1);
                this.board.setCell(0, 4, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(2, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(7, 4, 1);
                this.board.setCell(1, 5, 1);
                this.board.setCell(3, 5, 1);
                this.board.setCell(4, 5, 1);
                this.board.setCell(6, 5, 1);
                this.board.setCell(7, 5, 1);
                this.board.setCell(4, 6, 1);
                this.board.setCell(1, 7, 1);
                this.board.setCell(2, 7, 1);
                this.board.setCell(4, 7, 1);
                this.board.setCell(6, 7, 1);
                break;
            }
            case 15: {
                this.board.setCell(0, 0, 1);
                this.board.setCell(0, 2, 1);
                this.board.setCell(4, 0, 1);
                this.board.setCell(7, 0, 1);
                this.board.setCell(6, 0, 1);
                this.board.setCell(0, 1, 1);
                this.board.setCell(1, 1, 1);
                this.board.setCell(2, 1, 1);
                this.board.setCell(4, 1, 1);
                this.board.setCell(7, 1, 1);
                this.board.setCell(2, 2, 1);
                this.board.setCell(3, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(5, 2, 1);
                this.board.setCell(6, 2, 1);
                this.board.setCell(7, 2, 1);
                this.board.setCell(1, 3, 1);
                this.board.setCell(0, 4, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(2, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(7, 4, 1);
                this.board.setCell(1, 5, 1);
                this.board.setCell(3, 5, 1);
                this.board.setCell(4, 5, 1);
                this.board.setCell(5, 5, 1);
                this.board.setCell(6, 5, 1);
                this.board.setCell(7, 5, 1);
                this.board.setCell(4, 6, 1);
                this.board.setCell(0, 7, 1);
                this.board.setCell(1, 7, 1);
                this.board.setCell(2, 7, 1);
                this.board.setCell(4, 7, 1);
                this.board.setCell(6, 7, 1);
                this.board.setCell(7, 7, 1);
                break;
            }
            case 16: {
                this.board.setCell(0, 0, 1);
                this.board.setCell(6, 0, 1);
                this.board.setCell(6, 1, 1);
                this.board.setCell(2, 0, 1);
                this.board.setCell(3, 0, 1);
                this.board.setCell(5, 0, 1);
                this.board.setCell(0, 1, 1);
                this.board.setCell(3, 1, 1);
                this.board.setCell(5, 1, 1);
                this.board.setCell(0, 2, 1);
                this.board.setCell(1, 2, 1);
                this.board.setCell(2, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(0, 3, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(3, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(6, 4, 1);
                this.board.setCell(5, 4, 1);
                this.board.setCell(0, 5, 1);
                this.board.setCell(2, 5, 1);
                this.board.setCell(4, 5, 1);
                this.board.setCell(6, 6, 1);
                this.board.setCell(6, 7, 1);
                this.board.setCell(0, 7, 1);
                this.board.setCell(1, 7, 1);
                this.board.setCell(2, 7, 1);
                this.board.setCell(3, 7, 1);
                this.board.setCell(4, 7, 1);
                this.board.setCell(5, 7, 1);
                break;
            }
            case 17: {
                this.board.setCell(6, 0, 1);
                this.board.setCell(4, 0, 1);
                this.board.setCell(0, 0, 1);
                this.board.setCell(0, 1, 1);
                this.board.setCell(1, 1, 1);
                this.board.setCell(6, 1, 1);
                this.board.setCell(3, 1, 1);
                this.board.setCell(5, 1, 1);
                this.board.setCell(1, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(5, 2, 1);
                this.board.setCell(6, 2, 1);
                this.board.setCell(0, 3, 1);
                this.board.setCell(1, 3, 1);
                this.board.setCell(4, 3, 1);
                this.board.setCell(5, 3, 1);
                this.board.setCell(0, 4, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(5, 4, 1);
                this.board.setCell(6, 4, 1);
                this.board.setCell(2, 5, 1);
                this.board.setCell(3, 5, 1);
                this.board.setCell(5, 5, 1);
                this.board.setCell(0, 5, 1);
                this.board.setCell(6, 5, 1);
                this.board.setCell(0, 6, 1);
                this.board.setCell(2, 6, 1);
                this.board.setCell(4, 6, 1);
                this.board.setCell(6, 6, 1);
                this.board.setCell(0, 7, 1);
                this.board.setCell(2, 7, 1);
                break;
            }
            case 18: {
                this.board.setCell(0, 0, 1);
                this.board.setCell(1, 0, 1);
                this.board.setCell(2, 0, 1);
                this.board.setCell(3, 0, 1);
                this.board.setCell(5, 0, 1);
                this.board.setCell(7, 0, 1);
                this.board.setCell(4, 1, 1);
                this.board.setCell(5, 1, 1);
                this.board.setCell(0, 2, 1);
                this.board.setCell(1, 2, 1);
                this.board.setCell(4, 2, 1);
                this.board.setCell(6, 2, 1);
                this.board.setCell(7, 2, 1);
                this.board.setCell(2, 3, 1);
                this.board.setCell(5, 3, 1);
                this.board.setCell(7, 3, 1);
                this.board.setCell(0, 4, 1);
                this.board.setCell(1, 4, 1);
                this.board.setCell(2, 4, 1);
                this.board.setCell(4, 4, 1);
                this.board.setCell(6, 4, 1);
                this.board.setCell(0, 5, 1);
                this.board.setCell(2, 5, 1);
                this.board.setCell(5, 5, 1);
                this.board.setCell(0, 6, 1);
                this.board.setCell(1, 6, 1);
                this.board.setCell(2, 6, 1);
                this.board.setCell(3, 6, 1);
                this.board.setCell(4, 6, 1);
                this.board.setCell(6, 6, 1);
                this.board.setCell(0, 7, 1);
                this.board.setCell(3, 7, 1);
                this.board.setCell(5, 7, 1);
                this.board.setCell(7, 7, 1);
                break;
            }
        }
        boolean temp = false;
        for (int i = COLUMNS - 1; i >= 0; --i) {
            for (int j = ROWS - 1; j >= 0; --j) {
                this.blocks[i][j].setVisible(true);
                this.blocks[i][j].setFrame(0);
                this.blocks[i][j].setPosition(this.offsetX + i * FRAME_SIZE, this.offsetY + j * FRAME_SIZE);
            }
        }
    }

    public void animateMainMenu() {
        int x;
        if (this.changeSelection == -5) {
            this.g.drawImage(this.backImage, 0, 0, 0);
            this.changeSelection = 0;
            this.traverseIndex = 0;
            this.unfoldingIndex = 0;
            block0 : switch (this.menuType) {
                case 7: {
                    switch (this.menuIndex) {
                        case 0: {
                            if (this.paused) {
                                this.menuIndex = 0;
                                this.menuItems = language == 0 ? this.pauseMenuItems : (language == 1 ? this.pauseMenuItems1 : this.pauseMenuItems2);
                                this.menuType = 1;
                                break block0;
                            }
                            this.menuIndex = 0;
                            this.menuItems = language == 0 ? this.mmenuItems : (language == 1 ? this.mmenuItems1 : this.mmenuItems2);
                            this.menuType = 0;
                            break block0;
                        }
                    }
                    if (this.paused) {
                        this.paused = false;
                        this.menuItems = language == 0 ? this.mmenuItems : (language == 1 ? this.mmenuItems1 : this.mmenuItems2);
                        this.menuType = 0;
                        break;
                    }
                    this.midlet.destroyApp(true);
                    this.midlet.notifyDestroyed();
                    break;
                }
                case 0: {
                    this.paused = false;
                    switch (this.menuIndex) {
                        case 0: {
                            this.changeBackImage(2);
                            this.gameState = 2;
                            break block0;
                        }
                        case 1: {
                            this.menuItems = language == 0 ? this.omenuItems : (language == 1 ? this.omenuItems1 : this.omenuItems2);
                            this.menuType = 3;
                            break block0;
                        }
                        case 2: {
                            this.gameState = 3;
                            break block0;
                        }
                    }
                    this.menuIndex = 0;
                    this.menuItems = language == 0 ? this.confirmationItems : (language == 1 ? this.confirmationItems1 : this.confirmationItems2);
                    this.menuType = 7;
                    break;
                }
                case 3: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.menuIndex = this.soundVolume / 33;
                            this.menuItems = language == 0 ? this.soundsItems : (language == 1 ? this.soundsItems1 : this.soundsItems2);
                            this.menuType = 4;
                            break block0;
                        }
                        case 1: {
                            this.menuIndex = this.vibrations ? 0 : 1;
                            this.menuItems = language == 0 ? this.vibrationItems : (language == 1 ? this.vibrationItems1 : this.vibrationItems2);
                            this.menuType = 5;
                            break block0;
                        }
                        case 2: {
                            this.menuIndex = language;
                            this.menuItems = language == 0 ? this.languageItems : (language == 1 ? this.languageItems1 : this.languageItems2);
                            this.menuType = 8;
                            break block0;
                        }
                    }
                    this.menuIndex = 0;
                    if (this.paused) {
                        this.menuItems = language == 0 ? this.pauseMenuItems : (language == 1 ? this.pauseMenuItems1 : this.pauseMenuItems2);
                        this.menuType = 1;
                        break;
                    }
                    this.menuItems = language == 0 ? this.mmenuItems : (language == 1 ? this.mmenuItems1 : this.mmenuItems2);
                    this.menuType = 0;
                    break;
                }
                case 4: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.soundVolume = 0;
                            this.writeRMS();
                            this.initMedia();
                            break;
                        }
                        case 1: {
                            this.soundVolume = 33;
                            this.writeRMS();
                            this.initMedia();
                            break;
                        }
                        case 2: {
                            this.soundVolume = 66;
                            this.writeRMS();
                            this.initMedia();
                            break;
                        }
                        case 3: {
                            this.soundVolume = 100;
                            this.writeRMS();
                            this.initMedia();
                        }
                    }
                    if (this.paused) {
                        this.menuItems = language == 0 ? this.pauseMenuItems : (language == 1 ? this.pauseMenuItems1 : this.pauseMenuItems2);
                        this.menuType = 1;
                        break;
                    }
                    this.menuItems = language == 0 ? this.omenuItems : (language == 1 ? this.omenuItems1 : this.omenuItems2);
                    this.menuType = 3;
                    break;
                }
                case 5: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.vibrations = true;
                            this.midlet.vibra(1000);
                            this.writeRMS();
                            break;
                        }
                        case 1: {
                            this.vibrations = false;
                            this.writeRMS();
                            break;
                        }
                    }
                    if (this.paused) {
                        this.menuItems = language == 0 ? this.pauseMenuItems : (language == 1 ? this.pauseMenuItems1 : this.pauseMenuItems2);
                        this.menuType = 1;
                        break;
                    }
                    this.menuItems = language == 0 ? this.omenuItems : (language == 1 ? this.omenuItems1 : this.omenuItems2);
                    this.menuType = 3;
                    break;
                }
                case 8: {
                    switch (this.menuIndex) {
                        case 0: {
                            language = 0;
                            this.menuItems = language == 0 ? this.omenuItems : (language == 1 ? this.omenuItems1 : this.omenuItems2);
                            this.menuType = 3;
                            break block0;
                        }
                        case 1: {
                            language = 1;
                            this.menuItems = language == 0 ? this.omenuItems : (language == 1 ? this.omenuItems1 : this.omenuItems2);
                            this.menuType = 3;
                            break block0;
                        }
                        case 2: {
                            language = 2;
                            this.menuItems = language == 0 ? this.omenuItems : (language == 1 ? this.omenuItems1 : this.omenuItems2);
                            this.menuType = 3;
                            break block0;
                        }
                    }
                    if (this.paused) {
                        this.menuItems = language == 0 ? this.pauseMenuItems : (language == 1 ? this.pauseMenuItems1 : this.pauseMenuItems2);
                        this.menuType = 1;
                        break;
                    }
                    this.menuItems = language == 0 ? this.omenuItems : (language == 1 ? this.omenuItems1 : this.omenuItems2);
                    this.menuType = 3;
                    break;
                }
                case 1: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.paused = false;
                            this.g.setColor(0);
                            this.changeBackImage(1);
                            this.gameState = 10;
                            break block0;
                        }
                        case 1: {
                            this.menuIndex = this.soundVolume / 33;
                            this.menuItems = language == 0 ? this.soundsItems : (language == 1 ? this.soundsItems1 : this.soundsItems2);
                            this.menuType = 4;
                            break block0;
                        }
                        case 2: {
                            this.menuIndex = this.vibrations ? 0 : 1;
                            this.menuItems = language == 0 ? this.vibrationItems : (language == 1 ? this.vibrationItems1 : this.vibrationItems2);
                            this.menuType = 5;
                            break block0;
                        }
                        case 3: {
                            this.menuIndex = 0;
                            this.menuItems = language == 0 ? this.confirmationItems : (language == 1 ? this.confirmationItems1 : this.confirmationItems2);
                            this.menuType = 7;
                        }
                    }
                }
            }
            if (this.menuType != 4 && this.menuType != 5 && this.menuType != 8) {
                this.menuIndex = 0;
            }
        }
        if (this.changeSelection != 0) {
            do {
                this.menuIndex += this.changeSelection;
                if (this.menuIndex == -1) {
                    this.menuIndex = this.menuItems.length - 1;
                    continue;
                }
                if (this.menuIndex != this.menuItems.length) continue;
                this.menuIndex = 0;
            } while (this.menuItems[this.menuIndex].charAt(0) == '*');
        }
        int space = 14;
        if (this.menuType == 4) {
            space = 11;
        }
        for (x = 0; x < this.menuItems.length; ++x) {
            this.displayString(this.menuItems[x], space * x + 16, x == this.menuIndex);
        }
        this.changeSelection = 0;
        x = this.leftSelectorX;
        fWidth = this.BIGFONT.charWidth('C');
        int xx = screenWidth / 2 - this.menuItems[this.menuIndex].length() * fWidth / 2 - this.fontSprite.getWidth() - 10;
        if (x < xx) {
            x += (xx - x) / 3 + 1;
        } else if (x > xx) {
            x -= (x - xx) / 3 + 1;
        }
        int y = this.leftSelectorY;
        int yy = space * this.menuIndex + 16;
        if (y < yy) {
            y += (yy - y) / 3 + 1;
        } else if (y > yy) {
            y -= (y - yy) / 3 + 1;
        }
        this.leftSelectorX = x;
        this.leftSelectorY = y;
        this.fontSprite.setPosition(x, y);
        this.fontSprite.setFrame(0);
        this.fontSprite.paint(this.g);
        x = this.rightSelectorX;
        xx = screenWidth / 2 + this.menuItems[this.menuIndex].length() * fWidth / 2 + this.fontSprite.getWidth();
        if (x < xx) {
            x += (xx - x) / 3 + 1;
        } else if (x > xx) {
            x -= (x - xx) / 3 + 1;
        }
        y = this.rightSelectorY;
        if (y < yy) {
            y += (yy - y) / 3 + 1;
        } else if (y > yy) {
            y -= (y - yy) / 3 + 1;
        }
        this.rightSelectorX = x;
        this.rightSelectorY = y;
        this.fontSprite.setPosition(x, y);
        this.fontSprite.setFrame(1);
        this.fontSprite.paint(this.g);
    }

    private void changeBackImage(int whichScreen) {
        if (whichScreen == 3) {
            try {
                this.backImage = Image.createImage((String)"/vc.png");
            }
            catch (IOException ex) {
                System.out.println("cant find island cleared screen...");
                ex.printStackTrace();
            }
        } else if (whichScreen == 1) {
            this.backImage = null;
            try {
                this.backImage = Image.createImage((String)"/bk.png");
            }
            catch (IOException ex) {
                System.out.println("cant find splash...");
                ex.printStackTrace();
            }
        } else if (whichScreen == 2) {
            try {
                this.backImage = Image.createImage((String)"/map.png");
            }
            catch (IOException ex) {
                System.out.println("cant find map...");
                ex.printStackTrace();
            }
        } else {
            try {
                this.backImage = Image.createImage((String)"/splash.png");
            }
            catch (IOException ex) {
                System.out.println("cant find splash...");
                ex.printStackTrace();
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -7 && !this.paused && this.gameState == 10) {
            this.changeBackImage(0);
            this.menuItems = language == 0 ? this.pauseMenuItems : (language == 1 ? this.pauseMenuItems1 : this.pauseMenuItems2);
            this.menuType = 1;
            this.menuIndex = 0;
            this.gameState = 4;
            this.traverseIndex = 0;
            this.paused = true;
            return;
        }
        if (this.gameState == 4) {
            if (keyCode == -1 || keyCode == 50) {
                this.changeSelection = -1;
            } else if (keyCode == -2 || keyCode == 56) {
                this.changeSelection = 1;
            } else if (keyCode == -5 || keyCode == 53) {
                this.changeSelection = -5;
            }
        } else if (this.gameState == 10 || this.gameState == 2) {
            this.changeSelection = this.getKeyStates();
            if (keyCode == -6 || keyCode == -7) {
                this.changeSelection = keyCode;
            }
        } else if (this.gameState == 5 || this.gameState == 3) {
            this.changeSelection = keyCode == -3 || keyCode == 52 ? -1 : (keyCode == -4 || keyCode == 54 ? 1 : (keyCode == -5 || keyCode == 53 ? -5 : keyCode));
        }
    }

    protected void hideNotify() {
        if (this.gameState == 10) {
            this.changeBackImage(0);
            this.menuItems = language == 0 ? this.pauseMenuItems : (language == 1 ? this.pauseMenuItems1 : this.pauseMenuItems2);
            this.menuType = 1;
            this.menuIndex = 0;
            this.gameState = 4;
            this.paused = true;
            this.traverseIndex = 0;
        }
    }

    public void writeRMS() {
        this.rec[0] = 0;
        this.rec[0] = (byte)(this.soundVolume / 33);
        if (this.vibrations) {
            this.rec[0] = (byte)(this.rec[0] | 4);
        }
        this.rec[0] = (byte)(this.iv_islandsCleared << 3 | this.rec[0]);
        try {
            this.rs = RecordStore.openRecordStore((String)"JJDB", (boolean)true);
            if (this.rs.getNumRecords() > 0) {
                this.rs.setRecord(1, this.rec, 0, 1);
            } else {
                this.rs.addRecord(this.rec, 0, 1);
            }
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant write settings into rs : " + e);
        }
        System.out.println("written..." + Integer.toBinaryString(this.rec[0]));
    }

    public void readRMS() {
        try {
            this.rs = RecordStore.openRecordStore((String)"JJDB", (boolean)true);
            this.rec = this.rs.getRecord(1);
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant open recordStore for settings" + e);
            this.soundVolume = 33;
            this.vibrations = true;
            return;
        }
        this.soundVolume = (this.rec[0] & 3) * 33;
        this.vibrations = (this.rec[0] & 4) != 0;
        this.iv_islandsCleared = this.rec[0] >>> 3;
    }

    public static int nextInt() {
        seed = seed * -554899859 + 11 & 0xFFFFFF;
        return seed >>> 8;
    }

    public static int nextInt(int n) {
        seed = seed * -554899859 + 11 & 0xFFFFFF;
        return (seed >>> 8) % n;
    }

    public static int nextSignedInt(int n) {
        seed = seed * -554899859 + 11 & 0xFFFFFF;
        return (seed >>> 8) % (n * 2) - n;
    }

    private void initMedia() {
        if (musicPlayer == null) {
            String[] musicFiles = new String[]{"/tt.mid", "/lu.mid", "/jp.mid", "/br.mid", "/die.mid"};
            String xtension = "mid";
            musicPlayer = new Player[5];
            for (int i = 0; i < musicPlayer.length; ++i) {
                try {
                    InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(musicFiles[i]);
                    FroggerQuestCanvas128.musicPlayer[i] = musicFiles[i].endsWith(xtension) ? Manager.createPlayer((InputStream)is, (String)"audio/midi") : Manager.createPlayer((InputStream)is, (String)"audio/X-wav");
                    musicPlayer[i].realize();
                    continue;
                }
                catch (Exception e) {
                    System.out.println("in initMedia" + e.getMessage());
                }
            }
            musicPlayer[0].setLoopCount(-1);
        }
        if (this.soundVolume > 0) {
            VolumeControl vc = (VolumeControl)musicPlayer[0].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)musicPlayer[1].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)musicPlayer[2].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)musicPlayer[3].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)musicPlayer[4].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
        } else {
            try {
                musicPlayer[0].stop();
                musicPlayer[1].stop();
                musicPlayer[2].stop();
                musicPlayer[3].stop();
                musicPlayer[4].stop();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void loadText() {
        this.titleImage = null;
        try {
            this.titleImage = language == 0 ? Image.createImage((String)"/traditional.png") : (language == 1 ? Image.createImage((String)"/simplified.png") : Image.createImage((String)"/eng.png"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void DrawTitle() {
        if (language == 0) {
            this.g.drawImage(this.titleImage, screenWidth / 15, screenHeight - 3, 0x20 | 4);
        } else if (language == 1) {
            this.g.drawImage(this.titleImage, screenWidth / 15, screenHeight - 3, 0x20 | 4);
        } else {
            this.g.drawImage(this.titleImage, 18, screenHeight - 3, 0x20 | 4);
        }
    }

    static /* synthetic */ int access$200(FroggerQuestCanvas128 x0) {
        return x0.gameState;
    }

    static /* synthetic */ int access$308(FroggerQuestCanvas128 x0) {
        return x0.traverseIndex++;
    }

    static /* synthetic */ int access$300(FroggerQuestCanvas128 x0) {
        return x0.traverseIndex;
    }

    static /* synthetic */ Image access$400(FroggerQuestCanvas128 x0) {
        return x0.backImage;
    }

    static /* synthetic */ void access$700(FroggerQuestCanvas128 x0) {
        x0.loadText();
    }

    static /* synthetic */ void access$800(FroggerQuestCanvas128 x0) {
        x0.DrawTitle();
    }

    static /* synthetic */ String[] access$902(FroggerQuestCanvas128 x0, String[] x1) {
        x0.menuItems = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1000(FroggerQuestCanvas128 x0) {
        return x0.mmenuItems;
    }

    static /* synthetic */ String[] access$1100(FroggerQuestCanvas128 x0) {
        return x0.mmenuItems1;
    }

    static /* synthetic */ String[] access$1200(FroggerQuestCanvas128 x0) {
        return x0.mmenuItems2;
    }

    static /* synthetic */ int access$1302(FroggerQuestCanvas128 x0, int x1) {
        x0.menuType = x1;
        return x0.menuType;
    }

    static /* synthetic */ int access$1402(FroggerQuestCanvas128 x0, int x1) {
        x0.changeSelection = x1;
        return x0.changeSelection;
    }

    static /* synthetic */ int access$312(FroggerQuestCanvas128 x0, int x1) {
        return x0.traverseIndex += x1;
    }

    static /* synthetic */ Sprite access$1500(FroggerQuestCanvas128 x0) {
        return x0.player;
    }

    static /* synthetic */ int access$1400(FroggerQuestCanvas128 x0) {
        return x0.changeSelection;
    }

    static /* synthetic */ Font access$1700(FroggerQuestCanvas128 x0) {
        return x0.SMALLULINEFONT;
    }

    static /* synthetic */ Font access$1800(FroggerQuestCanvas128 x0) {
        return x0.BIGFONT;
    }

    static /* synthetic */ int access$1900(FroggerQuestCanvas128 x0) {
        return x0.soundVolume;
    }

    static /* synthetic */ Sprite access$2000(FroggerQuestCanvas128 x0) {
        return x0.flagSprite;
    }

    static /* synthetic */ Sprite access$2100(FroggerQuestCanvas128 x0) {
        return x0.arrowSprite;
    }

    static /* synthetic */ int access$100(FroggerQuestCanvas128 x0) {
        return x0.currentLevel;
    }

    static /* synthetic */ void access$2200(FroggerQuestCanvas128 x0) {
        x0.createBoard();
    }

    static /* synthetic */ int access$120(FroggerQuestCanvas128 x0, int x1) {
        return x0.currentLevel -= x1;
    }

    static /* synthetic */ int access$112(FroggerQuestCanvas128 x0, int x1) {
        return x0.currentLevel += x1;
    }

    static /* synthetic */ int access$110(FroggerQuestCanvas128 x0) {
        return x0.currentLevel--;
    }

    static /* synthetic */ int access$108(FroggerQuestCanvas128 x0) {
        return x0.currentLevel++;
    }

    static /* synthetic */ int access$2300() {
        return COLUMNS;
    }

    static /* synthetic */ int access$2400() {
        return ROWS;
    }

    static /* synthetic */ Sprite[][] access$2500(FroggerQuestCanvas128 x0) {
        return x0.blocks;
    }

    static /* synthetic */ int access$2600(FroggerQuestCanvas128 x0) {
        return x0.offsetX;
    }

    static /* synthetic */ int access$2700() {
        return FRAME_SIZE;
    }

    static /* synthetic */ int access$2800(FroggerQuestCanvas128 x0) {
        return x0.offsetY;
    }

    static /* synthetic */ TiledLayer access$2900(FroggerQuestCanvas128 x0) {
        return x0.board;
    }

    static /* synthetic */ void access$3000(FroggerQuestCanvas128 x0) {
        x0.setPlayerIdleState();
    }

    static /* synthetic */ int access$1300(FroggerQuestCanvas128 x0) {
        return x0.menuType;
    }

    static /* synthetic */ boolean access$3100(FroggerQuestCanvas128 x0) {
        return x0.paused;
    }

    static /* synthetic */ String[] access$900(FroggerQuestCanvas128 x0) {
        return x0.menuItems;
    }

    static /* synthetic */ Sprite access$3600(FroggerQuestCanvas128 x0) {
        return x0.fallingBlock;
    }

    static /* synthetic */ int access$3700(FroggerQuestCanvas128 x0) {
        return x0.playerState;
    }

    static /* synthetic */ int[] access$3202(FroggerQuestCanvas128 x0, int[] x1) {
        x0.dragonX = x1;
        return x1;
    }

    static /* synthetic */ int[] access$3302(FroggerQuestCanvas128 x0, int[] x1) {
        x0.dragonY = x1;
        return x1;
    }

    static {
        language = 0;
    }

    class GameLoop
    extends TimerTask {
        int[] levelX = new int[]{40, 52, 70, 20, 25, 23, 28, 36, 56, 90, 80, 115, 68, 50, 65, 88, 89, 105, 118};
        int[] levelY = new int[]{20, 30, 20, 59, 74, 90, 110, 122, 108, 94, 105, 115, 78, 70, 65, 60, 45, 44, 60};
        int[] lockX = new int[]{7, 28, 80, 48, 88};
        int[] lockY = new int[]{55, 91, 80, 50, 35};
        boolean[] levelCleared;
        boolean islandCleared;
        private int temp;
        private int currentIsland;
        private Image lock;

        public GameLoop() {
            this.levelCleared = FroggerQuestCanvas128.this.iv_islandsCleared == 5 ? new boolean[4] : new boolean[3];
            this.currentIsland = FroggerQuestCanvas128.this.iv_islandsCleared;
            FroggerQuestCanvas128.this.currentLevel = FroggerQuestCanvas128.this.iv_islandsCleared * 3;
            this.temp = 20;
            try {
                this.lock = Image.createImage((String)"/b.png");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            state = FroggerQuestCanvas128.this.getKeyStates();
            switch (FroggerQuestCanvas128.access$200(FroggerQuestCanvas128.this)) {
                case 0: {
                    FroggerQuestCanvas128.access$308(FroggerQuestCanvas128.this);
                    if (FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) < 40) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawImage(FroggerQuestCanvas128.access$400(FroggerQuestCanvas128.this), FroggerQuestCanvas128.screenWidth / 2, FroggerQuestCanvas128.screenHeight / 2, 3);
                        FroggerQuestCanvas128.access$302(FroggerQuestCanvas128.this, 40);
                        break;
                    }
                    if (FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) >= 40 && FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) <= 70) {
                        for (i = 0; i < 4; ++i) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawImage(this.lock, FroggerQuestCanvas128.screenWidth / 2, 20 * i + 20, 17);
                        }
                        break;
                    }
                    if (FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) == 71) {
                        FroggerQuestCanvas128.access$600(FroggerQuestCanvas128.this, 0);
                        break;
                    }
                    if (FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) > 71 && FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) < 100) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawImage(FroggerQuestCanvas128.access$400(FroggerQuestCanvas128.this), 0, 0, 0);
                        FroggerQuestCanvas128.access$700(FroggerQuestCanvas128.this);
                        FroggerQuestCanvas128.access$800(FroggerQuestCanvas128.this);
                        break;
                    }
                    try {
                        this.lock = Image.createImage((String)"/marker.png");
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    i = false;
                    FroggerQuestCanvas128.access$302(FroggerQuestCanvas128.this, 0);
                    this.temp = 0;
                    if (FroggerQuestCanvas128.language == 0) {
                        FroggerQuestCanvas128.access$902(FroggerQuestCanvas128.this, FroggerQuestCanvas128.access$1000(FroggerQuestCanvas128.this));
                    } else if (FroggerQuestCanvas128.language == 1) {
                        FroggerQuestCanvas128.access$902(FroggerQuestCanvas128.this, FroggerQuestCanvas128.access$1100(FroggerQuestCanvas128.this));
                    } else {
                        FroggerQuestCanvas128.access$902(FroggerQuestCanvas128.this, FroggerQuestCanvas128.access$1200(FroggerQuestCanvas128.this));
                    }
                    FroggerQuestCanvas128.access$1302(FroggerQuestCanvas128.this, 0);
                    FroggerQuestCanvas128.access$202(FroggerQuestCanvas128.this, 4);
                    FroggerQuestCanvas128.access$1402(FroggerQuestCanvas128.this, 0);
                    break;
                }
                case 3: {
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawImage(FroggerQuestCanvas128.access$400(FroggerQuestCanvas128.this), 0, 0, 20);
                    FroggerQuestCanvas128.access$700(FroggerQuestCanvas128.this);
                    FroggerQuestCanvas128.access$800(FroggerQuestCanvas128.this);
                    if (FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) < FroggerQuestCanvas128.screenWidth) {
                        FroggerQuestCanvas128.access$312(FroggerQuestCanvas128.this, 20);
                    }
                    if ((x = FroggerQuestCanvas128.access$1500(FroggerQuestCanvas128.this).getX()) < (xx = FroggerQuestCanvas128.screenWidth / 2 - this.temp * FroggerQuestCanvas128.screenWidth)) {
                        x += (xx - x) / 5 + 1;
                    } else if (x > xx) {
                        x -= (x - xx) / 5 + 1;
                    }
                    FroggerQuestCanvas128.access$1500(FroggerQuestCanvas128.this).setPosition(x, 100);
                    if (x == xx) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(153, 193, 204);
                        if (this.temp != 0) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).fillTriangle(12, 24 + FroggerQuestCanvas128.screenWidth / 2 - 75, 18, 24 + FroggerQuestCanvas128.screenWidth / 2 - 6 - 75, 18, 24 + FroggerQuestCanvas128.screenWidth / 2 + 6 - 75);
                        }
                        if (this.temp != 2) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).fillTriangle(FroggerQuestCanvas128.screenWidth - 12, 24 + FroggerQuestCanvas128.screenWidth / 2 - 75, FroggerQuestCanvas128.screenWidth - 12 - 6, 24 + FroggerQuestCanvas128.screenWidth / 2 - 6 - 75, FroggerQuestCanvas128.screenWidth - 12 - 6, 24 + FroggerQuestCanvas128.screenWidth / 2 + 6 - 75);
                        }
                    }
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0xFFFFFFF);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setFont(FroggerQuestCanvas128.access$1600(FroggerQuestCanvas128.this));
                    if (FroggerQuestCanvas128.language == 0) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5e6b\u52a9: " + (this.temp + 1) + "/3", FroggerQuestCanvas128.screenWidth / 2, 2, 17);
                    } else if (FroggerQuestCanvas128.language == 1) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5e2e\u52a9: " + (this.temp + 1) + "/3", FroggerQuestCanvas128.screenWidth / 2, 2, 17);
                    } else {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("Help: " + (this.temp + 1) + "/3", FroggerQuestCanvas128.screenWidth / 2, 2, 17);
                    }
                    if (this.temp == 0 || this.temp == 1) {
                        if (FroggerQuestCanvas128.language == 0) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u76ee\u6a19:", x, 12, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u4f60\u9700\u8981\u5f9e\u4e00", x, 24, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u7247\u8449\u5b50\u8df3\u5230", x, 36, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u53e6\u4e00\u7247, \u76f4", x, 48, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5230\u6700\u5f8c.", x, 60, 17);
                        } else if (FroggerQuestCanvas128.language == 1) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u76ee\u6807:", x, 12, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u4f60\u9700\u8981\u4ece\u4e00", x, 24, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u7247\u53f6\u5b50\u8df3", x, 36, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5230\u53e6\u4e00\u7247,", x, 48, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u76f4\u5230\u6700\u540e.", x, 60, 17);
                        } else {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("OBJECTIVE:", x, 12, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("You need to jump off", x, 24, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("from one leaf to another", x, 36, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("leaf till you reach", x, 48, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("the final leaf.", x, 60, 17);
                        }
                    }
                    if (this.temp == 0 || this.temp == 1 || this.temp == 2) {
                        if (FroggerQuestCanvas128.language == 0) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u63a7\u5236:", x + FroggerQuestCanvas128.screenWidth, 12, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5411\u4e0a\u79fb\u52d5: 4", x + FroggerQuestCanvas128.screenWidth, 24, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5411\u5de6\u79fb\u52d5: 6", x + FroggerQuestCanvas128.screenWidth, 36, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5411\u53f3\u79fb\u52d5: 2", x + FroggerQuestCanvas128.screenWidth, 48, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5411\u4e0b\u79fb\u52d5: 8", x + FroggerQuestCanvas128.screenWidth, 60, 17);
                        } else if (FroggerQuestCanvas128.language == 1) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u63a7\u5236:", x + FroggerQuestCanvas128.screenWidth, 12, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5411\u4e0a\u79fb\u52a8: 4", x + FroggerQuestCanvas128.screenWidth, 24, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5411\u5de6\u79fb\u52a8: 6", x + FroggerQuestCanvas128.screenWidth, 36, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5411\u53f3\u79fb\u52a8: 2", x + FroggerQuestCanvas128.screenWidth, 48, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5411\u4e0b\u79fb\u52a8: 8", x + FroggerQuestCanvas128.screenWidth, 60, 17);
                        } else {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("CONTROLS:", x + FroggerQuestCanvas128.screenWidth, 12, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("Face up/Move up: 4", x + FroggerQuestCanvas128.screenWidth, 24, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("Face left/ Move left: 6", x + FroggerQuestCanvas128.screenWidth, 36, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("Face  right/Move right: 2", x + FroggerQuestCanvas128.screenWidth, 48, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("Face Down/Move down: 8", x + FroggerQuestCanvas128.screenWidth, 60, 17);
                        }
                    }
                    if (this.temp == 1 || this.temp == 2 || this.temp == 3) {
                        if (FroggerQuestCanvas128.language == 0) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u63a7\u5236:", x + FroggerQuestCanvas128.screenWidth * 2, 12, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u8df3: \u9375 5", x + FroggerQuestCanvas128.screenWidth * 2, 24, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u66ab\u505c: \u53f3\u8edf\u9375", x + FroggerQuestCanvas128.screenWidth * 2, 36, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u8fd4\u56de: \u5de6\u8edf\u9375", x + FroggerQuestCanvas128.screenWidth * 2, 48, 17);
                        } else if (FroggerQuestCanvas128.language == 1) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u63a7\u5236:", x + FroggerQuestCanvas128.screenWidth * 2, 12, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u8df3: \u952e 5", x + FroggerQuestCanvas128.screenWidth * 2, 24, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u6682\u505c: \u53f3\u8f6f\u952e", x + FroggerQuestCanvas128.screenWidth * 3, 72, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u8fd4\u56de: \u5de6\u8f6f\u952e", x + FroggerQuestCanvas128.screenWidth * 4, 84, 17);
                        } else {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("CONTROLS:", x + FroggerQuestCanvas128.screenWidth * 2, 12, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("Jump: Fire key/key 5", x + FroggerQuestCanvas128.screenWidth * 5, 24, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("Pause: RSK", x + FroggerQuestCanvas128.screenWidth * 2, 36, 17);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("Back: LSK", x + FroggerQuestCanvas128.screenWidth * 2, 48, 17);
                        }
                    }
                    if (FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) == -6) {
                        FroggerQuestCanvas128.access$202(FroggerQuestCanvas128.this, 4);
                        this.temp = 0;
                    } else if (FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) == 1 && this.temp < 2) {
                        this.temp += FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this);
                    } else if (FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) == -1 && this.temp > 0) {
                        this.temp += FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this);
                    }
                    FroggerQuestCanvas128.access$1402(FroggerQuestCanvas128.this, 0);
                    break;
                }
                case 5: {
                    if (this.temp < 0 || this.temp > 2) {
                        this.temp = 0;
                    }
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawImage(FroggerQuestCanvas128.access$400(FroggerQuestCanvas128.this), 0, 0, 20);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0xFF1122);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawLine(0, 6, FroggerQuestCanvas128.screenWidth, 6);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0x221177);
                    for (y = 8; y < 126; y += 4) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawLine(0, y, FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this), y);
                    }
                    for (y = 10; y < 128; y += 4) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawLine(FroggerQuestCanvas128.screenWidth - FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this), y, FroggerQuestCanvas128.screenWidth, y);
                    }
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0xFF1122);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawLine(0, 128, FroggerQuestCanvas128.screenWidth, 128);
                    if (FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) < FroggerQuestCanvas128.screenWidth) {
                        FroggerQuestCanvas128.access$312(FroggerQuestCanvas128.this, 20);
                    }
                    if ((x = FroggerQuestCanvas128.access$1500(FroggerQuestCanvas128.this).getX()) < (xx = FroggerQuestCanvas128.screenWidth / 2 - this.temp * FroggerQuestCanvas128.screenWidth)) {
                        x += (xx - x) / 5 + 1;
                    } else if (x > xx) {
                        x -= (x - xx) / 5 + 1;
                    }
                    FroggerQuestCanvas128.access$1500(FroggerQuestCanvas128.this).setPosition(x, 100);
                    if (x == xx) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(153, 193, 204);
                        if (this.temp != 0) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).fillTriangle(8, 24 + FroggerQuestCanvas128.screenWidth / 2 - 75, 14, 24 + FroggerQuestCanvas128.screenWidth / 2 - 6 - 75, 14, 24 + FroggerQuestCanvas128.screenWidth / 2 + 6 - 75);
                        }
                        if (this.temp != 2) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).fillTriangle(FroggerQuestCanvas128.screenWidth - 12 - 6 + 10, 24 + FroggerQuestCanvas128.screenWidth / 2 - 75, FroggerQuestCanvas128.screenWidth - 24 + 10, 24 + FroggerQuestCanvas128.screenWidth / 2 - 6 - 75, FroggerQuestCanvas128.screenWidth - 24 + 10, 24 + FroggerQuestCanvas128.screenWidth / 2 + 6 - 75);
                        }
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0x223322);
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).fillRect(0, FroggerQuestCanvas128.screenHeight - 10, 40, 10);
                        if (FroggerQuestCanvas128.language == 0) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5b8c\u6210", FroggerQuestCanvas128.screenWidth / 2, FroggerQuestCanvas128.screenHeight - 2, 17);
                        } else if (FroggerQuestCanvas128.language == 1) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u5b8c\u6210", FroggerQuestCanvas128.screenWidth / 2, FroggerQuestCanvas128.screenHeight - 2, 17);
                        } else {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("DONE", FroggerQuestCanvas128.screenWidth / 2, FroggerQuestCanvas128.screenHeight - 12, 17);
                        }
                    }
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0xFFFFFF);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setFont(FroggerQuestCanvas128.access$1600(FroggerQuestCanvas128.this));
                    if (FroggerQuestCanvas128.language == 0) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u9752\u86d9\u4efb\u52d9 1.0.0", x, 36, 17);
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u00a9 2009 \u7248\u6b0a\u6240\u6709", x, 48, 17);
                    } else if (FroggerQuestCanvas128.language == 1) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u9752\u86d9\u4efb\u52a1 1.0.0", x, 36, 17);
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u00a9 2009 \u7248\u6743\u6240\u6709", x, 48, 17);
                    } else {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("FROGGER QUEST 1.0.0", x, 36, 17);
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("\u00a9 2009 ALL RIGHTS RESERVED", x, 48, 17);
                    }
                    if (this.temp > 0) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("CREDITS", FroggerQuestCanvas128.screenWidth / 2, 6, 17);
                    }
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setFont(FroggerQuestCanvas128.access$1700(FroggerQuestCanvas128.this));
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("PUBLISHED BY", x, 48, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("DEVELOPED BY", x, 84, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("GAME DESIGN", x + FroggerQuestCanvas128.screenWidth, 36, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("PROGRAMMERS", x + FroggerQuestCanvas128.screenWidth, 72, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("ARTIST", x + FroggerQuestCanvas128.screenWidth * 2, 24, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("PRODUCER", x + FroggerQuestCanvas128.screenWidth * 2, 66, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("TESTER", x + FroggerQuestCanvas128.screenWidth * 2, 90, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setFont(FroggerQuestCanvas128.access$1800(FroggerQuestCanvas128.this));
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("RZ2 GAMES", x, 60, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("RZ2 GAMES", x, 96, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("KAMESHWAR", x + FroggerQuestCanvas128.screenWidth, 48, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("PARUL SHEORAN", x + FroggerQuestCanvas128.screenWidth, 96, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("BHAWANI PRATAP", x + FroggerQuestCanvas128.screenWidth, 84, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("SANDEEP SHARMA", x + FroggerQuestCanvas128.screenWidth * 2, 36, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("MAYANK SHARMA", x + FroggerQuestCanvas128.screenWidth * 2, 48, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("SIMON BANERJEE", x + FroggerQuestCanvas128.screenWidth * 2, 78, 17);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawString("RANJOY DATTA", x + FroggerQuestCanvas128.screenWidth * 2, 102, 17);
                    if (FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) == -6) {
                        FroggerQuestCanvas128.access$202(FroggerQuestCanvas128.this, 4);
                        this.temp = 0;
                    } else if (FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) == 1 && this.temp < 2) {
                        this.temp += FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this);
                    } else if (FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) == -1 && this.temp > 0) {
                        this.temp += FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this);
                    }
                    FroggerQuestCanvas128.access$1402(FroggerQuestCanvas128.this, 0);
                    break;
                }
                case 2: {
                    if (FroggerQuestCanvas128.access$1900(FroggerQuestCanvas128.this) > 0 && FroggerQuestCanvas128.musicPlayer[0].getState() != 400) {
                        try {
                            FroggerQuestCanvas128.musicPlayer[0].start();
                        }
                        catch (Exception ex) {
                            System.out.println("exx:" + ex);
                            ex.printStackTrace();
                        }
                    }
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawImage(FroggerQuestCanvas128.access$400(FroggerQuestCanvas128.this), 0, 0, 0);
                    this.DrawCommands();
                    for (i = 0; i < FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) * 3; ++i) {
                        FroggerQuestCanvas128.access$2000(FroggerQuestCanvas128.this).setPosition(this.levelX[i] - 8, this.levelY[i] - 16);
                        FroggerQuestCanvas128.access$2000(FroggerQuestCanvas128.this).paint(FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this));
                    }
                    for (i = 0; i < 3; ++i) {
                        if (!this.levelCleared[i]) continue;
                        FroggerQuestCanvas128.access$2000(FroggerQuestCanvas128.this).setPosition(this.levelX[i + FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) * 3] - 8, this.levelY[i + FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) * 3] - 16);
                        FroggerQuestCanvas128.access$2000(FroggerQuestCanvas128.this).paint(FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this));
                    }
                    x = FroggerQuestCanvas128.access$2100(FroggerQuestCanvas128.this).getX();
                    if (x < (xx = this.levelX[FroggerQuestCanvas128.access$100(FroggerQuestCanvas128.this)] - 7)) {
                        x += (xx - x) / 3 + 1;
                    } else if (x > xx) {
                        x -= (x - xx) / 3 + 1;
                    }
                    y = FroggerQuestCanvas128.access$2100(FroggerQuestCanvas128.this).getY();
                    yy = this.levelY[FroggerQuestCanvas128.access$100(FroggerQuestCanvas128.this)] - 25;
                    if (y < yy) {
                        y += (yy - y) / 3 + 1;
                    } else if (y > yy) {
                        y -= (y - yy) / 3 + 1;
                    }
                    FroggerQuestCanvas128.access$2100(FroggerQuestCanvas128.this).setPosition(x, y);
                    FroggerQuestCanvas128.access$2100(FroggerQuestCanvas128.this).paint(FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this));
                    FroggerQuestCanvas128.access$2100(FroggerQuestCanvas128.this).nextFrame();
                    FroggerQuestCanvas128.access$2100(FroggerQuestCanvas128.this).paint(FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this));
                    for (i = FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this); i < this.lockX.length; ++i) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawImage(this.lock, this.lockX[i], this.lockY[i], 0);
                    }
                    if (FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) == -6) {
                        FroggerQuestCanvas128.this.menuIndex = 0;
                        FroggerQuestCanvas128.access$1302(FroggerQuestCanvas128.this, 0);
                        if (FroggerQuestCanvas128.language == 0) {
                            FroggerQuestCanvas128.access$902(FroggerQuestCanvas128.this, FroggerQuestCanvas128.access$1000(FroggerQuestCanvas128.this));
                        } else if (FroggerQuestCanvas128.language == 1) {
                            FroggerQuestCanvas128.access$902(FroggerQuestCanvas128.this, FroggerQuestCanvas128.access$1100(FroggerQuestCanvas128.this));
                        } else {
                            FroggerQuestCanvas128.access$902(FroggerQuestCanvas128.this, FroggerQuestCanvas128.access$1200(FroggerQuestCanvas128.this));
                        }
                        FroggerQuestCanvas128.access$600(FroggerQuestCanvas128.this, 0);
                        FroggerQuestCanvas128.access$302(FroggerQuestCanvas128.this, 0);
                        FroggerQuestCanvas128.access$202(FroggerQuestCanvas128.this, 4);
                    } else if ((FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) & 256) != 0 || FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) == -7) {
                        this.currentIsland = FroggerQuestCanvas128.access$100(FroggerQuestCanvas128.this) / 3;
                        FroggerQuestCanvas128.access$2200(FroggerQuestCanvas128.this);
                        FroggerQuestCanvas128.this.levelState();
                        FroggerQuestCanvas128.access$302(FroggerQuestCanvas128.this, 0);
                        FroggerQuestCanvas128.access$600(FroggerQuestCanvas128.this, 1);
                        FroggerQuestCanvas128.access$202(FroggerQuestCanvas128.this, 8);
                    } else if ((FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) & 2) != 0) {
                        FroggerQuestCanvas128.access$120(FroggerQuestCanvas128.this, 3);
                        if (FroggerQuestCanvas128.access$100(FroggerQuestCanvas128.this) < 0) {
                            FroggerQuestCanvas128.access$102(FroggerQuestCanvas128.this, 0);
                        }
                    } else if ((FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) & 64) != 0) {
                        FroggerQuestCanvas128.access$112(FroggerQuestCanvas128.this, 3);
                        if (FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) == 5) {
                            if (FroggerQuestCanvas128.access$100(FroggerQuestCanvas128.this) > 18) {
                                FroggerQuestCanvas128.access$102(FroggerQuestCanvas128.this, 18);
                            }
                        } else if (FroggerQuestCanvas128.access$100(FroggerQuestCanvas128.this) > FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) * 3 + 2) {
                            FroggerQuestCanvas128.access$102(FroggerQuestCanvas128.this, FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) * 3 + 2);
                        }
                    } else if ((FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) & 4) != 0) {
                        FroggerQuestCanvas128.access$110(FroggerQuestCanvas128.this);
                        if (FroggerQuestCanvas128.access$100(FroggerQuestCanvas128.this) < 0) {
                            FroggerQuestCanvas128.access$102(FroggerQuestCanvas128.this, 0);
                        }
                    } else if ((FroggerQuestCanvas128.access$1400(FroggerQuestCanvas128.this) & 32) != 0) {
                        FroggerQuestCanvas128.access$108(FroggerQuestCanvas128.this);
                        if (FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) == 5) {
                            if (FroggerQuestCanvas128.access$100(FroggerQuestCanvas128.this) > 18) {
                                FroggerQuestCanvas128.access$102(FroggerQuestCanvas128.this, 18);
                            }
                        } else if (FroggerQuestCanvas128.access$100(FroggerQuestCanvas128.this) > FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) * 3 + 2) {
                            FroggerQuestCanvas128.access$102(FroggerQuestCanvas128.this, FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) * 3 + 2);
                        }
                    }
                    FroggerQuestCanvas128.access$1402(FroggerQuestCanvas128.this, 0);
                    break;
                }
                case 8: {
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawImage(FroggerQuestCanvas128.access$400(FroggerQuestCanvas128.this), 0, 0, 0);
                    if (FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) < 16) {
                        for (i = FroggerQuestCanvas128.access$2300() - 1; i >= 0; --i) {
                            for (j = FroggerQuestCanvas128.access$2400() - 1; j >= 0; --j) {
                                if (!FroggerQuestCanvas128.access$2500(FroggerQuestCanvas128.this)[i][j].isVisible()) continue;
                                FroggerQuestCanvas128.access$2500(FroggerQuestCanvas128.this)[i][j].setPosition(FroggerQuestCanvas128.access$2600(FroggerQuestCanvas128.this) + i * FroggerQuestCanvas128.access$2700() + FroggerQuestCanvas128.nextSignedInt(2), FroggerQuestCanvas128.access$2800(FroggerQuestCanvas128.this) + j * FroggerQuestCanvas128.access$2700() + FroggerQuestCanvas128.nextSignedInt(2));
                                FroggerQuestCanvas128.access$2500(FroggerQuestCanvas128.this)[i][j].paint(FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this));
                            }
                        }
                    } else if (FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) == 16) {
                        for (i = FroggerQuestCanvas128.access$2300() - 1; i >= 0; --i) {
                            for (j = FroggerQuestCanvas128.access$2400() - 1; j >= 0; --j) {
                                this.temp = FroggerQuestCanvas128.access$2900(FroggerQuestCanvas128.this).getCell(i, j);
                                if (this.temp != 0) continue;
                                FroggerQuestCanvas128.access$2500(FroggerQuestCanvas128.this)[i][j].setFrame(1);
                            }
                        }
                    } else if (FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) > 16 && FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) < 60) {
                        for (i = FroggerQuestCanvas128.access$2300() - 1; i >= 0; --i) {
                            for (j = FroggerQuestCanvas128.access$2400() - 1; j >= 0; --j) {
                                this.temp = FroggerQuestCanvas128.access$2500(FroggerQuestCanvas128.this)[i][j].getFrame();
                                if (this.temp > 0 && this.temp < 5) {
                                    if (FroggerQuestCanvas128.nextInt() % 3 == 0) {
                                        FroggerQuestCanvas128.access$2500(FroggerQuestCanvas128.this)[i][j].setFrame(this.temp + 1);
                                        FroggerQuestCanvas128.access$2500(FroggerQuestCanvas128.this)[i][j].setPosition(FroggerQuestCanvas128.access$2600(FroggerQuestCanvas128.this) + i * FroggerQuestCanvas128.access$2700(), FroggerQuestCanvas128.access$2800(FroggerQuestCanvas128.this) + j * FroggerQuestCanvas128.access$2700() + this.temp * FroggerQuestCanvas128.access$2700());
                                    }
                                } else if (this.temp == 5) {
                                    FroggerQuestCanvas128.access$2500(FroggerQuestCanvas128.this)[i][j].setVisible(false);
                                }
                                FroggerQuestCanvas128.access$2500(FroggerQuestCanvas128.this)[i][j].paint(FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this));
                            }
                        }
                    } else {
                        try {
                            FroggerQuestCanvas128.musicPlayer[0].stop();
                        }
                        catch (Exception ex) {
                            System.out.println("exx:" + ex);
                            ex.printStackTrace();
                        }
                        FroggerQuestCanvas128.access$202(FroggerQuestCanvas128.this, 10);
                        FroggerQuestCanvas128.access$3000(FroggerQuestCanvas128.this);
                    }
                    FroggerQuestCanvas128.access$308(FroggerQuestCanvas128.this);
                    break;
                }
                case 4: {
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawImage(FroggerQuestCanvas128.access$400(FroggerQuestCanvas128.this), 0, 0, 0);
                    FroggerQuestCanvas128.access$700(FroggerQuestCanvas128.this);
                    FroggerQuestCanvas128.access$800(FroggerQuestCanvas128.this);
                    if (FroggerQuestCanvas128.access$1300(FroggerQuestCanvas128.this) == 3) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0xFFFFFFF);
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setFont(FroggerQuestCanvas128.access$1600(FroggerQuestCanvas128.this));
                        if (FroggerQuestCanvas128.language == 0) {
                            v0 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v1 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v0.drawString("\u9078\u64c7", v1, 2, 16 | 1);
                        } else if (FroggerQuestCanvas128.language == 1) {
                            v2 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v3 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v2.drawString("\u9009\u62e9", v3, 2, 16 | 1);
                        } else {
                            v4 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v5 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v4.drawString("OPTIONS", v5, 2, 16 | 1);
                        }
                    } else if (FroggerQuestCanvas128.access$1300(FroggerQuestCanvas128.this) == 5) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0xFFFFFFF);
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setFont(FroggerQuestCanvas128.access$1600(FroggerQuestCanvas128.this));
                        if (FroggerQuestCanvas128.language == 0) {
                            v6 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v7 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v6.drawString("\u632f\u52d5", v7, 2, 16 | 1);
                        } else if (FroggerQuestCanvas128.language == 1) {
                            v8 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v9 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v8.drawString("\u632f\u52a8", v9, 2, 16 | 1);
                        } else {
                            v10 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v11 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v10.drawString("VIBRATION", v11, 2, 16 | 1);
                        }
                    } else if (FroggerQuestCanvas128.access$1300(FroggerQuestCanvas128.this) == 4) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0xFFFFFFF);
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setFont(FroggerQuestCanvas128.access$1600(FroggerQuestCanvas128.this));
                        if (FroggerQuestCanvas128.language == 0) {
                            v12 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v13 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v12.drawString("\u8072\u97f3", v13, 2, 16 | 1);
                        } else if (FroggerQuestCanvas128.language == 1) {
                            v14 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v15 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v14.drawString("\u58f0\u97f3", v15, 2, 16 | 1);
                        } else {
                            v16 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v17 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v16.drawString("SOUND VOLUME", v17, 2, 16 | 1);
                        }
                    } else if (FroggerQuestCanvas128.access$1300(FroggerQuestCanvas128.this) == 8) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0xFFFFFFF);
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setFont(FroggerQuestCanvas128.access$1600(FroggerQuestCanvas128.this));
                        if (FroggerQuestCanvas128.language == 0) {
                            v18 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v19 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v18.drawString("\u8a9e\u8a00", v19, 2, 16 | 1);
                        } else if (FroggerQuestCanvas128.language == 1) {
                            v20 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v21 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v20.drawString("\u8bed\u8a00", v21, 2, 16 | 1);
                        } else {
                            v22 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v23 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v22.drawString("LANGUAGE", v23, 2, 16 | 1);
                        }
                    } else if (FroggerQuestCanvas128.access$1300(FroggerQuestCanvas128.this) == 7) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0xFFFFFF);
                        if (FroggerQuestCanvas128.language == 0) {
                            v24 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v25 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v24.drawString("\u78ba\u5b9a?", v25, 2, 16 | 1);
                        } else if (FroggerQuestCanvas128.language == 1) {
                            v26 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v27 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v26.drawString("\u786e\u5b9a?", v27, 2, 16 | 1);
                        } else {
                            v28 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v29 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v28.drawString("ARE U SURE?", v29, 2, 16 | 1);
                        }
                    } else if (FroggerQuestCanvas128.access$3100(FroggerQuestCanvas128.this)) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0xFFFFFF);
                        if (FroggerQuestCanvas128.language == 0) {
                            v30 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v31 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v30.drawString("\u904a\u6232\u66ab\u505c", v31, 2, 16 | 1);
                        } else if (FroggerQuestCanvas128.language == 1) {
                            v32 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v33 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v32.drawString("\u6e38\u620f\u6682\u505c", v33, 2, 16 | 1);
                        } else {
                            v34 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v35 = FroggerQuestCanvas128.screenWidth / 2;
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                            v34.drawString("GAME PAUSED", v35, 2, 16 | 1);
                        }
                    }
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0xFF1122);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawLine(0, 14, FroggerQuestCanvas128.screenWidth, 14);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0x88DD77);
                    if (FroggerQuestCanvas128.access$1300(FroggerQuestCanvas128.this) == 4) {
                        for (y = 16; y < (FroggerQuestCanvas128.access$900(FroggerQuestCanvas128.this).length + 1) * 12; y += 4) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawLine(0, y, FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this), y);
                        }
                        for (y = 18; y < (FroggerQuestCanvas128.access$900(FroggerQuestCanvas128.this).length + 1) * 12; y += 4) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawLine(FroggerQuestCanvas128.screenWidth - FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this), y, FroggerQuestCanvas128.screenWidth, y);
                        }
                    } else {
                        for (y = 16; y < (FroggerQuestCanvas128.access$900(FroggerQuestCanvas128.this).length + 1) * 14; y += 4) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawLine(0, y, FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this), y);
                        }
                        for (y = 18; y < (FroggerQuestCanvas128.access$900(FroggerQuestCanvas128.this).length + 1) * 14; y += 4) {
                            FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawLine(FroggerQuestCanvas128.screenWidth - FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this), y, FroggerQuestCanvas128.screenWidth, y);
                        }
                    }
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0xFF1122);
                    if (FroggerQuestCanvas128.access$1300(FroggerQuestCanvas128.this) == 4) {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawLine(0, (FroggerQuestCanvas128.access$900(FroggerQuestCanvas128.this).length + 1) * 12, FroggerQuestCanvas128.screenWidth, (FroggerQuestCanvas128.access$900(FroggerQuestCanvas128.this).length + 1) * 12);
                    } else {
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawLine(0, (FroggerQuestCanvas128.access$900(FroggerQuestCanvas128.this).length + 1) * 14, FroggerQuestCanvas128.screenWidth, (FroggerQuestCanvas128.access$900(FroggerQuestCanvas128.this).length + 1) * 14);
                    }
                    if (FroggerQuestCanvas128.access$300(FroggerQuestCanvas128.this) < FroggerQuestCanvas128.screenWidth) {
                        FroggerQuestCanvas128.access$312(FroggerQuestCanvas128.this, 20);
                        break;
                    }
                    FroggerQuestCanvas128.access$302(FroggerQuestCanvas128.this, FroggerQuestCanvas128.screenWidth);
                    FroggerQuestCanvas128.this.animateMainMenu();
                    this.temp = 0;
                    break;
                }
                case 1: {
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawImage(FroggerQuestCanvas128.access$400(FroggerQuestCanvas128.this), 0, 0, 0);
                    for (i = 0; i < FroggerQuestCanvas128.access$3200(FroggerQuestCanvas128.this).length; ++i) {
                        v36 = FroggerQuestCanvas128.access$3200(FroggerQuestCanvas128.this);
                        v37 = i;
                        v36[v37] = v36[v37] + (5 + FroggerQuestCanvas128.nextInt(3));
                        FroggerQuestCanvas128.access$3400(FroggerQuestCanvas128.this).setPosition(FroggerQuestCanvas128.access$3200(FroggerQuestCanvas128.this)[i], FroggerQuestCanvas128.access$3300(FroggerQuestCanvas128.this)[i]);
                        FroggerQuestCanvas128.access$3400(FroggerQuestCanvas128.this).nextFrame();
                        FroggerQuestCanvas128.access$3400(FroggerQuestCanvas128.this).paint(FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this));
                    }
                    if (FroggerQuestCanvas128.access$3200(FroggerQuestCanvas128.this)[2] < FroggerQuestCanvas128.screenWidth) break;
                    FroggerQuestCanvas128.access$108(FroggerQuestCanvas128.this);
                    FroggerQuestCanvas128.access$302(FroggerQuestCanvas128.this, 0);
                    FroggerQuestCanvas128.access$600(FroggerQuestCanvas128.this, 2);
                    FroggerQuestCanvas128.access$202(FroggerQuestCanvas128.this, 2);
                    break;
                }
                case 10: {
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).drawImage(FroggerQuestCanvas128.access$400(FroggerQuestCanvas128.this), 0, 0, 0);
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setFont(FroggerQuestCanvas128.access$1600(FroggerQuestCanvas128.this));
                    FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this).setColor(0);
                    FroggerQuestCanvas128.access$3502(FroggerQuestCanvas128.access$1600(FroggerQuestCanvas128.this).charWidth('C'));
                    if (FroggerQuestCanvas128.language == 0) {
                        str = "\u66ab\u505c";
                        v38 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                        v39 = FroggerQuestCanvas128.screenWidth - str.length() * FroggerQuestCanvas128.access$3500() - 5;
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                        v38.drawString("\u66ab\u505c", v39, FroggerQuestCanvas128.screenHeight - 5, 32 | 4);
                    } else if (FroggerQuestCanvas128.language == 1) {
                        str = "\u6682\u505c";
                        v40 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                        v41 = FroggerQuestCanvas128.screenWidth - str.length() * FroggerQuestCanvas128.access$3500() - 5;
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                        v40.drawString("\u6682\u505c", v41, FroggerQuestCanvas128.screenHeight - 5, 32 | 4);
                    } else {
                        str = "PAUSE";
                        v42 = FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                        v43 = FroggerQuestCanvas128.screenWidth - str.length() * FroggerQuestCanvas128.access$3500();
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                        FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this);
                        v42.drawString("PAUSE", v43, FroggerQuestCanvas128.screenHeight - 5, 32 | 4);
                    }
                    FroggerQuestCanvas128.this.input();
                    FroggerQuestCanvas128.access$3600(FroggerQuestCanvas128.this).paint(FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this));
                    for (i = FroggerQuestCanvas128.access$2300() - 1; i >= 0; --i) {
                        for (j = FroggerQuestCanvas128.access$2400() - 1; j >= 0; --j) {
                            FroggerQuestCanvas128.access$2500(FroggerQuestCanvas128.this)[i][j].paint(FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this));
                        }
                    }
                    FroggerQuestCanvas128.access$1500(FroggerQuestCanvas128.this).paint(FroggerQuestCanvas128.access$500(FroggerQuestCanvas128.this));
                    cellsLeft = 0;
                    for (i = 0; i < FroggerQuestCanvas128.access$2300(); ++i) {
                        for (j = 0; j < FroggerQuestCanvas128.access$2400(); ++j) {
                            if (FroggerQuestCanvas128.access$2900(FroggerQuestCanvas128.this).getCell(i, j) == 0) continue;
                            ++cellsLeft;
                        }
                    }
                    if (cellsLeft != true || FroggerQuestCanvas128.access$3700(FroggerQuestCanvas128.this) != 0) ** GOTO lbl693
                    if (FroggerQuestCanvas128.access$1900(FroggerQuestCanvas128.this) > 0) {
                        // empty if block
                    }
                    if (FroggerQuestCanvas128.access$100(FroggerQuestCanvas128.this) < FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) * 3) ** GOTO lbl688
                    if (FroggerQuestCanvas128.access$100(FroggerQuestCanvas128.this) != 18) ** GOTO lbl677
                    this.levelCleared[3] = true;
                    if (this.levelCleared[0] && this.levelCleared[1] && this.levelCleared[2] && this.levelCleared[3]) {
                        this.setIslandClearedState();
                        break;
                    }
                    for (i = 0; i < 3; ++i) {
                        if (this.levelCleared[i]) continue;
                        FroggerQuestCanvas128.access$102(FroggerQuestCanvas128.this, FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) * 3 + i);
                        ** GOTO lbl688
                    }
                    ** GOTO lbl688
lbl677:
                    // 1 sources

                    this.levelCleared[FroggerQuestCanvas128.access$100((FroggerQuestCanvas128)FroggerQuestCanvas128.this) % 3] = true;
                    if (this.levelCleared[0] && this.levelCleared[1] && this.levelCleared[2]) {
                        this.setIslandClearedState();
                        if (FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) != 5) break;
                        this.levelCleared = new boolean[4];
                        break;
                    }
                    for (i = 0; i < 4; ++i) {
                        if (this.levelCleared[i]) continue;
                        FroggerQuestCanvas128.access$102(FroggerQuestCanvas128.this, FroggerQuestCanvas128.access$000(FroggerQuestCanvas128.this) * 3 + i);
                        break;
                    }
lbl688:
                    // 5 sources

                    FroggerQuestCanvas128.access$302(FroggerQuestCanvas128.this, 0);
                    FroggerQuestCanvas128.access$600(FroggerQuestCanvas128.this, 2);
                    FroggerQuestCanvas128.access$202(FroggerQuestCanvas128.this, 2);
lbl693:
                    // 2 sources

                    FroggerQuestCanvas128.this.getKeyStates();
                }
            }
            FroggerQuestCanvas128.this.flushGraphics();
        }

        private void setIslandClearedState() {
            this.islandCleared = true;
            FroggerQuestCanvas128.access$3202(FroggerQuestCanvas128.this, new int[this.levelCleared.length]);
            FroggerQuestCanvas128.access$3302(FroggerQuestCanvas128.this, new int[this.levelCleared.length]);
            for (int i = 0; i < this.levelCleared.length; ++i) {
                this.levelCleared[i] = false;
                ((FroggerQuestCanvas128)FroggerQuestCanvas128.this).dragonX[i] = -20 * i - FroggerQuestCanvas128.nextInt(screenWidth / 4);
                ((FroggerQuestCanvas128)FroggerQuestCanvas128.this).dragonY[i] = 30 + FroggerQuestCanvas128.nextInt(screenHeight / 2);
            }
            FroggerQuestCanvas128.this.iv_islandsCleared++;
            ++this.currentIsland;
            FroggerQuestCanvas128.this.traverseIndex = 0;
            FroggerQuestCanvas128.this.changeBackImage(3);
            FroggerQuestCanvas128.this.gameState = 1;
            if (FroggerQuestCanvas128.this.dragonSprite == null) {
                try {
                    FroggerQuestCanvas128.this.dragonSprite = new Sprite(Image.createImage((String)"/drg.png"), 39, 40);
                }
                catch (IOException ex) {
                    System.out.println("dragon image not found");
                    ex.printStackTrace();
                }
            }
            FroggerQuestCanvas128.this.writeRMS();
            FroggerQuestCanvas128.this.getKeyStates();
        }

        private void DrawCommands() {
            FroggerQuestCanvas128.this.g.setFont(FroggerQuestCanvas128.this.SMALLFONT);
            FroggerQuestCanvas128.this.g.setColor(0);
            if (language == 0) {
                fWidth = FroggerQuestCanvas128.this.SMALLFONT.charWidth('\u958b');
                String str = "\u958b\u59cb";
                Graphics graphics = FroggerQuestCanvas128.this.g;
                int n = screenWidth - str.length() * fWidth - 13;
                FroggerQuestCanvas128.this.g;
                FroggerQuestCanvas128.this.g;
                graphics.drawString("\u958b\u59cb", n, screenHeight - 10, 0x10 | 4);
                Graphics graphics2 = FroggerQuestCanvas128.this.g;
                FroggerQuestCanvas128.this.g;
                FroggerQuestCanvas128.this.g;
                graphics2.drawString("\u8fd4\u56de", 13, screenHeight - 10, 0x10 | 4);
            } else if (language == 1) {
                fWidth = FroggerQuestCanvas128.this.SMALLFONT.charWidth('\u5f00');
                String str = "\u5f00\u59cb";
                Graphics graphics = FroggerQuestCanvas128.this.g;
                int n = screenWidth - str.length() * fWidth - 13;
                FroggerQuestCanvas128.this.g;
                FroggerQuestCanvas128.this.g;
                graphics.drawString("\u5f00\u59cb", n, screenHeight - 10, 0x10 | 4);
                Graphics graphics3 = FroggerQuestCanvas128.this.g;
                FroggerQuestCanvas128.this.g;
                FroggerQuestCanvas128.this.g;
                graphics3.drawString("\u8fd4\u56de", 13, screenHeight - 10, 0x10 | 4);
            } else {
                fWidth = FroggerQuestCanvas128.this.SMALLFONT.charWidth('C');
                String str = "START";
                Graphics graphics = FroggerQuestCanvas128.this.g;
                int n = screenWidth - str.length() * fWidth - 7;
                FroggerQuestCanvas128.this.g;
                FroggerQuestCanvas128.this.g;
                graphics.drawString("START", n, screenHeight - 10, 0x10 | 4);
                Graphics graphics4 = FroggerQuestCanvas128.this.g;
                FroggerQuestCanvas128.this.g;
                FroggerQuestCanvas128.this.g;
                graphics4.drawString("BACK", 13, screenHeight - 10, 0x10 | 4);
            }
        }
    }
}

