/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.ingame;

import com.jarbull.mgs.game.ingame.GolfCourse;
import com.jarbull.mgs.math.MathEx;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;

public class Hole
extends Sprite {
    private static final int TILE_WIDTH = 16;
    private static final int TILE_HEIGHT = 13;
    private Flag flag;

    public Hole(GolfCourse golfCourse, int x, int y, boolean showFlag) throws IOException {
        super(Image.createImage((String)"/res/image/ingame/hole.png"), 16, 13);
        if (showFlag) {
            this.flag = new Flag();
            golfCourse.insert((Layer)this.flag, 0);
            this.flag.setPosition(x + 5, y - 33 + 13 - 3);
        }
        golfCourse.append((Layer)this);
        this.setPosition(x, y);
    }

    public boolean hasPoint(double x, double y) {
        return Math.sqrt(MathEx.sqr((double)(this.getX() + 8) - x) + MathEx.sqr((double)(this.getY() + 6) - y)) < 6.0;
    }

    public void stopFlag() {
        this.flag.waveTimer.cancel();
    }

    private class Flag
    extends Sprite {
        private static final int TILE_WIDTH = 20;
        private static final int TILE_HEIGHT = 33;
        private Timer waveTimer;

        private Flag() throws IOException {
            super(Image.createImage((String)"/res/image/ingame/flag.png"), 20, 33);
            this.setFrame(0);
            this.waveTimer = new Timer();
            this.waveTimer.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    Hole.this.flag.nextFrame();
                }
            }, 0L, 140L);
        }
    }
}

