/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.ingame;

import com.jarbull.mgs.game.ingame.Ball;
import com.jarbull.mgs.game.ingame.GolfCourse;
import com.jarbull.mgs.math.Vector2D;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

public class WormHole {
    public static final int WORM_HOLE_NONE = 0;
    public static final int WORM_HOLE_HOLE1 = 1;
    public static final int WORM_HOLE_HOLE2 = 2;
    private static final int TILE_WIDTH = 20;
    private static final int TILE_HEIGHT = 20;
    private static final Vector2D leftVector = new Vector2D(-1.0, 0.0);
    private static final Vector2D rightVector = new Vector2D(1.0, 0.0);
    private static final Vector2D upVector = new Vector2D(0.0, 1.0);
    private static final Vector2D downVector = new Vector2D(0.0, -1.0);
    private TiledLayer hole1 = new TiledLayer(1, 1, Image.createImage((String)"/res/image/ingame/wormhole.png"), 20, 20);
    private TiledLayer hole2;
    private int hitHole = 0;
    private boolean ballLeaving = false;
    public boolean hasBall = false;

    public WormHole(GolfCourse golfCourse, int x1, int y1, int direction1, int x2, int y2, int direction2) throws IOException {
        this.hole1.setCell(0, 0, direction1);
        golfCourse.append((Layer)this.hole1);
        this.hole1.setPosition(x1, y1);
        this.hole2 = new TiledLayer(1, 1, Image.createImage((String)"/res/image/ingame/wormhole.png"), 20, 20);
        this.hole2.setCell(0, 0, direction2);
        golfCourse.append((Layer)this.hole2);
        this.hole2.setPosition(x2, y2);
    }

    private int collidesWith(Sprite sprite) {
        if (sprite.collidesWith(this.hole1, true)) {
            return 1;
        }
        if (sprite.collidesWith(this.hole2, true)) {
            return 2;
        }
        return 0;
    }

    public int isInside(int x, int y) {
        if (x >= this.hole1.getX() && x < this.hole1.getX() + this.hole1.getWidth() && y >= this.hole1.getY() && y < this.hole1.getY() + this.hole1.getHeight()) {
            return 1;
        }
        if (x >= this.hole2.getX() && x < this.hole2.getX() + this.hole2.getWidth() && y >= this.hole2.getY() && y < this.hole2.getY() + this.hole2.getHeight()) {
            return 2;
        }
        return 0;
    }

    public int getDirection(int hole) {
        switch (hole) {
            case 1: {
                return this.hole1.getCell(0, 0);
            }
            case 2: {
                return this.hole2.getCell(0, 0);
            }
        }
        return 0;
    }

    public void teleport(Ball ball, int toHole) {
        TiledLayer hole = toHole == 1 ? this.hole1 : this.hole2;
        switch (this.getDirection(toHole)) {
            case 1: {
                ball.setPosition(hole.getX() + hole.getWidth() - ball.getWidth() + 1, hole.getY() + hole.getHeight() / 2 - ball.getHeight() / 2);
                ball.angle = 0.0;
                break;
            }
            case 3: {
                ball.setPosition(hole.getX() + hole.getWidth() / 2 - ball.getWidth() / 2, hole.getY() - 1);
                ball.angle = 270.0;
                break;
            }
            case 2: {
                ball.setPosition(hole.getX() - 1, hole.getY() + hole.getHeight() / 2 - ball.getHeight() / 2);
                ball.angle = 180.0;
                break;
            }
            case 4: {
                ball.setPosition(hole.getX() + hole.getWidth() / 2 - ball.getWidth() / 2, hole.getY() + hole.getHeight() - ball.getHeight() + 1);
                ball.angle = 90.0;
            }
        }
        this.ballLeaving = true;
    }

    public boolean hasLeavingBall() {
        return this.ballLeaving;
    }

    public void ballLeft() {
        this.ballLeaving = false;
        this.hasBall = false;
    }

    public int getX(int hole) {
        return hole == 1 ? this.hole1.getX() : this.hole2.getX();
    }

    public int getY(int hole) {
        return hole == 1 ? this.hole1.getY() : this.hole2.getY();
    }

    public int getWidth() {
        return 20;
    }

    public int getHeight() {
        return 20;
    }

    public boolean checkCollision(Ball ball) {
        this.hitHole = this.collidesWith(ball);
        if (this.hitHole != 0 && !this.hasLeavingBall()) {
            return true;
        }
        this.ballLeft();
        return false;
    }

    public boolean responseCollision(Ball ball, boolean isMovedBack) {
        int holeDirection = this.getDirection(this.hitHole);
        int right = this.isInside(ball.getX() + ball.getWidth() - 1, ball.getY() + ball.getHeight() / 2);
        int left = this.isInside(ball.getX(), ball.getY() + ball.getHeight() / 2);
        int bottom = this.isInside(ball.getX() + ball.getWidth() / 2, ball.getY() + ball.getHeight() - 1);
        int top = this.isInside(ball.getX() + ball.getWidth() / 2, ball.getY());
        int totalPointsInside = (right + left + bottom + top) / this.hitHole;
        int ballCenterX = ball.getX() + ball.getWidth() / 2 - 1;
        int ballCenterY = ball.getY() + ball.getHeight() / 2 - 1;
        int leftX = this.getX(this.hitHole);
        int rightX = this.getX(this.hitHole) + this.getWidth() - 1;
        int topY = this.getY(this.hitHole);
        int bottomY = this.getY(this.hitHole) + this.getHeight() - 1;
        if (totalPointsInside == 4) {
            this.teleport(ball, this.hitHole == 1 ? 2 : 1);
        }
        if (!this.hasBall) {
            if (right != 0) {
                if (holeDirection != 2) {
                    if (!isMovedBack) {
                        ball.moveBack();
                        isMovedBack = true;
                    }
                    ball.reflect(leftVector);
                } else {
                    this.hasBall = true;
                }
            }
            if (left != 0) {
                if (holeDirection != 1) {
                    if (!isMovedBack) {
                        ball.moveBack();
                        isMovedBack = true;
                    }
                    ball.reflect(rightVector);
                } else {
                    this.hasBall = true;
                }
            }
            if (bottom != 0) {
                if (holeDirection != 3) {
                    if (!isMovedBack) {
                        ball.moveBack();
                        isMovedBack = true;
                    }
                    ball.reflect(upVector);
                } else {
                    this.hasBall = true;
                }
            }
            if (top != 0) {
                if (holeDirection != 4) {
                    if (!isMovedBack) {
                        ball.moveBack();
                        isMovedBack = true;
                    }
                    ball.reflect(downVector);
                } else {
                    this.hasBall = true;
                }
            }
        }
        int cornerX = 0;
        int cornerY = 0;
        if (ball.hasPoint(leftX, topY)) {
            cornerX = leftX;
            cornerY = topY;
        } else if (ball.hasPoint(leftX, bottomY)) {
            cornerX = leftX;
            cornerY = bottomY;
        } else if (ball.hasPoint(rightX, topY)) {
            cornerX = rightX;
            cornerY = topY;
        } else if (ball.hasPoint(rightX, bottomY)) {
            cornerX = rightX;
            cornerY = bottomY;
        }
        if (cornerX != 0 || cornerY != 0) {
            if (!isMovedBack) {
                ball.moveBack();
                isMovedBack = true;
            }
            ball.reflect(new Vector2D(ballCenterX - cornerX, ballCenterY - cornerY).normalize());
        }
        return isMovedBack;
    }
}

