/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.ingame;

import com.jarbull.mgs.game.ingame.Ball;
import com.jarbull.mgs.game.ingame.GolfCourse;
import com.jarbull.mgs.math.Vector2D;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.TiledLayer;

public class Wall
extends TiledLayer {
    private static final int TILE_WIDTH = 10;
    private static final int TILE_HEIGHT = 10;
    private static final Vector2D leftVector = new Vector2D(-1.0, 0.0);
    private static final Vector2D rightVector = new Vector2D(1.0, 0.0);
    private static final Vector2D upVector = new Vector2D(0.0, 1.0);
    private static final Vector2D downVector = new Vector2D(0.0, -1.0);

    public Wall(GolfCourse golfCourse, int width, int height, int x, int y) throws IOException {
        super(width / 10, height / 10, Image.createImage((String)"/res/image/ingame/wall.png"), 10, 10);
        int columns = width / 10;
        int rows = height / 10;
        if (columns == 1) {
            for (int i = columns * rows - 1; i >= 0; --i) {
                int row = (i - i % columns) / columns;
                if (row == 0) {
                    this.setCell(0, 0, 6);
                    continue;
                }
                if (row == rows - 1) {
                    this.setCell(0, row, 10);
                    continue;
                }
                this.setCell(0, row, (rows - row) % 3 + 7);
            }
        } else {
            for (int i = columns * rows - 1; i >= 0; --i) {
                int column = i % columns;
                int row = (i - column) / columns;
                if (column == 0) {
                    this.setCell(0, row, 1);
                    continue;
                }
                if (column == columns - 1) {
                    this.setCell(column, row, 5);
                    continue;
                }
                this.setCell(column, row, (columns - column) % 3 + 2);
            }
        }
        golfCourse.append((Layer)this);
        this.setPosition(x, y);
    }

    public boolean isInside(int x, int y) {
        return x >= this.getX() && x < this.getX() + this.getWidth() && y >= this.getY() && y < this.getY() + this.getHeight();
    }

    public boolean checkCollision(Ball ball) {
        return ball.collidesWith(this, true);
    }

    public boolean responseCollision(Ball ball, boolean isMovedBack) {
        int ballCenterX = ball.getX() + ball.getWidth() / 2;
        int ballCenterY = ball.getY() + ball.getHeight() / 2;
        if (this.isInside(ball.getX() + ball.getWidth() - 1, ballCenterY)) {
            ball.moveBack();
            isMovedBack = true;
            ball.reflect(leftVector);
        } else if (this.isInside(ball.getX(), ballCenterY)) {
            ball.moveBack();
            isMovedBack = true;
            ball.reflect(rightVector);
        }
        if (this.isInside(ballCenterX, ball.getY() + ball.getHeight() - 1)) {
            if (!isMovedBack) {
                ball.moveBack();
                isMovedBack = true;
            }
            ball.reflect(upVector);
        } else if (this.isInside(ballCenterX, ball.getY())) {
            if (!isMovedBack) {
                ball.moveBack();
                isMovedBack = true;
            }
            ball.reflect(downVector);
        }
        if (!isMovedBack) {
            ball.moveBack();
            isMovedBack = true;
            int[] pointsX = new int[]{this.getX(), this.getX() + this.getWidth() - 1};
            int[] pointsY = new int[]{this.getY(), this.getY() + this.getHeight() - 1};
            int cornerX = 0;
            int cornerY = 0;
            int distanceX = Integer.MAX_VALUE;
            int distanceY = Integer.MAX_VALUE;
            for (int i = 3; i >= 0; --i) {
                int newDistanceY;
                int newDistanceX = Math.abs(pointsX[i % 2] - ballCenterX);
                if (distanceX > newDistanceX) {
                    cornerX = pointsX[i % 2];
                    distanceX = newDistanceX;
                }
                if (distanceY <= (newDistanceY = Math.abs(pointsY[i / 2] - ballCenterY))) continue;
                cornerY = pointsY[i / 2];
                distanceY = newDistanceY;
            }
            ball.reflect(new Vector2D(ballCenterX - cornerX, ballCenterY - cornerY).normalize());
        }
        return isMovedBack;
    }
}

