/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.ingame;

import com.jarbull.mgs.game.ingame.Ball;
import com.jarbull.mgs.game.tools.LevelLoader;
import com.jarbull.mgs.math.Rectangle;
import com.jarbull.mgs.math.Vector2D;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.TiledLayer;

public class GolfCourse
extends LayerManager {
    private static final int TILE_WIDTH = 10;
    private static final int TILE_HEIGHT = 10;
    private static final Vector2D leftVector = new Vector2D(-1.0, 0.0);
    private static final Vector2D rightVector = new Vector2D(1.0, 0.0);
    private static final Vector2D upVector = new Vector2D(0.0, 1.0);
    private static final Vector2D downVector = new Vector2D(0.0, -1.0);
    private int LEVEL_COLUMNS = 0;
    private int LEVEL_ROWS = 0;
    private static final GolfCourse instance = new GolfCourse();
    private int[] courseMap;
    private TiledLayer outside;
    private TiledLayer course;
    private Image golfCourseBorderImage;
    private Image golfCourseGrassImage;
    private Image backgroundImage;

    private GolfCourse() {
        try {
            this.golfCourseBorderImage = Image.createImage((String)"/res/image/ingame/golfcourseborder.png");
            this.golfCourseGrassImage = Image.createImage((String)"/res/image/ingame/golfcoursegrass.png");
            this.backgroundImage = Image.createImage((String)"/res/image/ingame/background.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static GolfCourse getInstance() {
        return instance;
    }

    public void nullifyCourse() {
        this.courseMap = null;
        this.outside = null;
        this.course = null;
    }

    public void loadCourse() throws IOException {
        Rectangle mapSize = LevelLoader.getInstance().getMapSize();
        this.LEVEL_COLUMNS = mapSize.width / 10;
        this.LEVEL_ROWS = mapSize.height / 10;
        this.courseMap = LevelLoader.getInstance().loadMap();
        this.outside = new TiledLayer(this.LEVEL_COLUMNS, this.LEVEL_ROWS, this.golfCourseBorderImage, 10, 10);
        this.course = new TiledLayer(this.LEVEL_COLUMNS, this.LEVEL_ROWS, this.golfCourseGrassImage, 10, 10);
        for (int i = this.LEVEL_ROWS * this.LEVEL_COLUMNS - 1; i >= 0; --i) {
            int column = i % this.LEVEL_COLUMNS;
            int row = (i - column) / this.LEVEL_COLUMNS;
            if (this.courseMap[i] > 2) {
                this.course.setCell(column, row, this.courseMap[i] - 2);
                continue;
            }
            this.outside.setCell(column, row, this.courseMap[i]);
        }
        Rectangle[] decorations = LevelLoader.getInstance().loadDecorations();
        for (int i = decorations.length - 1; i >= 0; --i) {
            TiledLayer decoration = new TiledLayer(1, 1, decorations[i].image, decorations[i].width, decorations[i].height);
            decoration.setCell(0, 0, 1);
            this.append((Layer)decoration);
            decoration.setPosition(decorations[i].x, decorations[i].y);
        }
        this.append((Layer)this.course);
        this.append((Layer)this.outside);
        int backgroundColumns = (mapSize.width + 100) / (this.backgroundImage.getWidth() / 2) + 1;
        int backgroundRows = (mapSize.height + 100) / this.backgroundImage.getHeight() + 1;
        TiledLayer background = new TiledLayer(backgroundColumns, backgroundRows, this.backgroundImage, this.backgroundImage.getWidth() / 2, this.backgroundImage.getHeight());
        background.fillCells(0, 0, backgroundColumns, backgroundRows, 1);
        for (int i = 0; i < backgroundRows; i += 2) {
            background.fillCells(0, i, backgroundColumns, 1, 2);
        }
        this.append((Layer)background);
        background.setPosition(-50, -50);
    }

    public int getWidth() {
        return 10 * this.LEVEL_COLUMNS - 1;
    }

    public int getHeight() {
        return 10 * this.LEVEL_ROWS - 1;
    }

    private int getCellValue(int x, int y) {
        return this.courseMap[y / 10 * this.LEVEL_COLUMNS + x / 10];
    }

    public boolean isOutside(int x, int y) {
        return x <= 10 || x >= 10 * (this.LEVEL_COLUMNS - 1) || y <= 10 || y >= 10 * (this.LEVEL_ROWS - 1) || this.getCellValue(x, y) < 3;
    }

    public boolean checkCollision(Ball ball) {
        return ball.collidesWith(this.outside, true);
    }

    public boolean responseCollision(Ball ball, boolean isMovedBack) {
        int ballCenterX = ball.getX() + ball.getWidth() / 2;
        int ballCenterY = ball.getY() + ball.getHeight() / 2;
        int ballRightX = ball.getX() + ball.getWidth() - 1;
        int ballBottomY = ball.getY() + ball.getHeight() - 1;
        if (this.isOutside(ballRightX, ballCenterY)) {
            ball.moveBack();
            isMovedBack = true;
            ball.reflect(rightVector);
        } else if (this.isOutside(ball.getX(), ballCenterY)) {
            ball.moveBack();
            isMovedBack = true;
            ball.reflect(leftVector);
        }
        if (this.isOutside(ballCenterX, ballBottomY)) {
            if (!isMovedBack) {
                ball.moveBack();
                isMovedBack = true;
            }
            ball.reflect(downVector);
        } else if (this.isOutside(ballCenterX, ball.getY())) {
            if (!isMovedBack) {
                ball.moveBack();
                isMovedBack = true;
            }
            ball.reflect(upVector);
        }
        if (!isMovedBack) {
            ball.moveBack();
            isMovedBack = true;
            int cornerX = 0;
            int cornerY = 0;
            if (this.getCellValue(ball.getX(), ball.getY()) < 3) {
                cornerX = ball.getX();
                cornerY = ball.getY();
            } else if (this.getCellValue(ballRightX, ball.getY()) < 3) {
                cornerX = ballRightX;
                cornerY = ball.getY();
            } else if (this.getCellValue(ball.getX(), ballBottomY) < 3) {
                cornerX = ball.getX();
                cornerY = ballBottomY;
            } else if (this.getCellValue(ballRightX, ballBottomY) < 3) {
                cornerX = ballRightX;
                cornerY = ballBottomY;
            }
            ball.reflect(new Vector2D(ballCenterX - cornerX, ballCenterY - cornerY).normalize());
        }
        return isMovedBack;
    }
}

