/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.jbf.util;

import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.gadget.ScoreCheckerThread;
import com.jarbull.jbf.gadget.VersionCheckerThread;
import com.jarbull.jbf.menu.JBBGImage;
import com.jarbull.jbf.menu.JBElement;
import com.jarbull.jbf.menu.JBMenuNode;
import com.jarbull.jbf.util.JBUtil;
import com.jarbull.jbf.util.ParserUtility;
import java.util.Hashtable;
import java.util.Vector;

public class JBMenuXmlParser {
    private final Hashtable hash_menu_nodes;

    public JBMenuXmlParser(Hashtable hash_menu_nodes) {
        this.hash_menu_nodes = hash_menu_nodes;
        this.parseFile();
    }

    private void parseFile() {
        String menuXml = null;
        try {
            menuXml = JBUtil.getEncryptedTxtFromFile("/res/menu.enc");
        }
        catch (Exception ex) {
            try {
                menuXml = JBUtil.getEncryptedTxtFromFile("/menu.enc");
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        String mainMenuText = menuXml.substring(menuXml.indexOf("<main_menu>"), menuXml.indexOf("</main_menu>") + "</main_menu>".length());
        this.parseNodes(mainMenuText);
        String pauseMenuText = menuXml.substring(menuXml.indexOf("<pause_menu>"), menuXml.indexOf("</pause_menu>") + "</pause_menu>".length());
        this.parseNodes(pauseMenuText);
        String updateMenuText = menuXml.substring(menuXml.indexOf("<update_menu>"), menuXml.indexOf("</update_menu>") + "</update_menu>".length());
        this.parseNodes(updateMenuText);
        String topScoreText = menuXml.substring(menuXml.indexOf("<top_score>"), menuXml.indexOf("</top_score>") + "</top_score>".length());
        this.parseNodes(topScoreText);
    }

    private void parseNodes(String str) {
        while (str.indexOf("</node>") != -1) {
            String nodeStr = str.substring(str.indexOf("<node>"), str.indexOf("</node>") + "</node>".length());
            JBMenuNode node = this.parseNode(nodeStr);
            this.hash_menu_nodes.put(node.getId(), node);
            str = str.substring(str.indexOf("</node>") + "</node>".length());
        }
    }

    private JBMenuNode parseNode(String str) {
        String id = ParserUtility.getValue(str, "id");
        String title = ParserUtility.getValue(str, "title");
        int title_padding = ParserUtility.getIntValue(str, "title_padding");
        int left_space = ParserUtility.getIntValue(str, "left_space");
        int right_space = ParserUtility.getIntValue(str, "right_space");
        int top_space = ParserUtility.getIntValue(str, "top_space");
        int bottom_space = ParserUtility.getIntValue(str, "bottom_space");
        String align = ParserUtility.getValue(str, "align");
        String font = ParserUtility.getValue(str, "font");
        String button = ParserUtility.getValue(str, "button");
        String button_selected = ParserUtility.getValue(str, "button_selected");
        JBMenuNode node = new JBMenuNode(id);
        String backgroundsStr = str.substring(str.indexOf("<backgrounds>"), str.indexOf("</backgrounds>") + "</backgrounds>".length());
        Vector backgrounds = this.parseBackgrounds(backgroundsStr);
        for (int i = 0; i < backgrounds.size(); ++i) {
            JBBGImage bGImage = (JBBGImage)backgrounds.elementAt(i);
            JBManager.getInstance().addAction(new JBAction(this, bGImage.getPath()));
            node.addBGImage(bGImage);
        }
        node.setTitle(title);
        node.setTitle_padding(title_padding);
        node.setLeft_space(left_space);
        node.setRight_space(right_space);
        node.setTop_space(top_space);
        node.setBottom_space(bottom_space);
        node.setAlign(align);
        node.setFontKey(font);
        node.setButtonPath(button);
        node.setSelectedButtonPath(button_selected);
        JBManager.getInstance().addAction(new JBAction(this, button));
        JBManager.getInstance().addAction(new JBAction(this, button_selected));
        String elementsStr = str.substring(str.indexOf("<elements>"), str.indexOf("</elements>") + "</elements>".length());
        Vector elements = this.parseElements(elementsStr);
        for (int i = 0; i < elements.size(); ++i) {
            node.addElement((JBElement)elements.elementAt(i));
        }
        String title_check_start = ParserUtility.getValue(str, "title_check_start");
        String title_check_success_a = ParserUtility.getValue(str, "title_check_success_a");
        String title_check_success_y = ParserUtility.getValue(str, "title_check_success_y");
        String title_check_success_n = ParserUtility.getValue(str, "title_check_success_n");
        String title_check_error = ParserUtility.getValue(str, "title_check_error");
        if (!title_check_start.equals("")) {
            VersionCheckerThread.TITLE_CHECK_START = title_check_start;
        }
        if (!title_check_success_a.equals("")) {
            VersionCheckerThread.TITLE_CHECK_SUCCESS_A = title_check_success_a;
        }
        if (!title_check_success_y.equals("")) {
            VersionCheckerThread.TITLE_CHECK_SUCCESS_Y = title_check_success_y;
        }
        if (!title_check_success_n.equals("")) {
            VersionCheckerThread.TITLE_CHECK_SUCCESS_N = title_check_success_n;
        }
        if (!title_check_error.equals("")) {
            VersionCheckerThread.TITLE_CHECK_ERROR = title_check_error;
        }
        String title_score_start = ParserUtility.getValue(str, "title_score_start");
        String title_your_score = ParserUtility.getValue(str, "title_your_score");
        String title_your_top_score = ParserUtility.getValue(str, "title_your_top_score");
        String title_top_scores = ParserUtility.getValue(str, "title_top_scores");
        String title_score_error = ParserUtility.getValue(str, "title_score_error");
        String max_top = ParserUtility.getValue(str, "max_top");
        if (!title_score_start.equals("")) {
            ScoreCheckerThread.TITLE_SCORE_START = title_score_start;
        }
        if (!title_your_score.equals("")) {
            ScoreCheckerThread.TITLE_YOUR_SCORE = title_your_score;
        }
        if (!title_your_top_score.equals("")) {
            ScoreCheckerThread.TITLE_YOUR_TOP_SCORE = title_your_top_score;
        }
        if (!title_top_scores.equals("")) {
            ScoreCheckerThread.TITLE_TOP_SCORES = title_top_scores;
        }
        if (!title_score_error.equals("")) {
            ScoreCheckerThread.TITLE_SCORE_ERROR = title_score_error;
        }
        if (!max_top.equals("")) {
            ScoreCheckerThread.topScoreCount = max_top;
        }
        return node;
    }

    private Vector parseBackgrounds(String str) {
        Vector<JBBGImage> elements = new Vector<JBBGImage>();
        while (str.indexOf("</background>") != -1) {
            String nodeStr = str.substring(str.indexOf("<background>"), str.indexOf("</background>") + "</background>".length());
            elements.addElement(this.parseBackground(nodeStr));
            str = str.substring(str.indexOf("</background>") + "</background>".length());
        }
        return elements;
    }

    private Vector parseElements(String str) {
        Vector<JBElement> elements = new Vector<JBElement>();
        while (str.indexOf("</element>") != -1) {
            String nodeStr = str.substring(str.indexOf("<element>"), str.indexOf("</element>") + "</element>".length());
            elements.addElement(this.parseElement(nodeStr));
            str = str.substring(str.indexOf("</element>") + "</element>".length());
        }
        return elements;
    }

    private JBElement parseElement(String str) {
        String action = ParserUtility.getValue(str, "action");
        String title = ParserUtility.getValue(str, "title");
        String condition = ParserUtility.getValue(str, "condition");
        String key = ParserUtility.getValue(str, "key");
        String[] options = ParserUtility.getValues(str, "option");
        JBElement element = new JBElement(title);
        if (!action.equals("")) {
            element.setAction(action);
        } else {
            action = ParserUtility.getValue(str, "action_noedit");
            if (!action.equals("")) {
                element.setAction(action);
            }
        }
        if (!condition.equals("")) {
            element.setCondition(condition);
        }
        if (!key.equals("")) {
            element.setKey(key);
        }
        if (options.length > 0) {
            for (int i = 0; i < options.length; ++i) {
                element.addOption(options[i]);
            }
        }
        return element;
    }

    private JBBGImage parseBackground(String str) {
        String path = ParserUtility.getValue(str, "path");
        int x = ParserUtility.getIntValue(str, "x");
        int y = ParserUtility.getIntValue(str, "y");
        String alignh = ParserUtility.getValue(str, "alignh");
        String alignv = ParserUtility.getValue(str, "alignv");
        JBBGImage bBGImage = new JBBGImage(path);
        bBGImage.setX(x);
        bBGImage.setY(y);
        if (!alignh.equals("")) {
            if (alignh.equals("left")) {
                bBGImage.setAlignH(4);
            } else if (alignh.equals("right")) {
                bBGImage.setAlignH(8);
            } else {
                bBGImage.setAlignH(1);
            }
        }
        if (!alignv.equals("")) {
            if (alignv.equals("top")) {
                bBGImage.setAlignV(16);
            } else if (alignv.equals("bottom")) {
                bBGImage.setAlignV(32);
            } else {
                bBGImage.setAlignV(2);
            }
        }
        return bBGImage;
    }
}

