/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

public class MovingUnitGenerator
implements Runnable {
    boolean isCar;
    boolean isAlive = true;
    boolean isPaused = false;
    Thread t;
    int threadSleepLoop;
    LayerManager layermanager;
    int carStartX;
    int carStartY;
    int carSpeed;
    int carDirection;
    int pedStartX;
    int pedStartY;
    int pedSpeed;
    int pedDirection;
    int pedEndX;
    int pedEndY;
    int pedFrameWidth;
    int pedFrameHeigth;
    int[] pedFrameSequence;
    Image carImage;
    Image pedImage;

    public MovingUnitGenerator(MovingCar car, LayerManager layermanager) {
        this.isCar = true;
        this.layermanager = layermanager;
        this.threadSleepLoop = car.timeLoop;
        this.carDirection = car.direction;
        this.carSpeed = car.speed;
        this.carStartX = car.startX;
        this.carStartY = car.startY;
        this.carImage = car.image;
    }

    public MovingUnitGenerator(Pedestrian ped, LayerManager layerManager) {
        this.isCar = false;
        this.layermanager = layerManager;
        this.threadSleepLoop = ped.timeSleepLoop;
        this.pedDirection = ped.direction;
        this.pedSpeed = ped.speed;
        this.pedStartX = ped.startX;
        this.pedStartY = ped.startY;
        this.pedEndX = ped.endX;
        this.pedEndY = ped.endY;
        this.pedImage = ped.image;
        this.pedFrameHeigth = ped.frameHeight;
        this.pedFrameWidth = ped.frameWidth;
    }

    public void generateCar() {
        MovingCar temp = new MovingCar(this.carImage, this.carDirection, this.carSpeed, this.carStartX, this.carStartY, this.threadSleepLoop);
        MovingUnitHolder.getInstance().addCar(temp);
        this.layermanager.insert((Layer)temp, 0);
    }

    public void generatePedestrian() {
        Pedestrian temp = new Pedestrian(this.pedImage, this.pedFrameWidth, this.pedFrameHeigth, this.pedDirection, this.pedSpeed, this.pedStartX, this.pedStartY, this.pedEndX, this.pedEndY, this.threadSleepLoop);
        MovingUnitHolder.getInstance().addPedestrian(temp);
        this.layermanager.insert((Layer)temp, 0);
    }

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void kill() {
        this.isAlive = false;
    }

    public void waitForClose() {
        try {
            this.t.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void run() {
        while (this.isAlive) {
            if (!this.isPaused) {
                if (this.isCar) {
                    this.generateCar();
                } else if (!this.isCar) {
                    this.generatePedestrian();
                }
            }
            try {
                Thread.sleep(this.threadSleepLoop);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

