/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.jbf.menu;

import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.menu.JBBGImage;
import com.jarbull.jbf.menu.JBElement;
import com.jarbull.jbf.menu.JBMenuNode;
import com.jarbull.jbf.util.JBUtil;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class JBMainMenuCanvas
extends GameCanvas
implements Runnable {
    public boolean isPaused = false;
    private JBMenuNode currentNode = null;
    private boolean isRunning = true;
    private int itemPadding = 1;
    private int selectedItemPadding = 1;
    private int currentVloc = 0;
    private int TargetVloc = 0;
    private boolean showingSplash = false;
    private boolean isLoading = true;
    private static final int DRAG_SENSITIVITY__INVERSE = 60;
    private boolean pointerPressed;
    private int lastDragX;
    private int lastDragY;

    public JBMainMenuCanvas() {
        super(false);
        this.setFullScreenMode(true);
        JBManager.getInstance().addAction(new JBAction(this, "load_menu_xml"));
    }

    public void paint(Graphics g) {
        if (this.isPaused) {
            return;
        }
        if (!JBManager.getInstance().isMenuLoaded()) {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(255, 255, 255);
            g.drawString("Loading...", this.getWidth() / 2, this.getHeight() / 2, 65);
            return;
        }
        JBManager jBManager = JBManager.getInstance();
        if (this.currentNode == null) {
            Image intro;
            this.currentNode = jBManager.getMenuNode("M0");
            if (this.currentNode != null) {
                this.currentNode.refreshVisibleElements(null);
            }
            if ((intro = jBManager.getImage("si:/res/intro.png")) != null) {
                g.setColor(0, 0, 0);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.drawImage(intro, this.getWidth() / 2, this.getHeight() / 2, 3);
                this.isLoading = false;
                this.showingSplash = true;
            }
        } else {
            this.drawCurrentNode(g);
        }
    }

    private void drawCurrentNode(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        JBManager jBManager = JBManager.getInstance();
        int baseX = Integer.MAX_VALUE;
        int baseY = Integer.MAX_VALUE;
        int baseW = 0;
        int baseH = 0;
        Vector bGImages = this.currentNode.getBGImages();
        for (int i = 0; i < bGImages.size(); ++i) {
            JBBGImage jbbgImage = (JBBGImage)bGImages.elementAt(i);
            Image bgImage = jBManager.getImage(jbbgImage.getPath() + "");
            int locX = jbbgImage.getX();
            int locY = jbbgImage.getY();
            baseX = jbbgImage.getAlignH() == 1 ? Math.min(baseX, (locX += this.getWidth() / 2) - bgImage.getWidth() / 2) : (jbbgImage.getAlignH() == 8 ? Math.min(baseX, (locX += this.getWidth()) - bgImage.getWidth()) : Math.min(baseX, locX));
            baseW = Math.max(baseW, bgImage.getWidth());
            baseY = jbbgImage.getAlignV() == 2 ? Math.min(baseY, (locY += this.getHeight() / 2) - bgImage.getHeight() / 2) : (jbbgImage.getAlignV() == 32 ? Math.min(baseY, (locY += this.getHeight()) - bgImage.getHeight()) : Math.min(baseY, locY));
            baseH = Math.max(baseH, bgImage.getHeight());
            g.drawImage(bgImage, locX, locY, jbbgImage.getAlignH() | jbbgImage.getAlignV());
        }
        if (this.currentNode.getTop_space() < 0) {
            this.currentNode.setTop_space(baseY + baseH + this.currentNode.getTop_space());
        }
        if (this.currentNode.getBottom_space() < 0) {
            this.currentNode.setBottom_space(-this.currentNode.getBottom_space());
        }
        if (this.currentNode.getLeft_space() < 0) {
            this.currentNode.setLeft_space(baseX + baseW + this.currentNode.getLeft_space());
        }
        if (this.currentNode.getRight_space() < 0) {
            this.currentNode.setRight_space(-this.currentNode.getRight_space());
        }
        g.setColor(255, 255, 255);
        String nodeTitle = this.currentNode.getTitle();
        if (!nodeTitle.equals("")) {
            if (nodeTitle.indexOf(59) == -1) {
                Image titleImage = jBManager.getTextImage(nodeTitle, this.currentNode.getFontKey());
                g.drawImage(titleImage, this.getWidth() / 2, baseY + this.currentNode.getTitle_padding(), 17);
            } else {
                String[] lines = JBUtil.splitText(nodeTitle, ';');
                int title_y = baseY + this.currentNode.getTitle_padding();
                for (int i = 0; i < lines.length; ++i) {
                    if (lines[i].equals("")) {
                        lines[i] = " ";
                    }
                    Image titleImage = jBManager.getTextImage(lines[i], this.currentNode.getFontKey());
                    if (i == 0) {
                        g.drawImage(titleImage, this.getWidth() / 2, title_y, 17);
                    } else {
                        g.drawImage(titleImage, baseX + this.currentNode.getLeft_space() + 10, title_y, 20);
                    }
                    title_y = title_y + titleImage.getHeight() + 2;
                }
            }
        }
        int itemHeight = jBManager.getImage(this.currentNode.getButtonPath()).getHeight();
        this.TargetVloc = this.getMenuPosCalc(itemHeight, baseH);
        int posHeigth = this.currentNode.getTop_space() + this.currentVloc;
        int frame_Width = baseW - (this.currentNode.getLeft_space() + this.currentNode.getRight_space());
        int frame_Height = baseH - (this.currentNode.getTop_space() + this.currentNode.getBottom_space());
        g.setClip(baseX + this.currentNode.getLeft_space(), baseY + this.currentNode.getTop_space(), frame_Width, frame_Height);
        for (int i = 0; i < this.currentNode.getVisibleElements().size(); ++i) {
            JBElement jBelement = (JBElement)this.currentNode.getVisibleElements().elementAt(i);
            Image img = jBelement.getAction() != null ? jBManager.getTextImage(jBelement.getTitle(), this.currentNode.getFontKey()) : jBManager.getTextImage(jBelement.getTitle() + " <" + jBelement.getSelectedOption() + "> ", this.currentNode.getFontKey());
            g.setColor(255, 255, 255);
            int y_position = baseY + posHeigth + (itemHeight + this.itemPadding) * i + this.itemPadding;
            y_position = i < this.currentNode.getSelectedElementIndex() ? baseY + posHeigth + (itemHeight + this.itemPadding) * i + this.itemPadding : (i > this.currentNode.getSelectedElementIndex() ? baseY + posHeigth + (itemHeight + this.itemPadding) * i + this.selectedItemPadding + (this.selectedItemPadding - this.itemPadding) : baseY + posHeigth + (itemHeight + this.itemPadding) * i + this.selectedItemPadding);
            int menuTextPadding = (itemHeight - img.getHeight()) / 2;
            if (this.currentNode.getAlign().equals("left")) {
                if (i == this.currentNode.getSelectedElementIndex()) {
                    g.drawImage(jBManager.getImage(this.currentNode.getSelectedButtonPath()), this.currentNode.getLeft_space() + baseX, y_position, 20);
                } else {
                    g.drawImage(jBManager.getImage(this.currentNode.getButtonPath()), this.currentNode.getLeft_space() + baseX, y_position, 20);
                }
                g.drawImage(img, this.currentNode.getLeft_space() + 10 + baseX, y_position + menuTextPadding, 20);
                continue;
            }
            if (this.currentNode.getAlign().equals("right")) {
                if (i == this.currentNode.getSelectedElementIndex()) {
                    g.drawImage(jBManager.getImage(this.currentNode.getSelectedButtonPath()), baseX + baseW - this.currentNode.getRight_space(), y_position, 24);
                } else {
                    g.drawImage(jBManager.getImage(this.currentNode.getButtonPath()), baseX + baseW - this.currentNode.getRight_space(), y_position, 24);
                }
                g.drawImage(img, baseX + baseW - this.currentNode.getRight_space() - 10, y_position + menuTextPadding, 24);
                continue;
            }
            if (!this.currentNode.getAlign().equals("center")) continue;
            if (i == this.currentNode.getSelectedElementIndex()) {
                g.drawImage(jBManager.getImage(this.currentNode.getSelectedButtonPath()), baseX + (baseW - this.currentNode.getRight_space() + this.currentNode.getLeft_space()) / 2, y_position, 17);
            } else {
                g.drawImage(jBManager.getImage(this.currentNode.getButtonPath()), baseX + (baseW - this.currentNode.getRight_space() + this.currentNode.getLeft_space()) / 2, y_position, 17);
            }
            g.drawImage(img, baseX + (baseW - this.currentNode.getRight_space() + this.currentNode.getLeft_space()) / 2, y_position + menuTextPadding, 17);
        }
        g.setClip(0, 0, this.getWidth(), this.getHeight());
    }

    protected void keyPressed(int keyCode) {
        if (this.isLoading || this.showingSplash) {
            return;
        }
        int gkg = this.getGameAction(keyCode);
        JBElement selectedElement = (JBElement)this.currentNode.getVisibleElements().elementAt(this.currentNode.getSelectedElementIndex());
        switch (gkg) {
            case 1: {
                this.currentNode.selectPrevElement();
                break;
            }
            case 6: {
                this.currentNode.selectNextElement();
                break;
            }
            case 8: {
                if (selectedElement.getAction() != null) {
                    JBManager.getInstance().handleEvent(new JBAction(this, selectedElement.getAction()));
                    break;
                }
                String option = selectedElement.selectNextOption();
                JBManager.getInstance().saveMenuOption(this.currentNode, selectedElement, option);
                break;
            }
            case 2: {
                if (selectedElement.getAction() != null) break;
                String option = selectedElement.selectPrevOption();
                JBManager.getInstance().saveMenuOption(this.currentNode, selectedElement, option);
                break;
            }
            case 5: {
                if (selectedElement.getAction() != null) break;
                String option = selectedElement.selectNextOption();
                JBManager.getInstance().saveMenuOption(this.currentNode, selectedElement, option);
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.isLoading || this.showingSplash) {
            return;
        }
        this.pointerPressed = true;
        this.lastDragX = x;
        this.lastDragY = y;
    }

    public void pointerReleased(int x, int y) {
        if (!this.pointerPressed) {
            return;
        }
        JBElement selectedElement = (JBElement)this.currentNode.getVisibleElements().elementAt(this.currentNode.getSelectedElementIndex());
        if (selectedElement.getAction() != null) {
            JBManager.getInstance().handleEvent(new JBAction(this, selectedElement.getAction()));
        } else {
            String option = selectedElement.selectNextOption();
            JBManager.getInstance().saveMenuOption(this.currentNode, selectedElement, option);
        }
        this.pointerPressed = false;
    }

    public void pointerDragged(int x, int y) {
        if (this.isLoading || this.showingSplash) {
            return;
        }
        JBElement selectedElement = (JBElement)this.currentNode.getVisibleElements().elementAt(this.currentNode.getSelectedElementIndex());
        if (x - this.lastDragX > 60) {
            if (selectedElement.getAction() == null) {
                String option = selectedElement.selectNextOption();
                JBManager.getInstance().saveMenuOption(this.currentNode, selectedElement, option);
            }
            this.pointerPressed = false;
            this.lastDragX = x;
            return;
        }
        if (x - this.lastDragX < -60) {
            if (selectedElement.getAction() == null) {
                String option = selectedElement.selectPrevOption();
                JBManager.getInstance().saveMenuOption(this.currentNode, selectedElement, option);
            }
            this.pointerPressed = false;
            this.lastDragX = x;
            return;
        }
        if (y - this.lastDragY > 60) {
            this.currentNode.selectNextElement();
            this.pointerPressed = false;
            this.lastDragY = y;
        } else if (y - this.lastDragY < -60) {
            this.currentNode.selectPrevElement();
            this.pointerPressed = false;
            this.lastDragY = y;
        }
    }

    public void run() {
        while (this.isRunning) {
            try {
                if (this.currentVloc != this.TargetVloc) {
                    Thread.sleep(50L);
                    int VlocDiff = -1 * (this.currentVloc - this.TargetVloc);
                    this.currentVloc = VlocDiff < 0 && VlocDiff > -5 ? this.TargetVloc : (VlocDiff > 0 && VlocDiff < 5 ? this.TargetVloc : (this.currentVloc += VlocDiff / 3));
                } else {
                    Thread.sleep(100L);
                }
                if (this.showingSplash) {
                    Thread.sleep(1500L);
                    this.showingSplash = false;
                }
                if (this.isPaused) continue;
                this.repaint();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void stopProcessing() {
        this.isRunning = false;
    }

    public void setCurrentNode(JBMenuNode currentNode, String refreshAction) {
        this.currentNode = currentNode;
        this.currentNode.refreshVisibleElements(refreshAction);
    }

    private int getMenuPosCalc(int elementHeight, int frameHeight) {
        int ortaya_uzak = 0;
        int frameLine = (frameHeight - (this.currentNode.getTop_space() + this.currentNode.getBottom_space())) / (elementHeight + this.itemPadding);
        if (frameLine < this.currentNode.getVisibleElements().size()) {
            int maxTemp;
            int returnTemp;
            if (this.currentNode.getSelectedElementIndex() > frameLine / 2) {
                ortaya_uzak = this.currentNode.getSelectedElementIndex() - frameLine / 2;
            }
            if ((returnTemp = (elementHeight + this.itemPadding) * ortaya_uzak) > (maxTemp = this.currentNode.getVisibleElements().size() * (elementHeight + this.itemPadding) - (frameHeight - (this.currentNode.getTop_space() + this.currentNode.getBottom_space())))) {
                returnTemp = maxTemp;
            }
            return -1 * returnTemp;
        }
        return 0;
    }

    public JBMenuNode getCurrentNode() {
        return this.currentNode;
    }
}

