/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.jbf;

import com.jarbull.jbf.util.JBUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordStore;

public class JBRecordStore {
    private RecordStore recordStore;
    private final Hashtable recordHash = new Hashtable();

    public JBRecordStore(String name) {
        try {
            this.recordStore = RecordStore.openRecordStore((String)name, (boolean)true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.readRecords();
    }

    private void readRecords() {
        this.recordHash.clear();
        try {
            if (this.recordStore.getNextRecordID() > 1) {
                String info = new String(this.recordStore.getRecord(this.recordStore.getNextRecordID() - 1));
                String[] records = JBUtil.splitText(info, '@');
                for (int i = 0; i < records.length; ++i) {
                    if (records[i].length() <= 1) continue;
                    String[] values = JBUtil.splitText(records[i], ':');
                    this.recordHash.put(values[0], values[1]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveRecords() {
        try {
            if (this.recordStore.getNumRecords() > 0) {
                this.recordStore.deleteRecord(this.recordStore.getNextRecordID() - 1);
            }
            String record = "";
            Enumeration keys = this.recordHash.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = this.recordHash.get(key);
                record = record + key + ":" + value + "@";
            }
            this.recordStore.addRecord(record.getBytes(), 0, record.length());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String get(String key) {
        return (String)this.recordHash.get(key);
    }

    public void remove(String key) {
        this.recordHash.remove(key);
        this.saveRecords();
    }

    public void putAndSave(String key, String value) {
        this.recordHash.put(key, value);
        this.saveRecords();
    }

    public void put(String key, String value) {
        this.recordHash.put(key, value);
    }

    public void put(String[] keys, String[] values) {
        if (keys.length != values.length) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            this.recordHash.put(keys[i], values[i]);
        }
        this.saveRecords();
    }
}

