/*
 * Decompiled with CFR 0.152.
 */
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.midlet.MIDlet;

public class LevelEndScreen
extends Canvas
implements Runnable {
    public static final int STATE__IDLE = 0;
    public static final int STATE__WAIT = 1;
    public static final int STATE__EXIT = 2;
    public static final int TEXT_LINE_STATE__NORMAL = 0;
    public static final int TEXT_LINE_STATE__FLICKER = 1;
    private static final int CENTER = 3;
    private ParkingGameMidlet midlet;
    private Displayable previousDisplay;
    private Thread thread;
    private Image button1Image;
    private Image button3Image;
    private Image buttonFireImage;
    private Image araZeminTileImage;
    private Image buttonMovementsImage;
    private Image buttonSpaceImage;
    private Image buttonPImage;
    private Image buttonWImage;
    private Image buttonEImage;
    private Vector textLines;
    private Vector textLinesState;
    private TiledLayer backgroundTiled;
    private TiledLayer zeminTiled;
    private int screenCenterX;
    private int screenCenterY;
    private int state = 0;
    private boolean flicker = true;
    int levelNo;
    boolean basilacak;

    public LevelEndScreen(ParkingGameMidlet midlet, Image image) {
        this.initalize(midlet);
    }

    public LevelEndScreen(ParkingGameMidlet midlet, int levelNo) {
        this.levelNo = levelNo;
        this.initalize(midlet);
    }

    public void initalize(ParkingGameMidlet midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.previousDisplay = Display.getDisplay((MIDlet)midlet).getCurrent();
        this.araZeminTileImage = ImageHandler.getInstance().getImage("/res/zeminTile.png");
        if (midlet.gameCanvas.myLevel == null) {
            if (!KeyCodeAdapter.getInstance().getPlatformName().equals("blackberry")) {
                try {
                    this.button1Image = Image.createImage((String)"/res/buton1.png");
                    this.button3Image = Image.createImage((String)"/res/buton3.png");
                    this.buttonFireImage = Image.createImage((String)"/res/butonFire.png");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    this.buttonMovementsImage = Image.createImage((String)"/res/butonMovements.png");
                    this.buttonSpaceImage = Image.createImage((String)"/res/butonSpace.png");
                    this.buttonPImage = Image.createImage((String)"/res/butonP.png");
                    this.buttonWImage = Image.createImage((String)"/res/butonW.png");
                    this.buttonEImage = Image.createImage((String)"/res/butonE.png");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        Image tiledBackground = null;
        try {
            tiledBackground = Image.createImage((String)"/res/back.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        int backgroundColumns = this.getWidth() / tiledBackground.getWidth() + 1;
        int backgroundRows = this.getHeight() / tiledBackground.getHeight() + 1;
        this.backgroundTiled = new TiledLayer(backgroundColumns, backgroundRows, tiledBackground, tiledBackground.getWidth(), tiledBackground.getHeight());
        this.backgroundTiled.fillCells(0, 0, backgroundColumns, backgroundRows, 1);
        if (KeyCodeAdapter.getInstance().getPlatformName().equals("blackberry")) {
            this.zeminTiled = new TiledLayer(6, 9, this.araZeminTileImage, 28, 28);
            int[] araZeminTileData = new int[]{1, 5, 5, 5, 5, 2, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 5, 5, 5, 5, 4};
            for (int i = 0; i < araZeminTileData.length; ++i) {
                int column = i % 6;
                int row = (i - column) / 6;
                this.zeminTiled.setCell(column, row, araZeminTileData[i]);
            }
        } else {
            this.zeminTiled = new TiledLayer(6, 7, this.araZeminTileImage, 28, 28);
            int[] araZeminTileData = new int[]{1, 5, 5, 5, 5, 2, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 5, 5, 5, 5, 4};
            for (int i = 0; i < araZeminTileData.length; ++i) {
                int column = i % 6;
                int row = (i - column) / 6;
                this.zeminTiled.setCell(column, row, araZeminTileData[i]);
            }
        }
        this.textLines = new Vector();
        this.textLinesState = new Vector();
        this.screenCenterX = this.getWidth() / 2;
        this.screenCenterY = this.getHeight() / 2;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setNextDisplay(Displayable nextDisplay) {
        this.previousDisplay = nextDisplay;
    }

    public void addText(String text, String color) {
        this.addText(text, 0, color);
    }

    public void addText(String text, int state, String color) {
        this.textLinesState.addElement(new Integer(state));
        this.textLines.addElement(JBManager.getInstance().getTextImage(text, "10x10-" + color));
    }

    public void removeTextFromEnd(int count) {
        for (int i = 0; i < count; ++i) {
            this.textLines.removeElementAt(this.textLines.size() - 1);
            this.textLinesState.removeElementAt(this.textLines.size() - 1);
        }
    }

    public void show() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void waitForClose() {
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        this.backgroundTiled.paint(g);
        this.zeminTiled.setPosition(this.getWidth() / 2 - this.zeminTiled.getWidth() / 2, this.getHeight() / 2 - this.zeminTiled.getHeight() / 2);
        this.zeminTiled.paint(g);
        if (this.basilacak) {
            if (!KeyCodeAdapter.getInstance().getPlatformName().equals("blackberry")) {
                g.drawImage(this.buttonFireImage, this.screenCenterX - 43, this.screenCenterY - 53, 3);
                g.drawImage(this.button1Image, this.screenCenterX - 43, this.screenCenterY - 33, 3);
                g.drawImage(this.button3Image, this.screenCenterX - 43, this.screenCenterY - 15, 3);
            } else {
                g.drawImage(this.buttonMovementsImage, this.screenCenterX - 43, this.screenCenterY - 83, 3);
                g.drawImage(this.buttonSpaceImage, this.screenCenterX - 43, this.screenCenterY - 53, 3);
                g.drawImage(this.buttonPImage, this.screenCenterX - 43, this.screenCenterY - 33, 3);
                g.drawImage(this.buttonWImage, this.screenCenterX - 43, this.screenCenterY - 13, 3);
                g.drawImage(this.buttonEImage, this.screenCenterX - 43, this.screenCenterY + 7, 3);
            }
        }
        block4: for (int i = this.textLines.size() - 1; i >= 0; --i) {
            switch ((Integer)this.textLinesState.elementAt(i)) {
                case 0: {
                    g.drawImage((Image)this.textLines.elementAt(i), this.screenCenterX, this.screenCenterY - this.textLines.size() * 5 + i * 10 + 7, 3);
                    continue block4;
                }
                case 1: {
                    if (this.flicker) continue block4;
                    g.drawImage((Image)this.textLines.elementAt(i), this.screenCenterX, this.screenCenterY - this.textLines.size() * 5 + i * 10 + 7, 3);
                }
            }
        }
        this.flicker = !this.flicker;
    }

    protected void keyPressed(int keyCode) {
        if (this.state != 1) {
            this.basilacak = false;
            this.state = 2;
        }
    }

    public void run() {
        while (true) {
            if (this.state == 2) break;
            this.repaint();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent(this.previousDisplay);
    }
}

