/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

public class Level {
    int levelNo;
    String levelInfoFileName = "info.txt";
    String levelCarsInfoFileName = "duranArabaInfo.txt";
    String levelBarrierInfoFileName = "barrierInfo.txt";
    String levelMovingCarInfoFileName = "movingCarInfo.txt";
    String levelPedestrianInfoFileName = "pedestrianInfo.txt";
    String levelMetinFileName = "levelMetin.txt";
    String levelEvlerMevlerFileName = "evlerMevlerInfo.txt";
    String genelSeritInfoFileName = "genelSeritInfo.txt";
    String genelInfoFileName = "genelInfo.txt";
    Hashtable levelEvlerMevlerHash;
    Hashtable levelCarsHash;
    Hashtable levelInfoHash;
    Hashtable levelBarrierHash;
    Hashtable levelPedestrianHash;
    Hashtable levelMovingCarHash;
    Hashtable genelSeritHash;
    Hashtable genelInfoHash;
    Vector levelMetin;
    short[] mapDataArray = new short[]{14, 14, 14, 7, 11, 2, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 14, 14, 14, 14, 10, 15, 0, 23, 17, 17, 17, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 40, 0, 0, 23, 17, 17, 14, 14, 64, 65, 65, 66, 67, 0, 16, 13, 13, 13, 15, 0, 0, 23, 17, 17, 17, 17, 24, 0, 0, 41, 42, 0, 0, 16, 13, 13, 14, 14, 68, 69, 69, 70, 71, 0, 16, 13, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 15, 0, 0, 0, 0, 0, 0, 16, 13, 13, 14, 14, 14, 14, 14, 10, 15, 0, 16, 13, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 15, 23, 17, 17, 17, 17, 17, 22, 13, 13, 14, 14, 14, 14, 14, 10, 15, 0, 16, 13, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 15, 16, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 5, 9, 9, 4, 15, 0, 16, 13, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 15, 16, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 10, 19, 18, 18, 26, 0, 16, 13, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 15, 16, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 10, 15, 0, 23, 17, 17, 22, 13, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 15, 16, 13, 13, 19, 18, 18, 18, 18, 18, 9, 9, 4, 15, 0, 16, 13, 13, 13, 13, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 15, 16, 13, 13, 15, 0, 0, 0, 0, 0, 13, 13, 13, 15, 0, 16, 13, 13, 13, 13, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 15, 16, 13, 13, 15, 0, 50, 51, 52, 0, 18, 18, 18, 26, 0, 25, 18, 18, 18, 18, 18, 18, 26, 0, 0, 25, 18, 18, 18, 18, 26, 25, 18, 18, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 38, 30, 30, 24, 23, 17, 17, 17, 17, 17, 17, 24, 0, 0, 23, 17, 17, 17, 17, 24, 23, 17, 17, 17, 17, 17, 17, 24, 0, 0, 28, 0, 0, 0, 16, 13, 13, 13, 13, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 15, 16, 13, 13, 13, 13, 13, 13, 15, 0, 0, 28, 0, 0, 0, 16, 13, 13, 13, 13, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 15, 16, 13, 13, 13, 13, 13, 13, 15, 0, 0, 28, 0, 0, 27, 16, 13, 13, 13, 13, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 15, 25, 18, 20, 13, 13, 19, 18, 26, 0, 0, 36, 29, 29, 35, 25, 18, 18, 18, 18, 18, 18, 26, 0, 0, 16, 13, 13, 13, 13, 15, 0, 0, 25, 18, 18, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 17, 17, 17, 24, 0, 0, 16, 13, 13, 13, 13, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 17, 17, 17, 17, 24, 0, 16, 13, 13, 13, 15, 0, 0, 25, 18, 18, 18, 18, 26, 0, 0, 23, 17, 17, 17, 17, 17, 17, 0, 16, 13, 13, 13, 13, 15, 0, 16, 13, 13, 13, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 13, 13, 13, 13, 13, 13, 0, 16, 13, 13, 13, 13, 15, 0, 16, 13, 13, 13, 15, 0, 0, 23, 17, 17, 17, 17, 17, 17, 24, 16, 13, 13, 13, 13, 13, 13, 0, 16, 13, 13, 13, 13, 15, 0, 25, 18, 18, 18, 26, 0, 0, 16, 13, 13, 13, 13, 13, 13, 15, 25, 18, 20, 13, 31, 29, 29, 0, 25, 18, 18, 18, 18, 26, 0, 0, 0, 0, 0, 0, 0, 0, 16, 13, 13, 13, 13, 13, 13, 15, 0, 0, 16, 13, 27, 0, 0, 0, 23, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 24, 0, 0, 16, 13, 13, 13, 13, 13, 13, 15, 23, 24, 25, 18, 35, 0, 0, 0, 16, 31, 29, 32, 13, 13, 43, 44, 45, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 13, 13, 15, 16, 15, 0, 0, 0, 0, 0, 0, 16, 27, 0, 28, 13, 13, 13, 13, 13, 13, 13, 15, 0, 0, 16, 13, 13, 13, 13, 13, 13, 15, 16, 21, 17, 17, 17, 24, 0, 0, 25, 35, 0, 28, 13, 13, 13, 13, 13, 13, 13, 15, 0, 0, 25, 18, 18, 18, 18, 18, 18, 26, 16, 13, 31, 29, 29, 35, 0, 0, 0, 0, 0, 28, 13, 13, 13, 13, 13, 13, 13, 15, 0, 0, 0, 0, 0, 0, 0, 0, 23, 17, 22, 13, 33, 30, 30, 0, 0};

    public Level(int levelNo) throws Exception {
        this.levelNo = levelNo;
        this.fillLevelMovingCarHash();
        this.fillLevelPedestrianHash();
        this.fillLevelInfoHash();
        this.fillLevelMetin();
    }

    private void fillLevelMetin() {
        this.levelMetin = new Vector();
        StringBuffer fileContent = new StringBuffer();
        try {
            InputStream in = this.getClass().getResourceAsStream("/res/level" + this.levelNo + "/" + this.levelMetinFileName);
            byte[] buffer = new byte[2500];
            while (in.read(buffer) != -1) {
                fileContent.append(new String(buffer));
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = fileContent.toString() + " ";
        if (!content.equals("\n")) {
            while (content.indexOf(32) != -1) {
                int index = content.indexOf(32);
                String word = content.substring(0, index);
                content = content.substring(index + 1);
                this.levelMetin.addElement(word);
            }
        }
    }

    private void fillLevelEvlerMevlerHash() {
        this.levelEvlerMevlerHash = new Hashtable();
        StringBuffer fileContent = new StringBuffer();
        try {
            InputStream in = this.getClass().getResourceAsStream("/res/level" + this.levelNo + "/" + this.levelEvlerMevlerFileName);
            byte[] buffer = new byte[2000];
            while (in.read(buffer) != -1) {
                fileContent.append(new String(buffer));
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = fileContent.toString().trim() + "\n";
        if (!content.equals("\n")) {
            while (content.indexOf(10) != -1) {
                int index = content.indexOf(10);
                String line = content.substring(0, index);
                content = content.substring(index + 1);
                String evlerMevlerCode = line.substring(0, line.indexOf(58));
                line = line.substring(line.indexOf(58) + 1);
                int x = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int y = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int direction = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int type = Integer.parseInt(line.substring(0, line.indexOf(58)));
                this.levelEvlerMevlerHash.put(evlerMevlerCode, new int[]{x, y, direction, type});
            }
        }
    }

    private void fillLevelCarsHash() {
        this.levelCarsHash = new Hashtable();
        StringBuffer fileContent = new StringBuffer();
        try {
            InputStream in = this.getClass().getResourceAsStream("/res/level" + this.levelNo + "/" + this.levelCarsInfoFileName);
            byte[] buffer = new byte[1000];
            while (in.read(buffer) != -1) {
                fileContent.append(new String(buffer));
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = fileContent.toString().trim() + "\n";
        if (!content.equals("\n")) {
            while (content.indexOf(10) != -1) {
                int index = content.indexOf(10);
                String line = content.substring(0, index);
                content = content.substring(index + 1);
                String carCode = line.substring(0, line.indexOf(58));
                line = line.substring(line.indexOf(58) + 1);
                int x = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int y = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int direction = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int type = Integer.parseInt(line.substring(0, line.indexOf(58)));
                this.levelCarsHash.put(carCode, new int[]{x, y, direction, type});
            }
        }
    }

    private void fillLevelMovingCarHash() {
        this.levelMovingCarHash = new Hashtable();
        StringBuffer fileContent = new StringBuffer();
        try {
            InputStream in = this.getClass().getResourceAsStream("/res/level" + this.levelNo + "/" + this.levelMovingCarInfoFileName);
            byte[] buffer = new byte[1000];
            while (in.read(buffer) != -1) {
                fileContent.append(new String(buffer));
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = fileContent.toString().trim() + "\n";
        if (!content.equals("\n")) {
            while (content.indexOf(10) != -1) {
                int index = content.indexOf(10);
                String line = content.substring(0, index);
                content = content.substring(index + 1);
                String carCode = line.substring(0, line.indexOf(58));
                line = line.substring(line.indexOf(58) + 1);
                int x = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int y = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int direction = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int type = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int speed = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int timeLoop = Integer.parseInt(line.substring(0, line.indexOf(58)));
                this.levelMovingCarHash.put(carCode, new int[]{x, y, direction, type, speed, timeLoop});
            }
        }
    }

    private void fillLevelPedestrianHash() {
        this.levelPedestrianHash = new Hashtable();
        StringBuffer fileContent = new StringBuffer();
        try {
            InputStream in = this.getClass().getResourceAsStream("/res/level" + this.levelNo + "/" + this.levelPedestrianInfoFileName);
            byte[] buffer = new byte[1000];
            while (in.read(buffer) != -1) {
                fileContent.append(new String(buffer));
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = fileContent.toString().trim() + "\n";
        if (!content.equals("\n")) {
            while (content.indexOf(10) != -1) {
                int index = content.indexOf(10);
                String line = content.substring(0, index);
                content = content.substring(index + 1);
                String carCode = line.substring(0, line.indexOf(58));
                line = line.substring(line.indexOf(58) + 1);
                int x = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int y = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int endX = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int endY = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int direction = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int type = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int speed = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int timeLoop = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int frameWidth = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int frameHeigth = Integer.parseInt(line.substring(0, line.indexOf(58)));
                this.levelPedestrianHash.put(carCode, new int[]{x, y, endX, endY, direction, type, speed, timeLoop, frameWidth, frameHeigth});
            }
        }
    }

    private void fillLevelInfoHash() {
        this.levelInfoHash = new Hashtable();
        StringBuffer fileContent = new StringBuffer();
        try {
            InputStream in = this.getClass().getResourceAsStream("/res/level" + this.levelNo + "/" + this.levelInfoFileName);
            byte[] buffer = new byte[1000];
            while (in.read(buffer) != -1) {
                fileContent.append(new String(buffer));
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = fileContent.toString().trim() + "\n";
        if (!content.equals("\n")) {
            while (content.indexOf(10) != -1) {
                int index = content.indexOf(10);
                String line = content.substring(0, index);
                content = content.substring(index + 1);
                String code = line.substring(0, line.indexOf(58));
                line = line.substring(line.indexOf(58) + 1);
                int value = Integer.parseInt(line.substring(0, line.indexOf(58)));
                this.levelInfoHash.put(code, new Integer(value));
            }
        }
    }

    public void fillGenelInfoHash() {
        this.genelInfoHash = new Hashtable();
        StringBuffer fileContent = new StringBuffer();
        try {
            InputStream in = this.getClass().getResourceAsStream("/res/levelGenel/" + this.genelInfoFileName);
            byte[] buffer = new byte[1000];
            while (in.read(buffer) != -1) {
                fileContent.append(new String(buffer));
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = fileContent.toString().trim() + "\n";
        if (!content.equals("\n")) {
            while (content.indexOf(10) != -1) {
                int index = content.indexOf(10);
                String line = content.substring(0, index);
                content = content.substring(index + 1);
                String code = line.substring(0, line.indexOf(58));
                line = line.substring(line.indexOf(58) + 1);
                int value = Integer.parseInt(line.substring(0, line.indexOf(58)));
                this.genelInfoHash.put(code, new Integer(value));
            }
        }
    }

    public void fillGenelSeritHash() {
        this.genelSeritHash = new Hashtable();
        StringBuffer fileContent = new StringBuffer();
        try {
            InputStream in = this.getClass().getResourceAsStream("/res/levelGenel/" + this.genelSeritInfoFileName);
            byte[] buffer = new byte[1000];
            while (in.read(buffer) != -1) {
                fileContent.append(new String(buffer));
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = fileContent.toString().trim() + "\n";
        if (!content.equals("\n")) {
            while (content.indexOf(10) != -1) {
                int index = content.indexOf(10);
                String line = content.substring(0, index);
                content = content.substring(index + 1);
                String lineCode = line.substring(0, line.indexOf(58));
                line = line.substring(line.indexOf(58) + 1);
                int x = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int y = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int direction = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int type = Integer.parseInt(line.substring(0, line.indexOf(58)));
                this.genelSeritHash.put(lineCode, new int[]{x, y, direction, type});
            }
        }
    }

    private void fillLevelBarrierHash() {
        this.levelBarrierHash = new Hashtable();
        StringBuffer fileContent = new StringBuffer();
        try {
            InputStream in = this.getClass().getResourceAsStream("/res/level" + this.levelNo + "/" + this.levelBarrierInfoFileName);
            byte[] buffer = new byte[1000];
            while (in.read(buffer) != -1) {
                fileContent.append(new String(buffer));
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = fileContent.toString().trim() + "\n";
        if (!content.equals("\n")) {
            while (content.indexOf(10) != -1) {
                int index = content.indexOf(10);
                String line = content.substring(0, index);
                content = content.substring(index + 1);
                String barrierCode = line.substring(0, line.indexOf(58));
                line = line.substring(line.indexOf(58) + 1);
                int x = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int y = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int direction = Integer.parseInt(line.substring(0, line.indexOf(58)));
                line = line.substring(line.indexOf(58) + 1);
                int type = Integer.parseInt(line.substring(0, line.indexOf(58)));
                this.levelBarrierHash.put(barrierCode, new int[]{x, y, direction, type});
            }
        }
    }

    public int getMaxCrash() {
        return (Integer)this.levelInfoHash.get("maxCrash");
    }

    public int getCarStartDirection() {
        return (Integer)this.levelInfoHash.get("carStartDir");
    }

    public int getCarStartX() {
        return (Integer)this.levelInfoHash.get("carStartX");
    }

    public int getCarStartY() {
        return (Integer)this.levelInfoHash.get("carStartY");
    }

    public int getCompleteTime() {
        return (Integer)this.levelInfoHash.get("levelTime");
    }

    public int getPerfParkX() {
        return (Integer)this.levelInfoHash.get("perfParkX");
    }

    public int getPerfParkY() {
        return (Integer)this.levelInfoHash.get("perfParkY");
    }

    public int getMyCarType() {
        return (Integer)this.levelInfoHash.get("myCarType");
    }

    public int getMyDireksiyonType() {
        return (Integer)this.levelInfoHash.get("myDireksiyonType");
    }

    public int getGameHeigth() {
        return (Integer)this.genelInfoHash.get("lvlHeigth");
    }

    public int getGameWidth() {
        return (Integer)this.genelInfoHash.get("lvlWidth");
    }

    public int getLevelNo() {
        return this.levelNo;
    }

    public Image getLevelBackResim() {
        try {
            Image tempImage = Image.createImage((String)"/res/back.png");
            return Image.createImage((Image)tempImage);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Sprite[] getEvlerMevlerSprites() {
        this.fillLevelEvlerMevlerHash();
        Sprite[] evlerMevlerSprites = new Sprite[this.levelEvlerMevlerHash.size()];
        for (int i = 0; i < this.levelEvlerMevlerHash.size(); ++i) {
            Image img = null;
            String tempi = "" + i;
            int[] arr = (int[])this.levelEvlerMevlerHash.get(tempi);
            img = ImageHandler.getInstance().getImage("/res/ev" + arr[3] + ".png");
            evlerMevlerSprites[i] = new Sprite(img);
            img = ParkingGameCanvas.rotateImage_img(img, arr[2]);
            evlerMevlerSprites[i].setImage(img, img.getWidth(), img.getHeight());
            evlerMevlerSprites[i].setPosition(arr[0], arr[1]);
        }
        return evlerMevlerSprites;
    }

    public Sprite[] getCarSprites() {
        this.fillLevelCarsHash();
        Sprite[] carSprites = new Sprite[this.levelCarsHash.size()];
        for (int i = 0; i < this.levelCarsHash.size(); ++i) {
            Image img = null;
            String tempi = "" + i;
            int[] arr = (int[])this.levelCarsHash.get(tempi);
            try {
                img = Image.createImage((String)("/res/car" + arr[3] + ".png"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            carSprites[i] = new Sprite(img);
            img = ParkingGameCanvas.rotateImage_img(img, arr[2]);
            carSprites[i].setImage(img, img.getWidth(), img.getHeight());
            carSprites[i].setPosition(arr[0], arr[1]);
        }
        return carSprites;
    }

    public Sprite[] getBarrierSprites() {
        this.fillLevelBarrierHash();
        Sprite[] barrierSprites = new Sprite[this.levelBarrierHash.size()];
        for (int i = 0; i < this.levelBarrierHash.size(); ++i) {
            Image img = null;
            String tempi = "" + i;
            int[] arr = (int[])this.levelBarrierHash.get(tempi);
            try {
                img = Image.createImage((String)("/res/barrier" + arr[3] + ".png"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            barrierSprites[i] = new Sprite(img);
            img = ParkingGameCanvas.rotateImage_img(img, arr[2]);
            barrierSprites[i].setImage(img, img.getWidth(), img.getHeight());
            barrierSprites[i].setPosition(arr[0], arr[1]);
        }
        return barrierSprites;
    }

    public TiledLayer[] getSeritTiledLayers() {
        this.fillGenelSeritHash();
        TiledLayer[] seritTiledLayers = new TiledLayer[this.genelSeritHash.size()];
        for (int i = 0; i < this.genelSeritHash.size(); ++i) {
            Image img = null;
            String tempi = "" + i;
            int[] arr = (int[])this.genelSeritHash.get(tempi);
            try {
                img = Image.createImage((String)("/res/serit" + arr[3] + ".png"));
                img = ParkingGameCanvas.rotateImage_img(img, arr[2]);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            seritTiledLayers[i] = new TiledLayer(1, 1, img, img.getWidth(), img.getHeight());
            seritTiledLayers[i].setCell(0, 0, 1);
            seritTiledLayers[i].setPosition(arr[0], arr[1]);
        }
        return seritTiledLayers;
    }

    public Image[] getParkAreaImage() {
        Image[] img = new Image[3];
        int parkAreaWidth = 0;
        int parkAreaHeigth = 0;
        int counter = 0;
        for (int i = 0; i < 3; ++i) {
            Image tempImg = null;
            try {
                tempImg = Image.createImage((String)"/res/park.png");
                parkAreaWidth = tempImg.getWidth() / 3;
                parkAreaHeigth = tempImg.getHeight();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            img[i] = Image.createImage((Image)tempImg, (int)counter, (int)0, (int)parkAreaWidth, (int)parkAreaHeigth, (int)0);
            counter += parkAreaWidth;
        }
        return img;
    }

    public Image getCrashImage() {
        try {
            return Image.createImage((String)"/res/crash.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

