/*
 * Decompiled with CFR 0.152.
 */
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class CrashCanvas
extends Canvas
implements Runnable {
    public static final int STATE__IDLE = 0;
    public static final int STATE__WAIT = 1;
    public static final int STATE__EXIT = 2;
    public static final int TEXT_LINE_STATE__NORMAL = 0;
    public static final int TEXT_LINE_STATE__FLICKER = 1;
    private static final int CENTER = 3;
    private ParkingGameMidlet midlet;
    private Displayable previousDisplay;
    private Thread thread;
    private Vector textLines;
    private Vector textLinesState;
    private int screenCenterX;
    private int screenCenterY;
    private int state = 0;
    private boolean flicker = true;

    public CrashCanvas(ParkingGameMidlet midlet) {
        this.initalize(midlet);
    }

    public void initalize(ParkingGameMidlet midlet) {
        midlet.gameCanvas.tusAlgila = false;
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.previousDisplay = Display.getDisplay((MIDlet)midlet).getCurrent();
        this.textLines = new Vector();
        this.textLinesState = new Vector();
        this.screenCenterX = this.getWidth() / 2;
        this.screenCenterY = this.getHeight() / 2;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setNextDisplay(Displayable nextDisplay) {
        this.previousDisplay = nextDisplay;
    }

    public void addText(String text, String color) {
        this.addText(text, 0, color);
    }

    public void addText(String text, int state, String color) {
        this.textLinesState.addElement(new Integer(state));
        this.textLines.addElement(JBManager.getInstance().getTextImage(text, "10x10-" + color));
    }

    public void removeTextFromEnd(int count) {
        for (int i = 0; i < count; ++i) {
            this.textLines.removeElementAt(this.textLines.size() - 1);
            this.textLinesState.removeElementAt(this.textLines.size() - 1);
        }
    }

    public void show() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void waitForClose() {
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        block4: for (int i = this.textLines.size() - 1; i >= 0; --i) {
            switch ((Integer)this.textLinesState.elementAt(i)) {
                case 0: {
                    g.drawImage((Image)this.textLines.elementAt(i), this.screenCenterX, this.screenCenterY - this.textLines.size() * 5 + i * 10 + 7, 3);
                    continue block4;
                }
                case 1: {
                    if (this.flicker) continue block4;
                    g.drawImage((Image)this.textLines.elementAt(i), this.screenCenterX, this.screenCenterY - this.textLines.size() * 5 + i * 10 + 7, 3);
                }
            }
        }
        this.flicker = !this.flicker;
    }

    protected void keyPressed(int keyCode) {
        keyCode = KeyCodeAdapter.getInstance().adoptKeyCode(keyCode);
        if (keyCode == 225 && this.state != 1) {
            this.state = 2;
        }
    }

    public void run() {
        while (true) {
            if (this.state == 2) break;
            this.repaint();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent(this.previousDisplay);
        this.midlet.gameCanvas.tusAlgila = true;
        this.midlet.gameCanvas.time1 = System.currentTimeMillis();
        this.midlet.gameCanvas.getKeyStates();
        this.midlet.gameCanvas.oyunAcildi = true;
    }
}

