/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;

public class CollisionDetector {
    ParkingGameCanvas canvas;
    private static CollisionDetector instance = new CollisionDetector();
    boolean engelCollided;
    boolean arabaCollided;
    boolean barrierCollided;
    boolean carOutBounds;
    int saveX;
    int saveY;
    int saveDirection;
    int engelHitCount;
    int arabaHitCount;
    boolean flag;
    boolean increment = false;

    public static CollisionDetector getInstance() {
        return instance;
    }

    public void clear() {
        this.canvas = null;
        this.engelCollided = false;
        this.arabaCollided = false;
        this.barrierCollided = false;
        this.carOutBounds = false;
    }

    public void detect(ParkingGameCanvas canvas, MyCar car) {
        int i;
        for (i = 0; i < canvas.barrierSprites.length; ++i) {
            if (!canvas.carSprite.collidesWith(canvas.barrierSprites[i], true)) continue;
            this.barrierCollided = true;
            break;
        }
        for (i = 0; i < canvas.carSprites.length; ++i) {
            if (!canvas.carSprite.collidesWith(canvas.carSprites[i], true)) continue;
            this.arabaCollided = true;
            break;
        }
        if (canvas.carSprite.collidesWith(canvas.engelLayer, true)) {
            this.engelCollided = true;
        }
        if (canvas.carSprite.getX() <= -10 || canvas.carSprite.getY() <= -10 || canvas.carSprite.getX() + canvas.carSprite.getWidth() >= canvas.myLevel.getGameWidth() + 10 || canvas.carSprite.getY() + canvas.carSprite.getHeight() >= canvas.myLevel.getGameHeigth() + 10) {
            this.carOutBounds = true;
        }
        if (this.engelCollided || this.barrierCollided || this.arabaCollided || this.carOutBounds) {
            canvas.collisionDetected = true;
            car.setCarX(this.saveX);
            car.setCarY(this.saveY);
            car.setDirection(this.saveDirection);
            if (this.carOutBounds) {
                if (!this.increment) {
                    car.setSpeed(-0.4 * car.getSpeed());
                    this.increment = true;
                    if (canvas.vibrationOn) {
                        Display.getDisplay((MIDlet)canvas.mid).vibrate(40);
                    }
                }
            } else if (this.engelCollided || this.barrierCollided) {
                if (!this.increment) {
                    car.setSpeed(-0.4 * car.getSpeed());
                    this.increment = true;
                    if (canvas.vibrationOn) {
                        Display.getDisplay((MIDlet)canvas.mid).vibrate(80);
                    }
                    SFXPlayer.getInstance().playEffect(2);
                    canvas.totalScore -= 48;
                    ++this.engelHitCount;
                }
            } else if (this.arabaCollided && !this.increment) {
                car.setSpeed(-0.4 * car.getSpeed());
                this.increment = true;
                if (canvas.vibrationOn) {
                    Display.getDisplay((MIDlet)canvas.mid).vibrate(80);
                }
                SFXPlayer.getInstance().playEffect(2);
                canvas.totalScore -= 48;
                ++this.arabaHitCount;
            }
        } else {
            canvas.collisionDetected = false;
        }
        this.carOutBounds = false;
        this.barrierCollided = false;
        this.arabaCollided = false;
        this.engelCollided = false;
    }
}

