/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

import com.lemonquest.utils.SSFunctions;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SSFont {
    private int fontHeight;
    private int charSpacing;
    private int lineSpacing;
    private int spaceSize;
    private int numSymbols;
    private int numLetters;
    private int currentPalette;
    private int previousPalette;
    private short[][] symbols;
    private char[] letterChars;
    private short[][] letterSymbols;
    private Image[] image;

    public SSFont(DataInputStream dataInputStream, int[][] nArray) {
        try {
            int n;
            int n2;
            byte by = dataInputStream.readByte();
            this.numSymbols = dataInputStream.readUnsignedByte();
            this.symbols = new short[this.numSymbols][6];
            for (n2 = 0; n2 < this.numSymbols; ++n2) {
                this.symbols[n2][0] = (short)dataInputStream.readUnsignedByte();
                this.symbols[n2][1] = (short)dataInputStream.readUnsignedByte();
                this.symbols[n2][2] = (short)dataInputStream.readUnsignedByte();
                this.symbols[n2][3] = (short)dataInputStream.readUnsignedByte();
                this.symbols[n2][4] = dataInputStream.readByte();
                this.symbols[n2][5] = dataInputStream.readByte();
            }
            this.fontHeight = dataInputStream.readUnsignedByte();
            this.charSpacing = dataInputStream.readByte();
            this.lineSpacing = dataInputStream.readUnsignedByte();
            this.spaceSize = dataInputStream.readUnsignedByte();
            this.numLetters = dataInputStream.readUnsignedByte();
            this.letterChars = new char[this.numLetters];
            this.letterSymbols = new short[this.numLetters][];
            for (n2 = 0; n2 < this.numLetters; ++n2) {
                this.letterChars[n2] = dataInputStream.readChar();
                int n3 = dataInputStream.readUnsignedByte();
                this.letterSymbols[n2] = new short[n3];
                for (n = 0; n < n3; ++n) {
                    this.letterSymbols[n2][n] = (short)dataInputStream.readUnsignedByte();
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[128];
            n = dataInputStream.read(byArray);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = dataInputStream.read(byArray);
            }
            byArray = byteArrayOutputStream.toByteArray();
            this.image = new Image[nArray == null ? 1 : nArray.length + 1];
            this.image[0] = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            int n4 = 1;
            while (0 < nArray.length) {
                SSFunctions.changePNGPalette(byArray, nArray[n4 - 1]);
                this.image[n4] = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                ++n4;
            }
            this.currentPalette = 0;
            byteArrayOutputStream.close();
            dataInputStream.close();
            byteArrayOutputStream = null;
            dataInputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCurrentPalette(int n) {
        if (n < this.image.length) {
            this.currentPalette = n;
        }
    }

    public short[][] getLineData(char[] cArray, int n) {
        Vector<short[]> vector = new Vector<short[]>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        int n5 = 0;
        int n6 = 0;
        int n7 = 48;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case ' ': {
                    if (n7 == 67) {
                        n3 = i - 1;
                        n4 = n6 - this.getCharSpacing();
                    }
                    n6 += this.getSpaceSize() + this.getCharSpacing();
                    n7 = 83;
                    break;
                }
                case '\n': {
                    n3 = i - 1;
                    n4 = n6 - this.getCharSpacing();
                    n7 = 78;
                    break;
                }
                default: {
                    if (bl) {
                        n2 = i;
                        bl = false;
                    }
                    if (n7 == 83) {
                        n5 = i;
                    } else if (n7 == 78) {
                        n5 = i;
                    }
                    n6 += this.getCharacterWidth(c) + this.getCharSpacing();
                    n7 = 67;
                }
            }
            if (i == cArray.length - 1) {
                n3 = i;
                n4 = n6 - this.getCharSpacing();
                n7 = 78;
            }
            if (n6 < n && n7 != 78) continue;
            short[] sArray = new short[3];
            if (!bl) {
                sArray[0] = (short)n2;
                sArray[1] = (short)n3;
                sArray[2] = (short)n4;
            }
            vector.addElement(sArray);
            if (n5 <= n3) {
                bl = true;
            } else {
                n2 = n5;
                n6 -= (n5 - n3) * this.getSpaceSize() - 2;
            }
            n6 -= n4 + this.getCharSpacing();
        }
        short[][] sArrayArray = new short[vector.size()][];
        Enumeration enumeration = vector.elements();
        for (int i = 0; i < sArrayArray.length; ++i) {
            sArrayArray[i] = (short[])enumeration.nextElement();
        }
        return sArrayArray;
    }

    private int getCharacterWidth(char c) {
        short[] sArray = this.getSymbolByCharacter(c, 0);
        if (sArray == null) {
            if (c == ' ') {
                return this.getSpaceSize();
            }
            System.out.println("Character " + c + " not found");
            return 0;
        }
        return sArray[2];
    }

    private short[] getSymbolByCharacter(char c, int n) {
        int n2 = this.binarySearchOnChars(c, 0, this.letterChars.length - 1);
        if (n2 == -1) {
            return null;
        }
        return this.symbols[this.letterSymbols[n2][n]];
    }

    public int binarySearchOnChars(char c, int n, int n2) {
        while (n < n2) {
            int n3 = (n + n2) / 2;
            if (this.letterChars[n3] < c) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        if (this.letterChars[n] == c) {
            return n;
        }
        return -1;
    }

    public int drawChar(Graphics graphics, char c, int n, int n2) {
        if (c == ' ') {
            return this.getSpaceSize();
        }
        int n3 = this.binarySearchOnChars(c, 0, this.letterChars.length - 1);
        if (n3 == -1) {
            return 0;
        }
        short[] sArray = this.letterSymbols[n3];
        int n4 = this.drawSymbol(graphics, this.symbols[sArray[0]], n, n2);
        for (int i = 1; i < sArray.length; ++i) {
            n4 = Math.max(n4, this.drawSymbol(graphics, this.symbols[sArray[i]], n, n2));
        }
        return n4;
    }

    public int getLineWidth(char[] cArray) {
        int n = 0;
        if (cArray.length < 1) {
            return 0;
        }
        n += this.getCharacterWidth(cArray[0]);
        for (int i = 1; i < cArray.length; ++i) {
            char c = cArray[i];
            n = n + this.getCharacterWidth(c) + this.getCharSpacing();
        }
        return n;
    }

    private int drawSymbol(Graphics graphics, short[] sArray, int n, int n2) {
        graphics.setClip(n -= sArray[4], n2 -= sArray[5], (int)sArray[2], (int)sArray[3]);
        graphics.drawImage(this.image[this.currentPalette], n - sArray[0], n2 - sArray[1], 20);
        return sArray[2];
    }

    public int drawString(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        if (this.getLineWidth(cArray) > n4) {
            StringBuffer stringBuffer = new StringBuffer(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                if (n4 - this.getCharacterWidth(cArray[i]) > 3 * this.getCharacterWidth('.')) {
                    n4 -= this.getCharacterWidth(cArray[i]);
                } else {
                    stringBuffer.append('.');
                    break;
                }
                stringBuffer.append(cArray[i]);
            }
            return this.drawString(graphics, stringBuffer.toString().toCharArray(), n, n2, n3);
        }
        return this.drawString(graphics, cArray, n, n2, n3);
    }

    public int drawString(Graphics graphics, char[] cArray, int n, int n2, int n3) {
        if ((n3 & 0x10) != 0) {
            n2 += this.getFontHeight();
        } else if ((n3 & 0x20) != 0) {
            n2 -= this.getLineSpacing();
        } else if ((n3 & 2) != 0) {
            n2 += this.getFontHeight() / 2;
        }
        int n4 = 0;
        if ((n3 & 8) != 0) {
            n4 = this.getLineWidth(cArray);
            n -= n4;
        } else if ((n3 & 1) != 0) {
            n4 = this.getLineWidth(cArray);
            n -= n4 / 2;
        }
        if (n4 == 0) {
            for (int i = 0; i < cArray.length; ++i) {
                n4 = n4 + this.drawChar(graphics, cArray[i], n + n4, n2) + this.getCharSpacing();
            }
        } else {
            for (int i = 0; i < cArray.length; ++i) {
                n = n + this.drawChar(graphics, cArray[i], n, n2) + this.getCharSpacing();
            }
        }
        return n4;
    }

    public int drawString(Graphics graphics, int n, char[] cArray, int n2, int n3, int n4) {
        this.previousPalette = this.currentPalette;
        this.setCurrentPalette(n);
        int n5 = this.drawString(graphics, cArray, n2, n3, n4);
        this.currentPalette = this.previousPalette;
        return n5;
    }

    public int drawString(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n3 - n7 - 4;
        int n10 = 0;
        short[][] sArray = this.getLineData(cArray, n9);
        n10 = Math.min(n4 / (this.getFontHeight() + this.getLineSpacing()), sArray.length);
        n6 = Math.min(n6, sArray.length - n10);
        this.drawFastString(graphics, cArray, n, n2, n9, n4, n5, n6, n10);
        if (sArray.length > n10) {
            int n11 = n10 * n4 / sArray.length;
            int n12 = n2 + n6 * n4 / sArray.length;
            graphics.setClip(n + n9, n2, n7 + 4, n4);
            graphics.setColor(n8);
            graphics.setStrokeStyle(0);
            graphics.fillRect(n + n9 + 5, n12, n7 - 4, n11);
            graphics.drawRect(n + n9 + 3, n2, n7 - 1, n4 - 1);
        }
        return n6;
    }

    public short[][] drawString(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5) {
        short[][] sArray = this.getLineData(cArray, n3);
        this.drawFastString(graphics, cArray, n, n2, n3, n4, n5, sArray);
        return sArray;
    }

    public short[][] drawFastString(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5, short[][] sArray) {
        int n6;
        int n7 = n4 / (this.getFontHeight() + this.getLineSpacing());
        if (n7 < 1) {
            n7 = 1;
        }
        if (sArray.length < n7) {
            n7 = sArray.length;
        }
        int n8 = n6 = n7 == 1 ? n7 * this.getFontHeight() : n7 * (this.getLineSpacing() + this.getFontHeight());
        n2 = (n5 & 0x20) != 0 ? (n2 -= n6) : ((n5 & 2) != 0 ? n2 + this.getFontHeight() + (n4 - n6 >> 1) : (n2 += this.getFontHeight()));
        if ((n5 & 8) != 0) {
            n += n3;
        } else if ((n5 & 1) != 0) {
            n += n3 / 2;
        }
        boolean bl = false;
        for (int i = 0; i < n7; ++i) {
            bl = false;
            if (sArray[i][2] != 0) {
                this.drawFastString(graphics, cArray, n, n2, n5, sArray[i]);
            }
            n2 = n2 + this.getLineSpacing() + this.getFontHeight();
        }
        return sArray;
    }

    public int getMaxNumLines(short[][] sArray, int n) {
        return n / (this.getFontHeight() + this.lineSpacing);
    }

    public short[][] drawFastString(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        short[][] sArray = this.getLineData(cArray, n3);
        int n9 = n4 / (this.getFontHeight() + this.getLineSpacing());
        if (n7 < n9) {
            n9 = n7;
        }
        int n10 = n8 = n9 == 1 ? n9 * this.getFontHeight() : n9 * (this.getLineSpacing() + this.getFontHeight());
        n2 = (n5 & 0x20) != 0 ? (n2 -= n8) : ((n5 & 2) != 0 ? (n2 += n4 - n8 >> 1) : (n2 += this.getFontHeight()));
        this.drawFastString(graphics, cArray, sArray, n, n2, n3, n5, n6, n7);
        return sArray;
    }

    public void drawFastString(Graphics graphics, char[] cArray, short[][] sArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5 + n6;
        if (n7 > sArray.length) {
            n7 = sArray.length;
        }
        if ((n4 & 8) != 0) {
            n += n3;
        } else if ((n4 & 1) != 0) {
            n += n3 / 2;
        }
        boolean bl = false;
        for (int i = n5; i < n7; ++i) {
            bl = false;
            if (sArray[i][2] != 0) {
                this.drawFastString(graphics, cArray, n, n2, n4, sArray[i]);
            }
            n2 = n2 + this.getLineSpacing() + this.getFontHeight();
        }
    }

    private void drawFastString(Graphics graphics, char[] cArray, int n, int n2, int n3, short[] sArray) {
        if ((n3 & 8) != 0) {
            n -= sArray[2];
        } else if ((n3 & 1) != 0) {
            n -= sArray[2] / 2;
        }
        for (int i = sArray[0]; i < sArray[1] + 1; ++i) {
            n = n + this.drawChar(graphics, cArray[i], n, n2) + this.getCharSpacing();
        }
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getCharSpacing() {
        return this.charSpacing;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public int getSpaceSize() {
        return this.spaceSize;
    }
}

