/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

import com.lemonquest.circulate.BoardManager;
import com.lemonquest.circulate.GameEngine;
import com.lemonquest.circulate.Math2D;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class SSDebug {
    private static Font smallFont = Font.getFont((int)0, (int)0, (int)8);
    private static int heightFont = smallFont.getHeight();
    private static long memoryTotal = 0L;
    private static long memoryFree = 0L;
    private static long memoryUsed = 0L;
    private static long memoryPrevious = 0L;
    private static long fps = 0L;
    private static long fps_integer = 0L;
    private static long fps_decimal = 0L;
    private static long frameLastTime = 0L;
    private static long frameNowTime = System.currentTimeMillis();
    private static long frameCounter = 0L;
    private static StringBuffer auxStringBuffer = new StringBuffer();

    public static void paintDebug(Graphics graphics, int n, long l, int n2, int n3, long l2, long l3) {
        memoryTotal = Runtime.getRuntime().totalMemory();
        if (memoryTotal - (memoryFree = Runtime.getRuntime().freeMemory()) < memoryPrevious && memoryTotal - memoryFree > memoryUsed) {
            memoryUsed = memoryTotal - memoryFree;
        }
        memoryPrevious = memoryTotal - memoryFree;
        graphics.setFont(smallFont);
        graphics.setColor(0);
        graphics.setClip(0, 0, n2, heightFont);
        graphics.fillRect(0, 0, n2, heightFont);
        graphics.setColor(0xFFFFFF);
        graphics.drawString((memoryUsed >> 10) + "/" + (memoryTotal - memoryFree >> 10) + "/" + (memoryTotal >> 10) + "KB.", 0, 0, 20);
        if (l3 > 1024L) {
            fps = 10L * l2 / (l3 >> 10);
            fps_integer = fps / 10L;
            fps_decimal = fps % 10L;
            graphics.drawString(fps_integer + "." + fps_decimal + "fps", n2, 0, 24);
        }
        graphics.setColor(0);
        graphics.setClip(0, n3 - heightFont, n2, heightFont);
        graphics.fillRect(0, n3 - heightFont, n2, heightFont);
        graphics.setColor(0xFFFFFF);
        if (n != 0) {
            graphics.drawString("keyCode: " + n, 0, n3, 36);
        }
        graphics.drawString(n2 + "x" + n3 + "px", n2, n3, 40);
        graphics.drawString("r/f=" + Math2D.COMPUTED_ROOTS / BoardManager.auxFrames, n2 / 2, n3, 33);
    }

    public static void paintDebug(Graphics graphics) {
        memoryTotal = Runtime.getRuntime().totalMemory();
        if (memoryTotal - (memoryFree = Runtime.getRuntime().freeMemory()) < memoryPrevious && memoryTotal - memoryFree > memoryUsed) {
            memoryUsed = memoryTotal - memoryFree;
        }
        memoryPrevious = memoryTotal - memoryFree;
        frameNowTime = System.currentTimeMillis();
        if (frameNowTime - frameLastTime > 0L) {
            fps += 10000L / (frameNowTime - frameLastTime);
        }
        frameLastTime = frameNowTime;
        ++frameCounter;
        graphics.setFont(smallFont);
        graphics.setColor(0);
        graphics.setClip(0, 0, GameEngine.uiDeviceWidth, heightFont);
        graphics.fillRect(0, 0, GameEngine.uiDeviceWidth, heightFont);
        graphics.setColor(0xFFFFFF);
        auxStringBuffer.setLength(0);
        auxStringBuffer.append(memoryUsed >> 10);
        auxStringBuffer.append("/");
        auxStringBuffer.append(memoryTotal - memoryFree >> 10);
        auxStringBuffer.append("/");
        auxStringBuffer.append(memoryTotal >> 10);
        auxStringBuffer.append("KB.");
        graphics.drawString(auxStringBuffer.toString(), 0, 0, 20);
        if (frameCounter == 10L) {
            fps_integer = (fps /= frameCounter) / 10L;
            fps_decimal = fps % 10L;
            fps = 0L;
            frameCounter = 0L;
        }
        auxStringBuffer.setLength(0);
        auxStringBuffer.append(fps_integer);
        auxStringBuffer.append(".");
        auxStringBuffer.append(fps_decimal);
        auxStringBuffer.append("fps");
        graphics.drawString(auxStringBuffer.toString(), GameEngine.uiDeviceWidth, 0, 24);
        graphics.setColor(0);
        graphics.setClip(0, GameEngine.uiDeviceHeight - heightFont, GameEngine.uiDeviceWidth, heightFont);
        graphics.fillRect(0, GameEngine.uiDeviceHeight - heightFont, GameEngine.uiDeviceWidth, heightFont);
        graphics.setColor(0xFFFFFF);
        if (GameEngine.lastKeyCode != 0) {
            auxStringBuffer.setLength(0);
            auxStringBuffer.append("keyCode: ");
            auxStringBuffer.append(GameEngine.lastKeyCode);
            graphics.drawString(auxStringBuffer.toString(), 0, GameEngine.uiDeviceHeight, 36);
        }
        auxStringBuffer.setLength(0);
        auxStringBuffer.append(GameEngine.uiDeviceWidth);
        auxStringBuffer.append("x");
        auxStringBuffer.append(GameEngine.uiDeviceHeight);
        auxStringBuffer.append("px");
        graphics.drawString(auxStringBuffer.toString(), GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight, 40);
        auxStringBuffer.setLength(0);
        auxStringBuffer.append("r/f=");
        auxStringBuffer.append(Math2D.COMPUTED_ROOTS / BoardManager.auxFrames);
        graphics.drawString(auxStringBuffer.toString(), GameEngine.uiDeviceWidth >> 1, GameEngine.uiDeviceHeight, 33);
    }
}

