/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import com.lemonquest.circulate.FX;
import com.lemonquest.circulate.GameCanvas;
import com.lemonquest.circulate.GameEngine;
import com.lemonquest.circulate.Math2D;
import javax.microedition.lcdui.Graphics;

public class MenuManager {
    private static GameEngine ge;
    public static final int STATE_NONE = 0;
    public static final int STATE_MENU_FIXED = 1;
    public static final int STATE_MENU_TRANSITION = 2;
    public static final int STATE_MENU_INFO = 3;
    public static final int STATE_MENU_ARE_YOU_SURE = 4;
    private static long nowTime;
    public int state = 1;
    private int[] stateList = null;
    private int stateIndexCurrent = 0;
    private int stateIndexAdd = 0;
    public static final int SPEED = 4;
    public static final int MIN_STEP = 2;
    public static final boolean BOUNCE = true;
    public static final int BOUNCE_AMOUNT = 20;
    private int menuFrames = 0;
    private int menuSelected = 0;
    private int optionSelected = 0;
    private String[][] optionText = null;
    private int[][] optionRadius = null;
    private int[][] optionRadiusFinal = null;
    private int[][] optionAngle = null;
    private int[][] optionAngleFinal = null;
    private String infoTitle = "";
    private String infoText = "";
    private int infoX = 0;
    private int infoXfinal = 0;
    private int infoY = 0;
    private int infoYfinal = 0;
    private int infoWidth = 0;
    private int infoWidthFinal = 0;
    private int infoHeight = 0;
    private int infoHeightFinal = 0;
    public int infoTextLine = 0;
    private String aysTitle = "";

    public MenuManager(GameEngine gameEngine, int n) {
        ge = gameEngine;
        this.infoY = GameEngine.uiDeviceHeight;
        this.infoYfinal = GameEngine.uiDeviceHeight;
        this.optionText = new String[n][];
        this.optionRadius = new int[n][];
        this.optionRadiusFinal = new int[n][];
        this.optionAngle = new int[n][];
        this.optionAngleFinal = new int[n][];
        this.in();
    }

    private void stateClear() {
        this.stateList = new int[8];
        this.stateIndexCurrent = 0;
        this.stateIndexAdd = 0;
    }

    private void stateAdd(int n) {
        this.stateIndexAdd = (this.stateIndexAdd + 1) % this.stateList.length;
        this.stateList[this.stateIndexAdd] = n;
    }

    private int stateNext() {
        if (this.stateList[(this.stateIndexCurrent + 1) % this.stateList.length] == 0) {
            return 0;
        }
        this.stateIndexCurrent = (this.stateIndexCurrent + 1) % this.stateList.length;
        this.state = this.getState();
        return this.state;
    }

    private int getState() {
        return this.stateList[this.stateIndexCurrent];
    }

    public boolean setMenu(int n, String[] stringArray) {
        if (n < 0) {
            return false;
        }
        if (n >= this.optionText.length) {
            return false;
        }
        this.optionText[n] = stringArray;
        this.optionRadius[n] = new int[stringArray.length];
        this.optionRadiusFinal[n] = new int[stringArray.length];
        this.optionAngle[n] = new int[stringArray.length];
        this.optionAngleFinal[n] = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.optionRadius[n][i] = 80;
            this.optionRadiusFinal[n][i] = 80;
            this.optionAngle[n][i] = (270 + i * (360 / stringArray.length)) % 360;
            this.optionAngleFinal[n][i] = (270 + i * (360 / stringArray.length)) % 360;
        }
        return true;
    }

    public void setMenuSelected(int n) {
        this.menuSelected = n;
    }

    public void setOptionSelected(int n) {
        this.optionSelected = n;
        for (int i = 0; i < this.optionText[this.menuSelected].length; ++i) {
            this.optionAngle[this.menuSelected][(i + this.optionSelected) % this.optionText[this.menuSelected].length] = (270 + i * (360 / this.optionText[this.menuSelected].length)) % 360;
            this.optionAngleFinal[this.menuSelected][(i + this.optionSelected) % this.optionText[this.menuSelected].length] = (270 + i * (360 / this.optionText[this.menuSelected].length)) % 360;
        }
    }

    public void setRadius(int n, int n2, int n3) {
        for (int i = 0; i < this.optionText[n].length; ++i) {
            this.optionRadius[n][i] = n2;
            this.optionRadiusFinal[n][i] = n3;
        }
    }

    public void setInfoText(String string, String string2, int n, int n2, int n3, int n4) {
        this.infoTextLine = 0;
        this.infoTitle = string;
        this.infoText = string2;
        this.infoX = n;
        this.infoY = n2;
        this.infoWidth = n3;
        this.infoHeight = n4;
        this.infoXfinal = n;
        this.infoYfinal = n2;
        this.infoWidthFinal = n3;
        this.infoHeightFinal = n4;
    }

    public void setInfoText(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.infoTextLine = 0;
        this.infoTitle = string;
        this.infoText = string2;
        this.infoX = n;
        this.infoY = n3;
        this.infoWidth = n5;
        this.infoHeight = n7;
        this.infoXfinal = n2;
        this.infoYfinal = n4;
        this.infoWidthFinal = n6;
        this.infoHeightFinal = n8;
    }

    public void setAreYouSureTitle(String string) {
        this.aysTitle = string;
    }

    public void setOptionString(int n, int n2, String string) {
        this.optionText[n][n2] = string;
    }

    public String getOptionSelected() {
        return this.optionText[this.menuSelected][this.optionSelected];
    }

    public int getOptionNumber(String string) {
        for (int i = 0; i < this.optionText[this.menuSelected].length; ++i) {
            if (!this.optionText[this.menuSelected][i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void in() {
        GameEngine.objectX[0] = 120;
        GameCanvas cfr_ignored_0 = MenuManager.ge.gc;
        GameEngine.objectY[0] = -GameCanvas.resImagesHeight[8];
        GameEngine.objectXfinal[0] = 120;
        GameEngine.objectYfinal[0] = 5;
    }

    public void out(int n) {
        GameEngine.objectXfinal[0] = GameEngine.uiDeviceWidth >> 1;
        GameCanvas cfr_ignored_0 = MenuManager.ge.gc;
        GameEngine.objectYfinal[0] = -GameCanvas.resImagesHeight[8];
    }

    public void explodeMenu(int n, int n2) {
        for (int i = 0; i < this.optionText[n].length; ++i) {
            long l = (long)this.optionRadius[n][i] * Math2D.cos(this.optionAngle[n][i]);
            long l2 = (long)this.optionRadius[n][i] * Math2D.sin(this.optionAngle[n][i]);
            FX.fireParticles(GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l2), 30, 150, 5, 10, 6, 1, 1850, n2, 3, true);
        }
    }

    public void pressLeft() {
        this.state = 2;
        if (GameEngine.configClockwise) {
            this.state = 2;
            this.optionSelected = (this.optionSelected + this.optionText[this.menuSelected].length - 1) % this.optionText[this.menuSelected].length;
            int n = 0;
            while (n < this.optionText[this.menuSelected].length) {
                int[] nArray = this.optionAngleFinal[this.menuSelected];
                int n2 = n++;
                nArray[n2] = nArray[n2] + 360 / this.optionText[this.menuSelected].length;
            }
        } else {
            this.optionSelected = (this.optionSelected + 1) % this.optionText[this.menuSelected].length;
            int n = 0;
            while (n < this.optionText[this.menuSelected].length) {
                int[] nArray = this.optionAngleFinal[this.menuSelected];
                int n3 = n++;
                nArray[n3] = nArray[n3] - 360 / this.optionText[this.menuSelected].length;
            }
        }
    }

    public void pressRight() {
        this.state = 2;
        if (GameEngine.configClockwise) {
            this.optionSelected = (this.optionSelected + 1) % this.optionText[this.menuSelected].length;
            int n = 0;
            while (n < this.optionText[this.menuSelected].length) {
                int[] nArray = this.optionAngleFinal[this.menuSelected];
                int n2 = n++;
                nArray[n2] = nArray[n2] - 360 / this.optionText[this.menuSelected].length;
            }
        } else {
            this.state = 2;
            this.optionSelected = (this.optionSelected + this.optionText[this.menuSelected].length - 1) % this.optionText[this.menuSelected].length;
            int n = 0;
            while (n < this.optionText[this.menuSelected].length) {
                int[] nArray = this.optionAngleFinal[this.menuSelected];
                int n3 = n++;
                nArray[n3] = nArray[n3] + 360 / this.optionText[this.menuSelected].length;
            }
        }
    }

    public void paint(Graphics graphics) {
        switch (this.state) {
            case 1: {
                this.paintFixed(graphics);
                break;
            }
            case 2: {
                this.paintTransition(graphics);
                break;
            }
            case 3: {
                this.paintInfo(graphics);
                break;
            }
            case 4: {
                this.paintAreYouSure(graphics);
            }
        }
        ++this.menuFrames;
    }

    private void paintFixed(Graphics graphics) {
        nowTime = System.currentTimeMillis();
        for (int i = 0; i < this.optionText[this.menuSelected].length; ++i) {
            int n;
            long l;
            long l2;
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    l2 = (long)this.optionRadius[this.menuSelected][i] * Math2D.cos(this.optionAngle[this.menuSelected][i]);
                                    l = (long)this.optionRadius[this.menuSelected][i] * Math2D.sin(this.optionAngle[this.menuSelected][i]) + 5120L;
                                    if (GameEngine.state == 5) break block33;
                                    if (GameEngine.state != 14) break block34;
                                }
                                if (GameEngine.moreGameEnabled) {
                                    if (i == 5) {
                                        GameCanvas cfr_ignored_0 = MenuManager.ge.gc;
                                        GameCanvas.resAnimations[1].drawAnimation(graphics, 7, System.currentTimeMillis(), GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l2), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l), true);
                                    } else if (i == 6) {
                                        GameCanvas cfr_ignored_1 = MenuManager.ge.gc;
                                        GameCanvas.resAnimations[1].drawAnimation(graphics, 6, System.currentTimeMillis(), GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l2), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l), true);
                                    } else {
                                        GameCanvas cfr_ignored_2 = MenuManager.ge.gc;
                                        GameCanvas.resAnimations[1].drawAnimation(graphics, i + 1, System.currentTimeMillis(), GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l2), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l), true);
                                    }
                                    if (i != this.optionSelected) continue;
                                    GameCanvas cfr_ignored_3 = MenuManager.ge.gc;
                                    GameCanvas.resAnimations[1].drawAnimation(graphics, 0, System.currentTimeMillis(), GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l2), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l), true);
                                    continue;
                                }
                                GameCanvas cfr_ignored_4 = MenuManager.ge.gc;
                                GameCanvas.resAnimations[1].drawAnimation(graphics, i + 1, System.currentTimeMillis(), GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l2), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l), true);
                                if (i != this.optionSelected) continue;
                                if (GameEngine.state != 5) continue;
                                GameCanvas cfr_ignored_5 = MenuManager.ge.gc;
                                GameCanvas.resAnimations[1].drawAnimation(graphics, 0, System.currentTimeMillis(), GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l2), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l), true);
                                continue;
                            }
                            if (GameEngine.state == 11) break block35;
                            if (GameEngine.state == 12) break block35;
                            if (GameEngine.state == 7) break block35;
                            if (GameEngine.state != 8) break block36;
                        }
                        GameCanvas cfr_ignored_6 = MenuManager.ge.gc;
                        GameCanvas.resAnimations[1].drawAnimation(graphics, i + 1, System.currentTimeMillis(), GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l2), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l), true);
                        if (i != this.optionSelected) continue;
                        if (GameEngine.state != 5) continue;
                        GameCanvas cfr_ignored_7 = MenuManager.ge.gc;
                        GameCanvas.resAnimations[1].drawAnimation(graphics, 0, System.currentTimeMillis(), GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l2), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l), true);
                        continue;
                    }
                    if (GameEngine.state == 10) break block37;
                    if (GameEngine.state != 13) break block38;
                }
                switch (i) {
                    case 2: {
                        n = 1;
                        break;
                    }
                    case 3: {
                        n = 10;
                        break;
                    }
                    case 4: {
                        n = 6;
                        break;
                    }
                    default: {
                        n = i + 8;
                    }
                }
                GameCanvas cfr_ignored_8 = MenuManager.ge.gc;
                GameCanvas.resAnimations[1].drawAnimation(graphics, n, System.currentTimeMillis(), GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l2), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l), true);
                if (i != this.optionSelected) continue;
                if (GameEngine.state != 10) continue;
                GameCanvas cfr_ignored_9 = MenuManager.ge.gc;
                GameCanvas.resAnimations[1].drawAnimation(graphics, 0, System.currentTimeMillis(), GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l2), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l), true);
                continue;
            }
            if (GameEngine.state != 20) continue;
            switch (i) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 10;
                    break;
                }
                case 2: {
                    n = 4;
                    break;
                }
                case 3: {
                    n = 8;
                    break;
                }
                case 4: {
                    n = 9;
                    break;
                }
                case 5: {
                    n = 6;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            GameCanvas cfr_ignored_10 = MenuManager.ge.gc;
            GameCanvas.resAnimations[1].drawAnimation(graphics, n, System.currentTimeMillis(), GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l2), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l), true);
            if (i != this.optionSelected) continue;
            if (GameEngine.state != 20) continue;
            GameCanvas cfr_ignored_11 = MenuManager.ge.gc;
            GameCanvas.resAnimations[1].drawAnimation(graphics, 0, System.currentTimeMillis(), GameEngine.uiDeviceWidth / 2 + Math2D.getPixel(l2), GameEngine.uiDeviceHeight / 2 - Math2D.getPixel(l), true);
        }
        if (this.optionText[this.menuSelected].length == 4) {
            GameCanvas cfr_ignored_12 = MenuManager.ge.gc;
            GameCanvas.resFonts[0].drawString(graphics, this.optionText[this.menuSelected][this.optionSelected].toCharArray(), 55, GameEngine.uiDeviceHeight / 2 - 25, 130, 40, 65);
        } else {
            GameCanvas cfr_ignored_13 = MenuManager.ge.gc;
            GameCanvas.resFonts[0].drawString(graphics, this.optionText[this.menuSelected][this.optionSelected].toCharArray(), GameEngine.uiDeviceWidth / 2, GameEngine.uiDeviceHeight / 2 - 5, 65);
        }
        if (GameEngine.state != 20 && GameEngine.state != 11 && GameEngine.state != 12 && GameEngine.state != 7 && GameEngine.state != 8) {
            GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[5].toCharArray(), 2, 318, 68);
            if (GameEngine.state == 10) {
                GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[6].toCharArray(), 238, 318, 72);
            }
        }
        FX.paintParticles(graphics, GameCanvas.resAnimations[3]);
        if (this.state != 20) {
            GameCanvas cfr_ignored_14 = MenuManager.ge.gc;
            GameCanvas.paintImage(graphics, 8, GameEngine.objectX[0], GameEngine.objectY[0], 17);
        }
        graphics.setColor(0xFFFFFF);
    }

    private void paintTransition(Graphics graphics) {
        int n;
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        ge.updateObjects(2, 4);
        for (n = 0; n < this.optionText[this.menuSelected].length; ++n) {
            n2 = this.optionAngleFinal[this.menuSelected][n] - this.optionAngle[this.menuSelected][n];
            if (n2 != 0) {
                bl = false;
                n3 = Math.max(2, Math.abs(n2 / 4));
                if (Math.abs(n2) < n3) {
                    this.optionAngle[this.menuSelected][n] = this.optionAngleFinal[this.menuSelected][n];
                } else if (n2 > 0) {
                    int[] nArray = this.optionAngle[this.menuSelected];
                    int n4 = n;
                    nArray[n4] = nArray[n4] + n3;
                } else if (n2 < 0) {
                    int[] nArray = this.optionAngle[this.menuSelected];
                    int n5 = n;
                    nArray[n5] = nArray[n5] - n3;
                }
            }
            if ((n2 = this.optionRadiusFinal[this.menuSelected][n] - this.optionRadius[this.menuSelected][n]) == 0) continue;
            bl = false;
            n3 = Math.max(2, Math.abs(n2 / 4));
            if (Math.abs(n2) < n3) {
                this.optionRadius[this.menuSelected][n] = this.optionRadiusFinal[this.menuSelected][n];
                continue;
            }
            if (n2 > 0) {
                int[] nArray = this.optionRadius[this.menuSelected];
                int n6 = n;
                nArray[n6] = nArray[n6] + n3;
                continue;
            }
            if (n2 >= 0) continue;
            int[] nArray = this.optionRadius[this.menuSelected];
            int n7 = n;
            nArray[n7] = nArray[n7] - n3;
        }
        this.paintFixed(graphics);
        if (this.infoY < GameEngine.uiDeviceHeight) {
            bl = false;
            this.infoYfinal = GameEngine.uiDeviceHeight;
            this.paintInfo(graphics);
        }
        if (bl) {
            this.state = 1;
            for (n = 0; n < this.optionText[this.menuSelected].length; ++n) {
                this.optionAngle[this.menuSelected][(n + this.optionSelected) % this.optionText[this.menuSelected].length] = (270 + n * (360 / this.optionText[this.menuSelected].length)) % 360;
                this.optionAngleFinal[this.menuSelected][(n + this.optionSelected) % this.optionText[this.menuSelected].length] = (270 + n * (360 / this.optionText[this.menuSelected].length)) % 360;
            }
        }
    }

    private void paintInfo(Graphics graphics) {
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n = this.infoWidthFinal - this.infoWidth;
        if (n != 0) {
            bl = false;
            n5 = Math.max(2, Math.abs(n / 4));
            if (Math.abs(n) < n5) {
                this.infoWidth = this.infoWidthFinal;
            } else if (n > 0) {
                this.infoWidth += n5;
            } else if (n < 0) {
                this.infoWidth -= n5;
            }
        }
        if ((n2 = this.infoHeightFinal - this.infoHeight) != 0) {
            bl = false;
            n5 = Math.max(2, Math.abs(n2 / 4));
            if (Math.abs(n2) < n5) {
                this.infoHeight = this.infoHeightFinal;
            } else if (n2 > 0) {
                this.infoHeight += n5;
            } else if (n2 < 0) {
                this.infoHeight -= n5;
            }
        }
        if ((n3 = this.infoXfinal - this.infoX) != 0) {
            n5 = Math.max(4, Math.abs(n3 / 4));
            if (Math.abs(n3) < n5) {
                this.infoX = this.infoXfinal;
            } else if (n3 > 0) {
                this.infoX += n5;
            } else if (n3 < 0) {
                this.infoX -= n5;
            }
        }
        if ((n4 = this.infoYfinal - this.infoY) != 0) {
            n5 = Math.max(4, Math.abs(n4 / 4));
            if (Math.abs(n4) < n5) {
                this.infoY = this.infoYfinal;
            } else if (n4 > 0) {
                this.infoY += n5;
            } else if (n4 < 0) {
                this.infoY -= n5;
            }
        }
        if (this.state == 3) {
            this.paintFixed(graphics);
        }
        GameCanvas cfr_ignored_0 = MenuManager.ge.gc;
        GameCanvas.paintFrameItem(graphics, this.infoX, this.infoY, this.infoWidth, this.infoHeight);
        if (bl) {
            graphics.setClip(this.infoX, this.infoY, this.infoWidth, this.infoHeight);
            graphics.setColor(0);
            GameCanvas cfr_ignored_1 = MenuManager.ge.gc;
            graphics.fillRoundRect(this.infoX + 6, this.infoY + 6, this.infoWidth - 12, GameCanvas.resFonts[0].getFontHeight() + 4, 10, 10);
            GameCanvas cfr_ignored_2 = MenuManager.ge.gc;
            GameCanvas.resFonts[0].drawString(graphics, this.infoTitle.toCharArray(), this.infoX + this.infoWidth / 2, this.infoY + 7, 17);
            if (this.infoText.equals(GameCanvas.lang[33])) {
                GameCanvas cfr_ignored_3 = MenuManager.ge.gc;
                GameCanvas cfr_ignored_4 = MenuManager.ge.gc;
                GameCanvas cfr_ignored_5 = MenuManager.ge.gc;
                this.infoTextLine = GameCanvas.resFonts[1].drawString(graphics, this.infoText.toCharArray(), this.infoX + 6, this.infoY + 12 + GameCanvas.resFonts[0].getFontHeight(), this.infoWidth - 16, this.infoHeight - 20 - GameCanvas.resFonts[0].getFontHeight(), 17, this.infoTextLine, 7, 11297560);
            } else {
                GameCanvas cfr_ignored_6 = MenuManager.ge.gc;
                GameCanvas cfr_ignored_7 = MenuManager.ge.gc;
                GameCanvas cfr_ignored_8 = MenuManager.ge.gc;
                this.infoTextLine = GameCanvas.resFonts[1].drawString(graphics, this.infoText.toCharArray(), this.infoX + 6, this.infoY + 12 + GameCanvas.resFonts[0].getFontHeight(), this.infoWidth - 12, this.infoHeight - 20 - GameCanvas.resFonts[0].getFontHeight(), 17, this.infoTextLine, 7, 11297560);
            }
        }
        if (this.state != 2) {
            GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[6].toCharArray(), 238, 318, 72);
        }
    }

    private void paintAreYouSure(Graphics graphics) {
        this.paintFixed(graphics);
        GameCanvas cfr_ignored_0 = MenuManager.ge.gc;
        GameCanvas.paintFrameItem(graphics, 0, GameEngine.uiDeviceHeight - 70, GameEngine.uiDeviceWidth, 80);
        graphics.setClip(0, GameEngine.uiDeviceHeight - 70, GameEngine.uiDeviceWidth, 70);
        graphics.setColor(0);
        GameCanvas cfr_ignored_1 = MenuManager.ge.gc;
        graphics.fillRoundRect(6, GameEngine.uiDeviceHeight - 70 + 6, GameEngine.uiDeviceWidth - 12, GameCanvas.resFonts[0].getFontHeight() + 4, 10, 10);
        GameCanvas cfr_ignored_2 = MenuManager.ge.gc;
        GameCanvas.resFonts[0].drawString(graphics, this.aysTitle.toCharArray(), GameEngine.uiDeviceWidth / 2, GameEngine.uiDeviceHeight - 70 + 7, 17);
        if (GameEngine.state == 13) {
            GameCanvas cfr_ignored_3 = MenuManager.ge.gc;
            GameCanvas.resFonts[1].drawString(graphics, (GameCanvas.lang[20] + "\n" + GameCanvas.lang[18]).toCharArray(), 5, 272, 230, 36, 17);
        } else {
            GameCanvas cfr_ignored_4 = MenuManager.ge.gc;
            GameCanvas.resFonts[1].drawString(graphics, GameCanvas.lang[18].toCharArray(), GameEngine.uiDeviceWidth / 2, GameEngine.uiDeviceHeight - 40 + 7, 17);
        }
        GameCanvas cfr_ignored_5 = MenuManager.ge.gc;
        GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[2].toCharArray(), 6, GameEngine.uiDeviceHeight - 4, 68);
        GameCanvas cfr_ignored_6 = MenuManager.ge.gc;
        GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[3].toCharArray(), GameEngine.uiDeviceWidth - 6, GameEngine.uiDeviceHeight - 4, 72);
    }

    static {
        nowTime = System.currentTimeMillis();
    }
}

