/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import com.lemonquest.circulate.BoardManager;
import com.lemonquest.circulate.FX;
import com.lemonquest.circulate.GameCanvas;
import com.lemonquest.circulate.GameEngine;
import com.lemonquest.circulate.Math2D;
import javax.microedition.lcdui.Graphics;

public class Hole {
    GameEngine ge;
    public int size;
    public long rad;
    public long rad2;
    public long[] pos = new long[2];
    public long[] posIni = new long[2];
    public long TIME_TO_KILL = 100L;
    public boolean[] ballsTrapped = new boolean[16];
    public long[] timeTrapped = new long[16];
    public long d;
    public long dA;
    public long dB;

    public Hole(GameEngine gameEngine, int n, int n2, int n3) {
        this.ge = gameEngine;
        this.pos[0] = this.posIni[0] = (long)n << 10;
        this.pos[1] = this.posIni[1] = (long)n2 << 10;
        this.rad = (long)n3 << 10;
        this.rad2 = Math2D.pow2(this.rad);
    }

    public boolean isBallTrapped(int n) {
        if (BoardManager.balls[n].isTrapped && this.ballsTrapped[n]) {
            return BoardManager.balls[n].isTrapped && this.ballsTrapped[n];
        }
        this.d = Math2D.distancePointPoint_Pow2(this.pos[0], this.pos[1], BoardManager.balls[n].pos[0], BoardManager.balls[n].pos[1]);
        if (this.d < Math2D.pow2(BoardManager.balls[n].rad + this.rad)) {
            BoardManager.balls[n].isTrapped = true;
            this.ballsTrapped[n] = true;
            this.timeTrapped[n] = System.currentTimeMillis();
        } else {
            BoardManager.balls[n].isTrapped = false;
            this.ballsTrapped[n] = false;
        }
        return BoardManager.balls[n].isTrapped && this.ballsTrapped[n];
    }

    public void paintHole(Graphics graphics, int n, int n2) {
        GameCanvas.resAnimations[9].drawAnimation(graphics, 0, System.currentTimeMillis(), n + Math2D.getPixel(this.pos[0]), n2 - Math2D.getPixel(this.pos[1]), true);
        GameCanvas.resAnimations[10].drawAnimation(graphics, 0, System.currentTimeMillis(), n + Math2D.getPixel(this.pos[0]), n2 - Math2D.getPixel(this.pos[1]), true);
    }

    public void paintRays(Graphics graphics, int n, int n2) {
        for (int i = 0; i < 16; ++i) {
            if (!this.ballsTrapped[i]) continue;
            if (System.currentTimeMillis() - this.timeTrapped[i] < this.TIME_TO_KILL) {
                FX.paintRay(graphics, n + Math2D.getPixel(this.pos[0]), n2 - Math2D.getPixel(this.pos[1]), n + Math2D.getPixel(BoardManager.balls[i].pos[0]), n2 - Math2D.getPixel(BoardManager.balls[i].pos[1]), 2838656, 3, 10);
                switch (BoardManager.balls[i].type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        FX.fireParticles(n + Math2D.getPixel(BoardManager.balls[i].pos[0]), n2 - Math2D.getPixel(BoardManager.balls[i].pos[1]), 30, 150, 8, 10, 6, 1, 1850, 1, BoardManager.balls[i].type, true);
                    }
                }
                continue;
            }
            BoardManager.balls[i].status = -1;
            BoardManager.balls[i].destroyTime = System.currentTimeMillis();
            this.ballsTrapped[i] = false;
            GameEngine.trophyCounter[22] = GameEngine.trophyCounter[22] + 1;
            GameEngine.trophyCounter[23] = GameEngine.trophyCounter[23] + 1;
            GameEngine.trophyCounter[24] = GameEngine.trophyCounter[24] + 1;
        }
    }
}

