/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import com.lemonquest.circulate.BoardManager;
import com.lemonquest.circulate.Crono;
import com.lemonquest.circulate.FX;
import com.lemonquest.circulate.GameCanvas;
import com.lemonquest.circulate.GameMIDlet;
import com.lemonquest.circulate.Math2D;
import com.lemonquest.circulate.MenuManager;
import com.lemonquest.circulate.MenuSelector;
import com.lemonquest.circulate.MenuTrophies;
import com.lemonquest.circulate.Sound;
import com.lemonquest.utils.SSDebug;
import com.lemonquest.utils.SSFunctions;
import com.lemonquest.utils.SSKeyboard;
import com.lemonquest.utils.SSMath;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class GameEngine
extends Canvas {
    private static boolean running;
    public static int lastKeyCode;
    public static long lastKeyPressedTime;
    public static long lastProcessTime;
    private static long pauseTime;
    public GameMIDlet gm;
    public GameCanvas gc;
    public Sound sound;
    private static final int TIME_SPLASH = 6570;
    private static final int TIME_COVER = 3000;
    public static long waitingTime;
    public static String moreGamesURL;
    public static boolean moreGameEnabled;
    public static boolean configSound;
    public static boolean configVibrate;
    public static boolean configClockwise;
    private static final int MAX_PROCESS = 66;
    public static int loadingStep;
    public static int loadingTotal;
    public static long loadingTime;
    public static long sqrtPerSecond;
    public static final String GOD_CODE = "19771106";
    public static int godCounter;
    public static boolean godMode;
    public static boolean debug;
    public static boolean editorMode;
    public static int gameFrames;
    public static int gameFramesAux;
    public static long gameTimestamp;
    public static final int STATE_NONE = 0;
    public static final int STATE_SPLASH = 1;
    public static final int STATE_SPLASH_PI_EYE = 2;
    public static final int STATE_SOUND_QUESTION = 3;
    public static final int STATE_LOADING = 4;
    public static final int STATE_MENU_MAIN = 5;
    public static final int STATE_MENU_SELECT_LEVEL = 6;
    public static final int STATE_MENU_TROPHIES = 7;
    public static final int STATE_MENU_TROPHIES_DETAILS = 8;
    public static final int STATE_MENU_TROPHIES_POPUP = 9;
    public static final int STATE_MENU_OPTIONS = 10;
    public static final int STATE_MENU_HELP = 11;
    public static final int STATE_MENU_CREDITS = 12;
    public static final int STATE_MENU_RESET_GAME = 13;
    public static final int STATE_MENU_EXIT = 14;
    public static final int STATE_GAME_BEFORE = 15;
    public static final int STATE_GAME_PLAYING = 16;
    public static final int STATE_GAME_VICTORY = 17;
    public static final int STATE_GAME_FAIL = 18;
    public static final int STATE_GAME_TIME_OUT = 19;
    public static final int STATE_GAME_MENU = 20;
    public static final int STATE_GAME_MENU_HELP = 21;
    public static final int STATE_GAME_DETAILS = 22;
    public static final int STATE_EDITOR_BEFORE = 23;
    public static final int STATE_EDITOR_PLAYING = 24;
    public static final int STATE_EDITOR_AFTER = 25;
    public static final int STATE_LANDSCAPE = 26;
    public static final int STATE_GAME_MENU_5 = 27;
    public static final int STATE_MENU_Album = 28;
    public static final int STATE_MENU_UninstallAlbum = 29;
    public static final int STATE_MENU_LoaninglAlbum = 30;
    public static final int STATE_GAME_Album = 31;
    public static final int STATE_GAME_UAlbum = 32;
    public static final int STATE_GAME_LAlbum = 33;
    public static int statePrevLandscape;
    public static int state;
    public static int toState;
    public static SSKeyboard keyboard;
    private static final int COLOR_BACKGROUND = 0;
    private static final int COLOR_FRONT = 0xFFFFFF;
    private static final int COLOR_SELECTED = 0xFF0000;
    public static Font uiFontSmall;
    public static int uiFontSmallH;
    public static Font uiFontMedium;
    public static int uiFontMediumH;
    public static int uiDeviceWidth;
    public static int uiDeviceHeight;
    public static int uiBackground;
    public static int uiBackgroundNext;
    public static int uiBackgroundOut;
    public static int uiBackgroundIn;
    public static int uiBackgroundStep;
    public static boolean uiBackgroundSwap;
    public static final int SWAP_FROM_LEFT = -1;
    public static final int SWAP_FROM_CENTER = 0;
    public static final int SWAP_FROM_RIGHT = 1;
    public static int uiBackgroundSwapDir;
    public static int uiBackgroundSwapDirNext;
    private static StringBuffer uiInfo;
    private static boolean uiKeyUpPressed;
    private static boolean uiKeyDownPressed;
    public static boolean uiKeyRightPressed;
    public static boolean uiKeyLeftPressed;
    private static long uiKeyPressedStart;
    private static final int TIME_SCROLL_TEXT = 200;
    public static long uiTimeToScrollText;
    public static int uiTextLine;
    public static final int OBJECT_TITLE = 0;
    public static final int OBJECT_TOP_LABEL = 1;
    public static final int OBJECT_TOP_ALPHA = 2;
    public static final int OBJECT_BOTTOM_ALPHA = 3;
    public static final int OBJECT_LEFT_ARROW = 4;
    public static final int OBJECT_ICON = 5;
    public static final int OBJECT_RIGHT_ARROW = 6;
    public static final int OBJECT_ALPHA_UP = 7;
    public static final int OBJECT_ALPHA_DOWN = 8;
    public static final int MAX_OBJECTS = 9;
    public static int[] objectX;
    public static int[] objectXfinal;
    public static int[] objectY;
    public static int[] objectYfinal;
    public static int[] objectW;
    public static int[] objectH;
    public static int[] objectWfinal;
    public static int[] objectHfinal;
    public static boolean[] objectOnScreen;
    public static boolean objectsOnScreen;
    public static boolean objectsFixed;
    public static MenuManager menu;
    public static MenuSelector menuSelector;
    public static MenuTrophies menuTrophies;
    public static BoardManager board;
    public static Crono clock;
    public static int prepreviousState;
    public static int previousState;
    public static final long FIVE_STARS_TIME = 46000L;
    public static final long ONE_MORE_STAR_TIME = 10000L;
    public static final int TPZS = 10;
    public static final int TOTAL_LEVELS = 50;
    public static long TIME_OVER;
    public static String[] levelData;
    public static String[] levelTitle;
    public static String[] levelDescription;
    public static int[] levelIcon;
    public static int[] levelBackground;
    public static int levelSelected;
    public static String levelTimeString;
    public static long levelTime;
    public static int levelScore;
    public static int levelStars;
    public static int[] levelStarsNeeded;
    public static long[] levelBestTime;
    public static int[] levelBestScore;
    public static int[] levelBestStars;
    public static int totalStars;
    public static int totalScore;
    public static int totalLevelsComplete;
    public static int totalLevelsFiveStars;
    public static final int TROPHY_10_LEVELS = 0;
    public static final int TROPHY_20_LEVELS = 1;
    public static final int TROPHY_30_LEVELS = 2;
    public static final int TROPHY_40_LEVELS = 3;
    public static final int TROPHY_50_LEVELS = 4;
    public static final int TROPHY_50_STARS = 5;
    public static final int TROPHY_100_STARS = 6;
    public static final int TROPHY_150_STARS = 7;
    public static final int TROPHY_200_STARS = 8;
    public static final int TROPHY_10_LEVELS_5_STARS = 9;
    public static final int TROPHY_20_LEVELS_5_STARS = 10;
    public static final int TROPHY_30_LEVELS_5_STARS = 11;
    public static final int TROPHY_40_LEVELS_5_STARS = 12;
    public static final int TROPHY_KILL_50_BALLS = 13;
    public static final int TROPHY_KILL_100_BALLS = 14;
    public static final int TROPHY_KILL_200_BALLS = 15;
    public static final int TROPHY_KILL_500_BALLS = 16;
    public static final int TROPHY_READ_HELP = 17;
    public static final int TROPHY_READ_CREDITS = 18;
    public static final int TROPHY_9000_DEGREES = 19;
    public static final int TROPHY_18000_DEGREES = 20;
    public static final int TROPHY_36000_DEGREES = 21;
    public static final int TROPHY_HOLES_50_BALLS = 22;
    public static final int TROPHY_HOLES_100_BALLS = 23;
    public static final int TROPHY_HOLES_200_BALLS = 24;
    public static final int TOTAL_TROPHIES = 25;
    public static String[] trophyTitle;
    public static String[] trophyDescription;
    public static boolean[] trophyVisible;
    public static boolean[] trophyUnlocked;
    public static int[] trophyPoints;
    public static int[] trophyCounterFinal;
    public static int[] trophyCounter;
    public static boolean[] trophiesToShow;
    public static int trophyToShow;
    public static int totalTrophiesUnlocked;
    public static int totalTrophyPoints;
    public static int AlbumPage;
    public static int UAlbum;
    public static boolean isAlbumPage;
    public static boolean isLAlbum;
    int loadIndex;

    public GameEngine(GameMIDlet gameMIDlet) {
        this.setFullScreenMode(true);
        gameTimestamp = System.currentTimeMillis();
        this.gm = gameMIDlet;
        this.gc = new GameCanvas(this);
        keyboard = new SSKeyboard();
        clock = new Crono();
        this.sound = new Sound();
        configVibrate = true;
        try {
            moreGamesURL = gameMIDlet.getAppProperty("URL_ECAP_GMG");
            if (moreGamesURL != null && moreGamesURL.length() > 5) {
                moreGameEnabled = true;
                System.out.println("MoreGames Enabled -> '" + moreGamesURL + "'");
            }
        }
        catch (Exception exception) {
            moreGamesURL = null;
            moreGameEnabled = false;
        }
        this.loadConfig();
        this.gc.loadLanguage();
        GameCanvas.resLoad(0, 2);
        GameCanvas.resLoad(0, 0);
        GameCanvas.resLoad(7, 1);
        GameCanvas.resLoad(6, 1);
        waitingTime = System.currentTimeMillis();
        state = 1;
        if (editorMode) {
            state = 4;
            toState = 24;
            levelSelected = 0;
            GameEngine.levelTitle[0] = "EDITOR";
            GameEngine.levelDescription[0] = "Circulate Mobile";
            System.out.println("***********************");
            System.out.println("*     EDITOR MODE     *");
            System.out.println("***********************");
        }
    }

    private void process() {
        if (this.getWidth() > 240 && state != 26) {
            if (state == 16) {
                state = 20;
                GameEngine.menu.state = 2;
                menu.setRadius(2, 0, 80);
                menu.setMenuSelected(2);
                menu.setOptionSelected(0);
                clock.stop();
            }
            statePrevLandscape = state;
            state = 26;
        }
        switch (state) {
            case 26: {
                if (this.getWidth() != 240) break;
                state = statePrevLandscape;
                keyboard.removeAllEvents();
                break;
            }
            case 1: {
                state = 2;
                waitingTime = System.currentTimeMillis();
                break;
            }
            case 2: {
                if (System.currentTimeMillis() > waitingTime + 3000L) {
                    state = 4;
                    toState = 0;
                } else {
                    gameFramesAux = 0;
                }
                keyboard.removeAllEvents();
                break;
            }
            case 3: {
                this.processKeysSoundQuestion();
                keyboard.removeAllEvents();
                break;
            }
            case 4: {
                this.processLoading();
                keyboard.removeAllEvents();
                break;
            }
            case 30: {
                this.LoadingAlbum();
                break;
            }
            case 29: {
                this.UninstallAlbum();
                break;
            }
            case 33: {
                this.LoadingAlbum();
                break;
            }
            case 32: {
                if (configSound) {
                    this.sound.playMidi(1, 1);
                }
                this.UninstallAlbum();
                break;
            }
            case 11: 
            case 12: {
                if (uiTimeToScrollText >= lastProcessTime) {
                    if (uiKeyUpPressed) {
                        GameEngine.menu.infoTextLine = Math.max(0, GameEngine.menu.infoTextLine - 1);
                    } else if (uiKeyDownPressed) {
                        GameEngine.menu.infoTextLine = Math.max(0, GameEngine.menu.infoTextLine + 1);
                    }
                    uiTimeToScrollText = lastProcessTime + 200L;
                }
                this.processKeysRepeat();
                break;
            }
            case 21: {
                if (uiTimeToScrollText >= lastProcessTime) {
                    if (uiKeyUpPressed) {
                        uiTextLine = Math.max(0, uiTextLine - 1);
                    } else if (uiKeyDownPressed) {
                        uiTextLine = Math.max(0, uiTextLine + 1);
                    }
                    uiTimeToScrollText = lastProcessTime + 200L;
                }
                this.processKeysRepeat();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 28: 
            case 31: {
                this.processKeysMenu();
                break;
            }
            case 9: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: {
                this.processKeysGame();
                break;
            }
            case 16: 
            case 24: {
                this.processKeysArena();
                if (state != 16 && state != 24) break;
                board.processArena();
                break;
            }
            case 27: {
                this.processKeysMenu5();
            }
        }
        FX.processParticles();
    }

    public void ALoaning(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 320);
        GameCanvas.resFonts[0].drawString(graphics, GameCanvas.lang[4].toCharArray(), 150, 160, 9);
        graphics.setClip(0, 0, 240, 320);
    }

    public void LoadingAlbum() {
        GameCanvas.resUnload(0, 1);
        GameCanvas.resUnload(1, 1);
        GameCanvas.resUnload(2, 1);
        GameCanvas.resUnload(3, 1);
        GameCanvas.resUnload(4, 1);
        GameCanvas.resUnload(5, 1);
        if (state == 30) {
            if (levelBestStars[AlbumPage * 5 - 1] > 0) {
                isLAlbum = true;
                if (isLAlbum) {
                    switch (AlbumPage) {
                        case 1: {
                            GameCanvas.resLoad(16, 1);
                            UAlbum = 1;
                            break;
                        }
                        case 2: {
                            GameCanvas.resLoad(17, 1);
                            UAlbum = 2;
                            break;
                        }
                        case 3: {
                            GameCanvas.resLoad(18, 1);
                            UAlbum = 3;
                            break;
                        }
                        case 4: {
                            GameCanvas.resLoad(19, 1);
                            UAlbum = 4;
                            break;
                        }
                        case 5: {
                            GameCanvas.resLoad(20, 1);
                            UAlbum = 5;
                            break;
                        }
                        case 6: {
                            GameCanvas.resLoad(21, 1);
                            UAlbum = 6;
                            break;
                        }
                        case 7: {
                            GameCanvas.resLoad(22, 1);
                            UAlbum = 7;
                            break;
                        }
                        case 8: {
                            GameCanvas.resLoad(23, 1);
                            UAlbum = 8;
                            break;
                        }
                        case 9: {
                            GameCanvas.resLoad(24, 1);
                            UAlbum = 9;
                            break;
                        }
                        case 10: {
                            GameCanvas.resLoad(25, 1);
                            UAlbum = 10;
                        }
                    }
                }
            } else {
                isLAlbum = false;
                GameCanvas.resLoad(26, 1);
                UAlbum = 0;
            }
            state = 28;
        } else {
            switch (levelSelected + 1) {
                case 5: {
                    GameCanvas.resLoad(16, 1);
                    break;
                }
                case 10: {
                    GameCanvas.resLoad(17, 1);
                    break;
                }
                case 15: {
                    GameCanvas.resLoad(18, 1);
                    break;
                }
                case 20: {
                    GameCanvas.resLoad(19, 1);
                    break;
                }
                case 25: {
                    GameCanvas.resLoad(20, 1);
                    break;
                }
                case 30: {
                    GameCanvas.resLoad(21, 1);
                    break;
                }
                case 35: {
                    GameCanvas.resLoad(22, 1);
                    break;
                }
                case 40: {
                    GameCanvas.resLoad(23, 1);
                    break;
                }
                case 45: {
                    GameCanvas.resLoad(24, 1);
                    break;
                }
                case 50: {
                    GameCanvas.resLoad(25, 1);
                }
            }
            state = 31;
        }
    }

    public void UninstallAlbum() {
        if (state == 29) {
            switch (UAlbum) {
                case 0: {
                    GameCanvas.resUnload(26, 1);
                    break;
                }
                case 1: {
                    GameCanvas.resUnload(16, 1);
                    break;
                }
                case 2: {
                    GameCanvas.resUnload(17, 1);
                    break;
                }
                case 3: {
                    GameCanvas.resUnload(18, 1);
                    break;
                }
                case 4: {
                    GameCanvas.resUnload(19, 1);
                    break;
                }
                case 5: {
                    GameCanvas.resUnload(20, 1);
                    break;
                }
                case 6: {
                    GameCanvas.resUnload(21, 1);
                    break;
                }
                case 7: {
                    GameCanvas.resUnload(22, 1);
                    break;
                }
                case 8: {
                    GameCanvas.resUnload(23, 1);
                    break;
                }
                case 9: {
                    GameCanvas.resUnload(24, 1);
                    break;
                }
                case 10: {
                    GameCanvas.resUnload(25, 1);
                }
            }
        } else {
            switch (levelSelected + 1) {
                case 5: {
                    GameCanvas.resUnload(16, 1);
                    break;
                }
                case 10: {
                    GameCanvas.resUnload(17, 1);
                    break;
                }
                case 15: {
                    GameCanvas.resUnload(18, 1);
                    break;
                }
                case 20: {
                    GameCanvas.resUnload(19, 1);
                    break;
                }
                case 25: {
                    GameCanvas.resUnload(20, 1);
                    break;
                }
                case 30: {
                    GameCanvas.resUnload(21, 1);
                    break;
                }
                case 35: {
                    GameCanvas.resUnload(22, 1);
                    break;
                }
                case 40: {
                    GameCanvas.resUnload(23, 1);
                    break;
                }
                case 45: {
                    GameCanvas.resUnload(24, 1);
                    break;
                }
                case 50: {
                    GameCanvas.resUnload(25, 1);
                }
            }
        }
        GameCanvas.resLoad(0, 1);
        GameCanvas.resLoad(1, 1);
        GameCanvas.resLoad(2, 1);
        GameCanvas.resLoad(3, 1);
        GameCanvas.resLoad(4, 1);
        GameCanvas.resLoad(5, 1);
        state = state == 29 ? (isAlbumPage ? 5 : 30) : 17;
    }

    public void processLoading() {
        switch (toState) {
            case 24: {
                System.out.println("*** processLoading(): loading necessary resources ***");
                loadingTotal = 10;
                loadingStep = 0;
                loadingTime = System.currentTimeMillis();
                uiDeviceWidth = this.getWidth();
                uiDeviceHeight = this.getHeight();
                board = new BoardManager(this);
                board.loadAndBuildLevel("/editor.lev");
                uiBackground = uiBackgroundNext;
                GameCanvas.resLoad(3, 2);
                GameCanvas.resLoad(1, 2);
                GameCanvas.resLoad(2, 2);
                GameCanvas.resLoad(uiBackground, 1);
                GameCanvas.resLoad(3, 0);
                GameCanvas.resLoad(10, 1);
                GameCanvas.resLoad(4, 0);
                GameCanvas.resLoad(6, 0);
                GameCanvas.resLoad(7, 0);
                GameCanvas.resLoad(8, 0);
                GameCanvas.resLoad(5, 0);
                GameCanvas.resLoad(9, 0);
                GameCanvas.resLoad(10, 0);
                GameCanvas.resLoad(14, 1);
                GameCanvas.resLoad(13, 1);
                GameCanvas.resLoad(11, 0);
                GameCanvas.resLoad(12, 0);
                GameCanvas.resLoad(13, 0);
                this.initObjects();
                state = 24;
                clock.reset();
                clock.start();
                BoardManager.auxFrames = 1L;
                Math2D.COMPUTED_ROOTS = 0L;
                break;
            }
            default: {
                System.out.println("*** processLoading(): loading all resources ***");
                loadingTotal = 10;
                loadingStep = 0;
                loadingTime = System.currentTimeMillis();
                uiDeviceWidth = this.getWidth();
                uiDeviceHeight = this.getHeight();
                uiBackground = 5;
                uiBackgroundNext = 5;
                uiBackgroundOut = 5;
                uiBackgroundIn = 5;
                GameCanvas.resUnload(0, 0);
                GameCanvas.resUnload(7, 1);
                GameCanvas.resUnload(6, 1);
                GameCanvas.resLoad(3, 2);
                GameCanvas.resLoad(1, 2);
                GameCanvas.resLoad(2, 2);
                GameCanvas.resLoad(8, 1);
                GameCanvas.resLoad(5, 1);
                ++loadingStep;
                this.repaint();
                this.serviceRepaints();
                GameCanvas.resLoad(0, 1);
                GameCanvas.resLoad(1, 1);
                ++loadingStep;
                this.repaint();
                this.serviceRepaints();
                GameCanvas.resLoad(2, 1);
                GameCanvas.resLoad(3, 1);
                GameCanvas.resLoad(4, 1);
                ++loadingStep;
                this.repaint();
                this.serviceRepaints();
                GameCanvas.resLoad(1, 0);
                GameCanvas.resLoad(3, 0);
                GameCanvas.resLoad(9, 1);
                ++loadingStep;
                this.repaint();
                this.serviceRepaints();
                GameCanvas.resLoad(11, 1);
                GameCanvas.resLoad(12, 1);
                GameCanvas.resLoad(2, 0);
                ++loadingStep;
                this.repaint();
                this.serviceRepaints();
                GameCanvas.resLoad(10, 1);
                GameCanvas.resLoad(4, 0);
                GameCanvas.resLoad(6, 0);
                ++loadingStep;
                this.repaint();
                this.serviceRepaints();
                GameCanvas.resLoad(7, 0);
                GameCanvas.resLoad(8, 0);
                GameCanvas.resLoad(5, 0);
                ++loadingStep;
                this.repaint();
                this.serviceRepaints();
                GameCanvas.resLoad(9, 0);
                GameCanvas.resLoad(10, 0);
                GameCanvas.resLoad(14, 1);
                GameCanvas.resLoad(13, 1);
                GameCanvas.resLoad(11, 0);
                GameCanvas.resLoad(12, 0);
                GameCanvas.resLoad(13, 0);
                GameCanvas.resLoad(15, 1);
                ++loadingStep;
                this.repaint();
                this.serviceRepaints();
                menu = new MenuManager(this, 3);
                if (moreGameEnabled) {
                    menu.setMenu(0, new String[]{GameCanvas.lang[11], GameCanvas.lang[13], GameCanvas.lang[14], GameCanvas.lang[15], GameCanvas.lang[16], GameCanvas.lang[12], GameCanvas.lang[17]});
                } else {
                    menu.setMenu(0, new String[]{GameCanvas.lang[11], GameCanvas.lang[13], GameCanvas.lang[14], GameCanvas.lang[15], GameCanvas.lang[16], GameCanvas.lang[17]});
                }
                menu.setMenu(1, new String[]{configSound ? GameCanvas.lang[21] + " " + GameCanvas.lang[25] : GameCanvas.lang[21] + " " + GameCanvas.lang[26], configVibrate ? GameCanvas.lang[22] + " " + GameCanvas.lang[25] : GameCanvas.lang[22] + " " + GameCanvas.lang[26], configClockwise ? GameCanvas.lang[23] : GameCanvas.lang[24], GameCanvas.lang[6], GameCanvas.lang[19]});
                menu.setMenu(2, new String[]{GameCanvas.lang[8], GameCanvas.lang[9], GameCanvas.lang[15], configSound ? GameCanvas.lang[21] + " " + GameCanvas.lang[25] : GameCanvas.lang[21] + " " + GameCanvas.lang[26], configVibrate ? GameCanvas.lang[22] + " " + GameCanvas.lang[25] : GameCanvas.lang[22] + " " + GameCanvas.lang[26], GameCanvas.lang[35]});
                GameEngine.menu.state = 2;
                menu.setRadius(0, 0, 80);
                menuSelector = new MenuSelector(this);
                menuTrophies = new MenuTrophies(this);
                System.out.println("   Board & Levels");
                board = new BoardManager(this);
                if (editorMode) {
                    board.loadAndBuildLevel("/editor.lev");
                    ++loadingStep;
                    this.repaint();
                    this.serviceRepaints();
                } else {
                    levelData = board.loadLevels();
                    board.loadLevelTitles();
                    ++loadingStep;
                    this.repaint();
                    this.serviceRepaints();
                }
                this.loadScores();
                this.loadTrophies();
                this.initObjects();
                menu.in();
                loadingStep = loadingTotal;
                this.repaint();
                this.serviceRepaints();
                if (editorMode) {
                    state = 24;
                    clock.reset();
                    clock.start();
                    break;
                }
                state = 3;
                toState = 0;
            }
        }
    }

    private void processSound() {
    }

    private int processKeysMenu5() {
        while (keyboard.getHasMoreKeys()) {
            char c = keyboard.nextChar();
            if (keyboard.getLastEvent() != 0) continue;
            switch (c) {
                case '\u0002': 
                case '5': {
                    state = previousState;
                    if (state == 16) {
                        state = 20;
                    }
                    if (state < 5 || state > 15 || state <= 4 && state != 27) break;
                    if (Sound.lastMidi == 1) break;
                    if (Sound.lastMidi == 2 || !configSound) break;
                    this.sound.playMidi(0, -1);
                }
            }
        }
        return 0;
    }

    private void processKeysNotRepeat() {
        while (keyboard.getHasMoreKeys()) {
            char c = keyboard.nextChar();
            if (keyboard.getLastEvent() != 0) continue;
            switch (c) {
                case '\u0005': 
                case '2': {
                    uiTextLine = Math.max(0, uiTextLine - 5);
                    GameEngine.menu.infoTextLine = Math.max(0, GameEngine.menu.infoTextLine - 5);
                    break;
                }
                case '\u0006': 
                case '8': {
                    uiTextLine += 5;
                    GameEngine.menu.infoTextLine += 5;
                    break;
                }
                case '\u0001': 
                case '\u0002': 
                case '5': {
                    if (state == 21) {
                        state = 20;
                        GameEngine.menu.state = 2;
                        menu.setRadius(2, 0, 80);
                        menu.setMenuSelected(2);
                        break;
                    }
                    state = 5;
                    GameEngine.menu.state = 2;
                    menu.setMenuSelected(0);
                    if (state == 11) {
                        menu.setOptionSelected(menu.getOptionNumber(GameCanvas.lang[15]));
                        break;
                    }
                    if (state != 12) break;
                    menu.setOptionSelected(menu.getOptionNumber(GameCanvas.lang[16]));
                }
            }
        }
    }

    private void processKeysRepeat() {
        while (keyboard.getHasMoreKeys()) {
            char c = keyboard.nextChar();
            if (keyboard.getLastEvent() != 0) {
                uiKeyUpPressed = false;
                uiKeyDownPressed = false;
                keyboard.removeAllEvents();
                continue;
            }
            switch (c) {
                case '\u0005': 
                case '2': {
                    uiKeyDownPressed = false;
                    uiKeyUpPressed = true;
                    uiTimeToScrollText = lastProcessTime + 200L;
                    GameEngine.menu.infoTextLine = Math.max(0, GameEngine.menu.infoTextLine - 1);
                    break;
                }
                case '\u0006': 
                case '8': {
                    uiKeyDownPressed = true;
                    uiKeyUpPressed = false;
                    uiTimeToScrollText = lastProcessTime + 200L;
                    ++GameEngine.menu.infoTextLine;
                    break;
                }
                case '\u0001': 
                case '\u0002': 
                case '5': {
                    if (state == 21) {
                        state = 20;
                        GameEngine.menu.state = 2;
                        menu.setRadius(2, 0, 80);
                        menu.setMenuSelected(2);
                        break;
                    }
                    state = 5;
                    GameEngine.menu.state = 2;
                    menu.setMenuSelected(0);
                    if (state == 11) {
                        menu.setOptionSelected(menu.getOptionNumber(GameCanvas.lang[15]));
                        break;
                    }
                    if (state != 12) break;
                    menu.setOptionSelected(menu.getOptionNumber(GameCanvas.lang[16]));
                }
            }
        }
    }

    private void processKeysSoundQuestion() {
        while (keyboard.getHasMoreKeys()) {
            char c = keyboard.nextChar();
            if (keyboard.getLastEvent() != 0) continue;
            switch (c) {
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    configSound = true;
                    menu.setOptionString(2, 3, GameCanvas.lang[21] + " " + GameCanvas.lang[25]);
                    menu.setOptionString(1, 0, GameCanvas.lang[21] + " " + GameCanvas.lang[25]);
                    state = 5;
                    toState = 0;
                    this.sound.playMidi(0, -1);
                    break;
                }
                case '\u0001': {
                    configSound = false;
                    menu.setOptionString(2, 3, GameCanvas.lang[21] + " " + GameCanvas.lang[26]);
                    menu.setOptionString(1, 0, GameCanvas.lang[21] + " " + GameCanvas.lang[26]);
                    state = 5;
                    toState = 0;
                }
            }
        }
    }

    private void processKeysMenu() {
        while (keyboard.getHasMoreKeys()) {
            char c = keyboard.nextChar();
            if (keyboard.getLastEvent() != 0) continue;
            this.cheat(c);
            if (state == 5) {
                switch (c) {
                    case '*': {
                        if (!godMode) break;
                        debug = !debug;
                        break;
                    }
                    case '\u0003': 
                    case '4': {
                        menu.pressLeft();
                        break;
                    }
                    case '\u0004': 
                    case '6': {
                        menu.pressRight();
                        break;
                    }
                    case '\u0000': 
                    case '\u0002': 
                    case '5': {
                        if (menu.getOptionSelected().equals(GameCanvas.lang[11])) {
                            state = 6;
                            GameEngine.menu.state = 2;
                            menu.explodeMenu(0, FX.freeParticles / 6);
                            menuSelector.in();
                            lastKeyPressedTime = 0L;
                            uiBackgroundNext = levelBackground[levelSelected];
                            uiBackgroundSwapDir = 0;
                            break;
                        }
                        if (menu.getOptionSelected().equals(GameCanvas.lang[13])) {
                            state = 7;
                            break;
                        }
                        if (menu.getOptionSelected().equals(GameCanvas.lang[14])) {
                            state = 10;
                            GameEngine.menu.state = 2;
                            menu.explodeMenu(0, FX.freeParticles / 6);
                            menu.setRadius(1, 0, 80);
                            menu.setMenuSelected(1);
                            menu.setOptionSelected(0);
                            break;
                        }
                        if (menu.getOptionSelected().equals(GameCanvas.lang[15])) {
                            state = 11;
                            GameEngine.menu.state = 3;
                            menu.setInfoText(GameCanvas.lang[15], GameCanvas.lang[33], 10, (uiDeviceHeight - uiDeviceHeight / 2) / 2 + 16, 220, 2 * uiDeviceHeight / 3 - 20);
                            GameEngine.trophyVisible[17] = true;
                            GameEngine.trophyUnlocked[17] = true;
                            totalTrophiesUnlocked = SSMath.sum(trophyUnlocked);
                            totalTrophyPoints = this.countTrophiesPoints();
                            break;
                        }
                        if (menu.getOptionSelected().equals(GameCanvas.lang[16])) {
                            state = 11;
                            GameEngine.menu.state = 3;
                            menu.setInfoText(GameCanvas.lang[16], GameCanvas.lang[34], 10, (uiDeviceHeight - uiDeviceHeight / 2) / 2 + 16, 220, 2 * uiDeviceHeight / 3 - 20);
                            GameEngine.trophyVisible[18] = true;
                            GameEngine.trophyUnlocked[18] = true;
                            totalTrophiesUnlocked = SSMath.sum(trophyUnlocked);
                            totalTrophyPoints = this.countTrophiesPoints();
                            break;
                        }
                        if (menu.getOptionSelected().equals(GameCanvas.lang[17])) {
                            state = 14;
                            GameEngine.menu.state = 4;
                            menu.setAreYouSureTitle(GameCanvas.lang[17]);
                            break;
                        }
                        if (!menu.getOptionSelected().equals(GameCanvas.lang[12])) break;
                        try {
                            configSound = false;
                            menu.setOptionString(2, 3, GameCanvas.lang[21] + " " + GameCanvas.lang[26]);
                            menu.setOptionString(1, 0, GameCanvas.lang[21] + " " + GameCanvas.lang[26]);
                            this.sound.stopMidi(Sound.currentMidi);
                            this.gm.platformRequest(moreGamesURL);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                continue;
            }
            if (state == 7) continue;
            if (state == 28) {
                if (state != 28) continue;
                switch (c) {
                    case '\u0003': 
                    case '4': {
                        isAlbumPage = false;
                        if (AlbumPage >= 0 && --AlbumPage <= 0) {
                            AlbumPage = 10;
                        }
                        state = 29;
                        break;
                    }
                    case '\u0004': 
                    case '6': {
                        isAlbumPage = false;
                        if (AlbumPage <= 11 && ++AlbumPage >= 11) {
                            AlbumPage = 1;
                        }
                        state = 29;
                        break;
                    }
                    case '\u0001': {
                        isAlbumPage = true;
                        state = 29;
                        AlbumPage = 1;
                    }
                }
                continue;
            }
            if (state == 31) {
                switch (c) {
                    case '\u0001': {
                        state = 32;
                    }
                }
                continue;
            }
            if (state == 8) {
                switch (c) {
                    case '\u0001': 
                    case '\u0002': 
                    case '5': {
                        state = 7;
                    }
                }
                continue;
            }
            if (state == 6) {
                switch (c) {
                    case '\u0003': 
                    case '4': {
                        menuSelector.pressLeft();
                        uiBackgroundNext = levelBackground[levelSelected];
                        uiBackgroundSwapDirNext = 1;
                        break;
                    }
                    case '\u0004': 
                    case '6': {
                        menuSelector.pressRight();
                        uiBackgroundNext = levelBackground[levelSelected];
                        uiBackgroundSwapDirNext = -1;
                        break;
                    }
                    case '\u0001': {
                        menuSelector.out(1);
                        menu.in();
                        lastKeyPressedTime = 0L;
                        uiBackgroundNext = 5;
                        uiBackgroundSwapDirNext = 0;
                        break;
                    }
                    case '\u0000': 
                    case '\u0002': 
                    case '5': {
                        if (totalStars < levelStarsNeeded[levelSelected]) break;
                        state = 15;
                        board.inPreview();
                        board.buildLevel(levelData[levelSelected]);
                        if (!configSound) break;
                        this.sound.stopMidi(Sound.currentMidi);
                    }
                }
                continue;
            }
            if (state == 10) {
                switch (c) {
                    case '\u0003': 
                    case '4': {
                        menu.pressLeft();
                        break;
                    }
                    case '\u0004': 
                    case '6': {
                        menu.pressRight();
                        break;
                    }
                    case '\u0001': {
                        state = 5;
                        GameEngine.menu.state = 2;
                        menu.explodeMenu(1, FX.freeParticles / 6);
                        menu.setRadius(0, 0, 80);
                        menu.setMenuSelected(0);
                        menu.setOptionSelected(menu.getOptionNumber(GameCanvas.lang[14]));
                        break;
                    }
                    case '\u0000': 
                    case '\u0002': 
                    case '5': {
                        if (menu.getOptionSelected().startsWith(GameCanvas.lang[6].substring(0, 4))) {
                            state = 5;
                            GameEngine.menu.state = 2;
                            menu.explodeMenu(1, FX.freeParticles / 6);
                            menu.setRadius(0, 0, 80);
                            menu.setMenuSelected(0);
                            menu.setOptionSelected(menu.getOptionNumber(GameCanvas.lang[14]));
                            break;
                        }
                        if (menu.getOptionSelected().startsWith(GameCanvas.lang[21])) {
                            boolean bl = configSound = !configSound;
                            if (configSound) {
                                menu.setOptionString(2, 3, GameCanvas.lang[21] + " " + GameCanvas.lang[25]);
                                menu.setOptionString(1, 0, GameCanvas.lang[21] + " " + GameCanvas.lang[25]);
                                this.sound.playMidi(0, -1);
                                break;
                            }
                            menu.setOptionString(2, 3, GameCanvas.lang[21] + " " + GameCanvas.lang[26]);
                            menu.setOptionString(1, 0, GameCanvas.lang[21] + " " + GameCanvas.lang[26]);
                            this.sound.stopMidi(0);
                            break;
                        }
                        if (menu.getOptionSelected().startsWith(GameCanvas.lang[22])) {
                            boolean bl = configVibrate = !configVibrate;
                            if (configVibrate) {
                                Display.getDisplay((MIDlet)this.gm).vibrate(200);
                                menu.setOptionString(1, 1, GameCanvas.lang[22] + " " + GameCanvas.lang[25]);
                                menu.setOptionString(2, 4, GameCanvas.lang[22] + " " + GameCanvas.lang[25]);
                                break;
                            }
                            menu.setOptionString(1, 1, GameCanvas.lang[22] + " " + GameCanvas.lang[26]);
                            menu.setOptionString(2, 4, GameCanvas.lang[22] + " " + GameCanvas.lang[26]);
                            break;
                        }
                        if (menu.getOptionSelected().startsWith(GameCanvas.lang[23].substring(0, 4))) {
                            boolean bl = configClockwise = !configClockwise;
                            if (configClockwise) {
                                menu.setOptionString(1, menu.getOptionNumber(GameCanvas.lang[24]), GameCanvas.lang[23]);
                                break;
                            }
                            menu.setOptionString(1, menu.getOptionNumber(GameCanvas.lang[23]), GameCanvas.lang[24]);
                            break;
                        }
                        if (!menu.getOptionSelected().equals(GameCanvas.lang[19])) break;
                        state = 13;
                        GameEngine.menu.state = 4;
                        menu.setAreYouSureTitle(GameCanvas.lang[19]);
                    }
                }
                continue;
            }
            if (state == 13) {
                switch (c) {
                    case '\u0000': {
                        int n;
                        levelSelected = 0;
                        for (n = 0; n < 50; ++n) {
                            GameEngine.levelBestTime[n] = 0L;
                            GameEngine.levelBestScore[n] = 0;
                            GameEngine.levelBestStars[n] = 0;
                        }
                        totalScore = SSMath.sum(levelBestScore);
                        totalStars = SSMath.sum(levelBestStars);
                        for (n = 0; n < 25; ++n) {
                            GameEngine.trophyCounter[n] = 0;
                            GameEngine.trophyUnlocked[n] = false;
                            GameEngine.trophyVisible[n] = true;
                            GameEngine.trophiesToShow[n] = false;
                        }
                        totalTrophiesUnlocked = SSMath.sum(trophyUnlocked);
                        totalTrophyPoints = this.countTrophiesPoints();
                        GameEngine.trophyVisible[17] = false;
                        GameEngine.trophyVisible[18] = false;
                        GameEngine.trophyVisible[19] = false;
                        GameEngine.trophyVisible[20] = false;
                        GameEngine.trophyVisible[21] = false;
                        GameEngine.trophyVisible[22] = false;
                        GameEngine.trophyVisible[23] = false;
                        GameEngine.trophyVisible[24] = false;
                        this.saveScores();
                        this.saveTrophies();
                        state = 10;
                        GameEngine.menu.state = 2;
                        break;
                    }
                    case '\u0001': {
                        state = 10;
                        GameEngine.menu.state = 2;
                    }
                }
                continue;
            }
            if (state != 14) continue;
            switch (c) {
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    this.saveConfig();
                    this.saveTrophies();
                    this.gm.running = false;
                    running = false;
                    break;
                }
                case '\u0001': {
                    state = 5;
                    GameEngine.menu.state = 2;
                }
            }
        }
    }

    private void processKeysGame() {
        while (keyboard.getHasMoreKeys()) {
            char c = keyboard.nextChar();
            if (keyboard.getLastEvent() != 0) continue;
            this.cheat(c);
            if (state == 15) {
                switch (c) {
                    case '\u0001': {
                        state = 6;
                        if (configSound) {
                            this.sound.playMidi(0, -1);
                        }
                        board.out();
                        menuSelector.inArrows();
                        break;
                    }
                    case '\u0000': 
                    case '\u0002': 
                    case '5': {
                        BoardManager.auxFrames = 1L;
                        Math2D.COMPUTED_ROOTS = 0L;
                        state = 16;
                        board.outLabels();
                        clock.reset();
                        clock.start();
                    }
                }
                continue;
            }
            if (state == 22) {
                switch (c) {
                    case '\u0000': 
                    case '\u0002': 
                    case '5': {
                        state = 16;
                        board.outLabels();
                        clock.start();
                    }
                }
                continue;
            }
            if (state == 20) {
                switch (c) {
                    case '\u0003': 
                    case '4': {
                        menu.pressLeft();
                        break;
                    }
                    case '\u0004': 
                    case '6': {
                        menu.pressRight();
                        break;
                    }
                    case '\u0001': {
                        state = 16;
                        clock.start();
                        break;
                    }
                    case '\u0000': 
                    case '\u0002': 
                    case '5': {
                        if (menu.getOptionSelected().equals(GameCanvas.lang[15])) {
                            uiTextLine = 0;
                            state = 21;
                            break;
                        }
                        if (menu.getOptionSelected().startsWith(GameCanvas.lang[21])) {
                            boolean bl = configSound = !configSound;
                            if (configSound) {
                                menu.setOptionString(2, 3, GameCanvas.lang[21] + " " + GameCanvas.lang[25]);
                                menu.setOptionString(1, 0, GameCanvas.lang[21] + " " + GameCanvas.lang[25]);
                                this.sound.playMidi(3, 1);
                                break;
                            }
                            menu.setOptionString(2, 3, GameCanvas.lang[21] + " " + GameCanvas.lang[26]);
                            menu.setOptionString(1, 0, GameCanvas.lang[21] + " " + GameCanvas.lang[26]);
                            break;
                        }
                        if (menu.getOptionSelected().startsWith(GameCanvas.lang[22])) {
                            boolean bl = configVibrate = !configVibrate;
                            if (configVibrate) {
                                Display.getDisplay((MIDlet)this.gm).vibrate(200);
                            }
                            menu.setOptionString(1, 1, configVibrate ? GameCanvas.lang[22] + " " + GameCanvas.lang[25] : GameCanvas.lang[22] + " " + GameCanvas.lang[26]);
                            menu.setOptionString(2, 4, configVibrate ? GameCanvas.lang[22] + " " + GameCanvas.lang[25] : GameCanvas.lang[22] + " " + GameCanvas.lang[26]);
                            break;
                        }
                        if (menu.getOptionSelected().startsWith(GameCanvas.lang[8])) {
                            state = 16;
                            clock.start();
                            break;
                        }
                        if (menu.getOptionSelected().equals(GameCanvas.lang[9]) || menu.getOptionSelected().equals(GameCanvas.lang[9].substring(3))) {
                            state = 16;
                            board.buildLevel(levelData[levelSelected]);
                            clock.reset();
                            clock.start();
                            BoardManager.auxFrames = 1L;
                            Math2D.COMPUTED_ROOTS = 0L;
                            break;
                        }
                        if (!menu.getOptionSelected().equals(GameCanvas.lang[35])) break;
                        state = 6;
                        menuSelector.in();
                        if (!configSound) break;
                        this.sound.playMidi(0, -1);
                    }
                }
                continue;
            }
            if (state == 27) {
                switch (c) {
                    case '5': {
                        state = 20;
                        GameEngine.menu.state = 2;
                    }
                }
                continue;
            }
            if (state == 17) {
                switch (c) {
                    case '\u0000': 
                    case '\u0002': 
                    case '5': {
                        if (editorMode) {
                            state = 24;
                            board.loadAndBuildLevel("/editor.lev");
                            clock.reset();
                            clock.start();
                            BoardManager.auxFrames = 1L;
                            Math2D.COMPUTED_ROOTS = 0L;
                            break;
                        }
                        trophyToShow = -1;
                        if (trophyToShow != -1) break;
                        state = 6;
                        if (levelSelected < 49) {
                            menuSelector.pressRight();
                        }
                        menuSelector.inArrows();
                        if (!configSound) break;
                        this.sound.playMidi(0, -1);
                    }
                }
                continue;
            }
            if (state == 18 || state == 19) {
                switch (c) {
                    case '\u0000': 
                    case '\u0002': 
                    case '5': {
                        if (editorMode) {
                            state = 24;
                            board.loadAndBuildLevel("/editor.lev");
                            clock.reset();
                            clock.start();
                            BoardManager.auxFrames = 1L;
                            Math2D.COMPUTED_ROOTS = 0L;
                            break;
                        }
                        state = 15;
                        board.buildLevel(levelData[levelSelected]);
                        break;
                    }
                    case '\u0001': {
                        state = 6;
                        menuSelector.inArrows();
                        if (!configSound) break;
                        this.sound.playMidi(0, -1);
                    }
                }
                continue;
            }
            if (state != 9) continue;
            switch (c) {
                case '\u0000': 
                case '\u0002': 
                case '5': {
                    trophyToShow = -1;
                    for (int i = 0; i < 25; ++i) {
                        if (!trophiesToShow[i]) continue;
                        trophyToShow = i;
                        GameEngine.trophiesToShow[i] = false;
                        break;
                    }
                    if (trophyToShow != -1) break;
                    state = 6;
                    if (levelSelected < 49) {
                        menuSelector.pressRight();
                    }
                    menuSelector.inArrows();
                    if (!configSound) break;
                    this.sound.playMidi(0, -1);
                }
            }
        }
    }

    private void processKeysArena() {
        block8: while (keyboard.getHasMoreKeys()) {
            char c = keyboard.nextChar();
            if (keyboard.getLastEvent() != 0) {
                uiKeyLeftPressed = false;
                uiKeyRightPressed = false;
                continue;
            }
            switch (c) {
                case '*': {
                    if (state == 24) {
                        debug = !debug;
                        continue block8;
                    }
                    if (!godMode) continue block8;
                    debug = !debug;
                    continue block8;
                }
                case '#': {
                    if (state == 24) {
                        board.loadAndBuildLevel("/editor.lev");
                        clock.reset();
                        clock.start();
                        BoardManager.auxFrames = 1L;
                        Math2D.COMPUTED_ROOTS = 0L;
                        continue block8;
                    }
                    if (!godMode) continue block8;
                    state = 17;
                    board.andThenThereWasVictory();
                    continue block8;
                }
                case '\u0000': {
                    uiKeyLeftPressed = false;
                    uiKeyRightPressed = false;
                    state = 22;
                    clock.stop();
                    board.resetBallsTogether();
                    BoardManager.paintObjects = true;
                    GameEngine.objectYfinal[7] = (320 - objectH[7] - objectH[8]) / 2;
                    GameEngine.objectY[7] = objectYfinal[7];
                    GameEngine.objectYfinal[8] = objectYfinal[7] + objectH[7];
                    GameEngine.objectY[8] = objectYfinal[8];
                    if (configSound) {
                        this.sound.stopMidi(Sound.currentMidi);
                    }
                    if (!configSound) continue block8;
                    this.sound.playWav(7, 1);
                    continue block8;
                }
                case '\u0001': {
                    uiKeyLeftPressed = false;
                    uiKeyRightPressed = false;
                    state = 20;
                    GameEngine.menu.state = 2;
                    menu.setRadius(2, 0, 80);
                    menu.setMenuSelected(2);
                    menu.setOptionSelected(0);
                    clock.stop();
                    board.resetBallsTogether();
                    if (configSound) {
                        this.sound.stopMidi(Sound.currentMidi);
                    }
                    if (!configSound) continue block8;
                    this.sound.playWav(7, 1);
                    continue block8;
                }
                case '\u0003': 
                case '4': {
                    uiKeyPressedStart = System.currentTimeMillis();
                    if (configClockwise) {
                        uiKeyLeftPressed = false;
                        uiKeyRightPressed = true;
                        BoardManager.arenaAngleSpeed = BoardManager.arenaAngleSpeedMin;
                        continue block8;
                    }
                    uiKeyLeftPressed = true;
                    uiKeyRightPressed = false;
                    BoardManager.arenaAngleSpeed = -BoardManager.arenaAngleSpeedMin;
                    continue block8;
                }
                case '\u0004': 
                case '6': {
                    uiKeyPressedStart = System.currentTimeMillis();
                    if (configClockwise) {
                        uiKeyLeftPressed = true;
                        uiKeyRightPressed = false;
                        BoardManager.arenaAngleSpeed = -BoardManager.arenaAngleSpeedMin;
                        continue block8;
                    }
                    uiKeyLeftPressed = false;
                    uiKeyRightPressed = true;
                    BoardManager.arenaAngleSpeed = BoardManager.arenaAngleSpeedMin;
                    continue block8;
                }
            }
            if (state != 16) continue;
            int n = 0;
            while (true) {
                block37: {
                    block38: {
                        if (n >= BoardManager.ballCnt) break;
                        if (BoardManager.balls[n].actionKey != c) break block37;
                        if (BoardManager.balls[n].type == 7) break block38;
                        if (BoardManager.balls[n].type != 9) break block37;
                    }
                    BoardManager.balls[n].activeBall();
                }
                ++n;
            }
            n = 0;
            while (true) {
                if (n >= BoardManager.doorCnt) continue block8;
                if (BoardManager.doors[n].actionKey == c) {
                    BoardManager.doors[n].activeDoor();
                }
                ++n;
            }
        }
        if (!uiKeyLeftPressed && !uiKeyRightPressed) {
            if (BoardManager.arenaAngleSpeed > 0) {
                BoardManager.arenaAngleSpeed = Math.max(0, BoardManager.arenaAngleSpeed - 1);
            } else if (BoardManager.arenaAngleSpeed < 0) {
                BoardManager.arenaAngleSpeed = Math.min(0, BoardManager.arenaAngleSpeed + 1);
            }
        } else if (uiKeyLeftPressed) {
            if (lastProcessTime - uiKeyPressedStart > (long)BoardManager.arenaSpeedUpTime) {
                uiKeyPressedStart = System.currentTimeMillis();
                BoardManager.arenaAngleSpeed = Math.max(BoardManager.arenaAngleSpeed - BoardManager.arenaAngleStep, -BoardManager.arenaAngleSpeedMax);
            }
        } else if (uiKeyRightPressed) {
            if (lastProcessTime - uiKeyPressedStart > (long)BoardManager.arenaSpeedUpTime) {
                uiKeyPressedStart = System.currentTimeMillis();
                BoardManager.arenaAngleSpeed = Math.min(BoardManager.arenaAngleSpeed + BoardManager.arenaAngleStep, BoardManager.arenaAngleSpeedMax);
            }
        }
        if ((BoardManager.arenaAngle += BoardManager.arenaAngleSpeed) > 0) {
            BoardManager.arenaAngle %= 360;
        } else if (BoardManager.arenaAngle < 0) {
            BoardManager.arenaAngle += 360;
        }
        if (!trophyUnlocked[21]) {
            trophyCounter[19] = trophyCounter[19] + Math.abs(BoardManager.arenaAngleSpeed);
            trophyCounter[20] = trophyCounter[20] + Math.abs(BoardManager.arenaAngleSpeed);
            trophyCounter[21] = trophyCounter[21] + Math.abs(BoardManager.arenaAngleSpeed);
        }
    }

    public void paint(Graphics graphics) {
        switch (state) {
            case 26: {
                this.gc.paintLandscape(graphics);
                break;
            }
            case 1: {
                this.gc.paintSplash(graphics);
                break;
            }
            case 2: {
                this.gc.paintSplashPieEye(graphics);
                break;
            }
            case 3: {
                this.gc.paintSoundQuestion(graphics);
                break;
            }
            case 4: {
                this.gc.paintLoading(graphics);
                break;
            }
            case 5: 
            case 10: {
                this.gc.paintMenu(graphics);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.gc.paintMenu(graphics);
                break;
            }
            case 7: 
            case 8: {
                state = 30;
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                this.ALoaning(graphics);
                break;
            }
            case 28: 
            case 31: {
                this.gc.paintAlbums(graphics);
                break;
            }
            case 6: {
                menuSelector.paint(graphics);
                break;
            }
            case 16: 
            case 20: {
                this.gc.paintGame(graphics);
                break;
            }
            case 9: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.gc.paintGame(graphics);
                break;
            }
            case 27: {
                this.gc.paintPause5(graphics);
            }
        }
        ++gameFrames;
        ++gameFramesAux;
        if (debug) {
            SSDebug.paintDebug(graphics);
        }
    }

    public static void garbageCollector() {
        System.gc();
    }

    private void cheat(char c) {
        godCounter = c == GOD_CODE.charAt(godCounter) ? ++godCounter : 0;
        if (godCounter == GOD_CODE.length()) {
            godMode = true;
            godCounter = 0;
        }
        if (godMode) {
            totalStars = 250;
            TIME_OVER = 61000L;
        }
    }

    public boolean checkTrophy(int n) {
        if (godMode) {
            return true;
        }
        switch (n) {
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (totalLevelsComplete < trophyCounterFinal[n]) break;
                return true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (totalStars < trophyCounterFinal[n]) break;
                return true;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (totalLevelsFiveStars < trophyCounterFinal[n]) break;
                return true;
            }
            default: {
                if (trophyCounter[n] < trophyCounterFinal[n]) break;
                return true;
            }
        }
        return false;
    }

    public int countLevelsComplete() {
        int n = 0;
        for (int i = 0; i < 50; ++i) {
            if (levelBestStars[i] <= 0) continue;
            ++n;
        }
        return n;
    }

    public int countLevelsWithFiveStars() {
        int n = 0;
        for (int i = 0; i < 50; ++i) {
            if (levelBestStars[i] != 5) continue;
            ++n;
        }
        return n;
    }

    public int countTrophiesPoints() {
        int n = 0;
        for (int i = 0; i < 25; ++i) {
            if (!trophyUnlocked[i]) continue;
            n += trophyPoints[i];
        }
        return n;
    }

    public void initObjects() {
        GameEngine.objectX[0] = 120;
        GameEngine.objectY[0] = 5;
        GameEngine.objectW[0] = GameCanvas.resImagesWidth[8];
        GameEngine.objectH[0] = GameCanvas.resImagesHeight[8];
        GameEngine.objectX[1] = 120;
        GameEngine.objectY[1] = GameCanvas.resFonts[0].getFontHeight();
        GameEngine.objectW[1] = 0;
        GameEngine.objectH[1] = 0;
        GameEngine.objectX[2] = 120;
        GameEngine.objectY[2] = -2 * GameCanvas.resFonts[0].getFontHeight();
        GameEngine.objectW[2] = 240;
        GameEngine.objectH[2] = 40;
        GameEngine.objectX[3] = 0;
        GameEngine.objectY[3] = 320;
        GameEngine.objectW[3] = 240;
        GameEngine.objectH[3] = 100;
        GameEngine.objectX[4] = -GameCanvas.resImagesWidth[11];
        GameEngine.objectY[4] = 150;
        GameEngine.objectW[4] = GameCanvas.resImagesWidth[11];
        GameEngine.objectH[4] = GameCanvas.resImagesHeight[11];
        GameEngine.objectX[5] = 120;
        GameEngine.objectY[5] = -60;
        GameEngine.objectW[5] = 60;
        GameEngine.objectH[5] = 56;
        GameEngine.objectX[6] = 240 + GameCanvas.resImagesWidth[12];
        GameEngine.objectY[6] = 150;
        GameEngine.objectW[6] = GameCanvas.resImagesWidth[12];
        GameEngine.objectH[6] = GameCanvas.resImagesHeight[12];
        GameEngine.objectX[7] = 0;
        GameEngine.objectY[7] = -60;
        GameEngine.objectW[7] = 240;
        GameEngine.objectH[7] = 60;
        GameEngine.objectHfinal[7] = 60;
        GameEngine.objectX[8] = 0;
        GameEngine.objectY[8] = 380;
        GameEngine.objectW[8] = 240;
        GameEngine.objectH[8] = 60;
        GameEngine.objectHfinal[8] = 60;
    }

    public void updateObjects(int n, int n2) {
        objectsOnScreen = false;
        objectsFixed = true;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < 9; ++i) {
            n3 = objectXfinal[i] - objectX[i];
            if (n3 != 0) {
                objectsFixed = false;
                n4 = Math.max(n, Math.abs(n3 / n2));
                if (Math.abs(n3) < n4) {
                    GameEngine.objectX[i] = objectXfinal[i];
                } else if (n3 > 0) {
                    int n5 = i;
                    objectX[n5] = objectX[n5] + n4;
                } else if (n3 < 0) {
                    int n6 = i;
                    objectX[n6] = objectX[n6] - n4;
                }
            }
            if ((n3 = objectYfinal[i] - objectY[i]) != 0) {
                objectsFixed = false;
                n4 = !(state != 15 && state != 17 && state != 18 || i != 7 && i != 8) ? 20 : Math.max(n, Math.abs(n3 / n2));
                if (Math.abs(n3) < n4) {
                    GameEngine.objectY[i] = objectYfinal[i];
                } else if (n3 > 0) {
                    int n7 = i;
                    objectY[n7] = objectY[n7] + n4;
                } else if (n3 < 0) {
                    int n8 = i;
                    objectY[n8] = objectY[n8] - n4;
                }
            }
            if ((n3 = objectWfinal[i] - objectW[i]) != 0) {
                objectsFixed = false;
                n4 = Math.max(n, (8 - n2) * n);
                if (Math.abs(n3) < n4) {
                    GameEngine.objectW[i] = objectWfinal[i];
                } else if (n3 > 0) {
                    int n9 = i;
                    objectW[n9] = objectW[n9] + n4;
                } else if (n3 < 0) {
                    int n10 = i;
                    objectW[n10] = objectW[n10] - n4;
                }
            }
            if ((n3 = objectHfinal[i] - objectH[i]) != 0) {
                objectsFixed = false;
                n4 = Math.max(n, (8 - n2) * n);
                if (Math.abs(n3) < n4) {
                    GameEngine.objectH[i] = objectHfinal[i];
                } else if (n3 > 0) {
                    int n11 = i;
                    objectH[n11] = objectH[n11] + n4;
                } else if (n3 < 0) {
                    int n12 = i;
                    objectH[n12] = objectH[n12] - n4;
                }
            }
            GameEngine.objectOnScreen[i] = false;
            if (objectW[i] == 0 && objectH[i] == 0 || (0 > objectX[i] || objectX[i] >= 240) && (0 > objectX[i] + objectW[i] || objectX[i] + objectW[i] >= 240) || (0 > objectY[i] || objectY[i] >= 320) && (0 > objectY[i] + objectH[i] || objectY[i] + objectH[i] >= 320)) continue;
            GameEngine.objectOnScreen[i] = true;
            objectsOnScreen = true;
        }
    }

    public void saveScores() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            StringBuffer stringBuffer = new StringBuffer();
            System.out.println("*** saveScores() ***");
            for (int i = 0; i < 50; ++i) {
                stringBuffer.append(levelBestTime[i]);
                stringBuffer.append("#");
                stringBuffer.append(levelBestScore[i]);
                stringBuffer.append("#");
                stringBuffer.append(levelBestStars[i]);
                stringBuffer.append("#");
            }
            dataOutputStream.writeUTF(stringBuffer.toString());
            SSFunctions.store("Scores", byteArrayOutputStream);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveTrophies() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            StringBuffer stringBuffer = new StringBuffer();
            System.out.println("*** saveTrophies() ***");
            for (int i = 0; i < 25; ++i) {
                stringBuffer.append(trophyCounter[i]);
                stringBuffer.append("#");
                stringBuffer.append(trophyUnlocked[i] ? 1 : 0);
                stringBuffer.append("#");
                stringBuffer.append(trophyVisible[i] ? 1 : 0);
                stringBuffer.append("#");
                stringBuffer.append(trophiesToShow[i] ? 1 : 0);
                stringBuffer.append("#");
            }
            dataOutputStream.writeUTF(stringBuffer.toString());
            SSFunctions.store("Trophies", byteArrayOutputStream);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveConfig() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            StringBuffer stringBuffer = new StringBuffer();
            System.out.println("*** saveConfig() ***");
            stringBuffer.append(levelSelected);
            stringBuffer.append("#");
            stringBuffer.append(configClockwise ? 1 : 0);
            stringBuffer.append("#");
            stringBuffer.append(configVibrate ? 1 : 0);
            stringBuffer.append("#");
            dataOutputStream.writeUTF(stringBuffer.toString());
            SSFunctions.store("Config", byteArrayOutputStream);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String parseRecord(String string) {
        if (string == null) {
            return "0";
        }
        String string2 = "";
        while (string.charAt(this.loadIndex) != '#') {
            string2 = string2 + string.charAt(this.loadIndex);
            ++this.loadIndex;
        }
        ++this.loadIndex;
        return string2;
    }

    public void loadScores() {
        try {
            DataInputStream dataInputStream = SSFunctions.load("Scores");
            if (dataInputStream == null) {
                this.saveScores();
                return;
            }
            String string = dataInputStream.readUTF();
            dataInputStream.close();
            this.loadIndex = 0;
            System.out.println("*** loadScores() ***");
            for (int i = 0; i < 50; ++i) {
                GameEngine.levelBestTime[i] = Long.parseLong(this.parseRecord(string));
                GameEngine.levelBestScore[i] = Integer.parseInt(this.parseRecord(string));
                GameEngine.levelBestStars[i] = Integer.parseInt(this.parseRecord(string));
            }
            totalScore = SSMath.sum(levelBestScore);
            totalStars = SSMath.sum(levelBestStars);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadTrophies() {
        try {
            DataInputStream dataInputStream = SSFunctions.load("Trophies");
            if (dataInputStream == null) {
                this.saveTrophies();
                return;
            }
            String string = dataInputStream.readUTF();
            dataInputStream.close();
            this.loadIndex = 0;
            System.out.println("*** loadTrophies() ***");
            for (int i = 0; i < 25; ++i) {
                GameEngine.trophyCounter[i] = Integer.parseInt(this.parseRecord(string));
                GameEngine.trophyUnlocked[i] = Integer.parseInt(this.parseRecord(string)) == 1;
                GameEngine.trophyVisible[i] = Integer.parseInt(this.parseRecord(string)) == 1;
                GameEngine.trophiesToShow[i] = Integer.parseInt(this.parseRecord(string)) == 1;
            }
            totalTrophiesUnlocked = SSMath.sum(trophyUnlocked);
            totalTrophyPoints = this.countTrophiesPoints();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadConfig() {
        try {
            DataInputStream dataInputStream = SSFunctions.load("Config");
            if (dataInputStream == null) {
                this.saveConfig();
                return;
            }
            String string = dataInputStream.readUTF();
            dataInputStream.close();
            this.loadIndex = 0;
            System.out.println("*** loadConfig() ***");
            levelSelected = Integer.parseInt(this.parseRecord(string));
            configClockwise = Integer.parseInt(this.parseRecord(string)) == 1;
            configVibrate = Integer.parseInt(this.parseRecord(string)) == 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showNotify() {
        this.gm.startApp();
    }

    public void hideNotify() {
        this.gm.pauseApp();
    }

    public void keyPressed(int n) {
        lastKeyCode = n;
        lastKeyPressedTime = System.currentTimeMillis();
        keyboard.keyPressed(n);
    }

    public void keyReleased(int n) {
        keyboard.keyReleased(n);
    }

    public void run() {
        running = true;
        while (running) {
            lastProcessTime = System.currentTimeMillis() - pauseTime;
            this.process();
            this.processSound();
            this.repaint();
            this.serviceRepaints();
            long l = System.currentTimeMillis() - pauseTime;
            if (l - lastProcessTime < 66L) {
                this.sleep(66 - (int)(l - lastProcessTime));
                continue;
            }
            this.sleep(5);
        }
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        lastKeyPressedTime = 0L;
        waitingTime = 0L;
        moreGamesURL = null;
        moreGameEnabled = false;
        configSound = false;
        configVibrate = false;
        configClockwise = true;
        loadingStep = 0;
        loadingTotal = 1;
        loadingTime = 0L;
        sqrtPerSecond = 0L;
        godCounter = 0;
        godMode = false;
        debug = false;
        editorMode = false;
        gameFrames = 0;
        gameFramesAux = 0;
        gameTimestamp = 0L;
        statePrevLandscape = 0;
        state = 0;
        toState = 0;
        keyboard = null;
        uiFontSmall = Font.getFont((int)0, (int)1, (int)8);
        uiFontSmallH = uiFontSmall.getHeight();
        uiFontMedium = Font.getFont((int)0, (int)1, (int)0);
        uiFontMediumH = uiFontMedium.getHeight();
        uiDeviceWidth = 0;
        uiDeviceHeight = 0;
        uiBackground = 0;
        uiBackgroundNext = 0;
        uiBackgroundOut = 0;
        uiBackgroundIn = 0;
        uiBackgroundStep = 0;
        uiBackgroundSwap = false;
        uiBackgroundSwapDir = 0;
        uiBackgroundSwapDirNext = 0;
        uiInfo = new StringBuffer(32);
        uiKeyUpPressed = false;
        uiKeyDownPressed = false;
        uiKeyRightPressed = false;
        uiKeyLeftPressed = false;
        uiKeyPressedStart = 0L;
        uiTimeToScrollText = 0L;
        uiTextLine = 0;
        objectX = new int[9];
        objectXfinal = new int[9];
        objectY = new int[9];
        objectYfinal = new int[9];
        objectW = new int[9];
        objectH = new int[9];
        objectWfinal = new int[9];
        objectHfinal = new int[9];
        objectOnScreen = new boolean[9];
        objectsOnScreen = true;
        objectsFixed = false;
        prepreviousState = -1;
        previousState = -1;
        TIME_OVER = 600000L;
        levelData = null;
        levelTitle = new String[50];
        levelDescription = new String[50];
        levelIcon = new int[50];
        levelBackground = new int[50];
        levelSelected = 0;
        levelTimeString = null;
        levelTime = 0L;
        levelScore = 0;
        levelStars = 0;
        levelStarsNeeded = new int[50];
        levelBestTime = new long[50];
        levelBestScore = new int[50];
        levelBestStars = new int[50];
        totalStars = 0;
        totalScore = 0;
        totalLevelsComplete = 0;
        totalLevelsFiveStars = 0;
        trophyTitle = new String[25];
        trophyDescription = new String[25];
        trophyVisible = new boolean[25];
        trophyUnlocked = new boolean[25];
        trophyPoints = new int[25];
        trophyCounterFinal = new int[25];
        trophyCounter = new int[25];
        trophiesToShow = new boolean[25];
        trophyToShow = 0;
        totalTrophiesUnlocked = 0;
        totalTrophyPoints = 0;
        AlbumPage = 1;
        UAlbum = 0;
        isAlbumPage = true;
        isLAlbum = false;
    }
}

