/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import com.lemonquest.circulate.BoardManager;
import com.lemonquest.circulate.FX;
import com.lemonquest.circulate.GameEngine;
import com.lemonquest.circulate.MenuSelector;
import com.lemonquest.circulate.MenuTrophies;
import com.lemonquest.utils.SSAnimation;
import com.lemonquest.utils.SSFont;
import com.lemonquest.utils.SSFunctions;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas {
    private GameEngine ge;
    public static final int TCIRCULATE = 0;
    public static final int TSOUND_QUESTION = 1;
    public static final int TYES = 2;
    public static final int TNO = 3;
    public static final int TLOADING = 4;
    public static final int TSELECT = 5;
    public static final int TBACK = 6;
    public static final int TPLAY = 7;
    public static final int TCONTINUE = 8;
    public static final int TRESTART = 9;
    public static final int TMENU = 10;
    public static final int TMENU_START_GAME = 11;
    public static final int TMENU_MOREGAMES = 12;
    public static final int TMENU_TROPHIES = 13;
    public static final int TMENU_OPTIONS = 14;
    public static final int TMENU_HELP = 15;
    public static final int TMENU_CREDITS = 16;
    public static final int TMENU_EXIT = 17;
    public static final int TMENU_ARE_YOU_SURE = 18;
    public static final int TMENU_RESET_GAME = 19;
    public static final int TMENU_RESET_GAME_INFO = 20;
    public static final int TMENU_SOUND = 21;
    public static final int TMENU_VIBRATION = 22;
    public static final int TMENU_CONTROL_A = 23;
    public static final int TMENU_CONTROL_B = 24;
    public static final int TON = 25;
    public static final int TOFF = 26;
    public static final int TVIEW = 27;
    public static final int TLEVEL = 28;
    public static final int TSTARS = 29;
    public static final int TPOINTS = 30;
    public static final int TLEVEL_COMPLETE = 31;
    public static final int TIMPOSSIBLE_COMPLETE = 32;
    public static final int THELP_TEXT = 33;
    public static final int TCREDITS_TEXT = 34;
    public static final int TLEVEL_SELECTION = 35;
    public static final int TYOU_HAVE_STARS = 36;
    public static final int TYOU_NEED_STARS = 37;
    public static final int TYOU_HAVE_ENOUGHT = 38;
    public static final int TTOTAL_SCORE = 39;
    public static final int TBEST_TIME = 40;
    public static final int THIGH_SCORE = 41;
    public static final int TTIME = 42;
    public static final int TSCORE = 43;
    public static final int TYOU_WON_STARS = 44;
    public static final int TPRESS_PLAY = 45;
    public static final int TOBJETIVE = 46;
    public static final int TCLEAR_BALLS = 47;
    public static final int TFILL_CONTAINERS = 48;
    public static final int TTROPHY_DETAILS = 49;
    public static final int TTROPHY_UNLOCKED = 50;
    public static final int TNOT_WON_YET = 51;
    public static final int TPLAYER_SCORE = 52;
    public static final int TTROPHIES_UNLOCKED = 53;
    public static final int TTROPHY_POINTS = 54;
    public static final int TGAME_STARS = 55;
    public static final int TTROPHIES_LIST = 56;
    public static final int THIDDEN_TROPHY = 57;
    public static final int TSLIDE_TO_OPEN = 58;
    public static final int TTIME_OUT = 59;
    public static final int TTROPHIES_DATA = 60;
    public static final int TLEVEL_DATA = 110;
    public static final int TPRESS5 = 210;
    public static final int TMAINMENU = 211;
    public static final int TOTAL_TEXTS = 212;
    public static String[] lang = null;
    public static final int RES_LQA = 0;
    public static final int RES_PNG = 1;
    public static final int RES_SSF = 2;
    public static final int RES_MID = 3;
    public static final int RES_WAV = 4;
    public static final int RES_LQA_SPLASH = 0;
    public static final int RES_LQA_ICONS_MENU = 1;
    public static final int RES_LQA_ICONS_LEVEL = 2;
    public static final int RES_LQA_SPARKS = 3;
    public static final int RES_LQA_STAR = 4;
    public static final int RES_LQA_BORDER = 5;
    public static final int RES_LQA_BALLS = 6;
    public static final int RES_LQA_EXPLODE = 7;
    public static final int RES_LQA_BOMB = 8;
    public static final int RES_LQA_HOLE_DOWN = 9;
    public static final int RES_LQA_HOLE_UP = 10;
    public static final int RES_LQA_FLASH = 11;
    public static final int RES_LQA_MONEY = 12;
    public static final int RES_LQA_MINI_NUMBER = 13;
    public static final int RES_LQA_MAX = 14;
    public static SSAnimation[] resAnimations = new SSAnimation[14];
    public static final int RES_PNG_BG = 0;
    public static final int RES_PNG_BG_METAL = 0;
    public static final int RES_PNG_BG_SKY = 1;
    public static final int RES_PNG_BG_GRASS = 2;
    public static final int RES_PNG_BG_SWEET = 3;
    public static final int RES_PNG_BG_ORANGE = 4;
    public static final int RES_PNG_BG_MENU = 5;
    public static final int RES_PNG_SPLASH = 6;
    public static final int RES_PNG_COVER = 7;
    public static final int RES_PNG_TITLE = 8;
    public static final int RES_PNG_FRAME_TILES = 9;
    public static final int RES_PNG_ALPHA = 10;
    public static final int RES_PNG_LEFT_ARROW = 11;
    public static final int RES_PNG_RIGHT_ARROW = 12;
    public static final int RES_PNG_BUBBLE_NORMAL = 13;
    public static final int RES_PNG_BUBBLE_BIG = 14;
    public static final int RES_PNG_STAR_EMPTY = 15;
    public static final int RES_PNG_MM_1 = 16;
    public static final int RES_PNG_MM_2 = 17;
    public static final int RES_PNG_MM_3 = 18;
    public static final int RES_PNG_MM_4 = 19;
    public static final int RES_PNG_MM_5 = 20;
    public static final int RES_PNG_MM_6 = 21;
    public static final int RES_PNG_MM_7 = 22;
    public static final int RES_PNG_MM_8 = 23;
    public static final int RES_PNG_MM_9 = 24;
    public static final int RES_PNG_MM_10 = 25;
    public static final int RES_PNG_MM_SU = 26;
    public static final int RES_PNG_MAX = 27;
    public static Image[] resImages = new Image[27];
    public static int[] resImagesWidth = new int[27];
    public static int[] resImagesHeight = new int[27];
    public static final int RES_SSF_BIG = 0;
    public static final int RES_SSF_SMALL = 1;
    public static final int RES_SSF_SMALL_ORANGE = 2;
    public static final int RES_SSF_BIG_RED = 3;
    public static final int RES_SSF_MAX = 4;
    public static SSFont[] resFonts = new SSFont[4];
    public static final int RES_WAV_BOMB = 0;
    public static final int RES_WAV_DOOR = 1;
    public static final int RES_WAV_COLOR = 2;
    public static final int RES_WAV_FIRE_ICE = 3;
    public static final int RES_WAV_BUBBLE = 4;
    public static final int RES_WAV_STOP = 5;
    public static final int RES_WAV_HOLE_RAY = 6;
    public static final int RES_WAV_MENU = 7;
    public static final int RES_WAV_MAX = 8;
    public static final int RES_MID_MENU = 0;
    public static final int RES_MID_WIN = 1;
    public static final int RES_MID_LOSE = 2;
    public static final int RES_MID_CHECK = 3;
    public static final int RES_MID_MAX = 4;
    public StringBuffer auxString = new StringBuffer();
    public long aniTime = 0L;
    public static int AlbumsPXY = 0;
    public int lgjs = 0;
    private static Image image = null;
    private static int[] dataARGB = null;
    private static int width = -1;
    private static int height = -1;
    private static int[] newDataARGB = null;
    private static int newWidth = -1;
    private static int newHeight = -1;
    private static int offset = 0;

    public GameCanvas(GameEngine gameEngine) {
        this.ge = gameEngine;
    }

    public void loadLanguage() {
        lang = null;
        GameEngine.garbageCollector();
        lang = SSFunctions.loadLangUnicode(SSFunctions.getResourceAsStream("/texts.dat"), 212);
        GameCanvas.lang[34] = SSFunctions.replace(lang[34], "%%SRL%%\n", "");
        GameCanvas.lang[34] = SSFunctions.replace(lang[34], "%%VERSION%%", this.ge.gm.getAppProperty("MIDlet-Version"));
        for (int i = 0; i < 25; ++i) {
            GameEngine.trophyTitle[i] = lang[60 + 2 * i];
            GameEngine.trophyDescription[i] = lang[60 + 2 * i + 1];
            GameEngine.trophyUnlocked[i] = false;
            GameEngine.trophyVisible[i] = true;
        }
        GameEngine.trophyPoints[0] = 100;
        GameEngine.trophyPoints[1] = 150;
        GameEngine.trophyPoints[2] = 200;
        GameEngine.trophyPoints[3] = 250;
        GameEngine.trophyPoints[4] = 500;
        GameEngine.trophyCounterFinal[0] = 10;
        GameEngine.trophyCounterFinal[1] = 20;
        GameEngine.trophyCounterFinal[2] = 30;
        GameEngine.trophyCounterFinal[3] = 40;
        GameEngine.trophyCounterFinal[4] = 50;
        GameEngine.trophyPoints[5] = 100;
        GameEngine.trophyPoints[6] = 200;
        GameEngine.trophyPoints[7] = 300;
        GameEngine.trophyPoints[8] = 400;
        GameEngine.trophyCounterFinal[5] = 50;
        GameEngine.trophyCounterFinal[6] = 100;
        GameEngine.trophyCounterFinal[7] = 150;
        GameEngine.trophyCounterFinal[8] = 200;
        GameEngine.trophyPoints[9] = 100;
        GameEngine.trophyPoints[10] = 150;
        GameEngine.trophyPoints[11] = 250;
        GameEngine.trophyPoints[12] = 500;
        GameEngine.trophyCounterFinal[9] = 10;
        GameEngine.trophyCounterFinal[10] = 20;
        GameEngine.trophyCounterFinal[11] = 30;
        GameEngine.trophyCounterFinal[12] = 40;
        GameEngine.trophyPoints[13] = 50;
        GameEngine.trophyPoints[14] = 100;
        GameEngine.trophyPoints[15] = 150;
        GameEngine.trophyPoints[16] = 200;
        GameEngine.trophyCounterFinal[13] = 50;
        GameEngine.trophyCounterFinal[14] = 100;
        GameEngine.trophyCounterFinal[15] = 200;
        GameEngine.trophyCounterFinal[16] = 500;
        GameEngine.trophyPoints[17] = 50;
        GameEngine.trophyPoints[18] = 50;
        GameEngine.trophyVisible[17] = false;
        GameEngine.trophyVisible[18] = false;
        GameEngine.trophyPoints[19] = 100;
        GameEngine.trophyPoints[20] = 200;
        GameEngine.trophyPoints[21] = 300;
        GameEngine.trophyCounterFinal[19] = 9000;
        GameEngine.trophyCounterFinal[20] = 18000;
        GameEngine.trophyCounterFinal[21] = 36000;
        GameEngine.trophyVisible[19] = false;
        GameEngine.trophyVisible[20] = false;
        GameEngine.trophyVisible[21] = false;
        GameEngine.trophyPoints[22] = 100;
        GameEngine.trophyPoints[23] = 200;
        GameEngine.trophyPoints[24] = 300;
        GameEngine.trophyCounterFinal[22] = 50;
        GameEngine.trophyCounterFinal[23] = 100;
        GameEngine.trophyCounterFinal[24] = 200;
        GameEngine.trophyVisible[22] = false;
        GameEngine.trophyVisible[23] = false;
        GameEngine.trophyVisible[24] = false;
    }

    public static void resLoad(int n, int n2) {
        System.out.println("   Load resource res=" + n + " type=" + n2);
        switch (n2) {
            case 0: {
                if (resAnimations[n] == null) {
                    GameCanvas.resAnimations[n] = new SSAnimation(SSFunctions.getResourceAsStream("/res" + n + ".lqa"));
                    break;
                }
                System.out.println("     RES_CACHE: LQA resource number " + n + " already loaded");
                break;
            }
            case 1: {
                String string = "gnp";
                if (resImages[n] == null) {
                    if (string.equals("gnp")) {
                        try {
                            GameCanvas.resImages[n] = Image.createImage((String)("/res" + n + ".gnp"));
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    GameCanvas.resImagesWidth[n] = resImages[n].getWidth();
                    GameCanvas.resImagesHeight[n] = resImages[n].getHeight();
                    break;
                }
                System.out.println("      RES_CACHE: PNG resource number " + n + " already loaded");
                break;
            }
            case 2: {
                if (resFonts[n] == null) {
                    GameCanvas.resFonts[n] = new SSFont(SSFunctions.getResourceAsStream("/res" + n + ".ssf"), null);
                    break;
                }
                System.out.println("      RES_CACHE: SSF resource number " + n + " already loaded");
            }
        }
    }

    public static void resUnload(int n, int n2) {
        switch (n2) {
            case 0: {
                if (resAnimations[n] == null) {
                    System.out.println("      LQA resource number " + n + " is NOT in memory");
                    break;
                }
                GameCanvas.resAnimations[n] = null;
                System.out.println("      LQA resource number " + n + " unloaded");
                break;
            }
            case 1: {
                if (resImages[n] == null) {
                    System.out.println("      PNG resource number " + n + " is NOT in memory");
                    break;
                }
                GameCanvas.resImages[n] = null;
                System.out.println("      PNG resource number " + n + " unloaded");
                break;
            }
            case 2: {
                if (resFonts[n] == null) {
                    System.out.println("      SSF resource number " + n + " is NOT in memory");
                    break;
                }
                GameCanvas.resFonts[n] = null;
                System.out.println("      SSF resource number " + n + " unloaded");
            }
        }
    }

    public void paintMenu(Graphics graphics) {
        graphics.setClip(0, 0, GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight);
        graphics.setColor(0);
        graphics.fillRect(0, 0, GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight);
        this.paintBackground(graphics);
        GameEngine.menu.paint(graphics);
    }

    public void paintMenuTrophies(Graphics graphics) {
        this.paintMenu(graphics);
        MenuTrophies.paint(graphics);
    }

    public void paintAlbums(Graphics graphics) {
        GameEngine.menuTrophies.Albums(graphics);
    }

    public void paintGame(Graphics graphics) {
        GameEngine.board.paint(graphics);
    }

    public void paintPause5(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 320);
        if (resFonts[1] != null && lang[210] != null) {
            resFonts[1].drawString(graphics, lang[210].toCharArray(), 120, 160, 3);
        } else {
            String string = "";
            String string2 = "Press 5 to continue";
            graphics.setColor(0xFFFFFF);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            graphics.drawString(string2, 120, 106, 17);
            if (!string.equals("")) {
                graphics.drawString(string, 120, 106 + graphics.getFont().getHeight(), 17);
            }
        }
    }

    public void paintSplash(Graphics graphics) {
        if (resAnimations[0] != null) {
            graphics.setClip(0, 0, 240, 320);
            graphics.setColor(0);
            graphics.fillRect(0, 0, 240, 320);
            resAnimations[0].drawAnimation(graphics, 0, System.currentTimeMillis() - GameEngine.waitingTime, 15, 160, false);
        }
    }

    public void paintSplashPieEye(Graphics graphics) {
        if (resImages[6] != null) {
            graphics.setClip(0, 0, 240, 320);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, 240, 320);
            GameCanvas.paintImage(graphics, 6, 120, 160, 3);
        }
    }

    public void paintSoundQuestion(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 320);
        resFonts[0].drawString(graphics, lang[1].toCharArray(), 120, 160, 3);
        resFonts[0].drawString(graphics, lang[2].toCharArray(), 2, 318, 68);
        resFonts[0].drawString(graphics, lang[3].toCharArray(), 238, 318, 72);
    }

    public void paintLoading(Graphics graphics) {
        if (resImages[7] != null) {
            graphics.setClip(0, 0, GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight);
            graphics.setColor(0);
            graphics.fillRect(0, 0, GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight);
            GameCanvas.paintImage(graphics, 7, 0, 0, 20);
        }
        graphics.setColor(0);
        graphics.fillRect(8, 308, 223, 6);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(8, 308, 223, 6);
        graphics.setColor(0xFF0000);
        graphics.fillRect(10, 310, GameEngine.loadingStep * 220 / GameEngine.loadingTotal, 3);
    }

    public void paintObjects(Graphics graphics) {
        switch (GameEngine.state) {
            case 6: {
                resFonts[0].drawString(graphics, lang[35].toCharArray(), GameEngine.objectX[1], GameEngine.objectY[1], 17);
                resAnimations[2].drawAnimation(graphics, GameEngine.levelIcon[GameEngine.levelSelected], System.currentTimeMillis() - MenuSelector.timeIconAnimation, GameEngine.objectX[4], GameEngine.objectY[4], true);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[2], 240, 40);
                this.auxString.setLength(0);
                this.auxString.append(lang[28]);
                this.auxString.append(" ");
                this.auxString.append(GameEngine.levelSelected + 1);
                this.auxString.append("/");
                this.auxString.append(50);
                resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[2], GameEngine.objectY[2] + 5, 17);
                resFonts[0].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), GameEngine.objectX[2], GameEngine.objectY[2] + 5 + resFonts[0].getFontHeight() + 8, 17);
                GameCanvas.paintAlpha(graphics, GameEngine.objectX[6], GameEngine.objectY[6], 240, 75);
                this.auxString.setLength(0);
                this.auxString.append(SSFunctions.replace(lang[36], "%%STARS%%", Integer.toString(GameEngine.totalStars)));
                resFonts[2].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[6] + 120, GameEngine.objectY[6] + 5, 17);
                this.auxString.setLength(0);
                this.auxString.append(lang[39]);
                this.auxString.append(": ");
                this.auxString.append(GameEngine.totalScore);
                resFonts[2].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[6] + 120, GameEngine.objectY[6] + (resFonts[0].getFontHeight() + 7), 17);
                if (GameEngine.totalStars < GameEngine.levelStarsNeeded[GameEngine.levelSelected]) {
                    this.auxString.setLength(0);
                    this.auxString.append(SSFunctions.replace(lang[37], "%%STARS%%", Integer.toString(GameEngine.levelStarsNeeded[GameEngine.levelSelected])));
                    resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), 5, GameEngine.objectY[6] + 3 * (resFonts[0].getFontHeight() + 4), 230, 36, 17);
                } else if (GameEngine.levelBestStars[GameEngine.levelSelected] == 0) {
                    resFonts[0].drawString(graphics, lang[38].toCharArray(), 5, GameEngine.objectY[6] + 3 * (resFonts[0].getFontHeight() + 4), 230, 36, 17);
                } else {
                    this.auxString.setLength(0);
                    this.auxString.append(lang[40]);
                    this.auxString.append(": ");
                    this.auxString.append(GameEngine.clock.getTimeString(4, GameEngine.levelBestTime[GameEngine.levelSelected]));
                    resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[6] + 120, GameEngine.objectY[6] + 3 * (resFonts[0].getFontHeight() + 5), 17);
                    this.auxString.setLength(0);
                    this.auxString.append(lang[41]);
                    this.auxString.append(": ");
                    this.auxString.append(GameEngine.levelBestScore[GameEngine.levelSelected]);
                    resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[6] + 120, GameEngine.objectY[6] + 4 * (resFonts[0].getFontHeight() + 5), 17);
                    this.auxString.setLength(0);
                    this.auxString.append(GameEngine.levelBestStars[GameEngine.levelSelected]);
                    this.auxString.append(" ");
                    this.auxString.append(lang[29]);
                    resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[6] + 15 + 20, GameEngine.objectY[6] + 3 * (resFonts[0].getFontHeight() + 5), 17);
                    resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), GameEngine.objectX[6] + 240 - 55 + 20, GameEngine.objectY[6] + 3 * (resFonts[0].getFontHeight() + 5), 17);
                    GameCanvas.paintStars(graphics, GameEngine.levelBestStars[GameEngine.levelSelected], GameEngine.objectX[6] + 40, GameEngine.objectY[6] + 4 + 4 * (resFonts[0].getFontHeight() + 5));
                    GameCanvas.paintStars(graphics, GameEngine.levelBestStars[GameEngine.levelSelected], GameEngine.objectX[6] + 240 - 31, GameEngine.objectY[6] + 4 + 4 * (resFonts[0].getFontHeight() + 5));
                }
                graphics.setColor(0xFFFFFF);
                graphics.setClip(0, 0, GameEngine.uiDeviceWidth, GameEngine.uiDeviceHeight);
                graphics.setStrokeStyle(0);
                graphics.drawLine(GameEngine.objectX[2] - 60, GameEngine.objectY[2] + 5 + resFonts[0].getFontHeight() + 3, GameEngine.objectX[2] + 60, GameEngine.objectY[2] + 5 + resFonts[0].getFontHeight() + 3);
                graphics.setStrokeStyle(1);
                graphics.drawLine(GameEngine.objectX[6] + 120 - 100, GameEngine.objectY[6] + 2 * (resFonts[0].getFontHeight() + 5) + 3, GameEngine.objectX[6] + 120 + 100, GameEngine.objectY[6] + 2 * (resFonts[0].getFontHeight() + 5) + 3);
                GameCanvas.paintImage(graphics, 11, GameEngine.objectX[3], GameEngine.objectY[3], 3);
                GameCanvas.paintImage(graphics, 12, GameEngine.objectX[5], GameEngine.objectY[5], 3);
                FX.paintParticles(graphics, resAnimations[3]);
                GameCanvas.paintImage(graphics, 8, GameEngine.objectX[0], GameEngine.objectY[0], 17);
                break;
            }
            case 15: {
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[7], 240, GameEngine.objectH[7]);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[8], 240, GameEngine.objectH[8]);
                if (GameEngine.objectY[7] == GameEngine.objectYfinal[7]) {
                    if (System.currentTimeMillis() - this.aniTime < 400L) {
                        resAnimations[11].drawAnimation(graphics, 0, System.currentTimeMillis() - this.aniTime, 120, 160, false);
                    }
                    this.auxString.setLength(0);
                    this.auxString.append(lang[28]);
                    this.auxString.append(" ");
                    this.auxString.append(GameEngine.levelSelected + 1);
                    resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), 120, GameEngine.objectY[7] + 5, 17);
                    resFonts[0].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), 120, GameEngine.objectY[7] + 20, 17);
                    if (GameEngine.gameFramesAux > 10) {
                        resFonts[1].drawString(graphics, GameEngine.levelDescription[GameEngine.levelSelected].toCharArray(), 10, GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 20, 220, 65, 17);
                    }
                    if (GameEngine.gameFramesAux > 15 && GameEngine.gameFramesAux % 14 < 7) {
                        resFonts[2].drawString(graphics, lang[45].toCharArray(), 120, GameEngine.objectY[7] + 112, 65);
                    }
                    if (GameEngine.gameFramesAux > 5) {
                        graphics.setClip(0, GameEngine.objectY[7], GameEngine.uiDeviceWidth, 120);
                        graphics.setColor(0xFFFFFF);
                        graphics.setStrokeStyle(0);
                        graphics.drawLine(120 - Math.min(12 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3, 120 + Math.min(12 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3);
                        graphics.setStrokeStyle(1);
                        graphics.drawLine(120 - Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15, 120 + Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15);
                        graphics.drawLine(120 - Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 95, 120 + Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 95);
                    }
                } else {
                    GameEngine.gameFramesAux = 0;
                    this.aniTime = System.currentTimeMillis();
                }
                GameCanvas.paintImage(graphics, 11, GameEngine.objectX[4], GameEngine.objectY[4], 3);
                GameCanvas.paintImage(graphics, 12, GameEngine.objectX[6], GameEngine.objectY[6], 3);
                break;
            }
            case 16: {
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[7], 240, GameEngine.objectH[7]);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[8], 240, GameEngine.objectH[8]);
                this.auxString.setLength(0);
                this.auxString.append(lang[28]);
                this.auxString.append(" ");
                this.auxString.append(GameEngine.levelSelected + 1);
                resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), 120, GameEngine.objectY[7] + 5, 17);
                resFonts[0].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), 120, GameEngine.objectY[7] + 20, 17);
                resFonts[1].drawString(graphics, GameEngine.levelDescription[GameEngine.levelSelected].toCharArray(), 10, GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 20, 220, 65, 17);
                resFonts[2].drawString(graphics, lang[45].toCharArray(), 120, GameEngine.objectY[7] + 112, 65);
                graphics.setClip(0, GameEngine.objectY[7], GameEngine.uiDeviceWidth, 120);
                graphics.setColor(0xFFFFFF);
                graphics.setStrokeStyle(0);
                graphics.drawLine(120 - Math.min(12 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3, 120 + Math.min(12 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3);
                graphics.setStrokeStyle(1);
                graphics.drawLine(120 - Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15, 120 + Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15);
                graphics.drawLine(120 - Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 95, 120 + Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 95);
                GameCanvas.paintImage(graphics, 11, GameEngine.objectX[4], GameEngine.objectY[4], 3);
                GameCanvas.paintImage(graphics, 12, GameEngine.objectX[6], GameEngine.objectY[6], 3);
                break;
            }
            case 17: {
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[7], 240, GameEngine.objectH[7]);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[8], 240, GameEngine.objectH[8]);
                if (GameEngine.objectY[7] == GameEngine.objectYfinal[7]) {
                    if (GameEngine.gameFramesAux < 10) {
                        graphics.setClip(0, GameEngine.objectY[8] - (20 - 3 * Math.min(GameEngine.gameFramesAux, 10)) / 2, GameEngine.uiDeviceWidth, 20 - 3 * Math.min(GameEngine.gameFramesAux, 10));
                        graphics.setColor(0xFFFFFF);
                        graphics.setStrokeStyle(0);
                        graphics.fillRect(0, GameEngine.objectY[8] - (20 - 3 * Math.min(GameEngine.gameFramesAux, 10)) / 2, GameEngine.uiDeviceWidth, 20 - 3 * Math.min(GameEngine.gameFramesAux, 10));
                    }
                    this.auxString.setLength(0);
                    this.auxString.append(SSFunctions.replace(lang[31], "%%NUMBER%%", Integer.toString(GameEngine.levelSelected + 1)));
                    resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), 120, GameEngine.objectY[7] + 5, 17);
                    resFonts[0].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), 120, GameEngine.objectY[7] + 20, 17);
                    if (GameEngine.gameFramesAux > 10) {
                        this.auxString.setLength(0);
                        this.auxString.append(lang[42]);
                        this.auxString.append(": ");
                        this.auxString.append(GameEngine.levelTimeString);
                        resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), 120, GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 22, 17);
                    }
                    if (GameEngine.gameFramesAux > 15) {
                        this.auxString.setLength(0);
                        this.auxString.append(lang[43]);
                        this.auxString.append(": ");
                        this.auxString.append(GameEngine.levelScore);
                        resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), 120, GameEngine.objectY[7] + 5 + 3 * resFonts[0].getFontHeight() + 24, 17);
                    }
                    if (GameEngine.gameFramesAux > 20) {
                        this.auxString.setLength(0);
                        this.auxString.append(SSFunctions.replace(lang[44], "%%STARS%%", Integer.toString(GameEngine.levelStars)));
                        resFonts[1].drawString(graphics, this.auxString.toString().toCharArray(), 120, GameEngine.objectY[7] + 5 + 4 * resFonts[0].getFontHeight() + 26, 17);
                    }
                    if (GameEngine.gameFramesAux > 25) {
                        GameCanvas.paintStars(graphics, 5, 5 - GameEngine.levelStars, 125, GameEngine.objectY[7] + 5 + 4 * resFonts[0].getFontHeight() + 45);
                    }
                    if (GameEngine.gameFramesAux > 5) {
                        graphics.setClip(0, GameEngine.objectY[7], GameEngine.uiDeviceWidth, 120);
                        graphics.setColor(0xFFFFFF);
                        graphics.setStrokeStyle(0);
                        graphics.drawLine(120 - Math.min(10 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3, 120 + Math.min(10 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3);
                        graphics.setStrokeStyle(1);
                        graphics.drawLine(120 - Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15, 120 + Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15);
                        graphics.drawLine(120 - Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 103, 120 + Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 103);
                    }
                } else {
                    GameEngine.gameFramesAux = 0;
                }
                GameCanvas.paintImage(graphics, 11, GameEngine.objectX[4], GameEngine.objectY[4], 3);
                GameCanvas.paintImage(graphics, 12, GameEngine.objectX[6], GameEngine.objectY[6], 3);
                break;
            }
            case 18: 
            case 19: {
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[7], 240, GameEngine.objectH[7]);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[8], 240, GameEngine.objectH[8]);
                if (GameEngine.objectY[7] == GameEngine.objectYfinal[7]) {
                    if (GameEngine.gameFramesAux < 10) {
                        graphics.setClip(0, GameEngine.objectY[8] - (20 - 3 * Math.min(GameEngine.gameFramesAux, 10)) / 2, GameEngine.uiDeviceWidth, 20 - 3 * Math.min(GameEngine.gameFramesAux, 10));
                        graphics.setColor(0xFFFFFF);
                        graphics.setStrokeStyle(0);
                        graphics.fillRect(0, GameEngine.objectY[8] - (20 - 3 * Math.min(GameEngine.gameFramesAux, 10)) / 2, GameEngine.uiDeviceWidth, 20 - 3 * Math.min(GameEngine.gameFramesAux, 10));
                    }
                    this.auxString.setLength(0);
                    this.auxString.append(lang[28]);
                    this.auxString.append(" ");
                    this.auxString.append(GameEngine.levelSelected + 1);
                    this.auxString.append("/");
                    this.auxString.append(50);
                    resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), 120, GameEngine.objectY[7] + 5, 17);
                    resFonts[0].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), 120, GameEngine.objectY[7] + 20, 17);
                    if (GameEngine.gameFramesAux > 10) {
                        if (GameEngine.state == 18) {
                            resFonts[1].drawString(graphics, lang[32].toCharArray(), 120, 170, 3);
                        } else {
                            resFonts[3].drawString(graphics, lang[59].toCharArray(), 120, 170, 3);
                        }
                    }
                    if (GameEngine.gameFramesAux > 5) {
                        graphics.setClip(0, GameEngine.objectY[7], GameEngine.uiDeviceWidth, 120);
                        graphics.setColor(0xFFFFFF);
                        graphics.setStrokeStyle(0);
                        graphics.drawLine(120 - Math.min(10 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3, 120 + Math.min(10 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3);
                        graphics.setStrokeStyle(1);
                        graphics.drawLine(120 - Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15, 120 + Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15);
                        graphics.drawLine(120 - Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 103, 120 + Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 103);
                    }
                } else {
                    GameEngine.gameFramesAux = 0;
                }
                GameCanvas.paintImage(graphics, 11, GameEngine.objectX[4], GameEngine.objectY[4], 3);
                GameCanvas.paintImage(graphics, 12, GameEngine.objectX[6], GameEngine.objectY[6], 3);
                break;
            }
            case 22: {
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[7], 240, GameEngine.objectH[7]);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[8], 240, GameEngine.objectH[8]);
                this.auxString.setLength(0);
                this.auxString.append(lang[28]);
                this.auxString.append(" ");
                this.auxString.append(GameEngine.levelSelected + 1);
                resFonts[3].drawString(graphics, this.auxString.toString().toCharArray(), 120, GameEngine.objectY[7] + 5, 17);
                resFonts[0].drawString(graphics, GameEngine.levelTitle[GameEngine.levelSelected].toCharArray(), 120, GameEngine.objectY[7] + 20, 17);
                resFonts[1].drawString(graphics, GameEngine.levelDescription[GameEngine.levelSelected].toCharArray(), 10, GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 20, 220, 65, 17);
                if (GameEngine.gameFramesAux > 15 && GameEngine.gameFramesAux % 14 < 7) {
                    resFonts[2].drawString(graphics, lang[8].toCharArray(), 120, GameEngine.objectY[7] + 112, 65);
                }
                graphics.setClip(0, GameEngine.objectY[7], GameEngine.uiDeviceWidth, 120);
                graphics.setColor(0xFFFFFF);
                graphics.setStrokeStyle(0);
                graphics.drawLine(120 - Math.min(12 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3, 120 + Math.min(12 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3);
                graphics.setStrokeStyle(1);
                graphics.drawLine(120 - Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15, 120 + Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15);
                graphics.drawLine(120 - Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 95, 120 + Math.min(15 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 95);
                break;
            }
            case 9: {
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[7], 240, GameEngine.objectH[7]);
                GameCanvas.paintAlpha(graphics, 0, GameEngine.objectY[8], 240, GameEngine.objectH[8]);
                resFonts[3].drawString(graphics, lang[50].toString().toCharArray(), 120, GameEngine.objectY[7] + 5, 17);
                resFonts[0].drawString(graphics, GameEngine.trophyTitle[GameEngine.trophyToShow].toCharArray(), 120, GameEngine.objectY[7] + 23, 17);
                resFonts[1].drawString(graphics, GameEngine.trophyDescription[GameEngine.trophyToShow].toString().toCharArray(), 2, GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 22, 236, 30, 17);
                resAnimations[12].drawAnimation(graphics, 1, System.currentTimeMillis(), 120, GameEngine.objectY[7] + 5 + 4 * resFonts[0].getFontHeight() + 37, true);
                this.auxString.setLength(0);
                this.auxString.append(GameEngine.trophyPoints[GameEngine.trophyToShow]);
                this.auxString.append(" ");
                this.auxString.append(lang[30]);
                resFonts[0].drawString(graphics, this.auxString.toString().toCharArray(), 120, GameEngine.objectY[7] + 5 + 4 * resFonts[0].getFontHeight() + 50, 17);
                graphics.setClip(0, GameEngine.objectY[7], GameEngine.uiDeviceWidth, 120);
                graphics.setColor(0xFFFFFF);
                graphics.setStrokeStyle(0);
                graphics.drawLine(120 - Math.min(10 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3, 120 + Math.min(10 * (GameEngine.gameFramesAux - 5), 60), GameEngine.objectY[7] + 5 + resFonts[0].getFontHeight() + 3);
                graphics.setStrokeStyle(1);
                graphics.drawLine(120 - Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15, 120 + Math.min(10 * (GameEngine.gameFramesAux - 5), 90), GameEngine.objectY[7] + 5 + 2 * resFonts[0].getFontHeight() + 15);
            }
        }
    }

    public void paintScoreBoard(Graphics graphics) {
        resFonts[0].drawString(graphics, lang[46].toCharArray(), 5, 5, 20);
        if (BoardManager.arenaVictory == 0) {
            resFonts[2].drawString(graphics, lang[47].toCharArray(), 5, 18, 20);
        } else {
            resFonts[2].drawString(graphics, lang[48].toCharArray(), 5, 18, 20);
        }
        resFonts[0].drawString(graphics, lang[42].toCharArray(), 235, 5, 24);
        resFonts[2].drawString(graphics, GameEngine.clock.getTimeString(4).toCharArray(), 235, 18, 24);
        if (GameEngine.clock.getMilliseconds() < 46000L) {
            GameCanvas.paintStars(graphics, 5, 215, 36);
        } else if (GameEngine.clock.getMilliseconds() < 56000L) {
            GameCanvas.paintStars(graphics, 5, 1, 215, 36);
        } else if (GameEngine.clock.getMilliseconds() < 66000L) {
            GameCanvas.paintStars(graphics, 5, 2, 215, 36);
        } else if (GameEngine.clock.getMilliseconds() < 91000L) {
            GameCanvas.paintStars(graphics, 5, 3, 215, 36);
        } else {
            GameCanvas.paintStars(graphics, 5, 4, 215, 36);
        }
    }

    public void paintBackgroundOld(Graphics graphics) {
        if (GameEngine.uiBackgroundSwap) {
            int n = 4;
            GameCanvas.paintImage(graphics, GameEngine.uiBackgroundOut, 0, 0, 20);
            switch (GameEngine.uiBackgroundSwapDir) {
                case -1: {
                    graphics.setClip(0, 0, GameEngine.uiBackgroundStep * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(GameEngine.uiBackgroundStep * n, 0, 4 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip((GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip((GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip((GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    if (GameEngine.uiBackgroundStep > 20 + 240 / n) {
                        GameEngine.uiBackgroundSwap = false;
                        GameEngine.uiBackground = GameEngine.uiBackgroundIn;
                        break;
                    }
                    GameEngine.uiBackgroundStep += 4;
                    break;
                }
                case 0: {
                    graphics.setClip(0, 0, GameEngine.uiBackgroundStep * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(Math.max(0, 240 - GameEngine.uiBackgroundStep * n), 0, 240, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(GameEngine.uiBackgroundStep * n, 0, 4 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip((GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip((GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip((GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(240 - (GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(240 - (GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(240 - (GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(240 - GameEngine.uiBackgroundStep * n, 0, 4 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    if (GameEngine.uiBackgroundStep > 20 + 240 / (2 * n)) {
                        GameEngine.uiBackgroundSwap = false;
                        GameEngine.uiBackground = GameEngine.uiBackgroundIn;
                        break;
                    }
                    GameEngine.uiBackgroundStep += 3;
                    break;
                }
                case 1: {
                    graphics.setClip(Math.max(0, 240 - GameEngine.uiBackgroundStep * n), 0, 240, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(240 - (GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(240 - (GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(240 - (GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    graphics.setClip(240 - GameEngine.uiBackgroundStep * n, 0, 4 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 0, 0, 20);
                    if (GameEngine.uiBackgroundStep > 20 + 240 / n) {
                        GameEngine.uiBackgroundSwap = false;
                        GameEngine.uiBackground = GameEngine.uiBackgroundIn;
                        break;
                    }
                    GameEngine.uiBackgroundStep += 4;
                }
            }
        } else {
            GameCanvas.paintImage(graphics, GameEngine.uiBackground, 0, 0, 20);
            if (System.currentTimeMillis() - GameEngine.lastKeyPressedTime > 200L) {
                if (GameEngine.uiBackground != GameEngine.uiBackgroundNext) {
                    GameEngine.uiBackgroundSwap = true;
                    GameEngine.uiBackgroundStep = -20;
                    GameEngine.uiBackgroundIn = GameEngine.uiBackgroundNext;
                    GameEngine.uiBackgroundOut = GameEngine.uiBackground;
                    GameEngine.uiBackgroundSwapDir = GameEngine.uiBackgroundSwapDirNext;
                }
            }
        }
    }

    public void paintBackground(Graphics graphics) {
        if (GameEngine.uiBackgroundSwap) {
            int n = 4;
            GameCanvas.paintImage(graphics, GameEngine.uiBackgroundOut, 120, 160, 3);
            switch (GameEngine.uiBackgroundSwapDir) {
                case -1: {
                    graphics.setClip(0, 0, GameEngine.uiBackgroundStep * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip(GameEngine.uiBackgroundStep * n, 0, 4 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip((GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip((GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip((GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    if (GameEngine.uiBackgroundStep > 20 + 240 / n) {
                        GameEngine.uiBackgroundSwap = false;
                        GameEngine.uiBackground = GameEngine.uiBackgroundIn;
                        break;
                    }
                    GameEngine.uiBackgroundStep += 4;
                    break;
                }
                case 0: {
                    graphics.setClip(0, 0, GameEngine.uiBackgroundStep * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip(Math.max(0, 240 - GameEngine.uiBackgroundStep * n), 0, 240, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip(GameEngine.uiBackgroundStep * n, 0, 4 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip((GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip((GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip((GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip(240 - (GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip(240 - (GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip(240 - (GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip(240 - GameEngine.uiBackgroundStep * n, 0, 4 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    if (GameEngine.uiBackgroundStep > 20 + 240 / (2 * n)) {
                        GameEngine.uiBackgroundSwap = false;
                        GameEngine.uiBackground = GameEngine.uiBackgroundIn;
                        break;
                    }
                    GameEngine.uiBackgroundStep += 3;
                    break;
                }
                case 1: {
                    graphics.setClip(Math.max(0, 240 - GameEngine.uiBackgroundStep * n), 0, 240, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip(240 - (GameEngine.uiBackgroundStep + 19) * n, 0, 1 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip(240 - (GameEngine.uiBackgroundStep + 13) * n, 0, 2 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip(240 - (GameEngine.uiBackgroundStep + 7) * n, 0, 3 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    graphics.setClip(240 - GameEngine.uiBackgroundStep * n, 0, 4 * n, 320);
                    graphics.drawImage(resImages[GameEngine.uiBackgroundIn], 120, 160, 3);
                    if (GameEngine.uiBackgroundStep > 20 + 240 / n) {
                        GameEngine.uiBackgroundSwap = false;
                        GameEngine.uiBackground = GameEngine.uiBackgroundIn;
                        break;
                    }
                    GameEngine.uiBackgroundStep += 4;
                }
            }
        } else {
            GameCanvas.paintImage(graphics, GameEngine.uiBackground, 120, 160, 3);
            if (System.currentTimeMillis() - GameEngine.lastKeyPressedTime > 200L) {
                if (GameEngine.uiBackground != GameEngine.uiBackgroundNext) {
                    GameEngine.uiBackgroundSwap = true;
                    GameEngine.uiBackgroundStep = -20;
                    GameEngine.uiBackgroundIn = GameEngine.uiBackgroundNext;
                    GameEngine.uiBackgroundOut = GameEngine.uiBackground;
                    GameEngine.uiBackgroundSwapDir = GameEngine.uiBackgroundSwapDirNext;
                }
            }
        }
    }

    public static void paintAlpha(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = 0; i <= n3 / 20; ++i) {
            for (int j = 0; j <= n4 / 20; ++j) {
                graphics.setClip(n + i * 20, n2 + j * 20, Math.min(n3 - i * 20, 20), Math.min(n4 - j * 20, 20));
                graphics.drawImage(resImages[10], n + i * 20, n2 + j * 20, 20);
            }
        }
    }

    public static void drawAlbums(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        graphics.fillRect(0, 0, 240, 320);
        if (GameEngine.state == 28) {
            if (GameEngine.isLAlbum) {
                switch (GameEngine.AlbumPage) {
                    case 1: {
                        graphics.drawImage(resImages[16], (240 - resImagesWidth[16]) / 2, (320 - resImagesHeight[16]) / 2 + AlbumsPXY, 20);
                        break;
                    }
                    case 2: {
                        graphics.drawImage(resImages[17], (240 - resImagesWidth[17]) / 2, (320 - resImagesHeight[17]) / 2 + AlbumsPXY, 20);
                        break;
                    }
                    case 3: {
                        graphics.drawImage(resImages[18], (240 - resImagesWidth[18]) / 2, (320 - resImagesHeight[18]) / 2 + AlbumsPXY, 20);
                        break;
                    }
                    case 4: {
                        graphics.drawImage(resImages[19], (240 - resImagesWidth[19]) / 2, (320 - resImagesHeight[19]) / 2 + AlbumsPXY, 20);
                        break;
                    }
                    case 5: {
                        graphics.drawImage(resImages[20], (240 - resImagesWidth[20]) / 2, (320 - resImagesHeight[20]) / 2 + AlbumsPXY, 20);
                        break;
                    }
                    case 6: {
                        graphics.drawImage(resImages[21], (240 - resImagesWidth[21]) / 2, (320 - resImagesHeight[21]) / 2 + AlbumsPXY, 20);
                        break;
                    }
                    case 7: {
                        graphics.drawImage(resImages[22], (240 - resImagesWidth[22]) / 2, (320 - resImagesHeight[22]) / 2 + AlbumsPXY, 20);
                        break;
                    }
                    case 8: {
                        graphics.drawImage(resImages[23], (240 - resImagesWidth[23]) / 2, (320 - resImagesHeight[23]) / 2 + AlbumsPXY, 20);
                        break;
                    }
                    case 9: {
                        graphics.drawImage(resImages[24], (240 - resImagesWidth[24]) / 2, (320 - resImagesHeight[24]) / 2 + AlbumsPXY, 20);
                        break;
                    }
                    case 10: {
                        graphics.drawImage(resImages[25], (240 - resImagesWidth[25]) / 2, (320 - resImagesHeight[25]) / 2 + AlbumsPXY, 20);
                    }
                }
            } else {
                graphics.drawImage(resImages[26], (240 - resImagesWidth[26]) / 2, (320 - resImagesHeight[26]) / 2 + AlbumsPXY, 20);
            }
            graphics.setColor(16647098);
            graphics.fillTriangle(5, 130, 10, 120, 10, 140);
            graphics.fillTriangle(235, 130, 230, 120, 230, 140);
            String string = GameEngine.AlbumPage + "/10";
            resFonts[3].drawString(graphics, string.toCharArray(), 115, 310, 17);
        } else {
            switch (GameEngine.levelSelected + 1) {
                case 5: {
                    graphics.drawImage(resImages[16], (240 - resImagesWidth[16]) / 2, (320 - resImagesHeight[16]) / 2 + AlbumsPXY, 20);
                    break;
                }
                case 10: {
                    graphics.drawImage(resImages[17], (240 - resImagesWidth[17]) / 2, (320 - resImagesHeight[17]) / 2 + AlbumsPXY, 20);
                    break;
                }
                case 15: {
                    graphics.drawImage(resImages[18], (240 - resImagesWidth[18]) / 2, (320 - resImagesHeight[18]) / 2 + AlbumsPXY, 20);
                    break;
                }
                case 20: {
                    graphics.drawImage(resImages[19], (240 - resImagesWidth[19]) / 2, (320 - resImagesHeight[19]) / 2 + AlbumsPXY, 20);
                    break;
                }
                case 25: {
                    graphics.drawImage(resImages[20], (240 - resImagesWidth[20]) / 2, (320 - resImagesHeight[20]) / 2 + AlbumsPXY, 20);
                    break;
                }
                case 30: {
                    graphics.drawImage(resImages[21], (240 - resImagesWidth[21]) / 2, (320 - resImagesHeight[21]) / 2 + AlbumsPXY, 20);
                    break;
                }
                case 35: {
                    graphics.drawImage(resImages[22], (240 - resImagesWidth[22]) / 2, (320 - resImagesHeight[22]) / 2 + AlbumsPXY, 20);
                    break;
                }
                case 40: {
                    graphics.drawImage(resImages[23], (240 - resImagesWidth[23]) / 2, (320 - resImagesHeight[23]) / 2 + AlbumsPXY, 20);
                    break;
                }
                case 45: {
                    graphics.drawImage(resImages[24], (240 - resImagesWidth[24]) / 2, (320 - resImagesHeight[24]) / 2 + AlbumsPXY, 20);
                    break;
                }
                case 50: {
                    graphics.drawImage(resImages[25], (240 - resImagesWidth[25]) / 2, (320 - resImagesHeight[25]) / 2 + AlbumsPXY, 20);
                }
            }
        }
    }

    public static void paintFrameItem(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        graphics.setClip(n, n2, 8, 8);
        graphics.drawImage(resImages[9], n, n2, 20);
        graphics.setClip(n + n3 - 8, n2, 8, 8);
        graphics.drawImage(resImages[9], n + n3 - 36, n2, 20);
        graphics.setClip(n, n2 + n4 - 8, 8, 8);
        graphics.drawImage(resImages[9], n, n2 + n4 - 36, 20);
        graphics.setClip(n + n3 - 8, n2 + n4 - 8, 8, 8);
        graphics.drawImage(resImages[9], n + n3 - 36, n2 + n4 - 36, 20);
        for (n5 = 0; n5 <= (n3 - 16) / 20; ++n5) {
            graphics.setClip(n + 8 + n5 * 20, n2, Math.min(n3 - 16 - n5 * 20, 20), 8);
            graphics.drawImage(resImages[9], n + n5 * 20, n2, 20);
            graphics.setClip(n + 8 + n5 * 20, n2 + n4 - 8, Math.min(n3 - 16 - n5 * 20, 20), 8);
            graphics.drawImage(resImages[9], n + n5 * 20, n2 + n4, 36);
        }
        for (n5 = 0; n5 <= (n4 - 16) / 20; ++n5) {
            graphics.setClip(n, n2 + 8 + n5 * 20, 8, Math.min(n4 - 16 - n5 * 20, 20));
            graphics.drawImage(resImages[9], n, n2 + n5 * 20, 20);
            graphics.setClip(n + n3 - 8, n2 + 8 + n5 * 20, 8, Math.min(n4 - 16 - n5 * 20, 20));
            graphics.drawImage(resImages[9], n + n3, n2 + n5 * 20, 24);
        }
        for (n5 = 0; n5 <= (n3 - 16) / 20; ++n5) {
            for (int i = 0; i <= (n4 - 16) / 20; ++i) {
                graphics.setClip(n + 8 + n5 * 20, n2 + 8 + i * 20, Math.min(n3 - 16 - n5 * 20, 20), Math.min(n4 - 16 - i * 20, 20));
                graphics.drawImage(resImages[9], n + n5 * 20, n2 + i * 20, 20);
            }
        }
    }

    public static void paintStars(Graphics graphics, int n, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            resAnimations[4].drawAnimation(graphics, 0, System.currentTimeMillis() - (long)(50 * i), n2 - 5 * n + 10 * i, n3, true);
        }
    }

    public static void paintStars(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n; ++i) {
            if (i < n - n2) {
                resAnimations[4].drawAnimation(graphics, 0, System.currentTimeMillis() - (long)(50 * i), n3 - 5 * n + 10 * i, n4, true);
                continue;
            }
            GameCanvas.paintImage(graphics, 15, n3 - 5 * n + 10 * i, n4, 3);
        }
    }

    public static void paintImage(Graphics graphics, int n, int n2, int n3, int n4) {
        switch (n4) {
            case 20: {
                graphics.setClip(n2, n3, resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 17: {
                graphics.setClip(n2 - (resImagesWidth[n] >> 1), n3, resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 24: {
                graphics.setClip(n2 - resImagesWidth[n], n3, resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 6: {
                graphics.setClip(n2, n3 - (resImagesHeight[n] >> 1), resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 3: {
                graphics.setClip(n2 - (resImagesWidth[n] >> 1), n3 - (resImagesHeight[n] >> 1), resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 10: {
                graphics.setClip(n2 - resImagesWidth[n], n3 - (resImagesHeight[n] >> 1), resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 36: {
                graphics.setClip(n2, n3 - resImagesHeight[n], resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 33: {
                graphics.setClip(n2 - (resImagesWidth[n] >> 1), n3 - resImagesHeight[n], resImagesWidth[n], resImagesHeight[n]);
                break;
            }
            case 40: {
                graphics.setClip(n2 - resImagesWidth[n], n3 - resImagesHeight[n], resImagesWidth[n], resImagesHeight[n]);
            }
        }
        if (resImages[n] == null) {
            System.out.println("*** resImages[" + n + "] is NULL");
        } else {
            graphics.drawImage(resImages[n], n2, n3, n4);
        }
    }

    public void paintLandscape(Graphics graphics) {
        try {
            if (resImages[5] != null) {
                graphics.drawRegion(resImages[5], 0, 0, 240, 320, 5, 0, 0, 20);
            } else {
                graphics.setClip(0, 0, 320, 240);
                graphics.fillRect(0, 0, 240, 320);
            }
            GameCanvas.paintImage(graphics, 8, this.ge.getWidth() >> 1, this.ge.getHeight() >> 1, 3);
            if (resFonts[0] != null) {
                resFonts[0].drawString(graphics, lang[58].toCharArray(), this.ge.getWidth() >> 1, this.ge.getHeight() + resImages[8].getHeight() + 10 >> 1, 17);
            } else {
                graphics.setFont(GameEngine.uiFontSmall);
                graphics.setColor(255, 255, 255);
                graphics.setClip(0, 0, 320, 240);
                graphics.drawString("SLIDE TO OPEN", this.ge.getWidth() >> 1, this.ge.getHeight() + resImagesHeight[8] + 10 >> 1, 17);
            }
        }
        catch (Exception exception) {
            graphics.setClip(0, 0, this.ge.getWidth(), this.ge.getHeight());
            graphics.fillRect(0, 0, this.ge.getWidth(), this.ge.getHeight());
            graphics.setFont(GameEngine.uiFontSmall);
            graphics.setColor(255, 255, 255);
            graphics.drawString("SLIDE TO OPEN", this.ge.getWidth() / 2, this.ge.getHeight() / 2, 17);
        }
    }

    public static Image scaleX(Image image, int n, boolean bl) {
        GameCanvas.getRGB(image);
        if (newDataARGB != null) {
            newDataARGB = null;
            GameEngine.garbageCollector();
        }
        newWidth = n * image.getWidth();
        newHeight = n * image.getHeight();
        newDataARGB = new int[newWidth * newHeight];
        int n2 = 0;
        for (int i = 0; i < height; ++i) {
            n2 = i * width;
            for (int j = 0; j < width; ++j) {
                for (int k = 0; k < n; ++k) {
                    offset = n * (j + i * newWidth) + k * newWidth;
                    for (int i2 = 0; i2 < n; ++i2) {
                        GameCanvas.newDataARGB[GameCanvas.offset + i2] = dataARGB[n2];
                    }
                }
                ++n2;
            }
        }
        return Image.createRGBImage((int[])newDataARGB, (int)newWidth, (int)newHeight, (boolean)bl);
    }

    private static void getRGB(Image image) {
        if (dataARGB != null) {
            dataARGB = null;
            GameEngine.garbageCollector();
        }
        width = image.getWidth();
        height = image.getHeight();
        dataARGB = new int[width * height];
        image.getRGB(dataARGB, 0, width, 0, 0, width, height);
    }
}

