/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import com.lemonquest.circulate.Math2D;
import com.lemonquest.utils.SSAnimation;
import com.lemonquest.utils.SSMath;
import javax.microedition.lcdui.Graphics;

public class FX {
    private static final int MAX_PARTICLES = 64;
    private static final long GRAVITY = 1024L;
    private static long[][] p_pos = new long[64][2];
    private static long[][] p_vel = new long[64][2];
    private static long[] p_timeBorn = new long[64];
    private static long[] p_timeLife = new long[64];
    private static boolean[] p_isLive = new boolean[64];
    private static boolean[] p_hasGravity = new boolean[64];
    private static int[][] p_size = new int[64][2];
    private static int[] p_color = new int[64];
    public static int freeParticles = 64;
    private static int index;
    private static int aux;
    private static Object type;

    public static void fireParticles(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, boolean bl) {
        n10 = Math.min(n10, freeParticles);
        for (int i = 0; i < n10; ++i) {
            index = FX.getFreeParticle();
            if (index == -1) {
                return;
            }
            FX.p_pos[FX.index][0] = n << 10;
            FX.p_pos[FX.index][1] = n2 << 10;
            FX.p_size[FX.index][0] = n7;
            FX.p_size[FX.index][1] = n8;
            FX.p_timeBorn[FX.index] = System.currentTimeMillis();
            FX.p_timeLife[FX.index] = n9;
            FX.p_color[FX.index] = n11;
            aux = n3 + SSMath.rand(0, n4 - n3);
            FX.p_vel[FX.index][0] = Math2D.cos(aux) * (long)SSMath.rand(n5, n6);
            FX.p_vel[FX.index][1] = Math2D.sin(aux) * (long)SSMath.rand(n5, n6);
            FX.p_isLive[FX.index] = true;
            FX.p_hasGravity[FX.index] = bl;
            --freeParticles;
        }
    }

    public static void fireSmoke(int n, int n2, int n3, int n4, int n5) {
        FX.fireParticles(n, n2, 80, 100, 1, 4, 0, 0, n3, n4, n5, false);
    }

    private static int getFreeParticle() {
        for (int i = 0; i < 64; ++i) {
            if (p_isLive[i]) continue;
            return i;
        }
        return -1;
    }

    public static void processParticles() {
        for (int i = 0; i < 64; ++i) {
            if (!p_isLive[i]) continue;
            if (System.currentTimeMillis() > p_timeBorn[i] + p_timeLife[i]) {
                FX.p_isLive[i] = false;
                ++freeParticles;
                continue;
            }
            long[] lArray = p_pos[i];
            lArray[0] = lArray[0] + p_vel[i][0];
            long[] lArray2 = p_pos[i];
            lArray2[1] = lArray2[1] - p_vel[i][1];
            if (!p_hasGravity[i]) continue;
            long[] lArray3 = p_vel[i];
            lArray3[1] = lArray3[1] - 1024L;
        }
    }

    public static void paintParticles(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        for (int i = 0; i < 64; ++i) {
            if (!p_isLive[i]) continue;
            graphics.setColor(p_color[i]);
            long l = Math.max(1, p_size[i][0] - p_size[i][1]);
            long l2 = p_timeLife[i] / l;
            long l3 = (long)p_size[i][0] - (System.currentTimeMillis() - p_timeBorn[i]) / l2;
            graphics.fillArc(Math2D.getPixel(p_pos[i][0]), Math2D.getPixel(p_pos[i][1]), (int)l3, (int)l3, 0, 360);
        }
    }

    public static void paintParticles(Graphics graphics, SSAnimation sSAnimation) {
        for (int i = 0; i < 64; ++i) {
            if (!p_isLive[i]) continue;
            sSAnimation.drawAnimation(graphics, p_color[i], System.currentTimeMillis() - p_timeBorn[i], Math2D.getPixel(p_pos[i][0]), Math2D.getPixel(p_pos[i][1]), true);
        }
    }

    public static void paintRay(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = Math.max(Math.abs(n3 - n), Math.abs(n4 - n2)) / n7;
        n8 = Math.max(3, Math.min(n8, 10));
        graphics.setClip(Math.min(n, n3) - n7, Math.min(n2, n4) - n7, Math.abs(n3 - n) + (n7 << 1), Math.abs(n4 - n2) + (n7 << 1));
        graphics.setStrokeStyle(0);
        for (int i = 0; i < n6; ++i) {
            int n9 = n;
            int n10 = n2;
            for (int j = 1; j < n8; ++j) {
                int n11 = n + j * (n3 - n) / n8 - SSMath.rand(0, n7) + SSMath.rand(0, n7);
                int n12 = n2 + j * (n4 - n2) / n8 - SSMath.rand(0, n7) + SSMath.rand(0, n7);
                graphics.setColor(0xFFFFFF);
                graphics.drawLine(n9 - 1, n10, n11 - 1, n12);
                graphics.drawLine(n9, n10 - 1, n11, n12 - 1);
                graphics.setColor(n5);
                graphics.drawLine(n9, n10, n11, n12);
                graphics.drawLine(n9 + 1, n10, n11 + 1, n12);
                n9 = n11;
                n10 = n12;
            }
            graphics.setColor(0xFFFFFF);
            graphics.drawLine(n9 - 1, n10, n3 - 1, n4);
            graphics.drawLine(n9, n10 - 1, n3, n4 - 1);
            graphics.setColor(n5);
            graphics.drawLine(n9, n10, n3, n4);
            graphics.drawLine(n9 + 1, n10, n3 + 1, n4);
        }
    }

    public static void paintBeam(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }
}

