/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import com.lemonquest.circulate.BoardManager;
import com.lemonquest.circulate.FX;
import com.lemonquest.circulate.GameCanvas;
import com.lemonquest.circulate.GameEngine;
import com.lemonquest.circulate.Math2D;
import com.lemonquest.circulate.Wall;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class Ball {
    GameEngine ge;
    public static final int STATUS_KILL = -2;
    public static final int STATUS_DESTROY = -1;
    public static final int STATUS_DEFAULT = 0;
    public static final int STATUS_TOGETHER = 1;
    public static final int STATUS_STOP = 2;
    public static final int STATUS_EXPLODE = 3;
    public int status = 0;
    public int type;
    public int size;
    public long rad;
    public long rad2;
    public long[] pos = new long[2];
    public long[] posOld = new long[2];
    public long gravity;
    public long range;
    public int color = 0xFFFFFF;
    public int[] collideWithWall = new int[32];
    public int collideWithWallCont = 0;
    public boolean collideWithOuterWall = false;
    public boolean isTrapped = false;
    public char actionKey;
    public boolean isActionKeyPressed = false;
    public long actionKeyPressedTime;
    public long togetherTime;
    public long destroyTime;
    public long explodeTime;
    public boolean fireParticles = true;
    public long d;
    public long dA;
    public long dB;

    public Ball(GameEngine gameEngine, int n, int n2, int n3, int n4, char c, boolean bl, int n5) {
        this.ge = gameEngine;
        this.type = n;
        int n6 = this.type;
        BoardManager.ballTypeCnt[n6] = BoardManager.ballTypeCnt[n6] + 1;
        this.pos[0] = this.posOld[0] = (long)n3 << 10;
        this.pos[1] = this.posOld[1] = (long)n4 << 10;
        this.size = n2;
        switch (this.size) {
            case 0: {
                this.rad = 8192L;
                break;
            }
            case 1: {
                this.rad = 12288L;
            }
        }
        this.rad2 = Math2D.pow2(this.rad);
        switch (this.type) {
            case 8: {
                this.gravity = -1024L;
                break;
            }
            default: {
                this.gravity = 1024L;
            }
        }
        switch (this.type) {
            case 0: {
                this.color = 0xFF0000;
                break;
            }
            case 1: {
                this.color = 65280;
                break;
            }
            case 2: {
                this.color = 2463203;
                break;
            }
            case 3: {
                this.color = 0xFFFF00;
            }
        }
        this.status = 0;
        this.actionKey = c;
        this.range = (long)n5 << 10;
    }

    public void activeBall() {
        block0 : switch (this.type) {
            case 7: {
                if (this.isActionKeyPressed && (this.status == 0 || this.status == 2)) {
                    this.status = this.status == 2 ? 0 : 2;
                } else {
                    this.isActionKeyPressed = true;
                    this.actionKeyPressedTime = System.currentTimeMillis();
                }
                if (!GameEngine.configSound) break;
                this.ge.sound.playWav(5, 1);
                break;
            }
            case 9: {
                if (this.isActionKeyPressed && this.status == 0) {
                    this.status = 3;
                    this.explodeTime = System.currentTimeMillis();
                    int n = 0;
                    while (true) {
                        if (n >= BoardManager.ballCnt) break block0;
                        this.d = Math2D.distancePointPoint_Pow2(this.pos[0], this.pos[1], BoardManager.balls[n].pos[0], BoardManager.balls[n].pos[1]);
                        if (this.d != 0L && this.d < 921600L) {
                            BoardManager.balls[n].status = -1;
                        }
                        ++n;
                    }
                }
                this.isActionKeyPressed = true;
                this.actionKeyPressedTime = System.currentTimeMillis();
            }
        }
    }

    public void place(long l, long l2) {
        this.pos[0] = l;
        this.pos[1] = l2;
    }

    public void displace(long l, long l2, long l3) {
        this.pos[0] = this.pos[0] + (l * l3 >> 10);
        this.pos[1] = this.pos[1] + (l2 * l3 >> 10);
    }

    public void setDestroy(long l) {
        if (this.status != -1 && this.status != -2) {
            this.status = -1;
            this.destroyTime = l;
        }
    }

    public boolean setTogether(boolean bl, long l) {
        if (this.status == -1) {
            return true;
        }
        if (bl) {
            if (this.status != 1) {
                this.togetherTime = l;
            }
            this.status = 1;
        } else {
            this.status = 0;
            this.togetherTime = 0L;
        }
        return this.status == -1;
    }

    public int checkCollisionTypeWith(Wall wall) {
        this.collideWithWall[wall.id] = 0;
        if (this.pos[0] - this.rad >= Math.max(wall.posA[0], wall.posB[0]) || this.pos[0] + this.rad <= Math.min(wall.posA[0], wall.posB[0])) {
            return this.collideWithWall[wall.id];
        }
        if (this.pos[1] - this.rad >= Math.max(wall.posA[1], wall.posB[1]) || this.pos[1] + this.rad <= Math.min(wall.posA[1], wall.posB[1])) {
            return this.collideWithWall[wall.id];
        }
        long[] lArray = new long[]{0L, 0L};
        if (Math2D.isPointOverRect(this.pos[0], this.pos[1], wall.posA[0], wall.posA[1], wall.posB[0], wall.posB[1], lArray)) {
            this.d = Math2D.distanceBallWall_Pow2(this, wall);
            if (this.d < this.rad2) {
                this.collideWithWall[wall.id] = 1;
            }
        } else {
            this.dA = Math2D.distancePointPoint_Pow2(this.pos[0], this.pos[1], wall.posA[0], wall.posA[1]);
            this.dB = Math2D.distancePointPoint_Pow2(this.pos[0], this.pos[1], wall.posB[0], wall.posB[1]);
            if (this.dA < this.rad2 && this.dB >= wall.size2) {
                this.collideWithWall[wall.id] = 2;
            } else if (this.dB < this.rad2 && this.dA >= wall.size2) {
                this.collideWithWall[wall.id] = 3;
            }
        }
        return this.collideWithWall[wall.id];
    }

    public void paintBall(Graphics graphics, int n, int n2) {
        switch (this.status) {
            case -2: {
                break;
            }
            case -1: {
                this.paintBallDestroy(graphics, n, n2);
                break;
            }
            case 0: {
                this.paintBallDefault(graphics, n, n2);
                break;
            }
            case 1: {
                this.paintBallTogether(graphics, n, n2);
                break;
            }
            case 2: {
                this.paintBallStop(graphics, n, n2);
                break;
            }
            case 3: {
                this.paintBallExplode(graphics, n, n2);
            }
        }
        this.posOld[0] = this.pos[0];
        this.posOld[1] = this.pos[1];
    }

    public void paintBallDefault(Graphics graphics, int n, int n2) {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                GameCanvas cfr_ignored_0 = this.ge.gc;
                GameCanvas.resAnimations[6].drawAnimation(graphics, this.type + 10 * this.size, System.currentTimeMillis(), n + Math2D.getPixel(this.pos[0]), n2 - Math2D.getPixel(this.pos[1]), true);
                break;
            }
            case 8: {
                if (this.size == 0) {
                    GameCanvas.paintImage(graphics, 13, n + Math2D.getPixel(this.pos[0]), n2 - Math2D.getPixel(this.pos[1]), 3);
                    break;
                }
                GameCanvas.paintImage(graphics, 14, n + Math2D.getPixel(this.pos[0]), n2 - Math2D.getPixel(this.pos[1]), 3);
                break;
            }
            case 7: {
                if (GameEngine.lastProcessTime - this.actionKeyPressedTime < 2000L) {
                    graphics.setColor(0xFF0000);
                    graphics.setClip(n + Math2D.getPixel(this.pos[0]) - 18, n2 - Math2D.getPixel(this.pos[1]) - 18, 36, 36);
                    graphics.fillArc(n + Math2D.getPixel(this.pos[0]) - 12 - 4 * this.size, n2 - Math2D.getPixel(this.pos[1]) - 12 - 4 * this.size, 24 + 7 * this.size, 24 + 7 * this.size, 0, 360);
                } else {
                    this.isActionKeyPressed = false;
                }
                GameCanvas cfr_ignored_1 = this.ge.gc;
                GameCanvas.resAnimations[6].drawAnimation(graphics, 7 + 10 * this.size, System.currentTimeMillis(), n + Math2D.getPixel(this.pos[0]), n2 - Math2D.getPixel(this.pos[1]), true);
                break;
            }
            case 9: {
                if (GameEngine.lastProcessTime - this.actionKeyPressedTime < 2000L) {
                    graphics.setColor(0xFF0000);
                    graphics.setClip(n + Math2D.getPixel(this.pos[0]) - 14, n2 - Math2D.getPixel(this.pos[1]) - 14, 28, 28);
                    graphics.fillArc(n + Math2D.getPixel(this.pos[0]) - 12, n2 - Math2D.getPixel(this.pos[1]) - 12, 24, 24, 0, 360);
                } else {
                    this.isActionKeyPressed = false;
                }
                GameCanvas cfr_ignored_2 = this.ge.gc;
                GameCanvas.resAnimations[6].drawAnimation(graphics, 9, System.currentTimeMillis(), n + Math2D.getPixel(this.pos[0]), n2 - Math2D.getPixel(this.pos[1]), true);
            }
        }
    }

    public void paintBallDestroy(Graphics graphics, int n, int n2) {
        if (this.fireParticles) {
            this.fireParticles = !this.fireParticles;
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (GameEngine.configVibrate) {
                        Display.getDisplay((MIDlet)this.ge.gm).vibrate(200);
                    }
                    FX.fireParticles(n + Math2D.getPixel(this.pos[0]), n2 - Math2D.getPixel(this.pos[1]), 30, 150, 5, 10, 6, 1, 1850, 8, this.type, true);
                    break;
                }
                case 4: 
                case 5: {
                    FX.fireSmoke(n + Math2D.getPixel(this.pos[0]), n2 - Math2D.getPixel(this.pos[1]), 700, 4, 4);
                    if (!GameEngine.configSound) break;
                    this.ge.sound.playWav(4, 1);
                }
            }
        }
        if (System.currentTimeMillis() - this.destroyTime > 690L) {
            this.status = -2;
        }
    }

    public void paintBallTogether(Graphics graphics, int n, int n2) {
        this.paintBallDefault(graphics, n, n2);
        if (GameEngine.gameFrames % 2 == 0) {
            graphics.setColor(this.color);
            graphics.setClip(n + Math2D.getPixel(this.pos[0] - this.rad), n2 - Math2D.getPixel(this.pos[1] + this.rad), Math2D.getPixel(this.rad << 1), Math2D.getPixel(this.rad << 1));
            graphics.fillArc(n + Math2D.getPixel(this.pos[0] - this.rad), n2 - Math2D.getPixel(this.pos[1] + this.rad), Math2D.getPixel(this.rad << 1), Math2D.getPixel(this.rad << 1), 0, 360);
        }
        if (System.currentTimeMillis() - this.togetherTime > 1800L) {
            this.status = -1;
            this.destroyTime = System.currentTimeMillis();
        }
    }

    public void paintBallStop(Graphics graphics, int n, int n2) {
        if (GameEngine.lastProcessTime - this.actionKeyPressedTime < 2000L) {
            graphics.setColor(0xFF0000);
            graphics.setClip(n + Math2D.getPixel(this.pos[0]) - 18, n2 - Math2D.getPixel(this.pos[1]) - 18, 36, 36);
            graphics.fillArc(n + Math2D.getPixel(this.pos[0]) - 12 - 4 * this.size, n2 - Math2D.getPixel(this.pos[1]) - 12 - 4 * this.size, 24 + 7 * this.size, 24 + 7 * this.size, 0, 360);
        } else {
            this.isActionKeyPressed = false;
        }
        GameCanvas cfr_ignored_0 = this.ge.gc;
        GameCanvas.resAnimations[6].drawAnimation(graphics, 8 + 10 * this.size, System.currentTimeMillis(), n + Math2D.getPixel(this.pos[0]), n2 - Math2D.getPixel(this.pos[1]), true);
    }

    public void paintBallExplode(Graphics graphics, int n, int n2) {
        GameCanvas cfr_ignored_0 = this.ge.gc;
        GameCanvas.resAnimations[8].drawAnimation(graphics, 0, System.currentTimeMillis() - this.explodeTime, n + Math2D.getPixel(this.pos[0]), n2 - Math2D.getPixel(this.pos[1]), true);
        if (GameEngine.configSound) {
            this.ge.sound.playWav(0, 1);
        }
        if (System.currentTimeMillis() - this.explodeTime > 490L) {
            this.status = -2;
        }
    }
}

