/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

import java.util.Random;

public class SSMath {
    public static final int PI = 3217;
    public static Random rand = new Random(System.currentTimeMillis());

    public static long degree2rad(int n) {
        long l = n << 10;
        return l * 3217L / 184320L;
    }

    public static long rad2degree(long l) {
        return l * 180L / 3217L;
    }

    public static long atan(long l, long l2) {
        long l3;
        long l4 = 804L;
        long l5 = 3L * l4;
        long l6 = Math.abs(l2);
        if (l >= 0L) {
            long l7 = (l - l6) / (l + l6);
            l3 = l4 - l4 * l7;
        } else {
            long l8 = (l + l6) / (l6 - l);
            l3 = l5 - l4 * l8;
        }
        return l2 < 0L ? -l3 : l3;
    }

    public static long getCRC32(byte[] byArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = byArray.length;
        int[] nArray = new int[256];
        for (n2 = 0; n2 < 256; ++n2) {
            n = n2;
            int n5 = 8;
            while (--n5 >= 0) {
                if ((n & 1) != 0) {
                    n = 0xEDB88320 ^ n >>> 1;
                    continue;
                }
                n >>>= 1;
            }
            nArray[n2] = n;
        }
        n2 = 0;
        n = ~n2;
        while (--n4 >= 0) {
            n = nArray[(n ^ byArray[n3++]) & 0xFF] ^ n >>> 8;
        }
        n2 = ~n;
        return (long)n2 & 0xFFFFFFFFL;
    }

    public static long getCRC32(String string) {
        return SSMath.getCRC32(string.getBytes());
    }

    public static int sum(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public static int sum(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        return n;
    }

    public static int maxValue(int[] nArray) {
        int n = nArray[0];
        for (int i = 0; i < nArray.length; ++i) {
            if (n >= nArray[i]) continue;
            n = nArray[i];
        }
        return n;
    }

    public static int maxValueIndex(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[n] >= nArray[i]) continue;
            n = i;
        }
        return n;
    }

    public static int factorial(int n) {
        if (n <= 0) {
            return 1;
        }
        int n2 = 0;
        for (int i = 1; i <= n; ++i) {
            n2 += i;
        }
        return n2;
    }

    public static void sort(int[] nArray) {
        int n = nArray.length;
        for (int i = 1; i < n; ++i) {
            int n2 = nArray[i];
            for (int j = i - 1; j >= 0 && nArray[j] > n2; --j) {
                nArray[j + 1] = nArray[j];
            }
            nArray[j + 1] = n2;
        }
    }

    public static int rand(int n, int n2) {
        return Math.abs(n + rand.nextInt() % (n2 - n + 1));
    }

    public static int[] shuffle(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = SSMath.rand(0, nArray.length - 1);
            int n2 = nArray[i];
            nArray[i] = nArray[n];
            nArray[n] = n2;
        }
        return nArray;
    }
}

