/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class SSFunctions {
    private static int[] crc_table;
    public static final int[] seno;
    private static final int CHARACTER_ENTER = 172;

    public static long getCRC32(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        if (crc_table == null) {
            crc_table = new int[256];
            for (n4 = 0; n4 < 256; ++n4) {
                n3 = n4;
                int n5 = 8;
                while (--n5 >= 0) {
                    if ((n3 & 1) != 0) {
                        n3 = 0xEDB88320 ^ n3 >>> 1;
                        continue;
                    }
                    n3 >>>= 1;
                }
                SSFunctions.crc_table[n4] = n3;
            }
        }
        n4 = 0;
        n3 = ~n4;
        while (--n2 >= 0) {
            n3 = crc_table[(n3 ^ byArray[n++]) & 0xFF] ^ n3 >>> 8;
        }
        n4 = ~n3;
        return (long)n4 & 0xFFFFFFFFL;
    }

    public static long getCRC32(byte[] byArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = byArray.length;
        int[] nArray = new int[256];
        for (n2 = 0; n2 < 256; ++n2) {
            n = n2;
            int n5 = 8;
            while (--n5 >= 0) {
                if ((n & 1) != 0) {
                    n = 0xEDB88320 ^ n >>> 1;
                    continue;
                }
                n >>>= 1;
            }
            nArray[n2] = n;
        }
        n2 = 0;
        n = ~n2;
        while (--n4 >= 0) {
            n = nArray[(n ^ byArray[n3++]) & 0xFF] ^ n >>> 8;
        }
        n2 = ~n;
        return (long)n2 & 0xFFFFFFFFL;
    }

    public static long getCRC32(String string) {
        return SSFunctions.getCRC32(string.getBytes());
    }

    public static boolean changePNGPalette(byte[] byArray, short[][] sArray) {
        int n = 8;
        while (n < byArray.length) {
            int n2 = (byArray[n] << 24) + (byArray[n + 1] << 16) + (byArray[n + 2] << 8) + (byArray[n + 3] & 0xFF);
            if (byArray[n + 4] == 80 && byArray[n + 5] == 76 && byArray[n + 6] == 84 && byArray[n + 7] == 69) {
                int n3 = n + 8;
                for (int i = 0; i < sArray.length; ++i) {
                    int n4 = n3 + sArray[i][0] * 3;
                    byArray[n4] = (byte)(sArray[i][1] & 0xFF);
                    byArray[n4 + 1] = (byte)(sArray[i][2] & 0xFF);
                    byArray[n4 + 2] = (byte)(sArray[i][3] & 0xFF);
                }
                long l = SSFunctions.getCRC32(byArray, n + 4, n2 + 4);
                int n5 = n + 8 + n2;
                byArray[n5] = (byte)((l & 0xFFFFFFFFFF000000L) >> 24);
                byArray[n5 + 1] = (byte)((l & 0xFF0000L) >> 16);
                byArray[n5 + 2] = (byte)((l & 0xFFF00L) >> 8);
                byArray[n5 + 3] = (byte)(l & 0xFFL);
                return true;
            }
            n = n + 8 + n2 + 4;
        }
        return false;
    }

    public static boolean changePNGPalette(byte[] byArray, int[] nArray) {
        short[][] sArray = new short[nArray.length][4];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            sArray[i][0] = (short)(n >> 24 & 0xFF);
            sArray[i][1] = (short)(n >> 16 & 0xFF);
            sArray[i][2] = (short)(n >> 8 & 0xFF);
            sArray[i][3] = (short)(n & 0xFF);
        }
        return SSFunctions.changePNGPalette(byArray, sArray);
    }

    public static byte[] getResourceAsByteArray(String string) {
        byte[] byArray = new byte[64];
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataInputStream dataInputStream = new DataInputStream(byteArrayOutputStream.getClass().getResourceAsStream(string));
            while ((n = dataInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            dataInputStream.close();
            byteArrayOutputStream.close();
            return byArray2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static DataInputStream getResourceAsStream(String string) {
        try {
            DataInputStream dataInputStream = new DataInputStream(string.getClass().getResourceAsStream(string));
            return dataInputStream;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int seno(int n) {
        if ((n = Math.abs(n)) >= 360) {
            n %= 360;
        }
        if (n <= 90) {
            return seno[n];
        }
        if (n > 90 && n <= 180) {
            return seno[90 - (n - 90)];
        }
        if (n > 180 && n <= 270) {
            return -seno[n - 180];
        }
        return -seno[360 - n];
    }

    public static int coseno(int n) {
        if ((n = Math.abs(n)) >= 360) {
            n %= 360;
        }
        if (n <= 90) {
            return SSFunctions.seno(90 - n);
        }
        if (n > 90 && n <= 180) {
            return -SSFunctions.seno(n - 90);
        }
        if (n > 180 && n <= 270) {
            return SSFunctions.seno(270 - (n - 180));
        }
        return -SSFunctions.seno(360 - (n - 270));
    }

    public static int tangente(int n) {
        return SSFunctions.seno(n) / SSFunctions.coseno(n);
    }

    public static final String[] loadLang(String string) {
        int n;
        byte[] byArray = SSFunctions.getResourceAsByteArray(string);
        int n2 = 1;
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] != 10) continue;
            ++n2;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            int n4 = n3;
            do {
                if ((byArray[n4] & 0xFF) != 172) continue;
                byArray[n4] = 10;
            } while (++n4 < byArray.length && byArray[n4] != 10 && byArray[n4] != 13);
            stringArray[n] = new String(byArray, n3, n4 - n3);
            n3 += n4 - n3 + 1;
            if (n4 >= byArray.length || byArray[n4] != 13) continue;
            ++n3;
        }
        return stringArray;
    }

    public static final String[] loadLangUnicode(DataInputStream dataInputStream, int n) {
        String[] stringArray = new String[n];
        try {
            for (int i = 0; i < n; ++i) {
                String string = dataInputStream.readUTF();
                stringArray[i] = string = SSFunctions.replace(string, "\u00ac", "\n");
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringArray;
    }

    public static final String[] loadLang(DataInputStream dataInputStream, int n) {
        String[] stringArray = new String[n];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < n; ++i) {
            byteArrayOutputStream.reset();
            try {
                int n2 = dataInputStream.readByte();
                do {
                    if ((n2 & 0xFF) == 172) {
                        n2 = 10;
                    }
                    byteArrayOutputStream.write(n2);
                } while ((n2 = (int)((byte)dataInputStream.readUnsignedByte())) != 10 && n2 != 13);
                stringArray[i] = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                if (n2 != 13) continue;
                n2 = dataInputStream.readByte();
                continue;
            }
            catch (EOFException eOFException) {
                stringArray[i] = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stringArray;
    }

    public static void deleteRecordStore(String string) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                recordStore.deleteRecord(recordEnumeration.nextRecordId());
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void store(String string, ByteArrayOutputStream byteArrayOutputStream) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                recordStore.deleteRecord(recordEnumeration.nextRecordId());
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static DataInputStream load(String string) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordEnumeration.nextRecord());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return dataInputStream;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getTimeText(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = (int)(l /= 1000L) / 60;
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        stringBuffer.append(':');
        int n2 = (int)l - n * 60;
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        if (string.length() == 0) {
            return string;
        }
        int n = string2.length();
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.indexOf(string2);
        while (n2 != -1) {
            if (n2 != 0) {
                stringBuffer.append(string.substring(0, n2 - n + string2.length()) + string3);
            } else {
                stringBuffer.append(string3);
            }
            string = string.substring(n2 + n);
            n2 = string.indexOf(string2);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static {
        seno = new int[]{0, 175, 349, 523, 698, 872, 1045, 1219, 1392, 1564, 1736, 1908, 2079, 2250, 2419, 2588, 2756, 2924, 3090, 3256, 3420, 3584, 3746, 3907, 4067, 4226, 4384, 4540, 4695, 4848, 5000, 5150, 5299, 5446, 5592, 5736, 5878, 6018, 6157, 6293, 6428, 6561, 6691, 6820, 6947, 7071, 7193, 7314, 7431, 7547, 7660, 7771, 7880, 7986, 8090, 8192, 8290, 8387, 8480, 8572, 8660, 8746, 8829, 8910, 8988, 9063, 9135, 9205, 9272, 9336, 9397, 9455, 9511, 9563, 9613, 9659, 9703, 9744, 9781, 9816, 9848, 9877, 9903, 9925, 9945, 9962, 9976, 9986, 9994, 9998, 10000};
    }
}

