/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    private static Player[] playersMidi = null;
    private static Player[] playersWav = null;
    public static int currentMidi = -1;
    public static int currentWav = -1;
    public static int lastMidi = -1;
    public static int lastWav = -1;

    public Sound() {
        int n;
        System.out.println("*** Sound() ***");
        playersMidi = new Player[4];
        for (n = 0; n < 4; ++n) {
            this.loadSound(n, 3);
        }
        playersWav = new Player[8];
        for (n = 0; n < 8; ++n) {
            this.loadSound(n, 4);
        }
    }

    public boolean playMidi(int n, int n2) {
        if (n == -1) {
            return false;
        }
        if (n >= 4) {
            return false;
        }
        try {
            if (currentMidi != n) {
                playersMidi[n].setLoopCount(n2);
            }
            if (currentMidi != -1 && playersMidi[currentMidi].getState() == 400) {
                if (currentMidi == n) {
                    return true;
                }
                this.stopMidi(currentMidi);
            }
            switch (playersMidi[n].getState()) {
                case 100: {
                    playersMidi[n].realize();
                }
                case 200: {
                    playersMidi[n].prefetch();
                }
            }
            this.setVolumeMidi(n, 50);
            playersMidi[n].start();
            if (currentMidi != -1) {
                lastMidi = currentMidi;
            }
            currentMidi = n;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.playMidi(): " + exception.toString());
            return false;
        }
        return true;
    }

    public boolean stopMidi(int n) {
        if (n == -1) {
            return false;
        }
        if (n >= 4) {
            return false;
        }
        try {
            if (playersMidi[n].getState() != 400) {
                return false;
            }
            if (n != -1) {
                playersMidi[n].stop();
            }
            lastMidi = currentMidi;
            currentMidi = -1;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.stopMidi(): " + exception.toString());
            return false;
        }
        return true;
    }

    public boolean playWav(int n, int n2) {
        if (n == -1) {
            return false;
        }
        if (n >= 8) {
            return false;
        }
        try {
            if (currentWav != n) {
                playersWav[n].setLoopCount(n2);
            }
            if (currentWav != -1 && playersWav[currentWav].getState() == 400) {
                return false;
            }
            switch (playersWav[n].getState()) {
                case 100: {
                    playersWav[n].realize();
                }
                case 200: {
                    playersWav[n].prefetch();
                }
            }
            playersWav[n].start();
            if (currentWav != -1) {
                lastWav = currentWav;
            }
            currentWav = n;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.playWav(): " + exception.toString());
            return false;
        }
        return true;
    }

    public boolean stopWav(int n) {
        if (n == -1) {
            return false;
        }
        if (n >= 8) {
            return false;
        }
        try {
            if (playersWav[n].getState() != 400) {
                return false;
            }
            if (n != -1) {
                playersWav[n].stop();
            }
            lastWav = currentWav;
            currentWav = -1;
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.stopWav(): " + exception.toString());
            return false;
        }
        return true;
    }

    public void setVolumeMidi(int n, int n2) {
        try {
            VolumeControl volumeControl = (VolumeControl)playersMidi[n].getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setLevel(n2);
            }
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.setVolume(): " + exception.toString());
        }
    }

    public void setVolumeWav(int n, int n2) {
        try {
            VolumeControl volumeControl = (VolumeControl)playersWav[n].getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setLevel(n2);
            }
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: Sound.setVolume(): " + exception.toString());
        }
    }

    public boolean loadSound(int n, int n2) {
        switch (n2) {
            case 3: {
                try {
                    Sound.playersMidi[n] = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/res" + n + ".mid"), (String)"audio/midi");
                    System.out.println("   Load res" + n + ".mid");
                    break;
                }
                catch (IOException iOException) {
                    System.out.println("Can't load res" + n + ".mid");
                    return false;
                }
                catch (MediaException mediaException) {
                    System.out.println("Media problem with res" + n + ".mid");
                    return false;
                }
            }
            case 4: {
                try {
                    Sound.playersWav[n] = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/res" + n + ".wav"), (String)"audio/x-wav");
                    System.out.println("   Load res" + n + ".wav");
                    break;
                }
                catch (IOException iOException) {
                    System.out.println("Can't load res" + n + ".wav");
                    return false;
                }
                catch (MediaException mediaException) {
                    System.out.println("Media problem with res" + n + ".wav");
                    return false;
                }
            }
        }
        return true;
    }

    public boolean unloadSound(int n, int n2) {
        switch (n2) {
            case 3: {
                try {
                    playersMidi[n].deallocate();
                    playersMidi[n].close();
                    break;
                }
                catch (Exception exception) {
                    System.out.println("EXCEPTION: Sound.unloadSound(): " + exception.toString());
                    return false;
                }
            }
            case 4: {
                try {
                    playersWav[n].deallocate();
                    playersWav[n].close();
                    break;
                }
                catch (Exception exception) {
                    System.out.println("EXCEPTION: Sound.unloadSound(): " + exception.toString());
                    return false;
                }
            }
        }
        return true;
    }
}

