/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import java.util.Calendar;
import java.util.Date;

public class Crono {
    public static final int FORMAT_HHMMSSD = 0;
    public static final int FORMAT_HHMMSS = 1;
    public static final int FORMAT_HHMM = 2;
    public static final int FORMAT_MMSSD = 3;
    public static final int FORMAT_MMSS = 4;
    public static final int FORMAT_SSD = 5;
    public static final int FORMAT_SS = 6;
    private long clockTime = 0L;
    private long initTime = 0L;
    private long nowTime = 0L;
    private Calendar calendar = null;
    private StringBuffer output = new StringBuffer(16);
    private long remainTime = 0L;

    public Crono() {
        this.calendar = Calendar.getInstance();
    }

    public void setTime(long l) {
        this.clockTime = l;
    }

    public void addTime(long l) {
        this.clockTime += l;
    }

    public void start() {
        this.initTime = System.currentTimeMillis();
    }

    public long stop() {
        if (this.initTime == 0L) {
            return this.clockTime;
        }
        this.clockTime += System.currentTimeMillis() - this.initTime;
        this.initTime = 0L;
        return this.clockTime;
    }

    public void reset() {
        this.clockTime = 0L;
    }

    public long getMilliseconds() {
        if (this.initTime == 0L) {
            return this.clockTime;
        }
        return this.clockTime + System.currentTimeMillis() - this.initTime;
    }

    public int get(int n) {
        this.calendar.setTime(new Date(this.getMilliseconds()));
        return this.calendar.get(n);
    }

    public int get(int n, long l) {
        this.calendar.setTime(new Date(l));
        return this.calendar.get(n);
    }

    public String getTimeString(int n) {
        this.output.setLength(0);
        switch (n) {
            case 0: {
                this.output.append(this.get(11));
                this.output.append(":");
                if (this.get(13) < 10) {
                    this.output.append("0");
                    this.output.append(this.get(12));
                } else {
                    this.output.append(this.get(12));
                }
                this.output.append(":");
                if (this.get(13) < 10) {
                    this.output.append("0");
                    this.output.append(this.get(13));
                } else {
                    this.output.append(this.get(13));
                }
                this.output.append(":");
                this.output.append(this.get(14) / 100);
                break;
            }
            case 1: {
                this.output.append(this.get(11));
                this.output.append(":");
                if (this.get(13) < 10) {
                    this.output.append("0");
                    this.output.append(this.get(12));
                } else {
                    this.output.append(this.get(12));
                }
                this.output.append(":");
                if (this.get(13) < 10) {
                    this.output.append("0");
                    this.output.append(this.get(13));
                    break;
                }
                this.output.append(this.get(13));
                break;
            }
            case 2: {
                this.output.append(this.get(11));
                this.output.append(":");
                if (this.get(13) < 10) {
                    this.output.append("0");
                    this.output.append(this.get(12));
                    break;
                }
                this.output.append(this.get(12));
                break;
            }
            case 3: {
                if (this.getMilliseconds() >= 3600000L) {
                    this.output.append("59:59:9");
                    break;
                }
                this.output.append(Math.min(59, this.get(12)));
                this.output.append(":");
                if (this.get(13) < 10) {
                    this.output.append("0");
                    this.output.append(this.get(13));
                } else {
                    this.output.append(Math.min(59, this.get(13)));
                }
                this.output.append(":");
                this.output.append(this.get(14) / 100);
                break;
            }
            case 4: {
                this.remainTime = this.getMilliseconds() / 1000L;
                this.output.append(this.remainTime / 60L);
                this.remainTime %= 60L;
                this.output.append(":");
                if (this.remainTime < 10L) {
                    this.output.append("0");
                    this.output.append(this.remainTime);
                    break;
                }
                this.output.append(this.remainTime);
                break;
            }
            case 5: {
                this.output.append(this.get(13));
                this.output.append(".");
                this.output.append(this.get(14) / 100);
                break;
            }
            case 6: {
                this.output.append(this.get(13));
            }
        }
        return this.output.toString();
    }

    public String getTimeString(int n, long l) {
        this.output.setLength(0);
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (l >= 3600000L) {
                    this.output.append("59:59:9");
                    break;
                }
                this.output.append(Math.min(59, this.get(12, l)));
                this.output.append(":");
                if (this.get(13) < 10) {
                    this.output.append("0");
                    this.output.append(this.get(13, l));
                } else {
                    this.output.append(Math.min(59, this.get(13, l)));
                }
                this.output.append(":");
                this.output.append(this.get(14, l) / 100);
                break;
            }
            case 4: {
                this.remainTime = l / 1000L;
                this.output.append(this.remainTime / 60L);
                this.remainTime %= 60L;
                this.output.append(":");
                if (this.remainTime < 10L) {
                    this.output.append("0");
                    this.output.append(this.remainTime);
                    break;
                }
                this.output.append(this.remainTime);
                break;
            }
        }
        return this.output.toString();
    }
}

