/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

public class SSKeyboard {
    public static final char LEFT_BUTTON = '\u0000';
    public static final char RIGHT_BUTTON = '\u0001';
    public static final char FIRE_BUTTON = '\u0002';
    public static final char LEFT_ARROW = '\u0003';
    public static final char RIGHT_ARROW = '\u0004';
    public static final char UP_ARROW = '\u0005';
    public static final char DOWN_ARROW = '\u0006';
    public static final char CLEAR_KEY = '\u0007';
    public static final char NO_KEY = '\uffff';
    public static final byte KEY_PRESSED = 0;
    public static final byte KEY_RELEASED = 1;
    private static final String NUMBERS_CHARS = "0123456789*#";
    private static final int BUFFER_SIZE = 50;
    private byte[] evtType = new byte[50];
    private char[] evtKeys = new char[50];
    private int posRead = 0;
    private int posWrite = 0;
    private int lastEvent;
    private static char lastKey;
    private boolean hasMoreKeys = false;
    private static int lastKeyCode;
    public static final int LEFT_BUTTON_CODE = -6;
    public static final int RIGHT_BUTTON_CODE = -7;
    public static final int FIRE_BUTTON_CODE = -5;
    public static final int LEFT_ARROW_CODE = -3;
    public static final int RIGHT_ARROW_CODE = -4;
    private static final int UP_ARROW_CODE = -1;
    private static final int DOWN_ARROW_CODE = -2;
    private static final int CLEAR_KEY_CODE = -8;

    public boolean getHasMoreKeys() {
        return this.hasMoreKeys;
    }

    public int getLastEvent() {
        return this.lastEvent;
    }

    public static int getLastKeyCode() {
        return lastKeyCode;
    }

    public static int getLastKey() {
        return lastKey;
    }

    public char nextChar() {
        if (!this.hasMoreKeys) {
            return '\uffff';
        }
        this.lastEvent = this.evtType[this.posRead];
        lastKey = this.evtKeys[this.posRead];
        ++this.posRead;
        if (this.posRead == 50) {
            this.posRead = 0;
        }
        this.hasMoreKeys = this.posRead != this.posWrite;
        return lastKey;
    }

    public void removeAllEvents() {
        this.posRead = this.posWrite;
        this.hasMoreKeys = false;
    }

    private void addKey(byte by, char c) {
        this.evtKeys[this.posWrite] = c;
        this.evtType[this.posWrite] = by;
        ++this.posWrite;
        if (this.posWrite == 50) {
            this.posWrite = 0;
        }
        this.hasMoreKeys = true;
    }

    public synchronized void keyPressed(int n) {
        lastKeyCode = n;
        int n2 = this.getNumericKeyForKeycode(n);
        if (n2 != -1) {
            this.addKey((byte)0, NUMBERS_CHARS.charAt(n2));
        } else {
            char c = this.getActionByKeyCode(n);
            if (c != '\uffff') {
                this.addKey((byte)0, c);
            }
        }
    }

    public synchronized void keyReleased(int n) {
        lastKeyCode = n;
        int n2 = this.getNumericKeyForKeycode(n);
        if (n2 != -1) {
            this.addKey((byte)1, NUMBERS_CHARS.charAt(n2));
        } else {
            char c = this.getActionByKeyCode(n);
            if (c != '\uffff') {
                this.addKey((byte)1, c);
            }
        }
    }

    private int getNumericKeyForKeycode(int n) {
        switch (n) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 42: {
                return 10;
            }
            case 35: {
                return 11;
            }
        }
        return -1;
    }

    private char getActionByKeyCode(int n) {
        switch (n) {
            case -6: {
                return '\u0000';
            }
            case -7: {
                return '\u0001';
            }
            case -5: {
                return '\u0002';
            }
            case -3: {
                return '\u0003';
            }
            case -4: {
                return '\u0004';
            }
            case -1: {
                return '\u0005';
            }
            case -2: {
                return '\u0006';
            }
            case -8: {
                return '\u0007';
            }
        }
        return '\uffff';
    }
}

