/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;

public class SSBluetooth
implements Runnable,
DiscoveryListener {
    public static final int TIME_OUT_RECEIVE = 100000;
    public static final int NO_ERROR = -1;
    public static final int ERROR_INITIALIZE_BLUETOOTH = 0;
    public static final int ERROR_LAUNCH_SERVER = 1;
    public static final int ERROR_SEARCHING_REMOTES = 2;
    public static final int ERROR_SEARCHING_SERVICES = 3;
    public static final int ERROR_CONNECT_SERVER = 4;
    public static final int ERROR_CONNECT_CLIENT = 5;
    public static final int ERROR_SEND_DATA = 6;
    public static final int ERROR_RECEIVE_DATA = 7;
    private boolean searchingRemotes;
    private boolean searchingServices;
    private boolean errorConnection;
    private boolean serversFounded;
    private int errorCode;
    private RemoteDevice[] remotesAny;
    private ServiceRecord[][] servicesRecord;
    public String[] remotesNames;
    private String[] serversName;
    private LocalDevice localDevice;
    private DeviceClass deviceClass;
    private L2CAPConnection conn;
    private L2CAPConnectionNotifier connNotifier;
    private String uuid;
    private String name;
    private String connUrl;
    private int transID;
    public int posRemotesAny;
    private int posRemotesSave;
    private int posRemotes;
    public int posRemoteServices;
    private byte[] dataReceived;
    private int bytesReaded;

    public SSBluetooth() {
        try {
            this.remotesAny = new RemoteDevice[32];
            this.remotesNames = new String[32];
            this.servicesRecord = new ServiceRecord[32][];
            this.serversName = new String[16];
            this.dataReceived = new byte[512];
            this.uuid = "83fbfdb4517843db8388c8ba9e0f6fa1";
            this.name = "JUEGOHORCA";
            this.connUrl = "btl2cap://localhost:" + this.uuid + ";authenticate=false" + ";authorize=false" + ";encrypt=false" + ";name=" + this.name;
            this.searchingRemotes = false;
            this.errorConnection = false;
            this.searchingServices = false;
            this.transID = -1;
            this.errorCode = -1;
            this.bytesReaded = -1;
            this.localDevice = LocalDevice.getLocalDevice();
            this.deviceClass = this.localDevice.getDeviceClass();
            this.closeBluetooth();
        }
        catch (BluetoothStateException bluetoothStateException) {
            this.setError(0);
        }
    }

    public void sendData(byte[] byArray) {
        try {
            this.conn.send(byArray);
        }
        catch (Exception exception) {
            this.setError(6);
        }
    }

    public boolean receiveData(boolean bl) {
        if (this.conn == null) {
            return false;
        }
        try {
            boolean bl2 = this.conn.ready();
            long l = System.currentTimeMillis();
            while (!bl2 && bl) {
                this.sleep(10);
                bl2 = this.conn.ready();
                if (System.currentTimeMillis() - l < 100000L || bl2) continue;
            }
            if (!bl2) {
                if (bl) {
                    throw new IOException();
                }
                return false;
            }
            this.bytesReaded = this.conn.receive(this.dataReceived);
            return bl2;
        }
        catch (Exception exception) {
            this.setError(7);
            return false;
        }
    }

    public int getBytesReceived() {
        return this.bytesReaded;
    }

    public byte[] getDataReceived() {
        return this.dataReceived;
    }

    public void launchServer() {
        try {
            this.errorConnection = false;
            this.closeBluetooth();
            this.localDevice.setDiscoverable(10390323);
            Thread thread = new Thread(this);
            thread.start();
        }
        catch (Exception exception) {
            this.setError(1);
        }
    }

    public boolean hasServerFounded() {
        return this.serversFounded;
    }

    public boolean hasClientConnected() {
        return this.serversFounded;
    }

    public String[] getServersFounded() {
        return this.serversName;
    }

    public int getMaxServersFounded() {
        return this.posRemotesSave;
    }

    public boolean isSearchingGames() {
        return this.searchingRemotes || this.searchingServices || this.posRemotes < this.posRemotesAny;
    }

    public void openConnectionRemote(int n) {
        try {
            this.cancelSearch();
            String string = this.servicesRecord[n][0].getConnectionURL(0, false);
            this.conn = (L2CAPConnection)Connector.open((String)string);
        }
        catch (Exception exception) {
            this.setError(4);
        }
    }

    public void startSearchRemotes() {
        try {
            this.closeBluetooth();
            this.posRemotesAny = 0;
            this.posRemotes = 0;
            this.posRemotesSave = 0;
            this.posRemoteServices = 0;
            this.errorConnection = false;
            this.searchingRemotes = true;
            this.localDevice.setDiscoverable(0);
            this.localDevice.getDiscoveryAgent().startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (Exception exception) {
            this.setError(2);
        }
    }

    public void searchServices() {
        if (!this.searchingRemotes && this.posRemotes < this.posRemotesAny && !this.searchingServices) {
            this.searchService(this.posRemotes);
            this.posRemotes = this.posRemoteServices + 1;
        }
    }

    private void searchService(int n) {
        try {
            this.searchingServices = true;
            this.posRemoteServices = n;
            UUID[] uUIDArray = new UUID[]{new UUID(this.uuid, false)};
            this.transID = this.localDevice.getDiscoveryAgent().searchServices(null, uUIDArray, this.remotesAny[n], (DiscoveryListener)this);
        }
        catch (Exception exception) {
            this.setError(3);
        }
    }

    public int getError() {
        if (this.errorConnection) {
            return this.errorCode;
        }
        return -1;
    }

    private void setError(int n) {
        this.errorConnection = true;
        this.errorCode = n;
    }

    public void closeBluetooth() {
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
            if (this.connNotifier != null) {
                this.connNotifier.close();
                this.connNotifier = null;
            }
            this.localDevice.setDiscoverable(0);
            this.posRemotesAny = 0;
            this.posRemotesSave = 0;
            this.bytesReaded = -1;
            this.serversFounded = false;
            this.cancelSearch();
            int n = this.transID;
            if (this.transID != -1) {
                this.transID = -1;
                this.localDevice.getDiscoveryAgent().cancelServiceSearch(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void cancelSearch() {
        if (this.searchingRemotes) {
            this.searchingRemotes = false;
            this.serversFounded = false;
            this.localDevice.getDiscoveryAgent().cancelInquiry((DiscoveryListener)this);
            int n = this.transID;
            if (n != -1) {
                this.transID = -1;
                this.localDevice.getDiscoveryAgent().cancelServiceSearch(n);
            }
        }
    }

    public String getRemoteDeviceName(RemoteDevice remoteDevice) {
        try {
            return remoteDevice.getFriendlyName(false);
        }
        catch (Exception exception) {
            return "UNKNOWN";
        }
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        if (deviceClass.getMajorDeviceClass() == 512) {
            System.out.println("[client] RemoteDevice founded: " + this.getRemoteDeviceName(remoteDevice));
            this.remotesAny[this.posRemotesAny] = remoteDevice;
            this.remotesNames[this.posRemotesAny] = this.getRemoteDeviceName(remoteDevice);
            ++this.posRemotesAny;
        }
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        if (this.transID == n) {
            this.serversName[this.posRemotesSave] = this.getRemoteDeviceName(serviceRecordArray[0].getHostDevice());
            this.servicesRecord[this.posRemotesSave] = serviceRecordArray;
            ++this.posRemotesSave;
        }
    }

    public void serviceSearchCompleted(int n, int n2) {
        if (this.transID == n) {
            if (this.posRemotesSave > 0) {
                this.serversFounded = true;
            }
        } else {
            this.errorCode = -1;
            this.errorConnection = false;
        }
        this.searchingServices = false;
    }

    public void inquiryCompleted(int n) {
        this.searchingRemotes = false;
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        try {
            if (this.connNotifier == null) {
                this.connNotifier = (L2CAPConnectionNotifier)Connector.open((String)this.connUrl);
            }
            this.conn = this.connNotifier.acceptAndOpen();
            if (this.conn != null) {
                this.serversFounded = true;
                this.localDevice.setDiscoverable(0);
            } else {
                this.setError(5);
            }
        }
        catch (Exception exception) {
            this.setError(5);
            return;
        }
    }
}

