/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.circulate;

import com.lemonquest.circulate.BoardManager;
import com.lemonquest.circulate.Math2D;
import javax.microedition.lcdui.Graphics;

public class Wall {
    public int id = 0;
    public long[] posA = new long[2];
    public long[] posB = new long[2];
    public long[] posAini = new long[2];
    public long[] posBini = new long[2];
    public long size = 0L;
    public long size2 = 0L;
    public boolean isVisible = true;
    public boolean isDoor = false;

    public Wall(int n, int n2, int n3, int n4, int n5) {
        this.id = n;
        this.posA[0] = this.posAini[0] = (long)n2 << 10;
        this.posA[1] = this.posAini[1] = (long)n3 << 10;
        this.posB[0] = this.posBini[0] = (long)n4 << 10;
        this.posB[1] = this.posBini[1] = (long)n5 << 10;
        this.size2 = Math2D.distancePointPoint_Pow2(n2, n3, n4, n5);
        this.size = Math2D.sqrt(this.size2);
    }

    public long[] normal() {
        long[] lArray = new long[]{this.posA[1] - this.posB[1], this.posB[0] - this.posA[0]};
        if (this.posA[0] - this.posB[0] > 0L) {
            lArray[0] = this.posB[1] - this.posA[1];
            lArray[1] = this.posA[0] - this.posB[0];
        }
        lArray = Math2D.normalize(lArray[0], lArray[1]);
        return lArray;
    }

    public long[] normal(long l, long l2) {
        long[] lArray = new long[]{this.posB[1] - this.posA[1], this.posA[0] - this.posB[0]};
        if ((l2 - this.posA[1]) * (this.posB[0] - this.posA[0]) > (l - this.posA[0]) * (this.posB[1] - this.posA[1])) {
            lArray[0] = this.posA[1] - this.posB[1];
            lArray[1] = this.posB[0] - this.posA[0];
        }
        lArray = Math2D.normalize(lArray[0], lArray[1]);
        return lArray;
    }

    public void updatePosition(int n) {
        this.posA = Math2D.rotatePoint(this.posAini[0], this.posAini[1], n);
        this.posB = Math2D.rotatePoint(this.posBini[0], this.posBini[1], n);
    }

    public void paintWall(Graphics graphics, int n, int n2, int n3) {
        graphics.setClip(0, 0, 240, 320);
        if (this.isVisible) {
            graphics.setColor(BoardManager.arenaColor);
            graphics.setStrokeStyle(n3);
            graphics.drawLine(n + Math2D.getPixel(this.posA[0]), n2 - Math2D.getPixel(this.posA[1]), n + Math2D.getPixel(this.posB[0]), n2 - Math2D.getPixel(this.posB[1]));
            graphics.fillArc(n + Math2D.getPixel(this.posA[0]) - 2, n2 - Math2D.getPixel(this.posA[1]) - 2, 4, 4, 0, 360);
            graphics.fillArc(n + Math2D.getPixel(this.posB[0]) - 2, n2 - Math2D.getPixel(this.posB[1]) - 2, 4, 4, 0, 360);
        } else if (this.isDoor) {
            graphics.setColor(0);
            graphics.setStrokeStyle(n3);
            graphics.drawLine(n + Math2D.getPixel(this.posA[0]), n2 - Math2D.getPixel(this.posA[1]), n + Math2D.getPixel(this.posB[0]), n2 - Math2D.getPixel(this.posB[1]));
            graphics.fillArc(n + Math2D.getPixel(this.posA[0]) - 2, n2 - Math2D.getPixel(this.posA[1]) - 2, 4, 4, 0, 360);
            graphics.fillArc(n + Math2D.getPixel(this.posB[0]) - 2, n2 - Math2D.getPixel(this.posB[1]) - 2, 4, 4, 0, 360);
        }
    }
}

