/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.GameDefs;
import sk.inlogic.GeneralDefs;
import sk.inlogic.LevelTutorial;
import sk.inlogic.LevelsReader;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.GFont;
import sk.inlogic.saves.SavedItem;
import sk.inlogic.saves.SavedTutorialItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    MainCanvas mainCanvas;
    final byte SCREEN_GAME;
    final byte SCREEN_RESULT;
    static final byte ID_MODE_EASY = 0;
    static final byte ID_MODE_MEDIUM = 1;
    static final byte ID_MODE_HARD = 2;
    static final byte ID_MODE_TUTORIAL = 3;
    static final byte TOTAL_ID_GAME_MODE = 4;
    GFont fontMainWhite;
    GFont fontMainWhiteSmall;
    GFont fontMainWhiteBlackBg;
    GFont fontMainWhiteBlackBgSmall;
    Image imgBg;
    Image imgLogo;
    Sprite sprHand;
    Sprite sprIcons;
    Sprite sprMedalsSmall;
    Sprite sprStonesSelector;
    Sprite sprButton;
    Sprite sprButtonActive;
    Sprite sprDialog;
    Sprite sprStones;
    Sprite sprTiles;
    Sprite sprTilesDark;
    Sprite sprTimebar;
    Sprite sprFirework;
    Sprite sprStarsDialog;
    Sprite sprTopBg;
    Sprite sprTimebarFg;
    private Rectangle rectTextInfo;
    private static PreparedText preparedTextInfo;
    private int resultMatchesY;
    private int resultUsedUndoY;
    private int resultTimeY;
    private int resultTotalScoreY;
    private int resultMedalY;
    private int resultRecordY;
    private int timebarX;
    private Rectangle[] rectControls = new Rectangle[3];
    private Rectangle rectDialog;
    final byte NULL = (byte)-128;
    private byte[] layers;
    private byte[] posX;
    private byte[] posY;
    private byte[] tiles;
    private int[] removed;
    private byte[] showed;
    private byte[] stones;
    private int[] showedPosX;
    private int[] showedPosY;
    private int[] tilesNumber;
    private int[][] listOfTiles;
    private byte[] active;
    private int[] pomPosX;
    private int[] pomPosY;
    private int[] pomShowed;
    private int[] tilesOrder;
    private int[] markedTiles;
    private byte[] markedTilesType;
    private int[] hints;
    private int dealingSpeed;
    private int screen;
    private int updateCounter = 0;
    private int finishCounter;
    private int dealingCounter;
    private int nextModeCounter;
    private int marginXGrid;
    private int marginYGrid;
    private int gameMode;
    private int combos;
    private int comboTime;
    private int comboMultiplier;
    private int tilesCount;
    private int level;
    private int maxLayer;
    private int minPos;
    private int minPosX;
    private int maxPosX;
    private int minPosY;
    private int maxPosY;
    private int frameSelector;
    private int removedCursor;
    private long previousTime;
    private int autohintingTime;
    private int showedCursor;
    private int dealingCursor;
    private int loadingCounter = 0;
    private int particlesSpeed;
    private int timeBarDiff = 0;
    private int timeBarDiffxTimes = 0;
    private int usedUndo = 0;
    private int maxUndo = 0;
    private int maxTime = 0;
    private int playedTime = 0;
    private int timeBronze = 0;
    private int timeSilver = 0;
    private int timeGold = 0;
    private int medal = 0;
    private int bestMedal = 0;
    private int matches = 0;
    private int points = 0;
    private int score = 0;
    private int bestScore = 0;
    private int showedMatches = 0;
    private int showedUsedUndo = 0;
    private int showedTime = 0;
    private int showedTotalScore = 0;
    private int showedMedal = 0;
    private int seconds;
    private int xDialog;
    private int yDialog;
    private int wDialog;
    private int swDialog;
    private int rowsDialog;
    private int xBar;
    private int yBar;
    private int swBar;
    private int wBar;
    boolean isOutOfMoves;
    boolean isNoSolution;
    boolean isDialog;
    boolean isCombo;
    boolean isHint;
    boolean isCounting;
    boolean isUpdating;
    boolean isRemoving;
    boolean isFinished;
    boolean isPause;
    boolean isDealing;
    boolean isLoading;
    boolean loading = false;
    boolean bShadowTiles = true;
    boolean bPressedPause = false;
    boolean bPressedOk = false;
    boolean bPressedContinue = false;
    private int shadowTileLeftRight = 0;
    private int shadowTileUp = 0;
    private int shadowTileDown = 0;
    private int shiftLayerY = 0;
    private int handSpeed;
    private int handX;
    private int handY;
    private int handShiftX;
    private int handShiftY;
    private int frameHand;
    private Rectangle rectTextTutorial;
    private static PreparedText preparedTextTutorial;
    final byte TUTORIAL_LAYER1;
    final byte TUTORIAL_LAYER2;
    final byte TUTORIAL_LAYER3 = (byte)2;
    final byte TUTORIAL_LAYER4 = (byte)3;
    final byte TUTORIAL_LAYER5 = (byte)4;
    public int tutorialLayer;
    public int tutorialDialog;
    public int tutorialCounter;
    public int tutorialDelayCounter = 0;
    final byte RESULT_INIT;
    final byte RESULT_MATCHES;
    final byte RESULT_TOTAL_SCORE_1 = (byte)2;
    final byte RESULT_USED_UNDO = (byte)3;
    final byte RESULT_TOTAL_SCORE_2 = (byte)4;
    final byte RESULT_TIME = (byte)5;
    final byte RESULT_CUP = (byte)6;
    final byte RESULT_NEW_RECORD = (byte)7;
    final byte RESULT_END = (byte)8;
    private int resultStep = 0;
    private int resultMedalCounter = 0;
    String strMatches;
    String strUsedUndo;
    String strTime;
    String strTotalScore;
    String strRecord;
    String strNewRecord;
    String strCombo;
    boolean bNewRecord = false;
    boolean bNewRecordFlag = false;
    boolean isTotalCounting;
    boolean[] bPressedControl = new boolean[3];
    int iTopYIn;
    int iTopYOut;
    int iTopY;
    int iPlaygroundCenterY;
    int iDialogCenterY;
    int iDialogMaxWidth;
    int iDialogMaxHeight;
    int iTbShiftX = 0;
    int iTbShiftY = 0;
    int iTbWidth = 0;
    int iTbHeight = 0;
    int iTbX = 0;
    int iTbY = 0;
    int iTbTimeShiftLeft = 0;
    int iTbTimeShiftRight = 0;
    int iTbTimeShiftY = 0;
    int iTbTimeWidth = 0;
    int iTbTimeHeight = 0;
    int iTbTimeX = 0;
    int iTbTimeY = 0;
    int iTbTimeBronzeX = 0;
    int iTbTimeSilverX = 0;
    int iTbTimeGoldX = 0;
    int iTbTimePointerX = 0;
    int iTbTimeSegment = 0;
    int disapStep = 0;
    int[] disapTiles = new int[2];
    int[] flyingScoreStep = new int[10];
    int[] flyingScoreValue = new int[10];
    int[] flyingScoreCenterX = new int[10];
    int[] flyingScoreY = new int[10];
    boolean bNewStonesArrangement = true;
    static final Random randGenerator;
    int iNextScreenCounter = 0;
    int iTutorialUndoCounter = 0;
    boolean isNextTutorial = false;
    boolean bFinishDelay = false;

    static final int getRandomInt(int max) {
        return randGenerator.nextInt() % max;
    }

    static final int getRandomUInt(int max) {
        return Math.abs(randGenerator.nextInt() % max);
    }

    public ScreenGame(MainCanvas mainCanvas, int gameMode, int level, boolean bNewStonesArrangement) {
        this.SCREEN_GAME = 0;
        this.SCREEN_RESULT = 1;
        this.TUTORIAL_LAYER1 = 0;
        this.TUTORIAL_LAYER2 = 1;
        this.RESULT_INIT = 0;
        this.RESULT_MATCHES = 1;
        System.out.println("\n \nSCREEN GAME");
        this.mainCanvas = mainCanvas;
        this.gameMode = gameMode;
        this.level = level;
        this.bNewStonesArrangement = bNewStonesArrangement;
    }

    public void update(long lastRunLenght) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        this.updateTop();
        this.updateNextScreen();
        this.updateTimebar();
        switch (this.screen) {
            case 0: {
                if (this.isPause) break;
                ++this.updateCounter;
                if (!(this.isDealing || this.isFinished || this.isOutOfMoves || this.gameMode == 3 && (this.gameMode != 3 || this.isDialog))) {
                    if (Keys.isActionPressed(3) && !Keys.isActionPressed(4)) {
                        this.handLeft();
                    } else if (Keys.isActionPressed(4) && !Keys.isActionPressed(3)) {
                        this.handRight();
                    }
                    if (Keys.isActionPressed(1) && !Keys.isActionPressed(2)) {
                        this.handUp();
                    } else if (Keys.isActionPressed(2) && !Keys.isActionPressed(1)) {
                        this.handDown();
                    }
                }
                if (this.isDealing) {
                    this.updateDealing();
                } else {
                    if (this.gameMode == 3) {
                        this.updateTutorialMain(lastRunLenght);
                    } else if (!this.isFinished) {
                        if (!(this.isPause || this.isOutOfMoves || this.isDialog || this.removedCursor >= this.tilesCount)) {
                            this.updateTime();
                        }
                        this.checkGameCompleted();
                    } else {
                        this.updateFinish(lastRunLenght);
                    }
                    if (this.updateCounter % 2 == 0) {
                        this.frameSelector = (this.frameSelector + 1) % 4;
                    }
                }
                Particles.update();
                this.updateDisappearingTiles();
                this.updateFlyingScore();
                this.mainCanvas.repaint();
                break;
            }
            case 1: {
                if (this.isPause) break;
                ++this.updateCounter;
                if (this.isTotalCounting && !this.isCounting && !this.isUpdating) {
                    this.updateTotal(lastRunLenght);
                } else if (this.resultStep != 8) {
                    this.updateNextMode(lastRunLenght);
                }
                Particles.update();
                this.mainCanvas.repaint();
            }
        }
    }

    public void updateNextScreen() {
        if (this.iNextScreenCounter > 0) {
            --this.iNextScreenCounter;
            if (this.iNextScreenCounter <= 0) {
                this.iNextScreenCounter = 0;
                this.deactivatePressedControls();
                if (this.bPressedPause) {
                    this.bPressedPause = false;
                    if (this.gameMode != 3 && (this.isOutOfMoves || this.isNoSolution)) {
                        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 6, this.gameMode, this.level));
                        this.mainCanvas.repaint();
                    } else {
                        this.pause();
                    }
                } else if (this.bPressedOk) {
                    this.bPressedOk = false;
                    this.resultEnd();
                } else if (this.bPressedContinue) {
                    this.bPressedContinue = false;
                    if (this.screen == 0) {
                        this.pause();
                    } else if (this.screen == 1) {
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.MUSIC_RESULT, 1);
                    }
                }
            }
        }
    }

    public void updateTop() {
        int iTopShiftStepY = this.sprTopBg.getHeight() >> 2;
        if (iTopShiftStepY < 1) {
            iTopShiftStepY = 1;
        }
        if (this.screen == 0 || this.screen == 1) {
            if (this.iTopY != this.iTopYIn) {
                this.iTopY += iTopShiftStepY;
                if (this.iTopY > this.iTopYIn) {
                    this.iTopY = this.iTopYIn;
                }
            }
        } else if (this.iTopY != this.iTopYOut) {
            this.iTopY -= iTopShiftStepY;
            if (this.iTopY < this.iTopYOut) {
                this.iTopY = this.iTopYOut;
            }
        }
    }

    public void updateTimebar() {
        if (this.screen == 0) {
            this.iTbY = this.iTopY + (this.sprTopBg.getHeight() >> 2) - (this.iTbHeight >> 1) + (this.iTbShiftY >> 1);
            if (MainCanvas.WIDTH < 320 || MainCanvas.HEIGHT < 480) {
                this.iTbY -= this.iTbShiftY >> 2;
            }
            this.iTbTimeY = this.iTbY + (this.iTbHeight >> 1) - (this.iTbTimeHeight >> 1) - this.iTbTimeShiftY;
            this.iTbTimePointerX = this.iTbTimeX + this.iTbTimeWidth - this.playedTime / this.iTbTimeSegment;
            if (this.iTbTimePointerX < this.iTbTimeX) {
                this.iTbTimePointerX = this.iTbTimeX;
            }
        }
    }

    public void paint(Graphics g) {
        switch (this.screen) {
            case 0: {
                this.paintBg(g);
                this.paintControls(g);
                this.paintTiles(g);
                this.paintDealingTiles(g);
                this.paintHand(g);
                this.paintFlyingScore(g);
                this.paintStatusBar(g);
                if (!(this.gameMode == 3 && this.tutorialLayer == 4 && this.tutorialDialog == 2 || this.gameMode != 3 && this.isFinished)) {
                    Particles.paint(g);
                }
                this.paintDialogComplete(g);
                if ((this.gameMode != 3 || this.tutorialLayer != 4 || this.tutorialDialog != 2) && (this.gameMode == 3 || !this.isFinished)) break;
                Particles.paint(g);
                break;
            }
            case 1: {
                this.paintBg(g);
                this.paintControls(g);
                this.paintStatusBar(g);
                this.paintResultDialog(g);
                Particles.paint(g);
                break;
            }
        }
    }

    public void paintBg(Graphics g) {
        g.drawImage(this.imgBg, 0, 0, 20);
    }

    public void initTimebar() {
        this.iTbShiftX = this.sprTimebar.getWidth() * 1000 / 5222;
        this.iTbShiftY = this.sprTimebar.getHeight() * 1000 / 7833;
        this.iTbWidth = this.sprTimebar.getWidth() * 3;
        this.iTbHeight = this.sprTimebar.getHeight();
        this.iTbX = (MainCanvas.WIDTH >> 1) - (this.iTbWidth >> 1) - this.iTbShiftX;
        this.iTbY = this.iTopY + (this.sprTopBg.getHeight() >> 2) - (this.iTbHeight >> 1) + (this.iTbShiftY >> 1);
        if (MainCanvas.WIDTH < 320 || MainCanvas.HEIGHT < 480) {
            this.iTbY -= this.iTbShiftY >> 2;
        }
        this.iTbTimeShiftLeft = this.sprTimebar.getWidth() * 1000 / 1740;
        this.iTbTimeShiftRight = this.sprTimebar.getWidth() * 1000 / 2136;
        this.iTbTimeShiftY = this.sprTimebar.getHeight() * 1000 / 31333;
        this.iTbTimeWidth = this.iTbWidth - this.iTbTimeShiftLeft - this.iTbTimeShiftRight;
        this.iTbTimeHeight = this.sprTimebar.getHeight() * 1000 / 9400;
        this.iTbTimeX = this.iTbX + this.iTbTimeShiftLeft;
        this.iTbTimeY = this.iTbY + (this.iTbHeight >> 1) - (this.iTbTimeHeight >> 1) - this.iTbTimeShiftY;
        this.iTbTimeSegment = this.maxTime / this.iTbTimeWidth;
        this.iTbTimePointerX = this.iTbTimeX + this.iTbTimeWidth - this.playedTime / this.iTbTimeSegment;
        if (this.iTbTimePointerX < this.iTbTimeX) {
            this.iTbTimePointerX = this.iTbTimeX;
        }
        this.iTbTimeBronzeX = this.iTbTimeX + this.iTbTimeWidth - this.timeBronze / this.iTbTimeSegment - (this.sprMedalsSmall.getWidth() >> 1);
        this.iTbTimeSilverX = this.iTbTimeX + this.iTbTimeWidth - this.timeSilver / this.iTbTimeSegment - (this.sprMedalsSmall.getWidth() >> 1);
        this.iTbTimeGoldX = this.iTbTimeX + this.iTbTimeWidth - this.timeGold / this.iTbTimeSegment - (this.sprMedalsSmall.getWidth() >> 1);
    }

    public void paintStatusBar(Graphics g) {
        int yMid = this.yBar + (this.sprTopBg.getHeight() >> 1) - (this.sprTimebar.getHeight() >> 1);
        this.sprTopBg.setFrame(0);
        this.sprTopBg.setPosition(this.xBar, this.yBar);
        this.sprTopBg.paint(g);
        for (int posX = this.xBar + this.swBar; posX < this.xBar + this.wBar; posX += this.swBar) {
            this.sprTopBg.setFrame(1);
            this.sprTopBg.setPosition(posX, this.yBar);
            this.sprTopBg.paint(g);
        }
        this.sprTopBg.setFrame(2);
        this.sprTopBg.setPosition(this.xBar + this.wBar, this.yBar);
        this.sprTopBg.paint(g);
        if (this.screen == 0) {
            boolean bOk = true;
            if (this.gameMode == 3 && this.tutorialLayer == 1 && this.tutorialDialog >= 0 && this.tutorialDialog <= 2 && !this.isDealing && this.updateCounter % 20 < 10) {
                bOk = false;
            }
            if (bOk) {
                int sw = this.sprTimebar.getWidth();
                int x = this.xBar + (this.sprMedalsSmall.getWidth() << 1);
                int w = 24 * sw;
                if (MainCanvas.WIDTH < 176) {
                    w -= sw;
                }
                this.sprTimebar.setFrame(0);
                this.sprTimebar.setPosition(x, yMid);
                this.sprTimebar.paint(g);
                for (int posX = x + sw; posX < x + w; posX += sw) {
                    this.sprTimebar.setFrame(1);
                    this.sprTimebar.setPosition(posX, yMid);
                    this.sprTimebar.paint(g);
                }
                this.sprTimebar.setFrame(2);
                this.sprTimebar.setPosition(x + w, yMid);
                this.sprTimebar.paint(g);
                sw = this.sprTimebarFg.getWidth();
                int timeX = 24 * sw;
                if (!this.isFinished || !this.bPressedContinue) {
                    if (this.playedTime < this.maxTime && this.playedTime > 0) {
                        int oneSecDiff = this.wBar * 500 / (this.maxTime / 500) % 500;
                        this.timeBarDiff += oneSecDiff * this.seconds % 500;
                        if (this.timeBarDiff > 500) {
                            this.timeBarDiff %= 500;
                        }
                        this.seconds = this.playedTime / 500;
                        this.timebarX = this.wBar / (this.maxTime / 500) * this.seconds;
                        this.timeBarDiffxTimes = oneSecDiff * this.seconds / 500;
                        timeX -= this.timebarX + this.timeBarDiffxTimes;
                    } else {
                        timeX = this.playedTime == 0 ? w + sw : 0;
                    }
                }
                w = 24 * sw;
                if (MainCanvas.WIDTH < 176) {
                    w -= sw;
                }
                g.setClip(x, yMid, timeX, this.sprTimebarFg.getHeight());
                this.sprTimebarFg.setFrame(0);
                this.sprTimebarFg.setPosition(x, yMid);
                this.sprTimebarFg.paint(g);
                for (int posX = x + sw; posX < x + w - this.timebarX; posX += sw) {
                    this.sprTimebarFg.setFrame(1);
                    this.sprTimebarFg.setPosition(posX, yMid);
                    this.sprTimebarFg.paint(g);
                }
                this.sprTimebarFg.setFrame(2);
                this.sprTimebarFg.setPosition(x + w - this.timebarX, yMid);
                this.sprTimebarFg.paint(g);
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            }
            if (this.playedTime <= this.timeGold) {
                this.sprMedalsSmall.setFrame((int)GeneralDefs.MEDALS[3]);
                this.sprMedalsSmall.setPosition(this.xBar + (this.sprMedalsSmall.getWidth() >> 1), yMid + (this.sprTimebar.getHeight() >> 1) - (this.sprMedalsSmall.getHeight() >> 1));
                this.sprMedalsSmall.paint(g);
            } else if (this.playedTime <= this.timeSilver) {
                this.sprMedalsSmall.setFrame((int)GeneralDefs.MEDALS[2]);
                this.sprMedalsSmall.setPosition(this.xBar + (this.sprMedalsSmall.getWidth() >> 1), yMid + (this.sprTimebar.getHeight() >> 1) - (this.sprMedalsSmall.getHeight() >> 1));
                this.sprMedalsSmall.paint(g);
            } else if (this.playedTime <= this.timeBronze) {
                this.sprMedalsSmall.setFrame((int)GeneralDefs.MEDALS[1]);
                this.sprMedalsSmall.setPosition(this.xBar + (this.sprMedalsSmall.getWidth() >> 1), yMid + (this.sprTimebar.getHeight() >> 1) - (this.sprMedalsSmall.getHeight() >> 1));
                this.sprMedalsSmall.paint(g);
            }
            if (this.comboMultiplier > 1) {
                int iComboMultiplierCenterY = yMid + (this.sprTimebar.getHeight() >> 1) - (this.fontMainWhiteBlackBg.getHeight() >> 1);
                int iComboMultiplierX = this.xBar + this.wBar + this.swBar - (this.sprMedalsSmall.getWidth() >> 1);
                if (MainCanvas.WIDTH <= 240 || MainCanvas.HEIGHT == 240 && MainCanvas.WIDTH == 320) {
                    iComboMultiplierX += this.sprMedalsSmall.getWidth() >> 2;
                }
                String s = "X" + this.comboMultiplier;
                this.fontMainWhiteBlackBg.drawString(g, s.toCharArray(), iComboMultiplierX, iComboMultiplierCenterY, 24);
            }
        } else {
            int iX = MainCanvas.WIDTH >> 1;
            String sText = Resources.resTexts[0].getHashedString(17) + " " + (this.level + 1);
            int iCenterY = yMid + (this.sprTimebar.getHeight() >> 1) - (this.fontMainWhiteBlackBg.getHeight() >> 1);
            this.fontMainWhiteBlackBg.drawString(g, sText.toCharArray(), iX, iCenterY, 17);
        }
    }

    public void paintControls(Graphics g) {
        if (this.sprIcons != null) {
            switch (this.screen) {
                case 0: {
                    if (!this.isFinished) {
                        if (this.gameMode == 3) {
                            this.paintControl(g, 0, 6);
                            this.fontMainWhite.drawString(g, "*".toCharArray(), this.rectControls[1].x, this.rectControls[1].y, 24);
                            this.paintControl(g, 1, 2);
                        } else if (!this.isOutOfMoves) {
                            this.paintControl(g, 0, 6);
                            if (this.gameMode != 2) {
                                this.fontMainWhite.drawString(g, "*".toCharArray(), this.rectControls[1].x, this.rectControls[1].y, 24);
                                this.paintControl(g, 1, 2);
                                int shiftX = this.fontMainWhite.getSpaceWidth() >> 1;
                                if (shiftX < 2) {
                                    shiftX = 2;
                                }
                                this.fontMainWhite.drawString(g, "X".toCharArray(), this.rectControls[1].getRight() + shiftX, this.rectControls[1].getCenterY() - (this.fontMainWhite.getHeight() >> 1) - (this.fontMainWhite.getHeight() >> 3), 20);
                                shiftX += this.fontMainWhite.stringWidth("X".toCharArray()) + shiftX;
                                this.fontMainWhite.drawString(g, (this.maxUndo - this.usedUndo + "").toCharArray(), this.rectControls[1].getRight() + shiftX, this.rectControls[1].getCenterY() - (this.fontMainWhite.getHeight() >> 1) - (this.fontMainWhite.getHeight() >> 3), 20);
                            }
                        } else {
                            this.paintControl(g, 0, 8);
                            if (this.gameMode != 2 && !this.isNoSolution) {
                                this.fontMainWhite.drawString(g, "*".toCharArray(), this.rectControls[1].x, this.rectControls[1].y, 24);
                                this.paintControl(g, 1, 10);
                            }
                        }
                        if (this.gameMode != 3 && (this.isOutOfMoves || this.isNoSolution)) {
                            this.paintControl(g, 2, 4);
                            break;
                        }
                        this.paintControl(g, 2, 9);
                        break;
                    }
                    this.paintControl(g, 0, 6);
                    break;
                }
                case 1: {
                    if (this.resultStep != 8) break;
                    this.paintControl(g, 0, 6);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void paintControl(Graphics g, int id, int iconFrame) {
        boolean bActive;
        boolean bBlink;
        block30: {
            block31: {
                block32: {
                    block29: {
                        bBlink = false;
                        bActive = true;
                        if (id != 0) break block29;
                        bActive = true;
                        if (this.gameMode == 3) {
                            switch (this.tutorialLayer) {
                                case 3: {
                                    if (this.tutorialDialog != 2 && this.tutorialDialog != 3) break;
                                    bActive = false;
                                    break;
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                        break block30;
                    }
                    if (id != 1) break block31;
                    bBlink = false;
                    bActive = false;
                    if (this.gameMode != 3) break block32;
                    switch (this.tutorialLayer) {
                        case 3: {
                            if (this.tutorialDialog == 2) {
                                bBlink = true;
                                bActive = true;
                                break;
                            }
                            if (this.tutorialDialog != 3) break;
                            bActive = true;
                            break;
                        }
                    }
                    break block30;
                }
                if (!this.isOutOfMoves) {
                    if (this.gameMode != 2 && this.removedCursor < this.tilesCount && this.removedCursor >= 2 && this.usedUndo < this.maxUndo) {
                        bActive = true;
                    }
                    break block30;
                } else if (this.gameMode != 2 && !this.isNoSolution) {
                    bActive = true;
                }
                break block30;
            }
            if (id == 2) {
                bActive = true;
            }
        }
        if (id == 0 || id == 2) {
            if (!bActive) {
                this.sprButton.setFrame(0);
                this.sprButton.setPosition(this.rectControls[id].x, this.rectControls[id].y);
                this.sprButton.paint(g);
                this.sprIcons.setFrame(iconFrame);
                this.sprIcons.setPosition(this.rectControls[id].getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectControls[id].getCenterY() - (this.sprIcons.getHeight() >> 1));
                this.sprIcons.paint(g);
                return;
            }
            this.sprButton.setFrame(1);
            this.sprButton.setPosition(this.rectControls[id].x, this.rectControls[id].y);
            this.sprButton.paint(g);
            if (this.bPressedControl[id]) {
                this.sprButton.setFrame(1);
            } else {
                this.sprButton.setFrame(0);
            }
            this.sprButton.setPosition(this.rectControls[id].x, this.rectControls[id].y);
            this.sprButton.paint(g);
            if (this.bPressedControl[id]) {
                this.sprIcons.setFrame(iconFrame + 11);
            } else {
                this.sprIcons.setFrame(iconFrame);
            }
            this.sprIcons.setPosition(this.rectControls[id].getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectControls[id].getCenterY() - (this.sprIcons.getHeight() >> 1));
            this.sprIcons.paint(g);
            return;
        }
        if (id != 1) return;
        if (!bActive) {
            this.sprButton.setFrame(0);
            this.sprButton.setPosition(this.rectControls[id].x, this.rectControls[id].y);
            this.sprButton.paint(g);
            this.sprIcons.setFrame(iconFrame);
            this.sprIcons.setPosition(this.rectControls[id].getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectControls[id].getCenterY() - (this.sprIcons.getHeight() >> 1));
            this.sprIcons.paint(g);
            return;
        }
        if (bBlink) {
            if (this.updateCounter % 20 < 10) {
                this.sprButton.setFrame(0);
            } else if (!this.isDealing) {
                this.sprButton.setFrame(1);
            } else {
                this.sprButton.setFrame(0);
            }
            this.sprButton.setPosition(this.rectControls[id].x, this.rectControls[id].y);
            this.sprButton.paint(g);
            this.sprButton.setFrame(0);
            this.sprButton.setPosition(this.rectControls[id].x, this.rectControls[id].y);
            this.sprButton.paint(g);
            this.sprIcons.setFrame(iconFrame);
            this.sprIcons.setPosition(this.rectControls[id].getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectControls[id].getCenterY() - (this.sprIcons.getHeight() >> 1));
            this.sprIcons.paint(g);
            return;
        }
        this.sprButton.setFrame(1);
        this.sprButton.setPosition(this.rectControls[id].x, this.rectControls[id].y);
        this.sprButton.paint(g);
        if (this.bPressedControl[id]) {
            this.sprButton.setFrame(1);
        } else {
            this.sprButton.setFrame(0);
        }
        this.sprButton.setPosition(this.rectControls[id].x, this.rectControls[id].y);
        this.sprButton.paint(g);
        if (this.bPressedControl[id]) {
            this.sprIcons.setFrame(iconFrame + 11);
        } else {
            this.sprIcons.setFrame(iconFrame);
        }
        this.sprIcons.setPosition(this.rectControls[id].getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectControls[id].getCenterY() - (this.sprIcons.getHeight() >> 1));
        this.sprIcons.paint(g);
    }

    public void prepareTiles() {
        int i;
        this.tilesOrder = new int[this.tilesCount];
        int cursor = 0;
        int x = 0;
        byte y = 0;
        int maxLayerPom = 0;
        for (i = 0; i < this.tilesCount; ++i) {
            if (this.layers[i] <= maxLayerPom) continue;
            maxLayerPom = this.layers[i];
        }
        for (i = 0; i <= maxLayerPom; ++i) {
            for (int j = this.minPos; j <= this.maxPosX + this.maxPosY; ++j) {
                x = j;
                y = 0;
                while (x >= 0) {
                    for (int k = 0; k < this.tilesCount; ++k) {
                        if (this.layers[k] != i || this.posX[k] != x || this.posY[k] != y) continue;
                        this.tilesOrder[cursor] = k;
                        ++cursor;
                        break;
                    }
                    --x;
                    ++y;
                }
            }
        }
        for (i = cursor; i < this.tilesCount; ++i) {
            this.tilesOrder[i] = -128;
        }
    }

    public void paintTiles(Graphics g) {
        int x = 0;
        int y = 0;
        int newX = 0;
        int newY = 0;
        boolean bDisap = false;
        boolean selActive = false;
        for (int i = 0; i < this.tilesCount; ++i) {
            if (this.tilesOrder[i] != -128) {
                x = this.pomPosX[this.tilesOrder[i]];
                y = this.pomPosY[this.tilesOrder[i]];
                newX = x - this.shadowTileLeftRight;
                newY = y - this.shadowTileUp;
                bDisap = false;
                if (this.disapStep > 0) {
                    for (int j = 0; j < 2; ++j) {
                        if (this.disapTiles[j] != this.tilesOrder[i]) continue;
                        bDisap = true;
                    }
                }
                if (bDisap) {
                    this.sprStones.setFrame(1);
                    this.sprStones.setPosition(newX, newY);
                    this.sprStones.paint(g);
                } else if (this.showed[this.tilesOrder[i]] != -128 && (this.isDealing || this.tilesOrder[i] != this.hints[0] && this.tilesOrder[i] != this.hints[1] || (this.tilesOrder[i] == this.hints[0] || this.tilesOrder[i] == this.hints[1]) && this.updateCounter % 20 < 10) && x == this.showedPosX[this.tilesOrder[i]] && y == this.showedPosY[this.tilesOrder[i]]) {
                    this.sprStones.setFrame((int)this.stones[this.tilesOrder[i]]);
                    this.sprStones.setPosition(newX, newY);
                    this.sprStones.paint(g);
                    Sprite stonesTile = this.sprTilesDark;
                    if (this.sprStones.getFrame() == 1) {
                        stonesTile = this.sprTiles;
                    }
                    if (this.stones[this.tilesOrder[i]] != 0 && this.tiles[this.tilesOrder[i]] != -128) {
                        stonesTile.setFrame((int)this.tiles[this.tilesOrder[i]]);
                        stonesTile.setPosition(newX, newY);
                        stonesTile.paint(g);
                    }
                    if (!this.isDealing && (this.markedTiles[0] != -128 && this.tilesOrder[i] == this.markedTiles[0] || this.markedTiles[1] != -128 && this.tilesOrder[i] == this.markedTiles[1])) {
                        selActive = true;
                        this.sprStonesSelector.setFrame(this.frameSelector);
                        if (MainCanvas.HEIGHT == 480 && MainCanvas.WIDTH == 320) {
                            newY -= this.sprStones.getHeight() >> 5;
                        }
                        this.sprStonesSelector.setPosition(newX + (this.sprStones.getWidth() >> 1) - (this.sprStonesSelector.getWidth() >> 1), newY + (this.sprStones.getHeight() >> 1) - (this.sprStonesSelector.getHeight() >> 1));
                    }
                }
            }
            if (!selActive) continue;
            this.sprStonesSelector.paint(g);
        }
    }

    public void paintDealingTiles(Graphics g) {
        if (this.isDealing) {
            int x = 0;
            int y = 0;
            int newX = 0;
            int newY = 0;
            for (int i = 0; i < this.tilesCount; ++i) {
                if (this.tilesOrder[i] == -128 || this.showed[this.tilesOrder[i]] == -128) continue;
                x = this.pomPosX[this.tilesOrder[i]];
                y = this.pomPosY[this.tilesOrder[i]];
                newX = x - this.shadowTileLeftRight;
                newY = y - this.shadowTileUp;
                if (x == this.showedPosX[this.tilesOrder[i]] && y == this.showedPosY[this.tilesOrder[i]]) continue;
                this.sprStones.setFrame((int)this.stones[this.tilesOrder[i]]);
                this.sprStones.setPosition(newX, newY);
                this.sprStones.paint(g);
                Sprite stonesTile = this.sprTilesDark;
                if (this.sprStones.getFrame() == 1) {
                    stonesTile = this.sprTiles;
                }
                if (this.stones[this.tilesOrder[i]] == 0 || this.tiles[this.tilesOrder[i]] == -128) continue;
                stonesTile.setFrame((int)this.tiles[this.tilesOrder[i]]);
                stonesTile.setPosition(newX, newY);
                stonesTile.paint(g);
            }
        }
    }

    public void paintHand(Graphics g) {
        if (!this.isFinished) {
            this.sprHand.setFrame(this.frameHand);
            this.sprHand.setPosition(this.handX - this.handShiftX, this.handY - this.handShiftY);
            this.sprHand.paint(g);
        }
    }

    public void paintDialogComplete(Graphics g) {
        if (this.isDialog) {
            if (this.gameMode == 3) {
                if (!this.isDealing) {
                    this.paintDialog(g);
                    if (preparedTextTutorial != null) {
                        preparedTextTutorial.setTextOffsetY(-(this.rectTextTutorial.height - preparedTextTutorial.getTextHeight() >> 1));
                        preparedTextTutorial.drawText(g, this.rectTextTutorial, 17);
                    }
                }
            } else {
                this.paintDialog(g);
                if (preparedTextInfo != null) {
                    preparedTextInfo.setTextOffsetY(-(this.rectTextInfo.height - preparedTextInfo.getTextHeight() >> 1));
                    preparedTextInfo.drawText(g, this.rectTextInfo, 17);
                }
            }
        }
    }

    public void paintFlyingScore(Graphics g) {
        for (int i = 0; i < this.flyingScoreStep.length; ++i) {
            if (this.flyingScoreStep[i] <= 0) continue;
            this.fontMainWhiteBlackBg.drawString(g, (this.flyingScoreValue[i] + "").toCharArray(), this.flyingScoreCenterX[i], this.flyingScoreY[i], 17);
        }
    }

    public void paintDialog(Graphics g) {
        int posX;
        int y = this.yDialog;
        this.sprDialog.setFrame(0);
        this.sprDialog.setPosition(this.xDialog, y);
        this.sprDialog.paint(g);
        for (posX = this.xDialog + this.swDialog; posX < this.xDialog + this.wDialog; posX += this.swDialog) {
            this.sprDialog.setFrame(1);
            this.sprDialog.setPosition(posX, y);
            this.sprDialog.paint(g);
        }
        this.sprDialog.setFrame(2);
        this.sprDialog.setPosition(this.xDialog + this.wDialog, y);
        this.sprDialog.paint(g);
        y += this.sprDialog.getHeight();
        for (int row = 0; row < this.rowsDialog; ++row) {
            this.sprDialog.setFrame(3);
            this.sprDialog.setPosition(this.xDialog, y);
            this.sprDialog.paint(g);
            for (int posX2 = this.xDialog + this.swDialog; posX2 < this.xDialog + this.wDialog; posX2 += this.swDialog) {
                this.sprDialog.setFrame(4);
                this.sprDialog.setPosition(posX2, y);
                this.sprDialog.paint(g);
            }
            this.sprDialog.setFrame(5);
            this.sprDialog.setPosition(this.xDialog + this.wDialog, y);
            this.sprDialog.paint(g);
            y += this.sprDialog.getHeight();
        }
        this.sprDialog.setFrame(6);
        this.sprDialog.setPosition(this.xDialog, y);
        this.sprDialog.paint(g);
        for (posX = this.xDialog + this.swDialog; posX < this.xDialog + this.wDialog; posX += this.swDialog) {
            this.sprDialog.setFrame(7);
            this.sprDialog.setPosition(posX, y);
            this.sprDialog.paint(g);
        }
        this.sprDialog.setFrame(8);
        this.sprDialog.setPosition(this.xDialog + this.wDialog, y);
        this.sprDialog.paint(g);
    }

    public void paintResultDialog(Graphics g) {
        int TotalScoreY = this.resultTotalScoreY;
        int MedalY = this.resultMedalY;
        int RecordY = this.resultRecordY;
        int MatchesY = this.resultMatchesY;
        int UsedUndoY = this.resultUsedUndoY;
        int TimeY = this.resultTimeY;
        this.paintDialog(g);
        if (MainCanvas.HEIGHT == 220 && MainCanvas.WIDTH == 176) {
            TotalScoreY = this.resultTotalScoreY - this.sprDialog.getHeight() + (this.fontMainWhiteBlackBgSmall.getHeight() >> 1);
            MedalY = this.resultMedalY - this.sprDialog.getHeight() + (this.fontMainWhiteBlackBgSmall.getHeight() >> 1);
            RecordY = this.resultRecordY - this.sprDialog.getHeight() + (this.fontMainWhiteBlackBgSmall.getHeight() >> 1);
            MatchesY = this.resultMatchesY - this.sprDialog.getHeight();
            UsedUndoY = this.resultUsedUndoY - this.sprDialog.getHeight();
            TimeY = this.resultTimeY - this.sprDialog.getHeight();
        } else if (MainCanvas.HEIGHT <= 320 && MainCanvas.WIDTH <= 240) {
            TotalScoreY = this.resultTotalScoreY - this.sprDialog.getHeight();
            MedalY = this.resultMedalY - this.sprDialog.getHeight();
            RecordY = this.resultRecordY - this.sprDialog.getHeight();
            MatchesY = this.resultMatchesY - this.sprDialog.getHeight() - (this.fontMainWhiteBlackBgSmall.getHeight() >> 1);
            UsedUndoY = this.resultUsedUndoY - this.sprDialog.getHeight() - (this.fontMainWhiteBlackBgSmall.getHeight() >> 1);
            TimeY = this.resultTimeY - this.sprDialog.getHeight() - (this.fontMainWhiteBlackBgSmall.getHeight() >> 1);
        }
        int iCenterX = MainCanvas.WIDTH >> 1;
        this.fontMainWhiteBlackBg.drawString(g, (this.strTotalScore + " " + this.showedTotalScore).toCharArray(), iCenterX, TotalScoreY, 17);
        this.sprStarsDialog.setFrame((int)GeneralDefs.MEDALS[this.showedMedal]);
        this.sprStarsDialog.setPosition(iCenterX - (this.sprStarsDialog.getWidth() >> 1), MedalY);
        this.sprStarsDialog.paint(g);
        if (this.bNewRecord) {
            this.fontMainWhiteBlackBg.drawString(g, this.strNewRecord.toCharArray(), iCenterX, RecordY, 17);
        } else {
            this.fontMainWhiteBlackBg.drawString(g, (this.strRecord + " " + this.bestScore).toCharArray(), iCenterX, RecordY + (this.fontMainWhiteBlackBg.getHeight() >> 1) - (this.fontMainWhiteBlackBg.getHeight() >> 1), 17);
        }
        if (this.resultStep >= 1) {
            this.fontMainWhiteBlackBgSmall.drawString(g, (this.strMatches + " " + this.showedMatches).toCharArray(), iCenterX, MatchesY, 17);
        }
        if (this.gameMode != 2 && this.resultStep >= 3) {
            this.fontMainWhiteBlackBgSmall.drawString(g, (this.strUsedUndo + " " + this.showedUsedUndo).toCharArray(), iCenterX, UsedUndoY, 17);
        }
        if (this.resultStep >= 5) {
            int timeInSec = this.showedTime / 1000;
            int hrs = timeInSec / 3600;
            int min = (timeInSec -= hrs * 3600) / 60;
            int sec = timeInSec -= min * 60;
            String sHrs = hrs + "";
            String sMin = (min < 10 ? "0" : "") + min;
            String sSec = (sec < 10 ? "0" : "") + sec;
            String sTime = (hrs > 0 ? sHrs + ":" : "") + sMin + ":" + sSec;
            this.fontMainWhiteBlackBgSmall.drawString(g, (this.strTime + " " + sTime).toCharArray(), iCenterX, TimeY, 17);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (!(this.isLoading || this.isCounting || this.isUpdating)) {
            switch (this.screen) {
                case 0: {
                    if (Keys.isKeyPressed(-7)) {
                        if (this.isFinished) break;
                        this.bPressedPause = true;
                        this.activatePressedControl(2);
                        break;
                    }
                    if (Keys.isKeyPressed(-7) || this.isPause) break;
                    if (this.isDealing) {
                        if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6)) break;
                        this.activatePressedControl(0);
                        this.stopDealing();
                        break;
                    }
                    if (this.gameMode == 3) {
                        this.keyPressedTutorial(keyCode);
                        break;
                    }
                    this.keyPressedGame(keyCode);
                    break;
                }
                case 1: {
                    if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6) || this.isCounting || this.isUpdating) break;
                    this.next();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyPressedTutorial(int keyCode) {
        block34: {
            if (this.tutorialDelayCounter > 0 || this.isCounting || this.isRemoving || this.isNextTutorial) return;
            block0 : switch (this.tutorialLayer) {
                case 0: {
                    switch (this.tutorialDialog) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 5: {
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6)) return;
                            this.activatePressedControl(0);
                            this.nextTutorial();
                            return;
                        }
                        case 4: 
                        case 6: {
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6) || this.markedTiles[0] != -128 && this.markedTiles[1] != -128) return;
                            this.activatePressedControl(0);
                            this.markTile(this.handX, this.handY);
                            return;
                        }
                    }
                    return;
                }
                case 1: {
                    switch (this.tutorialDialog) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 4: {
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6)) return;
                            this.activatePressedControl(0);
                            this.nextTutorial();
                            return;
                        }
                        case 3: {
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6) || this.markedTiles[0] != -128 && this.markedTiles[1] != -128) return;
                            this.activatePressedControl(0);
                            this.markTile(this.handX, this.handY);
                            return;
                        }
                    }
                    return;
                }
                case 2: {
                    switch (this.tutorialDialog) {
                        case 0: {
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6)) return;
                            this.activatePressedControl(0);
                            this.nextTutorial();
                            return;
                        }
                        case 1: {
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6) || this.markedTiles[0] != -128 && this.markedTiles[1] != -128) return;
                            this.activatePressedControl(0);
                            this.markTile(this.handX, this.handY);
                            return;
                        }
                    }
                    return;
                }
                case 3: {
                    switch (this.tutorialDialog) {
                        case 2: {
                            if (!Keys.isKeyPressed(42)) return;
                            this.closeDialog();
                            this.tutorialDialog = 3;
                            this.initTutorialUndo();
                            return;
                        }
                        case 0: 
                        case 4: {
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6)) return;
                            this.activatePressedControl(0);
                            this.nextTutorial();
                            return;
                        }
                        case 1: 
                        case 5: {
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6) || this.markedTiles[0] != -128 && this.markedTiles[1] != -128) return;
                            this.activatePressedControl(0);
                            this.markTile(this.handX, this.handY);
                            return;
                        }
                        case 3: {
                            return;
                        }
                    }
                    return;
                }
                case 4: {
                    switch (this.tutorialDialog) {
                        case 0: {
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6)) return;
                            this.activatePressedControl(0);
                            this.nextTutorial();
                            break block34;
                        }
                        case 1: {
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6) || this.markedTiles[0] != -128 && this.markedTiles[1] != -128) return;
                            this.activatePressedControl(0);
                            this.markTile(this.handX, this.handY);
                            break block34;
                        }
                        case 2: {
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6)) return;
                            this.activatePressedControl(0);
                            if (this.finishCounter <= 100) return;
                            this.finishCounter = 100;
                            break block0;
                        }
                    }
                }
            }
        }
    }

    public void keyPressedGame(int keyCode) {
        if (this.isDialog && !this.isOutOfMoves) {
            if (Keys.isActionPressed(5) || Keys.isKeyPressed(-6)) {
                this.activatePressedControl(0);
                if (!this.isFinished) {
                    this.closeDialog();
                } else if (this.finishCounter > 100) {
                    this.finishCounter = 100;
                }
            }
        } else if (!this.isFinished && this.loadingCounter == 0) {
            if (!this.isOutOfMoves) {
                if ((Keys.isActionPressed(5) || Keys.isKeyPressed(-6)) && !this.isCounting && !this.isRemoving) {
                    this.activatePressedControl(0);
                    this.markTile(this.handX, this.handY);
                }
                if (Keys.isKeyPressed(42) && this.gameMode != 2 && this.removedCursor < this.tilesCount) {
                    this.undo();
                }
            } else {
                if (Keys.isKeyPressed(-6)) {
                    this.restart();
                }
                if (!this.isNoSolution && Keys.isKeyPressed(42) && this.gameMode != 2) {
                    this.shuffle();
                }
            }
        }
    }

    public void keyReleased(int keyCode) {
        this.frameHand = 0;
    }

    public void pointerPressed(int x, int y) {
    }

    public void initTutorialUndo() {
        this.activatePressedControl(1);
        this.iTutorialUndoCounter = 6;
    }

    public void updateTutorialUndo() {
        if (this.iTutorialUndoCounter > 0) {
            --this.iTutorialUndoCounter;
            if (this.iTutorialUndoCounter <= 0) {
                this.undo();
                this.initNextTutorial();
            } else {
                this.activatePressedControl(1);
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void pause() {
        this.isPause = true;
        this.saveGame();
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 7, this.gameMode, this.level));
        this.mainCanvas.repaint();
    }

    public void afterHide() {
        Resources.freeAllResources();
        MainCanvas.soundManager.Stop();
    }

    public void beforeShow() {
        this.isLoading = true;
        if (!this.mainCanvas.isInterrupted()) {
            MainCanvas.soundManager.Stop();
            if (this.gameMode != 3) {
                MainCanvas.soundManager.Play(Sounds.MUSIC_GAME1, -1);
            } else {
                MainCanvas.soundManager.Play(Sounds.MUSIC_GAME2, -1);
            }
        }
        Particles.resetParticles();
        Resources.loadText(0);
        Resources.loadGFonts(new int[]{0, 1, 3, 4});
        this.fontMainWhite = Resources.resGFonts[0];
        this.fontMainWhiteSmall = Resources.resGFonts[1];
        this.fontMainWhiteBlackBg = Resources.resGFonts[3];
        this.fontMainWhiteBlackBgSmall = Resources.resGFonts[4];
        Resources.loadImages(new int[]{3, 2});
        this.imgBg = Resources.resImgs[3];
        this.imgLogo = Resources.resImgs[2];
        Resources.loadSprites(new int[]{2, 17, 5, 6, 7, 20, 8, 9, 13, 14, 11, 16, 19});
        this.sprIcons = Resources.resSprs[2];
        this.sprMedalsSmall = Resources.resSprs[17];
        this.sprStonesSelector = Resources.resSprs[5];
        this.sprStones = Resources.resSprs[6];
        this.sprTiles = Resources.resSprs[7];
        this.sprTilesDark = Resources.resSprs[20];
        this.sprTimebar = Resources.resSprs[8];
        this.sprFirework = Resources.resSprs[9];
        this.sprDialog = Resources.resSprs[13];
        this.sprStarsDialog = Resources.resSprs[14];
        this.sprButton = Resources.resSprs[11];
        this.sprTopBg = Resources.resSprs[16];
        this.sprTimebarFg = Resources.resSprs[19];
        Resources.loadSprite(0);
        this.sprHand = Resources.resSprs[0];
        this.resultStep = 0;
        this.resultMedalCounter = 0;
        this.isPause = false;
        this.isUpdating = false;
        this.initParameters();
        this.initSpeeds();
        this.initFlyingScoreParameters();
        this.initTexts();
        if (this.loadGame()) {
            this.loadLevel();
            this.initTimes();
            this.calculateSavedGame();
            this.prepareTiles();
        } else {
            this.loadLevel();
            this.initTimes();
            this.calculateNewGame();
            this.prepareTiles();
            while (!this.checkLevel()) {
            }
            this.loading = false;
        }
        this.isLoading = false;
    }

    public void initParameters() {
        this.swDialog = this.sprDialog.getWidth();
        this.xDialog = (MainCanvas.WIDTH >> 1) - 7 * this.swDialog - (this.swDialog >> 1);
        this.yDialog = (MainCanvas.HEIGHT >> 1) - 6 * this.swDialog;
        this.wDialog = 14 * this.swDialog;
        this.rowsDialog = 15;
        if (MainCanvas.HEIGHT < 480 || MainCanvas.WIDTH < 480) {
            if (MainCanvas.HEIGHT >= 360 && MainCanvas.WIDTH >= 352 && MainCanvas.HEIGHT != 400) {
                if (MainCanvas.HEIGHT == 416) {
                    this.xDialog -= this.swDialog;
                    this.wDialog += this.swDialog << 1;
                }
            } else if (MainCanvas.HEIGHT < 320 || MainCanvas.WIDTH < 320) {
                if (MainCanvas.HEIGHT >= 224 && MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT != 260) {
                    this.rowsDialog = 13;
                    if (MainCanvas.HEIGHT >= 290 && MainCanvas.HEIGHT <= 310 && MainCanvas.WIDTH == 240) {
                        this.xDialog -= (this.swDialog << 1) + this.swDialog;
                        this.wDialog += (this.swDialog << 2) + (this.swDialog << 1);
                        this.rowsDialog += 5;
                        this.yDialog -= this.sprDialog.getHeight() + (this.sprDialog.getHeight() << 1);
                    } else if (MainCanvas.HEIGHT == 287 || MainCanvas.HEIGHT == 224) {
                        this.xDialog -= this.swDialog << 1;
                        this.wDialog += this.swDialog << 2;
                        this.rowsDialog += 4;
                        this.yDialog -= this.sprDialog.getHeight() << 1;
                    } else if (MainCanvas.HEIGHT == 348 || MainCanvas.HEIGHT == 400 || MainCanvas.HEIGHT == 432) {
                        this.yDialog += this.sprDialog.getHeight();
                        this.xDialog -= this.swDialog >> 1;
                        this.wDialog += this.swDialog;
                    } else if (MainCanvas.HEIGHT == 240 && MainCanvas.WIDTH == 320) {
                        this.xDialog -= this.swDialog << 1;
                        this.wDialog += this.swDialog << 2;
                        this.rowsDialog += 2;
                    }
                } else if (MainCanvas.HEIGHT >= 176 && MainCanvas.WIDTH >= 176) {
                    if (MainCanvas.WIDTH == 220) {
                        this.rowsDialog = 13;
                        this.xDialog += this.swDialog;
                        this.wDialog -= this.swDialog << 1;
                    } else if (MainCanvas.HEIGHT <= 208 && MainCanvas.HEIGHT >= 200) {
                        this.rowsDialog = 13;
                        this.xDialog -= this.swDialog << 1;
                        this.wDialog += this.swDialog << 2;
                    } else {
                        this.rowsDialog = 17;
                        this.xDialog -= this.swDialog << 1;
                        this.wDialog += this.swDialog << 2;
                        this.yDialog -= this.sprDialog.getHeight();
                    }
                } else if (MainCanvas.HEIGHT < 176 && MainCanvas.WIDTH < 176) {
                    this.rowsDialog = 11;
                    this.yDialog += this.sprDialog.getHeight();
                }
            }
        }
        this.swBar = this.sprTopBg.getWidth();
        this.xBar = (MainCanvas.WIDTH >> 1) - 10 * this.swBar;
        this.yBar = this.sprTopBg.getHeight();
        this.wBar = 19 * this.swBar;
        if (!(MainCanvas.HEIGHT >= 480 && MainCanvas.WIDTH >= 480 || MainCanvas.HEIGHT >= 360 && MainCanvas.WIDTH >= 352 && MainCanvas.HEIGHT != 400 || MainCanvas.HEIGHT >= 320 && MainCanvas.WIDTH >= 320)) {
            if (MainCanvas.HEIGHT >= 224 && MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT != 260) {
                this.yBar -= this.yBar >> 1;
            } else if (MainCanvas.HEIGHT >= 176 && MainCanvas.WIDTH >= 176) {
                this.yBar -= this.yBar >> 1;
            } else if (MainCanvas.HEIGHT < 176 && MainCanvas.WIDTH < 176) {
                this.wBar -= this.swBar << 1;
                this.xBar += this.swBar;
                this.yBar = this.yBar >> 1 >> 1;
            }
        }
        this.iTopYIn = 0;
        this.iTopY = this.iTopYOut = -this.sprTopBg.getHeight();
        this.iDialogCenterY = this.iPlaygroundCenterY = this.iTopYIn + this.sprTopBg.getHeight() + (MainCanvas.HEIGHT - this.iTopYIn - this.sprTopBg.getHeight() - this.sprButton.getHeight() >> 1);
        this.iDialogMaxWidth = this.wDialog;
        this.iDialogMaxHeight = this.rowsDialog * this.sprDialog.getHeight() + this.sprDialog.getHeight();
        this.rectDialog = new Rectangle((MainCanvas.WIDTH >> 1) - (this.sprDialog.getWidth() * 13 >> 1), this.iDialogCenterY - (this.sprDialog.getHeight() * 3 >> 1), this.sprDialog.getWidth() * 13, this.sprDialog.getHeight() * 3);
        this.deactivatePressedControls();
    }

    public void initTimes() {
        this.maxTime = this.tilesCount * 1000 * 6;
        switch (this.gameMode) {
            case 0: {
                this.maxTime += 12000;
                break;
            }
            case 1: {
                this.maxTime += 6000;
                break;
            }
            case 2: {
                break;
            }
        }
        this.timeBronze = this.maxTime;
        this.timeSilver = this.maxTime * 2 / 3;
        this.timeGold = this.maxTime / 3;
        this.initTimebar();
        this.initPreviousTime();
        this.maxUndo = this.tilesCount / 16;
        if (this.maxUndo < 3) {
            this.maxUndo = 3;
        } else if (this.maxUndo > 9) {
            this.maxUndo = 9;
        }
        this.bShadowTiles = true;
        switch (this.gameMode) {
            case 0: {
                this.maxUndo += 2;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.maxUndo = 0;
                this.bShadowTiles = false;
                break;
            }
        }
    }

    public void initTexts() {
        this.strCombo = Resources.resTexts[0].getHashedString(127);
        this.strMatches = Resources.resTexts[0].getHashedString(39);
        this.strUsedUndo = Resources.resTexts[0].getHashedString(40);
        this.strTime = Resources.resTexts[0].getHashedString(41);
        this.strTotalScore = Resources.resTexts[0].getHashedString(42);
        this.strRecord = Resources.resTexts[0].getHashedString(44);
        this.strNewRecord = Resources.resTexts[0].getHashedString(43);
    }

    public void initArrays() {
        int i;
        this.tiles = new byte[this.tilesCount];
        this.showed = new byte[this.tilesCount];
        this.removed = new int[this.tilesCount];
        this.stones = new byte[this.tilesCount];
        this.active = new byte[this.tilesCount];
        this.showedPosX = new int[this.tilesCount];
        this.showedPosY = new int[this.tilesCount];
        this.pomPosX = new int[this.tilesCount];
        this.pomPosY = new int[this.tilesCount];
        this.pomShowed = new int[this.tilesCount];
        this.tilesOrder = new int[this.tilesCount];
        this.markedTiles = new int[2];
        this.markedTilesType = new byte[2];
        this.hints = new int[2];
        for (i = 0; i < this.tilesCount; ++i) {
            this.tiles[i] = -128;
            this.showed[i] = 1;
            this.removed[i] = -128;
            this.stones[i] = -128;
            this.active[i] = -128;
            this.showedPosX[i] = -128;
            this.showedPosY[i] = -128;
            this.pomPosX[i] = -128;
            this.pomPosY[i] = -128;
            this.pomShowed[i] = -128;
            this.tilesOrder[i] = -128;
        }
        for (i = 0; i < 2; ++i) {
            this.markedTiles[i] = -128;
            this.markedTilesType[i] = -128;
            this.hints[i] = -128;
        }
    }

    public void initArrays2() {
        this.stones = new byte[this.tilesCount];
        this.active = new byte[this.tilesCount];
        this.showedPosX = new int[this.tilesCount];
        this.showedPosY = new int[this.tilesCount];
        this.pomPosX = new int[this.tilesCount];
        this.pomPosY = new int[this.tilesCount];
        this.pomShowed = new int[this.tilesCount];
        this.tilesOrder = new int[this.tilesCount];
        for (int i = 0; i < this.tilesCount; ++i) {
            this.stones[i] = -128;
            this.active[i] = -128;
            this.showedPosX[i] = -128;
            this.showedPosY[i] = -128;
            this.pomPosX[i] = -128;
            this.pomPosY[i] = -128;
            this.pomShowed[i] = -128;
            this.tilesOrder[i] = -128;
        }
    }

    public void initSpeeds() {
        this.handSpeed = this.sprStones.getWidth() / 4;
        if (this.handSpeed < 1) {
            this.handSpeed = 1;
        }
        this.dealingSpeed = MainCanvas.HEIGHT >= 800 ? 6 : (MainCanvas.HEIGHT >= 640 ? 5 : (MainCanvas.HEIGHT >= 480 ? 5 : (MainCanvas.HEIGHT >= 320 ? 4 : (MainCanvas.HEIGHT >= 220 ? 4 : 3))));
        this.particlesSpeed = MainCanvas.WIDTH / 6;
    }

    public void calculateSavedGame() {
        this.initArrays2();
        this.loadBestScore();
        this.calculateShiftLayer();
        this.calculateControls();
        this.calculateMinMaxPos();
        this.calculateMaxLayer();
        this.calculateShowedPos();
        this.calculateHand();
        if (this.gameMode == 3) {
            this.calculateTextTutorial();
            if (this.isDialog) {
                this.openDialog();
            }
            this.setStones();
            if (this.tutorialLayer == 0 && this.tutorialDialog == 0) {
                this.setInactiveStones();
                this.initTutorial();
            } else if (this.tutorialLayer == 1) {
                if (this.tutorialDialog == 0) {
                    this.setInactiveStones();
                }
                if (this.tutorialDialog == 3) {
                    this.initPreviousTime();
                }
            }
            this.inactiveLowerLayers();
        } else {
            this.isDialog = false;
        }
        if (this.comboMultiplier > 1) {
            this.isCombo = true;
        }
        this.initInfo();
        this.updateInfo();
        this.initHints();
        if (this.isFinished) {
            this.gameCompletedAfterPause();
        }
        this.initDealing();
    }

    public void calculateNewGame() {
        this.screen = 0;
        this.initArrays();
        this.loadBestScore();
        this.calculateShiftLayer();
        this.calculateControls();
        this.calculateMinMaxPos();
        this.calculateMaxLayer();
        this.calculateShowedPos();
        this.calculateHand();
        this.initGame(true);
        if (this.gameMode == 3) {
            this.score = 0;
            this.tutorialLayer = 0;
            this.tutorialDialog = 0;
            this.calculateTextTutorial();
            this.setInactiveStones();
            this.initTutorial();
            this.openDialog();
            this.inactiveLowerLayers();
        } else {
            this.isDialog = false;
        }
        this.initMarkedTiles();
        this.resetCombos();
        this.initInfo();
        this.updateInfo();
        this.initDealing();
    }

    public void calculateShiftLayer() {
        switch (this.sprStones.getHeight()) {
            case 16: {
                this.shadowTileLeftRight = 0;
                this.shadowTileUp = 0;
                this.shadowTileDown = -2;
                this.shiftLayerY = 2;
                break;
            }
            case 24: {
                this.shadowTileLeftRight = 0;
                this.shadowTileUp = 0;
                this.shadowTileDown = -1;
                this.shiftLayerY = 3;
                break;
            }
            case 34: {
                this.shadowTileLeftRight = 0;
                this.shadowTileUp = 0;
                this.shadowTileDown = 0;
                this.shiftLayerY = 3;
                break;
            }
            case 46: {
                this.shadowTileLeftRight = 0;
                this.shadowTileUp = 0;
                this.shadowTileDown = 0;
                this.shiftLayerY = 4;
                break;
            }
            case 52: {
                this.shadowTileLeftRight = 0;
                this.shadowTileUp = 0;
                this.shadowTileDown = 1;
                this.shiftLayerY = 5;
                break;
            }
            case 70: {
                this.shadowTileLeftRight = 1;
                this.shadowTileUp = 0;
                this.shadowTileDown = 1;
                this.shiftLayerY = 6;
                break;
            }
            default: {
                this.shadowTileLeftRight = 1;
                this.shadowTileUp = 0;
                this.shadowTileDown = 1;
                this.shiftLayerY = 6;
            }
        }
    }

    public void calculateTextTutorial() {
        int left = this.rectDialog.getCenterX() - (this.iDialogMaxWidth >> 1);
        int top = this.rectDialog.getCenterY() - (this.iDialogMaxHeight >> 1);
        top = (MainCanvas.HEIGHT >> 1) - 5 * this.sprDialog.getHeight();
        left = this.xDialog + (this.swDialog >> 1);
        top = this.yDialog + (this.sprDialog.getHeight() >> 1);
        this.rectTextTutorial = new Rectangle(left, top, this.iDialogMaxWidth, this.iDialogMaxHeight);
        preparedTextTutorial = new PreparedText(this.fontMainWhiteBlackBgSmall);
        this.updateTextTutorial();
    }

    public void updateTextTutorial() {
        String text = " ";
        block0 : switch (this.tutorialLayer) {
            case 0: {
                switch (this.tutorialDialog) {
                    case 0: {
                        text = Resources.resTexts[0].getHashedString(86);
                        break block0;
                    }
                    case 1: {
                        text = Resources.resTexts[0].getHashedString(87);
                        break block0;
                    }
                    case 2: {
                        text = Resources.resTexts[0].getHashedString(88);
                        break block0;
                    }
                    case 3: {
                        text = Resources.resTexts[0].getHashedString(89);
                        break block0;
                    }
                    case 5: {
                        text = Resources.resTexts[0].getHashedString(91);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.tutorialDialog) {
                    case 0: {
                        text = Resources.resTexts[0].getHashedString(92);
                        break block0;
                    }
                    case 1: {
                        text = Resources.resTexts[0].getHashedString(93);
                        break block0;
                    }
                    case 2: {
                        text = Resources.resTexts[0].getHashedString(94);
                        break block0;
                    }
                    case 4: {
                        if (RandomNum.getRandomUInt(2) == 0) {
                            text = Resources.resTexts[0].getHashedString(95);
                            break block0;
                        }
                        text = Resources.resTexts[0].getHashedString(96);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.tutorialDialog) {
                    case 0: {
                        text = Resources.resTexts[0].getHashedString(97);
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (this.tutorialDialog) {
                    case 0: {
                        text = Resources.resTexts[0].getHashedString(98);
                        break block0;
                    }
                    case 2: {
                        text = Resources.resTexts[0].getHashedString(99);
                        break block0;
                    }
                    case 4: {
                        if (MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT >= 320) {
                            text = Resources.resTexts[0].getHashedString(101);
                            break block0;
                        }
                        text = Resources.resTexts[0].getHashedString(1010);
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                switch (this.tutorialDialog) {
                    case 0: {
                        text = Resources.resTexts[0].getHashedString(102);
                        break block0;
                    }
                    case 2: {
                        text = Resources.resTexts[0].getHashedString(103);
                        break block0;
                    }
                }
            }
        }
        preparedTextTutorial.prepareText(text, this.iDialogMaxWidth - (this.iDialogMaxWidth >> 6));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateTutorialMain(long lTick) {
        if (this.tutorialDelayCounter > 0) {
            this.updateTutorialDelay();
            return;
        }
        block0 : switch (this.tutorialLayer) {
            case 0: {
                switch (this.tutorialDialog) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: {
                        this.updateTutorial(lTick);
                        return;
                    }
                }
                return;
            }
            case 1: {
                switch (this.tutorialDialog) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: {
                        this.updateTutorial(lTick);
                        return;
                    }
                    case 3: {
                        this.updateTime();
                        return;
                    }
                }
                return;
            }
            case 2: {
                switch (this.tutorialDialog) {
                    case 0: {
                        this.updateTutorial(lTick);
                        return;
                    }
                }
                return;
            }
            case 3: {
                switch (this.tutorialDialog) {
                    case 0: 
                    case 4: {
                        this.updateTutorial(lTick);
                        return;
                    }
                    case 3: {
                        this.updateTutorialUndo();
                        return;
                    }
                }
                return;
            }
            case 4: {
                switch (this.tutorialDialog) {
                    case 0: {
                        this.updateTutorial(lTick);
                        break block0;
                    }
                    case 2: {
                        if (!this.isFinished) return;
                        this.updateFinishTutorial(lTick);
                        break block0;
                    }
                }
            }
        }
    }

    public void initTutorial() {
        this.tutorialCounter = 12000;
    }

    public void initNextTutorial() {
        this.tutorialDelayCounter = 8;
    }

    public void updateTutorial(long lTick) {
        if (this.tutorialDelayCounter <= 0) {
            if (this.tutorialCounter > 0) {
                this.tutorialCounter = (int)((long)this.tutorialCounter - lTick);
            } else {
                this.nextTutorial();
            }
        }
    }

    public void updateTutorialDelay() {
        if (this.tutorialDelayCounter > 0) {
            --this.tutorialDelayCounter;
            if (this.tutorialDelayCounter <= 0) {
                this.nextTutorial();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void nextTutorial() {
        this.isNextTutorial = true;
        block0 : switch (this.tutorialLayer) {
            case 0: {
                switch (this.tutorialDialog) {
                    case 0: {
                        this.tutorialCounter = 0;
                        this.setStones();
                        ++this.tutorialDialog;
                        this.initTutorial();
                        this.updateTextTutorial();
                        this.openDialog();
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        ++this.tutorialDialog;
                        this.initTutorial();
                        this.updateTextTutorial();
                        break block0;
                    }
                    case 3: 
                    case 5: {
                        this.closeDialog();
                        ++this.tutorialDialog;
                        break block0;
                    }
                    case 4: {
                        ++this.tutorialDialog;
                        this.initTutorial();
                        this.updateTextTutorial();
                        this.openDialog();
                        break block0;
                    }
                    case 6: {
                        this.tutorialDialog = 0;
                        this.tutorialLayer = 1;
                        this.setInactiveStones();
                        this.initTutorial();
                        this.updateTextTutorial();
                        this.openDialog();
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.tutorialDialog) {
                    case 0: 
                    case 1: {
                        ++this.tutorialDialog;
                        this.initTutorial();
                        this.updateTextTutorial();
                        break block0;
                    }
                    case 2: {
                        this.closeDialog();
                        ++this.tutorialDialog;
                        this.setStones();
                        this.resetCombos();
                        this.initPreviousTime();
                        break block0;
                    }
                    case 3: {
                        ++this.tutorialDialog;
                        this.initTutorial();
                        this.updateTextTutorial();
                        this.openDialog();
                        break block0;
                    }
                    case 4: {
                        this.resetCombos();
                        this.tutorialDialog = 0;
                        this.tutorialLayer = 2;
                        this.setStones();
                        this.initTutorial();
                        this.updateTextTutorial();
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.tutorialDialog) {
                    case 0: {
                        this.closeDialog();
                        ++this.tutorialDialog;
                        break block0;
                    }
                    case 1: {
                        this.tutorialDialog = 0;
                        this.tutorialLayer = 3;
                        this.setStones();
                        this.initTutorial();
                        this.updateTextTutorial();
                        this.openDialog();
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (this.tutorialDialog) {
                    case 0: 
                    case 2: 
                    case 4: {
                        this.closeDialog();
                        ++this.tutorialDialog;
                        break;
                    }
                    case 1: 
                    case 3: {
                        ++this.tutorialDialog;
                        this.initTutorial();
                        this.updateTextTutorial();
                        this.openDialog();
                        break;
                    }
                    case 5: {
                        this.tutorialDialog = 0;
                        this.tutorialLayer = 4;
                        this.setStones();
                        this.updateTextTutorial();
                        this.openDialog();
                        break;
                    }
                }
                break;
            }
            case 4: {
                switch (this.tutorialDialog) {
                    case 0: {
                        this.closeDialog();
                        ++this.tutorialDialog;
                        break;
                    }
                    case 1: {
                        ++this.tutorialDialog;
                        this.initFinish();
                        this.updateTextTutorial();
                        this.initParticlesTutorial();
                        this.openDialog();
                        break;
                    }
                    case 2: {
                        if (this.finishCounter <= 100) break;
                        this.finishCounter = 100;
                    }
                }
                break;
            }
        }
        this.isNextTutorial = false;
    }

    public void updateFinishTutorial(long lTick) {
        if (this.finishCounter > 0) {
            this.finishCounter = (int)((long)this.finishCounter - lTick);
        } else {
            this.stopFinishTutorial();
        }
    }

    public void stopFinishTutorial() {
        this.deleteSavedGame();
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 1, 0, 0));
        this.mainCanvas.repaint();
    }

    public void initAutohinting() {
        this.autohintingTime = 15000;
    }

    public void calculateAutohinting() {
        if (this.autohintingTime > 0) {
            this.autohintingTime = (int)((long)this.autohintingTime - (System.currentTimeMillis() - this.previousTime));
        } else if (this.findHints()) {
            this.isHint = true;
        }
    }

    public boolean findHints() {
        for (int i = this.tilesCount - 1; i >= 0; --i) {
            if (this.active[i] == -128 || this.showed[i] == -128) continue;
            for (int j = this.tilesCount - 1; j >= 0; --j) {
                if (this.active[j] == -128 || this.showed[j] == -128 || i == j || !(this.getTilesType(i) == 0 && this.getTilesType(j) == 0 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 1 && this.getTilesType(j) == 1 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 2 && this.getTilesType(j) == 2 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 3 && this.getTilesType(j) == 3 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 4 && this.getTilesType(j) == 4 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 6 && this.getTilesType(j) == 6) && (this.getTilesType(i) != 5 || this.getTilesType(j) != 5)) continue;
                if (i != this.markedTiles[0] && i != this.markedTiles[1]) {
                    this.hints[0] = i;
                }
                if (j != this.markedTiles[0] && j != this.markedTiles[1]) {
                    this.hints[1] = j;
                }
                for (int k = 0; k < 2; ++k) {
                    if (i == this.markedTiles[k] || j == this.markedTiles[k] || this.markedTiles[k] == -128) continue;
                    this.markedTiles[k] = -128;
                }
                return true;
            }
        }
        return false;
    }

    public void initDealing() {
        int i;
        this.setInactiveStones();
        int stonesHalfWidth = this.sprStones.getWidth() - (this.shadowTileLeftRight << 1) >> 1;
        int initPosX = (MainCanvas.WIDTH >> 1) - (stonesHalfWidth >> 1);
        int initPosY = MainCanvas.HEIGHT;
        this.pomPosX = new int[this.tilesCount];
        this.pomPosY = new int[this.tilesCount];
        this.pomShowed = new int[this.tilesCount];
        for (i = 0; i < this.tilesCount; ++i) {
            this.pomPosX[i] = -128;
            this.pomPosY[i] = -128;
            this.pomShowed[i] = -128;
        }
        this.showedCursor = 0;
        if (this.bNewStonesArrangement) {
            for (i = 0; i < this.tilesCount; ++i) {
                if (this.showed[i] != -128) {
                    this.pomPosX[i] = initPosX;
                    this.pomPosY[i] = initPosY;
                    this.pomShowed[this.showedCursor] = i;
                    ++this.showedCursor;
                    continue;
                }
                this.pomPosX[i] = this.showedPosX[i];
                this.pomPosY[i] = this.showedPosY[i];
            }
            this.dealingCursor = 0;
            this.dealingCounter = 0;
            this.isDealing = true;
        } else {
            for (i = 0; i < this.tilesCount; ++i) {
                if (this.showed[i] != -128) {
                    this.pomShowed[this.showedCursor] = i;
                    ++this.showedCursor;
                }
                this.pomPosX[i] = this.showedPosX[i];
                this.pomPosY[i] = this.showedPosY[i];
            }
            this.isDealing = false;
            this.setStones();
        }
    }

    public void updateDealing() {
        if (this.showedCursor > 0) {
            for (int i = 0; i < this.dealingCursor; ++i) {
                if (this.pomPosX[this.pomShowed[i]] == this.showedPosX[this.pomShowed[i]] && this.pomPosY[this.pomShowed[i]] == this.showedPosY[this.pomShowed[i]]) continue;
                this.dda(this.pomShowed[i]);
            }
        }
        if (this.dealingCursor < this.showedCursor) {
            ++this.dealingCounter;
            if (this.dealingCounter % 3 == 0) {
                ++this.dealingCursor;
            }
        } else {
            boolean isOK = true;
            for (int i = 0; i < this.showedCursor; ++i) {
                if (this.pomPosX[this.pomShowed[i]] == this.showedPosX[this.pomShowed[i]] && this.pomPosY[this.pomShowed[i]] == this.showedPosY[this.pomShowed[i]]) continue;
                isOK = false;
                break;
            }
            if (isOK) {
                this.stopDealing();
            }
        }
    }

    public void stopDealing() {
        for (int i = 0; i < this.showedCursor; ++i) {
            this.pomPosX[this.pomShowed[i]] = this.showedPosX[this.pomShowed[i]];
            this.pomPosY[this.pomShowed[i]] = this.showedPosY[this.pomShowed[i]];
        }
        this.setStones();
        if (this.tutorialLayer == 1 && this.tutorialDialog == 0) {
            this.setInactiveStones();
        }
        this.initPreviousTime();
        if (this.gameMode != 3 && this.gameMode != 2) {
            this.initAutohinting();
        }
        if (this.gameMode != 3) {
            this.checkOutOfMoves();
        }
        this.isDealing = false;
    }

    public void resetCombos() {
        this.combos = 0;
        this.comboTime = 0;
        this.comboMultiplier = 1;
        this.isCombo = false;
    }

    public void openDialog() {
        this.isDialog = true;
    }

    public void closeDialog() {
        this.isDialog = false;
        this.initPreviousTime();
    }

    public void loadTutorialTiles() {
        this.tiles = new byte[this.tilesCount];
        for (int i = 0; i < this.tilesCount; ++i) {
            this.tiles[i] = LevelTutorial.tiles[i];
        }
    }

    public void beforeInteruption() {
        MainCanvas.soundManager.Stop();
        switch (this.screen) {
            case 0: {
                this.pause();
                break;
            }
            case 1: {
                this.isPause = true;
                this.saveGame();
                break;
            }
        }
    }

    public void afterInteruption() {
        this.isPause = false;
        if (!this.mainCanvas.isInterrupted()) {
            MainCanvas.soundManager.Stop();
            switch (this.screen) {
                case 0: {
                    if (this.gameMode != 3) {
                        MainCanvas.soundManager.Play(Sounds.MUSIC_GAME1, -1);
                        break;
                    }
                    MainCanvas.soundManager.Play(Sounds.MUSIC_GAME2, -1);
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    public void calculateHand() {
        this.handX = MainCanvas.WIDTH >> 1;
        this.handY = this.sprTopBg.getHeight() + (MainCanvas.HEIGHT - this.sprTopBg.getHeight() - this.sprButton.getHeight() >> 1);
        if (this.gameMode == 3) {
            this.handY -= this.shiftLayerY << 2;
        }
        this.handShiftX = this.sprHand.getWidth() - this.sprHand.getWidth() / 3;
        this.handShiftY = this.sprHand.getHeight() / 5;
        this.frameHand = 0;
    }

    public void handLeft() {
        this.handX = this.handX > (this.sprHand.getWidth() >> 4) + this.handSpeed ? (this.handX -= this.handSpeed) : MainCanvas.WIDTH + (this.sprHand.getWidth() >> 1);
    }

    public void handRight() {
        this.handX = this.handX < MainCanvas.WIDTH + (this.sprHand.getWidth() >> 1) + (this.sprHand.getWidth() >> 4) - this.handSpeed ? (this.handX += this.handSpeed) : this.sprHand.getWidth() >> 3;
    }

    public void handUp() {
        int maxY = 0;
        maxY = MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT >= 320 ? this.sprTopBg.getHeight() + (this.sprHand.getHeight() >> 1) + (this.sprHand.getHeight() >> 3) : (MainCanvas.HEIGHT > 160 ? this.sprTopBg.getHeight() + (this.sprHand.getHeight() >> 1) : this.sprTopBg.getHeight() + (this.sprHand.getHeight() >> 1) - (this.sprHand.getHeight() >> 3));
        this.handY = this.handY > maxY + this.handSpeed ? (this.handY -= this.handSpeed) : maxY;
    }

    public void handDown() {
        int minY = 0;
        minY = MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT >= 320 ? MainCanvas.HEIGHT - (this.sprButton.getHeight() + (this.sprHand.getHeight() >> 1) + (this.sprHand.getHeight() >> 2)) : (MainCanvas.HEIGHT > 160 ? MainCanvas.HEIGHT - (this.sprButton.getHeight() + (this.sprHand.getHeight() >> 1)) : MainCanvas.HEIGHT - (this.sprButton.getHeight() + (this.sprHand.getHeight() >> 1) - (this.sprHand.getHeight() >> 3)));
        this.handY = this.handY < minY - this.handSpeed ? (this.handY += this.handSpeed) : minY;
    }

    public void initPreviousTime() {
        this.previousTime = System.currentTimeMillis();
    }

    public void updateTime() {
        if (this.isCombo) {
            if (this.comboTime < 8000) {
                this.comboTime = (int)((long)this.comboTime + (System.currentTimeMillis() - this.previousTime));
            } else {
                this.isCombo = false;
                this.comboTime = 0;
                this.comboMultiplier = 1;
            }
        }
        if (this.gameMode != 3 && this.gameMode != 2 && !this.isHint) {
            this.calculateAutohinting();
        }
        int oldPlayedTime = this.playedTime;
        this.playedTime = (int)((long)this.playedTime + (System.currentTimeMillis() - this.previousTime));
        this.previousTime = System.currentTimeMillis();
        if (oldPlayedTime <= this.timeGold && this.playedTime > this.timeGold) {
            this.initParticlesTimebarStar();
        } else if (oldPlayedTime <= this.timeSilver && this.playedTime > this.timeSilver) {
            this.initParticlesTimebarStar();
        } else if (oldPlayedTime <= this.timeBronze && this.playedTime > this.timeBronze) {
            this.initParticlesTimebarStar();
        } else if (oldPlayedTime <= this.maxTime && this.playedTime > this.maxTime) {
            this.initParticlesTimebarStar();
        }
    }

    public void setTiles() {
        byte[] TILES_POM = new byte[this.tilesCount];
        for (int i = 0; i < this.tilesCount; ++i) {
            this.tiles[i] = -128;
            TILES_POM[i] = -128;
        }
        byte[] ID_COUNTS_FOR_TILE_TYPES = GameDefs.getIDCountsForTileTypes(this.gameMode, this.level);
        for (int c = 0; c < 7; ++c) {
            System.out.print(ID_COUNTS_FOR_TILE_TYPES[c] + ", ");
        }
        int cursor = 0;
        for (int i = 0; i < 7; ++i) {
            if (ID_COUNTS_FOR_TILE_TYPES[i] <= 0) continue;
            int pom = 0;
            switch (i) {
                case 0: 
                case 1: 
                case 2: {
                    pom = RandomNum.getRandomUInt(GameDefs.getTilesCountOfType(0));
                    break;
                }
                case 3: {
                    pom = RandomNum.getRandomUInt(GameDefs.getTilesCountOfType(3));
                    break;
                }
                case 4: {
                    pom = RandomNum.getRandomUInt(GameDefs.getTilesCountOfType(4));
                    break;
                }
                case 5: 
                case 6: {
                    pom = RandomNum.getRandomUInt(GameDefs.getTilesCountOfType(5));
                    break;
                }
            }
            int count = ID_COUNTS_FOR_TILE_TYPES[i] >> 1;
            for (int j = 0; j < count; ++j) {
                switch (i) {
                    case 0: {
                        TILES_POM[cursor] = (byte)(0 + pom);
                        TILES_POM[cursor + 1] = TILES_POM[cursor];
                        pom = (pom + 1) % GameDefs.getTilesCountOfType(0);
                        break;
                    }
                    case 1: {
                        TILES_POM[cursor] = (byte)(16 + pom);
                        TILES_POM[cursor + 1] = TILES_POM[cursor];
                        pom = (pom + 1) % GameDefs.getTilesCountOfType(1);
                        break;
                    }
                    case 2: {
                        TILES_POM[cursor] = (byte)(25 + pom);
                        TILES_POM[cursor + 1] = TILES_POM[cursor];
                        pom = (pom + 1) % GameDefs.getTilesCountOfType(2);
                        break;
                    }
                    case 3: {
                        TILES_POM[cursor] = (byte)(9 + pom);
                        TILES_POM[cursor + 1] = TILES_POM[cursor];
                        pom = (pom + 1) % GameDefs.getTilesCountOfType(3);
                        break;
                    }
                    case 4: {
                        TILES_POM[cursor] = (byte)(13 + pom);
                        TILES_POM[cursor + 1] = TILES_POM[cursor];
                        pom = (pom + 1) % GameDefs.getTilesCountOfType(4);
                        break;
                    }
                    case 5: {
                        TILES_POM[cursor] = (byte)(38 + (pom << 1));
                        TILES_POM[cursor + 1] = (byte)(TILES_POM[cursor] + 1);
                        pom = (pom + 1) % GameDefs.getTilesCountOfType(5);
                        break;
                    }
                    case 6: {
                        TILES_POM[cursor] = (byte)(34 + (pom << 1));
                        TILES_POM[cursor + 1] = (byte)(TILES_POM[cursor] + 1);
                        pom = (pom + 1) % GameDefs.getTilesCountOfType(6);
                        break;
                    }
                }
                cursor += 2;
            }
        }
        this.organizeTiles(TILES_POM);
    }

    public void markTile(int iPosX, int iPosY) {
        this.isCounting = true;
        this.calculateMaxLayer();
        int tileWidth = this.sprStones.getWidth() - (this.shadowTileLeftRight << 1);
        int tileHeight = this.sprStones.getHeight() - this.shiftLayerY - this.shadowTileUp - this.shadowTileDown;
        int id = -128;
        for (int i = this.maxLayer; i >= 0; --i) {
            for (int j = 0; j < this.tilesCount; ++j) {
                if (this.showed[j] == -128 || this.layers[j] != i || iPosX <= this.showedPosX[j] || iPosX >= this.showedPosX[j] + tileWidth || iPosY <= this.showedPosY[j] || iPosY >= this.showedPosY[j] + tileHeight) continue;
                if (this.active[j] != -128) {
                    id = j;
                }
                i = -128;
                j = this.tilesCount;
            }
        }
        if (id != -128) {
            if (this.hints[0] != -128 || this.hints[1] != -128) {
                if (id == this.hints[0]) {
                    this.hints[0] = -128;
                }
                if (id == this.hints[1]) {
                    this.hints[1] = -128;
                }
                if (this.hints[0] == -128 && this.hints[1] == -128 && this.isHint) {
                    this.isHint = false;
                }
            }
            this.frameHand = 1;
            byte markedTilesTypePom = this.getTilesType(id);
            if (this.markedTiles[0] == -128) {
                this.markedTiles[0] = id;
                this.markedTilesType[0] = markedTilesTypePom;
            } else if (id == this.markedTiles[0]) {
                this.markedTiles[0] = -128;
                this.markedTilesType[0] = -128;
            } else if (markedTilesTypePom == 0 || markedTilesTypePom == 1 || markedTilesTypePom == 2 || markedTilesTypePom == 3 || markedTilesTypePom == 4) {
                this.markedTiles[1] = id;
                if (this.tiles[this.markedTiles[1]] == this.tiles[this.markedTiles[0]]) {
                    this.removeTiles();
                } else {
                    this.markedTiles[0] = id;
                    this.markedTilesType[0] = this.getTilesType(id);
                    this.markedTiles[1] = -128;
                    this.markedTilesType[1] = -128;
                }
            } else if (markedTilesTypePom == 5 || markedTilesTypePom == 6) {
                if (this.markedTilesType[0] == markedTilesTypePom) {
                    this.markedTiles[1] = id;
                    this.removeTiles();
                } else {
                    this.markedTiles[0] = id;
                    this.markedTilesType[0] = this.getTilesType(id);
                    this.markedTiles[1] = -128;
                    this.markedTilesType[1] = -128;
                }
            }
            if (this.gameMode != 3 && this.gameMode != 2) {
                this.initAutohinting();
            }
        }
        this.isCounting = false;
    }

    public byte getTilesType(int id) {
        if (this.tiles[id] >= 0 && this.tiles[id] <= 8) {
            return 0;
        }
        if (this.tiles[id] >= 16 && this.tiles[id] <= 24) {
            return 1;
        }
        if (this.tiles[id] >= 25 && this.tiles[id] <= 33) {
            return 2;
        }
        if (this.tiles[id] >= 9 && this.tiles[id] <= 12) {
            return 3;
        }
        if (this.tiles[id] >= 13 && this.tiles[id] <= 15) {
            return 4;
        }
        if (this.tiles[id] >= 38 && this.tiles[id] <= 41) {
            return 5;
        }
        return 6;
    }

    public byte getTilesType(int id, byte[] POM) {
        if (POM[id] >= 0 && POM[id] <= 8) {
            return 0;
        }
        if (POM[id] >= 16 && POM[id] <= 24) {
            return 1;
        }
        if (POM[id] >= 25 && POM[id] <= 33) {
            return 2;
        }
        if (POM[id] >= 9 && POM[id] <= 12) {
            return 3;
        }
        if (POM[id] >= 13 && POM[id] <= 15) {
            return 4;
        }
        if (POM[id] >= 38 && POM[id] <= 41) {
            return 5;
        }
        return 6;
    }

    public void calculateMinMaxPos() {
        this.minPosX = this.posX[0];
        this.maxPosX = this.posX[0];
        this.minPosY = this.posY[0];
        this.maxPosY = this.posY[0];
        for (int i = 1; i < this.tilesCount; ++i) {
            if (this.posX[i] > this.maxPosX) {
                this.maxPosX = this.posX[i];
            }
            if (this.posX[i] < this.minPosX) {
                this.minPosX = this.posX[i];
            }
            if (this.posY[i] > this.maxPosY) {
                this.maxPosY = this.posY[i];
            }
            if (this.posY[i] >= this.minPosY) continue;
            this.minPosY = this.posY[i];
        }
        this.minPos = this.minPosX <= this.minPosY ? this.minPosX : this.minPosY;
    }

    public void calculateMaxLayer() {
        this.maxLayer = 0;
        for (int i = 0; i < this.tilesCount; ++i) {
            if (this.showed[i] == -128 || this.layers[i] <= this.maxLayer) continue;
            this.maxLayer = this.layers[i];
        }
    }

    public void calculateShowedPos() {
        int i;
        int i2;
        int stonesHalfWidth = this.sprStones.getWidth() - (this.shadowTileLeftRight << 1) >> 1;
        int stonesHalfHeight = this.sprStones.getHeight() - this.shiftLayerY - this.shadowTileUp - this.shadowTileDown >> 1;
        this.marginXGrid = MainCanvas.WIDTH - 10 * (stonesHalfWidth << 1) >> 1;
        this.marginYGrid = this.sprTopBg.getHeight() + (MainCanvas.HEIGHT - this.sprTopBg.getHeight() - this.sprButton.getHeight() - 8 * (stonesHalfHeight << 1) >> 1);
        this.showedPosX = new int[this.tilesCount];
        this.showedPosY = new int[this.tilesCount];
        for (i2 = 0; i2 < this.tilesCount; ++i2) {
            this.showedPosX[i2] = -128;
            this.showedPosY[i2] = -128;
        }
        for (i2 = 0; i2 < this.tilesCount; ++i2) {
            this.showedPosX[i2] = this.marginXGrid + this.posX[i2] * stonesHalfWidth;
            this.showedPosY[i2] = this.marginYGrid + this.posY[i2] * stonesHalfHeight - this.shiftLayerY * this.layers[i2];
        }
        int left = MainCanvas.WIDTH;
        int right = 0;
        int up = MainCanvas.HEIGHT;
        int down = 0;
        for (int i3 = 0; i3 < this.tilesCount; ++i3) {
            if (this.showedPosX[i3] < left) {
                left = this.showedPosX[i3];
            }
            if (this.showedPosX[i3] + this.sprStones.getWidth() > right) {
                right = this.showedPosX[i3] + this.sprStones.getWidth();
            }
            if (this.showedPosY[i3] < up) {
                up = this.showedPosY[i3];
            }
            if (this.showedPosY[i3] + this.sprStones.getHeight() <= down) continue;
            down = this.showedPosY[i3] + this.sprStones.getHeight();
        }
        int shiftX = 0;
        int shiftY = 0;
        int centerX = left + right >> 1;
        int centerY = up + down >> 1;
        int referCenterX = MainCanvas.WIDTH >> 1;
        int referCenterY = this.sprTopBg.getHeight() + (MainCanvas.HEIGHT - this.sprTopBg.getHeight() - this.sprButton.getHeight() >> 1);
        if (centerX != referCenterX) {
            shiftX = referCenterX - centerX;
        }
        if (centerY != referCenterY) {
            shiftY = referCenterY - centerY;
        }
        if (shiftX != 0) {
            i = 0;
            while (i < this.tilesCount) {
                int n = i++;
                this.showedPosX[n] = this.showedPosX[n] + shiftX;
            }
        }
        if (shiftY != 0) {
            i = 0;
            while (i < this.tilesCount) {
                int n = i++;
                this.showedPosY[n] = this.showedPosY[n] + shiftY;
            }
        }
    }

    public int getDistance(int a, int b) {
        if (a < b) {
            return b - a;
        }
        if (a > b) {
            return a - b;
        }
        return 0;
    }

    public void initMarkedTiles() {
        for (int i = 0; i < 2; ++i) {
            if (this.markedTiles[i] == -128) continue;
            this.markedTiles[i] = -128;
            this.markedTilesType[i] = -128;
        }
    }

    public void initHints() {
        this.initAutohinting();
        this.hints[0] = -128;
        this.hints[1] = -128;
        this.isHint = false;
    }

    public void updateDisappearingTiles() {
        if (this.disapStep > 0) {
            --this.disapStep;
        }
    }

    public void initDisappearing(int flyingScore) {
        int stonesHalfWidth = this.sprStones.getWidth() - (this.shadowTileLeftRight << 1) >> 1;
        int stonesHalfHeight = this.sprStones.getHeight() - this.shiftLayerY - this.shadowTileUp - this.shadowTileDown >> 1;
        this.disapStep = 5;
        for (int i = 0; i < 2; ++i) {
            this.disapTiles[i] = this.markedTiles[i];
            this.initParticlesRemoveTile(this.showedPosX[this.markedTiles[i]] + stonesHalfWidth, this.showedPosY[this.markedTiles[i]] + stonesHalfHeight);
            if (i != 1 || this.gameMode == 3) continue;
            this.initFlyingScore(flyingScore, this.showedPosX[this.markedTiles[i]] + stonesHalfWidth, this.showedPosY[this.markedTiles[i]] + stonesHalfHeight);
        }
        this.showed[this.markedTiles[0]] = -128;
        this.showed[this.markedTiles[1]] = -128;
        this.initMarkedTiles();
        this.setStones();
        if (this.gameMode == 3) {
            this.inactiveLowerLayers();
            if (this.tutorialLayer == 1 && this.tutorialDialog == 0) {
                this.setInactiveStones();
            }
        }
    }

    public void inactiveLowerLayers() {
        byte pom = 0;
        switch (this.tutorialLayer) {
            case 0: {
                pom = 4;
                break;
            }
            case 1: {
                pom = 3;
                break;
            }
            case 2: {
                pom = 2;
                break;
            }
            case 3: {
                pom = 1;
                break;
            }
        }
        if (pom > 0) {
            for (int i = 0; i < this.tilesCount; ++i) {
                if (this.layers[i] >= pom) continue;
                this.active[i] = -128;
                this.stones[i] = 2;
            }
        }
    }

    public void outOfMoves() {
        this.isOutOfMoves = true;
        if (this.gameMode == 2 || !this.existsSolution()) {
            this.isNoSolution = true;
        }
        this.initHints();
        this.updateInfo();
        this.openDialog();
    }

    public void noOutOfMoves() {
        this.closeDialog();
        this.isOutOfMoves = false;
        this.isNoSolution = false;
    }

    public void initFlyingScoreParameters() {
        for (int i = 0; i < this.flyingScoreStep.length; ++i) {
            this.flyingScoreStep[i] = 0;
            this.flyingScoreValue[i] = 0;
            this.flyingScoreCenterX[i] = 0;
            this.flyingScoreY[i] = 0;
        }
    }

    public void initFlyingScore(int score, int centerX, int centerY) {
        for (int i = 0; i < this.flyingScoreStep.length; ++i) {
            if (this.flyingScoreStep[i] > 0) continue;
            this.flyingScoreStep[i] = 1;
            this.flyingScoreValue[i] = score;
            this.flyingScoreCenterX[i] = centerX;
            this.flyingScoreY[i] = centerY - (this.fontMainWhite.getHeight() >> 1);
            break;
        }
    }

    public void updateFlyingScore() {
        for (int i = 0; i < this.flyingScoreStep.length; ++i) {
            if (this.flyingScoreStep[i] <= 0) continue;
            int n = i;
            this.flyingScoreY[n] = this.flyingScoreY[n] - (this.fontMainWhite.getHeight() >> 1);
            if (this.flyingScoreY[i] > -this.fontMainWhite.getHeight()) continue;
            this.flyingScoreStep[i] = 0;
            this.flyingScoreValue[i] = 0;
            this.flyingScoreCenterX[i] = 0;
            this.flyingScoreY[i] = 0;
        }
    }

    public void removeTiles() {
        this.isRemoving = true;
        this.removed[this.removedCursor] = this.markedTiles[0];
        this.removed[this.removedCursor + 1] = this.markedTiles[1];
        this.removedCursor += 2;
        this.initHints();
        if (!this.isCombo) {
            this.combos = 0;
            this.comboTime = 0;
            this.isCombo = true;
        } else {
            this.comboTime = 0;
            if (this.gameMode != 3) {
                ++this.combos;
            } else if (this.gameMode == 3 && this.tutorialLayer == 1 && this.tutorialDialog == 3) {
                if (this.removedCursor == 10) {
                    this.combos += 2;
                } else if (this.removedCursor == 12) {
                    this.combos += 2;
                }
            }
            if (this.combos == 2) {
                this.combos = 0;
                ++this.comboMultiplier;
            }
        }
        if (this.gameMode == 3) {
            switch (this.tutorialLayer) {
                case 0: {
                    if ((this.tutorialDialog != 4 || this.removedCursor != 2) && (this.tutorialDialog != 6 || this.removedCursor != 6)) break;
                    this.initNextTutorial();
                    break;
                }
                case 1: {
                    if (this.tutorialDialog != 3 || this.removedCursor != 12) break;
                    this.initNextTutorial();
                    break;
                }
                case 2: {
                    if (this.tutorialDialog != 1 || this.removedCursor != 16) break;
                    this.initNextTutorial();
                    break;
                }
                case 3: {
                    if ((this.tutorialDialog != 1 || this.removedCursor != 18) && (this.tutorialDialog != 5 || this.removedCursor != 20)) break;
                    this.initNextTutorial();
                    break;
                }
                case 4: {
                    if (this.tutorialDialog != 1 || this.removedCursor != 26) break;
                    this.initNextTutorial();
                    break;
                }
            }
        }
        int newScore = 100 * this.comboMultiplier;
        ++this.matches;
        this.points += newScore;
        this.initDisappearing(newScore);
        if (this.gameMode != 3) {
            this.checkOutOfMoves();
        }
        this.isRemoving = false;
    }

    public void createParticles(int mX, int mY, int mBaseLife, int mLife, int mCount) {
        int mVelX = this.particlesSpeed;
        int mVelY = this.particlesSpeed;
        int velX = 0;
        int velY = 0;
        for (int i = 0; i < mCount; ++i) {
            int life = mBaseLife + RandomNum.getRandomUInt(mLife);
            int randFrame = RandomNum.getRandomUInt(12);
            if (i < mCount >> 2) {
                velX = RandomNum.getRandomUInt(mVelX);
                velY = RandomNum.getRandomUInt(mVelY);
            } else if (i < mCount >> 1) {
                velX = -RandomNum.getRandomUInt(mVelX);
                velY = RandomNum.getRandomUInt(mVelY);
            } else if (i < (mCount >> 1) + (mCount >> 2)) {
                velX = -RandomNum.getRandomUInt(mVelX);
                velY = -RandomNum.getRandomUInt(mVelY);
            } else {
                velX = RandomNum.getRandomUInt(mVelX);
                velY = -RandomNum.getRandomUInt(mVelY);
            }
            Particles.createParticle(mX, mY, velX, velY, 0, 0, this.sprFirework, randFrame, life);
        }
    }

    public void initParticlesTutorial() {
        this.createParticles(MainCanvas.WIDTH >> 1, this.rectDialog.getCenterY(), 5, 25, 40);
    }

    public void initParticlesMedal() {
        this.createParticles(MainCanvas.WIDTH >> 1, this.resultMedalY + (this.sprStarsDialog.getHeight() >> 1), 5, 25, 40);
    }

    public void initParticlesNewRecord() {
        this.createParticles(MainCanvas.WIDTH >> 1, this.resultRecordY + (this.fontMainWhite.getHeight() >> 1), 5, 25, 40);
    }

    public void initParticlesFinish() {
        this.createParticles(MainCanvas.WIDTH >> 1, this.rectDialog.getCenterY(), 5, 25, 40);
    }

    public void initParticlesRemoveTile(int x, int y) {
        this.createParticles(x, y, 5, 10, 30);
    }

    public void initParticlesTimebarStar() {
        this.createParticles(this.iTbX + (this.sprMedalsSmall.getWidth() >> 1), this.iTbY + (this.sprMedalsSmall.getHeight() >> 1), 5, 10, 30);
    }

    public void resetPoints(boolean bResetPlayedTime) {
        if (bResetPlayedTime) {
            this.playedTime = 0;
        }
        this.matches = 0;
        this.points = 0;
        this.score = 0;
        this.medal = 0;
        this.usedUndo = 0;
        this.showedMatches = 0;
        this.showedUsedUndo = 0;
        this.showedTime = 0;
        this.showedTotalScore = 0;
        this.showedMedal = 0;
        this.bNewRecord = false;
        this.bNewRecordFlag = false;
    }

    public void gameCompletedAfterPause() {
        if (this.gameMode == 3 && this.tutorialLayer == 4 && this.tutorialDialog > 0) {
            this.initFinish();
        }
        this.loadBestScore();
        this.calculateTexts();
        this.calculateControls();
        this.isTotalCounting = false;
        this.initNextResultStep();
    }

    public void initNextResultStep() {
        this.nextModeCounter = 200;
    }

    public void updateNextMode(long lTick) {
        if (this.nextModeCounter > 0) {
            this.nextModeCounter = (int)((long)this.nextModeCounter - lTick);
        } else {
            this.initNextResultStep();
            this.nextResultStep();
        }
    }

    public void initFinish() {
        this.isFinished = true;
        this.finishCounter = 9600;
    }

    public void updateFinish(long lTick) {
        if (this.finishCounter > 0) {
            this.finishCounter = (int)((long)this.finishCounter - lTick);
        } else if (!this.bFinishDelay) {
            this.closeDialog();
            Particles.resetParticles();
            this.showedMatches = 0;
            this.showedUsedUndo = 0;
            this.showedTime = 0;
            this.showedTotalScore = 0;
            this.showedMedal = this.bestMedal > 0 ? this.bestMedal : 0;
            this.saveGame();
            this.bFinishDelay = true;
        } else if (this.bFinishDelay) {
            this.gameCompletedAfterPause();
            this.nextScreen(1);
        }
    }

    public void nextScreen(int nextScreen) {
        this.screen = nextScreen;
        switch (this.screen) {
            case 0: {
                break;
            }
            case 1: {
                if (this.mainCanvas.isInterrupted()) break;
                MainCanvas.soundManager.Stop();
                MainCanvas.soundManager.Play(Sounds.MUSIC_RESULT, 1);
                break;
            }
        }
    }

    public void checkGameCompleted() {
        if (this.removedCursor == this.tilesCount) {
            this.initFinish();
            Particles.resetParticles();
            this.updateInfo();
            this.openDialog();
            this.initParticlesFinish();
        }
    }

    public void checkOutOfMoves() {
        if (!this.existsMoves() && !this.isFinished && this.removedCursor < this.tilesCount) {
            this.outOfMoves();
        } else {
            this.noOutOfMoves();
        }
    }

    public void setInactiveStones() {
        for (int i = 0; i < this.tilesCount; ++i) {
            this.active[i] = -128;
            this.stones[i] = 2;
        }
    }

    public void setStones() {
        for (int i = 0; i < this.tilesCount; ++i) {
            int k;
            int j;
            this.active[i] = 1;
            this.stones[i] = 1;
            boolean isLeft = false;
            boolean isRight = false;
            for (j = 0; j < this.tilesCount; ++j) {
                if (this.showed[j] == -128 || this.layers[j] != this.layers[i]) continue;
                for (k = 0; k < 3; ++k) {
                    if (this.posX[j] == this.posX[i] - 2 && this.posY[j] == this.posY[i] - 1 + k && !isLeft) {
                        isLeft = true;
                    }
                    if (this.posX[j] != this.posX[i] + 2 || this.posY[j] != this.posY[i] - 1 + k || isRight) continue;
                    isRight = true;
                }
            }
            if (isLeft && isRight) {
                this.active[i] = -128;
                if (this.gameMode == 3 || this.bShadowTiles && this.gameMode != 2) {
                    this.stones[i] = 2;
                }
            }
            if (this.layers[i] >= 12) continue;
            for (j = 0; j < this.tilesCount; ++j) {
                if (this.showed[j] == -128 || this.layers[j] != this.layers[i] + 1) continue;
                for (k = 0; k < 3; ++k) {
                    for (int l = 0; l < 3; ++l) {
                        if (this.posX[j] != this.posX[i] - 1 + k || this.posY[j] != this.posY[i] - 1 + l) continue;
                        this.active[i] = -128;
                        if (this.gameMode != 3 && (!this.bShadowTiles || this.gameMode == 2)) continue;
                        this.stones[i] = 2;
                    }
                }
            }
        }
        if (this.gameMode == 3) {
            this.inactiveLowerLayers();
        }
    }

    public void organizeTiles(byte[] TILES_POM) {
        int cursor = 0;
        for (int i = 0; i < this.tilesCount >> 1; ++i) {
            int rand1 = RandomNum.getRandomUInt(this.tilesCount >> 1) << 1;
            while (TILES_POM[rand1] == -128) {
                rand1 = (rand1 + 2) % this.tilesCount;
            }
            int rand2 = rand1 + 1;
            if (rand2 == this.tilesCount) {
                rand2 = 0;
            }
            this.tiles[cursor] = TILES_POM[rand1];
            this.tiles[cursor + 1] = TILES_POM[rand2];
            cursor += 2;
            TILES_POM[rand1] = -128;
            TILES_POM[rand2] = -128;
        }
    }

    public boolean existsMoves() {
        int i;
        int activeCount = 0;
        for (i = 0; i < this.tilesCount; ++i) {
            if (this.active[i] == -128 || this.showed[i] == -128) continue;
            ++activeCount;
        }
        if (activeCount <= 1) {
            return false;
        }
        for (i = 0; i < this.tilesCount; ++i) {
            if (this.active[i] == -128 || this.showed[i] == -128) continue;
            for (int j = 0; j < this.tilesCount; ++j) {
                if (this.active[j] == -128 || this.showed[j] == -128 || i == j || !(this.getTilesType(i) == 0 && this.getTilesType(j) == 0 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 1 && this.getTilesType(j) == 1 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 2 && this.getTilesType(j) == 2 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 3 && this.getTilesType(j) == 3 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 4 && this.getTilesType(j) == 4 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 6 && this.getTilesType(j) == 6) && (this.getTilesType(i) != 5 || this.getTilesType(j) != 5)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existsSolution() {
        int i;
        int activeCount = 0;
        for (i = 0; i < this.tilesCount; ++i) {
            if (this.active[i] == -128 || this.showed[i] == -128) continue;
            ++activeCount;
        }
        if (activeCount <= 1) {
            return false;
        }
        for (i = 0; i < this.tilesCount; ++i) {
            if (this.showed[i] == -128) continue;
            for (int j = 0; j < this.tilesCount; ++j) {
                if (this.showed[j] == -128 || i == j || !(this.getTilesType(i) == 0 && this.getTilesType(j) == 0 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 1 && this.getTilesType(j) == 1 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 2 && this.getTilesType(j) == 2 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 3 && this.getTilesType(j) == 3 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 4 && this.getTilesType(j) == 4 && this.tiles[i] == this.tiles[j] || this.getTilesType(i) == 6 && this.getTilesType(j) == 6) && (this.getTilesType(i) != 5 || this.getTilesType(j) != 5)) continue;
                return true;
            }
        }
        return false;
    }

    public void activatePressedControl(int id) {
        this.bPressedControl[id] = true;
        this.iNextScreenCounter = 3;
    }

    public void deactivatePressedControls() {
        for (int i = 0; i < this.bPressedControl.length; ++i) {
            if (!this.bPressedControl[i]) continue;
            this.bPressedControl[i] = false;
        }
    }

    public void undo() {
        ++this.loadingCounter;
        if (this.removedCursor >= 2 && this.usedUndo < this.maxUndo) {
            if (this.gameMode != 3) {
                this.activatePressedControl(1);
            }
            ++this.usedUndo;
            this.initMarkedTiles();
            this.initHints();
            this.resetCombos();
            int newScore = -200;
            this.points += newScore;
            if (this.points < 0) {
                this.points = 0;
            }
            if (this.matches > 0) {
                --this.matches;
            }
            this.showed[this.removed[this.removedCursor - 1]] = 1;
            this.showed[this.removed[this.removedCursor - 2]] = 1;
            this.removed[this.removedCursor - 1] = -128;
            this.removed[this.removedCursor - 2] = -128;
            this.removedCursor -= 2;
            this.calculateMaxLayer();
            this.setStones();
            if (this.gameMode != 3) {
                this.initFlyingScore(newScore, this.rectControls[1].getCenterX(), this.rectControls[1].getCenterY());
                if (!this.existsMoves()) {
                    this.outOfMoves();
                } else {
                    this.noOutOfMoves();
                }
            }
        }
        --this.loadingCounter;
    }

    public void shuffle() {
        int i;
        int i2;
        ++this.loadingCounter;
        this.activatePressedControl(1);
        this.initMarkedTiles();
        this.initHints();
        this.resetCombos();
        int showedCursor = 0;
        int pairedCursor = 0;
        byte[] TILES_showed = new byte[this.tilesCount];
        byte[] TILES_PAIRED = new byte[this.tilesCount];
        for (i2 = 0; i2 < this.tilesCount; ++i2) {
            TILES_showed[i2] = -128;
            TILES_PAIRED[i2] = -128;
        }
        for (i2 = 0; i2 < this.tilesCount; ++i2) {
            if (this.showed[i2] == -128) continue;
            TILES_showed[showedCursor] = this.tiles[i2];
            ++showedCursor;
            this.tiles[i2] = -128;
        }
        block2: for (i2 = 0; i2 < showedCursor; ++i2) {
            if (TILES_showed[i2] == -128) continue;
            for (int j = 0; j < showedCursor; ++j) {
                if (TILES_showed[j] == -128 || i2 == j || !(this.getTilesType(i2, TILES_showed) == 0 && this.getTilesType(j, TILES_showed) == 0 && TILES_showed[i2] == TILES_showed[j] || this.getTilesType(i2, TILES_showed) == 1 && this.getTilesType(j, TILES_showed) == 1 && TILES_showed[i2] == TILES_showed[j] || this.getTilesType(i2, TILES_showed) == 2 && this.getTilesType(j, TILES_showed) == 2 && TILES_showed[i2] == TILES_showed[j] || this.getTilesType(i2, TILES_showed) == 3 && this.getTilesType(j, TILES_showed) == 3 && TILES_showed[i2] == TILES_showed[j] || this.getTilesType(i2, TILES_showed) == 4 && this.getTilesType(j, TILES_showed) == 4 && TILES_showed[i2] == TILES_showed[j] || this.getTilesType(i2, TILES_showed) == 6 && this.getTilesType(j, TILES_showed) == 6) && (this.getTilesType(i2, TILES_showed) != 5 || this.getTilesType(j, TILES_showed) != 5)) continue;
                TILES_PAIRED[pairedCursor] = TILES_showed[i2];
                TILES_PAIRED[pairedCursor + 1] = TILES_showed[j];
                pairedCursor += 2;
                TILES_showed[i2] = -128;
                TILES_showed[j] = -128;
                continue block2;
            }
        }
        for (i2 = 0; i2 < showedCursor; ++i2) {
            if (TILES_showed[i2] == -128) continue;
            TILES_PAIRED[pairedCursor] = TILES_showed[i2];
            ++pairedCursor;
            TILES_showed[i2] = -128;
        }
        int pomPairedCursor = 0;
        for (i = this.tilesCount - 1; i >= 0; --i) {
            if (this.showed[i] == -128 || this.tiles[i] != -128 || this.active[i] == -128) continue;
            this.tiles[i] = TILES_PAIRED[pomPairedCursor];
            TILES_PAIRED[pomPairedCursor] = -128;
            ++pomPairedCursor;
        }
        for (i = this.tilesCount - 1; i >= 0; --i) {
            if (this.showed[i] == -128 || this.tiles[i] != -128 || this.active[i] != -128) continue;
            this.tiles[i] = TILES_PAIRED[pomPairedCursor];
            TILES_PAIRED[pomPairedCursor] = -128;
            ++pomPairedCursor;
        }
        this.calculateMaxLayer();
        this.setStones();
        if (!this.existsMoves()) {
            this.shuffle();
        } else {
            this.noOutOfMoves();
        }
        --this.loadingCounter;
    }

    public void restart() {
        ++this.loadingCounter;
        this.activatePressedControl(0);
        this.initGame(true);
        this.isPause = false;
        this.closeDialog();
        this.initMarkedTiles();
        this.resetCombos();
        this.initInfo();
        this.updateInfo();
        this.prepareTiles();
        this.initDealing();
        --this.loadingCounter;
    }

    public void initGame(boolean bResetPlayedTime) {
        this.isDialog = false;
        this.isOutOfMoves = false;
        this.isNoSolution = false;
        this.isCounting = false;
        this.isUpdating = false;
        this.isRemoving = false;
        this.isFinished = false;
        this.initHints();
        this.resetCombos();
        this.resetPoints(bResetPlayedTime);
        this.initMarkedTiles();
        for (int i = 0; i < this.tilesCount; ++i) {
            this.showed[i] = 1;
            this.removed[i] = -128;
        }
        this.removedCursor = 0;
        this.calculateMaxLayer();
        if (this.gameMode == 3) {
            this.loadTutorialTiles();
        } else {
            this.setTiles();
        }
    }

    public void initInfo() {
        preparedTextInfo = new PreparedText(this.fontMainWhiteBlackBg);
    }

    public void updateInfo() {
        if (this.gameMode == 3) {
            this.updateTextTutorial();
        } else {
            int x = this.xDialog + (this.swDialog >> 1);
            int y = this.yDialog + (this.sprDialog.getHeight() >> 1);
            this.rectTextInfo = new Rectangle(x, y, this.iDialogMaxWidth, this.iDialogMaxHeight);
            if (this.isFinished) {
                int rand = RandomNum.getRandomUInt(10);
                switch (rand) {
                    case 0: {
                        preparedTextInfo.prepareText(Resources.resTexts[0].getHashedString(117), this.rectTextInfo.width);
                        break;
                    }
                    case 1: {
                        preparedTextInfo.prepareText(Resources.resTexts[0].getHashedString(118), this.rectTextInfo.width);
                        break;
                    }
                    case 2: {
                        preparedTextInfo.prepareText(Resources.resTexts[0].getHashedString(119), this.rectTextInfo.width);
                        break;
                    }
                    case 3: {
                        preparedTextInfo.prepareText(Resources.resTexts[0].getHashedString(120), this.rectTextInfo.width);
                        break;
                    }
                    case 4: {
                        preparedTextInfo.prepareText(Resources.resTexts[0].getHashedString(121), this.rectTextInfo.width);
                        break;
                    }
                    case 5: {
                        preparedTextInfo.prepareText(Resources.resTexts[0].getHashedString(122), this.rectTextInfo.width);
                        break;
                    }
                    case 6: {
                        preparedTextInfo.prepareText(Resources.resTexts[0].getHashedString(123), this.rectTextInfo.width);
                        break;
                    }
                    case 7: {
                        preparedTextInfo.prepareText(Resources.resTexts[0].getHashedString(124), this.rectTextInfo.width);
                        break;
                    }
                    case 8: {
                        preparedTextInfo.prepareText(Resources.resTexts[0].getHashedString(125), this.rectTextInfo.width);
                        break;
                    }
                    default: {
                        preparedTextInfo.prepareText(Resources.resTexts[0].getHashedString(126), this.rectTextInfo.width);
                        break;
                    }
                }
            } else if (!this.isNoSolution) {
                preparedTextInfo.prepareText(Resources.resTexts[0].getHashedString(111), this.rectTextInfo.width);
            } else {
                preparedTextInfo.prepareText(Resources.resTexts[0].getHashedString(113), this.rectTextInfo.width);
            }
        }
    }

    public void calculateControls() {
        int iControlsX = this.sprButton.getWidth() << 1;
        int iControlsY = MainCanvas.HEIGHT - (this.sprButton.getHeight() << 1);
        if (MainCanvas.HEIGHT < 480) {
            iControlsY = MainCanvas.HEIGHT - this.sprButton.getHeight() - (this.sprButton.getHeight() >> 2);
            iControlsX = this.sprButton.getWidth() >> 2;
        }
        this.rectControls = new Rectangle[3];
        this.rectControls[0] = new Rectangle(iControlsX, iControlsY, this.sprButton.getWidth(), this.sprButton.getHeight());
        this.rectControls[1] = new Rectangle((MainCanvas.WIDTH >> 1) - (this.sprButton.getWidth() >> 1), iControlsY, this.sprButton.getWidth(), this.sprButton.getHeight());
        this.rectControls[2] = new Rectangle(MainCanvas.WIDTH - this.sprButton.getWidth() - iControlsX, iControlsY, this.sprButton.getWidth(), this.sprButton.getHeight());
    }

    public void loadLevel() {
        this.tilesCount = 0;
        if (this.gameMode == 3) {
            this.tilesCount = 26;
            this.layers = new byte[this.tilesCount];
            this.posX = new byte[this.tilesCount];
            this.posY = new byte[this.tilesCount];
            for (int i = 0; i < this.tilesCount; ++i) {
                this.layers[i] = LevelTutorial.layers[i];
                this.posX[i] = LevelTutorial.posX[i];
                this.posY[i] = LevelTutorial.posY[i];
            }
        } else {
            LevelsReader fr = new LevelsReader();
            try {
                fr.readLevel(this.gameMode, this.level);
                this.tilesCount = fr.tilesCount;
                this.layers = new byte[this.tilesCount];
                this.posX = new byte[this.tilesCount];
                this.posY = new byte[this.tilesCount];
                for (int i = 0; i < this.tilesCount; ++i) {
                    this.layers[i] = fr.layers[i];
                    this.posX[i] = fr.posX[i];
                    this.posY[i] = fr.posY[i];
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean loadGame() {
        ++this.loadingCounter;
        boolean isOK = false;
        switch (this.gameMode) {
            case 0: {
                int i;
                SavedItem savedEasyItem = null;
                RMSObjects.createRMSConnect(1);
                if (!RMSObjects.rmsConnects[1].isExist()) {
                    RMSObjects.rmsConnects[1].create();
                }
                if (RMSObjects.rmsConnects[1].load()) {
                    savedEasyItem = RMSObjects.savedEasy.getSavedGame();
                }
                RMSObjects.freeRMSConnect(1);
                if (savedEasyItem == null) break;
                this.level = savedEasyItem.level;
                this.matches = savedEasyItem.matches;
                this.points = savedEasyItem.points;
                this.playedTime = savedEasyItem.playedTime;
                this.maxTime = savedEasyItem.maxTime;
                this.removedCursor = savedEasyItem.removedCursor;
                this.tilesCount = savedEasyItem.tilesCount;
                this.screen = savedEasyItem.screen;
                this.combos = savedEasyItem.combos;
                this.comboTime = savedEasyItem.comboTime;
                this.comboMultiplier = savedEasyItem.comboMultiplier;
                this.resultStep = savedEasyItem.resultStep;
                this.score = savedEasyItem.score;
                this.usedUndo = savedEasyItem.usedUndo;
                this.medal = savedEasyItem.medal;
                this.showedMatches = savedEasyItem.showedMatches;
                this.showedUsedUndo = savedEasyItem.showedUsedUndo;
                this.showedTime = savedEasyItem.showedTime;
                this.showedTotalScore = savedEasyItem.showedTotalScore;
                this.showedMedal = savedEasyItem.showedMedal;
                this.tiles = new byte[this.tilesCount];
                this.removed = new int[this.tilesCount];
                this.showed = new byte[this.tilesCount];
                this.markedTiles = new int[2];
                this.markedTilesType = new byte[2];
                this.hints = new int[2];
                for (i = 0; i < this.tilesCount; ++i) {
                    this.tiles[i] = savedEasyItem.tiles[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    this.removed[i] = savedEasyItem.removed[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    this.showed[i] = savedEasyItem.showed[i];
                }
                for (i = 0; i < 2; ++i) {
                    this.markedTiles[i] = savedEasyItem.markedTiles[i];
                }
                for (i = 0; i < 2; ++i) {
                    this.markedTilesType[i] = savedEasyItem.markedTilesType[i];
                }
                for (i = 0; i < 2; ++i) {
                    this.hints[i] = savedEasyItem.hints[i];
                }
                this.isOutOfMoves = savedEasyItem.isOutOfMoves;
                this.isNoSolution = savedEasyItem.isNoSolution;
                this.isHint = savedEasyItem.isHint;
                this.isDialog = savedEasyItem.isDialog;
                this.isFinished = savedEasyItem.isFinished;
                this.bNewRecord = savedEasyItem.bNewRecord;
                this.bNewRecordFlag = savedEasyItem.bNewRecordFlag;
                isOK = true;
                break;
            }
            case 1: {
                int i;
                SavedItem savedMediumItem = null;
                RMSObjects.createRMSConnect(2);
                if (!RMSObjects.rmsConnects[2].isExist()) {
                    RMSObjects.rmsConnects[2].create();
                }
                if (RMSObjects.rmsConnects[2].load()) {
                    savedMediumItem = RMSObjects.savedMedium.getSavedGame();
                }
                RMSObjects.freeRMSConnect(2);
                if (savedMediumItem == null) break;
                this.level = savedMediumItem.level;
                this.matches = savedMediumItem.matches;
                this.points = savedMediumItem.points;
                this.playedTime = savedMediumItem.playedTime;
                this.maxTime = savedMediumItem.maxTime;
                this.removedCursor = savedMediumItem.removedCursor;
                this.tilesCount = savedMediumItem.tilesCount;
                this.screen = savedMediumItem.screen;
                this.combos = savedMediumItem.combos;
                this.comboTime = savedMediumItem.comboTime;
                this.comboMultiplier = savedMediumItem.comboMultiplier;
                this.resultStep = savedMediumItem.resultStep;
                this.score = savedMediumItem.score;
                this.usedUndo = savedMediumItem.usedUndo;
                this.medal = savedMediumItem.medal;
                this.showedMatches = savedMediumItem.showedMatches;
                this.showedUsedUndo = savedMediumItem.showedUsedUndo;
                this.showedTime = savedMediumItem.showedTime;
                this.showedTotalScore = savedMediumItem.showedTotalScore;
                this.showedMedal = savedMediumItem.showedMedal;
                this.tiles = new byte[this.tilesCount];
                this.removed = new int[this.tilesCount];
                this.showed = new byte[this.tilesCount];
                this.markedTiles = new int[2];
                this.markedTilesType = new byte[2];
                this.hints = new int[2];
                for (i = 0; i < this.tilesCount; ++i) {
                    this.tiles[i] = savedMediumItem.tiles[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    this.removed[i] = savedMediumItem.removed[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    this.showed[i] = savedMediumItem.showed[i];
                }
                for (i = 0; i < 2; ++i) {
                    this.markedTiles[i] = savedMediumItem.markedTiles[i];
                }
                for (i = 0; i < 2; ++i) {
                    this.markedTilesType[i] = savedMediumItem.markedTilesType[i];
                }
                for (i = 0; i < 2; ++i) {
                    this.hints[i] = savedMediumItem.hints[i];
                }
                this.isOutOfMoves = savedMediumItem.isOutOfMoves;
                this.isNoSolution = savedMediumItem.isNoSolution;
                this.isHint = savedMediumItem.isHint;
                this.isDialog = savedMediumItem.isDialog;
                this.isFinished = savedMediumItem.isFinished;
                this.bNewRecord = savedMediumItem.bNewRecord;
                this.bNewRecordFlag = savedMediumItem.bNewRecordFlag;
                isOK = true;
                break;
            }
            case 2: {
                int i;
                SavedItem savedHardItem = null;
                RMSObjects.createRMSConnect(3);
                if (!RMSObjects.rmsConnects[3].isExist()) {
                    RMSObjects.rmsConnects[3].create();
                }
                if (RMSObjects.rmsConnects[3].load()) {
                    savedHardItem = RMSObjects.savedHard.getSavedGame();
                }
                RMSObjects.freeRMSConnect(3);
                if (savedHardItem == null) break;
                this.level = savedHardItem.level;
                this.matches = savedHardItem.matches;
                this.points = savedHardItem.points;
                this.playedTime = savedHardItem.playedTime;
                this.maxTime = savedHardItem.maxTime;
                this.removedCursor = savedHardItem.removedCursor;
                this.tilesCount = savedHardItem.tilesCount;
                this.screen = savedHardItem.screen;
                this.combos = savedHardItem.combos;
                this.comboTime = savedHardItem.comboTime;
                this.comboMultiplier = savedHardItem.comboMultiplier;
                this.resultStep = savedHardItem.resultStep;
                this.score = savedHardItem.score;
                this.usedUndo = savedHardItem.usedUndo;
                this.medal = savedHardItem.medal;
                this.showedMatches = savedHardItem.showedMatches;
                this.showedUsedUndo = savedHardItem.showedUsedUndo;
                this.showedTime = savedHardItem.showedTime;
                this.showedTotalScore = savedHardItem.showedTotalScore;
                this.showedMedal = savedHardItem.showedMedal;
                this.tiles = new byte[this.tilesCount];
                this.removed = new int[this.tilesCount];
                this.showed = new byte[this.tilesCount];
                this.markedTiles = new int[2];
                this.markedTilesType = new byte[2];
                this.hints = new int[2];
                for (i = 0; i < this.tilesCount; ++i) {
                    this.tiles[i] = savedHardItem.tiles[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    this.removed[i] = savedHardItem.removed[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    this.showed[i] = savedHardItem.showed[i];
                }
                for (i = 0; i < 2; ++i) {
                    this.markedTiles[i] = savedHardItem.markedTiles[i];
                }
                for (i = 0; i < 2; ++i) {
                    this.markedTilesType[i] = savedHardItem.markedTilesType[i];
                }
                for (i = 0; i < 2; ++i) {
                    this.hints[i] = savedHardItem.hints[i];
                }
                this.isOutOfMoves = savedHardItem.isOutOfMoves;
                this.isNoSolution = savedHardItem.isNoSolution;
                this.isHint = savedHardItem.isHint;
                this.isDialog = savedHardItem.isDialog;
                this.isFinished = savedHardItem.isFinished;
                this.bNewRecord = savedHardItem.bNewRecord;
                this.bNewRecordFlag = savedHardItem.bNewRecordFlag;
                isOK = true;
                break;
            }
            case 3: {
                int i;
                SavedTutorialItem savedTutorialItem = null;
                RMSObjects.createRMSConnect(4);
                if (!RMSObjects.rmsConnects[4].isExist()) {
                    RMSObjects.rmsConnects[4].create();
                }
                if (RMSObjects.rmsConnects[4].load()) {
                    savedTutorialItem = RMSObjects.savedTutorial.getSavedTutorial();
                }
                RMSObjects.freeRMSConnect(4);
                if (savedTutorialItem == null) break;
                this.tutorialLayer = savedTutorialItem.tutorialLayer;
                this.tutorialDialog = savedTutorialItem.tutorialDialog;
                this.tutorialCounter = savedTutorialItem.tutorialCounter;
                this.matches = savedTutorialItem.matches;
                this.playedTime = savedTutorialItem.playedTime;
                this.removedCursor = savedTutorialItem.removedCursor;
                this.tilesCount = savedTutorialItem.tilesCount;
                this.screen = savedTutorialItem.screen;
                this.combos = savedTutorialItem.combos;
                this.comboTime = savedTutorialItem.comboTime;
                this.comboMultiplier = savedTutorialItem.comboMultiplier;
                this.tiles = new byte[this.tilesCount];
                this.removed = new int[this.tilesCount];
                this.showed = new byte[this.tilesCount];
                this.markedTiles = new int[2];
                this.markedTilesType = new byte[2];
                this.hints = new int[2];
                for (i = 0; i < this.tilesCount; ++i) {
                    this.tiles[i] = savedTutorialItem.tiles[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    this.removed[i] = savedTutorialItem.removed[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    this.showed[i] = savedTutorialItem.showed[i];
                }
                for (i = 0; i < 2; ++i) {
                    this.markedTiles[i] = savedTutorialItem.markedTiles[i];
                }
                for (i = 0; i < 2; ++i) {
                    this.markedTilesType[i] = savedTutorialItem.markedTilesType[i];
                }
                for (i = 0; i < 2; ++i) {
                    this.hints[i] = savedTutorialItem.hints[i];
                }
                this.isHint = savedTutorialItem.isHint;
                this.isDialog = savedTutorialItem.isDialog;
                this.isFinished = savedTutorialItem.isFinished;
                isOK = true;
                break;
            }
        }
        --this.loadingCounter;
        if (isOK) {
            System.out.println("GAME LOADED");
            return true;
        }
        System.out.println("GAME NOT LOADED");
        return false;
    }

    public void saveGame() {
        ++this.loadingCounter;
        switch (this.gameMode) {
            case 0: {
                int i;
                SavedItem savedEasyItem = new SavedItem();
                savedEasyItem.level = this.level;
                savedEasyItem.matches = this.matches;
                savedEasyItem.points = this.points;
                savedEasyItem.playedTime = this.playedTime;
                savedEasyItem.maxTime = this.maxTime;
                savedEasyItem.removedCursor = this.removedCursor;
                savedEasyItem.tilesCount = this.tilesCount;
                savedEasyItem.screen = this.screen;
                savedEasyItem.combos = this.combos;
                savedEasyItem.comboTime = this.comboTime;
                savedEasyItem.comboMultiplier = this.comboMultiplier;
                savedEasyItem.resultStep = this.resultStep;
                savedEasyItem.score = this.score;
                savedEasyItem.usedUndo = this.usedUndo;
                savedEasyItem.medal = this.medal;
                savedEasyItem.showedMatches = this.showedMatches;
                savedEasyItem.showedUsedUndo = this.showedUsedUndo;
                savedEasyItem.showedTime = this.showedTime;
                savedEasyItem.showedTotalScore = this.showedTotalScore;
                savedEasyItem.showedMedal = this.showedMedal;
                savedEasyItem.tiles = new byte[this.tilesCount];
                savedEasyItem.removed = new int[this.tilesCount];
                savedEasyItem.showed = new byte[this.tilesCount];
                savedEasyItem.markedTiles = new int[2];
                savedEasyItem.markedTilesType = new byte[2];
                savedEasyItem.hints = new int[2];
                for (i = 0; i < this.tilesCount; ++i) {
                    savedEasyItem.tiles[i] = this.tiles[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    savedEasyItem.removed[i] = this.removed[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    savedEasyItem.showed[i] = this.showed[i];
                }
                for (i = 0; i < 2; ++i) {
                    savedEasyItem.markedTiles[i] = this.markedTiles[i];
                }
                for (i = 0; i < 2; ++i) {
                    savedEasyItem.markedTilesType[i] = this.markedTilesType[i];
                }
                for (i = 0; i < 2; ++i) {
                    savedEasyItem.hints[i] = this.hints[i];
                }
                savedEasyItem.isOutOfMoves = this.isOutOfMoves;
                savedEasyItem.isNoSolution = this.isNoSolution;
                savedEasyItem.isHint = this.isHint;
                savedEasyItem.isDialog = this.isDialog;
                savedEasyItem.isFinished = this.isFinished;
                savedEasyItem.bNewRecord = this.bNewRecord;
                savedEasyItem.bNewRecordFlag = this.bNewRecordFlag;
                RMSObjects.createRMSConnect(1);
                if (!RMSObjects.rmsConnects[1].isExist()) {
                    RMSObjects.rmsConnects[1].create();
                }
                RMSObjects.savedEasy.saveGame(savedEasyItem);
                RMSObjects.rmsConnects[1].save();
                RMSObjects.freeRMSConnect(1);
                break;
            }
            case 1: {
                int i;
                SavedItem savedMediumItem = new SavedItem();
                savedMediumItem.level = this.level;
                savedMediumItem.matches = this.matches;
                savedMediumItem.points = this.points;
                savedMediumItem.playedTime = this.playedTime;
                savedMediumItem.maxTime = this.maxTime;
                savedMediumItem.removedCursor = this.removedCursor;
                savedMediumItem.tilesCount = this.tilesCount;
                savedMediumItem.screen = this.screen;
                savedMediumItem.combos = this.combos;
                savedMediumItem.comboTime = this.comboTime;
                savedMediumItem.comboMultiplier = this.comboMultiplier;
                savedMediumItem.resultStep = this.resultStep;
                savedMediumItem.score = this.score;
                savedMediumItem.usedUndo = this.usedUndo;
                savedMediumItem.medal = this.medal;
                savedMediumItem.showedMatches = this.showedMatches;
                savedMediumItem.showedUsedUndo = this.showedUsedUndo;
                savedMediumItem.showedTime = this.showedTime;
                savedMediumItem.showedTotalScore = this.showedTotalScore;
                savedMediumItem.showedMedal = this.showedMedal;
                savedMediumItem.tiles = new byte[this.tilesCount];
                savedMediumItem.removed = new int[this.tilesCount];
                savedMediumItem.showed = new byte[this.tilesCount];
                savedMediumItem.markedTiles = new int[2];
                savedMediumItem.markedTilesType = new byte[2];
                savedMediumItem.hints = new int[2];
                for (i = 0; i < this.tilesCount; ++i) {
                    savedMediumItem.tiles[i] = this.tiles[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    savedMediumItem.removed[i] = this.removed[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    savedMediumItem.showed[i] = this.showed[i];
                }
                for (i = 0; i < 2; ++i) {
                    savedMediumItem.markedTiles[i] = this.markedTiles[i];
                }
                for (i = 0; i < 2; ++i) {
                    savedMediumItem.markedTilesType[i] = this.markedTilesType[i];
                }
                for (i = 0; i < 2; ++i) {
                    savedMediumItem.hints[i] = this.hints[i];
                }
                savedMediumItem.isOutOfMoves = this.isOutOfMoves;
                savedMediumItem.isNoSolution = this.isNoSolution;
                savedMediumItem.isHint = this.isHint;
                savedMediumItem.isDialog = this.isDialog;
                savedMediumItem.isFinished = this.isFinished;
                savedMediumItem.bNewRecord = this.bNewRecord;
                savedMediumItem.bNewRecordFlag = this.bNewRecordFlag;
                RMSObjects.createRMSConnect(2);
                if (!RMSObjects.rmsConnects[2].isExist()) {
                    RMSObjects.rmsConnects[2].create();
                }
                RMSObjects.savedMedium.saveGame(savedMediumItem);
                RMSObjects.rmsConnects[2].save();
                RMSObjects.freeRMSConnect(2);
                break;
            }
            case 2: {
                int i;
                SavedItem savedHardItem = new SavedItem();
                savedHardItem.level = this.level;
                savedHardItem.matches = this.matches;
                savedHardItem.points = this.points;
                savedHardItem.playedTime = this.playedTime;
                savedHardItem.maxTime = this.maxTime;
                savedHardItem.removedCursor = this.removedCursor;
                savedHardItem.tilesCount = this.tilesCount;
                savedHardItem.screen = this.screen;
                savedHardItem.combos = this.combos;
                savedHardItem.comboTime = this.comboTime;
                savedHardItem.comboMultiplier = this.comboMultiplier;
                savedHardItem.resultStep = this.resultStep;
                savedHardItem.score = this.score;
                savedHardItem.usedUndo = this.usedUndo;
                savedHardItem.medal = this.medal;
                savedHardItem.showedMatches = this.showedMatches;
                savedHardItem.showedUsedUndo = this.showedUsedUndo;
                savedHardItem.showedTime = this.showedTime;
                savedHardItem.showedTotalScore = this.showedTotalScore;
                savedHardItem.showedMedal = this.showedMedal;
                savedHardItem.tiles = new byte[this.tilesCount];
                savedHardItem.removed = new int[this.tilesCount];
                savedHardItem.showed = new byte[this.tilesCount];
                savedHardItem.markedTiles = new int[2];
                savedHardItem.markedTilesType = new byte[2];
                savedHardItem.hints = new int[2];
                for (i = 0; i < this.tilesCount; ++i) {
                    savedHardItem.tiles[i] = this.tiles[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    savedHardItem.removed[i] = this.removed[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    savedHardItem.showed[i] = this.showed[i];
                }
                for (i = 0; i < 2; ++i) {
                    savedHardItem.markedTiles[i] = this.markedTiles[i];
                }
                for (i = 0; i < 2; ++i) {
                    savedHardItem.markedTilesType[i] = this.markedTilesType[i];
                }
                for (i = 0; i < 2; ++i) {
                    savedHardItem.hints[i] = this.hints[i];
                }
                savedHardItem.isOutOfMoves = this.isOutOfMoves;
                savedHardItem.isNoSolution = this.isNoSolution;
                savedHardItem.isHint = this.isHint;
                savedHardItem.isDialog = this.isDialog;
                savedHardItem.isFinished = this.isFinished;
                savedHardItem.bNewRecord = this.bNewRecord;
                savedHardItem.bNewRecordFlag = this.bNewRecordFlag;
                RMSObjects.createRMSConnect(3);
                if (!RMSObjects.rmsConnects[3].isExist()) {
                    RMSObjects.rmsConnects[3].create();
                }
                RMSObjects.savedHard.saveGame(savedHardItem);
                RMSObjects.rmsConnects[3].save();
                RMSObjects.freeRMSConnect(3);
                break;
            }
            case 3: {
                int i;
                SavedTutorialItem savedTutorialItem = new SavedTutorialItem();
                savedTutorialItem.tutorialLayer = this.tutorialLayer;
                savedTutorialItem.tutorialDialog = this.tutorialDialog;
                savedTutorialItem.tutorialCounter = this.tutorialCounter;
                savedTutorialItem.matches = this.matches;
                savedTutorialItem.playedTime = this.playedTime;
                savedTutorialItem.removedCursor = this.removedCursor;
                savedTutorialItem.tilesCount = this.tilesCount;
                savedTutorialItem.screen = this.screen;
                savedTutorialItem.combos = this.combos;
                savedTutorialItem.comboTime = this.comboTime;
                savedTutorialItem.comboMultiplier = this.comboMultiplier;
                savedTutorialItem.tiles = new byte[this.tilesCount];
                savedTutorialItem.removed = new int[this.tilesCount];
                savedTutorialItem.showed = new byte[this.tilesCount];
                savedTutorialItem.markedTiles = new int[2];
                savedTutorialItem.markedTilesType = new byte[2];
                savedTutorialItem.hints = new int[2];
                for (i = 0; i < this.tilesCount; ++i) {
                    savedTutorialItem.tiles[i] = this.tiles[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    savedTutorialItem.removed[i] = this.removed[i];
                }
                for (i = 0; i < this.tilesCount; ++i) {
                    savedTutorialItem.showed[i] = this.showed[i];
                }
                for (i = 0; i < 2; ++i) {
                    savedTutorialItem.markedTiles[i] = this.markedTiles[i];
                }
                for (i = 0; i < 2; ++i) {
                    savedTutorialItem.markedTilesType[i] = this.markedTilesType[i];
                }
                for (i = 0; i < 2; ++i) {
                    savedTutorialItem.hints[i] = this.hints[i];
                }
                savedTutorialItem.isHint = this.isHint;
                savedTutorialItem.isDialog = this.isDialog;
                savedTutorialItem.isFinished = this.isFinished;
                RMSObjects.createRMSConnect(4);
                if (!RMSObjects.rmsConnects[4].isExist()) {
                    RMSObjects.rmsConnects[4].create();
                }
                RMSObjects.savedTutorial.saveTutorial(savedTutorialItem);
                RMSObjects.rmsConnects[4].save();
                RMSObjects.freeRMSConnect(4);
                break;
            }
        }
        System.out.println("GAME SAVED");
        --this.loadingCounter;
    }

    public void deleteSavedGame() {
        ++this.loadingCounter;
        switch (this.gameMode) {
            case 0: {
                RMSObjects.createRMSConnect(1);
                RMSObjects.rmsConnects[1].delete();
                RMSObjects.freeRMSConnect(1);
                break;
            }
            case 1: {
                RMSObjects.createRMSConnect(2);
                RMSObjects.rmsConnects[2].delete();
                RMSObjects.freeRMSConnect(2);
                break;
            }
            case 2: {
                RMSObjects.createRMSConnect(3);
                RMSObjects.rmsConnects[3].delete();
                RMSObjects.freeRMSConnect(3);
                break;
            }
            case 3: {
                RMSObjects.createRMSConnect(4);
                RMSObjects.rmsConnects[4].delete();
                RMSObjects.freeRMSConnect(4);
                break;
            }
        }
        System.out.println("SAVED GAME DELETED");
        --this.loadingCounter;
    }

    public void calculateTexts() {
        int iY;
        int iShiftY = 0;
        int iShiftY2 = 0;
        if (MainCanvas.WIDTH < 320 || MainCanvas.HEIGHT < 480) {
            if (MainCanvas.WIDTH >= 176 && MainCanvas.HEIGHT >= 220) {
                iShiftY = this.fontMainWhite.getHeight() >> 1;
            } else {
                iShiftY = this.fontMainWhite.getHeight();
                iShiftY2 = this.fontMainWhite.getHeight() >> 2;
            }
        }
        int iTotalHeight = this.fontMainWhite.getHeight() * 6 + (this.fontMainWhite.getHeight() >> 2) + this.sprStarsDialog.getHeight() - iShiftY;
        this.resultMatchesY = iY = this.iDialogCenterY - (iTotalHeight >> 1) + this.sprTopBg.getHeight();
        this.resultUsedUndoY = iY += this.fontMainWhite.getHeight();
        this.resultTimeY = iY += this.fontMainWhite.getHeight();
        iY += this.fontMainWhite.getHeight();
        this.resultTotalScoreY = (iY += this.fontMainWhite.getHeight() >> 1) - (iShiftY2 << 1);
        this.resultMedalY = (iY += this.fontMainWhite.getHeight() + (this.fontMainWhite.getHeight() >> 1) - (iShiftY >> 1)) - (iShiftY2 << 1);
        this.resultRecordY = (iY += this.sprStarsDialog.getHeight() + (this.fontMainWhite.getHeight() >> 2) - (iShiftY >> 1)) - iShiftY2;
        if (this.gameMode == 2) {
            this.resultMatchesY += this.fontMainWhite.getHeight() >> 1;
            this.resultTimeY -= this.fontMainWhite.getHeight() >> 1;
        }
    }

    public void resultEnd() {
        if (this.score > this.bestScore) {
            this.saveScore();
        }
        if (this.medal > this.bestMedal) {
            this.saveMedal();
        }
        this.unlockNextLevel();
        this.deleteSavedGame();
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 6, this.gameMode, this.level + 1));
        this.mainCanvas.repaint();
    }

    public void nextResultStep() {
        switch (this.resultStep) {
            case 0: {
                this.score = this.points;
                this.showedMatches = 0;
                this.showedUsedUndo = 0;
                this.showedTime = 0;
                this.showedTotalScore = 0;
                this.showedMedal = this.bestMedal > 0 ? this.bestMedal : 0;
                this.bNewRecord = false;
                this.bNewRecordFlag = false;
                this.resultStep = 1;
                this.isTotalCounting = true;
                break;
            }
            case 1: {
                if (this.gameMode == 2) {
                    this.resultStep = 4;
                    this.showedTotalScore = this.score;
                    break;
                }
                this.resultStep = 2;
                this.showedTotalScore = this.score;
                break;
            }
            case 2: {
                this.resultStep = 3;
                this.isTotalCounting = true;
                break;
            }
            case 3: {
                this.resultStep = 4;
                this.score -= this.usedUndo * 200;
                if (this.score < 0) {
                    this.score = 0;
                }
                this.showedTotalScore = this.score;
                break;
            }
            case 4: {
                this.resultStep = 5;
                this.isTotalCounting = true;
                break;
            }
            case 5: {
                this.medal = this.playedTime <= this.timeGold ? 3 : (this.playedTime <= this.timeSilver ? 2 : (this.playedTime <= this.timeBronze ? 1 : 0));
                if (this.medal > this.bestMedal) {
                    this.bNewRecordFlag = true;
                    this.resultStep = 6;
                    this.resultMedalCounter = 250;
                    this.isTotalCounting = true;
                    break;
                }
                if (this.score > this.bestScore) {
                    this.resultStep = 7;
                    this.bNewRecord = true;
                    this.initParticlesNewRecord();
                    break;
                }
                this.resultStep = 8;
                this.initParticlesFinish();
                break;
            }
            case 6: {
                if (this.bNewRecordFlag || this.score > this.bestScore) {
                    this.resultStep = 7;
                    this.bNewRecord = true;
                    this.initParticlesNewRecord();
                    break;
                }
                this.resultStep = 8;
                this.initParticlesFinish();
                break;
            }
            case 7: {
                this.resultStep = 8;
                break;
            }
            case 8: {
                break;
            }
        }
    }

    public void next() {
        if (this.isTotalCounting) {
            this.isTotalCounting = false;
            switch (this.resultStep) {
                case 1: {
                    this.showedMatches = this.matches;
                    break;
                }
                case 3: {
                    this.showedUsedUndo = this.usedUndo;
                    break;
                }
                case 5: {
                    this.showedTime = this.playedTime;
                    break;
                }
                case 6: {
                    this.showedMedal = this.medal;
                    this.initParticlesMedal();
                    break;
                }
            }
        } else if (this.resultStep != 8) {
            this.nextResultStep();
        } else {
            this.activatePressedControl(0);
            this.bPressedOk = true;
        }
    }

    public void updateTotal(long lTick) {
        int step = 0;
        switch (this.resultStep) {
            case 1: {
                if (this.showedMatches < this.matches) {
                    step = this.matches / 10;
                    if (step < 1) {
                        step = 1;
                    }
                    this.showedMatches += step;
                }
                if (this.showedMatches < this.matches) break;
                this.showedMatches = this.matches;
                this.initNextResultStep();
                this.isTotalCounting = false;
                break;
            }
            case 3: {
                if (this.showedUsedUndo < this.usedUndo) {
                    step = this.usedUndo / 10;
                    if (step < 1) {
                        step = 1;
                    }
                    this.showedUsedUndo += step;
                }
                if (this.showedUsedUndo < this.usedUndo) break;
                this.showedUsedUndo = this.usedUndo;
                this.initNextResultStep();
                this.isTotalCounting = false;
                break;
            }
            case 5: {
                if (this.showedTime < this.playedTime) {
                    step = this.playedTime / 10;
                    if (step < 1000) {
                        step = 1000;
                    }
                    this.showedTime += step;
                }
                if (this.showedTime < this.playedTime) break;
                this.showedTime = this.playedTime;
                this.initNextResultStep();
                this.isTotalCounting = false;
                break;
            }
            case 6: {
                if (this.showedMedal < this.medal) {
                    if (this.resultMedalCounter <= 0) break;
                    this.resultMedalCounter = (int)((long)this.resultMedalCounter - lTick);
                    if (this.resultMedalCounter > 0) break;
                    ++this.showedMedal;
                    this.initParticlesMedal();
                    if (this.showedMedal < this.medal) {
                        this.resultMedalCounter = 250;
                        break;
                    }
                    this.showedMedal = this.medal;
                    this.initNextResultStep();
                    this.isTotalCounting = false;
                    break;
                }
                this.showedMedal = this.medal;
                this.initNextResultStep();
                this.isTotalCounting = false;
                break;
            }
        }
    }

    public void saveScore() {
        switch (this.gameMode) {
            case 0: {
                RMSObjects.createRMSConnect(5);
                if (!RMSObjects.rmsConnects[5].isExist()) {
                    RMSObjects.rmsConnects[5].create();
                }
                RMSObjects.scoresEasy.setScore(this.level, this.score);
                RMSObjects.rmsConnects[5].save();
                RMSObjects.freeRMSConnect(5);
                break;
            }
            case 1: {
                RMSObjects.createRMSConnect(6);
                if (!RMSObjects.rmsConnects[6].isExist()) {
                    RMSObjects.rmsConnects[6].create();
                }
                RMSObjects.scoresMedium.setScore(this.level, this.score);
                RMSObjects.rmsConnects[6].save();
                RMSObjects.freeRMSConnect(6);
                break;
            }
            case 2: {
                RMSObjects.createRMSConnect(7);
                if (!RMSObjects.rmsConnects[7].isExist()) {
                    RMSObjects.rmsConnects[7].create();
                }
                RMSObjects.scoresHard.setScore(this.level, this.score);
                RMSObjects.rmsConnects[7].save();
                RMSObjects.freeRMSConnect(7);
                break;
            }
        }
        System.out.println("SAVED NEW BEST SCORE");
    }

    public void saveMedal() {
        switch (this.gameMode) {
            case 0: {
                RMSObjects.createRMSConnect(5);
                if (!RMSObjects.rmsConnects[5].isExist()) {
                    RMSObjects.rmsConnects[5].create();
                }
                RMSObjects.scoresEasy.setMedal(this.level, this.medal);
                RMSObjects.rmsConnects[5].save();
                RMSObjects.freeRMSConnect(5);
                break;
            }
            case 1: {
                RMSObjects.createRMSConnect(6);
                if (!RMSObjects.rmsConnects[6].isExist()) {
                    RMSObjects.rmsConnects[6].create();
                }
                RMSObjects.scoresMedium.setMedal(this.level, this.medal);
                RMSObjects.rmsConnects[6].save();
                RMSObjects.freeRMSConnect(6);
                break;
            }
            case 2: {
                RMSObjects.createRMSConnect(7);
                if (!RMSObjects.rmsConnects[7].isExist()) {
                    RMSObjects.rmsConnects[7].create();
                }
                RMSObjects.scoresHard.setMedal(this.level, this.medal);
                RMSObjects.rmsConnects[7].save();
                RMSObjects.freeRMSConnect(7);
                break;
            }
        }
        System.out.println("SAVED NEW BEST SCORE");
    }

    public void unlockNextLevel() {
        ++this.loadingCounter;
        switch (this.gameMode) {
            case 0: {
                RMSObjects.createRMSConnect(5);
                if (!RMSObjects.rmsConnects[5].isExist()) {
                    RMSObjects.rmsConnects[5].create();
                }
                if (this.level < 47 && RMSObjects.scoresEasy.getLocked(this.level + 1)) {
                    RMSObjects.scoresEasy.setUnlocked(this.level + 1);
                    System.out.println("UNLOCKED NEW LEVEL");
                }
                RMSObjects.rmsConnects[5].save();
                RMSObjects.freeRMSConnect(5);
                break;
            }
            case 1: {
                RMSObjects.createRMSConnect(6);
                if (!RMSObjects.rmsConnects[6].isExist()) {
                    RMSObjects.rmsConnects[6].create();
                }
                if (this.level < 47 && RMSObjects.scoresMedium.getLocked(this.level + 1)) {
                    RMSObjects.scoresMedium.setUnlocked(this.level + 1);
                    System.out.println("UNLOCKED NEW LEVEL");
                }
                RMSObjects.rmsConnects[6].save();
                RMSObjects.freeRMSConnect(6);
                break;
            }
            case 2: {
                RMSObjects.createRMSConnect(7);
                if (!RMSObjects.rmsConnects[7].isExist()) {
                    RMSObjects.rmsConnects[7].create();
                }
                if (this.level < 47 && RMSObjects.scoresHard.getLocked(this.level + 1)) {
                    RMSObjects.scoresHard.setUnlocked(this.level + 1);
                    System.out.println("UNLOCKED NEW LEVEL");
                }
                RMSObjects.rmsConnects[7].save();
                RMSObjects.freeRMSConnect(7);
                break;
            }
        }
        --this.loadingCounter;
    }

    public void loadBestScore() {
        ++this.loadingCounter;
        this.bestScore = 0;
        this.bestMedal = 0;
        switch (this.gameMode) {
            case 0: {
                RMSObjects.createRMSConnect(5);
                if (!RMSObjects.rmsConnects[5].isExist()) {
                    RMSObjects.rmsConnects[5].create();
                }
                if (RMSObjects.rmsConnects[5].load()) {
                    this.bestScore = RMSObjects.scoresEasy.getScore(this.level);
                    this.bestMedal = RMSObjects.scoresEasy.getMedal(this.level);
                }
                RMSObjects.freeRMSConnect(5);
                break;
            }
            case 1: {
                RMSObjects.createRMSConnect(6);
                if (!RMSObjects.rmsConnects[6].isExist()) {
                    RMSObjects.rmsConnects[6].create();
                }
                if (RMSObjects.rmsConnects[6].load()) {
                    this.bestScore = RMSObjects.scoresMedium.getScore(this.level);
                    this.bestMedal = RMSObjects.scoresMedium.getMedal(this.level);
                }
                RMSObjects.freeRMSConnect(6);
                break;
            }
            case 2: {
                RMSObjects.createRMSConnect(7);
                if (!RMSObjects.rmsConnects[7].isExist()) {
                    RMSObjects.rmsConnects[7].create();
                }
                if (RMSObjects.rmsConnects[7].load()) {
                    this.bestScore = RMSObjects.scoresHard.getScore(this.level);
                    this.bestMedal = RMSObjects.scoresHard.getMedal(this.level);
                }
                RMSObjects.freeRMSConnect(7);
                break;
            }
        }
        --this.loadingCounter;
    }

    public void dda(int id) {
        int shift = this.dealingSpeed;
        int deltaX = this.showedPosX[id] - this.pomPosX[id];
        int deltaY = this.showedPosY[id] - this.pomPosY[id];
        int xAdd = 0;
        int yAdd = 0;
        int count = this.hyp(this.pomPosX[id], this.pomPosY[id], this.showedPosX[id], this.showedPosY[id]);
        if (this.pomPosX[id] != this.showedPosX[id] || this.pomPosY[id] != this.showedPosY[id]) {
            xAdd = (deltaX << shift) / count;
            yAdd = (deltaY << shift) / count;
        }
        int n = id;
        this.pomPosX[n] = this.pomPosX[n] + xAdd;
        int n2 = id;
        this.pomPosY[n2] = this.pomPosY[n2] + yAdd;
        if (Math.abs(deltaX) <= Math.abs(xAdd) && Math.abs(deltaY) <= Math.abs(yAdd)) {
            this.pomPosX[id] = this.showedPosX[id];
            this.pomPosY[id] = this.showedPosY[id];
        }
    }

    public int hyp(int x1, int y1, int x2, int y2) {
        if ((x2 -= x1) < 0) {
            x2 = -x2;
        }
        if ((y2 -= y1) < 0) {
            y2 = -y2;
        }
        return x2 + y2 - ((x2 > y2 ? y2 : x2) >> 1);
    }

    private boolean checkLevel() {
        if (this.gameMode == 3) {
            return true;
        }
        this.loading = true;
        boolean check = false;
        int countT = this.tilesCount;
        byte[] showedT = this.showed;
        byte[] stonesT = this.stones;
        int[] positionT = this.tilesOrder;
        byte[] actiT = this.active;
        int counter = 0;
        this.listOfTiles = new int[this.tilesCount][this.tilesCount];
        if (this.tilesCount % 2 == 1) {
            System.out.println("Neparny pocet kamenov...");
            return false;
        }
        int deletedT = 0;
        while (deletedT < this.tilesCount) {
            int randomTwo;
            int randomOne;
            deletedT = 0;
            int[] activeT = new int[this.tilesCount];
            for (int k = 0; k < activeT.length; ++k) {
                activeT[k] = -1;
            }
            int isActive = 0;
            this.setStones();
            for (int count = 0; count < this.tilesCount; ++count) {
                if (this.showed[count] == -128 || this.active[count] != 1 || this.stones[count] != 1) continue;
                activeT[isActive] = this.tilesOrder[count];
                ++isActive;
            }
            if (isActive == 2) {
                randomOne = 0;
                randomTwo = 1;
                for (int j = 0; j < this.tilesOrder.length; ++j) {
                    if (this.tilesOrder[j] == activeT[randomOne] || this.tilesOrder[j] == activeT[randomTwo]) {
                        this.showed[j] = -128;
                        this.listOfTiles[0][counter] = this.tilesOrder[j];
                        ++counter;
                    }
                    if (this.showed[j] != -128) continue;
                    ++deletedT;
                }
                check = true;
                continue;
            }
            if (isActive > 1) {
                randomOne = ScreenGame.getRandomUInt(isActive);
                if (randomOne == (randomTwo = ScreenGame.getRandomUInt(isActive))) {
                    while ((randomTwo = ScreenGame.getRandomUInt(isActive)) == randomOne) {
                    }
                }
                for (int x = 0; x < this.tilesOrder.length; ++x) {
                    if (this.tilesOrder[x] == activeT[randomOne] || this.tilesOrder[x] == activeT[randomTwo]) {
                        this.showed[x] = -128;
                        this.listOfTiles[0][counter] = this.tilesOrder[x];
                        ++counter;
                    }
                    if (this.showed[x] != -128) continue;
                    ++deletedT;
                }
                continue;
            }
            if (isActive != 1) continue;
            System.out.println("je len jeden aktivny kamen... ta daco zle");
            check = false;
            this.tilesCount = countT;
            this.tilesOrder = positionT;
            for (int c = 0; c < this.showed.length; ++c) {
                showedT[c] = 1;
            }
            this.showed = showedT;
            this.stones = stonesT;
            this.active = actiT;
            return check;
        }
        if (check) {
            this.tilesNumber = new int[42];
            this.resetTiles();
            this.setTilesAfterCheckGame();
        }
        System.out.println("CHECK TEST IS ENDED...");
        return check;
    }

    private void setTilesAfterCheckGame() {
        int notSetTile = this.listOfTiles[0].length;
        int notUseTile = 42;
        int counter = 0;
        block4: while (notSetTile > 0) {
            int randomOne = 0;
            if (notUseTile < 5) {
                this.resetTiles();
                notUseTile = 42;
                continue;
            }
            randomOne = ScreenGame.getRandomUInt(42);
            while (true) {
                if (this.tilesNumber[randomOne] != -1) {
                    this.listOfTiles[1][counter] = randomOne;
                    ++counter;
                    --notSetTile;
                    this.tilesNumber[randomOne] = -1;
                    --notUseTile;
                    if (randomOne > 33 && randomOne < 42) {
                        switch (randomOne) {
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: {
                                while (true) {
                                    if (this.tilesNumber[randomOne] != -1) {
                                        this.listOfTiles[1][counter] = randomOne;
                                        ++counter;
                                        --notSetTile;
                                        this.tilesNumber[randomOne] = -1;
                                        --notUseTile;
                                        continue block4;
                                    }
                                    randomOne = ScreenGame.getRandomUInt(32) % 4 + 34;
                                }
                            }
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: {
                                while (true) {
                                    if (this.tilesNumber[randomOne] != -1) {
                                        this.listOfTiles[1][counter] = randomOne;
                                        ++counter;
                                        --notSetTile;
                                        this.tilesNumber[randomOne] = -1;
                                        --notUseTile;
                                        continue block4;
                                    }
                                    randomOne = ScreenGame.getRandomUInt(32) % 4 + 38;
                                }
                            }
                        }
                        continue block4;
                    }
                    this.listOfTiles[1][counter] = randomOne;
                    ++counter;
                    --notSetTile;
                    this.tilesNumber[randomOne] = -1;
                    continue block4;
                }
                randomOne = ScreenGame.getRandomUInt(42);
            }
        }
        this.restart();
        for (int count = 0; count < this.listOfTiles[0].length; ++count) {
            int position = this.listOfTiles[0][count];
            for (int pos = 0; pos < this.tilesOrder.length; ++pos) {
                if (this.tilesOrder[pos] != position) continue;
                this.tiles[pos] = (byte)this.listOfTiles[1][count];
            }
        }
    }

    private void resetTiles() {
        for (int count = 0; count < this.tilesNumber.length; ++count) {
            this.tilesNumber[count] = count;
        }
    }

    static {
        randGenerator = new Random();
    }
}

