/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

public class GameDefs {
    static final byte ID_MODE_EASY = 0;
    static final byte ID_MODE_MEDIUM = 1;
    static final byte ID_MODE_HARD = 2;
    public static final byte TILE_TYPES = 7;
    public static final byte LEVELS = 48;
    public static final byte LEVELS_PAGE = 16;
    public static final byte LEVELS_LINE = 4;
    public static final byte LEVELS_COLUMN = 4;
    public static final byte FRAME_SELECTOR = 4;
    public static final byte MATCHED_PAIRS_TO_COMBO = 2;
    public static final int SCORE_MATCHING_PAIR = 100;
    public static final int UNDO_PENAULTY_SCORE = 200;
    public static final int ONE_TILE_TIME = 6;
    public static final int COMBO_TIME = 8;
    public static final int AUTOHINTING_TIME = 15;
    public static final int MESSAGE_TIME = 9600;
    public static final int WAITING_TIME_RESULT = 200;
    public static final int WAITING_TIME_MEDAL = 250;
    public static final int TILES_X = 10;
    public static final int TILES_Y = 8;
    public static final int HIGHEST_LAYER = 12;
    public static final int DEFAULT_TIME = 60;
    public static final byte[] TILES_COUNT_OF_TYPE = new byte[]{9, 9, 9, 4, 3, 2, 2};
    public static final byte[] ID_COUNTS_FOR_TILE_TYPES = new byte[]{4, 4, 4, 0, 0, 0, 0, 2, 4, 4, 4, 0, 0, 0, 4, 4, 4, 4, 0, 0, 0, 6, 6, 4, 4, 0, 0, 0, 6, 6, 4, 4, 0, 0, 0, 8, 4, 4, 4, 4, 0, 0, 4, 4, 4, 4, 4, 0, 0, 8, 8, 8, 4, 0, 0, 0, 8, 8, 8, 4, 0, 0, 0, 8, 8, 8, 0, 4, 0, 0, 8, 8, 8, 4, 0, 4, 0, 8, 8, 12, 4, 4, 4, 0, 8, 8, 12, 4, 4, 4, 0, 8, 8, 8, 0, 4, 4, 0, 8, 8, 8, 4, 4, 0, 0, 8, 8, 8, 4, 4, 4, 0, 8, 8, 8, 4, 4, 4, 0, 8, 8, 8, 4, 4, 4, 0, 10, 10, 12, 2, 6, 4, 0, 8, 8, 8, 2, 6, 4, 0, 8, 8, 8, 2, 6, 4, 0, 8, 8, 8, 4, 4, 4, 4, 8, 8, 8, 4, 4, 4, 4, 12, 8, 8, 4, 4, 4, 4, 12, 8, 8, 4, 4, 4, 4, 12, 12, 12, 4, 4, 4, 4, 12, 10, 6, 4, 4, 4, 4, 12, 8, 8, 8, 4, 4, 4, 12, 8, 8, 8, 4, 4, 4, 12, 12, 8, 4, 4, 4, 4, 12, 12, 12, 4, 4, 4, 4, 10, 12, 16, 8, 6, 4, 4, 10, 12, 16, 8, 6, 4, 4, 12, 10, 10, 8, 4, 4, 4, 12, 12, 12, 8, 4, 4, 4, 16, 12, 12, 4, 4, 4, 4, 16, 12, 12, 4, 4, 4, 4, 16, 16, 12, 4, 4, 4, 4, 16, 16, 14, 8, 6, 4, 4, 14, 16, 10, 8, 4, 4, 4, 14, 16, 10, 8, 4, 4, 4, 16, 16, 12, 4, 8, 4, 4, 16, 16, 16, 4, 4, 4, 4, 16, 16, 16, 8, 4, 4, 4, 16, 16, 16, 8, 4, 4, 4, 16, 22, 20, 8, 2, 4, 4, 16, 20, 16, 8, 0, 4, 4, 16, 16, 16, 12, 4, 4, 4, 16, 16, 16, 12, 4, 4, 4, 16, 16, 16, 8, 8, 4, 4, 20, 16, 16, 8, 8, 4, 4, 20, 16, 24, 8, 8, 4, 4, 20, 16, 24, 8, 8, 4, 4, 16, 16, 16, 12, 8, 4, 4, 20, 16, 16, 8, 12, 4, 4, 20, 20, 16, 8, 8, 4, 4, 20, 20, 16, 8, 8, 4, 4, 20, 20, 20, 8, 8, 4, 4, 24, 22, 22, 12, 4, 4, 4, 20, 24, 16, 8, 8, 4, 4, 20, 24, 16, 8, 8, 4, 4, 20, 20, 20, 8, 12, 4, 4, 20, 20, 20, 12, 8, 4, 4, 20, 20, 20, 12, 12, 4, 4, 20, 20, 20, 12, 12, 4, 4, 22, 24, 26, 12, 8, 4, 4, 24, 26, 18, 12, 4, 4, 4, 20, 20, 20, 16, 12, 4, 4, 20, 20, 20, 16, 12, 4, 4, 24, 20, 20, 12, 12, 4, 4, 24, 24, 20, 12, 12, 4, 4, 24, 24, 28, 12, 8, 8, 4, 24, 24, 28, 12, 8, 8, 4, 24, 26, 20, 8, 12, 4, 8, 24, 24, 20, 16, 12, 4, 4, 24, 24, 24, 12, 12, 4, 4, 24, 24, 24, 12, 12, 4, 4, 24, 24, 24, 16, 12, 4, 4, 24, 24, 32, 8, 12, 8, 8, 30, 28, 20, 8, 6, 8, 8, 30, 28, 20, 8, 6, 8, 8, 24, 24, 28, 16, 12, 4, 4, 28, 24, 24, 16, 12, 4, 4, 28, 28, 24, 16, 12, 4, 4, 28, 28, 24, 16, 12, 4, 4, 30, 32, 32, 12, 6, 8, 4, 26, 30, 20, 16, 12, 8, 4, 28, 32, 24, 16, 12, 4, 4, 28, 32, 24, 16, 12, 4, 4, 28, 28, 28, 16, 12, 4, 4, 32, 28, 28, 16, 12, 4, 4, 34, 34, 36, 8, 12, 4, 4, 34, 34, 36, 8, 12, 4, 4, 32, 28, 28, 12, 12, 8, 8, 32, 28, 32, 16, 12, 4, 4, 32, 32, 28, 16, 12, 4, 4, 32, 32, 28, 16, 12, 4, 4, 32, 32, 32, 16, 12, 4, 4, 32, 34, 38, 12, 12, 8, 4, 34, 34, 30, 12, 6, 8, 8, 32, 32, 36, 16, 12, 4, 4, 36, 32, 32, 16, 12, 4, 4, 36, 32, 36, 16, 12, 4, 4, 36, 32, 40, 16, 12, 8, 4, 36, 36, 32, 16, 8, 4, 8, 36, 36, 32, 16, 12, 4, 4, 36, 36, 32, 16, 12, 4, 8, 36, 36, 36, 16, 12, 4, 4, 32, 32, 44, 16, 12, 8, 8, 36, 40, 28, 16, 12, 8, 4, 36, 36, 36, 16, 12, 8, 4, 38, 38, 38, 16, 6, 8, 4, 42, 40, 30, 12, 12, 8, 8, 40, 40, 42, 16, 6, 8, 8, 42, 44, 32, 12, 6, 8, 8, 44, 40, 36, 12, 12, 8, 4, 40, 46, 38, 12, 12, 0, 8, 48, 44, 38, 12, 6, 4, 8, 46, 40, 46, 12, 12, 4, 8, 42, 44, 30, 12, 12, 8, 12, 44, 50, 34, 12, 12, 8, 4, 50, 50, 34, 8, 6, 8, 8, 38, 40, 46, 16, 12, 12, 8, 44, 46, 36, 16, 18, 12, 8, 14, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 0, 34, 0, 0, 0, 0, 0, 0, 44, 0, 0, 0, 0, 0, 0, 50, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 58, 0, 0, 0, 0, 0, 0, 80, 0, 0, 0, 0, 0, 0, 82, 0, 0, 0, 0, 0, 0, 88, 0, 0, 0, 0, 0, 0, 98, 0, 0, 0, 0, 0, 0, 98, 0, 0, 0, 0, 0, 0, 102, 0, 0, 0, 0, 0, 0, 102, 0, 0, 0, 0, 0, 0, 106, 0, 0, 0, 0, 0, 0, 114, 0, 0, 0, 0, 0, 0, 118, 0, 0, 0, 0, 0, 0, 126, 0, 0, 0, 0, 0, 0, 100, 28, 0, 0, 0, 0, 0, 100, 32, 0, 0, 0, 0, 0, 100, 36, 0, 0, 0, 0, 0, 100, 38, 0, 0, 0, 0, 0, 100, 46, 0, 0, 0, 0, 0, 100, 46, 0, 0, 0, 0, 0, 100, 46, 0, 0, 0, 0, 0, 100, 48, 0, 0, 0, 0, 0, 100, 50, 0, 0, 0, 0, 0, 100, 50, 0, 0, 0, 0, 0, 100, 54, 0, 0, 0, 0, 0, 100, 56, 0, 0, 0, 0, 0, 100, 58, 0, 0, 0, 0, 0, 100, 58, 0, 0, 0, 0, 0, 100, 70, 0, 0, 0, 0, 0, 100, 70, 0, 0, 0, 0, 0, 100, 76, 0, 0, 0, 0, 0, 100, 80, 0, 0, 0, 0, 0, 100, 94, 0, 0, 0, 0, 0, 100, 100, 0, 0, 0, 0, 0, 100, 100, 6, 0, 0, 0, 0, 100, 100, 14, 0, 0, 0, 0, 100, 100, 16, 0, 0, 0, 0, 100, 100, 16, 0, 0, 0, 0, 100, 100, 30, 0, 0, 0, 0, 100, 100, 44, 0, 0, 0, 0, 100, 100, 76, 0, 0, 0, 0, 100, 100, 92, 0, 0, 0, 0, 100, 100, 100, 0, 0, 0, 0};

    public static byte[] getIDCountsForTileTypes(int gameMode, int level) {
        int id = 0;
        switch (gameMode) {
            case 0: {
                id = level;
                break;
            }
            case 1: {
                id = level + 34;
                break;
            }
            case 2: {
                id = level + 60;
                break;
            }
        }
        byte[] pom = new byte[7];
        for (int i = 0; i < 7; ++i) {
            pom[i] = ID_COUNTS_FOR_TILE_TYPES[id * 7 + i];
        }
        return pom;
    }

    public static byte getTilesCountOfType(int tileType) {
        return TILES_COUNT_OF_TYPE[tileType];
    }
}

