/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.saves;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.saves.ScoresItem;

public class Scores
implements RMSHandler {
    private Vector scores = new Vector();

    public int getScore(int level) {
        int score = 0;
        int scoresCount = this.scores.size();
        for (int i = 0; i < scoresCount; ++i) {
            if (((ScoresItem)this.scores.elementAt((int)i)).level != level) continue;
            score = ((ScoresItem)this.scores.elementAt((int)i)).score;
            break;
        }
        return score;
    }

    public int getMedal(int level) {
        int medal = -1;
        int scoresCount = this.scores.size();
        for (int i = 0; i < scoresCount; ++i) {
            if (((ScoresItem)this.scores.elementAt((int)i)).level != level) continue;
            medal = ((ScoresItem)this.scores.elementAt((int)i)).medal;
            break;
        }
        return medal;
    }

    public boolean getLocked(int level) {
        boolean isLocked = true;
        int scoresCount = this.scores.size();
        for (int i = 0; i < scoresCount; ++i) {
            if (((ScoresItem)this.scores.elementAt((int)i)).level != level) continue;
            isLocked = ((ScoresItem)this.scores.elementAt((int)i)).isLocked;
            break;
        }
        return isLocked;
    }

    public void setScore(int level, int score) {
        ScoresItem scoreItem = null;
        int scoresCount = this.scores.size();
        for (int i = 0; i < scoresCount; ++i) {
            if (((ScoresItem)this.scores.elementAt((int)i)).level != level) continue;
            scoreItem = (ScoresItem)this.scores.elementAt(i);
            scoreItem.score = score;
            this.scores.setElementAt(scoreItem, i);
            break;
        }
    }

    public void setMedal(int level, int medal) {
        ScoresItem scoreItem = null;
        int scoresCount = this.scores.size();
        for (int i = 0; i < scoresCount; ++i) {
            if (((ScoresItem)this.scores.elementAt((int)i)).level != level) continue;
            scoreItem = (ScoresItem)this.scores.elementAt(i);
            scoreItem.medal = medal;
            this.scores.setElementAt(scoreItem, i);
            break;
        }
    }

    public void setUnlocked(int level) {
        ScoresItem scoreItem = null;
        int scoresCount = this.scores.size();
        for (int i = 0; i < scoresCount; ++i) {
            if (((ScoresItem)this.scores.elementAt((int)i)).level != level) continue;
            scoreItem = (ScoresItem)this.scores.elementAt(i);
            scoreItem.isLocked = false;
            this.scores.setElementAt(scoreItem, i);
            break;
        }
    }

    public void initScores() {
        this.scores.removeAllElements();
        ScoresItem scoreItem = null;
        int levelsCount = 48;
        int i = 0;
        while (i < levelsCount) {
            scoreItem = new ScoresItem();
            scoreItem.level = i++;
            scoreItem.score = 0;
            scoreItem.medal = -1;
            scoreItem.isLocked = true;
            this.scores.addElement(scoreItem);
        }
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
        this.scores.removeAllElements();
        ScoresItem scoreItem = null;
        int scoresCount = dis.readInt();
        if (scoresCount != 0) {
            for (int i = 0; i < scoresCount; ++i) {
                scoreItem = new ScoresItem();
                scoreItem.level = dis.readInt();
                scoreItem.score = dis.readInt();
                scoreItem.medal = dis.readInt();
                scoreItem.isLocked = dis.readBoolean();
                this.scores.addElement(scoreItem);
            }
        }
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
        int scoresCount = this.scores.size();
        dos.writeInt(scoresCount);
        if (scoresCount != 0) {
            ScoresItem scoreItem = null;
            for (int i = 0; i < scoresCount; ++i) {
                scoreItem = (ScoresItem)this.scores.elementAt(i);
                dos.writeInt(scoreItem.level);
                dos.writeInt(scoreItem.score);
                dos.writeInt(scoreItem.medal);
                dos.writeBoolean(scoreItem.isLocked);
            }
        }
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(0);
    }
}

